/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.ndeftools.Record;

public class MimeRecord
extends Record {
    protected String mimeType;
    private byte[] data;

    public static MimeRecord parse(NdefRecord ndefRecord) {
        String contentType = new String(ndefRecord.getType(), Charset.forName("US_ASCII"));
        return new MimeRecord(contentType, ndefRecord.getPayload());
    }

    public MimeRecord() {
    }

    public MimeRecord(String mimeType, byte[] data) {
        this.mimeType = mimeType;
        this.data = data;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean hasMimeType() {
        return this.mimeType != null;
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasMimeType()) {
            throw new IllegalArgumentException("Expected content type");
        }
        return new NdefRecord(2, this.mimeType.getBytes(Charset.forName("US_ASCII")), this.id != null ? this.id : this.EMPTY, this.data != null ? this.data : this.EMPTY);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeRecord other = (MimeRecord)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return !(this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType));
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public static /* bridge */ /* synthetic */ Record parse(NdefRecord ndefRecord) throws FormatException {
        return MimeRecord.parse(ndefRecord);
    }
}

