/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import java.util.Arrays;
import org.ndeftools.Record;

public class UnsupportedRecord
extends Record {
    private short tnf;
    private byte[] type;
    private byte[] payload;

    public static UnsupportedRecord parse(NdefRecord ndefRecord) {
        return new UnsupportedRecord(ndefRecord.getTnf(), ndefRecord.getType(), ndefRecord.getId(), ndefRecord.getPayload());
    }

    public UnsupportedRecord(short tnf, byte[] type, byte[] id, byte[] payload) {
        this.tnf = tnf;
        this.type = type;
        this.id = id;
        this.payload = payload;
    }

    public UnsupportedRecord(NdefRecord record) {
        this(record.getTnf(), record.getType(), record.getId(), record.getPayload());
    }

    public short getTnf() {
        return this.tnf;
    }

    public void setTnf(short tnf) {
        this.tnf = tnf;
    }

    public byte[] getType() {
        return this.type;
    }

    public void setType(byte[] type) {
        this.type = type;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + this.tnf;
        result = 31 * result + Arrays.hashCode(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsupportedRecord other = (UnsupportedRecord)obj;
        if (!Arrays.equals(this.payload, other.payload)) {
            return false;
        }
        if (this.tnf != other.tnf) {
            return false;
        }
        return Arrays.equals(this.type, other.type);
    }

    @Override
    public NdefRecord getNdefRecord() {
        return new NdefRecord(this.tnf, this.type != null ? this.type : this.EMPTY, this.id != null ? this.id : this.EMPTY, this.payload != null ? this.payload : this.EMPTY);
    }

    public static /* bridge */ /* synthetic */ Record parse(NdefRecord ndefRecord) throws FormatException {
        return UnsupportedRecord.parse(ndefRecord);
    }
}

