/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.nfc.NdefRecord;
import java.nio.charset.Charset;
import java.util.Locale;
import org.ndeftools.Record;

public class TextRecord
extends Record {
    private static final byte LANGUAGE_CODE_MASK = 31;
    private static final short TEXT_ENCODING_MASK = 128;
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16BE");
    private String text;
    private Charset encoding;
    private Locale locale;

    public static TextRecord parseNdefRecord(NdefRecord ndefRecord) {
        byte[] payload = ndefRecord.getPayload();
        int status = payload[0] & 0xFF;
        int languageCodeLength = status & 0x1F;
        String languageCode = new String(payload, 1, languageCodeLength);
        Charset textEncoding = (status & 0x80) != 0 ? UTF16 : UTF8;
        return new TextRecord(new String(payload, 1 + languageCodeLength, payload.length - languageCodeLength - 1, textEncoding), textEncoding, new Locale(languageCode));
    }

    public TextRecord(String key, String text) {
        this(text, UTF8, Locale.getDefault());
        this.setKey(key);
    }

    public TextRecord(String text) {
        this(text, UTF8, Locale.getDefault());
    }

    public TextRecord(String text, Locale locale) {
        this(text, UTF8, locale);
    }

    public TextRecord(String text, Charset encoding, Locale locale) {
        this.encoding = encoding;
        this.text = text;
        this.locale = locale;
        if (!encoding.equals(UTF8) && !encoding.equals(UTF16)) {
            throw new IllegalArgumentException("Expected UTF-8 or UTF-16 encoding, not " + encoding.displayName());
        }
    }

    public TextRecord() {
    }

    public String getText() {
        return this.text;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setEncoding(Charset encoding) {
        if (!encoding.equals(UTF8) && !encoding.equals(UTF16)) {
            throw new IllegalArgumentException("unsupported encoding. only utf8 and utf16 are allowed.");
        }
        this.encoding = encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean hasText() {
        return this.text != null;
    }

    public boolean hasLocale() {
        return this.locale != null;
    }

    public boolean hasEncoding() {
        return this.encoding != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextRecord other = (TextRecord)obj;
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    @Override
    public NdefRecord getNdefRecord() {
        byte status;
        if (!this.hasLocale()) {
            throw new IllegalArgumentException("Expected locale");
        }
        if (!this.hasEncoding()) {
            throw new IllegalArgumentException("Expected encoding");
        }
        if (!this.hasText()) {
            throw new IllegalArgumentException("Expected text");
        }
        byte[] languageData = (String.valueOf(this.locale.getLanguage()) + (this.locale.getCountry() == null || this.locale.getCountry().length() == 0 ? "" : "-" + this.locale.getCountry())).getBytes();
        if (languageData.length > 31) {
            throw new IllegalArgumentException("Expected language code length <= 32 bytes, not " + languageData.length + " bytes");
        }
        byte[] textData = this.text.getBytes(this.encoding);
        byte[] payload = new byte[1 + languageData.length + textData.length];
        payload[0] = status = (byte)(languageData.length | (UTF16.equals(this.encoding) ? 128 : 0));
        System.arraycopy(languageData, 0, payload, 1, languageData.length);
        System.arraycopy(textData, 0, payload, 1 + languageData.length, textData.length);
        return new NdefRecord(1, NdefRecord.RTD_TEXT, this.id != null ? this.id : this.EMPTY, payload);
    }
}

