/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown.handover;

import android.nfc.NdefRecord;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.ndeftools.Record;

public class AlternativeCarrierRecord
extends Record {
    private CarrierPowerState carrierPowerState;
    private String carrierDataReference;
    private List<String> auxiliaryDataReferences;

    public static AlternativeCarrierRecord parseNdefRecord(NdefRecord ndefRecord) {
        byte[] payload = ndefRecord.getPayload();
        AlternativeCarrierRecord alternativeCarrierRecord = new AlternativeCarrierRecord();
        alternativeCarrierRecord.setCarrierPowerState(CarrierPowerState.toCarrierPowerState(payload[0]));
        short carrierDataReferenceLength = payload[1];
        alternativeCarrierRecord.setCarrierDataReference(new String(payload, 2, (int)carrierDataReferenceLength, Charset.forName("US-ASCII")));
        int auxiliaryDataReferenceCount = payload[2 + carrierDataReferenceLength];
        int index = 2 + carrierDataReferenceLength + 1;
        int i = 0;
        while (i < auxiliaryDataReferenceCount) {
            short auxiliaryDataReferenceLength = payload[index];
            alternativeCarrierRecord.addAuxiliaryDataReference(new String(payload, index + 1, (int)auxiliaryDataReferenceLength, Charset.forName("US-ASCII")));
            index += 1 + auxiliaryDataReferenceLength;
            ++i;
        }
        return alternativeCarrierRecord;
    }

    public AlternativeCarrierRecord() {
        this(new ArrayList<String>());
    }

    public AlternativeCarrierRecord(List<String> auxiliaryDataReferences) {
        this.auxiliaryDataReferences = auxiliaryDataReferences;
    }

    public AlternativeCarrierRecord(CarrierPowerState carrierPowerState, String carrierDataReference) {
        this(carrierPowerState, carrierDataReference, new ArrayList<String>());
    }

    public AlternativeCarrierRecord(CarrierPowerState carrierPowerState, String carrierDataReference, List<String> auxiliaryDataReferences) {
        this(auxiliaryDataReferences);
        this.carrierPowerState = carrierPowerState;
        this.carrierDataReference = carrierDataReference;
    }

    public CarrierPowerState getCarrierPowerState() {
        return this.carrierPowerState;
    }

    public void setCarrierPowerState(CarrierPowerState carrierPowerState) {
        this.carrierPowerState = carrierPowerState;
    }

    public String getCarrierDataReference() {
        return this.carrierDataReference;
    }

    public void setCarrierDataReference(String carrierDataReference) {
        this.carrierDataReference = carrierDataReference;
    }

    public List<String> getAuxiliaryDataReferences() {
        return this.auxiliaryDataReferences;
    }

    public void setAuxiliaryDataReferences(List<String> auxiliaryDataReference) {
        this.auxiliaryDataReferences = auxiliaryDataReference;
    }

    public void addAuxiliaryDataReference(String string) {
        this.auxiliaryDataReferences.add(string);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auxiliaryDataReferences == null ? 0 : this.auxiliaryDataReferences.hashCode());
        result = 31 * result + (this.carrierDataReference == null ? 0 : this.carrierDataReference.hashCode());
        result = 31 * result + (this.carrierPowerState == null ? 0 : this.carrierPowerState.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlternativeCarrierRecord other = (AlternativeCarrierRecord)obj;
        if (this.auxiliaryDataReferences == null ? other.auxiliaryDataReferences != null : !this.auxiliaryDataReferences.equals(other.auxiliaryDataReferences)) {
            return false;
        }
        if (this.carrierDataReference == null ? other.carrierDataReference != null : !this.carrierDataReference.equals(other.carrierDataReference)) {
            return false;
        }
        return this.carrierPowerState == other.carrierPowerState;
    }

    public boolean hasCarrierPowerState() {
        return this.carrierPowerState != null;
    }

    public String getAuxiliaryDataReferenceAt(int index) {
        return this.auxiliaryDataReferences.get(index);
    }

    public void setAuxiliaryDataReference(int index, String reference) {
        this.auxiliaryDataReferences.set(index, reference);
    }

    public boolean hasCarrierDataReference() {
        return this.carrierDataReference != null;
    }

    public void insertAuxiliaryDataReference(String reference, int index) {
        this.auxiliaryDataReferences.add(index, reference);
    }

    public void removeAuxiliaryDataReference(int index) {
        this.auxiliaryDataReferences.remove(index);
    }

    public boolean hasAuxiliaryDataReferences() {
        return !this.auxiliaryDataReferences.isEmpty();
    }

    @Override
    public NdefRecord getNdefRecord() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (!this.hasCarrierPowerState()) {
            throw new IllegalArgumentException("Expected carrier power state");
        }
        bout.write(this.carrierPowerState.getValue() & 7);
        if (!this.hasCarrierDataReference()) {
            throw new IllegalArgumentException("Expected carrier data reference");
        }
        byte[] carrierDataReferenceChar = this.carrierDataReference.getBytes(Charset.forName("US-ASCII"));
        if (carrierDataReferenceChar.length > 255) {
            throw new IllegalArgumentException("Expected carrier data reference '" + this.carrierDataReference + "' <= 255 bytes");
        }
        bout.write(carrierDataReferenceChar.length);
        bout.write(carrierDataReferenceChar, 0, carrierDataReferenceChar.length);
        bout.write(this.auxiliaryDataReferences.size());
        for (String auxiliaryDataReference : this.auxiliaryDataReferences) {
            byte[] auxiliaryDataReferenceChar = auxiliaryDataReference.getBytes(Charset.forName("US-ASCII"));
            if (auxiliaryDataReferenceChar.length > 255) {
                throw new IllegalArgumentException("Expected auxiliary data reference '" + auxiliaryDataReference + "' <= 255 bytes");
            }
            bout.write(auxiliaryDataReferenceChar.length);
            bout.write(auxiliaryDataReferenceChar, 0, auxiliaryDataReferenceChar.length);
        }
        bout.write(0);
        return new NdefRecord(1, NdefRecord.RTD_ALTERNATIVE_CARRIER, this.id != null ? this.id : this.EMPTY, bout.toByteArray());
    }

    public static enum CarrierPowerState {
        Inactive(0),
        Active(1),
        Activating(2),
        Unknown(3);

        private byte value;

        private CarrierPowerState(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static CarrierPowerState toCarrierPowerState(byte value) {
            CarrierPowerState[] carrierPowerStateArray = CarrierPowerState.values();
            int n = carrierPowerStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                CarrierPowerState state = carrierPowerStateArray[n2];
                if (state.value == value) {
                    return state;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unknown carrier power state " + value);
        }
    }
}

