/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown.handover;

import android.nfc.NdefRecord;
import org.ndeftools.Record;

public class CollisionResolutionRecord
extends Record {
    public static byte[] type = new byte[]{99, 114};
    private int randomNumber;

    public static CollisionResolutionRecord parseNdefRecord(NdefRecord ndefRecord) {
        byte[] payload = ndefRecord.getPayload();
        CollisionResolutionRecord collisionResolutionRecord = new CollisionResolutionRecord();
        collisionResolutionRecord.setRandomNumber((payload[0] << 8 | payload[1]) & 0xFFFF);
        return collisionResolutionRecord;
    }

    public CollisionResolutionRecord() {
    }

    public CollisionResolutionRecord(int randomNumber) {
        this.randomNumber = randomNumber;
    }

    public int getRandomNumber() {
        return this.randomNumber;
    }

    public void setRandomNumber(int randomNumber) {
        this.randomNumber = randomNumber;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.randomNumber;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollisionResolutionRecord other = (CollisionResolutionRecord)obj;
        return this.randomNumber == other.randomNumber;
    }

    @Override
    public NdefRecord getNdefRecord() {
        byte[] payload = new byte[]{(byte)(this.randomNumber >> 8 & 0xFF), (byte)(this.randomNumber & 0xFF)};
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, payload);
    }
}

