/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown.handover;

import android.nfc.NdefRecord;
import org.ndeftools.Record;

public class ErrorRecord
extends Record {
    public static byte[] type = new byte[]{101, 114, 114};
    private ErrorReason errorReason;
    private Number errorData;

    public static ErrorRecord parseNdefRecord(NdefRecord ndefRecord) {
        Number number;
        byte[] payload = ndefRecord.getPayload();
        ErrorReason errorReason = ErrorReason.toErrorReason(payload[0]);
        ErrorRecord errorRecord = new ErrorRecord();
        errorRecord.setErrorReason(errorReason);
        switch (errorReason) {
            case TemporaryMemoryConstraints: {
                number = (short)(payload[1] & 0xFFFF);
                break;
            }
            case PermanenteMemoryConstraints: {
                number = ((long)(payload[1] & 0xFF) << 24) + (long)((payload[2] & 0xFF) << 16) + (long)((payload[3] & 0xFF) << 8) + (long)((payload[4] & 0xFF) << 0);
                break;
            }
            case CarrierSpecificConstraints: {
                number = (short)(payload[1] & 0xFFFF);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        errorRecord.setErrorData(number);
        return errorRecord;
    }

    public ErrorRecord() {
    }

    public ErrorRecord(ErrorReason errorReason, Number errorData) {
        this.errorReason = errorReason;
        this.errorData = errorData;
    }

    public ErrorReason getErrorReason() {
        return this.errorReason;
    }

    public void setErrorReason(ErrorReason errorReason) {
        this.errorReason = errorReason;
    }

    public Number getErrorData() {
        return this.errorData;
    }

    public void setErrorData(Number errorData) {
        this.errorData = errorData;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.errorData == null ? 0 : this.errorData.hashCode());
        result = 31 * result + (this.errorReason == null ? 0 : this.errorReason.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorRecord other = (ErrorRecord)obj;
        if (this.errorData == null ? other.errorData != null : !this.errorData.equals(other.errorData)) {
            return false;
        }
        return this.errorReason == other.errorReason;
    }

    public boolean hasErrorReason() {
        return this.errorReason != null;
    }

    public boolean hasErrorData() {
        return this.errorData != null;
    }

    @Override
    public NdefRecord getNdefRecord() {
        byte[] payload;
        if (!this.hasErrorReason()) {
            throw new IllegalArgumentException("Expected error reason");
        }
        if (!this.hasErrorData()) {
            throw new IllegalArgumentException("Expected error data");
        }
        switch (this.errorReason) {
            case TemporaryMemoryConstraints: {
                payload = new byte[]{this.errorReason.getValue(), (byte)(this.errorData.shortValue() & 0xFF)};
                break;
            }
            case PermanenteMemoryConstraints: {
                long unsignedInt = this.errorData.longValue();
                payload = new byte[]{this.errorReason.getValue(), (byte)(unsignedInt >> 24 & 0xFFL), (byte)(unsignedInt >> 16 & 0xFFL), (byte)(unsignedInt >> 8 & 0xFFL), (byte)(unsignedInt & 0xFFL)};
                break;
            }
            case CarrierSpecificConstraints: {
                payload = new byte[]{this.errorReason.getValue(), (byte)(this.errorData.shortValue() & 0xFF)};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown error reason " + (Object)((Object)this.errorReason));
            }
        }
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, payload);
    }

    public static enum ErrorReason {
        TemporaryMemoryConstraints(1),
        PermanenteMemoryConstraints(2),
        CarrierSpecificConstraints(3);

        private byte value;

        private ErrorReason(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static ErrorReason toErrorReason(byte errorReason) {
            if (errorReason == ErrorReason.TemporaryMemoryConstraints.value) {
                return TemporaryMemoryConstraints;
            }
            if (errorReason == ErrorReason.PermanenteMemoryConstraints.value) {
                return PermanenteMemoryConstraints;
            }
            if (errorReason == ErrorReason.CarrierSpecificConstraints.value) {
                return CarrierSpecificConstraints;
            }
            throw new IllegalArgumentException("Unexpected error reason code " + errorReason);
        }
    }
}

