/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown.handover;

import android.annotation.SuppressLint;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.ndeftools.Record;
import org.ndeftools.externaltype.ExternalTypeRecord;

public class HandoverCarrierRecord
extends Record {
    private CarrierTypeFormat carrierTypeFormat;
    private Object carrierType;
    private byte[] carrierData;

    public static HandoverCarrierRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] carrierData;
        byte[] payload = ndefRecord.getPayload();
        CarrierTypeFormat carrierTypeFormat = CarrierTypeFormat.toCarrierTypeFormat((byte)(payload[0] & 7));
        HandoverCarrierRecord handoverCarrierRecord = new HandoverCarrierRecord();
        handoverCarrierRecord.setCarrierTypeFormat(carrierTypeFormat);
        int carrierTypeLength = payload[1] & 0xFF;
        switch (carrierTypeFormat) {
            case WellKnown: {
                byte[] recordsPayload = new byte[carrierTypeLength];
                System.arraycopy(payload, 2, recordsPayload, 0, carrierTypeLength);
                NdefMessage message = new NdefMessage(recordsPayload);
                NdefRecord[] records = message.getRecords();
                if (records.length != 1) {
                    throw new IllegalArgumentException();
                }
                if (records[0].getTnf() != 1) {
                    throw new IllegalArgumentException("Expected well-known type carrier type");
                }
                handoverCarrierRecord.setCarrierType(Record.parse(records[0]));
                break;
            }
            case Media: {
                handoverCarrierRecord.setCarrierType(new String(payload, 2, carrierTypeLength, Charset.forName("US-ASCII")));
                break;
            }
            case AbsoluteURI: {
                handoverCarrierRecord.setCarrierType(new String(payload, 2, carrierTypeLength, Charset.forName("US-ASCII")));
                break;
            }
            case External: {
                Record record = Record.parse(payload, 2, carrierTypeLength);
                if (record instanceof ExternalTypeRecord) {
                    handoverCarrierRecord.setCarrierType(record);
                } else {
                    throw new IllegalArgumentException("Expected external type carrier type, not " + record.getClass().getSimpleName());
                }
            }
            default: {
                throw new RuntimeException();
            }
        }
        int carrierDataLength = payload.length - 2 - carrierTypeLength;
        if (carrierDataLength > 0) {
            carrierData = new byte[carrierDataLength];
            System.arraycopy(payload, 2 + carrierTypeLength, carrierData, 0, carrierDataLength);
        } else {
            carrierData = null;
        }
        handoverCarrierRecord.setCarrierData(carrierData);
        return handoverCarrierRecord;
    }

    public HandoverCarrierRecord(CarrierTypeFormat carrierTypeFormat, ExternalTypeRecord carrierType, byte[] carrierData) {
        this.carrierTypeFormat = carrierTypeFormat;
        this.carrierType = carrierType;
        this.carrierData = carrierData;
    }

    public HandoverCarrierRecord(CarrierTypeFormat carrierTypeFormat, Record carrierType, byte[] carrierData) {
        this.carrierTypeFormat = carrierTypeFormat;
        this.carrierType = carrierType;
        this.carrierData = carrierData;
    }

    public HandoverCarrierRecord() {
    }

    public HandoverCarrierRecord(CarrierTypeFormat carrierTypeFormat, String carrierType, byte[] carrierData) {
        this.carrierTypeFormat = carrierTypeFormat;
        this.carrierType = carrierType;
        this.carrierData = carrierData;
    }

    public CarrierTypeFormat getCarrierTypeFormat() {
        return this.carrierTypeFormat;
    }

    public void setCarrierTypeFormat(CarrierTypeFormat carrierTypeFormat) {
        this.carrierTypeFormat = carrierTypeFormat;
    }

    public Object getCarrierType() {
        return this.carrierType;
    }

    public void setCarrierType(Object carrierType) {
        this.carrierType = carrierType;
    }

    public byte[] getCarrierData() {
        return this.carrierData;
    }

    public void setCarrierData(byte[] carrierData) {
        this.carrierData = carrierData;
    }

    public boolean hasCarrierData() {
        return this.carrierData != null;
    }

    public int getCarrierDataSize() {
        return this.carrierData.length;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.carrierData);
        result = 31 * result + (this.carrierType == null ? 0 : this.carrierType.hashCode());
        result = 31 * result + (this.carrierTypeFormat == null ? 0 : this.carrierTypeFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HandoverCarrierRecord other = (HandoverCarrierRecord)obj;
        if (!Arrays.equals(this.carrierData, other.carrierData)) {
            return false;
        }
        if (this.carrierType == null ? other.carrierType != null : !this.carrierType.equals(other.carrierType)) {
            return false;
        }
        return this.carrierTypeFormat == other.carrierTypeFormat;
    }

    public boolean hasCarrierTypeFormat() {
        return this.carrierTypeFormat != null;
    }

    public boolean hasCarrierType() {
        return this.carrierType != null;
    }

    @Override
    @SuppressLint(value={"NewApi", "NewApi"})
    public NdefRecord getNdefRecord() {
        byte[] encoded;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (!this.hasCarrierTypeFormat()) {
            throw new IllegalArgumentException("Expected carrier type format");
        }
        bout.write(this.carrierTypeFormat.getValue() & 7);
        switch (this.carrierTypeFormat) {
            case WellKnown: {
                if (this.carrierType instanceof Record) {
                    Record wellKnownRecord = (Record)this.carrierType;
                    encoded = wellKnownRecord.toByteArray();
                    break;
                }
                throw new IllegalArgumentException("Expected well-known record to be of well-known type");
            }
            case Media: {
                String string = (String)this.carrierType;
                encoded = string.getBytes(Charset.forName("US-ASCII"));
                break;
            }
            case AbsoluteURI: {
                String string = (String)this.carrierType;
                encoded = string.getBytes(Charset.forName("US-ASCII"));
                break;
            }
            case External: {
                if (this.carrierType instanceof ExternalTypeRecord) {
                    ExternalTypeRecord externalTypeRecord = (ExternalTypeRecord)this.carrierType;
                    encoded = externalTypeRecord.toByteArray();
                    break;
                }
                throw new IllegalArgumentException("Expected external type record to be of supertype " + ExternalTypeRecord.class.getName());
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (encoded.length > 255) {
            throw new IllegalArgumentException("Carrier type 255 byte limit exceeded.");
        }
        bout.write(encoded.length);
        bout.write(encoded, 0, encoded.length);
        if (this.hasCarrierData()) {
            bout.write(this.carrierData, 0, this.carrierData.length);
        }
        return new NdefRecord(1, NdefRecord.RTD_HANDOVER_CARRIER, this.id != null ? this.id : this.EMPTY, bout.toByteArray());
    }

    public static enum CarrierTypeFormat {
        WellKnown(1),
        Media(2),
        AbsoluteURI(3),
        External(4);

        private short value;

        private CarrierTypeFormat(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static CarrierTypeFormat toCarrierTypeFormat(short value) {
            CarrierTypeFormat[] carrierTypeFormatArray = CarrierTypeFormat.values();
            int n = carrierTypeFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                CarrierTypeFormat carrierTypeFormat = carrierTypeFormatArray[n2];
                if (carrierTypeFormat.value == value) {
                    return carrierTypeFormat;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unknown carrier type format " + value);
        }
    }
}

