/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown.handover;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import java.util.ArrayList;
import java.util.List;
import org.ndeftools.Message;
import org.ndeftools.Record;
import org.ndeftools.wellknown.handover.AlternativeCarrierRecord;
import org.ndeftools.wellknown.handover.CollisionResolutionRecord;

public class HandoverRequestRecord
extends Record {
    private byte majorVersion = 1;
    private byte minorVersion = (byte)2;
    private CollisionResolutionRecord collisionResolution;
    private List<AlternativeCarrierRecord> alternativeCarriers;

    public static HandoverRequestRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] payload = ndefRecord.getPayload();
        HandoverRequestRecord handoverRequestRecord = new HandoverRequestRecord();
        byte minorVersion = (byte)(payload[0] & 0xF);
        byte majorVersion = (byte)(payload[0] >> 4 & 0xF);
        handoverRequestRecord.setMinorVersion(minorVersion);
        handoverRequestRecord.setMajorVersion(majorVersion);
        HandoverRequestRecord.normalizeMessageBeginEnd(payload, 1, payload.length - 1);
        Message records = Message.parseNdefMessage(payload, 1, payload.length - 1);
        if (records.isEmpty()) {
            throw new IllegalArgumentException("Expected collision resolution record and at least one alternative carrier");
        }
        int i = 0;
        while (i < records.size()) {
            Record record = (Record)records.get(i);
            if (record instanceof CollisionResolutionRecord) {
                handoverRequestRecord.setCollisionResolution((CollisionResolutionRecord)record);
            } else if (record instanceof AlternativeCarrierRecord) {
                handoverRequestRecord.add((AlternativeCarrierRecord)records.get(i));
            }
            ++i;
        }
        if (handoverRequestRecord.getAlternativeCarriers().size() == 0) {
            throw new IllegalArgumentException("Expected at least one alternative carrier");
        }
        return handoverRequestRecord;
    }

    public HandoverRequestRecord() {
        this.alternativeCarriers = new ArrayList<AlternativeCarrierRecord>();
    }

    public HandoverRequestRecord(CollisionResolutionRecord collisionResolution) {
        this(collisionResolution, new ArrayList<AlternativeCarrierRecord>());
    }

    public HandoverRequestRecord(CollisionResolutionRecord collisionResolution, List<AlternativeCarrierRecord> alternativeCarriers) {
        this.collisionResolution = collisionResolution;
        this.alternativeCarriers = alternativeCarriers;
    }

    public HandoverRequestRecord(byte majorVersion, byte minorVersion, CollisionResolutionRecord collisionResolution, List<AlternativeCarrierRecord> alternativeCarriers) {
        this(collisionResolution, alternativeCarriers);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public List<AlternativeCarrierRecord> getAlternativeCarriers() {
        return this.alternativeCarriers;
    }

    public void setAlternativeCarriers(List<AlternativeCarrierRecord> alternativeCarriers) {
        this.alternativeCarriers = alternativeCarriers;
    }

    public CollisionResolutionRecord getCollisionResolution() {
        return this.collisionResolution;
    }

    public void setCollisionResolution(CollisionResolutionRecord collisionResolution) {
        this.collisionResolution = collisionResolution;
    }

    public boolean hasAlternativeCarriers() {
        return !this.alternativeCarriers.isEmpty();
    }

    public void add(AlternativeCarrierRecord alternativeCarrierRecord) {
        this.alternativeCarriers.add(alternativeCarrierRecord);
    }

    public boolean hasCollisionResolution() {
        return this.collisionResolution != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternativeCarriers == null ? 0 : this.alternativeCarriers.hashCode());
        result = 31 * result + (this.collisionResolution == null ? 0 : this.collisionResolution.hashCode());
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HandoverRequestRecord other = (HandoverRequestRecord)obj;
        if (this.alternativeCarriers == null ? other.alternativeCarriers != null : !this.alternativeCarriers.equals(other.alternativeCarriers)) {
            return false;
        }
        if (this.collisionResolution == null ? other.collisionResolution != null : !this.collisionResolution.equals(other.collisionResolution)) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        return this.minorVersion == other.minorVersion;
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasCollisionResolution()) {
            throw new IllegalArgumentException("Expected collision resolution");
        }
        if (!this.hasAlternativeCarriers()) {
            throw new IllegalArgumentException("Expected at least one alternative carrier");
        }
        ArrayList<NdefRecord> records = new ArrayList<NdefRecord>();
        records.add(this.collisionResolution.getNdefRecord());
        for (Record record : this.alternativeCarriers) {
            records.add(record.getNdefRecord());
        }
        byte[] byArray = new NdefMessage(records.toArray(new NdefRecord[records.size()])).toByteArray();
        byte[] payload = new byte[byArray.length + 1];
        payload[0] = (byte)(this.majorVersion << 4 | this.minorVersion);
        System.arraycopy(byArray, 0, payload, 1, byArray.length);
        return new NdefRecord(1, NdefRecord.RTD_HANDOVER_REQUEST, this.id != null ? this.id : this.EMPTY, payload);
    }
}

