/*
 * Generated by gdbus-codegen 2.40.0. DO NOT EDIT.
 *
 * The license of this code is the same as for the source it was derived from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "src/generated-code.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  gboolean use_gvariant;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.Adapter
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardAdapter
 * @title: NeardAdapter
 * @short_description: Generated C code for the org.neard.Adapter D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.Adapter ---- */

static const _ExtendedGDBusArgInfo _neard_adapter_method_info_start_poll_loop_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_adapter_method_info_start_poll_loop_IN_ARG_pointers[] =
{
  &_neard_adapter_method_info_start_poll_loop_IN_ARG_name,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_adapter_method_info_start_poll_loop =
{
  {
    -1,
    (gchar *) "StartPollLoop",
    (GDBusArgInfo **) &_neard_adapter_method_info_start_poll_loop_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-start-poll-loop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _neard_adapter_method_info_stop_poll_loop =
{
  {
    -1,
    (gchar *) "StopPollLoop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop-poll-loop",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_adapter_method_info_pointers[] =
{
  &_neard_adapter_method_info_start_poll_loop,
  &_neard_adapter_method_info_stop_poll_loop,
  NULL
};

static const _ExtendedGDBusArgInfo _neard_adapter_signal_info_tag_found_ARG_address =
{
  {
    -1,
    (gchar *) "address",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_adapter_signal_info_tag_found_ARG_pointers[] =
{
  &_neard_adapter_signal_info_tag_found_ARG_address,
  NULL
};

static const _ExtendedGDBusSignalInfo _neard_adapter_signal_info_tag_found =
{
  {
    -1,
    (gchar *) "TagFound",
    (GDBusArgInfo **) &_neard_adapter_signal_info_tag_found_ARG_pointers,
    NULL
  },
  "tag-found"
};

static const _ExtendedGDBusArgInfo _neard_adapter_signal_info_tag_lost_ARG_address =
{
  {
    -1,
    (gchar *) "address",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_adapter_signal_info_tag_lost_ARG_pointers[] =
{
  &_neard_adapter_signal_info_tag_lost_ARG_address,
  NULL
};

static const _ExtendedGDBusSignalInfo _neard_adapter_signal_info_tag_lost =
{
  {
    -1,
    (gchar *) "TagLost",
    (GDBusArgInfo **) &_neard_adapter_signal_info_tag_lost_ARG_pointers,
    NULL
  },
  "tag-lost"
};

static const _ExtendedGDBusSignalInfo * const _neard_adapter_signal_info_pointers[] =
{
  &_neard_adapter_signal_info_tag_found,
  &_neard_adapter_signal_info_tag_lost,
  NULL
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_mode =
{
  {
    -1,
    (gchar *) "Mode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mode",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_powered =
{
  {
    -1,
    (gchar *) "Powered",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "powered",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_polling =
{
  {
    -1,
    (gchar *) "Polling",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "polling",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_protocols =
{
  {
    -1,
    (gchar *) "Protocols",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "protocols",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_tags =
{
  {
    -1,
    (gchar *) "Tags",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tags",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_adapter_property_info_devices =
{
  {
    -1,
    (gchar *) "Devices",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "devices",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _neard_adapter_property_info_pointers[] =
{
  &_neard_adapter_property_info_name,
  &_neard_adapter_property_info_mode,
  &_neard_adapter_property_info_powered,
  &_neard_adapter_property_info_polling,
  &_neard_adapter_property_info_protocols,
  &_neard_adapter_property_info_tags,
  &_neard_adapter_property_info_devices,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_adapter_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.Adapter",
    (GDBusMethodInfo **) &_neard_adapter_method_info_pointers,
    (GDBusSignalInfo **) &_neard_adapter_signal_info_pointers,
    (GDBusPropertyInfo **) &_neard_adapter_property_info_pointers,
    NULL
  },
  "adapter",
};


/**
 * neard_adapter_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_adapter_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_adapter_interface_info.parent_struct;
}

/**
 * neard_adapter_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardAdapter interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_adapter_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "mode");
  g_object_class_override_property (klass, property_id_begin++, "powered");
  g_object_class_override_property (klass, property_id_begin++, "polling");
  g_object_class_override_property (klass, property_id_begin++, "protocols");
  g_object_class_override_property (klass, property_id_begin++, "tags");
  g_object_class_override_property (klass, property_id_begin++, "devices");
  return property_id_begin - 1;
}



/**
 * NeardAdapter:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link>.
 */

/**
 * NeardAdapterIface:
 * @parent_iface: The parent interface.
 * @handle_start_poll_loop: Handler for the #NeardAdapter::handle-start-poll-loop signal.
 * @handle_stop_poll_loop: Handler for the #NeardAdapter::handle-stop-poll-loop signal.
 * @get_devices: Getter for the #NeardAdapter:devices property.
 * @get_mode: Getter for the #NeardAdapter:mode property.
 * @get_name: Getter for the #NeardAdapter:name property.
 * @get_polling: Getter for the #NeardAdapter:polling property.
 * @get_powered: Getter for the #NeardAdapter:powered property.
 * @get_protocols: Getter for the #NeardAdapter:protocols property.
 * @get_tags: Getter for the #NeardAdapter:tags property.
 * @tag_found: Handler for the #NeardAdapter::tag-found signal.
 * @tag_lost: Handler for the #NeardAdapter::tag-lost signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link>.
 */

typedef NeardAdapterIface NeardAdapterInterface;
G_DEFINE_INTERFACE (NeardAdapter, neard_adapter, G_TYPE_OBJECT);

static void
neard_adapter_default_init (NeardAdapterIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardAdapter::handle-start-poll-loop:
   * @object: A #NeardAdapter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Adapter.StartPollLoop">StartPollLoop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_adapter_complete_start_poll_loop() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-poll-loop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAdapterIface, handle_start_poll_loop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NeardAdapter::handle-stop-poll-loop:
   * @object: A #NeardAdapter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Adapter.StopPollLoop">StopPollLoop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_adapter_complete_stop_poll_loop() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-poll-loop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAdapterIface, handle_stop_poll_loop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * NeardAdapter::tag-found:
   * @object: A #NeardAdapter.
   * @arg_address: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-neard-Adapter.TagFound">"TagFound"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("tag-found",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAdapterIface, tag_found),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * NeardAdapter::tag-lost:
   * @object: A #NeardAdapter.
   * @arg_address: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-neard-Adapter.TagLost">"TagLost"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("tag-lost",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAdapterIface, tag_lost),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * NeardAdapter:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardAdapter:mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Mode">"Mode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("mode", "Mode", "Mode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardAdapter:powered:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Powered">"Powered"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("powered", "Powered", "Powered", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardAdapter:polling:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Polling">"Polling"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("polling", "Polling", "Polling", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardAdapter:protocols:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Protocols">"Protocols"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("protocols", "Protocols", "Protocols", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardAdapter:tags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Tags">"Tags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("tags", "Tags", "Tags", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardAdapter:devices:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Adapter.Devices">"Devices"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("devices", "Devices", "Devices", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * neard_adapter_get_name: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_adapter_dup_name() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_adapter_get_name (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_name (object);
}

/**
 * neard_adapter_dup_name: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Adapter.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_adapter_dup_name (NeardAdapter *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * neard_adapter_set_name: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_adapter_set_name (NeardAdapter *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * neard_adapter_get_mode: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Mode">"Mode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_adapter_dup_mode() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_adapter_get_mode (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_mode (object);
}

/**
 * neard_adapter_dup_mode: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Adapter.Mode">"Mode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_adapter_dup_mode (NeardAdapter *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "mode", &value, NULL);
  return value;
}

/**
 * neard_adapter_set_mode: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Mode">"Mode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_adapter_set_mode (NeardAdapter *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "mode", value, NULL);
}

/**
 * neard_adapter_get_powered: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Powered">"Powered"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
neard_adapter_get_powered (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_powered (object);
}

/**
 * neard_adapter_set_powered: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Powered">"Powered"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
neard_adapter_set_powered (NeardAdapter *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "powered", value, NULL);
}

/**
 * neard_adapter_get_polling: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Polling">"Polling"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
neard_adapter_get_polling (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_polling (object);
}

/**
 * neard_adapter_set_polling: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Polling">"Polling"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_adapter_set_polling (NeardAdapter *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "polling", value, NULL);
}

/**
 * neard_adapter_get_protocols: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Protocols">"Protocols"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_adapter_dup_protocols() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
neard_adapter_get_protocols (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_protocols (object);
}

/**
 * neard_adapter_dup_protocols: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Adapter.Protocols">"Protocols"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
neard_adapter_dup_protocols (NeardAdapter *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "protocols", &value, NULL);
  return value;
}

/**
 * neard_adapter_set_protocols: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Protocols">"Protocols"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_adapter_set_protocols (NeardAdapter *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "protocols", value, NULL);
}

/**
 * neard_adapter_get_tags: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Tags">"Tags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_adapter_dup_tags() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
neard_adapter_get_tags (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_tags (object);
}

/**
 * neard_adapter_dup_tags: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Adapter.Tags">"Tags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
neard_adapter_dup_tags (NeardAdapter *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "tags", &value, NULL);
  return value;
}

/**
 * neard_adapter_set_tags: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Tags">"Tags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_adapter_set_tags (NeardAdapter *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "tags", value, NULL);
}

/**
 * neard_adapter_get_devices: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Adapter.Devices">"Devices"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_adapter_dup_devices() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
neard_adapter_get_devices (NeardAdapter *object)
{
  return NEARD_ADAPTER_GET_IFACE (object)->get_devices (object);
}

/**
 * neard_adapter_dup_devices: (skip)
 * @object: A #NeardAdapter.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Adapter.Devices">"Devices"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
neard_adapter_dup_devices (NeardAdapter *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "devices", &value, NULL);
  return value;
}

/**
 * neard_adapter_set_devices: (skip)
 * @object: A #NeardAdapter.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Adapter.Devices">"Devices"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_adapter_set_devices (NeardAdapter *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "devices", value, NULL);
}

/**
 * neard_adapter_emit_tag_found:
 * @object: A #NeardAdapter.
 * @arg_address: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-neard-Adapter.TagFound">"TagFound"</link> D-Bus signal.
 */
void
neard_adapter_emit_tag_found (
    NeardAdapter *object,
    const gchar *arg_address)
{
  g_signal_emit_by_name (object, "tag-found", arg_address);
}

/**
 * neard_adapter_emit_tag_lost:
 * @object: A #NeardAdapter.
 * @arg_address: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-neard-Adapter.TagLost">"TagLost"</link> D-Bus signal.
 */
void
neard_adapter_emit_tag_lost (
    NeardAdapter *object,
    const gchar *arg_address)
{
  g_signal_emit_by_name (object, "tag-lost", arg_address);
}

/**
 * neard_adapter_call_start_poll_loop:
 * @proxy: A #NeardAdapterProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Adapter.StartPollLoop">StartPollLoop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_adapter_call_start_poll_loop_finish() to get the result of the operation.
 *
 * See neard_adapter_call_start_poll_loop_sync() for the synchronous, blocking version of this method.
 */
void
neard_adapter_call_start_poll_loop (
    NeardAdapter *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartPollLoop",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_adapter_call_start_poll_loop_finish:
 * @proxy: A #NeardAdapterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_adapter_call_start_poll_loop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_adapter_call_start_poll_loop().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_adapter_call_start_poll_loop_finish (
    NeardAdapter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_adapter_call_start_poll_loop_sync:
 * @proxy: A #NeardAdapterProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Adapter.StartPollLoop">StartPollLoop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_adapter_call_start_poll_loop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_adapter_call_start_poll_loop_sync (
    NeardAdapter *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartPollLoop",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_adapter_call_stop_poll_loop:
 * @proxy: A #NeardAdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Adapter.StopPollLoop">StopPollLoop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_adapter_call_stop_poll_loop_finish() to get the result of the operation.
 *
 * See neard_adapter_call_stop_poll_loop_sync() for the synchronous, blocking version of this method.
 */
void
neard_adapter_call_stop_poll_loop (
    NeardAdapter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopPollLoop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_adapter_call_stop_poll_loop_finish:
 * @proxy: A #NeardAdapterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_adapter_call_stop_poll_loop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_adapter_call_stop_poll_loop().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_adapter_call_stop_poll_loop_finish (
    NeardAdapter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_adapter_call_stop_poll_loop_sync:
 * @proxy: A #NeardAdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Adapter.StopPollLoop">StopPollLoop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_adapter_call_stop_poll_loop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_adapter_call_stop_poll_loop_sync (
    NeardAdapter *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopPollLoop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_adapter_complete_start_poll_loop:
 * @object: A #NeardAdapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Adapter.StartPollLoop">StartPollLoop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_adapter_complete_start_poll_loop (
    NeardAdapter *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_adapter_complete_stop_poll_loop:
 * @object: A #NeardAdapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Adapter.StopPollLoop">StopPollLoop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_adapter_complete_stop_poll_loop (
    NeardAdapter *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardAdapterProxy:
 *
 * The #NeardAdapterProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardAdapterProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardAdapterProxy.
 */

struct _NeardAdapterProxyPrivate
{
  GData *qdata;
};

static void neard_adapter_proxy_iface_init (NeardAdapterIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardAdapterProxy, neard_adapter_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardAdapterProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_ADAPTER, neard_adapter_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardAdapterProxy, neard_adapter_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_ADAPTER, neard_adapter_proxy_iface_init));

#endif
static void
neard_adapter_proxy_finalize (GObject *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_adapter_proxy_parent_class)->finalize (object);
}

static void
neard_adapter_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = _neard_adapter_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
neard_adapter_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.neard.Adapter: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
neard_adapter_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = _neard_adapter_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.neard.Adapter", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) neard_adapter_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
neard_adapter_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_adapter_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_ADAPTER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_ADAPTER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_adapter_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_adapter_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_adapter_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
neard_adapter_proxy_get_name (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_adapter_proxy_get_mode (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Mode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
neard_adapter_proxy_get_powered (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Powered");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
neard_adapter_proxy_get_polling (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Polling");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
neard_adapter_proxy_get_protocols (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Protocols");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Protocols");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Protocols", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
neard_adapter_proxy_get_tags (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Tags");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
neard_adapter_proxy_get_devices (NeardAdapter *object)
{
  NeardAdapterProxy *proxy = NEARD_ADAPTER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Devices");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
neard_adapter_proxy_init (NeardAdapterProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_adapter_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_ADAPTER_PROXY, NeardAdapterProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_adapter_interface_info ());
}

static void
neard_adapter_proxy_class_init (NeardAdapterProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_adapter_proxy_finalize;
  gobject_class->get_property = neard_adapter_proxy_get_property;
  gobject_class->set_property = neard_adapter_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_adapter_proxy_g_signal;
  proxy_class->g_properties_changed = neard_adapter_proxy_g_properties_changed;

  neard_adapter_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardAdapterProxyPrivate));
#endif
}

static void
neard_adapter_proxy_iface_init (NeardAdapterIface *iface)
{
  iface->get_name = neard_adapter_proxy_get_name;
  iface->get_mode = neard_adapter_proxy_get_mode;
  iface->get_powered = neard_adapter_proxy_get_powered;
  iface->get_polling = neard_adapter_proxy_get_polling;
  iface->get_protocols = neard_adapter_proxy_get_protocols;
  iface->get_tags = neard_adapter_proxy_get_tags;
  iface->get_devices = neard_adapter_proxy_get_devices;
}

/**
 * neard_adapter_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_adapter_proxy_new_finish() to get the result of the operation.
 *
 * See neard_adapter_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_adapter_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_ADAPTER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Adapter", NULL);
}

/**
 * neard_adapter_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_adapter_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_adapter_proxy_new().
 *
 * Returns: (transfer full) (type NeardAdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAdapter *
neard_adapter_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_ADAPTER (ret);
  else
    return NULL;
}

/**
 * neard_adapter_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_adapter_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardAdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAdapter *
neard_adapter_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_ADAPTER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Adapter", NULL);
  if (ret != NULL)
    return NEARD_ADAPTER (ret);
  else
    return NULL;
}


/**
 * neard_adapter_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_adapter_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_adapter_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_adapter_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_adapter_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_ADAPTER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Adapter", NULL);
}

/**
 * neard_adapter_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_adapter_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_adapter_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardAdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAdapter *
neard_adapter_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_ADAPTER (ret);
  else
    return NULL;
}

/**
 * neard_adapter_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_adapter_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_adapter_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardAdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAdapter *
neard_adapter_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_ADAPTER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Adapter", NULL);
  if (ret != NULL)
    return NEARD_ADAPTER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardAdapterSkeleton:
 *
 * The #NeardAdapterSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardAdapterSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardAdapterSkeleton.
 */

struct _NeardAdapterSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_adapter_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_ADAPTER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_ADAPTER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_adapter_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_adapter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_adapter_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_adapter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_adapter_skeleton_vtable =
{
  _neard_adapter_skeleton_handle_method_call,
  _neard_adapter_skeleton_handle_get_property,
  _neard_adapter_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_adapter_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_adapter_interface_info ();
}

static GDBusInterfaceVTable *
neard_adapter_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_adapter_skeleton_vtable;
}

static GVariant *
neard_adapter_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_adapter_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_adapter_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_adapter_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_adapter_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Adapter", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _neard_adapter_emit_changed (gpointer user_data);

static void
neard_adapter_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _neard_adapter_emit_changed (skeleton);
}

static void
_neard_adapter_on_signal_tag_found (
    NeardAdapter *object,
    const gchar *arg_address)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_address));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Adapter", "TagFound",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_neard_adapter_on_signal_tag_lost (
    NeardAdapter *object,
    const gchar *arg_address)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_address));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Adapter", "TagLost",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void neard_adapter_skeleton_iface_init (NeardAdapterIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardAdapterSkeleton, neard_adapter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardAdapterSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_ADAPTER, neard_adapter_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardAdapterSkeleton, neard_adapter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_ADAPTER, neard_adapter_skeleton_iface_init));

#endif
static void
neard_adapter_skeleton_finalize (GObject *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_adapter_skeleton_parent_class)->finalize (object);
}

static void
neard_adapter_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_neard_adapter_emit_changed (gpointer user_data)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.neard.Adapter",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_neard_adapter_schedule_emit_changed (NeardAdapterSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
neard_adapter_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _neard_adapter_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
neard_adapter_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _neard_adapter_schedule_emit_changed (skeleton, _neard_adapter_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
neard_adapter_skeleton_init (NeardAdapterSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_adapter_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_ADAPTER_SKELETON, NeardAdapterSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
}

static const gchar *
neard_adapter_skeleton_get_name (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_adapter_skeleton_get_mode (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
neard_adapter_skeleton_get_powered (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
neard_adapter_skeleton_get_polling (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
neard_adapter_skeleton_get_protocols (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
neard_adapter_skeleton_get_tags (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
neard_adapter_skeleton_get_devices (NeardAdapter *object)
{
  NeardAdapterSkeleton *skeleton = NEARD_ADAPTER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
neard_adapter_skeleton_class_init (NeardAdapterSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_adapter_skeleton_finalize;
  gobject_class->get_property = neard_adapter_skeleton_get_property;
  gobject_class->set_property = neard_adapter_skeleton_set_property;
  gobject_class->notify       = neard_adapter_skeleton_notify;


  neard_adapter_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_adapter_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_adapter_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_adapter_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_adapter_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardAdapterSkeletonPrivate));
#endif
}

static void
neard_adapter_skeleton_iface_init (NeardAdapterIface *iface)
{
  iface->tag_found = _neard_adapter_on_signal_tag_found;
  iface->tag_lost = _neard_adapter_on_signal_tag_lost;
  iface->get_name = neard_adapter_skeleton_get_name;
  iface->get_mode = neard_adapter_skeleton_get_mode;
  iface->get_powered = neard_adapter_skeleton_get_powered;
  iface->get_polling = neard_adapter_skeleton_get_polling;
  iface->get_protocols = neard_adapter_skeleton_get_protocols;
  iface->get_tags = neard_adapter_skeleton_get_tags;
  iface->get_devices = neard_adapter_skeleton_get_devices;
}

/**
 * neard_adapter_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link>.
 *
 * Returns: (transfer full) (type NeardAdapterSkeleton): The skeleton object.
 */
NeardAdapter *
neard_adapter_skeleton_new (void)
{
  return NEARD_ADAPTER (g_object_new (NEARD_TYPE_ADAPTER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.NDEFAgent
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardNDEFAgent
 * @title: NeardNDEFAgent
 * @short_description: Generated C code for the org.neard.NDEFAgent D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.NDEFAgent ---- */

static const _ExtendedGDBusArgInfo _neard_ndefagent_method_info_get_ndef_IN_ARG_values =
{
  {
    -1,
    (gchar *) "values",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_ndefagent_method_info_get_ndef_IN_ARG_pointers[] =
{
  &_neard_ndefagent_method_info_get_ndef_IN_ARG_values,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_ndefagent_method_info_get_ndef =
{
  {
    -1,
    (gchar *) "GetNDEF",
    (GDBusArgInfo **) &_neard_ndefagent_method_info_get_ndef_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-get-ndef",
  FALSE
};

static const _ExtendedGDBusMethodInfo _neard_ndefagent_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_ndefagent_method_info_pointers[] =
{
  &_neard_ndefagent_method_info_get_ndef,
  &_neard_ndefagent_method_info_release,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_ndefagent_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.NDEFAgent",
    (GDBusMethodInfo **) &_neard_ndefagent_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "ndefagent",
};


/**
 * neard_ndefagent_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_ndefagent_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_ndefagent_interface_info.parent_struct;
}

/**
 * neard_ndefagent_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardNDEFAgent interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_ndefagent_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * NeardNDEFAgent:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link>.
 */

/**
 * NeardNDEFAgentIface:
 * @parent_iface: The parent interface.
 * @handle_get_ndef: Handler for the #NeardNDEFAgent::handle-get-ndef signal.
 * @handle_release: Handler for the #NeardNDEFAgent::handle-release signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link>.
 */

typedef NeardNDEFAgentIface NeardNDEFAgentInterface;
G_DEFINE_INTERFACE (NeardNDEFAgent, neard_ndefagent, G_TYPE_OBJECT);

static void
neard_ndefagent_default_init (NeardNDEFAgentIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardNDEFAgent::handle-get-ndef:
   * @object: A #NeardNDEFAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_values: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-NDEFAgent.GetNDEF">GetNDEF()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_ndefagent_complete_get_ndef() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-ndef",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardNDEFAgentIface, handle_get_ndef),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NeardNDEFAgent::handle-release:
   * @object: A #NeardNDEFAgent.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-NDEFAgent.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_ndefagent_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardNDEFAgentIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * neard_ndefagent_call_get_ndef:
 * @proxy: A #NeardNDEFAgentProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-NDEFAgent.GetNDEF">GetNDEF()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_ndefagent_call_get_ndef_finish() to get the result of the operation.
 *
 * See neard_ndefagent_call_get_ndef_sync() for the synchronous, blocking version of this method.
 */
void
neard_ndefagent_call_get_ndef (
    NeardNDEFAgent *proxy,
    GVariant *arg_values,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetNDEF",
    g_variant_new ("(@a{sv})",
                   arg_values),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_ndefagent_call_get_ndef_finish:
 * @proxy: A #NeardNDEFAgentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_ndefagent_call_get_ndef().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_ndefagent_call_get_ndef().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_ndefagent_call_get_ndef_finish (
    NeardNDEFAgent *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_ndefagent_call_get_ndef_sync:
 * @proxy: A #NeardNDEFAgentProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-NDEFAgent.GetNDEF">GetNDEF()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_ndefagent_call_get_ndef() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_ndefagent_call_get_ndef_sync (
    NeardNDEFAgent *proxy,
    GVariant *arg_values,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetNDEF",
    g_variant_new ("(@a{sv})",
                   arg_values),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_ndefagent_call_release:
 * @proxy: A #NeardNDEFAgentProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-NDEFAgent.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_ndefagent_call_release_finish() to get the result of the operation.
 *
 * See neard_ndefagent_call_release_sync() for the synchronous, blocking version of this method.
 */
void
neard_ndefagent_call_release (
    NeardNDEFAgent *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_ndefagent_call_release_finish:
 * @proxy: A #NeardNDEFAgentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_ndefagent_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_ndefagent_call_release().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_ndefagent_call_release_finish (
    NeardNDEFAgent *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_ndefagent_call_release_sync:
 * @proxy: A #NeardNDEFAgentProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-NDEFAgent.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_ndefagent_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_ndefagent_call_release_sync (
    NeardNDEFAgent *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_ndefagent_complete_get_ndef:
 * @object: A #NeardNDEFAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-NDEFAgent.GetNDEF">GetNDEF()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_ndefagent_complete_get_ndef (
    NeardNDEFAgent *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_ndefagent_complete_release:
 * @object: A #NeardNDEFAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-NDEFAgent.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_ndefagent_complete_release (
    NeardNDEFAgent *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardNDEFAgentProxy:
 *
 * The #NeardNDEFAgentProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardNDEFAgentProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardNDEFAgentProxy.
 */

struct _NeardNDEFAgentProxyPrivate
{
  GData *qdata;
};

static void neard_ndefagent_proxy_iface_init (NeardNDEFAgentIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardNDEFAgentProxy, neard_ndefagent_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardNDEFAgentProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_NDEFAGENT, neard_ndefagent_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardNDEFAgentProxy, neard_ndefagent_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_NDEFAGENT, neard_ndefagent_proxy_iface_init));

#endif
static void
neard_ndefagent_proxy_finalize (GObject *object)
{
  NeardNDEFAgentProxy *proxy = NEARD_NDEFAGENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_ndefagent_proxy_parent_class)->finalize (object);
}

static void
neard_ndefagent_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
neard_ndefagent_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
neard_ndefagent_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_ndefagent_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_NDEFAGENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_NDEFAGENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_ndefagent_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardNDEFAgentProxy *proxy = NEARD_NDEFAGENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_ndefagent_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_ndefagent_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
neard_ndefagent_proxy_init (NeardNDEFAgentProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_ndefagent_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_NDEFAGENT_PROXY, NeardNDEFAgentProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_ndefagent_interface_info ());
}

static void
neard_ndefagent_proxy_class_init (NeardNDEFAgentProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_ndefagent_proxy_finalize;
  gobject_class->get_property = neard_ndefagent_proxy_get_property;
  gobject_class->set_property = neard_ndefagent_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_ndefagent_proxy_g_signal;
  proxy_class->g_properties_changed = neard_ndefagent_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardNDEFAgentProxyPrivate));
#endif
}

static void
neard_ndefagent_proxy_iface_init (NeardNDEFAgentIface *iface)
{
}

/**
 * neard_ndefagent_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_ndefagent_proxy_new_finish() to get the result of the operation.
 *
 * See neard_ndefagent_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_ndefagent_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_NDEFAGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.NDEFAgent", NULL);
}

/**
 * neard_ndefagent_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_ndefagent_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_ndefagent_proxy_new().
 *
 * Returns: (transfer full) (type NeardNDEFAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardNDEFAgent *
neard_ndefagent_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_NDEFAGENT (ret);
  else
    return NULL;
}

/**
 * neard_ndefagent_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_ndefagent_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardNDEFAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardNDEFAgent *
neard_ndefagent_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_NDEFAGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.NDEFAgent", NULL);
  if (ret != NULL)
    return NEARD_NDEFAGENT (ret);
  else
    return NULL;
}


/**
 * neard_ndefagent_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_ndefagent_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_ndefagent_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_ndefagent_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_ndefagent_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_NDEFAGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.NDEFAgent", NULL);
}

/**
 * neard_ndefagent_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_ndefagent_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_ndefagent_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardNDEFAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardNDEFAgent *
neard_ndefagent_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_NDEFAGENT (ret);
  else
    return NULL;
}

/**
 * neard_ndefagent_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_ndefagent_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_ndefagent_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardNDEFAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardNDEFAgent *
neard_ndefagent_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_NDEFAGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.NDEFAgent", NULL);
  if (ret != NULL)
    return NEARD_NDEFAGENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardNDEFAgentSkeleton:
 *
 * The #NeardNDEFAgentSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardNDEFAgentSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardNDEFAgentSkeleton.
 */

struct _NeardNDEFAgentSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_ndefagent_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardNDEFAgentSkeleton *skeleton = NEARD_NDEFAGENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_NDEFAGENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_NDEFAGENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_ndefagent_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardNDEFAgentSkeleton *skeleton = NEARD_NDEFAGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_ndefagent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_ndefagent_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardNDEFAgentSkeleton *skeleton = NEARD_NDEFAGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_ndefagent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_ndefagent_skeleton_vtable =
{
  _neard_ndefagent_skeleton_handle_method_call,
  _neard_ndefagent_skeleton_handle_get_property,
  _neard_ndefagent_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_ndefagent_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_ndefagent_interface_info ();
}

static GDBusInterfaceVTable *
neard_ndefagent_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_ndefagent_skeleton_vtable;
}

static GVariant *
neard_ndefagent_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardNDEFAgentSkeleton *skeleton = NEARD_NDEFAGENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_ndefagent_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_ndefagent_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_ndefagent_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_ndefagent_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.NDEFAgent", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
neard_ndefagent_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void neard_ndefagent_skeleton_iface_init (NeardNDEFAgentIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardNDEFAgentSkeleton, neard_ndefagent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardNDEFAgentSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_NDEFAGENT, neard_ndefagent_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardNDEFAgentSkeleton, neard_ndefagent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_NDEFAGENT, neard_ndefagent_skeleton_iface_init));

#endif
static void
neard_ndefagent_skeleton_finalize (GObject *object)
{
  NeardNDEFAgentSkeleton *skeleton = NEARD_NDEFAGENT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_ndefagent_skeleton_parent_class)->finalize (object);
}

static void
neard_ndefagent_skeleton_init (NeardNDEFAgentSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_ndefagent_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_NDEFAGENT_SKELETON, NeardNDEFAgentSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
neard_ndefagent_skeleton_class_init (NeardNDEFAgentSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_ndefagent_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_ndefagent_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_ndefagent_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_ndefagent_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_ndefagent_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardNDEFAgentSkeletonPrivate));
#endif
}

static void
neard_ndefagent_skeleton_iface_init (NeardNDEFAgentIface *iface)
{
}

/**
 * neard_ndefagent_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link>.
 *
 * Returns: (transfer full) (type NeardNDEFAgentSkeleton): The skeleton object.
 */
NeardNDEFAgent *
neard_ndefagent_skeleton_new (void)
{
  return NEARD_NDEFAGENT (g_object_new (NEARD_TYPE_NDEFAGENT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.HandoverAgent
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardHandoverAgent
 * @title: NeardHandoverAgent
 * @short_description: Generated C code for the org.neard.HandoverAgent D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.HandoverAgent ---- */

static const _ExtendedGDBusArgInfo _neard_handover_agent_method_info_request_oob_IN_ARG_values =
{
  {
    -1,
    (gchar *) "values",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_handover_agent_method_info_request_oob_IN_ARG_pointers[] =
{
  &_neard_handover_agent_method_info_request_oob_IN_ARG_values,
  NULL
};

static const _ExtendedGDBusArgInfo _neard_handover_agent_method_info_request_oob_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_handover_agent_method_info_request_oob_OUT_ARG_pointers[] =
{
  &_neard_handover_agent_method_info_request_oob_OUT_ARG_result,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_handover_agent_method_info_request_oob =
{
  {
    -1,
    (gchar *) "RequestOOB",
    (GDBusArgInfo **) &_neard_handover_agent_method_info_request_oob_IN_ARG_pointers,
    (GDBusArgInfo **) &_neard_handover_agent_method_info_request_oob_OUT_ARG_pointers,
    NULL
  },
  "handle-request-oob",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_handover_agent_method_info_push_oob_IN_ARG_values =
{
  {
    -1,
    (gchar *) "values",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_handover_agent_method_info_push_oob_IN_ARG_pointers[] =
{
  &_neard_handover_agent_method_info_push_oob_IN_ARG_values,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_handover_agent_method_info_push_oob =
{
  {
    -1,
    (gchar *) "PushOOB",
    (GDBusArgInfo **) &_neard_handover_agent_method_info_push_oob_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-push-oob",
  FALSE
};

static const _ExtendedGDBusMethodInfo _neard_handover_agent_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_handover_agent_method_info_pointers[] =
{
  &_neard_handover_agent_method_info_request_oob,
  &_neard_handover_agent_method_info_push_oob,
  &_neard_handover_agent_method_info_release,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_handover_agent_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.HandoverAgent",
    (GDBusMethodInfo **) &_neard_handover_agent_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "handover-agent",
};


/**
 * neard_handover_agent_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_handover_agent_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_handover_agent_interface_info.parent_struct;
}

/**
 * neard_handover_agent_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardHandoverAgent interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_handover_agent_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * NeardHandoverAgent:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link>.
 */

/**
 * NeardHandoverAgentIface:
 * @parent_iface: The parent interface.
 * @handle_push_oob: Handler for the #NeardHandoverAgent::handle-push-oob signal.
 * @handle_release: Handler for the #NeardHandoverAgent::handle-release signal.
 * @handle_request_oob: Handler for the #NeardHandoverAgent::handle-request-oob signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link>.
 */

typedef NeardHandoverAgentIface NeardHandoverAgentInterface;
G_DEFINE_INTERFACE (NeardHandoverAgent, neard_handover_agent, G_TYPE_OBJECT);

static void
neard_handover_agent_default_init (NeardHandoverAgentIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardHandoverAgent::handle-request-oob:
   * @object: A #NeardHandoverAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_values: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-HandoverAgent.RequestOOB">RequestOOB()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_handover_agent_complete_request_oob() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-oob",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardHandoverAgentIface, handle_request_oob),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NeardHandoverAgent::handle-push-oob:
   * @object: A #NeardHandoverAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_values: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-HandoverAgent.PushOOB">PushOOB()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_handover_agent_complete_push_oob() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-push-oob",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardHandoverAgentIface, handle_push_oob),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NeardHandoverAgent::handle-release:
   * @object: A #NeardHandoverAgent.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-HandoverAgent.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_handover_agent_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardHandoverAgentIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * neard_handover_agent_call_request_oob:
 * @proxy: A #NeardHandoverAgentProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-HandoverAgent.RequestOOB">RequestOOB()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_handover_agent_call_request_oob_finish() to get the result of the operation.
 *
 * See neard_handover_agent_call_request_oob_sync() for the synchronous, blocking version of this method.
 */
void
neard_handover_agent_call_request_oob (
    NeardHandoverAgent *proxy,
    GVariant *arg_values,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestOOB",
    g_variant_new ("(@a{sv})",
                   arg_values),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_handover_agent_call_request_oob_finish:
 * @proxy: A #NeardHandoverAgentProxy.
 * @out_result: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_handover_agent_call_request_oob().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_handover_agent_call_request_oob().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_handover_agent_call_request_oob_finish (
    NeardHandoverAgent *proxy,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_handover_agent_call_request_oob_sync:
 * @proxy: A #NeardHandoverAgentProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @out_result: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-HandoverAgent.RequestOOB">RequestOOB()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_handover_agent_call_request_oob() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_handover_agent_call_request_oob_sync (
    NeardHandoverAgent *proxy,
    GVariant *arg_values,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestOOB",
    g_variant_new ("(@a{sv})",
                   arg_values),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_handover_agent_call_push_oob:
 * @proxy: A #NeardHandoverAgentProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-HandoverAgent.PushOOB">PushOOB()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_handover_agent_call_push_oob_finish() to get the result of the operation.
 *
 * See neard_handover_agent_call_push_oob_sync() for the synchronous, blocking version of this method.
 */
void
neard_handover_agent_call_push_oob (
    NeardHandoverAgent *proxy,
    GVariant *arg_values,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PushOOB",
    g_variant_new ("(@a{sv})",
                   arg_values),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_handover_agent_call_push_oob_finish:
 * @proxy: A #NeardHandoverAgentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_handover_agent_call_push_oob().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_handover_agent_call_push_oob().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_handover_agent_call_push_oob_finish (
    NeardHandoverAgent *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_handover_agent_call_push_oob_sync:
 * @proxy: A #NeardHandoverAgentProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-HandoverAgent.PushOOB">PushOOB()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_handover_agent_call_push_oob() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_handover_agent_call_push_oob_sync (
    NeardHandoverAgent *proxy,
    GVariant *arg_values,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PushOOB",
    g_variant_new ("(@a{sv})",
                   arg_values),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_handover_agent_call_release:
 * @proxy: A #NeardHandoverAgentProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-HandoverAgent.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_handover_agent_call_release_finish() to get the result of the operation.
 *
 * See neard_handover_agent_call_release_sync() for the synchronous, blocking version of this method.
 */
void
neard_handover_agent_call_release (
    NeardHandoverAgent *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_handover_agent_call_release_finish:
 * @proxy: A #NeardHandoverAgentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_handover_agent_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_handover_agent_call_release().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_handover_agent_call_release_finish (
    NeardHandoverAgent *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_handover_agent_call_release_sync:
 * @proxy: A #NeardHandoverAgentProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-HandoverAgent.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_handover_agent_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_handover_agent_call_release_sync (
    NeardHandoverAgent *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_handover_agent_complete_request_oob:
 * @object: A #NeardHandoverAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-HandoverAgent.RequestOOB">RequestOOB()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_handover_agent_complete_request_oob (
    NeardHandoverAgent *object,
    GDBusMethodInvocation *invocation,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   result));
}

/**
 * neard_handover_agent_complete_push_oob:
 * @object: A #NeardHandoverAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-HandoverAgent.PushOOB">PushOOB()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_handover_agent_complete_push_oob (
    NeardHandoverAgent *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_handover_agent_complete_release:
 * @object: A #NeardHandoverAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-HandoverAgent.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_handover_agent_complete_release (
    NeardHandoverAgent *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardHandoverAgentProxy:
 *
 * The #NeardHandoverAgentProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardHandoverAgentProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardHandoverAgentProxy.
 */

struct _NeardHandoverAgentProxyPrivate
{
  GData *qdata;
};

static void neard_handover_agent_proxy_iface_init (NeardHandoverAgentIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardHandoverAgentProxy, neard_handover_agent_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardHandoverAgentProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_HANDOVER_AGENT, neard_handover_agent_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardHandoverAgentProxy, neard_handover_agent_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_HANDOVER_AGENT, neard_handover_agent_proxy_iface_init));

#endif
static void
neard_handover_agent_proxy_finalize (GObject *object)
{
  NeardHandoverAgentProxy *proxy = NEARD_HANDOVER_AGENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_handover_agent_proxy_parent_class)->finalize (object);
}

static void
neard_handover_agent_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
neard_handover_agent_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
neard_handover_agent_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_handover_agent_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_HANDOVER_AGENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_HANDOVER_AGENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_handover_agent_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardHandoverAgentProxy *proxy = NEARD_HANDOVER_AGENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_handover_agent_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_handover_agent_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
neard_handover_agent_proxy_init (NeardHandoverAgentProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_handover_agent_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_HANDOVER_AGENT_PROXY, NeardHandoverAgentProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_handover_agent_interface_info ());
}

static void
neard_handover_agent_proxy_class_init (NeardHandoverAgentProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_handover_agent_proxy_finalize;
  gobject_class->get_property = neard_handover_agent_proxy_get_property;
  gobject_class->set_property = neard_handover_agent_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_handover_agent_proxy_g_signal;
  proxy_class->g_properties_changed = neard_handover_agent_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardHandoverAgentProxyPrivate));
#endif
}

static void
neard_handover_agent_proxy_iface_init (NeardHandoverAgentIface *iface)
{
}

/**
 * neard_handover_agent_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_handover_agent_proxy_new_finish() to get the result of the operation.
 *
 * See neard_handover_agent_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_handover_agent_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_HANDOVER_AGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.HandoverAgent", NULL);
}

/**
 * neard_handover_agent_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_handover_agent_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_handover_agent_proxy_new().
 *
 * Returns: (transfer full) (type NeardHandoverAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardHandoverAgent *
neard_handover_agent_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_HANDOVER_AGENT (ret);
  else
    return NULL;
}

/**
 * neard_handover_agent_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_handover_agent_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardHandoverAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardHandoverAgent *
neard_handover_agent_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_HANDOVER_AGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.HandoverAgent", NULL);
  if (ret != NULL)
    return NEARD_HANDOVER_AGENT (ret);
  else
    return NULL;
}


/**
 * neard_handover_agent_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_handover_agent_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_handover_agent_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_handover_agent_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_handover_agent_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_HANDOVER_AGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.HandoverAgent", NULL);
}

/**
 * neard_handover_agent_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_handover_agent_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_handover_agent_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardHandoverAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardHandoverAgent *
neard_handover_agent_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_HANDOVER_AGENT (ret);
  else
    return NULL;
}

/**
 * neard_handover_agent_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_handover_agent_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_handover_agent_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardHandoverAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardHandoverAgent *
neard_handover_agent_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_HANDOVER_AGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.HandoverAgent", NULL);
  if (ret != NULL)
    return NEARD_HANDOVER_AGENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardHandoverAgentSkeleton:
 *
 * The #NeardHandoverAgentSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardHandoverAgentSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardHandoverAgentSkeleton.
 */

struct _NeardHandoverAgentSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_handover_agent_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardHandoverAgentSkeleton *skeleton = NEARD_HANDOVER_AGENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_HANDOVER_AGENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_HANDOVER_AGENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_handover_agent_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardHandoverAgentSkeleton *skeleton = NEARD_HANDOVER_AGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_handover_agent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_handover_agent_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardHandoverAgentSkeleton *skeleton = NEARD_HANDOVER_AGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_handover_agent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_handover_agent_skeleton_vtable =
{
  _neard_handover_agent_skeleton_handle_method_call,
  _neard_handover_agent_skeleton_handle_get_property,
  _neard_handover_agent_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_handover_agent_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_handover_agent_interface_info ();
}

static GDBusInterfaceVTable *
neard_handover_agent_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_handover_agent_skeleton_vtable;
}

static GVariant *
neard_handover_agent_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardHandoverAgentSkeleton *skeleton = NEARD_HANDOVER_AGENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_handover_agent_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_handover_agent_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_handover_agent_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_handover_agent_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.HandoverAgent", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
neard_handover_agent_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void neard_handover_agent_skeleton_iface_init (NeardHandoverAgentIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardHandoverAgentSkeleton, neard_handover_agent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardHandoverAgentSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_HANDOVER_AGENT, neard_handover_agent_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardHandoverAgentSkeleton, neard_handover_agent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_HANDOVER_AGENT, neard_handover_agent_skeleton_iface_init));

#endif
static void
neard_handover_agent_skeleton_finalize (GObject *object)
{
  NeardHandoverAgentSkeleton *skeleton = NEARD_HANDOVER_AGENT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_handover_agent_skeleton_parent_class)->finalize (object);
}

static void
neard_handover_agent_skeleton_init (NeardHandoverAgentSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_handover_agent_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_HANDOVER_AGENT_SKELETON, NeardHandoverAgentSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
neard_handover_agent_skeleton_class_init (NeardHandoverAgentSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_handover_agent_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_handover_agent_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_handover_agent_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_handover_agent_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_handover_agent_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardHandoverAgentSkeletonPrivate));
#endif
}

static void
neard_handover_agent_skeleton_iface_init (NeardHandoverAgentIface *iface)
{
}

/**
 * neard_handover_agent_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link>.
 *
 * Returns: (transfer full) (type NeardHandoverAgentSkeleton): The skeleton object.
 */
NeardHandoverAgent *
neard_handover_agent_skeleton_new (void)
{
  return NEARD_HANDOVER_AGENT (g_object_new (NEARD_TYPE_HANDOVER_AGENT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardManager
 * @title: NeardManager
 * @short_description: Generated C code for the org.neard.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.Manager ---- */

static const _ExtendedGDBusArgInfo _neard_manager_method_info_register_handover_agent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_register_handover_agent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_method_info_register_handover_agent_IN_ARG_pointers[] =
{
  &_neard_manager_method_info_register_handover_agent_IN_ARG_path,
  &_neard_manager_method_info_register_handover_agent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_manager_method_info_register_handover_agent =
{
  {
    -1,
    (gchar *) "RegisterHandoverAgent",
    (GDBusArgInfo **) &_neard_manager_method_info_register_handover_agent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-handover-agent",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_unregister_handover_agent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_unregister_handover_agent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_method_info_unregister_handover_agent_IN_ARG_pointers[] =
{
  &_neard_manager_method_info_unregister_handover_agent_IN_ARG_path,
  &_neard_manager_method_info_unregister_handover_agent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_manager_method_info_unregister_handover_agent =
{
  {
    -1,
    (gchar *) "UnregisterHandoverAgent",
    (GDBusArgInfo **) &_neard_manager_method_info_unregister_handover_agent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-handover-agent",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_register_ndefagent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_register_ndefagent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_method_info_register_ndefagent_IN_ARG_pointers[] =
{
  &_neard_manager_method_info_register_ndefagent_IN_ARG_path,
  &_neard_manager_method_info_register_ndefagent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_manager_method_info_register_ndefagent =
{
  {
    -1,
    (gchar *) "RegisterNDEFAgent",
    (GDBusArgInfo **) &_neard_manager_method_info_register_ndefagent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-ndefagent",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_unregister_ndefagent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_method_info_unregister_ndefagent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_method_info_unregister_ndefagent_IN_ARG_pointers[] =
{
  &_neard_manager_method_info_unregister_ndefagent_IN_ARG_path,
  &_neard_manager_method_info_unregister_ndefagent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_manager_method_info_unregister_ndefagent =
{
  {
    -1,
    (gchar *) "UnregisterNDEFAgent",
    (GDBusArgInfo **) &_neard_manager_method_info_unregister_ndefagent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-ndefagent",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_manager_method_info_pointers[] =
{
  &_neard_manager_method_info_register_handover_agent,
  &_neard_manager_method_info_unregister_handover_agent,
  &_neard_manager_method_info_register_ndefagent,
  &_neard_manager_method_info_unregister_ndefagent,
  NULL
};

static const _ExtendedGDBusArgInfo _neard_manager_signal_info_property_changed_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_manager_signal_info_property_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_signal_info_property_changed_ARG_pointers[] =
{
  &_neard_manager_signal_info_property_changed_ARG_name,
  &_neard_manager_signal_info_property_changed_ARG_value,
  NULL
};

static const _ExtendedGDBusSignalInfo _neard_manager_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_neard_manager_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const _ExtendedGDBusArgInfo _neard_manager_signal_info_adapter_added_ARG_adapter =
{
  {
    -1,
    (gchar *) "adapter",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_signal_info_adapter_added_ARG_pointers[] =
{
  &_neard_manager_signal_info_adapter_added_ARG_adapter,
  NULL
};

static const _ExtendedGDBusSignalInfo _neard_manager_signal_info_adapter_added =
{
  {
    -1,
    (gchar *) "AdapterAdded",
    (GDBusArgInfo **) &_neard_manager_signal_info_adapter_added_ARG_pointers,
    NULL
  },
  "adapter-added"
};

static const _ExtendedGDBusArgInfo _neard_manager_signal_info_adapter_removed_ARG_adapter =
{
  {
    -1,
    (gchar *) "adapter",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_manager_signal_info_adapter_removed_ARG_pointers[] =
{
  &_neard_manager_signal_info_adapter_removed_ARG_adapter,
  NULL
};

static const _ExtendedGDBusSignalInfo _neard_manager_signal_info_adapter_removed =
{
  {
    -1,
    (gchar *) "AdapterRemoved",
    (GDBusArgInfo **) &_neard_manager_signal_info_adapter_removed_ARG_pointers,
    NULL
  },
  "adapter-removed"
};

static const _ExtendedGDBusSignalInfo * const _neard_manager_signal_info_pointers[] =
{
  &_neard_manager_signal_info_property_changed,
  &_neard_manager_signal_info_adapter_added,
  &_neard_manager_signal_info_adapter_removed,
  NULL
};

static const _ExtendedGDBusPropertyInfo _neard_manager_property_info_adapters =
{
  {
    -1,
    (gchar *) "Adapters",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "adapters",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _neard_manager_property_info_pointers[] =
{
  &_neard_manager_property_info_adapters,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.Manager",
    (GDBusMethodInfo **) &_neard_manager_method_info_pointers,
    (GDBusSignalInfo **) &_neard_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_neard_manager_property_info_pointers,
    NULL
  },
  "manager",
};


/**
 * neard_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_manager_interface_info.parent_struct;
}

/**
 * neard_manager_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "adapters");
  return property_id_begin - 1;
}



/**
 * NeardManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link>.
 */

/**
 * NeardManagerIface:
 * @parent_iface: The parent interface.
 * @handle_register_handover_agent: Handler for the #NeardManager::handle-register-handover-agent signal.
 * @handle_register_ndefagent: Handler for the #NeardManager::handle-register-ndefagent signal.
 * @handle_unregister_handover_agent: Handler for the #NeardManager::handle-unregister-handover-agent signal.
 * @handle_unregister_ndefagent: Handler for the #NeardManager::handle-unregister-ndefagent signal.
 * @get_adapters: Getter for the #NeardManager:adapters property.
 * @adapter_added: Handler for the #NeardManager::adapter-added signal.
 * @adapter_removed: Handler for the #NeardManager::adapter-removed signal.
 * @property_changed: Handler for the #NeardManager::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link>.
 */

typedef NeardManagerIface NeardManagerInterface;
G_DEFINE_INTERFACE (NeardManager, neard_manager, G_TYPE_OBJECT);

static void
neard_manager_default_init (NeardManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardManager::handle-register-handover-agent:
   * @object: A #NeardManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Manager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_manager_complete_register_handover_agent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-handover-agent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, handle_register_handover_agent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NeardManager::handle-unregister-handover-agent:
   * @object: A #NeardManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Manager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_manager_complete_unregister_handover_agent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-handover-agent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, handle_unregister_handover_agent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NeardManager::handle-register-ndefagent:
   * @object: A #NeardManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Manager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_manager_complete_register_ndefagent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-ndefagent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, handle_register_ndefagent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NeardManager::handle-unregister-ndefagent:
   * @object: A #NeardManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Manager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_manager_complete_unregister_ndefagent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-ndefagent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, handle_unregister_ndefagent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * NeardManager::property-changed:
   * @object: A #NeardManager.
   * @arg_name: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-neard-Manager.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("property-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, property_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * NeardManager::adapter-added:
   * @object: A #NeardManager.
   * @arg_adapter: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-neard-Manager.AdapterAdded">"AdapterAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("adapter-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, adapter_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * NeardManager::adapter-removed:
   * @object: A #NeardManager.
   * @arg_adapter: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-neard-Manager.AdapterRemoved">"AdapterRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("adapter-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardManagerIface, adapter_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * NeardManager:adapters:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Manager.Adapters">"Adapters"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("adapters", "Adapters", "Adapters", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * neard_manager_get_adapters: (skip)
 * @object: A #NeardManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Manager.Adapters">"Adapters"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_manager_dup_adapters() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
neard_manager_get_adapters (NeardManager *object)
{
  return NEARD_MANAGER_GET_IFACE (object)->get_adapters (object);
}

/**
 * neard_manager_dup_adapters: (skip)
 * @object: A #NeardManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Manager.Adapters">"Adapters"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
neard_manager_dup_adapters (NeardManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "adapters", &value, NULL);
  return value;
}

/**
 * neard_manager_set_adapters: (skip)
 * @object: A #NeardManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Manager.Adapters">"Adapters"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_manager_set_adapters (NeardManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "adapters", value, NULL);
}

/**
 * neard_manager_emit_property_changed:
 * @object: A #NeardManager.
 * @arg_name: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-neard-Manager.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
neard_manager_emit_property_changed (
    NeardManager *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  g_signal_emit_by_name (object, "property-changed", arg_name, arg_value);
}

/**
 * neard_manager_emit_adapter_added:
 * @object: A #NeardManager.
 * @arg_adapter: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-neard-Manager.AdapterAdded">"AdapterAdded"</link> D-Bus signal.
 */
void
neard_manager_emit_adapter_added (
    NeardManager *object,
    const gchar *arg_adapter)
{
  g_signal_emit_by_name (object, "adapter-added", arg_adapter);
}

/**
 * neard_manager_emit_adapter_removed:
 * @object: A #NeardManager.
 * @arg_adapter: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-neard-Manager.AdapterRemoved">"AdapterRemoved"</link> D-Bus signal.
 */
void
neard_manager_emit_adapter_removed (
    NeardManager *object,
    const gchar *arg_adapter)
{
  g_signal_emit_by_name (object, "adapter-removed", arg_adapter);
}

/**
 * neard_manager_call_register_handover_agent:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Manager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_manager_call_register_handover_agent_finish() to get the result of the operation.
 *
 * See neard_manager_call_register_handover_agent_sync() for the synchronous, blocking version of this method.
 */
void
neard_manager_call_register_handover_agent (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_manager_call_register_handover_agent_finish:
 * @proxy: A #NeardManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_manager_call_register_handover_agent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_manager_call_register_handover_agent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_register_handover_agent_finish (
    NeardManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_register_handover_agent_sync:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Manager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_manager_call_register_handover_agent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_register_handover_agent_sync (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_unregister_handover_agent:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Manager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_manager_call_unregister_handover_agent_finish() to get the result of the operation.
 *
 * See neard_manager_call_unregister_handover_agent_sync() for the synchronous, blocking version of this method.
 */
void
neard_manager_call_unregister_handover_agent (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_manager_call_unregister_handover_agent_finish:
 * @proxy: A #NeardManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_manager_call_unregister_handover_agent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_manager_call_unregister_handover_agent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_unregister_handover_agent_finish (
    NeardManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_unregister_handover_agent_sync:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Manager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_manager_call_unregister_handover_agent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_unregister_handover_agent_sync (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_register_ndefagent:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Manager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_manager_call_register_ndefagent_finish() to get the result of the operation.
 *
 * See neard_manager_call_register_ndefagent_sync() for the synchronous, blocking version of this method.
 */
void
neard_manager_call_register_ndefagent (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_manager_call_register_ndefagent_finish:
 * @proxy: A #NeardManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_manager_call_register_ndefagent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_manager_call_register_ndefagent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_register_ndefagent_finish (
    NeardManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_register_ndefagent_sync:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Manager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_manager_call_register_ndefagent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_register_ndefagent_sync (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_unregister_ndefagent:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Manager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_manager_call_unregister_ndefagent_finish() to get the result of the operation.
 *
 * See neard_manager_call_unregister_ndefagent_sync() for the synchronous, blocking version of this method.
 */
void
neard_manager_call_unregister_ndefagent (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_manager_call_unregister_ndefagent_finish:
 * @proxy: A #NeardManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_manager_call_unregister_ndefagent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_manager_call_unregister_ndefagent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_unregister_ndefagent_finish (
    NeardManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_call_unregister_ndefagent_sync:
 * @proxy: A #NeardManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Manager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_manager_call_unregister_ndefagent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_manager_call_unregister_ndefagent_sync (
    NeardManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_manager_complete_register_handover_agent:
 * @object: A #NeardManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Manager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_manager_complete_register_handover_agent (
    NeardManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_manager_complete_unregister_handover_agent:
 * @object: A #NeardManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Manager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_manager_complete_unregister_handover_agent (
    NeardManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_manager_complete_register_ndefagent:
 * @object: A #NeardManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Manager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_manager_complete_register_ndefagent (
    NeardManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_manager_complete_unregister_ndefagent:
 * @object: A #NeardManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Manager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_manager_complete_unregister_ndefagent (
    NeardManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardManagerProxy:
 *
 * The #NeardManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardManagerProxy.
 */

struct _NeardManagerProxyPrivate
{
  GData *qdata;
};

static void neard_manager_proxy_iface_init (NeardManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardManagerProxy, neard_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardManagerProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_MANAGER, neard_manager_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardManagerProxy, neard_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_MANAGER, neard_manager_proxy_iface_init));

#endif
static void
neard_manager_proxy_finalize (GObject *object)
{
  NeardManagerProxy *proxy = NEARD_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_manager_proxy_parent_class)->finalize (object);
}

static void
neard_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = _neard_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
neard_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.neard.Manager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
neard_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = _neard_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.neard.Manager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) neard_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
neard_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardManagerProxy *proxy = NEARD_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
neard_manager_proxy_get_adapters (NeardManager *object)
{
  NeardManagerProxy *proxy = NEARD_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Adapters");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
neard_manager_proxy_init (NeardManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_MANAGER_PROXY, NeardManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_manager_interface_info ());
}

static void
neard_manager_proxy_class_init (NeardManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_manager_proxy_finalize;
  gobject_class->get_property = neard_manager_proxy_get_property;
  gobject_class->set_property = neard_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_manager_proxy_g_signal;
  proxy_class->g_properties_changed = neard_manager_proxy_g_properties_changed;

  neard_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardManagerProxyPrivate));
#endif
}

static void
neard_manager_proxy_iface_init (NeardManagerIface *iface)
{
  iface->get_adapters = neard_manager_proxy_get_adapters;
}

/**
 * neard_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_manager_proxy_new_finish() to get the result of the operation.
 *
 * See neard_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Manager", NULL);
}

/**
 * neard_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_manager_proxy_new().
 *
 * Returns: (transfer full) (type NeardManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardManager *
neard_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_MANAGER (ret);
  else
    return NULL;
}

/**
 * neard_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardManager *
neard_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Manager", NULL);
  if (ret != NULL)
    return NEARD_MANAGER (ret);
  else
    return NULL;
}


/**
 * neard_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Manager", NULL);
}

/**
 * neard_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardManager *
neard_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_MANAGER (ret);
  else
    return NULL;
}

/**
 * neard_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardManager *
neard_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Manager", NULL);
  if (ret != NULL)
    return NEARD_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardManagerSkeleton:
 *
 * The #NeardManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardManagerSkeleton.
 */

struct _NeardManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_manager_skeleton_vtable =
{
  _neard_manager_skeleton_handle_method_call,
  _neard_manager_skeleton_handle_get_property,
  _neard_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_manager_interface_info ();
}

static GDBusInterfaceVTable *
neard_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_manager_skeleton_vtable;
}

static GVariant *
neard_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _neard_manager_emit_changed (gpointer user_data);

static void
neard_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _neard_manager_emit_changed (skeleton);
}

static void
_neard_manager_on_signal_property_changed (
    NeardManager *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_name,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Manager", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_neard_manager_on_signal_adapter_added (
    NeardManager *object,
    const gchar *arg_adapter)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_adapter));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Manager", "AdapterAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_neard_manager_on_signal_adapter_removed (
    NeardManager *object,
    const gchar *arg_adapter)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_adapter));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Manager", "AdapterRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void neard_manager_skeleton_iface_init (NeardManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardManagerSkeleton, neard_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_MANAGER, neard_manager_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardManagerSkeleton, neard_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_MANAGER, neard_manager_skeleton_iface_init));

#endif
static void
neard_manager_skeleton_finalize (GObject *object)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_manager_skeleton_parent_class)->finalize (object);
}

static void
neard_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_neard_manager_emit_changed (gpointer user_data)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.neard.Manager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_neard_manager_schedule_emit_changed (NeardManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
neard_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _neard_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
neard_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _neard_manager_schedule_emit_changed (skeleton, _neard_manager_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
neard_manager_skeleton_init (NeardManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_MANAGER_SKELETON, NeardManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
}

static const gchar *const *
neard_manager_skeleton_get_adapters (NeardManager *object)
{
  NeardManagerSkeleton *skeleton = NEARD_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
neard_manager_skeleton_class_init (NeardManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_manager_skeleton_finalize;
  gobject_class->get_property = neard_manager_skeleton_get_property;
  gobject_class->set_property = neard_manager_skeleton_set_property;
  gobject_class->notify       = neard_manager_skeleton_notify;


  neard_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardManagerSkeletonPrivate));
#endif
}

static void
neard_manager_skeleton_iface_init (NeardManagerIface *iface)
{
  iface->property_changed = _neard_manager_on_signal_property_changed;
  iface->adapter_added = _neard_manager_on_signal_adapter_added;
  iface->adapter_removed = _neard_manager_on_signal_adapter_removed;
  iface->get_adapters = neard_manager_skeleton_get_adapters;
}

/**
 * neard_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link>.
 *
 * Returns: (transfer full) (type NeardManagerSkeleton): The skeleton object.
 */
NeardManager *
neard_manager_skeleton_new (void)
{
  return NEARD_MANAGER (g_object_new (NEARD_TYPE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.AgentManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardAgentManager
 * @title: NeardAgentManager
 * @short_description: Generated C code for the org.neard.AgentManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.AgentManager ---- */

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_register_handover_agent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_register_handover_agent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_agent_manager_method_info_register_handover_agent_IN_ARG_pointers[] =
{
  &_neard_agent_manager_method_info_register_handover_agent_IN_ARG_path,
  &_neard_agent_manager_method_info_register_handover_agent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_agent_manager_method_info_register_handover_agent =
{
  {
    -1,
    (gchar *) "RegisterHandoverAgent",
    (GDBusArgInfo **) &_neard_agent_manager_method_info_register_handover_agent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-handover-agent",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_unregister_handover_agent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_unregister_handover_agent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_agent_manager_method_info_unregister_handover_agent_IN_ARG_pointers[] =
{
  &_neard_agent_manager_method_info_unregister_handover_agent_IN_ARG_path,
  &_neard_agent_manager_method_info_unregister_handover_agent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_agent_manager_method_info_unregister_handover_agent =
{
  {
    -1,
    (gchar *) "UnregisterHandoverAgent",
    (GDBusArgInfo **) &_neard_agent_manager_method_info_unregister_handover_agent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-handover-agent",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_register_ndefagent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_register_ndefagent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_agent_manager_method_info_register_ndefagent_IN_ARG_pointers[] =
{
  &_neard_agent_manager_method_info_register_ndefagent_IN_ARG_path,
  &_neard_agent_manager_method_info_register_ndefagent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_agent_manager_method_info_register_ndefagent =
{
  {
    -1,
    (gchar *) "RegisterNDEFAgent",
    (GDBusArgInfo **) &_neard_agent_manager_method_info_register_ndefagent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-ndefagent",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_unregister_ndefagent_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_agent_manager_method_info_unregister_ndefagent_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_agent_manager_method_info_unregister_ndefagent_IN_ARG_pointers[] =
{
  &_neard_agent_manager_method_info_unregister_ndefagent_IN_ARG_path,
  &_neard_agent_manager_method_info_unregister_ndefagent_IN_ARG_type,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_agent_manager_method_info_unregister_ndefagent =
{
  {
    -1,
    (gchar *) "UnregisterNDEFAgent",
    (GDBusArgInfo **) &_neard_agent_manager_method_info_unregister_ndefagent_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-ndefagent",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_agent_manager_method_info_pointers[] =
{
  &_neard_agent_manager_method_info_register_handover_agent,
  &_neard_agent_manager_method_info_unregister_handover_agent,
  &_neard_agent_manager_method_info_register_ndefagent,
  &_neard_agent_manager_method_info_unregister_ndefagent,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_agent_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.AgentManager",
    (GDBusMethodInfo **) &_neard_agent_manager_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "agent-manager",
};


/**
 * neard_agent_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_agent_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_agent_manager_interface_info.parent_struct;
}

/**
 * neard_agent_manager_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardAgentManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_agent_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * NeardAgentManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link>.
 */

/**
 * NeardAgentManagerIface:
 * @parent_iface: The parent interface.
 * @handle_register_handover_agent: Handler for the #NeardAgentManager::handle-register-handover-agent signal.
 * @handle_register_ndefagent: Handler for the #NeardAgentManager::handle-register-ndefagent signal.
 * @handle_unregister_handover_agent: Handler for the #NeardAgentManager::handle-unregister-handover-agent signal.
 * @handle_unregister_ndefagent: Handler for the #NeardAgentManager::handle-unregister-ndefagent signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link>.
 */

typedef NeardAgentManagerIface NeardAgentManagerInterface;
G_DEFINE_INTERFACE (NeardAgentManager, neard_agent_manager, G_TYPE_OBJECT);

static void
neard_agent_manager_default_init (NeardAgentManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardAgentManager::handle-register-handover-agent:
   * @object: A #NeardAgentManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-AgentManager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_agent_manager_complete_register_handover_agent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-handover-agent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAgentManagerIface, handle_register_handover_agent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NeardAgentManager::handle-unregister-handover-agent:
   * @object: A #NeardAgentManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_agent_manager_complete_unregister_handover_agent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-handover-agent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAgentManagerIface, handle_unregister_handover_agent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NeardAgentManager::handle-register-ndefagent:
   * @object: A #NeardAgentManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-AgentManager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_agent_manager_complete_register_ndefagent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-ndefagent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAgentManagerIface, handle_register_ndefagent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NeardAgentManager::handle-unregister-ndefagent:
   * @object: A #NeardAgentManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_agent_manager_complete_unregister_ndefagent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-ndefagent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardAgentManagerIface, handle_unregister_ndefagent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * neard_agent_manager_call_register_handover_agent:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_agent_manager_call_register_handover_agent_finish() to get the result of the operation.
 *
 * See neard_agent_manager_call_register_handover_agent_sync() for the synchronous, blocking version of this method.
 */
void
neard_agent_manager_call_register_handover_agent (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_agent_manager_call_register_handover_agent_finish:
 * @proxy: A #NeardAgentManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_agent_manager_call_register_handover_agent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_agent_manager_call_register_handover_agent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_register_handover_agent_finish (
    NeardAgentManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_register_handover_agent_sync:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_agent_manager_call_register_handover_agent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_register_handover_agent_sync (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_unregister_handover_agent:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_agent_manager_call_unregister_handover_agent_finish() to get the result of the operation.
 *
 * See neard_agent_manager_call_unregister_handover_agent_sync() for the synchronous, blocking version of this method.
 */
void
neard_agent_manager_call_unregister_handover_agent (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_agent_manager_call_unregister_handover_agent_finish:
 * @proxy: A #NeardAgentManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_agent_manager_call_unregister_handover_agent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_agent_manager_call_unregister_handover_agent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_unregister_handover_agent_finish (
    NeardAgentManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_unregister_handover_agent_sync:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_agent_manager_call_unregister_handover_agent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_unregister_handover_agent_sync (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterHandoverAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_register_ndefagent:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_agent_manager_call_register_ndefagent_finish() to get the result of the operation.
 *
 * See neard_agent_manager_call_register_ndefagent_sync() for the synchronous, blocking version of this method.
 */
void
neard_agent_manager_call_register_ndefagent (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_agent_manager_call_register_ndefagent_finish:
 * @proxy: A #NeardAgentManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_agent_manager_call_register_ndefagent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_agent_manager_call_register_ndefagent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_register_ndefagent_finish (
    NeardAgentManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_register_ndefagent_sync:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_agent_manager_call_register_ndefagent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_register_ndefagent_sync (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_unregister_ndefagent:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_agent_manager_call_unregister_ndefagent_finish() to get the result of the operation.
 *
 * See neard_agent_manager_call_unregister_ndefagent_sync() for the synchronous, blocking version of this method.
 */
void
neard_agent_manager_call_unregister_ndefagent (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_agent_manager_call_unregister_ndefagent_finish:
 * @proxy: A #NeardAgentManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_agent_manager_call_unregister_ndefagent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_agent_manager_call_unregister_ndefagent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_unregister_ndefagent_finish (
    NeardAgentManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_call_unregister_ndefagent_sync:
 * @proxy: A #NeardAgentManagerProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_agent_manager_call_unregister_ndefagent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_agent_manager_call_unregister_ndefagent_sync (
    NeardAgentManager *proxy,
    const gchar *arg_path,
    const gchar *arg_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterNDEFAgent",
    g_variant_new ("(os)",
                   arg_path,
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_agent_manager_complete_register_handover_agent:
 * @object: A #NeardAgentManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-AgentManager.RegisterHandoverAgent">RegisterHandoverAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_agent_manager_complete_register_handover_agent (
    NeardAgentManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_agent_manager_complete_unregister_handover_agent:
 * @object: A #NeardAgentManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterHandoverAgent">UnregisterHandoverAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_agent_manager_complete_unregister_handover_agent (
    NeardAgentManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_agent_manager_complete_register_ndefagent:
 * @object: A #NeardAgentManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-AgentManager.RegisterNDEFAgent">RegisterNDEFAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_agent_manager_complete_register_ndefagent (
    NeardAgentManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_agent_manager_complete_unregister_ndefagent:
 * @object: A #NeardAgentManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-AgentManager.UnregisterNDEFAgent">UnregisterNDEFAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_agent_manager_complete_unregister_ndefagent (
    NeardAgentManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardAgentManagerProxy:
 *
 * The #NeardAgentManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardAgentManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardAgentManagerProxy.
 */

struct _NeardAgentManagerProxyPrivate
{
  GData *qdata;
};

static void neard_agent_manager_proxy_iface_init (NeardAgentManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardAgentManagerProxy, neard_agent_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardAgentManagerProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_AGENT_MANAGER, neard_agent_manager_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardAgentManagerProxy, neard_agent_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_AGENT_MANAGER, neard_agent_manager_proxy_iface_init));

#endif
static void
neard_agent_manager_proxy_finalize (GObject *object)
{
  NeardAgentManagerProxy *proxy = NEARD_AGENT_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_agent_manager_proxy_parent_class)->finalize (object);
}

static void
neard_agent_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
neard_agent_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
neard_agent_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_agent_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_AGENT_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_AGENT_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_agent_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardAgentManagerProxy *proxy = NEARD_AGENT_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_agent_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_agent_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
neard_agent_manager_proxy_init (NeardAgentManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_agent_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_AGENT_MANAGER_PROXY, NeardAgentManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_agent_manager_interface_info ());
}

static void
neard_agent_manager_proxy_class_init (NeardAgentManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_agent_manager_proxy_finalize;
  gobject_class->get_property = neard_agent_manager_proxy_get_property;
  gobject_class->set_property = neard_agent_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_agent_manager_proxy_g_signal;
  proxy_class->g_properties_changed = neard_agent_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardAgentManagerProxyPrivate));
#endif
}

static void
neard_agent_manager_proxy_iface_init (NeardAgentManagerIface *iface)
{
}

/**
 * neard_agent_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_agent_manager_proxy_new_finish() to get the result of the operation.
 *
 * See neard_agent_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_agent_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_AGENT_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.AgentManager", NULL);
}

/**
 * neard_agent_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_agent_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_agent_manager_proxy_new().
 *
 * Returns: (transfer full) (type NeardAgentManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAgentManager *
neard_agent_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_AGENT_MANAGER (ret);
  else
    return NULL;
}

/**
 * neard_agent_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_agent_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardAgentManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAgentManager *
neard_agent_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_AGENT_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.AgentManager", NULL);
  if (ret != NULL)
    return NEARD_AGENT_MANAGER (ret);
  else
    return NULL;
}


/**
 * neard_agent_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_agent_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_agent_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_agent_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_agent_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_AGENT_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.AgentManager", NULL);
}

/**
 * neard_agent_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_agent_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_agent_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardAgentManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAgentManager *
neard_agent_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_AGENT_MANAGER (ret);
  else
    return NULL;
}

/**
 * neard_agent_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_agent_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_agent_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardAgentManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardAgentManager *
neard_agent_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_AGENT_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.AgentManager", NULL);
  if (ret != NULL)
    return NEARD_AGENT_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardAgentManagerSkeleton:
 *
 * The #NeardAgentManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardAgentManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardAgentManagerSkeleton.
 */

struct _NeardAgentManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_agent_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardAgentManagerSkeleton *skeleton = NEARD_AGENT_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_AGENT_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_AGENT_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_agent_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardAgentManagerSkeleton *skeleton = NEARD_AGENT_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_agent_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_agent_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardAgentManagerSkeleton *skeleton = NEARD_AGENT_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_agent_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_agent_manager_skeleton_vtable =
{
  _neard_agent_manager_skeleton_handle_method_call,
  _neard_agent_manager_skeleton_handle_get_property,
  _neard_agent_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_agent_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_agent_manager_interface_info ();
}

static GDBusInterfaceVTable *
neard_agent_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_agent_manager_skeleton_vtable;
}

static GVariant *
neard_agent_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardAgentManagerSkeleton *skeleton = NEARD_AGENT_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_agent_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_agent_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_agent_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_agent_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.AgentManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
neard_agent_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void neard_agent_manager_skeleton_iface_init (NeardAgentManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardAgentManagerSkeleton, neard_agent_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardAgentManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_AGENT_MANAGER, neard_agent_manager_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardAgentManagerSkeleton, neard_agent_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_AGENT_MANAGER, neard_agent_manager_skeleton_iface_init));

#endif
static void
neard_agent_manager_skeleton_finalize (GObject *object)
{
  NeardAgentManagerSkeleton *skeleton = NEARD_AGENT_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_agent_manager_skeleton_parent_class)->finalize (object);
}

static void
neard_agent_manager_skeleton_init (NeardAgentManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_agent_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_AGENT_MANAGER_SKELETON, NeardAgentManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
neard_agent_manager_skeleton_class_init (NeardAgentManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_agent_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_agent_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_agent_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_agent_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_agent_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardAgentManagerSkeletonPrivate));
#endif
}

static void
neard_agent_manager_skeleton_iface_init (NeardAgentManagerIface *iface)
{
}

/**
 * neard_agent_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link>.
 *
 * Returns: (transfer full) (type NeardAgentManagerSkeleton): The skeleton object.
 */
NeardAgentManager *
neard_agent_manager_skeleton_new (void)
{
  return NEARD_AGENT_MANAGER (g_object_new (NEARD_TYPE_AGENT_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.Tag
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardTag
 * @title: NeardTag
 * @short_description: Generated C code for the org.neard.Tag D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.Tag ---- */

static const _ExtendedGDBusArgInfo _neard_tag_method_info_write_IN_ARG_attributes =
{
  {
    -1,
    (gchar *) "attributes",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_tag_method_info_write_IN_ARG_pointers[] =
{
  &_neard_tag_method_info_write_IN_ARG_attributes,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_tag_method_info_write =
{
  {
    -1,
    (gchar *) "Write",
    (GDBusArgInfo **) &_neard_tag_method_info_write_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-write",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_tag_method_info_get_raw_ndef_OUT_ARG_NDEF =
{
  {
    -1,
    (gchar *) "NDEF",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const _ExtendedGDBusArgInfo * const _neard_tag_method_info_get_raw_ndef_OUT_ARG_pointers[] =
{
  &_neard_tag_method_info_get_raw_ndef_OUT_ARG_NDEF,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_tag_method_info_get_raw_ndef =
{
  {
    -1,
    (gchar *) "GetRawNDEF",
    NULL,
    (GDBusArgInfo **) &_neard_tag_method_info_get_raw_ndef_OUT_ARG_pointers,
    NULL
  },
  "handle-get-raw-ndef",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_tag_method_info_pointers[] =
{
  &_neard_tag_method_info_write,
  &_neard_tag_method_info_get_raw_ndef,
  NULL
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_protocol =
{
  {
    -1,
    (gchar *) "Protocol",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "protocol",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_read_only =
{
  {
    -1,
    (gchar *) "ReadOnly",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "read-only",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_adapter =
{
  {
    -1,
    (gchar *) "Adapter",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "adapter",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_records =
{
  {
    -1,
    (gchar *) "Records",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "records",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_iso14443a_uid =
{
  {
    -1,
    (gchar *) "Iso14443aUid",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "iso14443a-uid",
  TRUE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_iso14443a_atqa =
{
  {
    -1,
    (gchar *) "Iso14443aAtqa",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "iso14443a-atqa",
  TRUE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_iso14443a_sak =
{
  {
    -1,
    (gchar *) "Iso14443aSak",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "iso14443a-sak",
  TRUE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_felica_manufacturer =
{
  {
    -1,
    (gchar *) "FelicaManufacturer",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "felica-manufacturer",
  TRUE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_felica_cid =
{
  {
    -1,
    (gchar *) "FelicaCid",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "felica-cid",
  TRUE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_felica_ic =
{
  {
    -1,
    (gchar *) "FelicaIc",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "felica-ic",
  TRUE
};

static const _ExtendedGDBusPropertyInfo _neard_tag_property_info_felica_max_resp_times =
{
  {
    -1,
    (gchar *) "FelicaMaxRespTimes",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "felica-max-resp-times",
  TRUE
};

static const _ExtendedGDBusPropertyInfo * const _neard_tag_property_info_pointers[] =
{
  &_neard_tag_property_info_name,
  &_neard_tag_property_info_type_,
  &_neard_tag_property_info_protocol,
  &_neard_tag_property_info_read_only,
  &_neard_tag_property_info_adapter,
  &_neard_tag_property_info_records,
  &_neard_tag_property_info_iso14443a_uid,
  &_neard_tag_property_info_iso14443a_atqa,
  &_neard_tag_property_info_iso14443a_sak,
  &_neard_tag_property_info_felica_manufacturer,
  &_neard_tag_property_info_felica_cid,
  &_neard_tag_property_info_felica_ic,
  &_neard_tag_property_info_felica_max_resp_times,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_tag_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.Tag",
    (GDBusMethodInfo **) &_neard_tag_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_neard_tag_property_info_pointers,
    NULL
  },
  "tag",
};


/**
 * neard_tag_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_tag_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_tag_interface_info.parent_struct;
}

/**
 * neard_tag_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardTag interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_tag_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "type");
  g_object_class_override_property (klass, property_id_begin++, "protocol");
  g_object_class_override_property (klass, property_id_begin++, "read-only");
  g_object_class_override_property (klass, property_id_begin++, "adapter");
  g_object_class_override_property (klass, property_id_begin++, "records");
  g_object_class_override_property (klass, property_id_begin++, "iso14443a-uid");
  g_object_class_override_property (klass, property_id_begin++, "iso14443a-atqa");
  g_object_class_override_property (klass, property_id_begin++, "iso14443a-sak");
  g_object_class_override_property (klass, property_id_begin++, "felica-manufacturer");
  g_object_class_override_property (klass, property_id_begin++, "felica-cid");
  g_object_class_override_property (klass, property_id_begin++, "felica-ic");
  g_object_class_override_property (klass, property_id_begin++, "felica-max-resp-times");
  return property_id_begin - 1;
}



/**
 * NeardTag:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link>.
 */

/**
 * NeardTagIface:
 * @parent_iface: The parent interface.
 * @handle_get_raw_ndef: Handler for the #NeardTag::handle-get-raw-ndef signal.
 * @handle_write: Handler for the #NeardTag::handle-write signal.
 * @get_adapter: Getter for the #NeardTag:adapter property.
 * @get_felica_cid: Getter for the #NeardTag:felica-cid property.
 * @get_felica_ic: Getter for the #NeardTag:felica-ic property.
 * @get_felica_manufacturer: Getter for the #NeardTag:felica-manufacturer property.
 * @get_felica_max_resp_times: Getter for the #NeardTag:felica-max-resp-times property.
 * @get_iso14443a_atqa: Getter for the #NeardTag:iso14443a-atqa property.
 * @get_iso14443a_sak: Getter for the #NeardTag:iso14443a-sak property.
 * @get_iso14443a_uid: Getter for the #NeardTag:iso14443a-uid property.
 * @get_name: Getter for the #NeardTag:name property.
 * @get_protocol: Getter for the #NeardTag:protocol property.
 * @get_read_only: Getter for the #NeardTag:read-only property.
 * @get_records: Getter for the #NeardTag:records property.
 * @get_type_: Getter for the #NeardTag:type property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link>.
 */

typedef NeardTagIface NeardTagInterface;
G_DEFINE_INTERFACE (NeardTag, neard_tag, G_TYPE_OBJECT);

static void
neard_tag_default_init (NeardTagIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardTag::handle-write:
   * @object: A #NeardTag.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_attributes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Tag.Write">Write()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_tag_complete_write() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-write",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardTagIface, handle_write),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NeardTag::handle-get-raw-ndef:
   * @object: A #NeardTag.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Tag.GetRawNDEF">GetRawNDEF()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_tag_complete_get_raw_ndef() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-raw-ndef",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardTagIface, handle_get_raw_ndef),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * NeardTag:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:protocol:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Protocol">"Protocol"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("protocol", "Protocol", "Protocol", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:read-only:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.ReadOnly">"ReadOnly"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("read-only", "ReadOnly", "ReadOnly", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:adapter:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Adapter">"Adapter"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("adapter", "Adapter", "Adapter", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:records:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Records">"Records"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("records", "Records", "Records", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:iso14443a-uid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Iso14443aUid">"Iso14443aUid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("iso14443a-uid", "Iso14443aUid", "Iso14443aUid", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:iso14443a-atqa:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Iso14443aAtqa">"Iso14443aAtqa"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("iso14443a-atqa", "Iso14443aAtqa", "Iso14443aAtqa", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:iso14443a-sak:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.Iso14443aSak">"Iso14443aSak"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("iso14443a-sak", "Iso14443aSak", "Iso14443aSak", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:felica-manufacturer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.FelicaManufacturer">"FelicaManufacturer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("felica-manufacturer", "FelicaManufacturer", "FelicaManufacturer", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:felica-cid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.FelicaCid">"FelicaCid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("felica-cid", "FelicaCid", "FelicaCid", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:felica-ic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.FelicaIc">"FelicaIc"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("felica-ic", "FelicaIc", "FelicaIc", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardTag:felica-max-resp-times:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Tag.FelicaMaxRespTimes">"FelicaMaxRespTimes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("felica-max-resp-times", "FelicaMaxRespTimes", "FelicaMaxRespTimes", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * neard_tag_get_name: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_name() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_tag_get_name (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_name (object);
}

/**
 * neard_tag_dup_name: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_tag_dup_name (NeardTag *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * neard_tag_set_name: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_name (NeardTag *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * neard_tag_get_type_: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_type_() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_tag_get_type_ (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_type_ (object);
}

/**
 * neard_tag_dup_type_: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_tag_dup_type_ (NeardTag *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * neard_tag_set_type_: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_type_ (NeardTag *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * neard_tag_get_protocol: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Protocol">"Protocol"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_protocol() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_tag_get_protocol (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_protocol (object);
}

/**
 * neard_tag_dup_protocol: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Protocol">"Protocol"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_tag_dup_protocol (NeardTag *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "protocol", &value, NULL);
  return value;
}

/**
 * neard_tag_set_protocol: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Protocol">"Protocol"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_protocol (NeardTag *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "protocol", value, NULL);
}

/**
 * neard_tag_get_read_only: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.ReadOnly">"ReadOnly"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
neard_tag_get_read_only (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_read_only (object);
}

/**
 * neard_tag_set_read_only: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.ReadOnly">"ReadOnly"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_read_only (NeardTag *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "read-only", value, NULL);
}

/**
 * neard_tag_get_adapter: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Adapter">"Adapter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_adapter() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_tag_get_adapter (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_adapter (object);
}

/**
 * neard_tag_dup_adapter: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Adapter">"Adapter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_tag_dup_adapter (NeardTag *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "adapter", &value, NULL);
  return value;
}

/**
 * neard_tag_set_adapter: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Adapter">"Adapter"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_adapter (NeardTag *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "adapter", value, NULL);
}

/**
 * neard_tag_get_records: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Records">"Records"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_records() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
neard_tag_get_records (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_records (object);
}

/**
 * neard_tag_dup_records: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Records">"Records"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
neard_tag_dup_records (NeardTag *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "records", &value, NULL);
  return value;
}

/**
 * neard_tag_set_records: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Records">"Records"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_records (NeardTag *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "records", value, NULL);
}

/**
 * neard_tag_get_iso14443a_uid: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Iso14443aUid">"Iso14443aUid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_iso14443a_uid() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_iso14443a_uid (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_iso14443a_uid (object);
}

/**
 * neard_tag_dup_iso14443a_uid: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Iso14443aUid">"Iso14443aUid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_iso14443a_uid (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "iso14443a-uid", &value, NULL);
  return value;
}

/**
 * neard_tag_set_iso14443a_uid: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Iso14443aUid">"Iso14443aUid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_iso14443a_uid (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "iso14443a-uid", value, NULL);
}

/**
 * neard_tag_get_iso14443a_atqa: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Iso14443aAtqa">"Iso14443aAtqa"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_iso14443a_atqa() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_iso14443a_atqa (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_iso14443a_atqa (object);
}

/**
 * neard_tag_dup_iso14443a_atqa: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Iso14443aAtqa">"Iso14443aAtqa"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_iso14443a_atqa (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "iso14443a-atqa", &value, NULL);
  return value;
}

/**
 * neard_tag_set_iso14443a_atqa: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Iso14443aAtqa">"Iso14443aAtqa"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_iso14443a_atqa (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "iso14443a-atqa", value, NULL);
}

/**
 * neard_tag_get_iso14443a_sak: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.Iso14443aSak">"Iso14443aSak"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_iso14443a_sak() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_iso14443a_sak (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_iso14443a_sak (object);
}

/**
 * neard_tag_dup_iso14443a_sak: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.Iso14443aSak">"Iso14443aSak"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_iso14443a_sak (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "iso14443a-sak", &value, NULL);
  return value;
}

/**
 * neard_tag_set_iso14443a_sak: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.Iso14443aSak">"Iso14443aSak"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_iso14443a_sak (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "iso14443a-sak", value, NULL);
}

/**
 * neard_tag_get_felica_manufacturer: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.FelicaManufacturer">"FelicaManufacturer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_felica_manufacturer() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_felica_manufacturer (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_felica_manufacturer (object);
}

/**
 * neard_tag_dup_felica_manufacturer: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.FelicaManufacturer">"FelicaManufacturer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_felica_manufacturer (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "felica-manufacturer", &value, NULL);
  return value;
}

/**
 * neard_tag_set_felica_manufacturer: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.FelicaManufacturer">"FelicaManufacturer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_felica_manufacturer (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "felica-manufacturer", value, NULL);
}

/**
 * neard_tag_get_felica_cid: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.FelicaCid">"FelicaCid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_felica_cid() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_felica_cid (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_felica_cid (object);
}

/**
 * neard_tag_dup_felica_cid: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.FelicaCid">"FelicaCid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_felica_cid (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "felica-cid", &value, NULL);
  return value;
}

/**
 * neard_tag_set_felica_cid: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.FelicaCid">"FelicaCid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_felica_cid (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "felica-cid", value, NULL);
}

/**
 * neard_tag_get_felica_ic: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.FelicaIc">"FelicaIc"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_felica_ic() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_felica_ic (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_felica_ic (object);
}

/**
 * neard_tag_dup_felica_ic: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.FelicaIc">"FelicaIc"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_felica_ic (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "felica-ic", &value, NULL);
  return value;
}

/**
 * neard_tag_set_felica_ic: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.FelicaIc">"FelicaIc"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_felica_ic (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "felica-ic", value, NULL);
}

/**
 * neard_tag_get_felica_max_resp_times: (skip)
 * @object: A #NeardTag.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Tag.FelicaMaxRespTimes">"FelicaMaxRespTimes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_tag_dup_felica_max_resp_times() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
neard_tag_get_felica_max_resp_times (NeardTag *object)
{
  return NEARD_TAG_GET_IFACE (object)->get_felica_max_resp_times (object);
}

/**
 * neard_tag_dup_felica_max_resp_times: (skip)
 * @object: A #NeardTag.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Tag.FelicaMaxRespTimes">"FelicaMaxRespTimes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
neard_tag_dup_felica_max_resp_times (NeardTag *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "felica-max-resp-times", &value, NULL);
  return value;
}

/**
 * neard_tag_set_felica_max_resp_times: (skip)
 * @object: A #NeardTag.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Tag.FelicaMaxRespTimes">"FelicaMaxRespTimes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_tag_set_felica_max_resp_times (NeardTag *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "felica-max-resp-times", value, NULL);
}

/**
 * neard_tag_call_write:
 * @proxy: A #NeardTagProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Tag.Write">Write()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_tag_call_write_finish() to get the result of the operation.
 *
 * See neard_tag_call_write_sync() for the synchronous, blocking version of this method.
 */
void
neard_tag_call_write (
    NeardTag *proxy,
    GVariant *arg_attributes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Write",
    g_variant_new ("(@a{sv})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_tag_call_write_finish:
 * @proxy: A #NeardTagProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_tag_call_write().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_tag_call_write().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_tag_call_write_finish (
    NeardTag *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_tag_call_write_sync:
 * @proxy: A #NeardTagProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Tag.Write">Write()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_tag_call_write() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_tag_call_write_sync (
    NeardTag *proxy,
    GVariant *arg_attributes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Write",
    g_variant_new ("(@a{sv})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_tag_call_get_raw_ndef:
 * @proxy: A #NeardTagProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Tag.GetRawNDEF">GetRawNDEF()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_tag_call_get_raw_ndef_finish() to get the result of the operation.
 *
 * See neard_tag_call_get_raw_ndef_sync() for the synchronous, blocking version of this method.
 */
void
neard_tag_call_get_raw_ndef (
    NeardTag *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRawNDEF",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_tag_call_get_raw_ndef_finish:
 * @proxy: A #NeardTagProxy.
 * @out_NDEF: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_tag_call_get_raw_ndef().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_tag_call_get_raw_ndef().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_tag_call_get_raw_ndef_finish (
    NeardTag *proxy,
    GVariant **out_NDEF,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ay)",
                 out_NDEF);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_tag_call_get_raw_ndef_sync:
 * @proxy: A #NeardTagProxy.
 * @out_NDEF: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Tag.GetRawNDEF">GetRawNDEF()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_tag_call_get_raw_ndef() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_tag_call_get_raw_ndef_sync (
    NeardTag *proxy,
    GVariant **out_NDEF,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRawNDEF",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ay)",
                 out_NDEF);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_tag_complete_write:
 * @object: A #NeardTag.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Tag.Write">Write()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_tag_complete_write (
    NeardTag *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_tag_complete_get_raw_ndef:
 * @object: A #NeardTag.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @NDEF: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Tag.GetRawNDEF">GetRawNDEF()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_tag_complete_get_raw_ndef (
    NeardTag *object,
    GDBusMethodInvocation *invocation,
    GVariant *NDEF)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ay)",
                   NDEF));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardTagProxy:
 *
 * The #NeardTagProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardTagProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardTagProxy.
 */

struct _NeardTagProxyPrivate
{
  GData *qdata;
};

static void neard_tag_proxy_iface_init (NeardTagIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardTagProxy, neard_tag_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardTagProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_TAG, neard_tag_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardTagProxy, neard_tag_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_TAG, neard_tag_proxy_iface_init));

#endif
static void
neard_tag_proxy_finalize (GObject *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_tag_proxy_parent_class)->finalize (object);
}

static void
neard_tag_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = _neard_tag_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
neard_tag_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.neard.Tag: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
neard_tag_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = _neard_tag_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.neard.Tag", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) neard_tag_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
neard_tag_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_tag_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_TAG);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_TAG);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_tag_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_tag_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_tag_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
neard_tag_proxy_get_name (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_tag_proxy_get_type_ (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_tag_proxy_get_protocol (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Protocol");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
neard_tag_proxy_get_read_only (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ReadOnly");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_tag_proxy_get_adapter (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Adapter");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
neard_tag_proxy_get_records (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Records");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
neard_tag_proxy_get_iso14443a_uid (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Iso14443aUid");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
neard_tag_proxy_get_iso14443a_atqa (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Iso14443aAtqa");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
neard_tag_proxy_get_iso14443a_sak (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Iso14443aSak");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
neard_tag_proxy_get_felica_manufacturer (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FelicaManufacturer");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
neard_tag_proxy_get_felica_cid (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FelicaCid");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
neard_tag_proxy_get_felica_ic (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FelicaIc");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
neard_tag_proxy_get_felica_max_resp_times (NeardTag *object)
{
  NeardTagProxy *proxy = NEARD_TAG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FelicaMaxRespTimes");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
neard_tag_proxy_init (NeardTagProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_tag_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_TAG_PROXY, NeardTagProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_tag_interface_info ());
}

static void
neard_tag_proxy_class_init (NeardTagProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_tag_proxy_finalize;
  gobject_class->get_property = neard_tag_proxy_get_property;
  gobject_class->set_property = neard_tag_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_tag_proxy_g_signal;
  proxy_class->g_properties_changed = neard_tag_proxy_g_properties_changed;

  neard_tag_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardTagProxyPrivate));
#endif
}

static void
neard_tag_proxy_iface_init (NeardTagIface *iface)
{
  iface->get_name = neard_tag_proxy_get_name;
  iface->get_type_ = neard_tag_proxy_get_type_;
  iface->get_protocol = neard_tag_proxy_get_protocol;
  iface->get_read_only = neard_tag_proxy_get_read_only;
  iface->get_adapter = neard_tag_proxy_get_adapter;
  iface->get_records = neard_tag_proxy_get_records;
  iface->get_iso14443a_uid = neard_tag_proxy_get_iso14443a_uid;
  iface->get_iso14443a_atqa = neard_tag_proxy_get_iso14443a_atqa;
  iface->get_iso14443a_sak = neard_tag_proxy_get_iso14443a_sak;
  iface->get_felica_manufacturer = neard_tag_proxy_get_felica_manufacturer;
  iface->get_felica_cid = neard_tag_proxy_get_felica_cid;
  iface->get_felica_ic = neard_tag_proxy_get_felica_ic;
  iface->get_felica_max_resp_times = neard_tag_proxy_get_felica_max_resp_times;
}

/**
 * neard_tag_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_tag_proxy_new_finish() to get the result of the operation.
 *
 * See neard_tag_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_tag_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_TAG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Tag", NULL);
}

/**
 * neard_tag_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_tag_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_tag_proxy_new().
 *
 * Returns: (transfer full) (type NeardTagProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardTag *
neard_tag_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_TAG (ret);
  else
    return NULL;
}

/**
 * neard_tag_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_tag_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardTagProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardTag *
neard_tag_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_TAG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Tag", NULL);
  if (ret != NULL)
    return NEARD_TAG (ret);
  else
    return NULL;
}


/**
 * neard_tag_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_tag_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_tag_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_tag_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_tag_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_TAG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Tag", NULL);
}

/**
 * neard_tag_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_tag_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_tag_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardTagProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardTag *
neard_tag_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_TAG (ret);
  else
    return NULL;
}

/**
 * neard_tag_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_tag_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_tag_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardTagProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardTag *
neard_tag_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_TAG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Tag", NULL);
  if (ret != NULL)
    return NEARD_TAG (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardTagSkeleton:
 *
 * The #NeardTagSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardTagSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardTagSkeleton.
 */

struct _NeardTagSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_tag_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_TAG);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_TAG);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_tag_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_tag_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_tag_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_tag_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_tag_skeleton_vtable =
{
  _neard_tag_skeleton_handle_method_call,
  _neard_tag_skeleton_handle_get_property,
  _neard_tag_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_tag_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_tag_interface_info ();
}

static GDBusInterfaceVTable *
neard_tag_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_tag_skeleton_vtable;
}

static GVariant *
neard_tag_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_tag_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_tag_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_tag_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_tag_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Tag", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _neard_tag_emit_changed (gpointer user_data);

static void
neard_tag_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _neard_tag_emit_changed (skeleton);
}

static void neard_tag_skeleton_iface_init (NeardTagIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardTagSkeleton, neard_tag_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardTagSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_TAG, neard_tag_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardTagSkeleton, neard_tag_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_TAG, neard_tag_skeleton_iface_init));

#endif
static void
neard_tag_skeleton_finalize (GObject *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  guint n;
  for (n = 0; n < 13; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_tag_skeleton_parent_class)->finalize (object);
}

static void
neard_tag_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_neard_tag_emit_changed (gpointer user_data)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.neard.Tag",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_neard_tag_schedule_emit_changed (NeardTagSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
neard_tag_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _neard_tag_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
neard_tag_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _neard_tag_schedule_emit_changed (skeleton, _neard_tag_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
neard_tag_skeleton_init (NeardTagSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_tag_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_TAG_SKELETON, NeardTagSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 13);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_VARIANT);
}

static const gchar *
neard_tag_skeleton_get_name (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_tag_skeleton_get_type_ (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_tag_skeleton_get_protocol (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
neard_tag_skeleton_get_read_only (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_tag_skeleton_get_adapter (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
neard_tag_skeleton_get_records (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_iso14443a_uid (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_iso14443a_atqa (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_iso14443a_sak (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_felica_manufacturer (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_felica_cid (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_felica_ic (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
neard_tag_skeleton_get_felica_max_resp_times (NeardTag *object)
{
  NeardTagSkeleton *skeleton = NEARD_TAG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
neard_tag_skeleton_class_init (NeardTagSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_tag_skeleton_finalize;
  gobject_class->get_property = neard_tag_skeleton_get_property;
  gobject_class->set_property = neard_tag_skeleton_set_property;
  gobject_class->notify       = neard_tag_skeleton_notify;


  neard_tag_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_tag_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_tag_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_tag_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_tag_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardTagSkeletonPrivate));
#endif
}

static void
neard_tag_skeleton_iface_init (NeardTagIface *iface)
{
  iface->get_name = neard_tag_skeleton_get_name;
  iface->get_type_ = neard_tag_skeleton_get_type_;
  iface->get_protocol = neard_tag_skeleton_get_protocol;
  iface->get_read_only = neard_tag_skeleton_get_read_only;
  iface->get_adapter = neard_tag_skeleton_get_adapter;
  iface->get_records = neard_tag_skeleton_get_records;
  iface->get_iso14443a_uid = neard_tag_skeleton_get_iso14443a_uid;
  iface->get_iso14443a_atqa = neard_tag_skeleton_get_iso14443a_atqa;
  iface->get_iso14443a_sak = neard_tag_skeleton_get_iso14443a_sak;
  iface->get_felica_manufacturer = neard_tag_skeleton_get_felica_manufacturer;
  iface->get_felica_cid = neard_tag_skeleton_get_felica_cid;
  iface->get_felica_ic = neard_tag_skeleton_get_felica_ic;
  iface->get_felica_max_resp_times = neard_tag_skeleton_get_felica_max_resp_times;
}

/**
 * neard_tag_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link>.
 *
 * Returns: (transfer full) (type NeardTagSkeleton): The skeleton object.
 */
NeardTag *
neard_tag_skeleton_new (void)
{
  return NEARD_TAG (g_object_new (NEARD_TYPE_TAG_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.Device
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardDevice
 * @title: NeardDevice
 * @short_description: Generated C code for the org.neard.Device D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.Device ---- */

static const _ExtendedGDBusArgInfo _neard_device_method_info_push_IN_ARG_attributes =
{
  {
    -1,
    (gchar *) "attributes",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _neard_device_method_info_push_IN_ARG_pointers[] =
{
  &_neard_device_method_info_push_IN_ARG_attributes,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_device_method_info_push =
{
  {
    -1,
    (gchar *) "Push",
    (GDBusArgInfo **) &_neard_device_method_info_push_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-push",
  FALSE
};

static const _ExtendedGDBusArgInfo _neard_device_method_info_get_raw_ndef_OUT_ARG_NDEF =
{
  {
    -1,
    (gchar *) "NDEF",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const _ExtendedGDBusArgInfo * const _neard_device_method_info_get_raw_ndef_OUT_ARG_pointers[] =
{
  &_neard_device_method_info_get_raw_ndef_OUT_ARG_NDEF,
  NULL
};

static const _ExtendedGDBusMethodInfo _neard_device_method_info_get_raw_ndef =
{
  {
    -1,
    (gchar *) "GetRawNDEF",
    NULL,
    (GDBusArgInfo **) &_neard_device_method_info_get_raw_ndef_OUT_ARG_pointers,
    NULL
  },
  "handle-get-raw-ndef",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _neard_device_method_info_pointers[] =
{
  &_neard_device_method_info_push,
  &_neard_device_method_info_get_raw_ndef,
  NULL
};

static const _ExtendedGDBusPropertyInfo _neard_device_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_device_property_info_adapter =
{
  {
    -1,
    (gchar *) "Adapter",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "adapter",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_device_property_info_records =
{
  {
    -1,
    (gchar *) "Records",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "records",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _neard_device_property_info_pointers[] =
{
  &_neard_device_property_info_name,
  &_neard_device_property_info_adapter,
  &_neard_device_property_info_records,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_device_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.Device",
    (GDBusMethodInfo **) &_neard_device_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_neard_device_property_info_pointers,
    NULL
  },
  "device",
};


/**
 * neard_device_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_device_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_device_interface_info.parent_struct;
}

/**
 * neard_device_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardDevice interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_device_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "adapter");
  g_object_class_override_property (klass, property_id_begin++, "records");
  return property_id_begin - 1;
}



/**
 * NeardDevice:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link>.
 */

/**
 * NeardDeviceIface:
 * @parent_iface: The parent interface.
 * @handle_get_raw_ndef: Handler for the #NeardDevice::handle-get-raw-ndef signal.
 * @handle_push: Handler for the #NeardDevice::handle-push signal.
 * @get_adapter: Getter for the #NeardDevice:adapter property.
 * @get_name: Getter for the #NeardDevice:name property.
 * @get_records: Getter for the #NeardDevice:records property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link>.
 */

typedef NeardDeviceIface NeardDeviceInterface;
G_DEFINE_INTERFACE (NeardDevice, neard_device, G_TYPE_OBJECT);

static void
neard_device_default_init (NeardDeviceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NeardDevice::handle-push:
   * @object: A #NeardDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_attributes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Device.Push">Push()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_device_complete_push() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-push",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardDeviceIface, handle_push),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NeardDevice::handle-get-raw-ndef:
   * @object: A #NeardDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-neard-Device.GetRawNDEF">GetRawNDEF()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call neard_device_complete_get_raw_ndef() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-raw-ndef",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NeardDeviceIface, handle_get_raw_ndef),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * NeardDevice:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Device.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardDevice:adapter:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Device.Adapter">"Adapter"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("adapter", "Adapter", "Adapter", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardDevice:records:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Device.Records">"Records"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("records", "Records", "Records", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * neard_device_get_name: (skip)
 * @object: A #NeardDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Device.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_device_dup_name() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_device_get_name (NeardDevice *object)
{
  return NEARD_DEVICE_GET_IFACE (object)->get_name (object);
}

/**
 * neard_device_dup_name: (skip)
 * @object: A #NeardDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Device.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_device_dup_name (NeardDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * neard_device_set_name: (skip)
 * @object: A #NeardDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Device.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_device_set_name (NeardDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * neard_device_get_adapter: (skip)
 * @object: A #NeardDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Device.Adapter">"Adapter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_device_dup_adapter() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_device_get_adapter (NeardDevice *object)
{
  return NEARD_DEVICE_GET_IFACE (object)->get_adapter (object);
}

/**
 * neard_device_dup_adapter: (skip)
 * @object: A #NeardDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Device.Adapter">"Adapter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_device_dup_adapter (NeardDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "adapter", &value, NULL);
  return value;
}

/**
 * neard_device_set_adapter: (skip)
 * @object: A #NeardDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Device.Adapter">"Adapter"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_device_set_adapter (NeardDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "adapter", value, NULL);
}

/**
 * neard_device_get_records: (skip)
 * @object: A #NeardDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Device.Records">"Records"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_device_dup_records() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
neard_device_get_records (NeardDevice *object)
{
  return NEARD_DEVICE_GET_IFACE (object)->get_records (object);
}

/**
 * neard_device_dup_records: (skip)
 * @object: A #NeardDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Device.Records">"Records"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
neard_device_dup_records (NeardDevice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "records", &value, NULL);
  return value;
}

/**
 * neard_device_set_records: (skip)
 * @object: A #NeardDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Device.Records">"Records"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_device_set_records (NeardDevice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "records", value, NULL);
}

/**
 * neard_device_call_push:
 * @proxy: A #NeardDeviceProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Device.Push">Push()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_device_call_push_finish() to get the result of the operation.
 *
 * See neard_device_call_push_sync() for the synchronous, blocking version of this method.
 */
void
neard_device_call_push (
    NeardDevice *proxy,
    GVariant *arg_attributes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Push",
    g_variant_new ("(@a{sv})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_device_call_push_finish:
 * @proxy: A #NeardDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_device_call_push().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_device_call_push().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_device_call_push_finish (
    NeardDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_device_call_push_sync:
 * @proxy: A #NeardDeviceProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Device.Push">Push()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_device_call_push() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_device_call_push_sync (
    NeardDevice *proxy,
    GVariant *arg_attributes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Push",
    g_variant_new ("(@a{sv})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_device_call_get_raw_ndef:
 * @proxy: A #NeardDeviceProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-neard-Device.GetRawNDEF">GetRawNDEF()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_device_call_get_raw_ndef_finish() to get the result of the operation.
 *
 * See neard_device_call_get_raw_ndef_sync() for the synchronous, blocking version of this method.
 */
void
neard_device_call_get_raw_ndef (
    NeardDevice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRawNDEF",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * neard_device_call_get_raw_ndef_finish:
 * @proxy: A #NeardDeviceProxy.
 * @out_NDEF: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_device_call_get_raw_ndef().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with neard_device_call_get_raw_ndef().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_device_call_get_raw_ndef_finish (
    NeardDevice *proxy,
    GVariant **out_NDEF,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ay)",
                 out_NDEF);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_device_call_get_raw_ndef_sync:
 * @proxy: A #NeardDeviceProxy.
 * @out_NDEF: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-neard-Device.GetRawNDEF">GetRawNDEF()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See neard_device_call_get_raw_ndef() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
neard_device_call_get_raw_ndef_sync (
    NeardDevice *proxy,
    GVariant **out_NDEF,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRawNDEF",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ay)",
                 out_NDEF);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * neard_device_complete_push:
 * @object: A #NeardDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Device.Push">Push()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_device_complete_push (
    NeardDevice *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * neard_device_complete_get_raw_ndef:
 * @object: A #NeardDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @NDEF: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-neard-Device.GetRawNDEF">GetRawNDEF()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
neard_device_complete_get_raw_ndef (
    NeardDevice *object,
    GDBusMethodInvocation *invocation,
    GVariant *NDEF)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ay)",
                   NDEF));
}

/* ------------------------------------------------------------------------ */

/**
 * NeardDeviceProxy:
 *
 * The #NeardDeviceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardDeviceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardDeviceProxy.
 */

struct _NeardDeviceProxyPrivate
{
  GData *qdata;
};

static void neard_device_proxy_iface_init (NeardDeviceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardDeviceProxy, neard_device_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardDeviceProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_DEVICE, neard_device_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardDeviceProxy, neard_device_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_DEVICE, neard_device_proxy_iface_init));

#endif
static void
neard_device_proxy_finalize (GObject *object)
{
  NeardDeviceProxy *proxy = NEARD_DEVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_device_proxy_parent_class)->finalize (object);
}

static void
neard_device_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = _neard_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
neard_device_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.neard.Device: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
neard_device_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = _neard_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.neard.Device", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) neard_device_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
neard_device_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_device_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_DEVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_DEVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_device_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardDeviceProxy *proxy = NEARD_DEVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_device_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_device_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
neard_device_proxy_get_name (NeardDevice *object)
{
  NeardDeviceProxy *proxy = NEARD_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_device_proxy_get_adapter (NeardDevice *object)
{
  NeardDeviceProxy *proxy = NEARD_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Adapter");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
neard_device_proxy_get_records (NeardDevice *object)
{
  NeardDeviceProxy *proxy = NEARD_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Records");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
neard_device_proxy_init (NeardDeviceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_device_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_DEVICE_PROXY, NeardDeviceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_device_interface_info ());
}

static void
neard_device_proxy_class_init (NeardDeviceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_device_proxy_finalize;
  gobject_class->get_property = neard_device_proxy_get_property;
  gobject_class->set_property = neard_device_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_device_proxy_g_signal;
  proxy_class->g_properties_changed = neard_device_proxy_g_properties_changed;

  neard_device_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardDeviceProxyPrivate));
#endif
}

static void
neard_device_proxy_iface_init (NeardDeviceIface *iface)
{
  iface->get_name = neard_device_proxy_get_name;
  iface->get_adapter = neard_device_proxy_get_adapter;
  iface->get_records = neard_device_proxy_get_records;
}

/**
 * neard_device_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_device_proxy_new_finish() to get the result of the operation.
 *
 * See neard_device_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_device_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Device", NULL);
}

/**
 * neard_device_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_device_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_device_proxy_new().
 *
 * Returns: (transfer full) (type NeardDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardDevice *
neard_device_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_DEVICE (ret);
  else
    return NULL;
}

/**
 * neard_device_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_device_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardDevice *
neard_device_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Device", NULL);
  if (ret != NULL)
    return NEARD_DEVICE (ret);
  else
    return NULL;
}


/**
 * neard_device_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_device_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_device_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_device_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_device_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Device", NULL);
}

/**
 * neard_device_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_device_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_device_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardDevice *
neard_device_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_DEVICE (ret);
  else
    return NULL;
}

/**
 * neard_device_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_device_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_device_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardDevice *
neard_device_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Device", NULL);
  if (ret != NULL)
    return NEARD_DEVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardDeviceSkeleton:
 *
 * The #NeardDeviceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardDeviceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardDeviceSkeleton.
 */

struct _NeardDeviceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_device_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_DEVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_DEVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_device_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_device_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_device_skeleton_vtable =
{
  _neard_device_skeleton_handle_method_call,
  _neard_device_skeleton_handle_get_property,
  _neard_device_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_device_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_device_interface_info ();
}

static GDBusInterfaceVTable *
neard_device_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_device_skeleton_vtable;
}

static GVariant *
neard_device_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_device_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_device_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_device_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_device_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Device", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _neard_device_emit_changed (gpointer user_data);

static void
neard_device_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _neard_device_emit_changed (skeleton);
}

static void neard_device_skeleton_iface_init (NeardDeviceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardDeviceSkeleton, neard_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardDeviceSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_DEVICE, neard_device_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardDeviceSkeleton, neard_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_DEVICE, neard_device_skeleton_iface_init));

#endif
static void
neard_device_skeleton_finalize (GObject *object)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_device_skeleton_parent_class)->finalize (object);
}

static void
neard_device_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_neard_device_emit_changed (gpointer user_data)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.neard.Device",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_neard_device_schedule_emit_changed (NeardDeviceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
neard_device_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _neard_device_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
neard_device_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _neard_device_schedule_emit_changed (skeleton, _neard_device_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
neard_device_skeleton_init (NeardDeviceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_device_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_DEVICE_SKELETON, NeardDeviceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
}

static const gchar *
neard_device_skeleton_get_name (NeardDevice *object)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_device_skeleton_get_adapter (NeardDevice *object)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
neard_device_skeleton_get_records (NeardDevice *object)
{
  NeardDeviceSkeleton *skeleton = NEARD_DEVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
neard_device_skeleton_class_init (NeardDeviceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_device_skeleton_finalize;
  gobject_class->get_property = neard_device_skeleton_get_property;
  gobject_class->set_property = neard_device_skeleton_set_property;
  gobject_class->notify       = neard_device_skeleton_notify;


  neard_device_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_device_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_device_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_device_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_device_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardDeviceSkeletonPrivate));
#endif
}

static void
neard_device_skeleton_iface_init (NeardDeviceIface *iface)
{
  iface->get_name = neard_device_skeleton_get_name;
  iface->get_adapter = neard_device_skeleton_get_adapter;
  iface->get_records = neard_device_skeleton_get_records;
}

/**
 * neard_device_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link>.
 *
 * Returns: (transfer full) (type NeardDeviceSkeleton): The skeleton object.
 */
NeardDevice *
neard_device_skeleton_new (void)
{
  return NEARD_DEVICE (g_object_new (NEARD_TYPE_DEVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.neard.Record
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardRecord
 * @title: NeardRecord
 * @short_description: Generated C code for the org.neard.Record D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.neard.Record ---- */

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_encoding =
{
  {
    -1,
    (gchar *) "Encoding",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "encoding",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_language =
{
  {
    -1,
    (gchar *) "Language",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "language",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_representation =
{
  {
    -1,
    (gchar *) "Representation",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "representation",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_uri =
{
  {
    -1,
    (gchar *) "URI",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uri",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_mimetype =
{
  {
    -1,
    (gchar *) "MIMEType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mimetype",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_size =
{
  {
    -1,
    (gchar *) "Size",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "size",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_action =
{
  {
    -1,
    (gchar *) "Action",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "action",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _neard_record_property_info_android_package =
{
  {
    -1,
    (gchar *) "AndroidPackage",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "android-package",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _neard_record_property_info_pointers[] =
{
  &_neard_record_property_info_name,
  &_neard_record_property_info_type_,
  &_neard_record_property_info_encoding,
  &_neard_record_property_info_language,
  &_neard_record_property_info_representation,
  &_neard_record_property_info_uri,
  &_neard_record_property_info_mimetype,
  &_neard_record_property_info_size,
  &_neard_record_property_info_action,
  &_neard_record_property_info_android_package,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _neard_record_interface_info =
{
  {
    -1,
    (gchar *) "org.neard.Record",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_neard_record_property_info_pointers,
    NULL
  },
  "record",
};


/**
 * neard_record_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
neard_record_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_neard_record_interface_info.parent_struct;
}

/**
 * neard_record_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NeardRecord interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
neard_record_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "type");
  g_object_class_override_property (klass, property_id_begin++, "encoding");
  g_object_class_override_property (klass, property_id_begin++, "language");
  g_object_class_override_property (klass, property_id_begin++, "representation");
  g_object_class_override_property (klass, property_id_begin++, "uri");
  g_object_class_override_property (klass, property_id_begin++, "mimetype");
  g_object_class_override_property (klass, property_id_begin++, "size");
  g_object_class_override_property (klass, property_id_begin++, "action");
  g_object_class_override_property (klass, property_id_begin++, "android-package");
  return property_id_begin - 1;
}



/**
 * NeardRecord:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link>.
 */

/**
 * NeardRecordIface:
 * @parent_iface: The parent interface.
 * @get_action: Getter for the #NeardRecord:action property.
 * @get_android_package: Getter for the #NeardRecord:android-package property.
 * @get_encoding: Getter for the #NeardRecord:encoding property.
 * @get_language: Getter for the #NeardRecord:language property.
 * @get_mimetype: Getter for the #NeardRecord:mimetype property.
 * @get_name: Getter for the #NeardRecord:name property.
 * @get_representation: Getter for the #NeardRecord:representation property.
 * @get_size: Getter for the #NeardRecord:size property.
 * @get_type_: Getter for the #NeardRecord:type property.
 * @get_uri: Getter for the #NeardRecord:uri property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link>.
 */

typedef NeardRecordIface NeardRecordInterface;
G_DEFINE_INTERFACE (NeardRecord, neard_record, G_TYPE_OBJECT);

static void
neard_record_default_init (NeardRecordIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * NeardRecord:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:encoding:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Encoding">"Encoding"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("encoding", "Encoding", "Encoding", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:language:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Language">"Language"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("language", "Language", "Language", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:representation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Representation">"Representation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("representation", "Representation", "Representation", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:uri:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.URI">"URI"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uri", "URI", "URI", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:mimetype:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.MIMEType">"MIMEType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("mimetype", "MIMEType", "MIMEType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Size">"Size"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("size", "Size", "Size", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.Action">"Action"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("action", "Action", "Action", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NeardRecord:android-package:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-neard-Record.AndroidPackage">"AndroidPackage"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("android-package", "AndroidPackage", "AndroidPackage", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * neard_record_get_name: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_name() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_name (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_name (object);
}

/**
 * neard_record_dup_name: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_name (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * neard_record_set_name: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_name (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * neard_record_get_type_: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_type_() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_type_ (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_type_ (object);
}

/**
 * neard_record_dup_type_: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_type_ (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * neard_record_set_type_: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_type_ (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * neard_record_get_encoding: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Encoding">"Encoding"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_encoding() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_encoding (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_encoding (object);
}

/**
 * neard_record_dup_encoding: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.Encoding">"Encoding"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_encoding (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "encoding", &value, NULL);
  return value;
}

/**
 * neard_record_set_encoding: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Encoding">"Encoding"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_encoding (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "encoding", value, NULL);
}

/**
 * neard_record_get_language: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Language">"Language"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_language() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_language (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_language (object);
}

/**
 * neard_record_dup_language: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.Language">"Language"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_language (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "language", &value, NULL);
  return value;
}

/**
 * neard_record_set_language: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Language">"Language"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_language (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "language", value, NULL);
}

/**
 * neard_record_get_representation: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Representation">"Representation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_representation() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_representation (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_representation (object);
}

/**
 * neard_record_dup_representation: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.Representation">"Representation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_representation (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "representation", &value, NULL);
  return value;
}

/**
 * neard_record_set_representation: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Representation">"Representation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_representation (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "representation", value, NULL);
}

/**
 * neard_record_get_uri: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.URI">"URI"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_uri() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_uri (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_uri (object);
}

/**
 * neard_record_dup_uri: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.URI">"URI"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_uri (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uri", &value, NULL);
  return value;
}

/**
 * neard_record_set_uri: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.URI">"URI"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_uri (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uri", value, NULL);
}

/**
 * neard_record_get_mimetype: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.MIMEType">"MIMEType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_mimetype() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_mimetype (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_mimetype (object);
}

/**
 * neard_record_dup_mimetype: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.MIMEType">"MIMEType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_mimetype (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "mimetype", &value, NULL);
  return value;
}

/**
 * neard_record_set_mimetype: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.MIMEType">"MIMEType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_mimetype (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "mimetype", value, NULL);
}

/**
 * neard_record_get_size: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Size">"Size"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
neard_record_get_size (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_size (object);
}

/**
 * neard_record_set_size: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Size">"Size"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_size (NeardRecord *object, guint value)
{
  g_object_set (G_OBJECT (object), "size", value, NULL);
}

/**
 * neard_record_get_action: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.Action">"Action"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_action() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_action (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_action (object);
}

/**
 * neard_record_dup_action: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.Action">"Action"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_action (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "action", &value, NULL);
  return value;
}

/**
 * neard_record_set_action: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.Action">"Action"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_action (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "action", value, NULL);
}

/**
 * neard_record_get_android_package: (skip)
 * @object: A #NeardRecord.
 *
 * Gets the value of the <link linkend="gdbus-property-org-neard-Record.AndroidPackage">"AndroidPackage"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use neard_record_dup_android_package() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
neard_record_get_android_package (NeardRecord *object)
{
  return NEARD_RECORD_GET_IFACE (object)->get_android_package (object);
}

/**
 * neard_record_dup_android_package: (skip)
 * @object: A #NeardRecord.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-neard-Record.AndroidPackage">"AndroidPackage"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
neard_record_dup_android_package (NeardRecord *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "android-package", &value, NULL);
  return value;
}

/**
 * neard_record_set_android_package: (skip)
 * @object: A #NeardRecord.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-neard-Record.AndroidPackage">"AndroidPackage"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
neard_record_set_android_package (NeardRecord *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "android-package", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * NeardRecordProxy:
 *
 * The #NeardRecordProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardRecordProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardRecordProxy.
 */

struct _NeardRecordProxyPrivate
{
  GData *qdata;
};

static void neard_record_proxy_iface_init (NeardRecordIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardRecordProxy, neard_record_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NeardRecordProxy)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_RECORD, neard_record_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardRecordProxy, neard_record_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_RECORD, neard_record_proxy_iface_init));

#endif
static void
neard_record_proxy_finalize (GObject *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (neard_record_proxy_parent_class)->finalize (object);
}

static void
neard_record_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = _neard_record_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
neard_record_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.neard.Record: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
neard_record_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = _neard_record_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.neard.Record", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) neard_record_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
neard_record_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_neard_record_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEARD_TYPE_RECORD);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_RECORD);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
neard_record_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_record_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_record_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
neard_record_proxy_get_name (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_type_ (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_encoding (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Encoding");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_language (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Language");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_representation (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Representation");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_uri (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "URI");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_mimetype (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MIMEType");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
neard_record_proxy_get_size (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Size");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_action (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Action");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
neard_record_proxy_get_android_package (NeardRecord *object)
{
  NeardRecordProxy *proxy = NEARD_RECORD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AndroidPackage");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
neard_record_proxy_init (NeardRecordProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = neard_record_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEARD_TYPE_RECORD_PROXY, NeardRecordProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), neard_record_interface_info ());
}

static void
neard_record_proxy_class_init (NeardRecordProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = neard_record_proxy_finalize;
  gobject_class->get_property = neard_record_proxy_get_property;
  gobject_class->set_property = neard_record_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = neard_record_proxy_g_signal;
  proxy_class->g_properties_changed = neard_record_proxy_g_properties_changed;

  neard_record_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardRecordProxyPrivate));
#endif
}

static void
neard_record_proxy_iface_init (NeardRecordIface *iface)
{
  iface->get_name = neard_record_proxy_get_name;
  iface->get_type_ = neard_record_proxy_get_type_;
  iface->get_encoding = neard_record_proxy_get_encoding;
  iface->get_language = neard_record_proxy_get_language;
  iface->get_representation = neard_record_proxy_get_representation;
  iface->get_uri = neard_record_proxy_get_uri;
  iface->get_mimetype = neard_record_proxy_get_mimetype;
  iface->get_size = neard_record_proxy_get_size;
  iface->get_action = neard_record_proxy_get_action;
  iface->get_android_package = neard_record_proxy_get_android_package;
}

/**
 * neard_record_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_record_proxy_new_finish() to get the result of the operation.
 *
 * See neard_record_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_record_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_RECORD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Record", NULL);
}

/**
 * neard_record_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_record_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_record_proxy_new().
 *
 * Returns: (transfer full) (type NeardRecordProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardRecord *
neard_record_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_RECORD (ret);
  else
    return NULL;
}

/**
 * neard_record_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_record_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardRecordProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardRecord *
neard_record_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_RECORD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.neard.Record", NULL);
  if (ret != NULL)
    return NEARD_RECORD (ret);
  else
    return NULL;
}


/**
 * neard_record_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_record_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_record_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_record_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_record_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEARD_TYPE_RECORD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Record", NULL);
}

/**
 * neard_record_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_record_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_record_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NeardRecordProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardRecord *
neard_record_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEARD_RECORD (ret);
  else
    return NULL;
}

/**
 * neard_record_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_record_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_record_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardRecordProxy): The constructed proxy object or %NULL if @error is set.
 */
NeardRecord *
neard_record_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_RECORD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.neard.Record", NULL);
  if (ret != NULL)
    return NEARD_RECORD (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NeardRecordSkeleton:
 *
 * The #NeardRecordSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardRecordSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardRecordSkeleton.
 */

struct _NeardRecordSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_neard_record_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEARD_TYPE_RECORD);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEARD_TYPE_RECORD);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_neard_record_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_record_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_neard_record_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_neard_record_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _neard_record_skeleton_vtable =
{
  _neard_record_skeleton_handle_method_call,
  _neard_record_skeleton_handle_get_property,
  _neard_record_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
neard_record_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return neard_record_interface_info ();
}

static GDBusInterfaceVTable *
neard_record_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_neard_record_skeleton_vtable;
}

static GVariant *
neard_record_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_neard_record_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _neard_record_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _neard_record_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _neard_record_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.neard.Record", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _neard_record_emit_changed (gpointer user_data);

static void
neard_record_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _neard_record_emit_changed (skeleton);
}

static void neard_record_skeleton_iface_init (NeardRecordIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NeardRecordSkeleton, neard_record_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NeardRecordSkeleton)
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_RECORD, neard_record_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (NeardRecordSkeleton, neard_record_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_RECORD, neard_record_skeleton_iface_init));

#endif
static void
neard_record_skeleton_finalize (GObject *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  guint n;
  for (n = 0; n < 10; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (neard_record_skeleton_parent_class)->finalize (object);
}

static void
neard_record_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_neard_record_emit_changed (gpointer user_data)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.neard.Record",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_neard_record_schedule_emit_changed (NeardRecordSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
neard_record_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _neard_record_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
neard_record_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _neard_record_schedule_emit_changed (skeleton, _neard_record_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
neard_record_skeleton_init (NeardRecordSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = neard_record_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEARD_TYPE_RECORD_SKELETON, NeardRecordSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 10);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
}

static const gchar *
neard_record_skeleton_get_name (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_type_ (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_encoding (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_language (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_representation (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_uri (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_mimetype (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
neard_record_skeleton_get_size (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_action (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
neard_record_skeleton_get_android_package (NeardRecord *object)
{
  NeardRecordSkeleton *skeleton = NEARD_RECORD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
neard_record_skeleton_class_init (NeardRecordSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = neard_record_skeleton_finalize;
  gobject_class->get_property = neard_record_skeleton_get_property;
  gobject_class->set_property = neard_record_skeleton_set_property;
  gobject_class->notify       = neard_record_skeleton_notify;


  neard_record_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = neard_record_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = neard_record_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = neard_record_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = neard_record_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NeardRecordSkeletonPrivate));
#endif
}

static void
neard_record_skeleton_iface_init (NeardRecordIface *iface)
{
  iface->get_name = neard_record_skeleton_get_name;
  iface->get_type_ = neard_record_skeleton_get_type_;
  iface->get_encoding = neard_record_skeleton_get_encoding;
  iface->get_language = neard_record_skeleton_get_language;
  iface->get_representation = neard_record_skeleton_get_representation;
  iface->get_uri = neard_record_skeleton_get_uri;
  iface->get_mimetype = neard_record_skeleton_get_mimetype;
  iface->get_size = neard_record_skeleton_get_size;
  iface->get_action = neard_record_skeleton_get_action;
  iface->get_android_package = neard_record_skeleton_get_android_package;
}

/**
 * neard_record_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link>.
 *
 * Returns: (transfer full) (type NeardRecordSkeleton): The skeleton object.
 */
NeardRecord *
neard_record_skeleton_new (void)
{
  return NEARD_RECORD (g_object_new (NEARD_TYPE_RECORD_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardObject
 * @title: NeardObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #NeardObject, #NeardObjectProxy, and #NeardObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * NeardObject:
 *
 * The #NeardObject type is a specialized container of interfaces.
 */

/**
 * NeardObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #NeardObject interface.
 */

typedef NeardObjectIface NeardObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (NeardObject, neard_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT));

static void
neard_object_default_init (NeardObjectIface *iface)
{
  /**
   * NeardObject:adapter:
   *
   * The #NeardAdapter instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("adapter", "adapter", "adapter", NEARD_TYPE_ADAPTER, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:ndefagent:
   *
   * The #NeardNDEFAgent instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("ndefagent", "ndefagent", "ndefagent", NEARD_TYPE_NDEFAGENT, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:handover-agent:
   *
   * The #NeardHandoverAgent instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("handover-agent", "handover-agent", "handover-agent", NEARD_TYPE_HANDOVER_AGENT, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:manager:
   *
   * The #NeardManager instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("manager", "manager", "manager", NEARD_TYPE_MANAGER, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:agent-manager:
   *
   * The #NeardAgentManager instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("agent-manager", "agent-manager", "agent-manager", NEARD_TYPE_AGENT_MANAGER, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:tag:
   *
   * The #NeardTag instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("tag", "tag", "tag", NEARD_TYPE_TAG, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:device:
   *
   * The #NeardDevice instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("device", "device", "device", NEARD_TYPE_DEVICE, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

  /**
   * NeardObject:record:
   *
   * The #NeardRecord instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("record", "record", "record", NEARD_TYPE_RECORD, G_PARAM_READWRITE|G_PARAM_STATIC_STRINGS));

}

/**
 * neard_object_get_adapter:
 * @object: A #NeardObject.
 *
 * Gets the #NeardAdapter instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardAdapter that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardAdapter *neard_object_get_adapter (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Adapter");
  if (ret == NULL)
    return NULL;
  return NEARD_ADAPTER (ret);
}

/**
 * neard_object_get_ndefagent:
 * @object: A #NeardObject.
 *
 * Gets the #NeardNDEFAgent instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardNDEFAgent that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardNDEFAgent *neard_object_get_ndefagent (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.NDEFAgent");
  if (ret == NULL)
    return NULL;
  return NEARD_NDEFAGENT (ret);
}

/**
 * neard_object_get_handover_agent:
 * @object: A #NeardObject.
 *
 * Gets the #NeardHandoverAgent instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardHandoverAgent that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardHandoverAgent *neard_object_get_handover_agent (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.HandoverAgent");
  if (ret == NULL)
    return NULL;
  return NEARD_HANDOVER_AGENT (ret);
}

/**
 * neard_object_get_manager:
 * @object: A #NeardObject.
 *
 * Gets the #NeardManager instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardManager that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardManager *neard_object_get_manager (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Manager");
  if (ret == NULL)
    return NULL;
  return NEARD_MANAGER (ret);
}

/**
 * neard_object_get_agent_manager:
 * @object: A #NeardObject.
 *
 * Gets the #NeardAgentManager instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardAgentManager that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardAgentManager *neard_object_get_agent_manager (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.AgentManager");
  if (ret == NULL)
    return NULL;
  return NEARD_AGENT_MANAGER (ret);
}

/**
 * neard_object_get_tag:
 * @object: A #NeardObject.
 *
 * Gets the #NeardTag instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardTag that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardTag *neard_object_get_tag (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Tag");
  if (ret == NULL)
    return NULL;
  return NEARD_TAG (ret);
}

/**
 * neard_object_get_device:
 * @object: A #NeardObject.
 *
 * Gets the #NeardDevice instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardDevice that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardDevice *neard_object_get_device (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Device");
  if (ret == NULL)
    return NULL;
  return NEARD_DEVICE (ret);
}

/**
 * neard_object_get_record:
 * @object: A #NeardObject.
 *
 * Gets the #NeardRecord instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link> on @object, if any.
 *
 * Returns: (transfer full): A #NeardRecord that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NeardRecord *neard_object_get_record (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Record");
  if (ret == NULL)
    return NULL;
  return NEARD_RECORD (ret);
}


/**
 * neard_object_peek_adapter: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_adapter() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardAdapter or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardAdapter *neard_object_peek_adapter (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Adapter");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_ADAPTER (ret);
}

/**
 * neard_object_peek_ndefagent: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_ndefagent() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardNDEFAgent or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardNDEFAgent *neard_object_peek_ndefagent (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.NDEFAgent");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_NDEFAGENT (ret);
}

/**
 * neard_object_peek_handover_agent: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_handover_agent() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardHandoverAgent or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardHandoverAgent *neard_object_peek_handover_agent (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.HandoverAgent");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_HANDOVER_AGENT (ret);
}

/**
 * neard_object_peek_manager: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_manager() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardManager or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardManager *neard_object_peek_manager (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Manager");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_MANAGER (ret);
}

/**
 * neard_object_peek_agent_manager: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_agent_manager() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardAgentManager or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardAgentManager *neard_object_peek_agent_manager (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.AgentManager");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_AGENT_MANAGER (ret);
}

/**
 * neard_object_peek_tag: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_tag() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardTag or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardTag *neard_object_peek_tag (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Tag");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_TAG (ret);
}

/**
 * neard_object_peek_device: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_device() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardDevice or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardDevice *neard_object_peek_device (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Device");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_DEVICE (ret);
}

/**
 * neard_object_peek_record: (skip)
 * @object: A #NeardObject.
 *
 * Like neard_object_get_record() but doesn't increase the reference count on the returned object.
 *
 * <warning>It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.</warning>
 *
 * Returns: (transfer none): A #NeardRecord or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NeardRecord *neard_object_peek_record (NeardObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Record");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEARD_RECORD (ret);
}


static void
neard_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * NeardObjectProxy:
 *
 * The #NeardObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardObjectProxy.
 */

static void
neard_object_proxy__neard_object_iface_init (NeardObjectIface *iface G_GNUC_UNUSED)
{
}

static void
neard_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = neard_object_notify;
  iface->interface_removed = neard_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (NeardObjectProxy, neard_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_OBJECT, neard_object_proxy__neard_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, neard_object_proxy__g_dbus_object_iface_init));

static void
neard_object_proxy_init (NeardObjectProxy *object G_GNUC_UNUSED)
{
}

static void
neard_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
neard_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  NeardObjectProxy *object = NEARD_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Adapter");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.NDEFAgent");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.HandoverAgent");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Manager");
      g_value_take_object (value, interface);
      break;

    case 5:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.AgentManager");
      g_value_take_object (value, interface);
      break;

    case 6:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Tag");
      g_value_take_object (value, interface);
      break;

    case 7:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Device");
      g_value_take_object (value, interface);
      break;

    case 8:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Record");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
neard_object_proxy_class_init (NeardObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = neard_object_proxy_set_property;
  gobject_class->get_property = neard_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "adapter");
  g_object_class_override_property (gobject_class, 2, "ndefagent");
  g_object_class_override_property (gobject_class, 3, "handover-agent");
  g_object_class_override_property (gobject_class, 4, "manager");
  g_object_class_override_property (gobject_class, 5, "agent-manager");
  g_object_class_override_property (gobject_class, 6, "tag");
  g_object_class_override_property (gobject_class, 7, "device");
  g_object_class_override_property (gobject_class, 8, "record");
}

/**
 * neard_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
NeardObjectProxy *
neard_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return NEARD_OBJECT_PROXY (g_object_new (NEARD_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * NeardObjectSkeleton:
 *
 * The #NeardObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardObjectSkeleton.
 */

static void
neard_object_skeleton__neard_object_iface_init (NeardObjectIface *iface G_GNUC_UNUSED)
{
}


static void
neard_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = neard_object_notify;
  iface->interface_removed = neard_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (NeardObjectSkeleton, neard_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEARD_TYPE_OBJECT, neard_object_skeleton__neard_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, neard_object_skeleton__g_dbus_object_iface_init));

static void
neard_object_skeleton_init (NeardObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
neard_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NeardObjectSkeleton *object = NEARD_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_ADAPTER (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.Adapter");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_NDEFAGENT (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.NDEFAgent");
        }
      break;

    case 3:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_HANDOVER_AGENT (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.HandoverAgent");
        }
      break;

    case 4:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_MANAGER (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.Manager");
        }
      break;

    case 5:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_AGENT_MANAGER (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.AgentManager");
        }
      break;

    case 6:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_TAG (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.Tag");
        }
      break;

    case 7:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_DEVICE (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.Device");
        }
      break;

    case 8:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEARD_IS_RECORD (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.neard.Record");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
neard_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  NeardObjectSkeleton *object = NEARD_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Adapter");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.NDEFAgent");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.HandoverAgent");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Manager");
      g_value_take_object (value, interface);
      break;

    case 5:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.AgentManager");
      g_value_take_object (value, interface);
      break;

    case 6:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Tag");
      g_value_take_object (value, interface);
      break;

    case 7:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Device");
      g_value_take_object (value, interface);
      break;

    case 8:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.neard.Record");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
neard_object_skeleton_class_init (NeardObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = neard_object_skeleton_set_property;
  gobject_class->get_property = neard_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "adapter");
  g_object_class_override_property (gobject_class, 2, "ndefagent");
  g_object_class_override_property (gobject_class, 3, "handover-agent");
  g_object_class_override_property (gobject_class, 4, "manager");
  g_object_class_override_property (gobject_class, 5, "agent-manager");
  g_object_class_override_property (gobject_class, 6, "tag");
  g_object_class_override_property (gobject_class, 7, "device");
  g_object_class_override_property (gobject_class, 8, "record");
}

/**
 * neard_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
NeardObjectSkeleton *
neard_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return NEARD_OBJECT_SKELETON (g_object_new (NEARD_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * neard_object_skeleton_set_adapter:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardAdapter or %NULL to clear the interface.
 *
 * Sets the #NeardAdapter instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Adapter.top_of_page">org.neard.Adapter</link> on @object.
 */
void neard_object_skeleton_set_adapter (NeardObjectSkeleton *object, NeardAdapter *interface_)
{
  g_object_set (G_OBJECT (object), "adapter", interface_, NULL);
}

/**
 * neard_object_skeleton_set_ndefagent:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardNDEFAgent or %NULL to clear the interface.
 *
 * Sets the #NeardNDEFAgent instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-NDEFAgent.top_of_page">org.neard.NDEFAgent</link> on @object.
 */
void neard_object_skeleton_set_ndefagent (NeardObjectSkeleton *object, NeardNDEFAgent *interface_)
{
  g_object_set (G_OBJECT (object), "ndefagent", interface_, NULL);
}

/**
 * neard_object_skeleton_set_handover_agent:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardHandoverAgent or %NULL to clear the interface.
 *
 * Sets the #NeardHandoverAgent instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-HandoverAgent.top_of_page">org.neard.HandoverAgent</link> on @object.
 */
void neard_object_skeleton_set_handover_agent (NeardObjectSkeleton *object, NeardHandoverAgent *interface_)
{
  g_object_set (G_OBJECT (object), "handover-agent", interface_, NULL);
}

/**
 * neard_object_skeleton_set_manager:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardManager or %NULL to clear the interface.
 *
 * Sets the #NeardManager instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Manager.top_of_page">org.neard.Manager</link> on @object.
 */
void neard_object_skeleton_set_manager (NeardObjectSkeleton *object, NeardManager *interface_)
{
  g_object_set (G_OBJECT (object), "manager", interface_, NULL);
}

/**
 * neard_object_skeleton_set_agent_manager:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardAgentManager or %NULL to clear the interface.
 *
 * Sets the #NeardAgentManager instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-AgentManager.top_of_page">org.neard.AgentManager</link> on @object.
 */
void neard_object_skeleton_set_agent_manager (NeardObjectSkeleton *object, NeardAgentManager *interface_)
{
  g_object_set (G_OBJECT (object), "agent-manager", interface_, NULL);
}

/**
 * neard_object_skeleton_set_tag:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardTag or %NULL to clear the interface.
 *
 * Sets the #NeardTag instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Tag.top_of_page">org.neard.Tag</link> on @object.
 */
void neard_object_skeleton_set_tag (NeardObjectSkeleton *object, NeardTag *interface_)
{
  g_object_set (G_OBJECT (object), "tag", interface_, NULL);
}

/**
 * neard_object_skeleton_set_device:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardDevice or %NULL to clear the interface.
 *
 * Sets the #NeardDevice instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Device.top_of_page">org.neard.Device</link> on @object.
 */
void neard_object_skeleton_set_device (NeardObjectSkeleton *object, NeardDevice *interface_)
{
  g_object_set (G_OBJECT (object), "device", interface_, NULL);
}

/**
 * neard_object_skeleton_set_record:
 * @object: A #NeardObjectSkeleton.
 * @interface_: (allow-none): A #NeardRecord or %NULL to clear the interface.
 *
 * Sets the #NeardRecord instance for the D-Bus interface <link linkend="gdbus-interface-org-neard-Record.top_of_page">org.neard.Record</link> on @object.
 */
void neard_object_skeleton_set_record (NeardObjectSkeleton *object, NeardRecord *interface_)
{
  g_object_set (G_OBJECT (object), "record", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NeardObjectManagerClient
 * @title: NeardObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses neard_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * NeardObjectManagerClient:
 *
 * The #NeardObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NeardObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NeardObjectManagerClient.
 */

G_DEFINE_TYPE (NeardObjectManagerClient, neard_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT);

static void
neard_object_manager_client_init (NeardObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
neard_object_manager_client_class_init (NeardObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * neard_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (allow-none): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy<!-- -->- and #GDBusProxy<!-- -->-derived types.
 *
 * Returns: A #GDBusProxy<!-- -->-derived #GType if @interface_name is not %NULL, otherwise the #GType for #NeardObjectProxy.
 */
GType
neard_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return NEARD_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.Adapter", GSIZE_TO_POINTER (NEARD_TYPE_ADAPTER_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.NDEFAgent", GSIZE_TO_POINTER (NEARD_TYPE_NDEFAGENT_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.HandoverAgent", GSIZE_TO_POINTER (NEARD_TYPE_HANDOVER_AGENT_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.Manager", GSIZE_TO_POINTER (NEARD_TYPE_MANAGER_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.AgentManager", GSIZE_TO_POINTER (NEARD_TYPE_AGENT_MANAGER_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.Tag", GSIZE_TO_POINTER (NEARD_TYPE_TAG_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.Device", GSIZE_TO_POINTER (NEARD_TYPE_DEVICE_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.neard.Record", GSIZE_TO_POINTER (NEARD_TYPE_RECORD_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) GPOINTER_TO_SIZE (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * neard_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using neard_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_object_manager_client_new_finish() to get the result of the operation.
 *
 * See neard_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (NEARD_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", neard_object_manager_client_get_proxy_type, NULL);
}

/**
 * neard_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_object_manager_client_new().
 *
 * Returns: (transfer full) (type NeardObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
neard_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * neard_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using neard_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
neard_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", neard_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * neard_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like neard_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call neard_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See neard_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
neard_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (NEARD_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", neard_object_manager_client_get_proxy_type, NULL);
}

/**
 * neard_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to neard_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with neard_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type NeardObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
neard_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * neard_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like neard_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See neard_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NeardObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
neard_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (NEARD_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", neard_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


