#include "phceT2T_Sw.h"

#define URI                0
#define MAX_SMARTPOSTER    1
#define BIG_MIME_IMAGE     2
#define MAX_VCARD          3
#define TEXT               4
#define TEXT_ZERO          5
#define TEXT_LONG          6


// define this to one of the above for NDEF predefined content
#define T2T_NDEFFILE_PREDEF   4

const uint8_t T2T_LOCK_CC_DEF[30] = {
      0x00, 0x00, 0x00, 0x00,	   // internal bytes
      0x00, 0x00, 0x00, 0x00,	   // internal bytes
      0x00, 0x00, 0x00, 0x00,	   // internal bytes AND
      // static lock bytes (last 2 bytes here)
      // CC
      0xE1, 0x10, 0xEA, 0x00
      
      // 3rd byte - data memory in bytes / 8
      // 0xE1 - magic number
      // 0x10 - version
      // 0x00 - TAG memory size * 8 in bytes
      //      example 0x06 = 48 bytes / 0x10 = 128 bytes / 0x00 = 2040 bytes
      // 0x00 - read and write access without any security
};

#if T2T_NDEFFILE_PREDEF == URI
const uint8_t T2T_DATA_DEF[] = {
      // NDEF TLV
      0x03, 0x10,
      // NXP URL Record
      0xD1, 						// MB=1, ME=1, CF=0, SR=1, IL=0, TNF=0x01
      0x01, 						// TYPE field length = 1 bytes
      0x0C, 						// Payload Length 12 bytes
      0x55, 						// "U" Well Known Type for an URI record
      0x01, 0x6E,
      0x78, 0x70, 0x2E, 0x63,
      0x6F, 0x6D, 0x2F, 0x6E,
      0x66, 0x63, // URL: www.nxp.com/nfc
      // Terminator TLV
      0xF3
};
#endif

#if T2T_NDEFFILE_PREDEF == TEXT
const uint8_t T2T_DATA_DEF[] = {
      // NDEF TLV
      0x03,                   // 0x03 - Contains an NDEF message
      0x18,                   // total msg length. 20+4 bytes
      // NXP URL Record
      0xD1,                   // MB=1, ME=1, CF=0, SR=1, IL=0, TNF=0x01
      0x01,                   // TYPE field length = 1 bytes
      0x14,                   // Payload Length 21 bytes 17+3
      0x54,                   // TYPE TEXT
      // PAYLOAD
      0x02,                   // ID UTF8
      0x65, 0x6e,             // LOCALE EN
      'N','x','p',' ','T','2','T',' ','E','m','u','l','a','t','i','o','n', // text
      // Terminator TLV
      0xF3
};
#endif
#if T2T_NDEFFILE_PREDEF == TEXT

const uint8_t T2T_DATA_DEF2[] = {
      // NDEF TLV
      0x03,                   // 0x03 - Contains an NDEF message
      0x18,                   // total msg length. 20+4 bytes
      // NXP URL Record
      0xD1,                   // MB=1, ME=1, CF=0, SR=1, IL=0, TNF=0x01
      0x01,                   // TYPE field length = 1 bytes
      0x14,                   // Payload Length 21 bytes 17+3
      0x54,                   // TYPE TEXT
      // PAYLOAD
      0x02,                   // ID UTF8
      0x65, 0x6e,             // LOCALE EN
      'H','a','l',' ','F','A','B',' ','E','m','u','l','a','t','i','o','n', // text
      // Terminator TLV
      0xF3
};
#endif


#if T2T_NDEFFILE_PREDEF == TEXT_ZERO
const uint8_t T2T_DATA_DEF[] = {
      // NDEF TLV
      0x03,                   // 0x03 - Contains an NDEF message
      0x07,
      // NXP URL Record
      0xD1,                   // MB=1, ME=1, CF=0, SR=1, IL=0, TNF=0x01
      0x01,                   // TYPE field length = 1 bytes
      0x03,                   // Payload Length 3 bytes
      0x54,                   // TYPE TEXT
      // PAYLOAD
      0x02,                   // ID UTF8
      0x65, 0x6e,             // LOCALE EN
                              // not any message - zero message
      // Terminator TLV
      0xF3
};
#endif

#if T2T_NDEFFILE_PREDEF == TEXT_LONG
const uint8_t T2T_DATA_DEF[] = {
      // NDEF TLV
      0x03,                   // 0x03 - Contains an NDEF message
      0xFF, 0x01,0xFE,        // NDEF message length
      // NXP URL Record
      0xC1,                   // MB=1, ME=1, CF=0, SR=1, IL=0, TNF=0x01
      0x01,                   // TYPE field length = 1 bytes
      0x00, 0x00,0x01,0xF7,   // Payload Length 503 bytes
      0x54,                   // TYPE TEXT
      // PAYLOAD
      0x02,                   // ID UTF8
      0x65, 0x6e,             // LOCALE EN
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  // text: 10 chars per line
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  // 100
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  // 200
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  // 300
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  // 400
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  //
      'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',  // 500
      // Terminator TLV
      0xF3
};
#endif

#if T2T_NDEFFILE_PREDEF == MAX_SMARTPOSTER
// NDEF with maximum size (SmartPoster)
const uint8_t T2T_DATA_DEF[2040] = {
	0x03, 0xFF, 0x07, 0xF4,
	0xC1,
	0x02,                      // Record name length   (2 bytes)
	0x00, 0x00,	0x07, 0xEC,    // Length of the Smart Poster data
	0x53,	0x70,                // smart poster "Sp"
	0x81,                      // NDEF header. TNF = 0x01, SR=0, MB=1, ME=0
	0x01,                      // Record name length   (1 byte)
   0x00, 0x00, 0x07, 0xCE,
   0x54,                      // TYPE TEXT
   // PAYLOAD
   0x02,                      // ID UTF8
   0x65, 0x6e,                // LOCALE EN
	0x4C, 0x6F,	0x72, 0x65, 0x6D, 0x20, 0x69, 0x70, 0x73, 0x75, // 10    0x7DA
	0x6D, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20,             // 18
	0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74,             // 26
	0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63,
	0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x61, 0x64,
	0x69, 0x70, 0x69, 0x73, 0x63, 0x69, 0x6E, 0x67,
	0x20, 0x65, 0x6C, 0x69, 0x74, 0x2E, 0x20, 0x49,
	0x6E, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x69,
	0x6E, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20,
	0x61, 0x74, 0x20, 0x65, 0x6E, 0x69, 0x6D, 0x20,
	0x6F, 0x72, 0x6E, 0x61, 0x72, 0x65, 0x20, 0x74,
	0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74,   // 98
	0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20,
	0x69, 0x64, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75,
	0x73, 0x20, 0x63, 0x75, 0x72, 0x73, 0x75, 0x73,
	0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x20,
	0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64,
	0x61, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61,
	0x74, 0x20, 0x61, 0x74, 0x20, 0x73, 0x65, 0x64,
	0x20, 0x6F, 0x72, 0x63, 0x69, 0x2E, 0x20, 0x51,
	0x75, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x65,
	0x6C, 0x69, 0x74, 0x20, 0x6E, 0x69, 0x73, 0x69,
	0x2C, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70,
	0x61, 0x74, 0x20, 0x61, 0x20, 0x61, 0x64, 0x69,   // 194
	0x70, 0x69, 0x73, 0x63, 0x69, 0x6E, 0x67, 0x20,
	0x69, 0x64, 0x2C, 0x20, 0x65, 0x6C, 0x65, 0x69,
	0x66, 0x65, 0x6E, 0x64, 0x20, 0x73, 0x69, 0x74,
	0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x64, 0x75,
	0x69, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x65,
	0x75, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20,
	0x6E, 0x65, 0x63, 0x20, 0x69, 0x70, 0x73, 0x75,
	0x6D, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x20,
	0x64, 0x69, 0x63, 0x74, 0x75, 0x6D, 0x20, 0x6E,
	0x6F, 0x6E, 0x20, 0x61, 0x63, 0x20, 0x6E, 0x75,
	0x6C, 0x6C, 0x61, 0x2E, 0x20, 0x56, 0x69, 0x76,
	0x61, 0x6D, 0x75, 0x73, 0x20, 0x76, 0x65, 0x6C,
	0x20, 0x65, 0x6E, 0x69, 0x6D, 0x20, 0x73, 0x65,   // 298
	0x64, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20,
	0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C, 0x6C, 0x69,
	0x73, 0x20, 0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C,
	0x6C, 0x69, 0x73, 0x2E, 0x20, 0x4D, 0x6F, 0x72,
	0x62, 0x69, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73,
	0x20, 0x64, 0x75, 0x69, 0x2C, 0x20, 0x76, 0x75,
	0x6C, 0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20,
	0x65, 0x75, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69,
	0x63, 0x65, 0x73, 0x20, 0x73, 0x69, 0x74, 0x20,
	0x61, 0x6D, 0x65, 0x74, 0x2C, 0x20, 0x70, 0x6F,
	0x72, 0x74, 0x74, 0x69, 0x74, 0x6F, 0x72, 0x20,
	0x65, 0x74, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x2E,    // 394
	0x20, 0x56, 0x69, 0x76, 0x61, 0x6D, 0x75, 0x73,
	0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x20, 0x6E,
	0x69, 0x73, 0x6C, 0x2C, 0x20, 0x64, 0x61, 0x70,
	0x69, 0x62, 0x75, 0x73, 0x20, 0x61, 0x74, 0x20,
	0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x65,
	0x67, 0x65, 0x74, 0x2C, 0x20, 0x65, 0x6C, 0x65,
	0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x71, 0x75,
	0x69, 0x73, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x2E,
	0x20, 0x43, 0x75, 0x72, 0x61, 0x62, 0x69, 0x74,
	0x75, 0x72, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69,
	0x73, 0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61,
	0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x67, 0x75, 0x65,
	0x20, 0x61, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75,
	0x73, 0x20, 0x76, 0x65, 0x6C, 0x2C, 0x20, 0x76,    // 498
	0x69, 0x76, 0x65, 0x72, 0x72, 0x61, 0x20, 0x65,
	0x74, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x2E, 0x20,
	0x43, 0x75, 0x6D, 0x20, 0x73, 0x6F, 0x63, 0x69,
	0x69, 0x73, 0x20, 0x6E, 0x61, 0x74, 0x6F, 0x71,
	0x75, 0x65, 0x20, 0x70, 0x65, 0x6E, 0x61, 0x74,
	0x69, 0x62, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20,
	0x6D, 0x61, 0x67, 0x6E, 0x69, 0x73, 0x20, 0x64,
	0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74, 0x75,
	0x72, 0x69, 0x65, 0x6E, 0x74, 0x20, 0x6D, 0x6F,
	0x6E, 0x74, 0x65, 0x73, 0x2C, 0x20, 0x6E, 0x61,
	0x73, 0x63, 0x65, 0x74, 0x75, 0x72, 0x20, 0x72,
	0x69, 0x64, 0x69, 0x63, 0x75, 0x6C, 0x75, 0x73,
	0x20, 0x6D, 0x75, 0x73, 0x2E, 0x20, 0x4D, 0x61,
	0x75, 0x72, 0x69, 0x73, 0x20, 0x64, 0x61, 0x70,
	0x69, 0x62, 0x75, 0x73, 0x20, 0x63, 0x75, 0x72,
	0x73, 0x75, 0x73, 0x20, 0x74, 0x65, 0x6D, 0x70,
	0x6F, 0x72, 0x2E, 0x20, 0x43, 0x75, 0x72, 0x61,
	0x62, 0x69, 0x74, 0x75, 0x72, 0x20, 0x61, 0x20,
	0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x61,
	0x75, 0x67, 0x75, 0x65, 0x2E, 0x20, 0x4E, 0x75,
	0x6E, 0x63, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75,
	0x73, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F,
	0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65,
	0x74, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x20,
	0x73, 0x6F, 0x64, 0x61, 0x6C, 0x65, 0x73, 0x20,
	0x76, 0x65, 0x6E, 0x65, 0x6E, 0x61, 0x74, 0x69,
	0x73, 0x2E, 0x20, 0x43, 0x72, 0x61, 0x73, 0x20,
	0x63, 0x75, 0x72, 0x73, 0x75, 0x73, 0x2C, 0x20,
	0x6F, 0x64, 0x69, 0x6F, 0x20, 0x69, 0x6E, 0x20,
	0x63, 0x6F, 0x6E, 0x73, 0x65, 0x71, 0x75, 0x61,
	0x74, 0x20, 0x70, 0x68, 0x61, 0x72, 0x65, 0x74,
	0x72, 0x61, 0x2C, 0x20, 0x65, 0x73, 0x74, 0x20,
	0x6D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x73,
	0x6F, 0x64, 0x61, 0x6C, 0x65, 0x73, 0x20, 0x65,
	0x72, 0x61, 0x74, 0x2C, 0x20, 0x68, 0x65, 0x6E,
	0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x20, 0x63,
	0x75, 0x72, 0x73, 0x75, 0x73, 0x20, 0x6C, 0x69,
	0x67, 0x75, 0x6C, 0x61, 0x20, 0x73, 0x65, 0x6D,
	0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x67, 0x6E,
	0x61, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x68, 0x61,
	0x63, 0x20, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61,
	0x73, 0x73, 0x65, 0x20, 0x70, 0x6C, 0x61, 0x74,
	0x65, 0x61, 0x20, 0x64, 0x69, 0x63, 0x74, 0x75,
	0x6D, 0x73, 0x74, 0x2E, 0x20, 0x49, 0x6E, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x20, 0x70, 0x75, 0x6C,
	0x76, 0x69, 0x6E, 0x61, 0x72, 0x20, 0x62, 0x6C,
	0x61, 0x6E, 0x64, 0x69, 0x74, 0x20, 0x76, 0x61,
	0x72, 0x69, 0x75, 0x73, 0x2E, 0x20, 0x4E, 0x75,
	0x6C, 0x6C, 0x61, 0x6D, 0x20, 0x73, 0x61, 0x67,
	0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x62, 0x69,
	0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x75,
	0x72, 0x6E, 0x61, 0x20, 0x65, 0x74, 0x20, 0x6D,
	0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65, 0x2E,
	0x20, 0x44, 0x75, 0x69, 0x73, 0x20, 0x6E, 0x65,
	0x63, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20,
	0x69, 0x6E, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73,
	0x20, 0x70, 0x75, 0x6C, 0x76, 0x69, 0x6E, 0x61,
	0x72, 0x20, 0x6D, 0x61, 0x74, 0x74, 0x69, 0x73,
	0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x6D,
	0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x70,
	0x75, 0x72, 0x75, 0x73, 0x20, 0x64, 0x75, 0x69,
	0x2E, 0x20, 0x50, 0x72, 0x6F, 0x69, 0x6E, 0x20,
	0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x6C, 0x6F,
	0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x6C,
	0x6F, 0x72, 0x65, 0x6D, 0x2E, 0x20, 0x44, 0x75,
	0x69, 0x73, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69,
	0x63, 0x69, 0x74, 0x75, 0x64, 0x69, 0x6E, 0x20,
	0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x20, 0x61,
	0x63, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x20, 0x64,
	0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D,
	0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69,
	0x73, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x64, 0x61,
	0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x6D, 0x69,
	0x20, 0x69, 0x6E, 0x20, 0x73, 0x65, 0x6D, 0x20,
	0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E,
	0x74, 0x20, 0x61, 0x20, 0x65, 0x67, 0x65, 0x73,
	0x74, 0x61, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x69,
	0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75,
	0x6D, 0x2E, 0x20, 0x4D, 0x61, 0x75, 0x72, 0x69,
	0x73, 0x20, 0x69, 0x64, 0x20, 0x6F, 0x72, 0x63,
	0x69, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x2C, 0x20,
	0x6E, 0x65, 0x63, 0x20, 0x76, 0x75, 0x6C, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6D, 0x61,
	0x73, 0x73, 0x61, 0x2E, 0x20, 0x4E, 0x75, 0x6C,
	0x6C, 0x61, 0x20, 0x75, 0x74, 0x20, 0x65, 0x73,
	0x74, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E,
	0x2E, 0x20, 0x56, 0x65, 0x73, 0x74, 0x69, 0x62,
	0x75, 0x6C, 0x75, 0x6D, 0x20, 0x61, 0x6E, 0x74,
	0x65, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20,
	0x70, 0x72, 0x69, 0x6D, 0x69, 0x73, 0x20, 0x69,
	0x6E, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69, 0x62,
	0x75, 0x73, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20,
	0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65,
	0x74, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63,
	0x65, 0x73, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65,
	0x72, 0x65, 0x20, 0x63, 0x75, 0x62, 0x69, 0x6C,
	0x69, 0x61, 0x20, 0x43, 0x75, 0x72, 0x61, 0x65,
	0x3B, 0x20, 0x56, 0x69, 0x76, 0x61, 0x6D, 0x75,
	0x73, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69,
	0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75,
	0x61, 0x64, 0x61, 0x20, 0x73, 0x65, 0x6D, 0x20,
	0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74,
	0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74,
	0x75, 0x6D, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C,
	0x61, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x20,
	0x6E, 0x69, 0x73, 0x69, 0x2C, 0x20, 0x70, 0x72,
	0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x65, 0x75,
	0x20, 0x63, 0x6F, 0x6E, 0x67, 0x75, 0x65, 0x20,
	0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x2C,
	0x20, 0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C, 0x6C,
	0x69, 0x73, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x6D,
	0x69, 0x2E, 0x20, 0x45, 0x74, 0x69, 0x61, 0x6D,
	0x20, 0x64, 0x75, 0x69, 0x20, 0x75, 0x72, 0x6E,
	0x61, 0x2C, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65,
	0x72, 0x61, 0x74, 0x20, 0x69, 0x6E, 0x20, 0x74,
	0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74,
	0x20, 0x61, 0x2C, 0x20, 0x76, 0x65, 0x73, 0x74,
	0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x73,
	0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20,
	0x6C, 0x61, 0x63, 0x75, 0x73, 0x2E, 0x20, 0x4C,
	0x6F, 0x72, 0x65, 0x6D, 0x20, 0x69, 0x70, 0x73,
	0x75, 0x6D, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72,
	0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65,
	0x74, 0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65,
	0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x61,
	0x64, 0x69, 0x70, 0x69, 0x73, 0x63, 0x69, 0x6E,
	0x67, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x2E, 0x20,
	0x50, 0x72, 0x61, 0x65, 0x73, 0x65, 0x6E, 0x74,
	0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69, 0x6D, 0x65,
	0x6E, 0x74, 0x75, 0x6D, 0x20, 0x63, 0x6F, 0x6E,
	0x76, 0x61, 0x6C, 0x6C, 0x69, 0x73, 0x20, 0x69,
	0x61, 0x63, 0x75, 0x6C, 0x69, 0x73, 0x2E, 0x20,
	0x4D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x69,
	0x61, 0x63, 0x75, 0x6C, 0x69, 0x73, 0x20, 0x62,
	0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x20, 0x6D,
	0x61, 0x75, 0x72, 0x69, 0x73, 0x2C, 0x20, 0x73,
	0x65, 0x64, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69,
	0x75, 0x6D, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x20,
	0x72, 0x75, 0x74, 0x72, 0x75, 0x6D, 0x20, 0x69,
	0x6E, 0x2E, 0x20, 0x50, 0x68, 0x61, 0x73, 0x65,
	0x6C, 0x6C, 0x75, 0x73, 0x20, 0x76, 0x65, 0x6C,
	0x20, 0x74, 0x65, 0x6D, 0x70, 0x75, 0x73, 0x20,
	0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x2E, 0x20, 0x50,
	0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73,
	0x71, 0x75, 0x65, 0x20, 0x73, 0x69, 0x74, 0x20,
	0x61, 0x6D, 0x65, 0x74, 0x20, 0x63, 0x6F, 0x6E,
	0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72,
	0x20, 0x6E, 0x69, 0x62, 0x68, 0x2E, 0x20, 0x50,
	0x72, 0x6F, 0x69, 0x6E, 0x20, 0x6E, 0x75, 0x6C,
	0x6C, 0x61, 0x20, 0x74, 0x6F, 0x72, 0x74, 0x6F,
	0x72, 0x2C, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x75,
	0x73, 0x20, 0x61, 0x63, 0x20, 0x70, 0x68, 0x61,
	0x72, 0x65, 0x74, 0x72, 0x61, 0x20, 0x61, 0x2C,
	0x20, 0x70, 0x6F, 0x72, 0x74, 0x74, 0x69, 0x74,
	0x6F, 0x72, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20,
	0x6D, 0x61, 0x67, 0x6E, 0x61, 0x2E, 0x20, 0x4E,
	0x75, 0x6E, 0x63, 0x20, 0x70, 0x6F, 0x73, 0x75,
	0x65, 0x72, 0x65, 0x20, 0x65, 0x6E, 0x69, 0x6D,
	0x20, 0x65, 0x74, 0x20, 0x6C, 0x65, 0x63, 0x74,
	0x75, 0x73, 0x20, 0x63, 0x6F, 0x6E, 0x67, 0x75,
	0x65, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D,
	0x65, 0x74, 0x20, 0x64, 0x69, 0x63, 0x74, 0x75,
	0x6D, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F,
	0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x2E,
	0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74,
	0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x61, 0x20,
	0x6E, 0x69, 0x73, 0x69, 0x20, 0x61, 0x20, 0x71,
	0x75, 0x61, 0x6D, 0x20, 0x66, 0x61, 0x63, 0x69,
	0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x65, 0x6C,
	0x65, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20,
	0x6C, 0x61, 0x63, 0x69, 0x6E, 0x69, 0x61, 0x20,
	0x69, 0x6E, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69,
	0x73, 0x2E, 0x20, 0x43, 0x75, 0x72, 0x61, 0x62,
	0x69, 0x74, 0x75, 0x72, 0x20, 0x61, 0x64, 0x69,
	0x70, 0x69, 0x73, 0x63, 0x69, 0x6E, 0x67, 0x20,
	0x6E, 0x69, 0x62, 0x68, 0x20, 0x76, 0x75, 0x6C,
	0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20, 0x61,
	0x6E, 0x74, 0x65, 0x20, 0x61, 0x63, 0x63, 0x75,
	0x6D, 0x73, 0x61, 0x6E, 0x20, 0x63, 0x6F, 0x6E,
	0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72,
	0x2E, 0x20, 0x41, 0x6C, 0x69, 0x71, 0x75, 0x61,
	0x6D, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20,
	0x69, 0x70, 0x73, 0x75, 0x6D, 0x2C, 0x20, 0x6C,
	0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20,
	0x65, 0x75, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x74,
	0x69, 0x74, 0x6F, 0x72, 0x20, 0x73, 0x65, 0x64,
	0x2E, 0x11, 0x01, 0x0C, 0x55, 0x01, 0x6E, 0x78,
	0x70, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x6E, 0x66,
	0x63, 0x51, 0x03, 0x01, 0x61, 0x63, 0x74, 0x00
};
#endif

#if T2T_NDEFFILE_PREDEF == BIG_MIME_IMAGE
const uint8_t T2T_DATA_DEF[2031] = {
    0x03, 0xFF, 0x07, 0xEB, 0xC2, 0x09, 0x00, 0x00,
    0x07, 0xDC, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F,
    0x67, 0x69, 0x66, 0x47, 0x49, 0x46, 0x38, 0x39,
    0x61, 0x46, 0x00, 0x46, 0x00, 0xF7, 0x00, 0x00,
    0x78, 0xB0, 0xE0, 0xF9, 0xB1, 0x00, 0xF9, 0xB3,
    0x00, 0xC6, 0xD0, 0x00, 0xFA, 0xC5, 0x3A, 0x6F,
    0x95, 0x2B, 0xFA, 0xB1, 0x00, 0xC5, 0xD0, 0x00,
    0x7C, 0x9D, 0x8A, 0x90, 0x8C, 0x55, 0xFD, 0xFD,
    0xFC, 0xC8, 0xD2, 0x05, 0xFF, 0xFD, 0xF7, 0xE8,
    0xE2, 0x74, 0xFD, 0xFF, 0xFB, 0x6F, 0x95, 0x29,
    0xC6, 0xD1, 0x00, 0xFF, 0xFE, 0xFB, 0xB0, 0xC5,
    0x8C, 0xC8, 0xD1, 0x01, 0xF5, 0xF4, 0xC5, 0xD2,
    0xDA, 0x2C, 0xFA, 0xC3, 0x30, 0x97, 0x84, 0x31,
    0x6A, 0x92, 0x24, 0xFC, 0xFD, 0xF3, 0xC2, 0xB9,
    0x90, 0xFE, 0xFE, 0xFC, 0xF9, 0xB2, 0x00, 0xFB,
    0xCD, 0x51, 0x98, 0x85, 0x33, 0xF1, 0xDD, 0x74,
    0xCE, 0xD6, 0x1C, 0xFD, 0xFE, 0xFF, 0xF0, 0xE8,
    0x95, 0xFF, 0xB7, 0x00, 0xF1, 0xE5, 0x8A, 0xCA,
    0xD1, 0x04, 0xCB, 0xCB, 0x04, 0x73, 0xAD, 0xDD,
    0x87, 0x78, 0x29, 0x71, 0xAC, 0xDD, 0xCC, 0xD4,
    0x13, 0xC8, 0xD3, 0x00, 0x7D, 0xB3, 0xDE, 0xFE,
    0xFC, 0xF1, 0x76, 0xAF, 0xDE, 0xC4, 0xCF, 0x00,
    0x89, 0x7A, 0x36, 0xE8, 0xF1, 0xF9, 0xFF, 0xFE,
    0xFD, 0x91, 0xBF, 0xE3, 0xFA, 0xAF, 0x00, 0x77,
    0xB0, 0xDE, 0xFC, 0xB4, 0x01, 0x6F, 0xAB, 0xDC,
    0xF5, 0xF9, 0xFD, 0x6C, 0xAA, 0xDB, 0x68, 0x92,
    0x2D, 0xCE, 0xD9, 0x00, 0x88, 0xB9, 0xE1, 0xEA,
    0xB4, 0x05, 0xFE, 0xFC, 0xF3, 0xCD, 0xD4, 0x00,
    0xFE, 0xB5, 0x00, 0x81, 0xA0, 0x88, 0xBE, 0xD9,
    0xEE, 0xD7, 0xE7, 0xF4, 0xF4, 0xE5, 0x92, 0xCA,
    0xD3, 0x0C, 0xC2, 0x98, 0x1B, 0xA5, 0xCA, 0xE9,
    0xF9, 0xB3, 0x01, 0xFD, 0xFE, 0xF9, 0xDB, 0xE9,
    0xF5, 0xF8, 0xFB, 0xFE, 0xA3, 0xB5, 0x13, 0xC7,
    0xD2, 0x00, 0xFB, 0xFC, 0xFE, 0x74, 0xAE, 0xDD,
    0xFD, 0xF2, 0xCF, 0xFA, 0xC1, 0x2A, 0x92, 0x80,
    0x32, 0xB6, 0x9B, 0x19, 0x95, 0x8D, 0x26, 0xF0,
    0xDC, 0x6F, 0x6D, 0x94, 0x2C, 0xC9, 0xD4, 0x00,
    0x87, 0x9D, 0x23, 0xFC, 0xE7, 0xA9, 0x76, 0x9A,
    0x86, 0xFA, 0xBD, 0x1C, 0xFC, 0xFE, 0xF3, 0xB9,
    0xD6, 0xF0, 0xF9, 0xB6, 0x14, 0xF8, 0xF5, 0xD0,
    0xFF, 0xBB, 0x00, 0xFB, 0xF7, 0xDB, 0x8B, 0x89,
    0x57, 0xF4, 0xCC, 0x3F, 0x88, 0x78, 0x2A, 0x83,
    0x79, 0x36, 0xC9, 0xD2, 0x06, 0xDC, 0xCB, 0x95,
    0x73, 0xAD, 0xDE, 0x97, 0x90, 0x51, 0xCE, 0xAB,
    0x0F, 0x66, 0x90, 0x2F, 0xF9, 0xB1, 0x07, 0x77,
    0x9B, 0x8C, 0x85, 0x7D, 0x3D, 0x8B, 0x7D, 0x36,
    0xF5, 0xB5, 0x04, 0xAC, 0xBE, 0x0E, 0xFD, 0xFB,
    0xEA, 0xB5, 0xD3, 0xEC, 0xF5, 0xEA, 0xA4, 0xD7,
    0xA4, 0x15, 0x98, 0x85, 0x31, 0xA7, 0xAF, 0x15,
    0xFF, 0xFF, 0xFC, 0xE6, 0xAA, 0x0B, 0x9B, 0x87,
    0x33, 0xFE, 0xFF, 0xFC, 0xFB, 0xB3, 0x01, 0x65,
    0x8F, 0x24, 0xD0, 0xE3, 0xF3, 0xFA, 0xC3, 0x34,
    0xF9, 0xB3, 0x0A, 0xEC, 0xB8, 0x05, 0xBB, 0xC9,
    0x06, 0x8A, 0x7E, 0x31, 0x6D, 0x90, 0x2E, 0xF7,
    0xFA, 0xFB, 0x8E, 0x7D, 0x35, 0xF2, 0xDB, 0x6B,
    0x7B, 0x9A, 0x24, 0xF1, 0xE9, 0x9A, 0xF9, 0xB2,
    0x03, 0x92, 0x9C, 0x22, 0x72, 0x93, 0x29, 0x82,
    0x74, 0x29, 0x6A, 0x93, 0x2D, 0x68, 0x92, 0x2B,
    0xC7, 0xD1, 0x01, 0xF2, 0xD1, 0x4D, 0xEF, 0xD5,
    0x53, 0x75, 0xAE, 0xDF, 0x73, 0xAE, 0xDD, 0x8A,
    0x9B, 0x1D, 0xFB, 0xFB, 0xE5, 0xB2, 0xD2, 0xEE,
    0xC0, 0xB6, 0x8F, 0xFC, 0xB6, 0x02, 0xCF, 0xA2,
    0x15, 0xFE, 0xFE, 0xFB, 0xEA, 0xDF, 0x6A, 0xEE,
    0xF5, 0xFA, 0xFB, 0xED, 0xBC, 0xBB, 0xD7, 0xED,
    0x89, 0x7A, 0x32, 0xFB, 0xDB, 0x86, 0x95, 0x82,
    0x32, 0xFA, 0xF8, 0xD9, 0xFB, 0xE2, 0x99, 0xF1,
    0xD2, 0x50, 0xAF, 0xC4, 0x89, 0xC9, 0xDF, 0xF3,
    0xF3, 0xCC, 0x42, 0xFC, 0xE8, 0xAF, 0xFB, 0xCF,
    0x5B, 0xC7, 0xD1, 0x02, 0xF7, 0xF5, 0xCA, 0xCA,
    0xD0, 0x00, 0xF9, 0xBA, 0x16, 0xFF, 0xFF, 0xF6,
    0xF2, 0xC4, 0x24, 0xC1, 0xCA, 0x86, 0xF7, 0xF8,
    0xD8, 0x9A, 0xC4, 0xE7, 0xFD, 0xFE, 0xFC, 0xFF,
    0xFE, 0xFF, 0xFF, 0xFD, 0xEF, 0x92, 0xAE, 0x19,
    0xD0, 0xD7, 0x21, 0xE8, 0xEB, 0x90, 0xEF, 0xD8,
    0x5B, 0xEA, 0xE4, 0x7C, 0x91, 0x7F, 0x2A, 0xF7,
    0xF2, 0xC5, 0xF8, 0xC4, 0x31, 0xFB, 0xFB, 0xE8,
    0xE9, 0xE4, 0x7A, 0xFE, 0xFE, 0xFD, 0xF3, 0xDB,
    0x70, 0xBF, 0xB9, 0x95, 0xFB, 0xCE, 0x55, 0xEF,
    0xE2, 0x7E, 0xF9, 0xB6, 0x08, 0xBA, 0xBC, 0x05,
    0xFB, 0xFD, 0xF0, 0xC4, 0xCD, 0xCA, 0xF8, 0xE1,
    0x8E, 0xB8, 0xB6, 0x06, 0xFC, 0xCD, 0x51, 0x8D,
    0x81, 0x20, 0x81, 0xB5, 0xDD, 0xC0, 0xBA, 0x95,
    0xF0, 0xEF, 0xAC, 0xF9, 0xB5, 0x0F, 0xF7, 0xD8,
    0x70, 0x99, 0x86, 0x33, 0xF0, 0xF2, 0xB3, 0xCE,
    0xD7, 0x20, 0xCB, 0xD3, 0x00, 0xC7, 0xD1, 0x05,
    0xE8, 0xE3, 0x78, 0xF8, 0xE4, 0x97, 0xB3, 0xD2,
    0xEB, 0xFA, 0xDA, 0x7C, 0xB4, 0xBE, 0xBA, 0x94,
    0x84, 0x2C, 0xEF, 0xEF, 0xAC, 0xFD, 0xFC, 0xFD,
    0xB3, 0xBC, 0x0E, 0xFA, 0xED, 0xB6, 0xF0, 0xCB,
    0x36, 0xD9, 0xDA, 0x3D, 0xFF, 0xFF, 0xFE, 0xF5,
    0xF4, 0xC2, 0x70, 0xAC, 0xDD, 0xED, 0xE7, 0x8D,
    0x84, 0xB7, 0xE1, 0xF6, 0xF7, 0xD4, 0xD4, 0xDA,
    0x1A, 0xF6, 0xEF, 0xB5, 0xF1, 0xF7, 0xFB, 0xB5,
    0xD4, 0xEC, 0x8D, 0x80, 0x1C, 0xE3, 0xAF, 0x1A,
    0xB6, 0xC9, 0x9A, 0xFB, 0xE5, 0xA1, 0x94, 0xAE,
    0x31, 0xFE, 0xB5, 0x02, 0xD7, 0xDD, 0x3F, 0xE1,
    0xE0, 0x5D, 0xDC, 0xDC, 0x49, 0xD4, 0xD8, 0x30,
    0x78, 0xB0, 0xDE, 0xC7, 0xD1, 0x00, 0xF9, 0xB4,
    0x02, 0xD2, 0xD0, 0xD0, 0xFF, 0xFF, 0xFF, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x21, 0xF9, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x2C, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x46,
    0x00, 0x00, 0x08, 0xFF, 0x00, 0xF7, 0x09, 0x1C,
    0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A,
    0x5C, 0x58, 0x90, 0x9F, 0xC3, 0x87, 0x10, 0x23,
    0x4A, 0x9C, 0x48, 0xB1, 0xA2, 0xC5, 0x8B, 0x0E,
    0x05, 0x62, 0xDC, 0xC8, 0xB1, 0x23, 0x47, 0x8D,
    0x1E, 0x43, 0x8A, 0xF4, 0x08, 0x72, 0xA4, 0xC9,
    0x93, 0x12, 0x4B, 0xA2, 0x5C, 0x69, 0x52, 0x25,
    0xCB, 0x97, 0x1D, 0x5D, 0xC2, 0x9C, 0x69, 0x51,
    0x26, 0xCD, 0x9B, 0x11, 0x6D, 0xE2, 0xDC, 0xA9,
    0x73, 0xE7, 0xCD, 0x9E, 0x3E, 0x67, 0x02, 0x0D,
    0xFA, 0x72, 0x28, 0xD1, 0x95, 0x46, 0x8F, 0x9E,
    0x4C, 0xAA, 0x74, 0x24, 0xD3, 0xA6, 0x21, 0x9F,
    0x42, 0x8D, 0xB9, 0x6F, 0xEA, 0xCF, 0xAA, 0x56,
    0x85, 0x62, 0xCD, 0x5A, 0x74, 0x2B, 0x57, 0xA4,
    0x5E, 0xBF, 0x2E, 0xDD, 0xB7, 0x27, 0x89, 0x83,
    0xB3, 0x0E, 0xCC, 0x62, 0x74, 0xA2, 0x60, 0x83,
    0x5B, 0xB7, 0xC1, 0x42, 0x58, 0x0C, 0xF1, 0x4D,
    0x81, 0xDD, 0xBB, 0x4E, 0x22, 0xE8, 0xDD, 0xCB,
    0x57, 0xAF, 0x8C, 0x89, 0x02, 0x89, 0x48, 0xFA,
    0x40, 0xF8, 0x83, 0xAE, 0x2A, 0xBF, 0x2E, 0x9E,
    0xC1, 0xA4, 0xA1, 0x71, 0xE3, 0x67, 0x97, 0x94,
    0x50, 0x2C, 0xD4, 0x85, 0x9B, 0x84, 0xCB, 0x98,
    0x63, 0x35, 0xD8, 0xCC, 0xB9, 0xF3, 0x66, 0x6C,
    0xDE, 0xD2, 0xC9, 0x81, 0x28, 0xF0, 0x0F, 0x0D,
    0x03, 0xA8, 0x51, 0x07, 0x88, 0x84, 0xCC, 0x62,
    0x14, 0x77, 0x8D, 0xC8, 0xA0, 0x98, 0xED, 0x26,
    0xC7, 0x0C, 0x1C, 0x13, 0xB5, 0xA1, 0xD1, 0x82,
    0xA1, 0x77, 0xEF, 0x3E, 0xCB, 0x20, 0x1C, 0x18,
    0x4E, 0xBC, 0xF8, 0xF0, 0x17, 0x10, 0xC6, 0x41,
    0x7B, 0x28, 0x90, 0x40, 0x00, 0x7D, 0xD0, 0xA1,
    0x23, 0x09, 0x70, 0x48, 0x2E, 0x45, 0x62, 0x6A,
    0x60, 0xE8, 0xF1, 0xE0, 0xC1, 0x4E, 0x02, 0x00,
    0x27, 0x3E, 0x49, 0xFF, 0x1C, 0xC2, 0x62, 0x12,
    0x82, 0x07, 0x05, 0xD2, 0xEB, 0xB8, 0x75, 0x25,
    0x9F, 0xFB, 0xF7, 0xF0, 0xE3, 0xBF, 0xC8, 0x97,
    0x2B, 0xE3, 0x3E, 0xE7, 0xD1, 0xA3, 0x73, 0x50,
    0xA4, 0xAC, 0x22, 0x33, 0x1B, 0x46, 0xC0, 0x30,
    0xCD, 0x05, 0x17, 0x7C, 0x77, 0x02, 0x0B, 0x92,
    0x3D, 0xB4, 0xC4, 0x2C, 0x39, 0x00, 0x70, 0x5E,
    0x7A, 0x56, 0x54, 0xD2, 0x4A, 0x13, 0xF1, 0x55,
    0x18, 0xDF, 0x00, 0x0B, 0xF4, 0xC2, 0x4F, 0x73,
    0xCF, 0xE5, 0x07, 0x5D, 0x00, 0x6C, 0x90, 0x42,
    0x51, 0x07, 0x40, 0xF4, 0x40, 0x85, 0x21, 0x1E,
    0x14, 0x08, 0x00, 0x3E, 0x39, 0x1C, 0xB1, 0xC4,
    0x43, 0xA7, 0x9C, 0xE0, 0x82, 0x83, 0xE8, 0x15,
    0xB0, 0x06, 0x38, 0xD6, 0x58, 0xA8, 0xE3, 0x7B,
    0x2F, 0xDC, 0x43, 0x0E, 0x87, 0x1E, 0xEA, 0xC7,
    0x46, 0x16, 0x13, 0x75, 0x20, 0xC0, 0x08, 0x9A,
    0xBC, 0x41, 0xE0, 0x77, 0xF8, 0xD4, 0x90, 0x82,
    0x1F, 0x0E, 0xC5, 0xC0, 0xC2, 0x09, 0xF8, 0xD0,
    0x58, 0x80, 0x0E, 0x8B, 0x98, 0xB0, 0x42, 0x3E,
    0x13, 0x74, 0xE9, 0xE5, 0x97, 0x13, 0x0C, 0x70,
    0x61, 0x11, 0xA3, 0x00, 0x19, 0xE4, 0x87, 0xAE,
    0x40, 0x21, 0x91, 0x91, 0x25, 0x52, 0x01, 0x83,
    0x07, 0x4C, 0xE2, 0x33, 0x89, 0x33, 0xEC, 0xF0,
    0x33, 0xC7, 0x0D, 0xF8, 0x54, 0x79, 0x9E, 0x15,
    0x8E, 0xC4, 0xF1, 0x03, 0x04, 0x2A, 0x24, 0x22,
    0xC2, 0xA0, 0x84, 0x0E, 0x9A, 0x48, 0x31, 0xB8,
    0x40, 0x00, 0x1F, 0x04, 0x66, 0xD0, 0x61, 0xE6,
    0x99, 0xFA, 0x18, 0x20, 0x8E, 0x25, 0x11, 0x19,
    0xA9, 0xCF, 0x08, 0x75, 0x80, 0x22, 0x45, 0x9C,
    0xF8, 0x3C, 0x21, 0xC4, 0x10, 0x29, 0xE4, 0xA9,
    0xE7, 0x03, 0x84, 0x30, 0xB1, 0x43, 0x3E, 0x03,
    0x54, 0x73, 0x91, 0x0F, 0x2A, 0x2C, 0x5A, 0x02,
    0x09, 0x8F, 0x42, 0xFF, 0x6A, 0x40, 0x24, 0x0E,
    0x40, 0x64, 0xA9, 0x3E, 0x60, 0x4C, 0x31, 0x08,
    0xA7, 0xF8, 0xB0, 0xC0, 0x43, 0x0D, 0xA2, 0x3A,
    0xF8, 0x08, 0x16, 0x26, 0x50, 0x38, 0x00, 0x08,
    0x2D, 0x58, 0x24, 0x03, 0x27, 0x07, 0xBC, 0x07,
    0xC1, 0xAB, 0xB1, 0x46, 0x6A, 0x80, 0x87, 0x01,
    0x48, 0x63, 0xAB, 0x00, 0xD0, 0xD9, 0x10, 0x48,
    0x37, 0x62, 0xAC, 0x28, 0xAA, 0x0B, 0x4F, 0x88,
    0xAA, 0x27, 0x23, 0x77, 0x9C, 0x8A, 0x2A, 0xB2,
    0xCA, 0x02, 0xD3, 0xAC, 0x7B, 0xCF, 0xC2, 0x7A,
    0x5F, 0x87, 0xD0, 0xF1, 0x31, 0x46, 0x29, 0x1C,
    0xE4, 0x27, 0x00, 0x0D, 0xDB, 0x3C, 0x74, 0xEB,
    0xA5, 0x79, 0xF0, 0x2A, 0x6E, 0x9E, 0x00, 0xB4,
    0x81, 0x88, 0x96, 0xEE, 0x1D, 0x9B, 0x6C, 0x45,
    0x32, 0xEC, 0xB2, 0x6E, 0x3E, 0xED, 0xC6, 0xCA,
    0xC1, 0x18, 0x61, 0x6C, 0x81, 0xAD, 0x7E, 0x34,
    0x84, 0xE2, 0xD0, 0xBE, 0x97, 0xA6, 0xE1, 0xED,
    0xBF, 0xC1, 0x06, 0x21, 0x48, 0x7B, 0x05, 0x83,
    0xE0, 0x83, 0x45, 0x9B, 0xD0, 0x23, 0x26, 0xBB,
    0xD0, 0xBE, 0x6B, 0xAF, 0x05, 0xFC, 0x40, 0xB1,
    0x05, 0xBC, 0xFA, 0x70, 0x60, 0x0C, 0x91, 0x1D,
    0x20, 0x91, 0x9F, 0x0D, 0xEF, 0x6C, 0xCC, 0x71,
    0x95, 0x41, 0xFC, 0x00, 0xDF, 0xB1, 0x96, 0x64,
    0x20, 0xF4, 0xD0, 0x44, 0x9F, 0x03, 0x89, 0xAB,
    0xEE, 0xE2, 0x17, 0x9D, 0x00, 0x16, 0x30, 0xC0,
    0x4F, 0x2A, 0x80, 0xC0, 0x6C, 0x00, 0x2C, 0xB2,
    0xA8, 0x32, 0x31, 0x74, 0x70, 0x68, 0xBC, 0x73,
    0xC7, 0x1F, 0xC3, 0x67, 0x46, 0x05, 0x60, 0x87,
    0x2D, 0x76, 0x05, 0xAB, 0xC4, 0x07, 0x41, 0x11,
    0xEB, 0xC4, 0xCA, 0xB4, 0xD3, 0xFC, 0xC4, 0x13,
    0x75, 0x7E, 0x06, 0xA0, 0xE2, 0x4B, 0x7E, 0x23,
    0x4C, 0x91, 0x00, 0xB0, 0x5B, 0x57, 0x29, 0x30,
    0xC1, 0xEF, 0x0D, 0xFF, 0xE0, 0xF7, 0xDF, 0x80,
    0x9F, 0xFC, 0x73, 0x11, 0x0C, 0xA8, 0xDD, 0xF4,
    0x43, 0xD9, 0x28, 0x72, 0x75, 0xA4, 0xF5, 0x66,
    0x1B, 0x08, 0x2F, 0xDD, 0x8A, 0x0B, 0xAE, 0xB8,
    0x0E, 0x92, 0x6B, 0xEE, 0x8E, 0x98, 0xBF, 0x60,
    0xCF, 0x86, 0x2A, 0x2F, 0x7D, 0xB8, 0x43, 0x21,
    0x08, 0xC3, 0x81, 0xCD, 0x67, 0xE6, 0xBA, 0xAB,
    0xCE, 0xBE, 0xE2, 0xAD, 0xE7, 0xB0, 0xC5, 0x62,
    0xBE, 0xE3, 0x00, 0x2A, 0x84, 0xC1, 0xB9, 0xD2,
    0xD0, 0xAD, 0x0D, 0x11, 0x17, 0x92, 0x2C, 0x1E,
    0x1D, 0xA6, 0x52, 0x88, 0xC2, 0x29, 0x25, 0x9F,
    0x86, 0x0A, 0xF0, 0x79, 0xA5, 0x5E, 0xEE, 0x3A,
    0x7C, 0x07, 0xA8, 0x40, 0x8D, 0x7D, 0xB4, 0xEB,
    0x63, 0x3B, 0x44, 0x72, 0x44, 0xD1, 0x78, 0x74,
    0x6D, 0x1A, 0xA2, 0x62, 0x9E, 0x94, 0xDC, 0x66,
    0x27, 0x9E, 0xA3, 0xF2, 0xE9, 0x67, 0x3E, 0x90,
    0x2C, 0x20, 0xFE, 0xF8, 0xE4, 0x8F, 0x7F, 0x8D,
    0x0A, 0xF5, 0x7C, 0xC1, 0x5C, 0xE7, 0xB5, 0x7F,
    0x0E, 0x11, 0x14, 0xD1, 0xC0, 0x9C, 0x89, 0x11,
    0x65, 0xA4, 0xC8, 0xA4, 0x0B, 0xE6, 0x24, 0xD8,
    0xC9, 0x0C, 0xA1, 0x5A, 0x89, 0xA5, 0x96, 0x20,
    0x60, 0x05, 0x05, 0x06, 0x48, 0xC0, 0x02, 0x52,
    0xA0, 0x1C, 0x5F, 0x60, 0x00, 0x1E, 0x48, 0xC3,
    0x3E, 0xE7, 0xB9, 0x0F, 0x22, 0x9E, 0xF0, 0x42,
    0x87, 0x46, 0x90, 0x87, 0x32, 0x48, 0xC1, 0x7E,
    0x2B, 0xBA, 0x81, 0x8B, 0x1E, 0xE2, 0x87, 0x14,
    0xCC, 0xE8, 0x41, 0x57, 0x62, 0xC2, 0x0A, 0x44,
    0x26, 0x92, 0x10, 0x18, 0x8E, 0x6D, 0x12, 0x09,
    0x87, 0x04, 0xF5, 0x31, 0x0F, 0x23, 0xBC, 0x21,
    0x45, 0x2A, 0x4A, 0x01, 0x0F, 0x62, 0x00, 0x11,
    0x1C, 0x1C, 0xE1, 0x06, 0x56, 0x4A, 0xCF, 0x1A,
    0x8E, 0x81, 0x2E, 0x91, 0x9C, 0x90, 0x22, 0x21,
    0x20, 0x02, 0x1C, 0xB9, 0xF8, 0x90, 0x9D, 0xED,
    0x74, 0xC7, 0x40, 0x42, 0x90, 0x48, 0x0C, 0xD0,
    0x81, 0x06, 0x10, 0xA6, 0xA7, 0x12, 0xEA, 0x38,
    0x58, 0x54, 0xF6, 0x61, 0x9A, 0xD4, 0xA0, 0x26,
    0x0A, 0x28, 0x94, 0x48, 0x12, 0x0E, 0x21, 0x80,
    0x66, 0xC4, 0x66, 0x36, 0x28, 0xA8, 0x8D, 0xF6,
    0x24, 0xD2, 0x8E, 0x13, 0xF0, 0xC6, 0x37, 0x18,
    0xE8, 0x83, 0x3C, 0x6C, 0xE1, 0x94, 0x7D, 0x10,
    0xA1, 0x0A, 0x85, 0xF9, 0x40, 0x15, 0xE8, 0xB0,
    0xC0, 0x8A, 0x70, 0x61, 0x31, 0x8E, 0x69, 0xCC,
    0x30, 0x2E, 0x41, 0xC3, 0x89, 0x50, 0x26, 0x19,
    0x98, 0xB9, 0x8C, 0x29, 0xE0, 0xF1, 0x8A, 0x36,
    0xEE, 0x01, 0x2D, 0x68, 0xD9, 0x08, 0x5B, 0xDE,
    0xE2, 0x16, 0x05, 0x58, 0x07, 0x88, 0xB5, 0xB8,
    0xCB, 0x5D, 0x68, 0xD1, 0x92, 0xB0, 0x88, 0xA5,
    0x8D, 0x97, 0x04, 0x4B, 0x26, 0x51, 0x22, 0x95,
    0x4D, 0xE6, 0xC4, 0x92, 0x9E, 0xFC, 0x08, 0x28,
    0x43, 0x89, 0x91, 0x4E, 0x92, 0x92, 0x73, 0xA7,
    0x9C, 0x62, 0x2A, 0x49, 0x32, 0xCA, 0x55, 0x02,
    0xA6, 0x95, 0xAE, 0xFC, 0x64, 0x2C, 0x37, 0x62,
    0x4A, 0x52, 0xD6, 0x32, 0x94, 0xB7, 0xF4, 0x64,
    0x2E, 0x37, 0xB9, 0xCB, 0x4C, 0xF6, 0xF2, 0x92,
    0xBF, 0x14, 0x0B, 0x43, 0x86, 0x49, 0xCC, 0x62,
    0x1A, 0x73, 0x1F, 0x01, 0x01, 0x00, 0x3B
};
#endif

#if T2T_NDEFFILE_PREDEF == MAX_VCARD
const uint8_t T2T_DATA_DEF[2040] = {
    0x03, 0xFF, 0x07, 0xF4, 0xC2, 0x0C, 0x00, 0x00,
    0x07, 0xE2, 0x74, 0x65, 0x78, 0x74, 0x2F, 0x78,
    0x2D, 0x76, 0x43, 0x61, 0x72, 0x64, 0x42, 0x45,
    0x47, 0x49, 0x4E, 0x3A, 0x56, 0x43, 0x41, 0x52,
    0x44, 0x0D, 0x0A, 0x56, 0x45, 0x52, 0x53, 0x49,
    0x4F, 0x4E, 0x3A, 0x32, 0x2E, 0x31, 0x0D, 0x0A,
    0x4E, 0x3A, 0x53, 0x65, 0x6D, 0x69, 0x63, 0x6F,
    0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x73,
    0x3B, 0x4E, 0x58, 0x50, 0x3B, 0x3B, 0x3B, 0x0D,
    0x0A, 0x46, 0x4E, 0x3A, 0x4E, 0x58, 0x50, 0x20,
    0x53, 0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64,
    0x75, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x0D, 0x0A,
    0x55, 0x52, 0x4C, 0x3A, 0x77, 0x77, 0x77, 0x2E,
    0x6E, 0x78, 0x70, 0x2E, 0x63, 0x6F, 0x6D, 0x2F,
    0x6E, 0x66, 0x63, 0x0D, 0x0A, 0x4E, 0x4F, 0x54,
    0x45, 0x3A, 0x4E, 0x58, 0x50, 0x20, 0x4E, 0x46,
    0x43, 0x0D, 0x0A, 0x50, 0x48, 0x4F, 0x54, 0x4F,
    0x3B, 0x45, 0x4E, 0x43, 0x4F, 0x44, 0x49, 0x4E,
    0x47, 0x3D, 0x42, 0x41, 0x53, 0x45, 0x36, 0x34,
    0x3B, 0x4A, 0x50, 0x45, 0x47, 0x3A, 0x2F, 0x39,
    0x6A, 0x2F, 0x34, 0x41, 0x41, 0x51, 0x53, 0x6B,
    0x5A, 0x4A, 0x52, 0x67, 0x41, 0x42, 0x41, 0x51,
    0x41, 0x41, 0x41, 0x51, 0x41, 0x42, 0x41, 0x41,
    0x44, 0x2F, 0x32, 0x77, 0x42, 0x44, 0x41, 0x41,
    0x6F, 0x48, 0x42, 0x77, 0x6B, 0x48, 0x42, 0x67,
    0x6F, 0x4A, 0x43, 0x41, 0x6B, 0x4C, 0x43, 0x77,
    0x6F, 0x4D, 0x44, 0x78, 0x6B, 0x51, 0x44, 0x77,
    0x34, 0x4F, 0x44, 0x78, 0x34, 0x57, 0x46, 0x78,
    0x49, 0x5A, 0x4A, 0x43, 0x41, 0x6D, 0x4A, 0x53,
    0x4D, 0x67, 0x0A, 0x49, 0x79, 0x49, 0x6F, 0x4C,
    0x54, 0x6B, 0x77, 0x4B, 0x43, 0x6F, 0x32, 0x4B,
    0x79, 0x49, 0x6A, 0x4D, 0x6B, 0x51, 0x79, 0x4E,
    0x6A, 0x73, 0x39, 0x51, 0x45, 0x42, 0x41, 0x4A,
    0x6A, 0x42, 0x47, 0x53, 0x30, 0x55, 0x2B, 0x53,
    0x6A, 0x6B, 0x2F, 0x51, 0x44, 0x33, 0x2F, 0x32,
    0x77, 0x42, 0x44, 0x41, 0x51, 0x73, 0x4C, 0x43,
    0x77, 0x38, 0x4E, 0x44, 0x78, 0x30, 0x51, 0x45,
    0x42, 0x30, 0x39, 0x4B, 0x53, 0x4D, 0x70, 0x50,
    0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39, 0x0A,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x30, 0x39, 0x50, 0x54, 0x30, 0x39,
    0x50, 0x54, 0x33, 0x2F, 0x77, 0x41, 0x41, 0x52,
    0x43, 0x41, 0x42, 0x49, 0x41, 0x45, 0x67, 0x44,
    0x41, 0x53, 0x49, 0x41, 0x0A, 0x41, 0x68, 0x45,
    0x42, 0x41, 0x78, 0x45, 0x42, 0x2F, 0x38, 0x51,
    0x41, 0x48, 0x77, 0x41, 0x41, 0x41, 0x51, 0x55,
    0x42, 0x41, 0x51, 0x45, 0x42, 0x41, 0x51, 0x45,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x45, 0x43, 0x41, 0x77, 0x51,
    0x46, 0x42, 0x67, 0x63, 0x49, 0x43, 0x51, 0x6F,
    0x4C, 0x2F, 0x38, 0x51, 0x41, 0x74, 0x52, 0x41,
    0x41, 0x41, 0x67, 0x45, 0x44, 0x41, 0x77, 0x49,
    0x45, 0x41, 0x77, 0x55, 0x46, 0x42, 0x41, 0x51,
    0x41, 0x0A, 0x41, 0x41, 0x46, 0x39, 0x41, 0x51,
    0x49, 0x44, 0x41, 0x41, 0x51, 0x52, 0x42, 0x52,
    0x49, 0x68, 0x4D, 0x55, 0x45, 0x47, 0x45, 0x31,
    0x46, 0x68, 0x42, 0x79, 0x4A, 0x78, 0x46, 0x44,
    0x4B, 0x42, 0x6B, 0x61, 0x45, 0x49, 0x49, 0x30,
    0x4B, 0x78, 0x77, 0x52, 0x56, 0x53, 0x30, 0x66,
    0x41, 0x6B, 0x4D, 0x32, 0x4A, 0x79, 0x67, 0x67,
    0x6B, 0x4B, 0x46, 0x68, 0x63, 0x59, 0x47, 0x52,
    0x6F, 0x6C, 0x4A, 0x69, 0x63, 0x6F, 0x4B, 0x53,
    0x6F, 0x30, 0x4E, 0x54, 0x59, 0x33, 0x0A, 0x4F,
    0x44, 0x6B, 0x36, 0x51, 0x30, 0x52, 0x46, 0x52,
    0x6B, 0x64, 0x49, 0x53, 0x55, 0x70, 0x54, 0x56,
    0x46, 0x56, 0x57, 0x56, 0x31, 0x68, 0x5A, 0x57,
    0x6D, 0x4E, 0x6B, 0x5A, 0x57, 0x5A, 0x6E, 0x61,
    0x47, 0x6C, 0x71, 0x63, 0x33, 0x52, 0x31, 0x64,
    0x6E, 0x64, 0x34, 0x65, 0x58, 0x71, 0x44, 0x68,
    0x49, 0x57, 0x47, 0x68, 0x34, 0x69, 0x4A, 0x69,
    0x70, 0x4B, 0x54, 0x6C, 0x4A, 0x57, 0x57, 0x6C,
    0x35, 0x69, 0x5A, 0x6D, 0x71, 0x4B, 0x6A, 0x70,
    0x4B, 0x57, 0x6D, 0x0A, 0x70, 0x36, 0x69, 0x70,
    0x71, 0x72, 0x4B, 0x7A, 0x74, 0x4C, 0x57, 0x32,
    0x74, 0x37, 0x69, 0x35, 0x75, 0x73, 0x4C, 0x44,
    0x78, 0x4D, 0x58, 0x47, 0x78, 0x38, 0x6A, 0x4A,
    0x79, 0x74, 0x4C, 0x54, 0x31, 0x4E, 0x58, 0x57,
    0x31, 0x39, 0x6A, 0x5A, 0x32, 0x75, 0x48, 0x69,
    0x34, 0x2B, 0x54, 0x6C, 0x35, 0x75, 0x66, 0x6F,
    0x36, 0x65, 0x72, 0x78, 0x38, 0x76, 0x50, 0x30,
    0x39, 0x66, 0x62, 0x33, 0x2B, 0x50, 0x6E, 0x36,
    0x2F, 0x38, 0x51, 0x41, 0x48, 0x77, 0x45, 0x41,
    0x0A, 0x41, 0x77, 0x45, 0x42, 0x41, 0x51, 0x45,
    0x42, 0x41, 0x51, 0x45, 0x42, 0x41, 0x51, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x45,
    0x43, 0x41, 0x77, 0x51, 0x46, 0x42, 0x67, 0x63,
    0x49, 0x43, 0x51, 0x6F, 0x4C, 0x2F, 0x38, 0x51,
    0x41, 0x74, 0x52, 0x45, 0x41, 0x41, 0x67, 0x45,
    0x43, 0x42, 0x41, 0x51, 0x44, 0x42, 0x41, 0x63,
    0x46, 0x42, 0x41, 0x51, 0x41, 0x41, 0x51, 0x4A,
    0x33, 0x41, 0x41, 0x45, 0x43, 0x41, 0x78, 0x45,
    0x45, 0x42, 0x53, 0x45, 0x78, 0x0A, 0x42, 0x68,
    0x4A, 0x42, 0x55, 0x51, 0x64, 0x68, 0x63, 0x52,
    0x4D, 0x69, 0x4D, 0x6F, 0x45, 0x49, 0x46, 0x45,
    0x4B, 0x52, 0x6F, 0x62, 0x48, 0x42, 0x43, 0x53,
    0x4D, 0x7A, 0x55, 0x76, 0x41, 0x56, 0x59, 0x6E,
    0x4C, 0x52, 0x43, 0x68, 0x59, 0x6B, 0x4E, 0x4F,
    0x45, 0x6C, 0x38, 0x52, 0x63, 0x59, 0x47, 0x52,
    0x6F, 0x6D, 0x4A, 0x79, 0x67, 0x70, 0x4B, 0x6A,
    0x55, 0x32, 0x4E, 0x7A, 0x67, 0x35, 0x4F, 0x6B,
    0x4E, 0x45, 0x52, 0x55, 0x5A, 0x48, 0x53, 0x45,
    0x6C, 0x4B, 0x0A, 0x55, 0x31, 0x52, 0x56, 0x56,
    0x6C, 0x64, 0x59, 0x57, 0x56, 0x70, 0x6A, 0x5A,
    0x47, 0x56, 0x6D, 0x5A, 0x32, 0x68, 0x70, 0x61,
    0x6E, 0x4E, 0x30, 0x64, 0x58, 0x5A, 0x33, 0x65,
    0x48, 0x6C, 0x36, 0x67, 0x6F, 0x4F, 0x45, 0x68,
    0x59, 0x61, 0x48, 0x69, 0x49, 0x6D, 0x4B, 0x6B,
    0x70, 0x4F, 0x55, 0x6C, 0x5A, 0x61, 0x58, 0x6D,
    0x4A, 0x6D, 0x61, 0x6F, 0x71, 0x4F, 0x6B, 0x70,
    0x61, 0x61, 0x6E, 0x71, 0x4B, 0x6D, 0x71, 0x73,
    0x72, 0x4F, 0x30, 0x74, 0x62, 0x61, 0x33, 0x0A,
    0x75, 0x4C, 0x6D, 0x36, 0x77, 0x73, 0x50, 0x45,
    0x78, 0x63, 0x62, 0x48, 0x79, 0x4D, 0x6E, 0x4B,
    0x30, 0x74, 0x50, 0x55, 0x31, 0x64, 0x62, 0x58,
    0x32, 0x4E, 0x6E, 0x61, 0x34, 0x75, 0x50, 0x6B,
    0x35, 0x65, 0x62, 0x6E, 0x36, 0x4F, 0x6E, 0x71,
    0x38, 0x76, 0x50, 0x30, 0x39, 0x66, 0x62, 0x33,
    0x2B, 0x50, 0x6E, 0x36, 0x2F, 0x39, 0x6F, 0x41,
    0x44, 0x41, 0x4D, 0x42, 0x41, 0x41, 0x49, 0x52,
    0x41, 0x78, 0x45, 0x41, 0x50, 0x77, 0x44, 0x32,
    0x61, 0x69, 0x6B, 0x7A, 0x0A, 0x51, 0x44, 0x51,
    0x41, 0x74, 0x46, 0x4A, 0x52, 0x6D, 0x67, 0x42,
    0x61, 0x4B, 0x54, 0x4E, 0x47, 0x61, 0x41, 0x46,
    0x6F, 0x70, 0x4D, 0x30, 0x5A, 0x6F, 0x41, 0x57,
    0x69, 0x6B, 0x7A, 0x52, 0x51, 0x42, 0x56, 0x4F,
    0x6F, 0x32, 0x67, 0x4A, 0x42, 0x75, 0x59, 0x38,
    0x6A, 0x74, 0x6D, 0x72, 0x43, 0x4D, 0x48, 0x47,
    0x35, 0x53, 0x43, 0x44, 0x79, 0x43, 0x4B, 0x34,
    0x71, 0x62, 0x2F, 0x58, 0x53, 0x66, 0x37, 0x78,
    0x72, 0x53, 0x30, 0x66, 0x55, 0x78, 0x62, 0x74,
    0x35, 0x0A, 0x45, 0x37, 0x59, 0x69, 0x59, 0x2F,
    0x4B, 0x53, 0x66, 0x75, 0x6E, 0x2F, 0x41, 0x41,
    0x72, 0x35, 0x2F, 0x43, 0x35, 0x31, 0x37, 0x53,
    0x74, 0x37, 0x4F, 0x71, 0x6B, 0x6C, 0x33, 0x4F,
    0x2B, 0x72, 0x67, 0x75, 0x57, 0x48, 0x4E, 0x46,
    0x33, 0x4F, 0x67, 0x75, 0x4C, 0x69, 0x4B, 0x31,
    0x68, 0x61, 0x57, 0x64, 0x31, 0x6A, 0x6A, 0x58,
    0x71, 0x7A, 0x48, 0x67, 0x56, 0x54, 0x54, 0x58,
    0x64, 0x4D, 0x6B, 0x59, 0x4A, 0x48, 0x66, 0x51,
    0x4D, 0x78, 0x34, 0x41, 0x44, 0x69, 0x0A, 0x6D,
    0x36, 0x36, 0x71, 0x79, 0x61, 0x4E, 0x4D, 0x72,
    0x44, 0x4B, 0x74, 0x67, 0x48, 0x38, 0x78, 0x58,
    0x6E, 0x50, 0x32, 0x59, 0x32, 0x74, 0x2B, 0x30,
    0x5A, 0x7A, 0x6A, 0x42, 0x4B, 0x6B, 0x39, 0x78,
    0x58, 0x71, 0x2F, 0x57, 0x66, 0x38, 0x41, 0x61,
    0x59, 0x34, 0x66, 0x75, 0x63, 0x55, 0x6F, 0x75,
    0x4E, 0x46, 0x31, 0x65, 0x78, 0x36, 0x76, 0x6D,
    0x71, 0x55, 0x2B, 0x73, 0x36, 0x66, 0x62, 0x53,
    0x6D, 0x4B, 0x65, 0x38, 0x68, 0x6A, 0x63, 0x64,
    0x56, 0x5A, 0x73, 0x0A, 0x45, 0x56, 0x69, 0x32,
    0x66, 0x69, 0x51, 0x52, 0x36, 0x49, 0x2F, 0x6D,
    0x6E, 0x4E, 0x7A, 0x48, 0x38, 0x69, 0x2F, 0x37,
    0x57, 0x63, 0x34, 0x50, 0x34, 0x59, 0x2F, 0x53,
    0x75, 0x4F, 0x75, 0x6C, 0x6B, 0x75, 0x72, 0x31,
    0x52, 0x6B, 0x74, 0x4A, 0x4A, 0x31, 0x4A, 0x37,
    0x38, 0x6E, 0x4A, 0x72, 0x71, 0x78, 0x4B, 0x64,
    0x43, 0x6C, 0x4B, 0x6F, 0x2B, 0x68, 0x78, 0x72,
    0x45, 0x71, 0x55, 0x6F, 0x78, 0x6A, 0x31, 0x50,
    0x54, 0x49, 0x74, 0x58, 0x73, 0x4A, 0x6C, 0x33,
    0x0A, 0x52, 0x33, 0x63, 0x4C, 0x44, 0x70, 0x6B,
    0x4E, 0x54, 0x2F, 0x37, 0x54, 0x73, 0x2F, 0x38,
    0x41, 0x6E, 0x34, 0x6A, 0x2F, 0x41, 0x4F, 0x2B,
    0x71, 0x35, 0x62, 0x54, 0x64, 0x48, 0x6C, 0x6C,
    0x74, 0x74, 0x74, 0x73, 0x71, 0x37, 0x55, 0x34,
    0x4A, 0x4A, 0x78, 0x6B, 0x31, 0x63, 0x2F, 0x73,
    0x4B, 0x38, 0x48, 0x38, 0x4B, 0x66, 0x39, 0x39,
    0x56, 0x34, 0x43, 0x7A, 0x50, 0x47, 0x54, 0x58,
    0x4E, 0x54, 0x70, 0x58, 0x6A, 0x30, 0x33, 0x4F,
    0x7A, 0x6C, 0x58, 0x55, 0x36, 0x0A, 0x53, 0x4B,
    0x65, 0x4B, 0x59, 0x5A, 0x69, 0x6B, 0x56, 0x78,
    0x37, 0x48, 0x4E, 0x46, 0x63, 0x68, 0x62, 0x79,
    0x79, 0x57, 0x6C, 0x30, 0x47, 0x55, 0x6C, 0x58,
    0x52, 0x73, 0x45, 0x45, 0x66, 0x6D, 0x44, 0x52,
    0x58, 0x52, 0x68, 0x4D, 0x32, 0x68, 0x57, 0x69,
    0x2F, 0x61, 0x4B, 0x7A, 0x51, 0x4F, 0x4A, 0x46,
    0x4E, 0x2F, 0x72, 0x70, 0x50, 0x39, 0x34, 0x2F,
    0x7A, 0x71, 0x2F, 0x71, 0x57, 0x6D, 0x47, 0x32,
    0x56, 0x5A, 0x34, 0x68, 0x6D, 0x4A, 0x67, 0x4D,
    0x6A, 0x2B, 0x0A, 0x36, 0x66, 0x38, 0x41, 0x43,
    0x71, 0x4D, 0x33, 0x2B, 0x75, 0x6B, 0x2F, 0x33,
    0x6A, 0x58, 0x59, 0x69, 0x4E, 0x4A, 0x62, 0x56,
    0x55, 0x64, 0x51, 0x79, 0x73, 0x6F, 0x42, 0x42,
    0x72, 0x78, 0x38, 0x76, 0x77, 0x63, 0x63, 0x55,
    0x71, 0x73, 0x58, 0x76, 0x30, 0x66, 0x33, 0x6E,
    0x71, 0x34, 0x69, 0x73, 0x36, 0x58, 0x49, 0x30,
    0x63, 0x31, 0x2F, 0x61, 0x52, 0x6C, 0x30, 0x75,
    0x53, 0x31, 0x6C, 0x35, 0x49, 0x78, 0x73, 0x62,
    0x31, 0x35, 0x48, 0x42, 0x72, 0x44, 0x76, 0x0A,
    0x7A, 0x48, 0x75, 0x6A, 0x42, 0x2F, 0x31, 0x6E,
    0x4F, 0x50, 0x70, 0x57, 0x76, 0x71, 0x31, 0x6C,
    0x2F, 0x5A, 0x72, 0x73, 0x35, 0x2F, 0x31, 0x4A,
    0x47, 0x56, 0x62, 0x2B, 0x6C, 0x63, 0x6F, 0x74,
    0x77, 0x31, 0x31, 0x66, 0x74, 0x49, 0x65, 0x34,
    0x49, 0x55, 0x65, 0x67, 0x72, 0x66, 0x41, 0x55,
    0x36, 0x30, 0x73, 0x64, 0x42, 0x56, 0x76, 0x73,
    0x57, 0x52, 0x7A, 0x34, 0x79, 0x56, 0x4E, 0x59,
    0x57, 0x66, 0x4A, 0x39, 0x6F, 0x74, 0x56, 0x4E,
    0x59, 0x6D, 0x4D, 0x58, 0x0A, 0x6A, 0x42, 0x76,
    0x39, 0x5A, 0x73, 0x2B, 0x58, 0x2B, 0x74, 0x64,
    0x50, 0x5A, 0x2B, 0x48, 0x46, 0x62, 0x51, 0x32,
    0x6A, 0x6C, 0x41, 0x46, 0x78, 0x4C, 0x68, 0x77,
    0x66, 0x37, 0x70, 0x37, 0x44, 0x39, 0x54, 0x2B,
    0x64, 0x63, 0x54, 0x65, 0x69, 0x57, 0x31, 0x76,
    0x67, 0x44, 0x6C, 0x4A, 0x59, 0x2B, 0x43, 0x50,
    0x51, 0x67, 0x6D, 0x76, 0x71, 0x63, 0x33, 0x61,
    0x72, 0x34, 0x4F, 0x63, 0x45, 0x2B, 0x33, 0x35,
    0x6E, 0x7A, 0x64, 0x43, 0x6C, 0x4B, 0x6C, 0x56,
    0x6A, 0x0A, 0x4B, 0x58, 0x55, 0x37, 0x50, 0x53,
    0x39, 0x55, 0x53, 0x77, 0x69, 0x64, 0x48, 0x6A,
    0x5A, 0x79, 0x7A, 0x5A, 0x34, 0x4E, 0x58, 0x54,
    0x34, 0x6A, 0x6A, 0x77, 0x63, 0x51, 0x50, 0x6E,
    0x74, 0x6C, 0x68, 0x57, 0x64, 0x6F, 0x4E, 0x6E,
    0x42, 0x72, 0x46, 0x6B, 0x5A, 0x32, 0x64, 0x31,
    0x49, 0x62, 0x62, 0x68, 0x53, 0x4F, 0x4B, 0x31,
    0x50, 0x2B, 0x45, 0x64, 0x74, 0x76, 0x2B, 0x65,
    0x73, 0x33, 0x35, 0x6A, 0x2F, 0x43, 0x76, 0x6D,
    0x63, 0x4C, 0x44, 0x4D, 0x6C, 0x52, 0x0A, 0x55,
    0x61, 0x62, 0x58, 0x4C, 0x30, 0x32, 0x50, 0x59,
    0x39, 0x31, 0x36, 0x6D, 0x42, 0x75, 0x61, 0x65,
    0x34, 0x4C, 0x48, 0x6C, 0x33, 0x62, 0x50, 0x41,
    0x36, 0x6B, 0x6D, 0x69, 0x75, 0x6D, 0x74, 0x4E,
    0x49, 0x74, 0x37, 0x53, 0x54, 0x65, 0x6F, 0x5A,
    0x33, 0x42, 0x34, 0x5A, 0x6A, 0x30, 0x6F, 0x72,
    0x66, 0x42, 0x35, 0x54, 0x4B, 0x4D, 0x57, 0x36,
    0x7A, 0x31, 0x66, 0x59, 0x54, 0x6B, 0x54, 0x6D,
    0x78, 0x74, 0x53, 0x63, 0x6D, 0x33, 0x69, 0x7A,
    0x2F, 0x75, 0x43, 0x0A, 0x72, 0x43, 0x67, 0x44,
    0x6A, 0x47, 0x42, 0x53, 0x34, 0x6F, 0x78, 0x58,
    0x75, 0x52, 0x68, 0x47, 0x50, 0x77, 0x71, 0x77,
    0x6D, 0x32, 0x39, 0x79, 0x4F, 0x61, 0x43, 0x4B,
    0x34, 0x6A, 0x4D, 0x63, 0x30, 0x61, 0x53, 0x49,
    0x65, 0x71, 0x75, 0x6F, 0x49, 0x50, 0x34, 0x47,
    0x71, 0x36, 0x61, 0x54, 0x59, 0x52, 0x73, 0x47,
    0x53, 0x78, 0x74, 0x6C, 0x59, 0x63, 0x67, 0x72,
    0x45, 0x6F, 0x49, 0x2F, 0x53, 0x72, 0x6C, 0x46,
    0x56, 0x5A, 0x58, 0x75, 0x49, 0x53, 0x71, 0x30,
    0x0A, 0x75, 0x6D, 0x57, 0x55, 0x38, 0x68, 0x65,
    0x61, 0x7A, 0x74, 0x35, 0x48, 0x50, 0x56, 0x6D,
    0x6A, 0x55, 0x6B, 0x2F, 0x6A, 0x69, 0x72, 0x56,
    0x47, 0x4B, 0x47, 0x72, 0x36, 0x43, 0x73, 0x51,
    0x32, 0x39, 0x72, 0x42, 0x61, 0x71, 0x56, 0x74,
    0x34, 0x59, 0x34, 0x6C, 0x4A, 0x79, 0x51, 0x69,
    0x68, 0x51, 0x54, 0x2B, 0x46, 0x54, 0x43, 0x69,
    0x69, 0x68, 0x4B, 0x77, 0x77, 0x6F, 0x70, 0x61,
    0x4B, 0x59, 0x42, 0x52, 0x52, 0x52, 0x51, 0x41,
    0x55, 0x55, 0x55, 0x55, 0x41, 0x0A, 0x46, 0x46,
    0x46, 0x46, 0x41, 0x42, 0x52, 0x52, 0x52, 0x51,
    0x41, 0x55, 0x55, 0x55, 0x55, 0x41, 0x66, 0x2F,
    0x2F, 0x5A, 0x0A, 0x0D, 0x0A, 0x45, 0x4E, 0x44,
    0x3A, 0x56, 0x43, 0x41, 0x52, 0x44, 0x0D, 0x0A
};
#endif

const uint16_t T2T_DATA_DEF_SIZE = sizeof(T2T_DATA_DEF);
