/*
*         Copyright (c), NXP Semiconductors Bangalore / India
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* Example Source for NfcrdlibEx6_EMVCo_Loopback.
* This application will configure Reader Library as per Emvco specification and start Emvco polling.
* This loop back application will send SELECT_PPSE command and is used to test Emvco2.3.1a(L1)
* digital compliance.
* Please refer Readme.txt file  for  Hardware Pin Configuration, Software Configuration and steps to build and
* execute the project which is present in the same project directory.
* $Author: jenkins_ cm (nxp92197) $
* $Revision: 4184 $ (NFCRDLIB_V4.010.01.001603 : 4078 )
* $Date: 2016-01-22 18:04:59 +0530 (Fri, 22 Jan 2016) $
*
* History:
* BK: Generated 12. Jun 2014
* PC: Generated 25. Nov 2012
*
*/

#include <cr_section_macros.h>
#include <NXP/crp.h>

/**
 * Header for hardware configuration: bus interface, reset of attached reader ID, on-board LED handling etc.
 * */
#include <phhwConfig.h>

/**
* Reader Library Headers
*/
#include <ph_Status.h>

/*Platform Headers*/
#include <phPlatform.h>

/*BAL Headers*/
#include <phbalReg.h>
#include <phDownload_lib.h>
#include <phDlHalConfig_LPC1769.h>

/*DownloadLibrary Headers*/
#include <PN5180Firmware_3_4.h>
#include <PN5180Firmware_3_5.h>
#include <PN5180Firmware_3_6.h>

__CRP const unsigned int CRP_WORD = CRP_NO_CRP ;
#define PRETTY_PRINTING                                         /**< Enable pretty printing */
#define MiN_VALID_DATA_SIZE                     6
#define PHAC_EMVCO_MAX_BUFFSIZE               600               /**< Maximum buffer size for Emvco. */

#define DOWNLOAD_TX_BUFFER_LEN   600
#define DOWNLOAD_RX_BUFFER_LEN   600


/*******************************************************************************
**   Global Variable Declaration
*******************************************************************************/
phbalReg_Stub_DataParams_t         sBalReader;                 /**< BAL component holder */

/*******************************************************************************
**   Function Declaration
*******************************************************************************/

static phStatus_t DownloadLibBalInit(void)
{
    phStatus_t  status;
    /* Initialize the Reader BAL (Bus Abstraction Layer) component */
	status = phbalReg_Stub_Init(&sBalReader, sizeof(phbalReg_Stub_DataParams_t));
	CHECK_STATUS(status);


	/* Set HAL type in BAL */
	status = phbalReg_SetConfig(
		&sBalReader,
		PHBAL_REG_CONFIG_HAL_HW_TYPE,
		PHBAL_REG_HAL_HW_PN5180);

	CHECK_STATUS(status);

	/* Open BAL */
	status = phbalReg_OpenPort(&sBalReader);
	CHECK_STATUS(status);

	return status;
}

/*******************************************************************************
**   Main Function
*******************************************************************************/

int main (void)
{
    phStatus_t status;
    uint8_t bOption;
    phDlhalHw_Pn5180_DL_DataParams_t sDlDataParams;

    uint8_t bTxBuffer[DOWNLOAD_TX_BUFFER_LEN];
    uint8_t bRxBuffer[DOWNLOAD_RX_BUFFER_LEN];

    /* Set LED port pin to output */
    Set_Port();

    /* Ensure, that the LED is off */
    LedOn();

    /* Perform a hardware reset */
    phDlhalHw_Pn5180_ResetDevice();

    /* Initialization of the BAL*/
    DownloadLibBalInit();


    DEBUG_PRINTF("\n Download Library Example: ");

	status = phDlhalHw_Pn5180_DownloadMode( PH_DLHAL_HW_PN5180_DOWNLOAD_MODE_ENABLE);
	CHECK_STATUS(status);


    status = phDlhalHw_Pn5180_Download_Init(&sDlDataParams,&sBalReader,bTxBuffer,DOWNLOAD_TX_BUFFER_LEN, bRxBuffer,DOWNLOAD_RX_BUFFER_LEN );


    if(status == PH_ERR_SUCCESS)
    {
    	DEBUG_PRINTF("\n Initialization SUCCESS");
    }
    else
    {
    	DEBUG_PRINTF("\n Initialization FAILED");
    }

    DEBUG_PRINTF("\n Select the Option \n - Enter 0 to EXIT.\n - Enter 1 for FW Version.\n - Enter 2 to Get DieID.\n"
    		" - Enter 3 to perform SOFT RESET.\n - Enter 4 to CheckSessionState.\n"
    		" - Enter 5 to CheckIntegrity.\n - Enter 6 to READ.\n - Enter 7 for Firmware Update 3.4.\n - Enter 8 for Firmware Update 3.5.\n"
    		" - Enter 9 for Firmware Update 3.6.\n\n" );
    while(1)
    {
    	DEBUG_PRINTF("Select Option\t");
    	scanf("%d", &bOption);

    	 switch (bOption)
		{
			case 0x01:  //GetFirmwareVersion
			{
				uint8_t bMajorVersion;
				uint8_t bMinorVersion;

				DEBUG_PRINTF("GetFirmwareVersion func\n");

				status = phDlhalHw_Pn5180_Download_GetFirmwareVersion(&sDlDataParams, &bMajorVersion, &bMinorVersion);
				CHECK_SUCCESS(status);
				DEBUG_PRINTF("FW ver: %d.%d\n\n", bMajorVersion, bMinorVersion);
				break;
			}

			case 0x02: //GetDieID
			{
				uint8_t bDieID[16];
				int idx=0;
				DEBUG_PRINTF("GetDieId func\n");
				status = phDlhalHw_Pn5180_Download_GetDieId(&sDlDataParams, bDieID);
				CHECK_SUCCESS(status);
				DEBUG_PRINTF("DieID: ");

				for(idx=0; idx < 16; ++idx)
					DEBUG_PRINTF("%02X ",bDieID[idx]);
				DEBUG_PRINTF("\n\n");
				break;
			}

			case 0x03:
			{
				DEBUG_PRINTF("PerformSoftReset func\n");

				status = phDlhalHw_Pn5180_Download_PerformSoftReset(&sDlDataParams);
				CHECK_SUCCESS(status);
				break;
			}

			case 0x04:
			{
				phDlhalHw_Pn5180_Download_SessionStateInformation_t sStateInfo;

				DEBUG_PRINTF("CheckSessionState func\n");

				status = phDlhalHw_Pn5180_Download_CheckSessionState(&sDlDataParams, &sStateInfo);
				CHECK_SUCCESS(status);
				DEBUG_PRINTF("Session state: %02d\n", sStateInfo.bSessionState);

				DEBUG_PRINTF("Life cycle: %02d\n\n", sStateInfo.bLifeCycle);

				break;
			}

			case 0x05:
			{
				phDlhalHw_Pn5180_Download_IntegrityInformation_t sIntegrityInfo;

				DEBUG_PRINTF("CheckIntegrity func\n");

				status = phDlhalHw_Pn5180_Download_CheckIntegrity(&sDlDataParams, &sIntegrityInfo);
				CHECK_SUCCESS(status);

				DEBUG_PRINTF( "Function code: %1d\n",sIntegrityInfo.bFunctionCodeOk);
				DEBUG_PRINTF("Patch code:    %1d\n",sIntegrityInfo.bPatchCodeOk);
				DEBUG_PRINTF("Patch table:   %1d\n",sIntegrityInfo.bPatchTableOk);
				DEBUG_PRINTF("User data:     %1d\n",sIntegrityInfo.bUserDataOk);
				DEBUG_PRINTF("\n\n");
				break;
			}
			/* READ function test */
			case 0x06:
			{
				uint8_t* pBuffer = NULL;
				uint8_t bReadLength;
				int idx=0;
				status = phDlhalHw_Pn5180_Download_Read(&sDlDataParams, 128, 0x00201380, &pBuffer );

				CHECK_SUCCESS(status);

				bReadLength = (pBuffer[1] << 8) | pBuffer[0];
				if (pBuffer != NULL)
				{
					DEBUG_PRINTF( "READ Data: ");
					for(idx=0; idx < bReadLength ; ++idx)
						DEBUG_PRINTF(  "%02X ",pBuffer[idx + 2]);
				}
				DEBUG_PRINTF("\n\n");

				break;
			}
			/* Firmware download test */
			case 0x07:
			{
				DEBUG_PRINTF("Firmware upload func\n");
				status = phDlhalHw_Pn5180_Download_PerformSecureFirmwareUpdate(&sDlDataParams, (uint8_t*)gphDnldNfc_DlSequence3_4, gphDnldNfc_DlSeqSizeOf3_4);
				if (status == PH_ERR_SUCCESS)
				{
				DEBUG_PRINTF("Successful firmware upload \n");
				DEBUG_PRINTF("\n\n");
				}
				else if (status == PH_DLHAL_HW_PN5180_DOWNLOAD_ERR_FIRMWARE_VERSION_ERROR)
				{
				DEBUG_PRINTF(" firmware Version already exists\n");
				DEBUG_PRINTF("\n\n");
				}
				else
				{
				DEBUG_PRINTF(" firmware upload failure\n");
				DEBUG_PRINTF("\n\n");
				}

				/*Putting it back to download mode as user might try to read version number and check*/
				status = phDlhalHw_Pn5180_DownloadMode(1);
				CHECK_SUCCESS(status);
				break;
			}
			case 0x08:
			{
				DEBUG_PRINTF("Firmware upload func\n");
				status = phDlhalHw_Pn5180_Download_PerformSecureFirmwareUpdate(&sDlDataParams, (uint8_t*)gphDnldNfc_DlSequence3_5, gphDnldNfc_DlSeqSizeOf3_5);
				if (status == PH_ERR_SUCCESS)
				{
				DEBUG_PRINTF("Successful firmware upload \n");
				DEBUG_PRINTF("\n\n");
				}
				else if (status == PH_DLHAL_HW_PN5180_DOWNLOAD_ERR_FIRMWARE_VERSION_ERROR)
				{
				DEBUG_PRINTF(" firmware Version already exists\n");
				DEBUG_PRINTF("\n\n");
				}
				else
				{
				DEBUG_PRINTF(" firmware upload failure\n");
				DEBUG_PRINTF("\n\n");
				}

				/*Putting it back to download mode as user might try to read version number and check*/
				status = phDlhalHw_Pn5180_DownloadMode( 1);
				CHECK_SUCCESS(status);
				break;
			}
			case 0x09:
			{
				DEBUG_PRINTF("Firmware upload func\n");
				status = phDlhalHw_Pn5180_Download_PerformSecureFirmwareUpdate(&sDlDataParams, (uint8_t*)gphDnldNfc_DlSequence3_6, gphDnldNfc_DlSeqSizeOf3_6);
				if (status == PH_ERR_SUCCESS)
				{
				DEBUG_PRINTF("Successful firmware upload \n");
				DEBUG_PRINTF("\n\n");
				}
				else if (status == PH_DLHAL_HW_PN5180_DOWNLOAD_ERR_FIRMWARE_VERSION_ERROR)
				{
				DEBUG_PRINTF(" firmware Version already exists\n");
				DEBUG_PRINTF("\n\n");
				}
				else
				{
				DEBUG_PRINTF(" firmware upload failure\n");
				DEBUG_PRINTF("\n\n");
				}

				/*Putting it back to download mode as user might try to read version number and check*/
				status = phDlhalHw_Pn5180_DownloadMode(1);
				CHECK_SUCCESS(status);
				break;
			}
			default:
				DEBUG_PRINTF("Application Exited. \n");
				return 0;
		}
    }
    return 0;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
