/*
*         Copyright (c), NXP Semiconductors Gratkorn / Austria
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* File used to configure example application for NXP Lpc11u68 and LPC176x Family MCU's.
* $Author:Bharamappa Khatagalli(nxp62726)$
* $Revision: 4184 $ (NFCRDLIB_V4.010.01.001603 : 4078 )
* $Date: 2016-01-22 18:04:59 +0530 (Fri, 22 Jan 2016) $
*
*/
/*******************************************************************************
 *   History
 *   2012.07.20  ver 1.00    First Release
 *
 ******************************************************************************/

/*------------------------------------------------------------------------------
 * Includes
 -----------------------------------------------------------------------------*/
#ifndef __PHHW_CONFIG_H__
#define __PHHW_CONFIG_H__

//#include <ph_NxpBuild.h>
//#include <phhalHw.h>
//#include <phOsal.h>

#ifdef LPC17xx
#include <phLpc1768_Build.h>
#undef LPC11U6x
#endif /* LPC17xx */


/*******************************************************************************
 **    Global macros and definitions
 ******************************************************************************/

#ifdef   DEBUG
#include <stdio.h>
#define  DEBUG_PRINTF(...) printf(__VA_ARGS__)
#else
#define  DEBUG_PRINTF(...)
#endif


#ifdef LPC17xx

#define PORT0              0		/**< Download  Request pin is connected to this port. */
#define PORT2              2		/**< Reset pin is connected to this port. */


/* ------------------------------------------------ */
/* general ports definition                         */
/* ------------------------------------------------ */
#define LED_PORT           PORT0    /* Port for LED */

#define LED_BIT            1 << 22      /* Bit on port for led */
#define LED_ON             1            /* Level to set port to turn on led */
#define LED_OFF            0            /* Level to set port to turn off led */

/* ------------------------------------------------ */
/* pins definition                                  */
/* ------------------------------------------------ */

#endif /*LPC17xx*/


#define PORT_RST_DEV       PORT_RESET   // port of GPIO pin where is placed reset pin for reader chip
#define PIN_RST_DEV        PIN_RESET


/*******************************************************************************
 **    Function prototypes
 ******************************************************************************/
extern void Set_Interface_Link(void);
extern void GPIO_Init(void);
extern void Set_Port(void);
extern void phDlhalHw_Pn5180_ResetDevice(void);
extern void LedOn(void);
extern void LedOff(void);

void Set_Interrupt(void);

/*******************************************************************************
 * Reader IC specific soft reset function - command
 ******************************************************************************/
#endif    /* __PHHW_CONFIG_H__ */

/*******************************************************************************
 **                            End Of File
 ******************************************************************************/
