/*
 *         Copyright (c), NXP Semiconductors
 *
 *       All rights are reserved. Reproduction in whole or in part is
 *      prohibited without the written consent of the copyright owner.
 *  NXP reserves the right to make changes without notice at any time.
 * NXP makes no warranty, expressed, implied or statutory, including but
 * not limited to any implied warranty of merchantability or fitness for any
 *particular purpose, or that the use will not infringe any third party patent,
 * copyright or trademark. NXP must not be liable for any loss or damage
 *                          arising from its use.
 */

/*------------------------------------------------------------------------------
 * Includes
 -----------------------------------------------------------------------------*/
#include <ph_TypeDefs.h>
#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_Status.h>
#include <phhwConfig.h>
#include <phDownload_lib.h>

#include <lpc17xx_ssp.h>
#include <lpc17xx_i2c.h>
#include <lpc17xx_pinsel.h>
#include <lpc17xx_gpio.h>



/*==============================================================================
 * Function:    GPIO_Init
 *
 * brief:
 *
 * ---------------------------------------------------------------------------*/
void GPIO_Init(void)
{
    /* there is a different name for the GPIO driver module for each LPC
     * processor which comes from drivers.
     * GPIO interface is consolidated via this function calling.
     */

    /* this is empty function for LPC1769 */
    /* GPIOInit(); */
}

/*==============================================================================
 * Function:    Set_Port
 *
 * brief:
 *
 * ---------------------------------------------------------------------------*/
void Set_Port(void)
{
    /* Set LED port pin to output */
    GPIO_SetDir( LED_PORT, LED_BIT, SET_OUT );
}

/*==============================================================================
 * Function:    LedOn
 *
 * brief:   switch the LED on
 *
 * ---------------------------------------------------------------------------*/
void LedOn(void)
{
    GPIO_SetValue( LED_PORT, LED_BIT );
}

/*==============================================================================
 * Function:    LedOff
 *
 * brief:   switch the LED off
 *
 * ---------------------------------------------------------------------------*/
void LedOff(void)
{
    GPIO_ClearValue( LED_PORT, LED_BIT );
}
/*------------------------------------------------------------------------------
 * End of file
 -----------------------------------------------------------------------------*/
