/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef FSL_FONT5X7_H_
#define FSL_FONT5X7_H_

static const uint8_t font5x7[] = {

	/* Character (0x00):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |****    |
	 |****    |
	 |****    |
	 |****    |
	 |****    |
	 |        |
	 +--------+ */
	0xf0,
	0xf0,
	0xf0,
	0xf0,
	0xf0,
	0xf0,
	0x00,

	/* Character (0x01):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |  *     |
	 | ***    |
	 |*****   |
	 | ***    |
	 |  *     |
	 |        |
	 +--------+ */
	0x00,
	0x20,
	0x70,
	0xf8,
	0x70,
	0x20,
	0x00,

	/* Character (0x02):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | * *    |
	 |* *     |
	 | * *    |
	 |* *     |
	 | * *    |
	 |* *     |
	 |        |
	 +--------+ */
	0x50,
	0xa0,
	0x50,
	0xa0,
	0x50,
	0xa0,
	0x00,

	/* Character (0x03):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |* *     |
	 |***     |
	 |* *     |
	 |* *     |
	 | ***    |
	 |  *     |
	 |  *     |
	 +--------+ */
	0xa0,
	0xe0,
	0xa0,
	0xa0,
	0x70,
	0x20,
	0x20,

	/* Character (0x04):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |**      |
	 |*       |
	 |**      |
	 |* **    |
	 |  *     |
	 |  **    |
	 |  *     |
	 +--------+ */
	0xc0,
	0x80,
	0xc0,
	0xb0,
	0x20,
	0x30,
	0x20,

	/* Character (0x05):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |**      |
	 |*       |
	 |**      |
	 | **     |
	 | * *    |
	 | **     |
	 | * *    |
	 +--------+ */
	0xc0,
	0x80,
	0xc0,
	0x60,
	0x50,
	0x60,
	0x50,

	/* Character (0x06):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 |*       |
	 |**      |
	 |  **    |
	 |  *     |
	 |  **    |
	 |  *     |
	 +--------+ */
	0x80,
	0x80,
	0xc0,
	0x30,
	0x20,
	0x30,
	0x20,

	/* Character (0x07):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 | * *    |
	 |  *     |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x20,
	0x50,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x08):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 | ***    |
	 |  *     |
	 |        |
	 | ***    |
	 |        |
	 |        |
	 +--------+ */
	0x20,
	0x70,
	0x20,
	0x00,
	0x70,
	0x00,
	0x00,

	/* Character (0x09):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |** *    |
	 |* **    |
	 |*  *    |
	 |  *     |
	 |  *     |
	 |  **    |
	 +--------+ */
	0x90,
	0xd0,
	0xb0,
	0x90,
	0x20,
	0x20,
	0x30,

	/* Character (0x0a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |* *     |
	 |* *     |
	 |* *     |
	 | *      |
	 | ***    |
	 |  *     |
	 |  *     |
	 +--------+ */
	0xa0,
	0xa0,
	0xa0,
	0x40,
	0x70,
	0x20,
	0x20,

	/* Character (0x0b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |***     |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0xe0,
	0x00,
	0x00,
	0x00,

	/* Character (0x0c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |***     |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0xe0,
	0x20,
	0x20,
	0x20,

	/* Character (0x0d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |  ***   |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x38,
	0x20,
	0x20,
	0x20,

	/* Character (0x0e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |  ***   |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0x38,
	0x00,
	0x00,
	0x00,

	/* Character (0x0f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |*****   |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0xf8,
	0x20,
	0x20,
	0x20,

	/* Character (0x10):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |*****   |
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0xf8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x11):
	   bbw=6, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |*****   |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xf8,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x12):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |*****   |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0xf8,
	0x00,
	0x00,
	0x00,

	/* Character (0x13):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |        |
	 |*****   |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x00,
	0xf8,
	0x00,
	0x00,

	/* Character (0x14):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 |*****   |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xf8,
	0x00,

	/* Character (0x15):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |  ***   |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0x38,
	0x20,
	0x20,
	0x20,

	/* Character (0x16):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |***     |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0xe0,
	0x20,
	0x20,
	0x20,

	/* Character (0x17):
	   bbw=6, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |*****   |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0xf8,
	0x00,
	0x00,
	0x00,

	/* Character (0x18):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |*****   |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0xf8,
	0x20,
	0x20,
	0x20,

	/* Character (0x19):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0x20,
	0x20,
	0x20,
	0x20,

	/* Character (0x1a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |   *    |
	 |  *     |
	 | *      |
	 |  *     |
	 |   *    |
	 | ***    |
	 |        |
	 +--------+ */
	0x10,
	0x20,
	0x40,
	0x20,
	0x10,
	0x70,
	0x00,

	/* Character (0x1b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |  *     |
	 |   *    |
	 |  *     |
	 | *      |
	 | ***    |
	 |        |
	 +--------+ */
	0x40,
	0x20,
	0x10,
	0x20,
	0x40,
	0x70,
	0x00,

	/* Character (0x1c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | ***    |
	 | * *    |
	 | * *    |
	 | * *    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x70,
	0x50,
	0x50,
	0x50,
	0x00,

	/* Character (0x1d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |   *    |
	 | ***    |
	 |  *     |
	 | ***    |
	 | *      |
	 |        |
	 +--------+ */
	0x00,
	0x10,
	0x70,
	0x20,
	0x70,
	0x40,
	0x00,

	/* Character (0x1e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |  **    |
	 | *      |
	 |***     |
	 | *      |
	 |* **    |
	 |        |
	 +--------+ */
	0x00,
	0x30,
	0x40,
	0xe0,
	0x40,
	0xb0,
	0x00,

	/* Character (0x1f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |  *     |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x20,
	0x00,
	0x00,
	0x00,

	/* Character (0x20):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x21):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 |        |
	 |  *     |
	 |        |
	 +--------+ */
	0x20,
	0x20,
	0x20,
	0x20,
	0x00,
	0x20,
	0x00,

	/* Character (0x22):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | * *    |
	 | * *    |
	 | * *    |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x50,
	0x50,
	0x50,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x23):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 | * *    |
	 |*****   |
	 | * *    |
	 |*****   |
	 | * *    |
	 |        |
	 +--------+ */
	0x00,
	0x50,
	0xf8,
	0x50,
	0xf8,
	0x50,
	0x00,

	/* Character (0x24):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 | ***    |
	 |* *     |
	 | ***    |
	 |  * *   |
	 | ***    |
	 |        |
	 +--------+ */
	0x00,
	0x70,
	0xa0,
	0x70,
	0x28,
	0x70,
	0x00,

	/* Character (0x25):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 |*  *    |
	 |  *     |
	 | *      |
	 |*  *    |
	 |   *    |
	 |        |
	 +--------+ */
	0x80,
	0x90,
	0x20,
	0x40,
	0x90,
	0x10,
	0x00,

	/* Character (0x26):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 | *      |
	 |* *     |
	 | *      |
	 |* *     |
	 | * *    |
	 |        |
	 +--------+ */
	0x00,
	0x40,
	0xa0,
	0x40,
	0xa0,
	0x50,
	0x00,

	/* Character (0x27):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 | *      |
	 |*       |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x60,
	0x40,
	0x80,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x28):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 |  *     |
	 |        |
	 +--------+ */
	0x20,
	0x40,
	0x40,
	0x40,
	0x40,
	0x20,
	0x00,

	/* Character (0x29):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 | *      |
	 |        |
	 +--------+ */
	0x40,
	0x20,
	0x20,
	0x20,
	0x20,
	0x40,
	0x00,

	/* Character (0x2a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |* *     |
	 | *      |
	 |***     |
	 | *      |
	 |* *     |
	 |        |
	 +--------+ */
	0x00,
	0xa0,
	0x40,
	0xe0,
	0x40,
	0xa0,
	0x00,

	/* Character (0x2b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |  *     |
	 |  *     |
	 |*****   |
	 |  *     |
	 |  *     |
	 |        |
	 +--------+ */
	0x00,
	0x20,
	0x20,
	0xf8,
	0x20,
	0x20,
	0x00,

	/* Character (0x2c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |        |
	 | **     |
	 | *      |
	 |*       |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x40,
	0x80,

	/* Character (0x2d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |****    |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0xf0,
	0x00,
	0x00,
	0x00,

	/* Character (0x2e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |        |
	 | **     |
	 | **     |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x60,
	0x00,

	/* Character (0x2f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |   *    |
	 |  *     |
	 | *      |
	 |*       |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x10,
	0x20,
	0x40,
	0x80,
	0x00,
	0x00,

	/* Character (0x30):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |* *     |
	 |* *     |
	 |* *     |
	 |* *     |
	 | *      |
	 |        |
	 +--------+ */
	0x40,
	0xa0,
	0xa0,
	0xa0,
	0xa0,
	0x40,
	0x00,

	/* Character (0x31):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |**      |
	 | *      |
	 | *      |
	 | *      |
	 |***     |
	 |        |
	 +--------+ */
	0x40,
	0xc0,
	0x40,
	0x40,
	0x40,
	0xe0,
	0x00,

	/* Character (0x32):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |   *    |
	 |  *     |
	 | *      |
	 |****    |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x10,
	0x20,
	0x40,
	0xf0,
	0x00,

	/* Character (0x33):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |   *    |
	 | **     |
	 |   *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0xf0,
	0x10,
	0x60,
	0x10,
	0x90,
	0x60,
	0x00,

	/* Character (0x34):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 | **     |
	 |* *     |
	 |****    |
	 |  *     |
	 |  *     |
	 |        |
	 +--------+ */
	0x20,
	0x60,
	0xa0,
	0xf0,
	0x20,
	0x20,
	0x00,

	/* Character (0x35):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |*       |
	 |***     |
	 |   *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0xf0,
	0x80,
	0xe0,
	0x10,
	0x90,
	0x60,
	0x00,

	/* Character (0x36):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*       |
	 |***     |
	 |*  *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x80,
	0xe0,
	0x90,
	0x90,
	0x60,
	0x00,

	/* Character (0x37):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |   *    |
	 |  *     |
	 |  *     |
	 | *      |
	 | *      |
	 |        |
	 +--------+ */
	0xf0,
	0x10,
	0x20,
	0x20,
	0x40,
	0x40,
	0x00,

	/* Character (0x38):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 | **     |
	 |*  *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x60,
	0x90,
	0x90,
	0x60,
	0x00,

	/* Character (0x39):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |*  *    |
	 | ***    |
	 |   *    |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x90,
	0x70,
	0x10,
	0x60,
	0x00,

	/* Character (0x3a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 | **     |
	 | **     |
	 |        |
	 | **     |
	 | **     |
	 |        |
	 +--------+ */
	0x00,
	0x60,
	0x60,
	0x00,
	0x60,
	0x60,
	0x00,

	/* Character (0x3b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 | **     |
	 | **     |
	 |        |
	 | **     |
	 | *      |
	 |*       |
	 +--------+ */
	0x00,
	0x60,
	0x60,
	0x00,
	0x60,
	0x40,
	0x80,

	/* Character (0x3c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |  *     |
	 | *      |
	 |*       |
	 | *      |
	 |  *     |
	 |        |
	 +--------+ */
	0x00,
	0x20,
	0x40,
	0x80,
	0x40,
	0x20,
	0x00,

	/* Character (0x3d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |****    |
	 |        |
	 |****    |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xf0,
	0x00,
	0xf0,
	0x00,
	0x00,

	/* Character (0x3e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |*       |
	 | *      |
	 |  *     |
	 | *      |
	 |*       |
	 |        |
	 +--------+ */
	0x00,
	0x80,
	0x40,
	0x20,
	0x40,
	0x80,
	0x00,

	/* Character (0x3f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |* *     |
	 |  *     |
	 | *      |
	 |        |
	 | *      |
	 |        |
	 +--------+ */
	0x40,
	0xa0,
	0x20,
	0x40,
	0x00,
	0x40,
	0x00,

	/* Character (0x40):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |* **    |
	 |* **    |
	 |*       |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0xb0,
	0xb0,
	0x80,
	0x60,
	0x00,

	/* Character (0x41):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |*  *    |
	 |****    |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x90,
	0xf0,
	0x90,
	0x90,
	0x00,

	/* Character (0x42):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 |*  *    |
	 |***     |
	 |*  *    |
	 |*  *    |
	 |***     |
	 |        |
	 +--------+ */
	0xe0,
	0x90,
	0xe0,
	0x90,
	0x90,
	0xe0,
	0x00,

	/* Character (0x43):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |*       |
	 |*       |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x80,
	0x80,
	0x90,
	0x60,
	0x00,

	/* Character (0x44):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |***     |
	 |        |
	 +--------+ */
	0xe0,
	0x90,
	0x90,
	0x90,
	0x90,
	0xe0,
	0x00,

	/* Character (0x45):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |*       |
	 |***     |
	 |*       |
	 |*       |
	 |****    |
	 |        |
	 +--------+ */
	0xf0,
	0x80,
	0xe0,
	0x80,
	0x80,
	0xf0,
	0x00,

	/* Character (0x46):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |*       |
	 |***     |
	 |*       |
	 |*       |
	 |*       |
	 |        |
	 +--------+ */
	0xf0,
	0x80,
	0xe0,
	0x80,
	0x80,
	0x80,
	0x00,

	/* Character (0x47):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |*       |
	 |* **    |
	 |*  *    |
	 | ***    |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x80,
	0xb0,
	0x90,
	0x70,
	0x00,

	/* Character (0x48):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |*  *    |
	 |****    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x90,
	0x90,
	0xf0,
	0x90,
	0x90,
	0x90,
	0x00,

	/* Character (0x49):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 |***     |
	 |        |
	 +--------+ */
	0xe0,
	0x40,
	0x40,
	0x40,
	0x40,
	0xe0,
	0x00,

	/* Character (0x4a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |   *    |
	 |   *    |
	 |   *    |
	 |   *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x10,
	0x10,
	0x10,
	0x10,
	0x90,
	0x60,
	0x00,

	/* Character (0x4b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |* *     |
	 |**      |
	 |**      |
	 |* *     |
	 |*  *    |
	 |        |
	 +--------+ */
	0x90,
	0xa0,
	0xc0,
	0xc0,
	0xa0,
	0x90,
	0x00,

	/* Character (0x4c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 |*       |
	 |*       |
	 |*       |
	 |*       |
	 |****    |
	 |        |
	 +--------+ */
	0x80,
	0x80,
	0x80,
	0x80,
	0x80,
	0xf0,
	0x00,

	/* Character (0x4d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |****    |
	 |****    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x90,
	0xf0,
	0xf0,
	0x90,
	0x90,
	0x90,
	0x00,

	/* Character (0x4e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |** *    |
	 |** *    |
	 |* **    |
	 |* **    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x90,
	0xd0,
	0xd0,
	0xb0,
	0xb0,
	0x90,
	0x00,

	/* Character (0x4f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x90,
	0x90,
	0x90,
	0x60,
	0x00,

	/* Character (0x50):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 |*  *    |
	 |*  *    |
	 |***     |
	 |*       |
	 |*       |
	 |        |
	 +--------+ */
	0xe0,
	0x90,
	0x90,
	0xe0,
	0x80,
	0x80,
	0x00,

	/* Character (0x51):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |** *    |
	 | **     |
	 |   *    |
	 +--------+ */
	0x60,
	0x90,
	0x90,
	0x90,
	0xd0,
	0x60,
	0x10,

	/* Character (0x52):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 |*  *    |
	 |*  *    |
	 |***     |
	 |* *     |
	 |*  *    |
	 |        |
	 +--------+ */
	0xe0,
	0x90,
	0x90,
	0xe0,
	0xa0,
	0x90,
	0x00,

	/* Character (0x53):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | **     |
	 |*  *    |
	 | *      |
	 |  *     |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x60,
	0x90,
	0x40,
	0x20,
	0x90,
	0x60,
	0x00,

	/* Character (0x54):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 |        |
	 +--------+ */
	0xe0,
	0x40,
	0x40,
	0x40,
	0x40,
	0x40,
	0x00,

	/* Character (0x55):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x90,
	0x90,
	0x90,
	0x90,
	0x90,
	0x60,
	0x00,

	/* Character (0x56):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 | **     |
	 | **     |
	 |        |
	 +--------+ */
	0x90,
	0x90,
	0x90,
	0x90,
	0x60,
	0x60,
	0x00,

	/* Character (0x57):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |****    |
	 |****    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x90,
	0x90,
	0x90,
	0xf0,
	0xf0,
	0x90,
	0x00,

	/* Character (0x58):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*  *    |
	 |*  *    |
	 | **     |
	 | **     |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x90,
	0x90,
	0x60,
	0x60,
	0x90,
	0x90,
	0x00,

	/* Character (0x59):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |* *     |
	 |* *     |
	 |* *     |
	 | *      |
	 | *      |
	 | *      |
	 |        |
	 +--------+ */
	0xa0,
	0xa0,
	0xa0,
	0x40,
	0x40,
	0x40,
	0x00,

	/* Character (0x5a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |****    |
	 |   *    |
	 |  *     |
	 | *      |
	 |*       |
	 |****    |
	 |        |
	 +--------+ */
	0xf0,
	0x10,
	0x20,
	0x40,
	0x80,
	0xf0,
	0x00,

	/* Character (0x5b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 |*       |
	 |*       |
	 |*       |
	 |*       |
	 |***     |
	 |        |
	 +--------+ */
	0xe0,
	0x80,
	0x80,
	0x80,
	0x80,
	0xe0,
	0x00,

	/* Character (0x5c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |*       |
	 | *      |
	 |  *     |
	 |   *    |
	 |        |
	 |        |
	 +--------+ */
	0x00,
	0x80,
	0x40,
	0x20,
	0x10,
	0x00,
	0x00,

	/* Character (0x5d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |***     |
	 |  *     |
	 |  *     |
	 |  *     |
	 |  *     |
	 |***     |
	 |        |
	 +--------+ */
	0xe0,
	0x20,
	0x20,
	0x20,
	0x20,
	0xe0,
	0x00,

	/* Character (0x5e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |* *     |
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x40,
	0xa0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x5f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 |****    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xf0,
	0x00,

	/* Character (0x60):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |**      |
	 | *      |
	 |  *     |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0xc0,
	0x40,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,

	/* Character (0x61):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | ***    |
	 |*  *    |
	 |* **    |
	 | * *    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x70,
	0x90,
	0xb0,
	0x50,
	0x00,

	/* Character (0x62):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 |*       |
	 |***     |
	 |*  *    |
	 |*  *    |
	 |***     |
	 |        |
	 +--------+ */
	0x80,
	0x80,
	0xe0,
	0x90,
	0x90,
	0xe0,
	0x00,

	/* Character (0x63):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | **     |
	 |*       |
	 |*       |
	 | **     |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x60,
	0x80,
	0x80,
	0x60,
	0x00,

	/* Character (0x64):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |   *    |
	 |   *    |
	 | ***    |
	 |*  *    |
	 |*  *    |
	 | ***    |
	 |        |
	 +--------+ */
	0x10,
	0x10,
	0x70,
	0x90,
	0x90,
	0x70,
	0x00,

	/* Character (0x65):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | **     |
	 |* **    |
	 |**      |
	 | **     |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x60,
	0xb0,
	0xc0,
	0x60,
	0x00,

	/* Character (0x66):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 | * *    |
	 | *      |
	 |***     |
	 | *      |
	 | *      |
	 |        |
	 +--------+ */
	0x20,
	0x50,
	0x40,
	0xe0,
	0x40,
	0x40,
	0x00,

	/* Character (0x67):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | ***    |
	 |*  *    |
	 | **     |
	 |*       |
	 | ***    |
	 +--------+ */
	0x00,
	0x00,
	0x70,
	0x90,
	0x60,
	0x80,
	0x70,

	/* Character (0x68):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 |*       |
	 |***     |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x80,
	0x80,
	0xe0,
	0x90,
	0x90,
	0x90,
	0x00,

	/* Character (0x69):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 |        |
	 |**      |
	 | *      |
	 | *      |
	 |***     |
	 |        |
	 +--------+ */
	0x40,
	0x00,
	0xc0,
	0x40,
	0x40,
	0xe0,
	0x00,

	/* Character (0x6a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 |        |
	 |  *     |
	 |  *     |
	 |  *     |
	 |* *     |
	 | *      |
	 +--------+ */
	0x20,
	0x00,
	0x20,
	0x20,
	0x20,
	0xa0,
	0x40,

	/* Character (0x6b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 |*       |
	 |* *     |
	 |**      |
	 |* *     |
	 |*  *    |
	 |        |
	 +--------+ */
	0x80,
	0x80,
	0xa0,
	0xc0,
	0xa0,
	0x90,
	0x00,

	/* Character (0x6c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |**      |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 |***     |
	 |        |
	 +--------+ */
	0xc0,
	0x40,
	0x40,
	0x40,
	0x40,
	0xe0,
	0x00,

	/* Character (0x6d):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |* *     |
	 |****    |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xa0,
	0xf0,
	0x90,
	0x90,
	0x00,

	/* Character (0x6e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |***     |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xe0,
	0x90,
	0x90,
	0x90,
	0x00,

	/* Character (0x6f):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | **     |
	 |*  *    |
	 |*  *    |
	 | **     |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x60,
	0x90,
	0x90,
	0x60,
	0x00,

	/* Character (0x70):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |***     |
	 |*  *    |
	 |*  *    |
	 |***     |
	 |*       |
	 +--------+ */
	0x00,
	0x00,
	0xe0,
	0x90,
	0x90,
	0xe0,
	0x80,

	/* Character (0x71):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | ***    |
	 |*  *    |
	 |*  *    |
	 | ***    |
	 |   *    |
	 +--------+ */
	0x00,
	0x00,
	0x70,
	0x90,
	0x90,
	0x70,
	0x10,

	/* Character (0x72):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |***     |
	 |*  *    |
	 |*       |
	 |*       |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xe0,
	0x90,
	0x80,
	0x80,
	0x00,

	/* Character (0x73):
	   bbw=6, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 | ***    |
	 |**      |
	 |  **    |
	 |***     |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x70,
	0xc0,
	0x30,
	0xe0,
	0x00,

	/* Character (0x74):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 | *      |
	 |***     |
	 | *      |
	 | *      |
	 |  **    |
	 |        |
	 +--------+ */
	0x40,
	0x40,
	0xe0,
	0x40,
	0x40,
	0x30,
	0x00,

	/* Character (0x75):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |*  *    |
	 |*  *    |
	 |*  *    |
	 | ***    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x90,
	0x90,
	0x90,
	0x70,
	0x00,

	/* Character (0x76):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |* *     |
	 |* *     |
	 |* *     |
	 | *      |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xa0,
	0xa0,
	0xa0,
	0x40,
	0x00,

	/* Character (0x77):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |*  *    |
	 |*  *    |
	 |****    |
	 |****    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x90,
	0x90,
	0xf0,
	0xf0,
	0x00,

	/* Character (0x78):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |*  *    |
	 | **     |
	 | **     |
	 |*  *    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0x90,
	0x60,
	0x60,
	0x90,
	0x00,

	/* Character (0x79):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |*  *    |
	 |*  *    |
	 | * *    |
	 |  *     |
	 | *      |
	 +--------+ */
	0x00,
	0x00,
	0x90,
	0x90,
	0x50,
	0x20,
	0x40,

	/* Character (0x7a):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |        |
	 |        |
	 |****    |
	 |  *     |
	 | *      |
	 |****    |
	 |        |
	 +--------+ */
	0x00,
	0x00,
	0xf0,
	0x20,
	0x40,
	0xf0,
	0x00,

	/* Character (0x7b):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |  *     |
	 | *      |
	 |**      |
	 | *      |
	 | *      |
	 |  *     |
	 |        |
	 +--------+ */
	0x20,
	0x40,
	0xc0,
	0x40,
	0x40,
	0x20,
	0x00,

	/* Character (0x7c):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 | *      |
	 |        |
	 +--------+ */
	0x40,
	0x40,
	0x40,
	0x40,
	0x40,
	0x40,
	0x00,

	/* Character (0x7d):
	   bbw=6, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 |*       |
	 | *      |
	 | **     |
	 | *      |
	 | *      |
	 |*       |
	 |        |
	 +--------+ */
	0x80,
	0x40,
	0x60,
	0x40,
	0x40,
	0x80,
	0x00,

	/* Character (0x7e):
	   bbw=5, bbh=7, bbx=0, bby=-1, width=5
	 +--------+
	 | * *    |
	 |* *     |
	 |        |
	 |        |
	 |        |
	 |        |
	 |        |
	 +--------+ */
	0x50,
	0xa0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
};

static const uint8_t logo_nxp[] = {

	0x80, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0xF0, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFE, 0xF8, 0xE3, 0xC7, 0x1F, 0x7F, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF8, 0xE0, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xF0, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x8F, 0xE3, 0xF1, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF8, 0xF0, 0xE0, 0xC0, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF8, 0xE3,
	0x87, 0x1F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
	0xF0, 0xF0, 0xF8, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F,
	0x3F, 0x8F, 0xC3, 0xF1, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1F,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFE, 0xF8, 0xF0, 0xE0, 0xC0, 0xFF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x7C, 0x18, 0x83, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0x01, 0x3C,
	0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0,
	0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xFC,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F, 0x8F,
	0xE3, 0xF0, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F,
	0x1F, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
	0xF8, 0xE1, 0xC7, 0x1F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x03, 0x07, 0x0F, 0x1F, 0x3F, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F, 0x8F, 0xE3, 0xF1, 0xFC, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x1F, 0x0F, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x1F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF8, 0xE3, 0xC7, 0x1F, 0x3F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	};


#endif /* FSL_FONT5X7_H_ */
