        .export _init

        .section .text
_init:
        ;; set up SVC mode stack pointer
        .import _stack_e
        ldr     sp, =_stack_e

        ;; set up IRQ mode stack pointer
        .import _irq_stack_e
        msr     cpsr_c, 0xD2    ; change to IRQ mode (IRQ/FIQ off)
        ldr     sp, =_irq_stack_e
        msr     cpsr_c, 0xD3    ; change back to supervisor mode (IRQ/FIQ off)

        ;; set VBAR to vector table address
        .import vt
        ldr     r0, =vt
        mcr     p15, 0, r0, c12, c0, 0

        ;; jump to main
        .import main
        bl      main

trap:
        b       trap
