#include "mscm.h"
#include "smc.h"

static void module_init(void)
{
    smc_init();
}

static int still_testing(void)
{
    return 1;
}

#define SIEVE_SIZE 120
/* Run the Sieve of Eratosthenes */
static int * sieve_of_eratosthenes(void)
{
    static int numbers[SIEVE_SIZE];
    int i, next_multiple;

    /* reset the number list */
    for (i = 0; i < SIEVE_SIZE; i++) {
        numbers[i] = 1;
    }

    for (i = 2; i < SIEVE_SIZE; i++) {
        if (numbers[i] == 0) continue;
        for (next_multiple = i * 2; next_multiple < SIEVE_SIZE; next_multiple += i) {
            numbers[next_multiple] = 0;
        }
    }

    return numbers;
}

int main(void)
{
    /* initialize modules handled by CM0+ */
    module_init();

    /* tell the CM4 that the CM0+ has finished initialization */
    mscm_interrupt_cpu(MSCM_CPU_CM4, (uint8_t)mscm_whoami());

    /* keep the CM0+ busy */
    while (still_testing()) {
        sieve_of_eratosthenes();
    }

    return 0;
}
