        .export _init

        .section .text
_init:
        ;; disable CM4 watchdog
        ldr     r0, =0x40088010
        ldr     r1, =0xC520
        str     r1, [r0]
        ldr     r1, =0xD928
        str     r1, [r0]
        subs    r0, r0, 0x10
        ldr     r1, =0xFF00010A
        str     r1, [r0]

        ;; set up stack pointer
        .import _stack_e
        ldr     r0, =_stack_e
        mov     sp, r0

        ;; set VTOR to point to vector table
        .import vt
        ldr     r0, =0xE000ED08 ; VTOR address
        ldr     r1, =vt
        str     r1, [r0]

        ;; jump to main
        .import main
        bl      main

trap:
        b       trap
