#include "MAC57D54H.h"
#include "cortexm.h"
#include "dma.h"
#include "siul2.h"
#include "mscm.h"

static void module_init(void)
{
    dma_cm4_init();
}

void system_tick(void)
{
    systick_clear_flag();
}

static int still_testing(void)
{
    return 1;
}

#define SIEVE_SIZE 120
/* Run the Sieve of Eratosthenes */
static int * sieve_of_eratosthenes(void)
{
    static int numbers[SIEVE_SIZE];
    int i, next_multiple;

    /* reset the number list */
    for (i = 0; i < SIEVE_SIZE; i++) {
        numbers[i] = 1;
    }

    for (i = 2; i < SIEVE_SIZE; i++) {
        if (numbers[i] == 0) continue;
        for (next_multiple = i * 2; next_multiple < SIEVE_SIZE; next_multiple += i) {
            numbers[next_multiple] = 0;
        }
    }

    return numbers;
}

static int cm0p_ready = 0;
static int ca5_ready = 0;

void interrupt_from_cm0p(void)
{
    mscm_clear_cpu_interrupt((uint8_t)MSCM_CPU_CM0P);
    cm0p_ready = 1;
}

void interrupt_from_ca5(void)
{
    mscm_clear_cpu_interrupt((uint8_t)MSCM_CPU_CA5);
    ca5_ready = 1;
}

static int other_cores_ready(void)
{
    return cm0p_ready && ca5_ready;
}

#ifdef ATE
#define FAIL_PIN 5
#define DONE_PIN 6
#else
#define FAIL_PIN 176
#define DONE_PIN 177
#endif
int main(void)
{
    /* turn on interrupts */
    __enable_irq();

    /* initialize modules handled by CM4 */
    module_init();

    /* wait until the CM0+ and CA5 indicate they are ready */
    mscm_route_interrupt((uint8_t)MSCM_CPU_CM0P);
    mscm_route_interrupt((uint8_t)MSCM_CPU_CA5);
    nvic_enable_irq((uint8_t)MSCM_CPU_CM0P);
    nvic_enable_irq((uint8_t)MSCM_CPU_CA5);
    while (!other_cores_ready()) {}

    /* Set up SysTick for 1ms ticks (assumes 160MHz CM4 clock) */
    systick_current(1);
    systick_reload(160000);
    systick_start();

    /* set the 'done' pin */
    siul2_io_config(DONE_PIN, SIUL2_CONFIG_OBE, 0);
    siul2_gpio_hi(DONE_PIN);

    /* keep the CM4 busy */
    while (still_testing()) {
        sieve_of_eratosthenes();
    }

    return 0;
}
