#include <stddef.h>

#include "config.h"
#include "mc.h"
#include "uart.h"
#include "tinyprintf.h"
#include "iop.h"
#include "led.h"

#define PMCDIG_BASE 0x400CC000
#define PMCDIG_RDCR (PMCDIG_BASE + 0x00)
#define PMCDIG_SGSR (PMCDIG_BASE + 0x04)
#define PMCDIG_MCR  (PMCDIG_BASE + 0x10)

void basic_config(void) {
    /* turn on XOSC */
    mode_clock_enable(DRUN, FXOSC);
    enter_mode(DRUN);
    while (mode_transition_ongoing()) {}

    /* 320 MHz PLL0 from 40 MHz XOSC */
    auxclk_src_set(0, FXOSC);
    pll_cfg(PLL0, 2, 32, 0);

    /* turn on PLL0 */
    mode_clock_enable(DRUN, PLL0);
    enter_mode(DRUN);
    while (mode_transition_ongoing()) {}

    /* DDR/SDR clock = 320 Mhz */
    sysclk_div_set(0, 0);
    sysclk_div_enable(0);
    /* CA5 clock = 320 Mhz */
    sysclk_div_set(1, 0);
    sysclk_div_enable(1);
    /* CM4/Platform = 160 Mhz */
    sysclk_div_set(2, 1);
    sysclk_div_enable(2);
    /* Peripherals = 80 Mhz */
    sysclk_div_set(3, 3);
    sysclk_div_enable(3);
    /* IOP clock = 80 Mhz */
    sysclk_div_set(4, 3);
    sysclk_div_enable(4);
    /* 2X platform clock */
    sysclk_div_set(5, 0);
    sysclk_div_enable(5);

    /* set PLL0 to sysclk */
    mode_sysclk_src_set(DRUN, PLL0);
    enter_mode(DRUN);
    while (mode_transition_ongoing()) {}
    
    run_percfg_mode_disable(0, DRUN);
    run_percfg_mode_enable(1, DRUN);
 
    /* Turn on SIUL and LINFlex_2 */
    perctl_run_percfg_set(26, 1);
    perctl_run_percfg_set(60, 1);
    enter_mode(DRUN);

    /* Configure 160 MHz linflex clock from PLL0 */
    auxclk_src_set(2, PLL0);
    auxclk_div_set(2, 1, 1);
    auxclk_div_enable(2, 1);

    /* 115200 baud from 160 MHz clock */
    uart_init(86, 13);

    init_printf(NULL, uart_putc);

    /* initialize LEDs */
    led_init();
}

void iop_basic_config(void) {
    /* Allow CM0+ in STANDBY modes */
    core_mode_enable(CM0P, STANDBY0);

    /* Enable additional mode */
    mode_enable(STANDBY0);
    mode_enable(RUN0);
    mode_enable(RUN1);
    mode_enable(RUN2);
    mode_enable(RUN3);

    /* Disable all modules using percfg 0 */
    run_percfg_mode_disable(0, DRUN);
    run_percfg_mode_disable(0, RUN0);
    run_percfg_mode_disable(0, RUN1);
    run_percfg_mode_disable(0, RUN2);
    run_percfg_mode_disable(0, RUN3);
    lp_percfg_mode_disable(0, STANDBY0);
    enter_mode(DRUN);
    while (mode_transition_ongoing()) {}

    /* Disable all modules in IOP modes */
    iop_module_disable_all();

    /* enable SIUL for LED indicators in all modes */
    run_percfg_mode_enable(1, DRUN);
    run_percfg_mode_enable(1, RUN0);
    run_percfg_mode_enable(1, RUN1);
    run_percfg_mode_enable(1, RUN2);
    run_percfg_mode_enable(1, RUN3);
    lp_percfg_mode_enable(1, STANDBY0);
    perctl_run_percfg_set(60, 1);
    perctl_lp_percfg_set(60, 1);
    enter_mode(DRUN);
    while (mode_transition_ongoing()) {}

    /* allow SIUL in IOP modes */
    iop_module_enable(IOP_SIUL);

    /* initialize LEDs */
    led_init();

    /* disable SIRC clock in DRUN */
    mode_clock_disable(DRUN, SIRC);
    enter_mode(DRUN);
    while (mode_transition_ongoing()) {}

    /* Set ISO_ACK bit */
    *(volatile unsigned int *)PMCDIG_MCR = 0x70000000;

    /* don't reset CM0+ on IOP mode change */
    iop_config(IOP_NO_RMC);
}

void all_aux_config(void) {
    run_percfg_mode_enable(0, DRUN);
    
    auxclk_src_set(1, FXOSC);
    auxclk_div_set(1, 0, 0);
    auxclk_div_enable(1, 0);

    auxclk_src_set(3, FXOSC);
    auxclk_div_set(3, 0, 0);
    auxclk_div_enable(3, 0);

    auxclk_src_set(4, FXOSC);
    auxclk_div_set(4, 0, 0);
    auxclk_div_enable(4, 0);

    auxclk_src_set(5, FXOSC);
    auxclk_div_set(5, 0, 0);
    auxclk_div_enable(5, 0);
    auxclk_div_set(5, 1, 0);
    auxclk_div_enable(5, 1);

    auxclk_src_set(6, FXOSC);
    auxclk_div_set(6, 0, 0);
    auxclk_div_enable(6, 0);

    auxclk_src_set(7, FXOSC);
    auxclk_div_set(7, 0, 0);
    auxclk_div_enable(7, 0);

    auxclk_src_set(8, FXOSC);
    auxclk_div_set(8, 0, 0);
    auxclk_div_enable(8, 0);

    auxclk_src_set(9, FXOSC);
    auxclk_div_set(9, 0, 0);
    auxclk_div_enable(9, 0);

    auxclk_src_set(10, FXOSC);
    auxclk_div_set(10, 0, 0);
    auxclk_div_enable(10, 0);

    auxclk_src_set(11, FXOSC);
    auxclk_div_set(11, 0, 0);
    auxclk_div_enable(11, 0);

    auxclk_src_set(12, FXOSC);
    auxclk_div_set(12, 0, 0);
    auxclk_div_enable(12, 0);

    auxclk_src_set(13, FXOSC);
    auxclk_div_set(13, 0, 0);
    auxclk_div_enable(13, 0);

    auxclk_src_set(14, FXOSC);
    auxclk_div_set(14, 0, 0);
    auxclk_div_enable(14, 0);

    auxclk_src_set(15, FXOSC);
    auxclk_div_set(15, 0, 0);
    auxclk_div_enable(15, 0);
    auxclk_div_set(15, 1, 0);
    auxclk_div_enable(15, 1);
}
