DEFAULTS {
    STACK_SIZE  = 4K;
    PE_RESERVED = 0x100
    GFX_RESERVED = 256K
}

MEMORY {
    gram         : org = 0x3F000000 + PE_RESERVED, len = 1M - PE_RESERVED - GFX_RESERVED
    gram_gfx     : org = 0x3F000000 + 1M - GFX_RESERVED, len = GFX_RESERVED
    sram         : org = 0x3EF00000, len = 1M
    iop_ram      : org = 0x3E400000, len = 32K
    cm4_tcm_code : org = 0x1E000000, len = 32K
    cm4_tcm_data : org = 0x3E000000, len = 32K
}

SECTIONS
{
    .text : {
        *(.text)
        *(.rodata)
    } > gram

    .data : {
        *(.data)
    } > .

    .bss : {
        *(.bss)
    } > .

    .stack ALIGN(8) : {
        _stack_s = .;
        . = STACK_SIZE;
        _stack_e = .;
    } > .

    .sdabase : {} > . /* required by GHS, but should be empty */

    .cm4 ALIGN(32) : {
        _cm4_raw_s = .;
        cm4.mem(.raw)
        . = ALIGN(32);
        _cm4_raw_e = .;
    } > .

    .ca5 ALIGN(32) : {
        _ca5_raw_s = .;
        ca5.mem(.raw)
        . = ALIGN(32);
        _ca5_raw_e = .;
    } > .
    
    .cm0p ALIGN(32) : {
        _cm0p_raw_s = .;
        cm0p.mem(.raw)
        . = ALIGN(32);
        _cm0p_raw_e = .;
    } > .

    _cm4_start_addr = MEMADDR(cm4_tcm_code);
    _ca5_start_addr = MEMADDR(sram);
    _cm0p_start_addr = MEMADDR(iop_ram);

/*
 * These special symbols mark the bounds of RAM and ROM memory.
 * They are used by the MULTI debugger.
 */
    __ghs_ramstart  = MEMADDR(gram);
    __ghs_ramend    = MEMENDADDR(gram);
}
