DEFAULTS {
    CM4_STACK_SIZE  = 4K;
    CA5_STACK_SIZE  = 4K;
    CM0P_STACK_SIZE = 4K;
    PE_RESERVED = 0x100
}

MEMORY {
    gram         : org = 0x3F000000 + PE_RESERVED, len = 1M - PE_RESERVED
    sram         : org = 0x3EF00000, len = 1M
    iop_ram      : org = 0x3E400000, len = 32K
    cm4_tcm_code : org = 0x1E000000, len = 32K
    cm4_tcm_data : org = 0x3E000000, len = 32K
}

SECTIONS
{

/*
 * Everything is stuffed into GRAM. During initialization, the CM4 will move:
 * - CM4 text segments into cm4_tcm_code
 * - CM4 data segments into cm4_data_code
 * - CA5 text/data segments into sram
 * - CM0+ text/data segments into iop_ram
 *
 * Aligning everything to 32 bytes allows us to quickly initialize memory using
 * the DMA burst read/write functionality.
 *
 * Clearing BSS segments happens while the CM4 initializes memory.
 */

    .init : {
        cm4_init.o(.text)
        cm4_init.o(.data)
        cm4_init.o(.bss)
    } > gram
    
    . = ALIGN(32);
    _cm4_text_lma = .;
    _cm4_data_lma = _cm4_text_lma + SIZEOF(.cm4_text);
    _ca5_text_lma = _cm4_data_lma + SIZEOF(.cm4_data);
    _ca5_data_lma = _ca5_text_lma + SIZEOF(.ca5_text);
    _cm0p_text_lma = _ca5_data_lma + SIZEOF(.ca5_data);
    _cm0p_data_lma = _cm0p_text_lma + SIZEOF(.cm0p_text);
    . = _cm0p_data_lma + SIZEOF(.cm0p_data);

    .sdabase : {} > . /* required by GHS, but should be empty */
    
 /*
  * CM4 code segments
  */
  
    .cm4_text : AT(_cm4_text_lma) {
        _cm4_text_vma_s = .;
        cm4_vt.o(.text) /* place the vector table first to satisfy alignment */
        "cm4_*.o(.text)"
        "cm4_*.o(.rodata)"
        . = ALIGN(32);
        _cm4_text_vma_e = .;
    } > cm4_tcm_code

/*
 * CM4 data segments
 */

    .cm4_data : AT(_cm4_data_lma) {
        _cm4_data_vma_s = .;
        "cm4_*.o(.data)"
        . = ALIGN(32);
        _cm4_data_vma_e = .;
    } > cm4_tcm_data

    .cm4_bss : {
        "cm4_*.o(.bss)"
    } > .

    .cm4_stack ALIGN(8) : {
        _cm4_stack_s = .;
        . = CM4_STACK_SIZE;
        _cm4_stack_e = .;
    } > .

/*
 * CA5 code/data segments
 */

    .ca5_text : AT(_ca5_text_lma) {
        _ca5_text_vma_s = .;
        ca5_vt.o(.text) /* place the vector table first to satisy alignment */
        "ca5_*.o(.text)"
        "ca5_*.o(.rodata)"
        . = ALIGN(32);
        _ca5_text_vma_e = .;
    } > sram

    .ca5_data : AT(_ca5_data_lma) {
        _ca5_data_vma_s = .;
        "ca5_*.o(.data)"
        . = ALIGN(32);
        _ca5_data_vma_e = .;
    } > .

    .ca5_bss : {
        "ca5_*.o(.bss)"
    } > .

    .ca5_stack ALIGN(8) : {
        _ca5_stack_s = .;
        . = CA5_STACK_SIZE;
        _ca5_stack_e = .;
    } > .

/*
 * CM0+ code/data segments
 */

    .cm0p_text : AT(_cm0p_text_lma) {
        _cm0p_text_vma_s = .;
        cm0p_vt.o(.text) /* place the vector table first to satisy alignment */
        "cm0p_*.o(.text)"
        "cm0p_*.o(.rodata)"
        . = ALIGN(32);
        _cm0p_text_vma_e = .;
    } > iop_ram

    .cm0p_data : AT(_cm0p_data_lma) {
        _cm0p_data_vma_s = .;
        "cm0p_*.o(.data)"
        . = ALIGN(32);
        _cm0p_data_vma_e = .;
    } > .

    .cm0p_bss : {
        "cm0p_*.o(.bss)"
    } > .

    .cm0p_stack ALIGN(8) : {
        _cm0p_stack_s = .;
        . = CM0P_STACK_SIZE;
        _cm0p_stack_e = .;
    } > .

/*
 * These special symbols mark the bounds of RAM and ROM memory.
 * They are used by the MULTI debugger.
 */
    __ghs_ramstart  = MEMADDR(sram);
    __ghs_ramend    = MEMENDADDR(sram);
}
