#include "MAC57D54H.h"
#include "DCUcommon.h"

void DCU0_init(uint32_t freq, uint8_t mode)
{   
    uint32_t i;

    DCU_0.BGND.R = 0x00707070;	/* Background colour = grey */
    DCU_0.MODE.B.RASTER_EN=1;

/* Sharp LQ043 set up */
//    LQ043_setup(freq);
//  SVGA_setup(0,freq);
/* Sharp LQ050 set up */
#ifdef __EVB
    LQ050_setup(0,freq);
#else
    /* Generic Panel set up */
    Panel_setup(0,freq);
#endif
  /* initialise layers to be off */
  for(i=0;i<32;i++){
    DCU_0.LAYER[i].CTRLDESCL_1.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_2.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_3.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_4.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_5.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_6.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_7.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_8.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_9.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_10.R = 0;  /*  */
    DCU_0.LAYER[i].CTRLDESCL_11.R = 0;  /*  */	
  }


  if (mode > 0)
  {
    DCU_0.MODE.B.DCU_MODE = mode;
    DCU_0.UPDATE_MODE.B.READREG = 1;  /* Initiate manual refresh */
  }
}

void DCU1_init(uint32_t freq, uint8_t mode)
{   
}
