#include "MAC57D54H.h"
#include <stdio.h>
#include "m4_cache.h"
#include "halo_ports.h"

const uint8_t water_Bitmap0[];
unsigned char LETTER_Data[];
extern const void* __vector_table;
extern void sysinit();
extern void disable_wdog();
extern void ecc_init();

void dcu_layer(int layer, int address, int width, int height, int bpp);
void dcu_layer_en(int layer, int enable);
void dcu_layer_pos(int layer, int x, int y);

int main(int argc, char *argv[])
{
	uint32_t i,j;
	disable_wdog();
	write_vtor((uint32_t)&__vector_table); /* configure vector table address */
	asm(" CPSIE i"); //enable interrupts (if required)
	//m4_cache_init(CODE_CACHE);
	//m4_cache_init(SYS_CACHE);
	sysinit();
	ecc_init();
	
	#define PF3 83
	#define BACKLIGHT PF3
	SIUL2.MSCR[BACKLIGHT].B.OBE = 1;
	SIUL2.GPDO[20].B.PDO_4n3 = 1;	

    MC_CGM.AC6_DC0.R = 0x80060000;	/* /7 = 91 MHz */
    MC_CGM.AC6_SC.B.SELCTL = 4;	/* Select PLL0 */
    DCU0_init(91,1);

    /* Wait until frame complete then go to automatic mode */
    while(DCU_0.UPDATE_MODE.B.READREG) {}
    DCU_0.UPDATE_MODE.B.MODE = 1;
	
	dcu_layer(6, (int)water_Bitmap0,800,480,4);
	dcu_layer_en(6,1);

	dcu_layer(0, (int)LETTER_Data,128,128,8);
	dcu_layer_pos(0,0,0);
	dcu_layer_en(0,1);
	

    while(1);
}

void dcu_layer(int layer, int address, int width, int height, int bpp)
{
	DCU_0.LAYER[layer].CTRLDESCL_1.B.WIDTH = width;
	DCU_0.LAYER[layer].CTRLDESCL_1.B.HEIGHT = height;
	DCU_0.LAYER[layer].CTRLDESCL_2.R = 0;
	DCU_0.LAYER[layer].CTRLDESCL_3.R = address;
	DCU_0.LAYER[layer].CTRLDESCL_4.R = 0; 
	DCU_0.LAYER[layer].CTRLDESCL_4.B.BPP = bpp; 
	
	DCU_0.LAYER[layer].CTRLDESCL_5.R = 0;
	DCU_0.LAYER[layer].CTRLDESCL_6.R = 0;
	DCU_0.LAYER[layer].CTRLDESCL_7.R = 0;
	DCU_0.LAYER[layer].CTRLDESCL_8.R = 0xffffff;
	DCU_0.LAYER[layer].CTRLDESCL_9.R = 0;
	DCU_0.LAYER[layer].CTRLDESCL_10.R = 0;
	DCU_0.LAYER[layer].CTRLDESCL_11.R = 0;
}

void dcu_layer_pos(int layer, int x, int y)
{
	DCU_0.LAYER[layer].CTRLDESCL_2.B.POSX = x;
	DCU_0.LAYER[layer].CTRLDESCL_2.B.POSY = y;
}


void dcu_layer_en(int layer, int enable)
{
	DCU_0.LAYER[layer].CTRLDESCL_4.B.EN = enable;  
}


const uint8_t water_Bitmap0[] =
{
93,59,252,50,253,50,253,50,253,50,253,50,253,50,29,51,
29,51,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
29,59,253,58,253,50,253,50,253,50,29,59,29,51,61,59,
253,50,253,58,29,59,29,59,29,59,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,59,29,59,29,59,29,59,
30,59,62,59,62,59,62,59,62,59,61,59,61,59,61,59,
61,59,61,59,93,59,93,59,93,59,125,59,91,59,56,59,
57,59,89,67,249,58,29,59,95,59,61,51,125,59,62,59,
62,59,62,59,62,59,62,59,62,59,94,59,94,59,94,59,
62,59,62,59,62,59,62,59,62,59,62,59,62,59,62,59,
62,59,62,59,62,59,94,59,94,59,94,59,94,59,94,59,
62,59,94,59,94,59,94,59,126,59,94,59,94,59,126,59,
93,59,94,59,94,59,126,59,126,59,94,59,94,59,93,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,127,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,59,126,67,158,67,126,67,126,59,126,59,126,59,126,59,
158,59,158,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,126,59,126,59,126,59,126,59,
159,59,159,59,159,59,158,59,158,59,158,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,159,59,
159,67,126,67,126,67,159,67,159,67,126,67,126,67,159,67,
158,67,158,67,158,67,159,67,159,67,159,67,159,67,159,67,
158,67,158,67,158,59,158,59,158,59,158,59,158,67,158,67,
159,59,159,59,158,59,158,59,158,59,159,59,159,67,159,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,127,67,159,67,159,67,159,67,127,67,127,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
159,67,159,67,159,59,159,67,159,67,159,67,159,67,159,59,
159,67,159,67,159,67,158,67,158,67,158,67,158,67,159,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
159,67,159,67,159,67,191,67,191,67,158,67,158,67,158,67,
158,67,158,67,159,67,159,67,158,67,158,67,159,67,159,67,
158,67,158,67,158,67,159,67,159,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,191,67,191,67,191,67,191,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,191,67,191,67,
159,67,159,67,158,67,159,67,159,67,159,67,159,67,159,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
159,67,159,67,191,67,191,67,191,67,191,67,159,67,159,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,190,67,191,75,191,75,190,67,158,67,190,67,
191,67,190,67,190,67,190,67,190,67,190,67,190,67,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
191,67,191,67,191,67,191,67,191,75,191,75,191,75,191,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
191,67,191,67,191,67,191,67,191,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,223,75,223,75,
191,67,191,67,191,67,191,67,191,67,191,67,191,67,191,67,
190,75,223,75,223,75,190,75,190,67,190,67,190,75,223,75,
191,75,191,75,191,75,190,75,190,75,190,75,190,75,191,75,
190,67,190,67,190,67,190,67,223,75,223,75,223,75,223,75,
222,75,222,75,222,75,222,75,190,75,190,75,190,75,190,75,
191,75,191,75,190,75,190,75,190,75,190,75,191,75,191,75,
222,75,222,67,222,67,222,67,222,75,222,75,222,75,222,67,
222,75,222,75,190,75,190,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,223,75,190,67,190,67,223,75,223,75,223,75,
223,75,223,75,223,75,223,75,223,75,223,75,223,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
190,75,222,75,222,75,223,75,223,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,223,75,223,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
191,75,223,75,223,75,223,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,254,75,222,75,221,75,221,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,223,75,223,75,223,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
252,50,187,42,155,42,156,42,156,34,188,42,156,34,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,156,42,
188,42,188,42,188,42,188,42,188,42,155,42,155,42,155,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,188,42,188,42,188,42,188,42,188,42,189,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,220,42,220,42,220,42,220,42,220,42,220,42,
221,42,221,42,221,42,220,42,220,42,220,42,220,42,220,42,
220,42,252,50,28,51,252,42,252,50,252,50,250,50,217,50,
215,50,215,50,151,42,186,50,253,50,253,42,253,50,189,42,
253,50,253,50,253,50,221,42,221,42,221,42,221,42,221,42,
253,50,221,42,221,42,221,42,253,50,253,50,253,50,221,42,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,42,
253,50,253,50,253,50,253,42,253,50,253,50,253,42,29,43,
253,50,253,50,253,50,29,51,29,51,253,50,253,50,253,50,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
253,50,253,50,253,50,253,50,29,51,29,51,29,51,29,51,
29,51,29,51,253,50,253,50,253,50,253,50,253,50,253,50,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,61,51,61,51,
29,51,29,51,61,51,61,51,29,51,29,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,29,51,29,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,62,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
62,51,61,51,61,51,61,51,61,51,61,51,62,51,62,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,59,61,51,62,51,62,51,61,51,62,51,62,51,62,51,
62,51,62,51,61,51,61,51,61,51,62,51,62,59,62,59,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,59,94,59,61,59,61,51,61,51,61,51,61,59,61,59,
61,59,61,59,61,59,61,59,61,59,61,59,61,59,61,59,
61,59,61,59,61,59,61,59,61,59,94,59,94,59,94,59,
62,51,93,51,94,51,94,51,94,51,93,51,93,51,93,51,
61,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
93,59,61,59,61,59,61,59,61,59,61,59,61,59,93,59,
94,59,94,59,61,59,61,59,61,59,61,59,61,59,61,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,61,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,126,59,
93,59,61,59,61,59,61,59,93,59,94,59,94,59,93,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
93,59,93,59,93,59,125,59,125,59,125,59,125,59,125,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
126,59,93,59,93,59,93,59,93,59,93,59,93,59,126,59,
126,59,126,59,126,59,93,59,93,59,126,59,126,59,126,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
93,59,93,59,93,59,94,59,94,59,94,59,94,59,94,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
93,59,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
125,59,125,59,125,59,125,59,93,59,93,59,125,59,125,59,
126,67,93,59,93,59,93,59,93,59,93,59,93,59,93,59,
125,59,125,59,125,59,125,59,125,59,125,59,126,59,126,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
126,59,125,59,125,59,93,59,93,59,125,59,125,59,126,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,125,59,125,59,125,59,126,59,126,59,
125,67,125,67,125,67,125,59,125,59,125,59,125,67,125,67,
125,67,125,67,158,67,158,67,158,67,158,67,125,67,125,67,
125,59,125,67,125,67,158,67,158,67,125,67,125,67,125,67,
158,67,158,67,125,67,125,67,125,67,125,59,125,59,125,59,
125,67,125,67,125,67,125,67,125,67,125,67,125,67,125,67,
125,67,125,67,125,67,125,67,125,67,125,59,125,59,125,59,
126,67,125,67,125,67,125,67,125,67,125,67,125,67,126,67,
125,67,125,67,125,67,125,67,125,67,125,67,125,67,125,67,
126,59,126,59,126,67,125,67,125,67,125,59,157,67,157,67,
125,67,125,67,125,67,125,67,125,67,157,67,157,67,157,67,
125,67,125,67,125,67,125,67,125,67,125,67,125,67,125,67,
125,67,125,67,125,67,125,67,125,67,125,67,125,67,125,67,
125,67,125,67,125,67,125,67,125,67,125,67,125,67,125,67,
125,67,125,67,125,67,125,67,125,67,125,67,125,67,125,67,
157,67,157,67,125,67,125,67,125,67,125,67,157,67,157,67,
125,59,125,67,125,67,125,67,125,59,125,59,125,67,125,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
252,50,155,42,156,42,156,42,156,34,156,34,156,34,156,42,
156,42,156,42,188,42,188,42,156,42,156,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,156,42,156,42,156,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
187,42,219,42,250,50,250,50,218,42,186,42,188,42,189,42,
189,42,189,42,189,42,189,42,188,42,220,42,220,42,220,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
220,42,252,50,28,51,252,42,221,42,220,50,220,50,219,50,
247,50,215,50,183,50,184,42,187,42,222,42,223,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
253,50,221,42,221,42,221,42,253,50,253,50,253,50,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,42,253,42,
254,50,254,50,254,50,254,50,254,50,254,50,254,50,254,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,42,253,42,253,42,253,42,253,42,253,42,253,42,30,51,
254,50,254,50,254,50,254,50,254,50,254,50,254,50,254,50,
29,51,29,51,29,51,29,51,29,51,30,51,30,51,30,51,
29,51,29,51,29,51,29,51,29,51,29,51,30,51,30,51,
29,51,29,51,30,51,30,51,30,51,30,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
30,51,30,51,30,51,29,51,29,51,29,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,29,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,29,51,62,51,62,51,29,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
61,51,61,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,63,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
63,51,63,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,93,51,93,51,
94,51,62,51,62,51,94,51,94,51,94,59,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
61,59,61,59,61,59,61,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,59,94,59,94,51,62,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,62,51,94,51,94,59,94,59,94,59,94,59,
93,59,93,59,93,59,93,59,93,59,93,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,93,59,93,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,67,126,67,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,125,59,125,59,125,67,157,67,
125,59,125,59,125,67,125,67,125,67,125,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,59,125,67,158,67,158,67,158,67,158,67,125,67,125,59,
158,67,158,67,125,67,125,67,125,67,158,67,158,67,158,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
125,59,125,59,125,67,125,67,125,67,125,67,158,67,158,67,
125,67,125,67,125,67,125,59,125,59,125,59,125,59,125,59,
253,50,188,42,156,42,156,42,156,34,157,42,156,34,156,42,
156,34,156,42,188,42,188,42,156,42,156,42,157,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,188,42,219,50,250,50,218,42,187,42,188,42,158,42,
189,42,189,42,189,42,189,42,189,42,189,42,221,42,221,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,42,221,42,252,42,252,42,252,50,252,50,251,50,251,50,
246,50,214,50,246,58,182,50,185,34,222,42,223,42,253,50,
221,42,221,42,221,42,221,42,221,50,254,50,254,50,254,50,
221,50,221,50,221,50,254,50,254,50,254,50,254,50,254,50,
254,50,254,50,254,50,254,50,254,50,254,50,254,50,254,50,
254,50,254,50,254,50,254,50,254,50,254,50,254,42,254,42,
254,50,254,50,254,50,254,50,254,50,254,50,254,50,254,50,
254,50,254,50,254,50,253,50,253,50,253,50,253,50,253,50,
254,42,30,51,30,51,30,51,254,42,254,42,30,51,30,51,
254,50,254,50,30,51,254,50,254,50,254,50,254,50,254,50,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,30,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,30,51,30,51,62,51,62,51,
30,51,30,51,30,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,63,51,62,51,62,51,62,51,
62,51,62,51,62,51,94,51,94,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
63,51,63,51,63,51,63,51,63,51,63,51,63,51,63,51,
94,51,62,51,62,51,62,51,94,51,94,51,94,51,62,51,
94,51,94,51,94,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,59,94,59,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
95,51,95,51,95,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,51,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,67,126,67,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,59,126,67,126,67,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,158,67,158,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,156,42,156,42,157,42,157,42,156,34,156,42,
156,34,156,42,188,42,188,42,157,42,157,42,157,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
158,42,189,42,219,42,218,42,217,42,186,42,187,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,221,42,221,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
190,42,221,42,220,42,252,42,252,50,28,51,26,51,248,50,
213,50,180,50,244,58,180,50,152,42,222,42,223,42,252,42,
221,42,221,42,221,42,222,42,222,50,222,50,222,50,254,50,
253,42,253,42,253,42,253,42,253,42,253,42,254,50,254,50,
253,42,253,42,253,42,254,50,254,50,254,50,254,50,254,50,
221,50,221,50,254,50,254,50,254,50,254,50,254,42,254,42,
254,50,253,50,253,50,253,50,253,50,253,50,253,50,254,50,
254,42,254,42,254,42,254,42,254,42,254,42,254,42,254,42,
254,42,254,42,30,51,30,51,254,42,254,42,30,51,30,51,
29,43,29,51,29,51,29,51,29,43,253,42,29,43,29,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
30,51,30,51,30,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,30,51,62,51,62,51,
30,51,30,51,30,51,30,51,30,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,62,59,62,59,94,59,94,59,62,59,62,59,
62,51,62,51,62,51,94,51,94,51,62,51,62,51,62,51,
62,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,59,94,59,94,51,94,51,94,59,94,59,94,59,94,51,
94,51,94,51,94,51,94,51,94,51,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,126,59,126,59,126,59,126,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
125,59,158,67,158,67,125,59,125,59,158,67,158,67,125,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,59,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
253,50,188,42,188,42,189,42,157,42,189,42,188,42,188,42,
188,42,188,42,188,42,188,42,157,42,157,42,157,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,220,42,219,42,218,42,217,42,217,42,217,50,218,50,
188,42,188,42,189,42,189,42,189,42,221,42,221,42,221,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
222,50,221,42,221,42,252,42,252,50,27,51,25,51,23,51,
21,59,211,50,210,50,147,42,152,42,222,50,254,42,28,43,
254,50,254,50,254,50,254,50,222,50,222,50,222,50,222,50,
253,42,254,50,254,50,254,50,254,50,254,50,254,50,254,50,
254,42,254,42,254,42,254,42,254,50,254,50,254,50,254,50,
254,50,221,50,254,50,254,50,254,50,254,50,30,51,30,51,
29,51,29,51,29,51,253,50,253,50,29,51,29,51,29,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,29,51,29,51,29,51,61,51,61,51,61,51,61,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
93,51,93,51,93,51,93,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,93,51,93,51,93,51,
94,51,62,51,62,51,62,51,94,51,94,51,94,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
93,59,93,59,93,59,93,59,93,59,93,51,93,51,93,51,
94,59,94,59,94,59,94,59,94,59,94,59,62,59,62,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,127,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,51,94,51,94,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
159,67,126,67,126,67,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,67,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
125,67,157,67,157,67,125,67,157,67,157,67,157,67,157,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
252,50,155,42,156,42,156,42,156,34,188,42,156,34,188,42,
188,34,188,34,156,34,156,34,156,34,156,34,156,34,156,34,
188,34,188,34,188,34,188,34,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,189,42,189,42,188,42,188,42,187,42,187,50,187,50,
186,42,187,42,188,42,188,42,189,42,189,42,189,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,252,50,25,51,247,50,
55,59,243,58,177,50,84,42,122,42,190,42,221,42,252,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,253,42,253,42,221,42,221,42,253,42,253,50,
253,42,253,42,253,42,253,42,253,50,253,50,253,50,253,50,
253,50,221,42,253,50,253,50,253,42,253,50,30,51,253,42,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,42,253,42,253,42,253,42,253,42,253,42,253,42,253,42,
29,43,29,43,253,42,29,43,29,43,30,43,30,43,29,43,
29,51,29,43,29,43,29,43,29,43,29,43,29,43,253,42,
30,43,29,43,29,43,29,43,29,43,30,43,30,43,30,51,
29,43,29,43,29,43,29,43,29,43,29,43,30,51,30,51,
30,51,30,43,30,43,29,43,29,43,30,43,30,43,30,51,
30,43,30,43,30,43,30,43,30,43,30,43,30,43,30,43,
30,51,30,51,29,51,29,51,29,51,30,51,30,51,30,51,
29,43,29,43,29,43,29,43,30,51,30,51,29,43,29,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,43,30,43,30,43,30,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,29,43,30,51,30,51,62,51,30,51,30,51,
30,51,62,51,62,51,62,51,30,51,30,51,30,51,62,51,
62,51,62,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,30,51,30,51,62,51,62,51,62,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
61,51,61,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,93,51,93,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,59,62,59,62,59,62,59,62,59,62,59,62,51,62,51,
94,59,62,59,62,59,62,59,94,59,94,59,62,59,62,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,62,59,62,51,62,59,94,59,94,59,
94,59,94,59,94,59,94,51,62,51,62,51,94,51,94,51,
94,59,94,51,62,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,94,59,94,51,94,51,94,59,126,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
93,59,93,59,93,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
93,59,94,59,94,59,126,59,126,59,94,59,94,59,93,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,125,59,125,59,125,59,
125,59,125,59,125,59,125,59,126,59,126,59,125,59,93,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
157,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
125,59,125,59,125,59,125,59,125,59,125,59,125,59,125,59,
125,67,125,67,125,59,125,59,125,59,125,59,125,67,125,67,
125,59,125,67,125,67,125,67,125,59,125,59,125,59,125,67,
125,67,125,67,125,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,156,42,156,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,189,42,189,42,188,42,156,34,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
251,42,251,42,220,42,221,42,188,50,219,50,218,50,218,50,
217,42,218,42,187,42,189,42,189,42,189,42,189,42,188,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
188,42,221,42,222,42,223,42,222,42,253,50,27,51,25,59,
247,58,20,67,210,58,182,58,189,50,191,50,254,42,29,43,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,42,253,50,253,50,253,50,253,50,253,42,253,50,253,50,
29,43,29,43,29,43,29,43,29,51,29,51,253,50,253,50,
30,51,253,50,29,51,30,51,253,50,29,51,30,51,29,43,
30,51,254,50,254,50,254,50,254,50,254,50,254,50,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,29,43,29,43,29,43,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,62,51,62,51,
62,51,30,51,30,51,29,43,29,43,30,51,30,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,62,51,62,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,30,51,62,51,62,51,62,51,30,51,30,51,
62,51,62,51,94,51,62,51,62,51,61,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,94,51,94,51,94,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,59,62,51,62,51,62,59,62,59,62,51,62,51,62,59,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,59,94,51,62,51,62,51,62,51,62,51,63,51,63,51,
62,51,62,51,94,51,94,51,94,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,94,51,94,51,94,51,94,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,94,51,94,51,94,51,
94,59,94,51,94,51,62,51,93,51,94,51,94,51,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
62,59,62,59,62,59,62,59,62,59,62,59,62,59,62,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,126,59,94,59,94,51,94,51,94,51,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,62,59,62,59,94,59,94,59,
94,59,126,59,126,59,94,59,94,59,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
93,59,126,59,126,59,126,59,126,59,126,59,126,59,93,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,67,126,67,126,67,126,67,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,158,67,158,67,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,125,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,158,67,126,59,126,59,126,59,126,59,158,67,158,67,
126,67,158,67,126,59,126,59,158,59,158,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
158,67,158,67,158,67,158,67,125,67,125,67,125,67,125,67,
157,67,125,67,125,67,125,67,158,67,126,67,126,59,125,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,126,59,126,59,158,67,158,67,126,59,126,59,158,67,
125,59,125,59,158,67,158,67,158,67,158,67,125,59,125,59,
158,67,158,67,158,67,158,67,158,67,125,59,125,59,158,67,
157,67,157,67,157,67,125,67,125,67,157,67,157,67,157,67,
125,67,125,67,157,67,157,67,157,67,157,67,157,67,157,67,
125,67,125,67,125,67,125,67,158,67,158,67,158,67,158,67,
253,50,188,42,156,42,156,42,188,42,189,42,188,34,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
156,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,220,42,250,42,250,42,249,50,217,42,216,50,215,50,
186,50,187,42,188,42,221,42,221,42,221,42,188,42,189,42,
221,42,189,42,189,42,189,42,189,42,189,42,189,42,221,42,
189,42,189,42,221,42,221,42,221,42,221,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,220,42,252,42,252,42,220,42,219,42,250,50,26,51,
84,67,50,67,14,75,17,75,218,58,222,50,254,42,30,43,
221,42,221,42,253,42,254,50,253,50,253,50,253,42,253,42,
253,42,253,42,253,42,253,42,254,50,254,50,254,50,253,42,
253,42,254,42,254,42,254,42,254,42,254,42,254,42,254,42,
30,51,253,42,253,42,253,42,253,42,30,51,30,51,30,51,
253,42,30,51,30,51,30,51,253,42,253,42,253,42,30,51,
253,42,253,42,253,42,253,42,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,29,51,29,51,29,51,29,51,30,51,30,51,30,51,
30,43,30,43,30,51,30,51,253,50,29,51,30,51,62,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,62,51,62,51,62,51,62,51,30,51,29,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,30,51,30,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,30,51,30,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,62,51,62,51,62,51,94,59,94,59,94,59,94,51,
62,51,62,51,94,51,94,59,94,59,94,51,62,51,62,51,
94,51,94,59,94,59,94,59,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,62,59,62,59,62,59,94,59,
94,51,94,51,94,51,62,51,62,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,51,94,51,94,59,94,59,94,59,94,51,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,67,158,67,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,59,94,59,94,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,59,126,59,158,67,158,67,126,67,126,59,126,67,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,59,126,67,126,67,126,59,126,59,126,67,126,67,126,59,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,125,67,125,59,125,67,158,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
125,59,125,67,158,67,158,67,158,67,125,67,125,67,158,67,
158,67,158,67,125,59,125,59,125,67,158,67,158,67,158,67,
126,67,158,67,158,67,126,67,126,67,158,67,158,67,126,67,
158,67,158,67,158,67,125,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,156,42,188,42,156,42,189,42,188,34,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
156,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,188,42,219,42,219,42,218,42,186,42,185,42,184,50,
216,50,185,50,187,42,188,42,221,42,221,42,221,42,222,50,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,221,42,221,42,221,42,221,42,221,42,221,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
222,50,221,50,253,50,253,42,221,42,188,42,187,42,217,42,
211,50,241,66,44,75,11,75,17,67,24,59,253,50,223,42,
253,42,253,42,253,42,253,42,253,42,253,42,253,50,253,50,
253,42,253,42,253,42,254,50,254,50,254,50,254,50,254,50,
254,42,254,42,254,42,254,42,254,42,254,42,254,42,254,42,
253,42,253,42,253,42,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,253,42,253,42,253,42,30,51,
253,42,253,42,30,51,30,51,30,51,30,51,30,51,30,51,
253,42,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,43,29,43,30,51,30,51,30,51,30,51,30,51,30,51,
30,43,30,43,30,51,30,51,253,50,29,51,30,51,30,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,30,51,62,51,62,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,30,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,94,51,94,51,94,59,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,59,94,59,94,59,94,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
62,59,94,59,94,59,94,59,62,59,62,59,62,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,59,94,59,94,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,67,158,67,
126,59,126,59,126,59,126,59,126,59,158,67,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,59,126,59,126,67,126,67,126,59,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,125,67,125,67,125,67,125,67,
125,67,125,67,158,67,158,67,158,67,158,67,125,67,125,67,
125,67,158,67,158,67,158,67,125,67,125,67,125,67,158,67,
158,67,158,67,125,59,125,59,125,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,125,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,188,42,188,42,156,42,188,42,188,34,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
190,42,189,42,188,42,188,42,188,42,187,42,186,42,185,50,
245,58,247,58,217,50,187,42,188,42,189,42,221,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
222,50,222,42,221,42,221,42,254,50,253,50,219,42,186,42,
151,50,207,58,234,74,10,75,237,74,242,58,249,50,253,50,
254,50,253,42,221,42,221,42,221,42,253,42,253,50,253,50,
253,42,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,42,253,42,253,42,253,42,253,42,30,51,30,51,30,51,
253,42,253,42,30,51,30,51,30,51,30,51,30,51,253,42,
30,51,253,42,253,42,253,42,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
253,42,253,42,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,43,30,43,30,51,61,51,29,51,29,51,30,51,30,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,30,51,30,51,30,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,30,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,59,94,51,62,51,62,51,62,51,62,51,94,51,94,59,
94,51,94,51,62,51,62,51,62,51,94,51,94,51,94,51,
93,51,93,51,94,51,94,51,94,51,94,51,93,51,93,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,51,94,51,62,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,51,62,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
62,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,126,59,126,59,126,59,126,59,158,67,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,125,67,125,67,158,67,158,67,125,67,125,67,
125,67,125,67,158,67,158,67,158,67,158,67,125,67,125,67,
125,67,158,67,158,67,158,67,125,67,125,67,158,67,158,67,
158,67,158,67,125,67,125,59,125,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,125,67,125,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,188,42,189,42,156,42,188,42,188,34,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,190,42,190,42,221,50,219,42,185,42,
211,50,244,58,214,58,217,50,188,50,222,42,222,42,221,42,
189,42,189,42,221,42,221,42,221,42,221,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,42,221,42,221,42,221,42,254,50,253,50,252,50,218,42,
251,58,210,58,203,66,169,66,139,66,82,50,153,42,219,42,
254,50,254,50,221,42,221,42,221,42,253,42,253,50,254,50,
253,50,253,50,253,50,253,50,253,42,253,42,253,50,254,50,
30,51,30,51,253,42,253,42,253,42,30,51,30,51,30,51,
253,42,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,253,42,253,42,253,42,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
253,42,253,42,30,51,30,51,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,29,51,
30,51,30,51,29,51,61,51,29,51,29,51,62,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,30,51,30,51,30,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,30,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,59,94,51,62,51,62,51,62,51,62,51,94,51,94,59,
94,59,94,51,94,51,62,51,62,51,94,51,94,51,94,51,
93,51,93,51,94,51,94,51,94,51,94,51,93,51,93,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
62,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,51,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,126,59,
126,59,126,59,126,59,126,59,126,59,158,67,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,59,126,59,126,67,126,67,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,125,67,125,67,158,67,158,67,125,67,125,59,
125,67,125,67,158,67,158,67,158,67,158,67,125,67,125,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,125,67,125,67,158,67,158,67,125,67,125,67,158,67,
158,67,158,67,158,67,125,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,188,42,189,42,156,42,188,42,188,34,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,222,42,222,42,221,42,219,50,217,42,
180,50,211,50,242,58,213,50,186,50,190,50,190,42,220,42,
189,42,189,42,221,42,221,42,221,42,221,42,189,42,189,42,
221,42,221,42,221,42,189,42,189,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,253,50,253,50,253,42,253,42,253,50,27,51,250,50,
248,42,181,42,112,50,106,50,104,50,145,58,188,50,191,42,
254,50,253,42,253,42,253,42,253,42,253,50,253,50,253,50,
253,42,253,42,253,42,253,42,253,42,253,42,253,42,30,51,
30,51,30,51,30,51,253,42,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,253,42,253,42,253,42,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
253,42,30,51,30,51,30,51,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,30,51,29,51,61,51,
30,51,29,51,29,51,29,51,29,51,29,51,61,51,29,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,62,51,
62,51,62,51,30,51,62,51,62,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,94,51,94,51,94,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,59,94,59,94,51,94,51,62,51,94,51,94,51,94,59,
93,51,93,51,94,51,94,51,94,51,94,51,93,51,93,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
62,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,94,59,94,59,94,59,126,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,125,67,125,67,158,67,158,67,125,67,125,59,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,158,67,158,67,125,67,125,67,125,67,158,67,158,67,
158,67,125,67,125,67,158,67,158,67,125,67,125,67,158,67,
125,67,125,67,125,67,125,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,188,42,189,42,188,42,189,42,188,34,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,42,188,42,188,42,189,42,189,42,220,42,219,42,249,50,
215,58,243,58,241,58,210,58,151,50,155,50,189,42,220,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,189,42,189,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,253,50,253,50,
253,50,29,51,29,43,253,42,253,42,252,42,251,50,26,51,
55,51,215,42,151,50,146,58,170,58,234,58,212,50,189,50,
253,42,253,42,254,50,254,50,253,50,253,50,253,50,253,50,
253,42,253,42,253,42,253,42,253,42,253,42,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,253,42,253,42,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,61,51,61,51,92,51,
61,51,29,51,29,51,29,51,29,51,61,51,61,51,60,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,62,51,62,51,62,51,62,51,30,51,29,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,59,94,59,
93,51,93,51,94,51,94,51,94,51,94,51,93,51,93,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,51,94,51,62,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,59,94,59,94,59,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,67,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,125,67,125,67,158,67,158,67,125,67,125,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,158,67,125,67,125,67,158,67,158,67,158,67,125,67,
125,67,158,67,158,67,158,67,125,67,125,67,125,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,125,67,125,67,125,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,188,42,189,42,188,42,189,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
189,50,189,42,188,42,188,42,189,42,188,42,219,42,218,50,
216,50,213,50,210,58,209,58,179,58,183,50,187,50,222,50,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,253,50,253,50,253,50,
221,42,253,42,253,42,253,42,253,42,253,42,252,50,27,51,
25,51,183,42,183,50,181,58,175,58,170,58,238,58,248,58,
253,42,254,50,254,50,254,50,253,50,253,50,253,50,253,50,
29,43,29,43,29,43,29,43,29,51,29,51,29,51,29,43,
29,43,29,43,29,51,29,51,29,51,29,51,29,51,29,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,30,51,30,51,30,51,30,51,61,51,60,51,60,51,
59,59,28,51,29,51,30,51,30,51,61,51,60,51,59,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,62,51,62,51,62,51,30,51,29,51,
62,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,94,51,94,51,94,51,
94,59,94,51,94,51,94,51,62,51,62,51,62,51,62,51,
94,59,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,94,51,94,51,94,59,94,51,94,51,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,158,67,158,67,126,59,126,59,158,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
158,67,126,59,126,59,126,59,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,59,126,59,126,67,126,67,126,67,126,67,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,67,126,67,126,59,126,59,126,67,
158,67,158,67,158,67,158,67,125,67,125,67,125,67,125,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,125,67,125,67,125,67,125,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,125,67,125,67,125,67,158,67,158,67,158,67,125,67,
125,67,158,67,158,67,158,67,125,67,125,67,125,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
158,67,158,67,158,67,158,67,125,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
253,50,188,42,188,42,188,42,189,42,189,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,221,42,221,42,
189,42,189,42,221,42,221,42,221,42,189,42,220,42,219,42,
249,50,215,58,211,58,209,58,209,58,180,50,186,50,190,42,
221,42,221,42,221,42,189,42,189,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,253,50,253,50,253,50,253,50,
222,50,221,42,253,42,254,42,254,42,222,42,220,42,219,42,
217,50,184,50,243,50,238,50,46,50,242,49,115,58,180,58,
254,50,254,50,253,42,253,42,253,50,253,50,253,50,253,50,
29,43,29,43,29,43,29,51,30,51,30,51,29,51,29,43,
253,42,29,43,29,51,29,51,29,51,29,51,29,51,29,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,253,42,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,29,51,30,51,30,51,30,51,61,51,27,51,27,51,
59,59,27,51,29,51,30,51,30,51,61,51,59,51,58,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,62,51,62,51,30,51,
62,51,62,51,30,51,62,51,62,51,62,51,30,51,30,51,
62,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,94,51,94,51,94,59,
62,51,62,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,62,51,94,51,94,59,94,59,94,59,94,59,94,59,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,62,51,62,51,62,51,94,59,94,59,94,59,94,51,
94,59,94,59,94,51,62,51,62,51,94,51,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,158,67,158,67,126,59,126,59,158,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
158,67,126,59,126,59,126,59,126,59,158,67,158,67,158,67,
158,67,126,59,126,59,126,59,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,59,126,59,126,67,126,67,126,59,126,67,158,67,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,67,126,59,126,59,126,67,126,67,126,59,126,59,126,67,
158,67,158,67,158,67,158,67,125,67,125,67,125,67,125,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,125,67,125,59,125,67,158,67,
125,67,125,67,158,67,158,67,158,67,158,67,125,67,125,67,
158,67,125,67,125,67,158,67,158,67,158,67,125,67,125,59,
125,67,158,67,158,67,158,67,125,67,125,67,125,67,158,67,
125,67,157,67,157,67,125,67,125,67,157,67,157,67,125,67,
158,67,158,67,158,67,158,67,125,67,125,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,189,42,189,42,188,42,188,42,188,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,221,42,
189,42,221,42,221,42,221,42,189,42,189,42,189,42,189,42,
249,42,245,42,18,51,206,58,171,58,176,58,119,42,189,42,
190,42,221,42,221,42,222,50,222,50,252,50,253,42,223,42,
253,50,221,42,221,42,221,42,221,42,253,50,221,42,221,42,
253,42,221,42,221,42,221,42,221,50,221,50,222,50,222,50,
220,42,221,50,222,50,254,50,29,51,29,43,253,42,221,34,
155,42,180,50,206,58,174,50,113,42,147,42,181,50,215,66,
213,50,223,58,29,51,255,50,253,42,30,51,223,42,252,50,
30,51,30,51,253,42,253,42,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,62,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,29,51,29,51,62,51,
30,51,30,51,30,51,29,51,29,51,61,51,61,51,61,51,
89,51,189,50,221,58,221,50,29,51,62,51,94,51,55,43,
58,43,93,51,62,51,31,51,31,51,30,43,63,51,93,43,
60,51,60,51,30,51,31,51,60,51,60,43,31,43,62,43,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,59,94,51,94,51,62,51,62,51,94,51,94,51,94,59,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,59,94,59,94,59,94,51,94,51,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,51,94,51,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,94,59,94,59,94,59,126,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
93,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,126,67,126,67,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,59,126,59,126,67,126,67,126,59,126,59,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,125,67,125,67,125,59,125,59,125,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,125,67,125,67,158,67,
158,67,158,67,125,67,125,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,125,67,125,67,
29,51,188,42,189,42,189,42,188,42,188,42,188,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,189,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,220,42,220,42,
254,50,248,42,211,50,112,50,79,50,78,42,51,34,189,50,
222,42,221,42,253,50,221,50,221,42,221,42,221,42,221,42,
253,50,221,42,221,42,221,42,253,50,253,50,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,50,221,50,221,50,
254,50,221,42,252,42,221,42,254,50,254,50,29,51,28,51,
31,51,27,51,243,50,173,50,142,66,179,74,212,66,242,50,
244,50,251,50,222,50,30,51,253,42,28,43,254,42,253,50,
30,51,30,51,253,42,30,51,30,51,30,51,30,51,253,42,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,29,51,29,51,62,51,
30,51,30,51,30,51,30,51,29,51,29,51,29,51,61,51,
120,59,56,59,58,59,252,50,30,51,61,51,89,59,21,51,
246,42,60,59,255,50,28,51,90,51,31,51,30,51,60,51,
61,51,93,51,63,51,31,51,61,51,61,51,31,51,31,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,94,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,62,51,62,51,94,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,51,62,51,62,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,59,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,51,94,51,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,94,59,94,59,94,59,126,59,126,59,126,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
93,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,94,59,94,59,126,59,126,67,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,158,67,158,67,158,67,158,67,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,59,126,67,126,67,126,67,126,67,126,59,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,158,67,158,67,158,67,125,67,125,67,158,67,
157,67,158,67,125,67,125,67,125,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,125,67,125,67,
29,51,188,42,189,42,189,42,188,42,188,42,188,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,188,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
220,42,220,42,220,42,220,42,252,42,251,42,251,42,251,42,
252,50,251,50,214,50,177,50,177,66,145,58,51,42,155,50,
252,42,253,42,221,42,253,42,221,42,221,42,221,42,220,42,
221,42,221,42,221,42,221,42,253,50,253,50,253,50,253,50,
221,42,221,42,221,42,221,42,253,42,253,42,253,42,253,42,
31,51,253,42,253,42,253,42,254,50,253,50,252,42,251,42,
25,43,252,50,220,50,182,42,144,50,175,58,177,58,211,50,
242,50,214,50,157,42,29,51,253,42,59,51,62,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
253,42,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,62,51,62,51,62,51,
62,51,62,51,62,51,30,51,30,51,30,51,30,51,30,51,
27,59,56,59,58,59,26,51,61,51,28,51,52,59,207,50,
210,50,60,67,31,59,29,51,92,59,59,51,28,51,28,59,
31,51,92,59,94,51,31,51,61,43,63,51,31,59,60,59,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,94,51,94,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,94,51,94,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,94,51,94,51,94,51,94,51,94,51,94,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,62,51,62,51,62,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,59,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,94,59,126,59,126,59,94,59,
94,59,94,59,126,59,126,67,126,67,126,67,126,59,126,59,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,158,67,158,67,158,67,158,67,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,158,67,158,67,158,67,125,67,125,67,158,67,158,67,
157,67,157,67,157,67,125,67,125,67,158,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,125,67,125,67,
29,51,188,42,189,42,189,42,188,42,188,42,188,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,189,42,188,42,188,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,220,42,220,42,219,42,219,42,219,42,219,42,
251,42,26,51,22,59,177,50,176,58,208,66,211,58,248,58,
26,51,221,42,190,42,221,42,253,42,253,50,222,42,220,42,
222,42,221,42,221,42,221,42,253,50,253,50,253,50,252,50,
253,50,253,50,253,50,253,42,253,42,253,42,253,42,254,42,
253,42,253,42,254,42,254,50,253,50,28,51,251,50,220,50,
123,34,119,42,149,50,182,50,152,42,119,34,181,50,20,67,
242,58,245,58,186,42,253,50,254,50,251,42,30,51,253,50,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
253,42,253,42,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,30,51,30,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,30,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,30,51,30,51,30,51,30,51,
58,59,87,59,86,67,54,59,27,51,255,58,27,59,181,42,
206,42,252,58,30,59,60,51,61,51,28,51,251,50,249,50,
249,58,28,59,93,59,93,51,31,43,63,51,60,51,28,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,30,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,94,51,94,51,94,59,94,59,94,51,94,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,59,94,59,94,59,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,94,59,126,59,126,67,126,67,126,67,126,59,94,59,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,67,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,158,67,126,67,126,67,158,67,126,67,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,125,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,125,67,125,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,189,42,189,42,188,42,188,42,188,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
188,42,188,42,188,42,189,42,189,42,188,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,221,42,221,42,220,42,188,42,187,42,187,42,
186,34,220,42,249,50,177,50,107,50,142,58,177,58,16,59,
246,50,219,50,191,42,222,42,253,42,253,42,222,42,222,42,
222,42,222,42,221,42,221,42,253,50,253,50,253,50,252,50,
28,51,252,50,252,50,252,50,253,42,253,42,253,42,254,42,
252,42,253,42,254,42,253,42,252,42,251,50,27,51,28,51,
30,43,185,42,147,50,178,58,214,58,248,58,24,59,55,59,
209,58,246,58,213,50,220,50,31,51,253,42,223,42,253,50,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,30,51,30,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,29,51,29,51,29,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,30,51,30,51,30,51,
93,51,57,51,50,59,18,59,215,50,29,59,95,59,27,43,
178,42,247,50,60,59,91,59,28,43,254,50,59,51,25,43,
178,58,246,58,91,67,61,59,61,51,93,51,62,43,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,94,51,94,51,94,59,94,59,94,51,94,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
62,51,94,59,94,59,94,59,94,51,62,51,94,51,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,126,59,126,59,126,59,126,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,126,59,126,67,126,67,126,67,126,59,94,59,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,158,67,158,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,158,67,158,67,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,67,158,67,126,67,126,67,158,67,126,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,125,67,125,67,158,67,158,67,158,67,
125,67,125,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,125,67,125,67,125,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,189,42,189,42,188,42,188,42,188,42,189,42,
188,42,188,42,188,42,188,42,188,42,188,42,188,42,188,42,
221,42,221,42,221,42,188,42,189,42,189,42,189,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
222,42,221,42,221,42,221,42,221,42,221,42,220,42,220,42,
190,42,184,34,183,42,180,50,141,58,139,58,174,58,176,58,
178,50,216,50,221,50,254,50,253,42,220,42,222,42,223,50,
221,42,221,42,221,50,253,50,253,50,253,50,253,50,253,50,
28,51,252,50,28,51,252,50,252,50,252,50,253,50,253,50,
254,50,29,51,28,51,252,50,253,50,253,50,252,50,27,51,
56,51,57,51,26,51,215,50,178,58,238,66,16,75,19,67,
176,50,183,58,19,51,185,42,31,59,31,51,255,42,61,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,62,51,62,51,62,51,
61,51,61,51,29,51,29,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,23,51,15,59,16,67,211,58,53,59,91,51,28,43,
186,42,20,51,118,59,89,59,24,43,28,51,95,59,59,43,
210,58,17,59,117,67,88,59,28,51,31,51,255,42,61,43,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,62,51,62,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,59,94,59,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
62,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,51,94,51,94,51,94,59,
94,51,94,59,94,59,94,59,94,59,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,67,126,67,126,67,126,59,126,59,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,158,67,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,125,67,125,67,125,67,125,67,158,67,158,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,125,67,125,67,125,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,189,42,189,42,189,42,188,42,188,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
220,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,42,189,42,189,42,189,42,189,42,189,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,253,50,253,50,
60,51,251,42,183,42,177,50,173,58,173,66,175,66,208,66,
177,58,211,58,248,58,252,50,221,42,221,42,221,42,254,50,
221,42,253,50,253,50,253,50,253,50,221,42,253,50,253,50,
253,50,252,50,252,50,252,50,27,51,27,51,27,51,27,51,
220,50,220,42,251,50,252,50,253,50,29,51,28,51,59,51,
152,42,54,51,117,51,21,51,115,42,111,50,204,66,43,75,
207,58,182,58,53,59,213,42,253,50,31,51,253,42,29,43,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,30,51,30,51,62,51,62,51,62,51,62,51,
61,51,61,51,61,51,61,51,29,51,30,51,62,51,62,51,
62,51,62,51,62,51,61,51,61,51,61,51,61,51,61,51,
63,51,24,51,242,58,241,66,15,59,46,59,239,50,211,50,
184,50,216,50,51,59,18,59,211,42,219,50,31,59,58,43,
182,50,182,50,48,59,49,59,252,58,63,67,92,51,127,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
62,51,94,51,94,51,94,51,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,158,67,126,59,126,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,158,67,158,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,125,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,125,67,125,67,158,67,158,67,158,67,158,67,
28,51,188,42,189,42,189,42,189,42,220,42,188,42,189,42,
189,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
220,42,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,42,189,42,221,42,189,42,189,42,189,42,221,42,221,42,
220,42,220,42,220,42,220,42,220,42,252,42,221,42,221,42,
187,34,254,50,25,59,16,59,204,58,171,66,171,58,204,66,
176,66,240,58,243,58,250,50,254,50,254,42,252,42,220,42,
221,42,253,50,253,50,253,50,221,42,221,42,221,50,254,50,
222,42,253,50,253,50,252,50,27,51,26,59,58,59,57,59,
27,59,252,50,188,42,187,42,219,42,27,43,28,43,28,43,
60,59,248,58,209,58,236,58,173,50,113,42,112,50,173,50,
206,66,181,58,55,67,241,42,219,42,62,51,60,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,62,51,30,51,30,51,30,51,30,51,62,51,
30,51,30,51,30,51,62,51,62,51,62,51,62,51,62,51,
61,51,61,51,61,51,61,51,29,51,30,51,30,51,62,51,
62,51,62,51,62,51,61,51,61,51,61,51,93,51,93,51,
121,51,86,59,147,50,176,58,205,58,141,50,11,42,48,50,
182,42,215,58,210,58,205,50,148,50,188,50,92,59,93,59,
30,59,217,50,245,58,242,58,20,59,88,67,27,51,61,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,59,94,59,94,59,94,51,62,51,62,51,
94,51,94,59,94,59,94,51,62,51,62,51,94,51,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,59,94,59,94,59,94,59,62,51,62,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,67,126,67,126,67,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,59,126,59,126,67,126,67,158,67,
158,67,126,67,126,67,158,67,158,67,126,67,126,67,158,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,125,67,125,67,125,67,158,67,158,67,158,67,
29,51,188,42,188,42,188,42,188,42,189,42,188,42,188,42,
188,42,188,42,188,42,188,42,188,42,188,42,189,42,221,42,
189,42,189,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,50,252,50,253,50,221,42,221,50,221,50,221,50,188,42,
220,42,122,34,154,42,216,50,244,58,174,58,75,50,75,58,
105,50,42,50,12,50,113,50,216,50,253,42,254,42,253,34,
253,50,252,50,252,42,221,42,223,42,254,50,253,50,252,42,
222,42,253,42,28,51,27,59,26,59,24,59,21,59,243,58,
247,50,250,50,252,50,27,51,24,43,149,34,83,34,84,42,
216,50,58,67,246,58,172,42,141,50,206,58,208,66,242,66,
14,83,51,67,22,43,243,58,181,66,189,58,30,51,92,43,
30,51,30,51,62,51,30,51,30,51,30,51,30,51,30,51,
62,51,30,51,29,51,30,51,30,51,62,51,62,51,30,51,
30,51,30,51,30,51,62,51,62,51,30,51,30,51,30,51,
30,51,30,51,62,51,62,51,62,51,30,51,30,51,62,51,
62,51,62,51,62,51,30,51,30,51,62,51,62,51,62,51,
61,51,92,51,58,51,59,51,28,51,62,51,62,51,62,43,
61,43,62,43,31,51,62,51,61,51,62,51,61,51,91,51,
125,59,244,50,174,58,41,42,72,34,242,58,183,58,113,50,
183,58,250,42,212,42,139,50,141,66,248,58,62,59,61,67,
125,51,56,51,52,67,46,75,11,67,14,67,243,50,248,42,
63,51,61,43,62,43,63,51,61,51,29,59,31,51,61,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,94,51,94,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,94,51,94,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,59,94,59,94,51,94,51,62,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,51,94,59,94,59,94,59,94,59,94,51,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,59,94,59,94,59,
94,59,94,51,94,51,94,59,94,59,94,51,94,51,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,51,94,59,94,51,94,59,126,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,67,126,67,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,94,59,94,59,94,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,67,126,59,126,59,126,59,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,158,67,158,67,158,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,125,67,125,59,125,59,
29,51,188,42,188,42,188,42,188,42,189,42,188,42,188,42,
189,42,189,42,189,42,189,42,189,42,221,42,221,42,221,42,
189,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,50,27,51,26,51,249,42,219,42,252,50,252,50,250,50,
251,42,188,42,186,42,183,42,182,42,180,58,141,50,136,58,
40,42,42,50,76,50,112,50,182,50,221,42,254,42,253,34,
222,42,221,42,252,42,221,42,222,42,254,50,254,50,253,42,
222,42,253,42,253,50,252,50,251,50,250,50,247,50,245,50,
216,50,250,58,251,50,26,51,25,51,25,51,185,50,120,50,
216,50,243,50,243,58,145,58,109,58,170,66,205,66,206,74,
237,74,241,58,242,50,209,58,211,58,217,50,31,51,31,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,62,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,62,51,62,51,62,51,30,51,30,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
61,51,61,51,60,51,28,51,60,51,60,51,61,51,62,43,
93,51,62,51,62,51,61,51,61,51,30,51,29,51,60,51,
54,59,50,59,208,58,41,34,38,34,173,58,210,58,242,50,
143,50,247,50,213,42,106,50,106,50,150,42,60,51,87,59,
93,59,249,50,208,50,237,66,237,66,206,58,148,50,148,42,
59,59,94,59,95,51,61,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,51,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,126,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,158,67,158,67,126,67,126,67,158,67,
126,67,126,67,158,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,158,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,125,67,125,67,125,67,
29,51,188,42,188,42,189,42,188,42,189,42,188,42,188,42,
188,42,189,42,189,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,42,220,42,217,42,185,42,186,42,188,42,221,50,220,50,
189,42,250,42,27,51,186,42,213,42,17,59,142,50,42,42,
42,42,139,58,205,66,143,58,116,42,187,42,254,50,253,42,
254,42,254,42,253,42,252,42,253,50,254,50,254,50,253,50,
253,50,254,50,254,42,254,42,254,42,29,51,26,51,24,59,
246,58,22,59,58,59,28,59,250,50,247,50,247,50,248,58,
153,42,86,34,114,42,143,50,76,50,43,50,104,58,168,66,
206,66,210,58,208,50,177,58,179,50,183,34,222,42,254,50,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,62,51,62,51,62,51,30,51,30,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,31,51,29,51,28,51,59,51,60,51,30,51,
61,51,62,51,62,51,61,51,61,51,30,51,30,51,61,51,
243,50,173,42,206,58,79,50,204,41,137,50,202,50,108,34,
11,34,209,50,147,42,15,42,239,41,88,34,252,42,22,43,
248,50,25,59,181,58,205,58,235,66,238,66,16,75,207,66,
179,50,27,59,94,51,93,43,95,51,62,51,29,51,95,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,51,62,51,62,51,94,51,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,158,67,158,67,126,67,126,67,158,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,59,126,67,126,67,158,67,158,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,188,42,189,42,188,42,189,42,188,42,188,42,
188,42,188,42,189,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
220,42,220,42,220,42,218,42,217,42,249,42,250,50,251,50,
187,42,221,50,26,51,22,51,245,50,210,58,140,50,10,34,
10,42,107,58,170,58,75,42,49,42,185,50,30,59,29,51,
29,43,30,51,29,51,28,51,28,51,28,51,28,51,27,51,
253,50,253,50,254,42,255,42,255,42,30,43,27,51,25,51,
244,50,242,50,244,50,24,59,219,50,219,50,248,58,53,51,
56,59,24,59,212,50,149,42,146,42,48,34,75,42,172,66,
14,75,211,66,212,58,244,58,245,58,216,50,253,50,30,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,30,51,30,51,30,51,30,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,30,51,30,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,63,51,63,51,30,51,28,51,60,51,60,51,29,51,
61,51,63,51,63,51,93,51,61,51,62,51,62,51,61,51,
25,51,80,34,107,50,78,58,16,42,140,42,135,42,199,33,
234,41,236,50,206,50,143,58,80,50,185,50,95,59,25,43,
52,59,117,67,245,58,177,50,205,58,235,66,9,67,170,66,
141,50,215,58,62,59,63,51,63,51,63,51,62,51,62,43,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,51,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,59,94,59,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,126,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,126,67,126,59,126,59,
126,59,126,59,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,158,67,158,67,126,67,126,67,158,67,
158,67,126,67,126,59,126,59,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,125,67,125,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,188,42,189,42,188,42,189,42,188,42,221,42,
188,42,188,42,189,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
222,42,222,42,222,42,221,42,218,42,249,50,24,51,25,51,
248,50,217,50,187,50,184,50,209,50,173,50,140,58,170,58,
74,50,106,58,105,50,40,42,13,42,182,58,28,59,28,51,
27,51,253,50,254,50,253,50,28,51,29,51,60,51,90,51,
58,59,58,51,27,51,29,43,30,43,254,42,253,42,251,42,
151,42,185,50,216,50,213,50,213,50,248,50,24,59,244,42,
14,59,242,58,150,50,89,34,179,34,149,42,177,58,11,83,
169,66,177,66,183,50,53,59,50,67,213,66,26,59,63,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
29,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
62,51,62,51,30,51,30,51,30,51,30,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,61,51,61,51,29,51,29,51,28,51,60,51,
29,51,63,59,63,51,93,51,61,51,94,51,93,59,92,59,
220,34,120,42,45,42,103,50,235,66,173,58,232,41,166,41,
169,33,75,42,141,50,170,58,73,42,117,42,63,67,60,51,
22,59,242,50,208,42,149,42,213,58,44,67,201,58,170,66,
203,66,242,66,60,67,63,59,62,51,63,51,95,51,61,43,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,51,62,51,62,51,62,51,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,51,94,51,94,51,94,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,94,59,94,59,126,59,126,59,126,59,126,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,67,126,67,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,67,126,59,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,126,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,188,42,189,42,188,42,189,42,188,42,221,42,
188,42,189,42,189,42,189,42,189,42,189,42,189,42,189,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,189,50,220,50,219,50,250,50,
220,50,185,50,180,42,180,50,115,42,46,42,170,58,11,75,
170,66,138,58,137,58,104,58,108,58,211,58,57,59,58,51,
24,51,252,58,254,50,253,50,253,50,254,50,253,50,27,51,
56,51,55,51,56,51,58,51,28,51,30,51,254,50,30,51,
187,50,218,50,216,50,182,50,148,42,179,42,212,42,213,42,
112,58,171,58,238,66,214,66,212,50,145,42,76,50,230,49,
230,49,112,58,218,58,85,59,11,59,139,50,210,58,61,51,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,30,51,62,51,30,51,30,51,30,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,61,51,60,51,61,51,62,51,61,51,60,51,58,59,
28,59,62,59,63,51,62,51,61,43,61,51,60,51,58,51,
91,59,250,58,113,42,72,34,136,58,168,66,72,58,73,50,
233,41,234,33,78,50,108,50,40,34,110,50,88,67,88,59,
150,50,117,42,181,42,149,42,210,50,14,67,204,58,204,74,
169,66,172,58,22,67,61,67,92,59,93,59,127,59,93,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,94,51,94,51,94,51,
62,51,62,51,62,51,62,51,62,51,94,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,126,67,
126,67,126,67,126,67,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,158,67,158,67,126,67,126,67,126,59,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,126,67,
126,59,126,67,158,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,188,42,189,42,189,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,189,42,189,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
27,43,27,43,26,51,27,51,251,50,251,50,251,50,251,50,
188,50,219,50,185,42,213,42,111,34,204,25,12,42,138,58,
136,58,72,50,105,58,168,58,105,58,142,58,245,58,89,59,
19,59,248,58,27,59,27,59,27,51,254,50,222,42,252,42,
250,42,248,42,247,50,23,51,25,59,251,50,28,51,28,51,
61,51,22,43,210,42,180,42,184,50,151,42,183,42,218,42,
117,42,44,42,72,50,169,58,110,50,80,42,80,50,109,58,
105,58,207,66,53,75,53,67,205,50,104,50,142,50,216,50,
30,51,30,51,30,51,30,51,30,51,30,51,30,51,30,51,
30,51,30,51,62,51,62,51,30,51,30,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,61,51,94,51,93,51,60,51,58,51,89,59,
25,51,60,59,94,51,62,51,62,43,62,51,61,51,58,51,
21,59,144,42,78,34,16,42,237,41,7,42,68,42,230,33,
39,50,39,42,139,50,109,50,11,42,107,50,237,58,47,59,
242,66,22,75,25,75,241,58,204,50,174,58,236,66,235,74,
104,66,136,50,206,58,53,67,56,67,89,59,91,59,95,51,
94,51,62,51,62,51,62,51,94,51,94,51,62,51,62,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,94,51,94,51,94,51,
62,51,62,51,94,51,62,51,62,51,94,51,94,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,94,59,94,59,94,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,67,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,59,126,59,94,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,67,126,67,158,67,158,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,59,
126,59,126,59,158,67,158,67,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,158,67,158,67,126,67,126,67,158,67,158,67,126,67,
126,67,126,67,158,67,158,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,158,67,158,67,158,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,158,67,158,67,158,67,158,67,158,67,126,67,126,67,
126,59,126,67,158,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,188,42,188,42,189,42,189,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
222,42,222,42,221,42,251,42,24,51,23,51,248,50,218,50,
253,50,30,51,252,50,185,42,18,26,139,17,169,25,201,41,
70,50,39,42,105,58,168,66,71,58,42,42,178,50,88,51,
15,59,244,58,23,67,87,59,88,59,60,51,30,51,29,43,
255,50,252,50,249,58,23,59,23,67,24,59,57,51,57,51,
63,51,31,51,219,50,180,42,211,50,215,50,188,50,255,58,
29,43,178,42,15,50,139,66,202,66,107,42,82,42,17,67,
140,83,74,83,235,66,179,50,180,50,142,58,82,58,22,42,
62,51,62,51,62,51,30,51,30,51,30,51,30,51,62,51,
30,51,62,51,62,51,62,51,30,51,30,51,62,51,62,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,30,51,
30,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
93,51,62,51,31,51,62,51,92,51,90,51,88,59,56,59,
55,51,58,59,93,59,62,51,63,51,95,51,94,59,91,59,
211,50,108,42,234,33,242,49,52,42,12,26,229,25,5,34,
201,33,43,42,236,66,172,58,13,50,238,49,45,42,204,50,
233,58,235,58,171,50,139,50,74,42,73,42,171,66,201,66,
169,74,168,66,200,58,14,59,20,59,244,50,24,43,95,51,
94,51,62,51,62,51,62,51,94,51,94,51,94,51,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,62,51,62,51,
94,51,94,51,94,51,62,51,62,51,62,51,62,51,62,51,
62,51,94,51,94,51,62,51,62,51,94,51,94,59,94,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,62,51,62,51,62,51,62,51,94,51,94,51,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,51,62,51,62,51,94,51,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,94,59,
94,51,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,126,51,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,127,59,
94,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,59,94,59,94,59,94,59,126,59,126,67,
126,67,126,67,126,67,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,67,126,67,126,59,94,59,94,59,94,59,
126,67,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,67,126,67,158,67,158,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,158,67,158,67,126,59,126,59,126,59,158,67,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,158,67,158,67,126,67,126,67,158,67,158,67,126,67,
126,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,126,67,126,67,126,67,
125,59,126,67,158,67,158,67,158,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,59,220,42,188,42,189,42,189,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,252,42,252,42,
253,42,189,34,254,42,253,42,220,42,26,43,26,51,253,50,
222,42,252,42,254,42,223,42,252,42,252,50,248,50,47,51,
82,59,250,50,254,50,30,51,221,50,85,34,11,34,39,42,
39,50,39,50,39,50,104,58,72,50,41,42,142,58,242,74,
207,58,107,42,180,58,26,75,19,59,85,67,60,67,252,50,
29,43,30,51,253,50,24,59,17,51,180,50,153,58,212,58,
118,67,86,59,252,50,29,59,24,51,55,59,249,58,254,66,
95,35,61,51,248,58,242,66,12,67,168,50,109,42,213,58,
142,50,234,58,232,58,206,66,212,66,211,58,181,50,157,50,
60,51,62,51,31,51,31,51,29,51,61,51,62,51,31,43,
62,51,62,51,30,51,30,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
29,51,62,51,62,51,93,51,92,51,92,51,61,51,31,51,
94,51,62,51,62,51,62,51,62,51,62,51,62,51,61,51,
61,51,95,51,126,51,61,43,94,51,91,59,20,51,242,58,
17,67,241,58,24,59,63,51,63,43,126,43,127,51,30,51,
220,42,52,59,169,50,164,25,199,33,9,42,166,25,133,25,
135,41,199,41,105,50,207,58,84,50,244,33,50,42,115,50,
78,58,105,58,105,50,42,34,234,33,11,34,77,50,205,66,
169,66,138,66,108,66,234,66,209,58,220,58,217,50,29,51,
93,51,62,51,63,59,63,59,61,59,93,59,93,59,62,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,62,51,62,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
62,51,62,51,94,51,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,51,94,51,62,51,
94,59,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,51,94,59,94,59,94,51,62,51,62,51,94,59,94,59,
94,51,94,59,94,59,94,59,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,94,59,94,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,94,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,67,158,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
94,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,59,94,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,126,67,126,67,158,67,158,67,158,67,
126,67,126,67,126,67,158,67,158,67,158,67,157,67,157,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,125,67,158,67,158,67,158,67,158,67,158,67,158,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,158,67,158,67,158,67,157,67,157,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
158,67,157,67,157,67,157,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,59,220,42,188,42,189,42,189,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
190,42,220,42,252,42,221,42,252,50,250,50,185,42,216,50,
254,50,251,42,252,42,222,42,220,42,220,50,250,50,243,50,
205,66,177,58,218,50,253,50,28,43,27,51,181,50,9,34,
165,33,6,42,5,42,38,50,40,50,74,50,173,58,207,66,
241,66,203,50,240,58,55,75,18,59,18,51,217,50,254,58,
250,50,30,51,30,43,26,51,212,58,143,50,17,59,118,59,
241,58,175,50,244,58,118,75,51,59,84,67,82,59,49,59,
91,51,62,51,27,51,242,50,107,50,41,50,73,58,171,66,
84,58,239,66,202,58,170,58,203,58,206,50,213,58,251,66,
61,43,62,43,30,51,30,43,29,43,29,43,62,51,94,51,
62,51,62,51,62,51,30,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
61,51,62,51,62,51,61,51,92,51,92,51,61,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
63,51,62,51,94,51,61,43,31,43,95,59,23,59,239,50,
141,50,141,50,212,58,59,59,93,51,93,51,94,51,93,59,
94,59,55,59,206,50,72,42,7,34,198,33,101,25,68,17,
231,41,6,42,102,50,170,50,176,50,148,50,181,50,244,58,
238,66,203,58,171,58,76,50,45,50,78,50,112,58,178,66,
236,74,169,58,42,50,104,50,140,50,24,67,89,67,120,59,
127,67,94,59,94,59,94,59,95,51,95,59,94,59,61,51,
62,51,62,51,62,51,62,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
62,51,94,51,94,51,94,59,94,59,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,51,94,51,94,51,
94,59,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,51,94,59,94,59,94,51,94,51,94,51,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,94,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,126,67,126,59,
126,67,126,67,126,67,158,67,158,67,158,67,157,67,157,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
125,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,157,67,158,67,158,67,157,67,157,67,157,67,
158,67,157,67,157,67,157,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,59,220,42,189,42,189,42,189,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
189,50,221,50,190,50,190,50,27,51,247,50,182,42,183,50,
156,42,252,42,29,51,253,42,252,42,251,50,250,50,23,59,
145,74,208,66,51,67,84,59,51,51,23,59,182,50,76,34,
133,25,197,25,196,33,6,42,73,50,140,66,204,66,171,58,
239,58,207,58,237,58,15,67,241,58,15,59,16,51,250,58,
27,51,29,51,253,50,253,50,188,50,213,50,16,51,16,51,
14,75,109,50,178,66,82,75,15,59,17,59,15,51,236,42,
51,75,89,67,61,51,217,42,114,50,142,74,171,74,166,66,
207,66,16,75,235,66,42,75,13,67,109,50,146,50,152,58,
63,51,62,51,62,51,62,51,62,51,30,51,30,51,61,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
93,51,62,51,62,51,62,51,61,51,60,51,60,59,60,59,
63,51,63,51,62,51,62,51,62,51,62,51,62,51,62,51,
63,51,62,51,94,59,61,51,62,51,63,51,252,50,176,34,
106,42,106,50,143,58,23,67,91,67,94,59,31,51,63,51,
94,51,27,51,181,50,142,50,138,50,39,42,101,25,36,17,
163,33,197,33,7,42,104,50,170,50,144,42,117,42,151,42,
212,58,177,58,174,58,106,50,8,42,7,34,41,42,143,50,
239,66,203,58,77,58,77,58,75,50,211,58,88,67,82,59,
86,67,89,59,93,59,95,59,63,51,62,43,93,51,93,51,
62,51,62,51,62,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
158,67,158,67,126,59,126,59,126,59,126,59,158,67,158,67,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,126,67,125,59,
158,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,157,67,157,67,157,67,157,67,157,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,157,67,158,67,158,67,157,67,157,67,157,67,
158,67,157,67,157,67,157,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,59,220,42,189,42,221,42,221,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,50,222,50,191,50,190,50,252,50,23,51,246,50,217,50,
154,42,221,50,253,50,252,42,28,51,250,50,215,42,245,50,
153,50,243,58,45,59,11,59,173,58,110,50,110,42,142,50,
232,33,166,25,101,17,102,25,200,41,41,50,105,58,72,50,
141,58,174,58,173,58,204,58,237,66,45,67,236,58,175,50,
222,50,61,59,58,59,56,51,27,51,29,59,249,50,179,42,
14,75,170,58,171,58,14,75,211,66,184,58,182,50,245,50,
143,66,239,58,52,51,247,42,177,42,173,58,173,58,139,50,
39,42,141,66,139,58,105,50,110,58,207,66,47,67,211,58,
30,51,30,51,30,51,30,43,62,51,62,51,62,51,29,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
93,51,94,51,62,51,62,51,61,51,60,51,91,59,91,59,
63,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
93,43,61,51,62,59,92,59,123,51,94,51,29,51,217,42,
113,50,236,33,204,33,82,50,214,50,27,51,63,51,127,51,
94,51,62,51,59,67,244,58,141,58,106,50,7,42,100,25,
98,17,165,33,11,50,109,58,170,50,109,34,86,34,189,50,
220,50,184,50,177,58,106,58,200,41,232,41,77,42,182,66,
246,66,18,75,206,74,206,74,203,66,176,58,216,66,19,59,
237,58,242,58,58,59,95,51,95,51,62,43,93,51,94,59,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
158,67,126,59,126,59,126,59,126,59,126,59,126,59,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,158,67,158,67,126,67,
158,67,158,67,158,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,158,67,158,67,158,67,158,67,157,67,157,67,
158,67,157,67,157,67,157,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,59,220,42,189,42,221,42,221,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
253,50,221,42,252,42,253,50,221,50,250,50,24,59,26,59,
246,50,218,50,219,50,27,51,59,51,59,59,247,50,243,42,
50,51,25,67,244,66,170,58,108,58,113,58,111,58,138,50,
74,42,169,25,39,17,7,17,135,33,40,50,137,58,137,58,
105,50,106,50,106,58,169,66,169,58,235,66,172,66,76,50,
153,50,28,59,121,51,53,43,214,50,188,58,253,58,26,43,
146,58,106,50,104,50,203,58,145,58,150,58,148,42,181,42,
113,50,206,58,47,59,21,59,213,50,112,42,141,42,239,58,
137,58,170,66,138,58,233,41,42,50,238,66,239,66,175,58,
58,51,61,59,62,51,30,51,29,43,61,51,62,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
94,51,94,51,62,51,62,51,62,51,61,51,91,59,90,59,
61,51,61,51,93,51,94,51,62,51,62,51,62,51,62,51,
92,43,62,51,30,51,60,51,123,51,122,51,90,51,92,59,
180,58,13,34,235,33,111,50,179,50,26,51,95,51,63,43,
94,51,29,43,91,59,242,50,10,34,41,50,137,58,197,33,
36,17,68,17,170,33,15,50,110,50,78,34,85,34,254,58,
124,51,23,51,206,50,136,50,38,50,103,50,171,58,210,66,
51,75,17,75,204,66,172,74,235,74,237,74,212,66,240,58,
110,58,144,50,212,42,58,43,126,51,127,51,95,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,59,
158,67,126,67,126,67,126,67,126,59,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,158,67,158,67,126,59,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,67,126,67,
158,67,158,67,158,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,157,67,158,67,158,67,158,67,158,67,157,67,157,67,
157,67,158,67,158,67,158,67,158,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,220,42,221,42,221,42,221,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
253,50,250,42,250,42,28,51,251,42,218,50,27,59,26,59,
19,59,212,50,248,50,58,59,218,42,219,50,26,59,21,59,
46,67,18,75,21,75,211,58,176,58,47,75,77,75,202,58,
42,42,234,33,170,33,137,33,200,41,137,58,169,66,105,58,
136,58,72,50,71,50,136,58,40,50,105,58,141,66,115,66,
182,50,252,58,28,51,57,51,185,42,153,42,217,50,251,58,
181,50,111,42,139,42,203,58,173,58,240,58,16,59,212,50,
218,50,182,50,207,50,15,59,180,58,82,42,79,42,178,58,
235,74,137,58,137,58,74,50,107,58,206,66,175,58,206,58,
245,50,25,59,61,59,62,59,61,51,61,43,61,51,30,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,61,51,59,51,90,51,
58,59,59,59,92,59,93,51,94,51,62,51,62,51,62,51,
61,43,63,59,30,51,62,51,62,51,24,43,243,42,243,50,
43,26,135,17,200,25,108,50,208,50,25,51,127,59,63,51,
95,51,60,51,214,42,110,34,73,34,104,50,168,58,104,58,
198,33,132,25,202,33,48,50,176,58,173,50,146,42,219,58,
127,51,27,43,180,42,110,42,74,50,136,50,135,50,170,58,
232,66,234,66,168,66,73,58,171,66,202,66,236,66,201,66,
143,66,146,58,182,50,251,50,94,51,95,51,62,51,62,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,51,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,158,67,158,67,158,67,158,67,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,126,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,158,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,158,67,158,67,158,67,158,67,158,67,158,67,157,67,
157,67,158,67,158,67,158,67,157,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,220,42,221,42,221,42,221,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,42,252,42,252,42,220,42,221,42,221,42,221,42,221,42,
252,50,248,42,216,42,218,42,217,50,185,42,218,50,185,50,
213,58,208,50,244,50,217,50,121,42,120,34,185,50,247,58,
15,75,13,67,47,67,18,67,240,58,237,58,11,59,168,58,
73,50,74,50,106,58,41,50,8,50,73,58,72,50,231,33,
108,50,140,50,109,58,141,58,40,50,39,50,108,58,112,66,
249,58,28,67,28,59,91,59,58,51,248,42,216,50,185,58,
254,50,216,50,177,50,171,58,108,58,173,66,202,58,171,50,
115,67,245,58,210,50,207,58,207,66,175,66,174,58,174,50,
138,66,139,66,138,58,8,42,42,42,176,66,240,66,11,67,
176,50,180,50,249,50,29,51,62,51,62,43,29,43,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,61,51,61,51,62,51,61,51,92,51,91,51,
22,59,24,59,59,59,93,51,62,51,62,51,62,51,93,51,
62,51,95,59,62,59,94,51,62,51,250,42,179,34,76,34,
10,26,136,17,137,25,11,42,109,42,245,50,90,67,24,51,
63,59,93,59,151,34,16,26,76,42,71,50,38,42,71,50,
6,42,231,41,44,50,79,50,141,50,203,50,110,50,86,50,
63,51,61,51,28,51,183,50,143,50,137,50,104,58,137,66,
134,58,167,66,200,66,104,58,104,58,135,58,169,66,168,66,
171,66,208,58,216,58,253,58,63,59,93,51,93,51,126,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
94,59,94,51,94,51,94,51,94,59,94,59,94,59,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
126,59,94,59,94,59,94,59,94,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,67,126,67,
94,59,94,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,126,59,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,67,126,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,157,67,157,67,157,67,157,67,
157,67,158,67,158,67,158,67,158,67,158,67,158,67,157,67,
157,67,158,67,158,67,158,67,157,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
29,51,220,42,221,42,221,42,221,42,221,42,188,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,42,252,42,252,42,252,42,220,42,221,42,221,42,221,42,
221,58,249,50,179,34,181,42,186,50,122,42,151,50,151,50,
185,66,240,58,144,42,88,42,218,50,216,50,184,50,248,58,
177,50,233,50,230,50,172,58,178,66,210,74,206,66,204,58,
170,66,169,58,201,66,169,66,41,50,41,50,8,42,7,34,
205,25,53,50,117,58,241,74,172,58,136,58,135,50,105,50,
180,58,55,59,29,51,29,51,54,59,245,58,247,58,244,50,
27,43,27,59,181,58,172,58,203,74,236,74,169,58,172,58,
201,66,206,58,213,66,179,66,202,66,12,75,51,75,19,59,
137,66,199,66,169,66,104,50,104,42,115,58,183,74,237,66,
81,75,18,67,214,50,28,59,63,51,63,51,62,51,93,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
62,51,62,51,62,51,62,51,62,51,62,51,62,51,62,51,
31,51,62,51,61,51,61,51,62,51,62,51,93,51,92,51,
244,58,22,59,58,59,61,51,62,51,63,51,94,51,93,51,
93,51,61,59,30,51,93,51,124,51,61,59,216,58,45,42,
167,25,71,17,74,25,172,33,78,42,179,50,150,50,50,34,
30,51,62,59,253,50,121,42,16,42,41,42,103,50,6,34,
167,41,232,41,138,58,74,42,236,33,108,42,109,50,50,50,
61,51,93,51,94,59,217,50,173,42,102,42,37,50,6,58,
136,66,38,58,170,66,75,58,41,50,7,50,73,66,136,74,
135,50,139,50,145,50,248,50,61,59,95,59,62,51,93,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,51,94,51,94,51,94,51,
94,59,94,51,94,51,94,51,94,59,126,59,94,59,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,51,94,51,94,51,94,59,94,59,94,59,
94,51,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,51,
126,59,94,59,94,59,94,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
93,59,93,59,94,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,67,126,67,
94,59,94,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,126,67,126,67,126,67,126,59,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,157,67,157,67,157,67,157,67,157,67,157,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,157,67,157,67,157,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,158,67,158,67,158,67,157,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,220,42,252,42,251,42,
218,50,251,50,26,59,58,59,57,51,25,51,252,42,254,50,
221,42,222,42,184,42,84,34,183,50,245,50,83,34,157,50,
28,43,185,42,86,34,154,42,253,50,253,42,185,50,207,58,
74,42,108,58,42,58,136,66,204,66,175,58,174,58,233,58,
140,66,170,66,134,58,168,66,138,58,11,42,77,50,44,42,
243,33,121,50,154,50,182,58,141,50,167,58,135,66,105,66,
172,66,211,58,27,51,62,51,26,51,21,59,51,67,210,58,
211,58,55,59,246,50,114,42,142,58,201,74,199,66,203,58,
169,58,170,50,176,58,183,66,52,42,13,34,106,42,239,66,
171,74,168,66,201,74,204,74,206,74,211,66,246,58,20,59,
9,67,202,66,209,66,246,50,90,43,94,51,31,51,93,43,
61,51,93,51,61,51,61,51,61,51,62,43,63,51,63,51,
62,51,62,51,94,51,94,51,94,51,94,51,94,51,93,51,
31,51,60,51,93,51,63,51,62,51,60,51,26,51,248,42,
211,58,210,58,216,50,30,51,93,51,62,59,255,50,94,51,
60,51,94,51,63,51,63,51,62,51,123,51,150,34,242,33,
106,17,9,9,69,9,203,41,236,49,205,33,122,50,122,34,
31,59,93,51,124,43,29,43,153,42,48,34,9,34,8,34,
38,50,71,58,235,49,241,41,82,42,143,42,177,50,149,58,
154,42,253,50,125,51,29,43,86,34,9,34,71,50,40,50,
230,41,38,50,136,58,105,58,233,41,234,41,200,41,105,58,
232,66,174,66,177,66,178,50,251,58,63,59,62,43,159,51,
95,43,94,51,95,59,95,59,94,59,92,51,62,51,95,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,51,94,51,94,51,94,51,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,59,126,67,126,59,126,67,126,67,
126,59,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,59,126,59,158,67,158,67,158,67,158,67,126,59,126,59,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,126,59,126,59,126,59,126,59,158,67,158,67,158,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,125,67,157,67,158,67,158,67,157,67,125,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,157,67,
158,67,157,67,157,67,157,67,158,67,158,67,158,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,220,42,220,42,252,42,
219,42,252,50,252,50,251,50,250,50,250,50,250,50,27,51,
255,42,255,42,27,51,247,50,213,50,113,42,16,34,118,50,
250,50,185,50,219,58,251,58,255,50,255,50,217,42,153,42,
143,50,109,50,41,50,105,58,203,66,204,66,171,58,170,58,
139,58,169,66,103,58,168,66,137,58,42,50,76,50,11,42,
17,42,22,67,87,75,51,67,172,58,169,66,168,66,201,74,
203,66,146,50,187,50,62,51,61,51,26,59,53,67,47,67,
178,58,22,59,20,51,176,42,142,58,138,66,134,58,168,58,
105,50,72,50,137,50,15,67,211,66,213,74,175,58,72,42,
39,50,135,66,168,66,10,83,110,91,47,75,207,50,240,50,
77,50,140,66,172,66,112,42,151,42,29,51,62,59,62,51,
62,51,94,51,62,51,94,59,94,59,93,59,93,59,59,59,
93,59,62,59,63,51,63,51,61,51,92,51,93,51,62,51,
63,51,92,51,92,51,94,51,93,51,125,59,92,59,25,51,
177,50,174,50,178,50,24,51,90,59,61,59,31,59,62,43,
62,67,124,59,91,51,94,67,95,59,126,51,218,42,50,34,
176,33,176,33,73,17,71,17,233,41,12,42,120,50,60,59,
63,51,94,51,93,59,95,59,63,59,185,42,78,42,135,58,
170,58,102,50,71,50,45,50,113,50,209,58,208,58,177,58,
91,34,31,51,127,51,125,59,183,34,242,25,114,58,172,58,
230,41,39,50,168,66,169,66,73,58,9,50,200,41,106,58,
106,58,169,66,172,58,113,42,183,50,94,59,127,59,125,51,
126,51,93,51,62,59,62,51,93,51,94,51,63,51,61,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,94,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,59,126,67,126,59,126,67,126,67,
126,67,126,67,126,67,126,67,126,59,126,59,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,158,67,158,67,158,67,158,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,59,126,59,126,59,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,157,67,158,67,158,67,158,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,157,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,157,67,157,67,157,67,158,67,158,67,158,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,220,42,220,42,
221,42,253,42,253,50,221,50,220,50,251,50,248,58,23,51,
55,43,251,42,253,50,26,51,247,50,149,42,82,42,112,50,
146,50,117,50,26,67,22,59,246,42,30,51,29,51,58,51,
210,58,75,42,231,33,201,41,42,50,105,50,104,50,73,58,
137,66,136,58,6,50,38,50,39,50,73,50,74,50,200,33,
109,58,108,50,107,42,12,59,11,75,168,66,135,66,40,83,
232,66,144,58,154,50,31,59,94,51,251,42,246,50,17,59,
207,74,20,67,22,59,211,42,142,42,39,42,229,41,231,49,
104,58,103,50,166,58,232,66,172,66,209,74,174,66,137,58,
134,58,201,74,168,66,199,66,75,83,107,83,201,58,107,42,
241,41,79,50,171,58,173,58,183,50,31,59,95,51,62,51,
61,51,93,59,93,59,92,59,123,67,153,67,152,67,119,59,
58,59,91,59,92,59,93,59,62,51,63,51,63,51,63,51,
93,51,92,51,94,51,63,51,62,51,93,59,122,59,85,51,
209,58,172,58,174,58,212,58,246,50,26,59,94,59,156,43,
92,67,88,59,84,59,26,59,62,59,93,51,93,51,182,42,
14,34,77,17,44,9,42,9,169,25,202,25,240,25,120,42,
158,59,94,59,62,51,93,59,124,59,183,42,50,34,48,50,
109,50,103,50,166,58,73,50,46,50,177,66,175,58,141,50,
248,50,124,67,94,67,89,51,249,42,190,50,249,66,203,58,
103,58,71,50,103,58,136,66,103,58,71,50,231,41,41,58,
104,58,40,50,41,42,108,42,212,58,92,67,127,67,125,51,
123,59,93,59,62,59,61,59,93,51,95,51,95,59,92,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,59,94,51,
94,51,94,51,94,59,94,51,94,51,94,51,94,51,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,51,94,51,
94,51,94,51,94,51,94,51,94,51,94,51,94,51,94,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,126,59,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,157,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,157,67,157,67,158,67,158,67,158,67,157,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,42,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
222,42,253,42,253,50,221,50,221,50,251,50,249,50,246,50,
49,59,24,59,253,58,26,59,23,51,250,58,183,50,44,26,
18,42,115,42,52,59,245,50,150,50,218,50,222,50,62,43,
84,67,173,50,138,50,76,50,77,50,107,58,73,58,105,66,
201,66,169,66,136,66,169,66,169,66,136,58,72,50,198,33,
173,66,205,66,170,58,170,58,202,66,137,66,104,58,200,66,
230,66,204,66,181,66,29,67,95,51,61,43,56,51,20,59,
238,74,48,75,52,67,21,59,178,50,74,42,230,41,231,49,
72,58,135,58,70,50,71,50,136,58,168,66,104,58,107,58,
169,66,202,74,169,66,102,58,103,58,168,66,233,66,171,66,
211,66,179,50,175,50,140,50,147,50,30,51,95,43,93,51,
30,43,94,51,93,51,61,59,60,51,28,59,92,67,60,67,
58,59,57,59,55,59,55,51,59,59,62,59,63,51,31,51,
93,51,93,51,63,51,31,51,30,51,61,51,89,51,81,43,
237,58,168,58,170,58,176,58,146,50,216,58,62,59,126,43,
93,59,118,51,79,43,214,50,30,67,93,51,156,59,24,51,
16,34,79,17,22,42,55,50,178,33,105,17,137,17,56,50,
127,67,95,51,63,43,93,51,54,43,142,34,111,42,148,50,
76,42,136,50,165,58,229,41,200,41,108,58,172,58,172,58,
242,50,243,58,85,75,20,51,26,59,157,75,242,58,74,42,
167,66,71,50,71,50,71,58,102,58,135,66,71,58,73,58,
167,66,104,58,42,50,141,58,240,58,22,59,60,67,92,59,
57,59,90,59,92,59,125,59,126,51,95,51,95,51,125,59,
94,51,94,51,94,51,94,51,94,51,94,51,94,59,94,51,
94,51,94,51,94,59,94,59,94,51,94,51,94,59,126,59,
94,51,94,59,94,59,126,59,126,59,94,59,94,59,94,51,
94,59,94,51,94,51,94,51,94,51,94,51,94,51,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,42,252,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,50,221,50,252,50,252,50,252,50,252,50,26,51,24,51,
213,58,215,58,249,58,23,51,243,50,22,59,247,58,79,34,
179,33,118,42,18,51,19,59,214,66,211,58,211,50,217,42,
210,50,111,42,142,50,78,50,45,50,44,42,41,50,105,58,
169,58,39,50,39,50,169,66,10,75,201,74,136,58,71,50,
9,50,171,66,202,58,103,50,102,50,101,58,101,58,102,50,
165,58,199,66,172,58,213,58,29,59,95,51,122,59,84,59,
237,66,11,67,46,67,243,58,178,50,75,42,230,33,166,41,
73,58,167,66,101,58,7,50,104,58,101,58,37,50,41,58,
41,50,72,58,169,66,234,74,233,74,136,66,105,58,136,66,
44,67,16,59,145,50,45,42,111,50,56,59,126,51,123,51,
62,51,94,51,62,51,62,51,29,51,28,51,60,59,59,59,
26,59,59,59,88,59,53,59,22,51,56,51,122,59,126,67,
93,59,93,59,94,51,94,51,61,51,62,59,60,51,53,43,
142,42,73,50,107,58,142,66,175,58,212,58,61,67,94,51,
95,51,59,43,18,35,179,42,30,67,95,59,122,51,211,42,
79,42,204,25,208,33,242,33,19,42,175,25,44,9,59,58,
61,67,59,51,124,51,125,51,250,50,116,42,110,42,106,42,
41,42,39,42,229,33,131,33,196,41,70,50,170,58,238,66,
204,58,138,50,203,66,234,58,14,59,48,59,136,42,40,50,
135,58,104,58,137,66,104,58,71,58,102,58,71,58,7,42,
229,41,103,58,73,58,12,50,79,50,177,50,22,59,60,59,
26,51,24,51,24,51,59,51,127,51,95,51,94,51,94,59,
94,51,94,51,94,51,94,59,94,59,94,51,94,59,94,59,
94,51,94,51,94,59,94,59,94,51,94,51,94,59,126,59,
94,51,94,59,94,59,126,59,126,59,94,59,94,59,94,51,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,50,220,50,251,50,251,50,251,50,27,51,27,51,58,51,
24,59,19,51,20,59,213,50,178,50,209,58,179,58,82,50,
86,42,183,50,181,50,241,58,241,74,174,58,140,50,83,42,
143,34,114,42,116,50,115,58,81,50,46,42,10,34,39,42,
232,33,167,33,198,33,6,42,104,58,201,74,233,74,200,66,
107,58,76,58,141,58,140,58,169,66,103,58,6,50,39,42,
101,58,135,58,103,50,137,50,241,50,26,59,28,59,58,51,
82,67,75,67,74,75,15,67,176,58,107,42,7,34,198,41,
6,42,102,58,134,66,38,58,39,58,103,58,169,66,138,66,
8,42,38,50,103,58,168,66,232,74,168,66,104,58,134,66,
133,50,136,50,110,58,78,66,172,66,239,66,246,58,25,59,
90,59,92,59,29,51,63,59,63,59,62,59,92,51,58,43,
22,51,57,59,88,67,55,67,217,58,248,58,86,59,119,59,
90,59,89,59,91,59,93,59,94,51,63,59,30,59,26,51,
150,50,111,58,174,66,206,66,138,50,141,50,246,58,90,51,
91,51,63,51,28,59,244,50,56,59,93,59,88,59,18,59,
175,58,9,34,71,17,39,9,172,25,207,33,106,17,239,41,
217,42,183,42,149,34,214,42,250,42,219,50,180,58,41,42,
232,33,201,33,169,33,232,41,38,50,5,42,42,50,177,66,
205,66,172,58,48,50,20,50,83,50,79,42,106,50,137,58,
40,42,40,42,105,58,72,58,39,58,104,58,169,66,105,58,
38,42,105,58,136,66,137,58,144,66,177,58,178,50,217,50,
60,59,25,51,245,42,248,50,94,59,127,59,125,51,95,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,126,67,126,59,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,157,67,157,67,157,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
252,42,221,42,253,50,252,50,250,50,249,50,25,59,57,59,
84,67,237,50,238,50,210,58,178,58,240,66,209,58,181,66,
209,50,237,50,173,50,141,50,173,66,236,74,203,58,146,58,
114,42,179,58,211,58,243,58,245,58,148,50,48,34,235,33,
202,33,9,34,72,50,39,50,7,50,105,58,169,66,200,66,
137,58,139,58,237,66,171,66,137,66,102,66,102,58,70,50,
38,58,72,58,71,58,165,58,199,58,143,50,186,50,63,51,
58,59,48,59,9,67,234,66,172,58,110,42,78,42,42,42,
71,50,103,50,168,66,135,66,134,66,102,66,103,58,8,50,
134,33,231,41,40,50,104,58,102,58,134,58,167,66,168,66,
7,75,168,66,172,74,13,83,11,75,203,66,177,58,25,67,
82,67,51,59,21,59,57,59,91,59,92,59,93,51,60,51,
55,51,23,51,20,59,21,59,251,66,27,67,21,59,179,42,
56,59,54,59,56,51,60,59,62,59,63,59,62,59,59,51,
148,42,109,50,139,58,140,58,105,50,76,50,211,58,86,67,
115,67,88,67,61,75,20,67,242,50,90,67,119,67,83,67,
237,58,201,66,168,66,73,50,106,25,111,25,173,33,201,33,
152,42,219,58,120,42,51,26,114,26,147,42,144,50,41,50,
232,41,234,41,76,50,75,50,40,50,231,41,202,41,79,50,
86,58,178,58,179,50,121,50,150,58,142,50,111,50,83,50,
142,50,108,50,138,58,71,50,38,50,105,58,236,74,204,66,
105,58,71,50,104,58,137,66,234,74,206,58,115,42,182,50,
126,51,91,59,245,50,213,50,28,59,127,59,126,59,127,59,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,51,94,51,94,51,94,59,94,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,51,94,51,94,59,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
126,59,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,157,67,157,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,157,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,220,42,221,42,221,42,221,42,221,42,221,42,221,42,
221,42,221,42,221,42,221,42,221,42,221,42,221,42,252,42,
28,43,253,42,254,42,253,50,250,50,247,50,246,50,23,59,
18,67,237,58,45,75,14,67,238,66,239,58,209,50,22,59,
18,59,116,50,173,58,106,58,143,66,46,75,12,75,238,66,
122,58,211,58,170,42,170,42,243,50,218,58,218,58,183,58,
143,58,201,33,165,25,229,33,7,42,40,50,39,50,135,58,
103,50,105,50,171,58,41,50,231,49,39,58,103,58,70,50,
229,49,38,58,103,58,135,66,71,58,203,33,85,34,127,51,
126,51,23,59,177,74,171,74,200,66,206,58,180,58,115,58,
43,50,72,50,134,58,134,66,199,74,101,58,69,50,37,50,
105,58,202,41,42,50,137,58,39,50,101,50,199,74,170,66,
201,66,107,66,170,66,40,67,9,67,171,66,112,58,215,50,
151,66,150,58,149,58,246,58,56,59,26,51,61,51,95,59,
254,50,29,59,86,67,81,67,53,67,54,67,54,67,186,50,
251,66,22,59,54,59,90,59,91,59,92,59,93,59,93,51,
19,51,139,42,73,42,108,50,172,58,173,66,208,66,46,59,
13,67,9,59,17,67,207,66,110,42,27,59,246,58,141,50,
138,50,166,58,167,74,170,74,9,42,43,42,43,42,101,17,
43,9,24,67,126,67,187,42,18,26,170,17,230,25,228,25,
165,33,165,25,40,34,229,25,196,25,39,50,8,42,9,42,
185,58,188,50,89,59,119,59,20,59,81,42,210,33,118,42,
146,58,174,58,234,66,134,58,5,50,8,42,205,66,238,74,
236,74,200,66,233,74,136,66,134,50,201,58,176,50,185,50,
94,43,93,59,54,59,211,50,249,50,62,59,95,51,127,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,51,94,51,94,51,126,59,127,59,126,59,126,59,
94,59,94,59,94,51,94,51,94,51,94,51,94,59,94,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,158,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,158,67,158,67,158,67,158,67,
126,67,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,159,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,190,67,190,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,157,67,157,67,158,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,252,42,221,42,221,42,221,42,221,42,221,42,253,50,
253,50,221,42,221,42,221,42,221,42,221,42,221,42,221,42,
253,50,221,42,222,42,254,50,253,50,251,42,216,42,182,42,
244,58,241,50,174,50,208,58,241,74,239,66,174,58,241,66,
205,58,211,66,181,58,47,42,76,42,141,58,237,66,168,58,
213,50,86,67,207,50,42,34,207,58,241,66,176,58,20,75,
206,66,9,34,134,33,231,49,72,58,7,50,199,33,232,33,
71,50,136,58,10,75,137,58,72,50,6,42,228,33,228,33,
228,41,228,41,6,50,38,50,198,33,10,50,46,50,114,66,
126,51,93,51,24,51,173,42,167,50,233,66,237,66,16,67,
13,50,144,66,109,58,231,41,70,50,201,74,230,41,230,41,
140,58,115,58,52,42,178,50,108,42,6,42,167,66,169,66,
102,58,166,58,232,66,201,66,169,66,169,58,173,58,178,50,
188,42,92,59,126,59,30,59,26,59,248,58,219,50,29,59,
63,43,124,59,22,51,180,58,52,75,48,75,16,67,53,67,
61,67,23,59,244,58,26,67,90,75,86,59,26,51,95,67,
25,59,174,42,105,42,109,50,77,50,138,50,8,42,11,50,
107,58,136,58,138,66,171,66,173,58,216,66,30,59,214,34,
110,50,107,50,70,50,69,58,103,66,5,50,38,42,201,25,
103,17,17,42,213,58,180,50,242,25,173,17,104,25,69,25,
165,33,102,25,100,25,67,25,4,17,167,33,39,50,169,58,
13,67,210,66,20,75,14,59,205,42,184,42,189,42,182,34,
202,25,233,33,41,50,72,58,38,58,38,50,105,58,13,75,
235,58,138,50,73,50,8,50,72,58,105,58,139,58,206,66,
59,51,191,59,26,43,144,42,147,50,63,67,159,59,95,51,
95,59,94,51,94,59,125,59,126,59,94,51,94,51,94,51,
94,51,94,51,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,126,59,126,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,158,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,158,67,158,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,158,67,158,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,67,158,67,158,67,158,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,126,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,157,67,157,67,
190,67,190,67,158,67,157,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,157,67,158,67,158,67,158,67,158,67,157,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,252,42,221,42,221,42,221,42,221,42,221,42,253,50,
253,50,253,50,221,42,221,42,221,42,221,42,221,42,221,42,
251,42,252,42,253,42,254,42,253,42,220,42,218,50,249,50,
215,58,243,58,208,58,207,58,237,66,235,66,169,58,170,58,
201,58,173,58,177,66,177,58,177,58,113,58,114,58,146,66,
207,58,239,66,204,58,169,58,204,66,171,66,104,50,170,58,
172,58,73,50,8,42,230,41,133,33,166,33,8,42,8,42,
139,58,138,58,11,75,201,66,168,58,38,42,229,41,39,50,
5,50,38,50,38,50,5,42,164,33,39,50,139,66,238,74,
20,51,56,67,91,67,181,50,48,42,110,58,172,58,202,58,
40,42,9,42,9,42,229,33,5,42,103,58,6,50,6,50,
39,50,106,50,81,42,182,58,240,66,168,58,167,66,133,58,
167,66,168,66,137,58,105,58,103,58,104,58,108,50,49,50,
31,51,123,59,86,51,52,59,85,75,247,66,219,50,254,50,
95,51,94,59,28,51,28,51,90,67,52,67,207,58,238,66,
85,67,82,59,51,59,21,59,25,59,56,59,86,51,60,59,
122,59,145,34,41,34,170,58,107,50,42,42,200,25,234,33,
141,50,137,50,169,66,201,66,202,66,243,58,28,59,253,42,
80,34,42,34,198,33,199,41,136,66,103,50,41,50,233,41,
137,33,199,33,201,25,236,17,20,34,55,42,172,25,8,1,
105,17,199,33,133,25,227,16,2,17,165,33,166,33,71,42,
105,58,138,58,107,58,232,41,72,42,80,75,87,75,213,58,
52,34,238,33,200,25,198,33,38,42,37,42,39,50,138,58,
105,50,105,50,73,50,198,41,198,41,72,50,138,58,140,58,
18,59,92,67,54,51,149,50,145,50,219,50,93,51,158,59,
95,59,94,59,94,59,126,59,93,59,94,51,94,51,95,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
158,67,158,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,59,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
126,67,126,67,126,67,126,67,158,67,158,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,158,67,158,67,158,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,157,67,157,67,
190,67,190,67,158,67,157,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,252,42,221,42,221,42,221,42,221,42,221,42,221,42,
253,50,253,50,253,50,221,42,221,42,221,42,253,50,253,50,
252,42,252,42,253,42,253,42,29,51,29,51,60,59,27,59,
26,67,243,58,176,50,175,58,204,58,138,58,106,58,202,66,
167,66,136,58,139,58,174,58,175,66,109,58,143,58,178,74,
238,74,108,58,73,50,40,50,73,58,169,66,168,66,167,58,
40,42,231,41,40,50,39,42,100,25,100,25,7,50,73,58,
232,41,232,41,139,66,203,74,203,74,137,58,38,50,70,50,
6,50,136,66,169,74,71,58,164,33,228,41,38,50,104,58,
102,58,203,58,49,67,51,67,243,58,242,66,208,66,205,66,
72,42,167,25,199,33,164,33,4,42,37,50,38,58,70,58,
4,50,40,42,43,42,141,50,171,58,104,50,70,50,70,58,
168,66,201,74,234,74,169,66,103,66,71,58,42,58,46,50,
60,59,26,59,119,42,150,50,180,58,181,50,56,67,151,59,
61,51,95,51,95,51,157,51,122,59,245,50,208,58,13,67,
213,66,245,58,24,51,24,59,26,59,24,59,54,51,57,51,
93,59,21,51,46,34,209,41,52,50,109,50,43,42,18,42,
15,34,108,50,169,58,167,66,102,50,107,42,214,50,95,59,
26,51,238,25,105,25,170,41,7,34,36,34,6,42,168,41,
169,41,230,41,228,33,170,17,213,33,57,42,22,26,212,17,
238,33,168,17,69,17,5,17,228,16,69,25,136,33,234,33,
238,41,74,50,72,58,230,49,5,50,135,58,137,58,105,50,
123,50,154,58,18,34,201,25,6,34,6,42,6,50,37,58,
73,50,105,58,105,58,197,41,197,41,72,58,202,66,203,66,
204,66,210,58,146,50,115,50,114,50,183,50,30,51,125,59,
126,51,94,59,94,59,94,59,94,59,126,59,126,59,95,51,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,126,67,126,67,126,59,126,67,126,67,126,67,
158,67,126,59,126,59,158,67,158,67,158,67,158,67,158,67,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,157,67,157,67,
158,67,190,67,158,67,158,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,158,67,158,67,
61,59,252,42,221,42,253,50,221,42,253,50,221,42,221,42,
253,50,253,50,253,50,221,42,221,42,253,50,253,50,253,50,
254,50,253,42,254,42,253,42,253,50,28,51,250,42,184,34,
150,42,176,42,143,42,175,58,203,58,106,58,76,58,170,74,
136,66,169,74,235,74,235,74,10,75,233,66,9,75,10,75,
174,66,108,58,42,50,166,33,69,25,231,49,170,66,171,66,
203,66,73,58,72,50,71,42,197,33,100,25,100,25,100,33,
198,33,231,41,106,58,106,58,106,58,105,58,38,50,37,42,
230,49,72,58,137,74,105,66,39,50,38,50,5,42,5,42,
200,49,167,41,40,42,234,58,43,67,11,67,233,66,168,58,
77,42,236,33,10,42,38,42,165,58,134,66,103,66,104,66,
228,49,199,41,230,41,69,42,70,50,39,50,6,42,40,50,
74,58,201,66,232,66,199,66,135,66,104,66,137,66,171,66,
208,58,21,67,251,58,94,75,59,75,249,66,55,75,208,50,
26,43,30,51,95,59,123,59,56,51,247,58,21,67,113,75,
78,83,50,75,86,67,89,67,119,75,53,67,24,67,57,59,
155,67,246,58,237,25,46,34,150,58,82,50,13,42,207,41,
244,33,79,50,105,50,71,58,72,58,104,42,206,50,55,59,
157,67,121,42,51,34,11,34,133,17,131,17,196,41,167,49,
102,33,135,33,199,33,138,25,175,33,149,42,252,58,95,67,
148,42,173,17,38,9,71,33,72,33,136,33,201,33,15,42,
116,50,143,50,138,58,71,50,6,42,166,33,197,25,70,42,
209,58,87,75,149,50,46,34,41,34,168,33,200,41,9,58,
40,50,73,58,169,66,104,58,104,58,104,58,169,66,169,58,
73,58,106,50,144,58,241,58,146,50,150,42,31,59,95,59,
94,51,126,59,94,59,94,59,126,59,125,59,126,59,95,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
158,67,158,67,126,67,126,59,126,59,126,67,126,67,158,67,
158,67,158,67,126,59,158,67,158,67,158,67,158,67,158,67,
126,59,126,59,126,59,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,158,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,126,67,126,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,157,67,158,67,158,67,158,67,158,67,158,67,190,67,
61,59,252,42,221,42,253,50,221,42,253,50,221,42,221,42,
253,50,221,42,221,42,221,42,221,42,221,42,253,50,253,50,
254,50,254,50,253,42,253,42,253,42,252,42,218,42,153,34,
156,42,216,50,215,50,116,50,110,50,109,50,77,58,40,50,
70,58,169,74,202,74,104,58,103,50,103,50,168,66,168,66,
106,58,170,66,203,74,73,50,166,33,166,33,8,42,74,50,
204,74,203,74,137,58,39,42,229,33,131,25,34,17,34,25,
198,33,6,42,71,50,70,50,70,50,104,58,71,50,231,41,
6,50,39,58,137,66,138,66,139,66,139,66,170,74,203,74,
137,66,6,50,6,50,136,66,202,66,169,58,169,66,170,66,
78,50,13,42,11,42,165,33,228,33,229,41,6,50,198,49,
231,49,195,41,196,33,199,41,6,42,5,42,230,41,38,50,
140,58,171,58,168,50,102,50,103,50,104,58,169,58,233,58,
140,58,207,58,179,42,23,59,57,67,251,66,59,75,246,66,
85,59,27,51,63,59,62,59,61,59,91,67,86,75,110,75,
43,83,14,75,18,67,52,67,81,75,78,75,48,75,141,75,
109,67,242,58,48,34,173,17,176,17,80,34,108,50,72,25,
22,42,80,50,39,42,6,50,74,66,104,58,103,50,76,42,
210,42,61,67,251,58,237,17,69,9,39,25,71,33,231,41,
5,42,197,33,200,41,134,33,103,17,239,33,117,42,153,42,
119,42,82,42,105,17,39,25,169,41,166,33,133,25,236,33,
145,42,112,42,77,42,40,42,7,42,7,42,231,33,38,34,
168,58,10,67,107,50,78,50,76,50,197,33,230,41,75,66,
138,66,105,58,137,66,72,58,71,58,72,58,136,58,168,66,
105,66,71,58,106,50,145,42,49,34,86,34,95,59,95,51,
94,51,125,59,126,59,94,59,93,59,124,59,125,59,95,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,59,158,59,
158,67,126,67,126,67,126,59,126,59,126,67,126,67,158,67,
158,67,158,67,126,67,126,67,126,59,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
190,67,158,67,190,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,190,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
157,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
61,59,252,42,221,42,253,50,221,42,253,50,221,42,253,50,
221,42,221,42,221,42,221,42,221,42,221,42,253,50,253,50,
252,42,253,50,29,51,29,51,29,51,30,51,30,51,253,50,
253,50,27,51,250,50,151,42,145,42,176,58,174,66,168,58,
5,50,168,66,11,75,202,66,137,58,72,50,72,50,39,50,
38,50,103,50,171,66,140,58,41,42,200,33,9,34,171,58,
172,66,204,74,137,58,103,58,168,58,6,50,165,33,39,50,
70,50,229,33,197,33,71,50,168,66,10,75,200,66,103,58,
5,50,38,50,169,66,170,66,140,74,108,66,140,66,237,82,
10,75,200,66,103,66,105,74,73,66,39,50,71,58,137,66,
169,58,74,50,9,42,134,25,35,17,100,33,6,50,196,41,
164,33,132,33,165,41,166,41,133,33,132,25,132,33,228,41,
42,42,108,50,75,42,40,42,38,42,39,50,105,50,171,50,
210,66,244,66,150,50,216,58,22,67,149,50,214,50,55,59,
176,50,182,50,28,51,95,51,127,59,154,67,147,75,108,75,
139,83,140,83,142,83,143,83,51,83,19,75,44,75,234,66,
169,58,169,58,75,42,210,33,24,34,17,34,233,33,104,25,
20,42,80,42,231,33,163,33,7,50,71,58,37,50,198,41,
41,9,148,42,92,59,150,42,171,25,137,33,39,25,133,17,
230,33,164,25,164,33,165,33,136,25,175,33,243,33,242,25,
52,34,45,34,103,17,39,17,101,25,101,25,103,17,10,42,
203,25,236,33,43,42,42,50,42,50,40,50,197,33,165,33,
72,58,167,66,102,50,41,50,233,41,69,25,100,25,198,41,
138,66,105,58,137,66,72,58,73,58,137,58,201,66,200,66,
168,66,104,66,200,58,242,58,182,50,245,58,127,67,94,51,
95,51,125,51,126,59,126,59,125,59,122,59,91,59,62,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,126,59,126,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
94,59,94,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,67,126,67,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,59,158,59,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
93,59,252,50,221,42,253,50,221,42,253,50,221,42,253,50,
253,50,253,50,221,42,221,42,221,42,253,50,253,50,253,50,
252,50,252,50,29,51,29,51,253,42,253,42,254,50,254,50,
29,51,253,42,30,51,28,51,217,50,182,50,177,50,171,50,
104,58,169,58,235,66,171,66,171,66,136,58,103,58,39,50,
198,41,39,50,172,66,174,66,106,50,168,25,105,25,202,33,
139,58,106,58,230,41,229,41,103,66,6,50,102,33,233,41,
135,58,165,33,36,17,231,41,137,66,43,83,106,91,105,91,
200,66,167,58,168,66,169,66,236,82,172,74,139,66,171,66,
136,58,70,58,196,49,6,58,103,66,101,50,134,58,202,74,
230,66,169,66,105,58,8,42,101,25,69,25,133,33,132,25,
66,9,37,17,101,33,228,49,132,33,100,25,164,33,165,33,
197,33,74,50,141,58,137,58,102,58,103,58,171,58,14,67,
136,50,142,50,152,50,253,66,26,67,182,50,185,50,29,59,
149,58,215,50,58,51,94,51,93,43,56,51,244,50,210,58,
16,59,43,67,74,83,107,83,82,83,83,75,77,75,11,75,
234,66,234,74,138,58,235,41,79,50,78,42,173,25,144,33,
115,42,117,50,207,33,168,25,6,42,38,50,229,49,165,41,
203,41,78,42,23,67,217,58,208,25,202,25,103,17,70,17,
102,25,36,17,66,17,102,25,235,41,79,50,19,42,80,42,
14,34,202,25,135,17,136,25,70,17,104,25,236,41,45,50,
167,33,169,33,10,42,76,50,14,50,235,41,167,33,231,41,
230,41,103,58,166,58,69,50,231,41,235,41,11,50,232,41,
73,58,40,58,137,66,72,50,41,50,138,58,234,66,233,66,
135,58,200,74,200,66,238,58,215,66,206,58,59,67,158,59,
127,51,125,51,125,59,94,59,92,59,88,51,89,51,61,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,94,59,94,59,94,59,
94,59,126,59,126,59,126,59,94,59,94,59,94,59,126,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
158,59,158,59,126,67,126,67,126,67,126,67,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,59,158,59,
158,67,158,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,190,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,190,67,190,67,158,67,158,67,190,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
189,67,189,67,189,67,189,67,189,67,189,67,189,67,189,67,
93,59,252,50,221,42,221,42,221,42,253,50,221,42,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
222,50,222,42,253,42,29,43,29,43,29,43,29,43,29,51,
27,43,30,43,31,51,30,51,252,50,57,59,83,59,236,50,
140,58,170,58,170,58,142,58,206,66,202,66,135,58,231,41,
232,49,198,41,232,41,41,42,71,42,40,42,203,41,235,41,
9,34,73,50,230,41,131,33,164,41,166,41,136,33,44,50,
41,50,199,33,134,33,230,41,229,41,70,50,167,66,8,75,
73,83,231,66,166,58,102,58,169,66,170,66,169,66,169,66,
170,74,197,41,193,16,68,33,70,50,67,42,36,42,72,58,
167,58,169,66,8,42,231,41,100,25,69,25,167,33,72,50,
71,42,163,25,35,25,101,41,131,33,195,33,6,42,197,41,
162,33,39,50,72,50,70,50,69,50,39,50,106,58,204,58,
143,74,80,50,184,50,60,59,22,43,18,43,52,59,213,58,
30,67,251,58,251,50,63,59,95,59,93,51,28,51,255,50,
29,59,212,58,235,74,44,83,110,75,110,67,79,75,75,83,
13,75,137,66,233,82,135,66,166,33,11,9,178,25,119,50,
115,34,187,58,123,50,17,34,231,25,164,25,133,41,166,49,
199,41,204,41,145,58,210,50,82,34,81,42,140,25,75,25,
5,17,34,17,228,16,230,16,135,25,137,25,137,17,237,33,
205,33,47,42,12,42,201,33,105,25,172,33,203,41,107,25,
137,33,78,25,177,33,16,34,14,34,233,33,165,25,133,25,
198,33,229,33,37,42,4,34,230,41,73,50,74,50,199,33,
199,41,198,41,72,58,105,58,74,50,73,50,104,50,103,50,
137,66,233,82,166,66,171,58,17,75,172,58,212,58,95,59,
127,51,125,51,125,59,94,59,91,59,55,51,88,51,93,59,
94,59,94,59,94,59,94,59,94,59,94,59,126,59,126,59,
94,59,94,59,94,59,126,59,126,59,94,59,94,59,94,59,
126,59,126,59,126,59,126,59,94,59,94,59,94,59,94,59,
94,59,94,59,94,59,94,59,94,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
158,59,158,59,126,67,126,67,126,67,126,67,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,67,126,67,126,67,126,67,126,59,126,59,
126,67,126,67,126,67,126,67,126,67,126,67,158,59,158,59,
158,67,158,67,158,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
191,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
190,67,190,67,158,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,190,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,157,67,157,67,
190,67,158,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
189,67,189,67,189,67,189,67,189,67,189,67,189,67,189,67,
94,59,253,50,221,42,221,42,221,42,221,42,221,42,252,42,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
254,50,253,50,253,50,253,50,253,50,252,50,252,50,28,51,
252,50,253,42,254,42,29,43,26,51,180,42,110,50,172,58,
172,58,137,50,137,58,105,58,104,58,137,66,136,66,164,58,
133,58,228,41,197,41,198,41,132,25,133,25,234,41,175,58,
171,58,105,50,230,33,196,33,229,41,5,42,71,50,72,50,
166,33,169,41,137,33,135,25,164,25,36,42,167,66,104,74,
167,74,200,74,167,74,136,66,168,74,233,82,10,83,168,74,
106,66,8,50,166,33,7,50,71,58,229,49,197,41,5,50,
103,58,136,66,165,33,68,17,166,33,165,33,132,33,196,33,
37,58,8,50,134,33,164,33,135,66,169,74,7,50,4,42,
131,25,99,25,131,33,37,50,71,58,72,58,73,58,232,41,
234,66,237,66,15,67,206,58,79,42,244,41,53,50,211,66,
216,50,59,59,60,51,94,51,127,51,62,51,124,59,121,59,
118,67,51,75,238,74,202,66,234,66,48,75,49,75,75,75,
43,83,201,74,169,74,199,74,41,50,141,25,236,33,110,50,
75,58,175,58,118,75,240,58,232,33,167,41,228,41,37,42,
197,33,100,25,137,33,75,58,200,41,137,33,105,17,173,33,
71,25,162,8,36,25,136,33,102,33,100,25,102,25,107,33,
103,25,170,33,15,42,19,42,18,42,142,17,111,17,212,33,
206,25,209,25,248,33,55,34,21,34,173,17,174,25,209,33,
133,25,101,25,166,33,197,41,37,50,134,58,230,41,134,25,
79,42,147,58,140,50,71,50,137,58,70,50,70,50,232,41,
73,50,71,50,38,50,137,66,172,66,174,58,148,42,60,51,
125,59,127,59,95,59,126,59,93,59,24,59,21,59,55,75,
156,59,124,59,95,59,95,59,124,59,125,51,127,59,127,51,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,126,59,125,59,126,51,127,51,95,51,
156,59,125,51,126,59,127,59,93,59,125,59,158,59,127,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,59,126,59,126,59,126,59,126,67,126,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,126,59,126,59,
126,59,126,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,59,126,59,126,59,126,67,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,126,67,126,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,126,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
159,67,159,67,158,67,158,67,158,67,158,67,157,67,157,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,157,67,157,67,190,67,190,67,158,67,158,67,190,67,
189,67,189,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
94,59,252,50,221,42,253,50,221,42,253,50,221,42,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
254,50,253,50,253,50,253,50,253,50,252,50,252,50,252,50,
253,50,253,50,253,50,29,51,250,50,117,34,17,34,16,42,
45,42,199,25,198,33,167,33,164,33,229,41,230,41,231,41,
70,50,197,41,165,33,133,33,100,25,100,25,231,41,235,66,
202,66,72,50,6,42,229,41,163,33,196,33,70,50,135,58,
102,50,105,58,136,33,104,25,232,33,198,25,7,42,170,74,
200,74,232,74,201,74,201,74,169,74,169,74,234,82,169,74,
138,66,138,66,138,66,234,74,169,74,6,50,229,49,70,58,
38,58,168,74,38,50,133,33,165,33,165,33,132,33,165,33,
133,33,40,50,231,41,67,17,99,33,5,50,135,58,199,66,
38,50,229,41,230,41,104,58,105,66,105,58,137,66,137,58,
136,58,73,50,109,58,46,58,78,58,240,74,239,74,175,66,
143,50,246,66,29,59,62,59,94,51,94,51,93,59,60,59,
85,67,18,59,237,66,200,66,101,58,173,66,117,83,52,59,
19,67,240,58,206,58,43,75,40,75,106,58,201,33,133,25,
166,25,171,58,47,75,168,58,134,58,170,74,136,66,71,58,
230,41,4,17,38,25,198,33,69,25,9,42,41,42,110,25,
41,17,195,0,2,17,35,25,36,25,164,33,196,33,132,25,
132,17,134,17,78,42,215,58,253,66,90,42,245,33,177,17,
173,25,176,25,122,42,62,59,63,59,156,42,90,42,82,34,
104,25,70,25,6,42,71,50,39,50,39,50,230,41,6,42,
78,42,148,66,110,58,39,50,71,50,6,42,39,50,40,50,
5,42,73,50,105,58,166,66,166,66,172,58,148,50,124,67,
56,51,92,59,126,59,127,59,93,59,24,59,243,58,19,67,
56,51,93,59,127,59,94,51,125,59,126,59,95,59,126,51,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,127,59,94,59,93,51,92,51,125,59,126,59,
127,59,127,59,126,59,126,59,126,59,126,59,126,59,126,51,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,67,126,67,126,67,
158,67,158,67,158,67,126,59,126,59,126,59,126,59,126,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,59,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,126,59,126,59,158,67,158,67,158,67,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,59,158,59,158,67,158,59,158,59,158,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
159,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,158,67,157,67,190,67,190,67,190,67,158,67,158,67,
189,67,189,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
93,59,252,50,253,50,253,50,253,50,253,50,221,42,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,254,50,29,51,29,51,253,50,252,50,252,50,252,50,
253,58,253,50,253,50,29,51,252,50,186,42,152,42,151,50,
149,58,44,34,8,34,168,33,70,25,100,25,100,25,36,25,
132,25,164,33,229,41,229,41,133,33,35,25,67,17,6,42,
6,42,100,25,197,41,71,58,197,41,34,17,99,25,37,50,
70,58,135,66,167,33,107,33,83,58,82,58,44,50,200,74,
9,75,9,75,233,74,201,74,202,74,234,74,11,83,203,74,
171,66,138,58,105,58,169,66,201,74,135,58,38,50,5,42,
37,50,167,66,167,66,38,50,165,33,100,25,134,33,199,41,
133,33,71,42,39,42,132,25,67,25,164,41,38,58,105,58,
103,58,6,42,6,42,105,58,106,66,73,58,137,58,137,58,
106,58,73,58,45,91,14,91,173,82,204,82,109,66,15,50,
149,58,249,74,91,75,89,67,121,59,122,59,59,67,91,67,
28,59,57,51,213,50,209,66,138,66,137,74,77,91,141,83,
244,58,24,67,21,67,45,67,72,83,231,74,235,49,77,25,
109,25,236,41,13,83,8,75,101,50,136,58,169,74,72,66,
6,50,69,25,133,33,5,42,134,25,72,50,169,58,178,66,
85,50,42,17,227,8,65,17,33,17,2,17,99,17,195,33,
196,25,132,17,231,25,109,42,147,50,150,50,183,50,82,34,
243,57,243,49,182,50,57,51,127,59,126,59,248,50,48,26,
75,17,203,33,172,58,169,66,71,50,103,58,71,50,71,50,
41,42,112,58,140,58,71,50,72,58,39,50,104,58,137,66,
74,58,107,58,10,50,231,41,70,58,136,58,141,50,20,59,
215,42,29,51,95,59,127,59,93,59,24,51,242,50,208,58,
211,50,93,67,127,59,93,51,126,59,95,59,94,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,127,59,94,59,92,59,91,59,91,59,123,59,
63,59,127,59,125,59,125,59,126,59,127,59,95,59,94,51,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,158,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,126,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,157,67,
190,67,189,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
93,59,252,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,253,50,29,51,29,51,29,51,253,50,252,50,252,50,
250,50,251,50,253,50,255,50,255,50,254,50,253,50,28,59,
150,42,49,34,49,34,48,42,10,42,230,33,133,25,5,9,
5,9,68,17,196,33,229,41,230,41,133,33,68,25,164,33,
67,17,3,17,100,25,166,41,230,41,197,41,131,33,228,41,
196,41,4,50,165,33,107,33,52,50,182,66,174,66,134,58,
232,74,167,66,167,66,233,74,42,83,11,83,76,91,76,91,
76,83,11,75,169,66,136,58,168,66,232,74,232,74,166,66,
69,58,69,58,166,66,167,66,37,42,165,33,134,33,135,33,
199,33,199,33,231,33,6,42,229,41,165,41,198,41,8,50,
200,66,168,58,168,66,202,74,203,74,138,58,74,50,74,50,
138,66,135,66,40,83,9,83,136,74,202,74,13,83,48,91,
22,75,249,66,28,67,26,59,86,59,51,51,207,42,238,58,
209,50,21,59,217,50,247,66,238,66,167,74,232,90,42,99,
240,74,87,83,85,75,206,58,168,66,231,74,144,58,25,42,
48,50,238,41,14,42,141,58,201,58,100,50,35,50,38,58,
229,41,230,49,70,58,104,58,74,58,104,50,37,34,141,58,
186,91,113,50,202,33,103,50,37,50,164,33,132,25,228,25,
194,33,163,33,164,33,229,33,199,25,45,34,143,50,201,17,
105,33,45,50,78,42,76,34,241,50,121,67,59,67,211,50,
244,41,173,25,8,34,102,42,102,50,136,58,105,58,72,50,
70,50,40,50,196,33,164,33,72,58,134,66,168,74,138,74,
107,58,173,66,139,58,105,58,168,66,104,58,8,42,107,42,
181,42,27,51,94,59,126,59,94,59,59,59,247,58,181,58,
178,58,90,67,158,59,126,51,95,59,95,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
93,51,126,59,127,59,126,59,93,59,91,59,89,59,88,59,
62,59,126,67,125,59,93,59,126,59,127,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,67,126,67,126,59,126,59,126,59,
158,59,158,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,59,126,59,126,59,158,59,158,59,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,67,126,67,158,67,126,67,126,67,126,67,
126,59,126,59,158,67,158,67,126,59,126,59,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,191,67,
158,67,158,67,191,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
157,67,190,67,190,67,190,67,190,67,190,67,190,67,157,67,
189,67,189,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
94,59,252,50,253,50,253,50,253,50,253,50,253,50,29,51,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,42,253,50,253,50,29,51,29,51,29,51,253,50,253,50,
250,42,251,42,28,51,62,51,62,51,30,51,61,51,61,51,
27,51,215,42,117,42,115,42,112,50,46,42,237,33,236,33,
237,41,202,41,231,41,196,41,99,33,67,25,100,33,164,33,
133,33,4,17,228,16,69,25,199,41,39,50,230,49,38,58,
164,33,131,33,164,41,198,41,200,33,9,42,106,50,105,50,
167,66,102,58,134,58,9,83,9,75,135,66,168,66,233,74,
200,66,201,66,136,58,5,42,228,33,101,58,7,75,71,83,
134,66,166,66,231,74,198,66,37,42,132,25,134,33,200,41,
170,33,139,25,202,33,7,34,131,33,35,25,100,33,37,50,
38,42,38,50,70,50,102,50,104,58,106,58,108,58,110,58,
169,74,169,66,171,66,239,66,16,75,78,83,108,91,77,91,
112,75,52,67,26,59,253,58,62,59,252,58,118,42,147,42,
138,58,202,66,110,83,111,83,203,58,138,50,202,66,168,74,
13,91,109,91,45,75,174,66,170,74,231,74,205,58,208,42,
11,50,243,33,249,33,152,42,18,67,234,66,104,50,231,41,
167,33,39,50,199,66,42,83,109,91,43,75,38,34,164,25,
205,75,79,75,109,50,105,58,101,58,197,58,133,50,226,25,
228,41,197,41,132,33,131,25,70,17,203,33,45,42,136,17,
176,25,86,58,80,50,201,33,43,42,241,58,49,59,16,51,
174,50,237,33,174,33,237,41,41,50,135,58,102,50,37,42,
228,33,133,33,33,17,35,25,198,41,101,58,167,66,169,74,
172,66,201,66,168,58,72,50,71,58,4,50,198,41,109,58,
182,50,29,59,127,67,127,59,126,59,58,59,245,50,145,50,
178,66,52,67,122,59,127,59,95,59,94,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,94,59,94,59,126,59,93,59,91,59,57,51,55,51,
89,59,155,67,158,67,126,59,127,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
158,59,158,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,67,158,67,158,67,158,67,126,67,126,67,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,126,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
157,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
189,67,189,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
93,59,252,50,253,50,253,50,253,50,253,50,253,50,29,51,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,42,253,50,253,50,29,51,29,51,29,51,29,51,29,51,
28,43,28,43,59,51,90,51,58,51,58,51,59,51,60,51,
253,58,214,50,145,42,145,42,115,50,118,58,214,66,18,75,
78,58,202,41,199,33,197,41,132,33,133,33,101,33,69,25,
69,25,195,8,37,17,167,33,134,33,36,25,35,25,100,33,
68,25,68,33,197,41,228,41,131,25,132,17,166,25,231,41,
198,41,230,41,70,50,167,66,232,74,199,74,199,66,134,58,
102,58,167,58,167,58,5,50,195,33,36,50,231,74,104,91,
8,83,231,74,199,66,199,66,134,58,132,25,36,25,8,50,
235,41,14,42,77,50,7,42,99,25,3,25,36,25,98,25,
100,25,196,41,37,50,68,50,102,50,105,58,141,58,208,66,
170,66,138,58,111,50,247,66,22,75,174,58,140,66,112,74,
243,74,53,75,85,67,86,59,154,59,156,67,56,51,243,42,
46,42,234,41,105,66,234,82,9,75,234,66,235,66,73,83,
8,75,230,66,200,58,173,66,173,74,201,74,169,58,171,50,
141,33,22,34,217,42,20,43,174,50,204,66,12,67,165,42,
171,33,136,25,38,42,41,75,171,91,204,99,10,67,130,17,
2,51,42,67,75,50,40,42,226,33,66,42,132,50,68,42,
196,25,165,25,196,25,228,25,164,25,10,34,15,42,210,33,
55,26,115,42,46,34,139,25,170,33,114,50,215,58,247,50,
177,58,209,58,206,66,107,50,8,42,39,50,39,50,7,42,
199,41,104,33,4,17,36,25,132,33,37,58,136,66,232,74,
136,58,108,58,110,58,106,58,71,58,166,41,169,41,108,58,
145,42,249,58,95,59,127,59,127,59,123,59,53,59,207,50,
179,58,208,58,53,59,93,67,126,59,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,94,59,94,59,94,59,93,59,59,51,57,51,
21,51,57,59,93,59,127,59,127,59,126,59,125,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,67,126,67,126,67,126,59,126,59,126,67,126,67,126,67,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
126,59,126,59,126,67,126,67,126,67,126,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,190,67,190,67,190,67,
189,67,189,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
94,59,252,50,252,50,253,50,253,50,253,50,252,50,253,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
253,50,253,50,253,50,29,51,29,51,29,51,29,51,29,51,
62,51,28,51,25,51,247,50,213,50,180,42,213,50,214,50,
213,50,144,42,143,42,143,50,45,42,13,42,47,50,205,33,
166,33,37,17,37,17,166,33,72,58,105,58,232,41,103,25,
4,17,199,41,105,58,105,58,166,33,100,25,100,25,3,17,
227,8,68,25,133,41,101,33,102,25,102,25,69,17,68,25,
233,49,105,58,137,66,168,66,200,74,8,75,8,75,134,66,
134,58,134,58,200,74,103,58,196,41,131,33,4,50,166,66,
200,74,167,66,199,66,8,75,9,75,103,58,99,25,67,25,
102,25,169,33,201,33,198,33,165,33,166,41,68,33,226,8,
3,17,132,33,37,50,134,58,200,66,202,66,171,58,238,74,
41,42,41,42,174,50,244,66,177,50,43,34,77,50,147,74,
213,66,57,75,250,66,247,50,85,59,84,59,243,50,177,50,
244,58,176,58,108,58,171,66,204,74,78,58,77,50,202,66,
201,58,136,58,169,58,203,66,174,74,207,74,238,66,178,58,
26,42,219,58,144,34,234,17,235,33,79,50,177,58,43,59,
174,58,15,42,233,33,135,50,232,66,106,83,107,83,227,33,
130,42,200,58,138,50,202,58,5,34,130,17,4,34,135,58,
67,34,195,25,197,25,197,33,99,17,5,34,234,33,239,41,
184,42,184,50,111,50,42,42,10,42,112,58,208,58,50,67,
49,75,240,66,141,58,106,50,71,50,230,41,231,41,41,50,
74,58,136,33,4,17,102,33,165,41,102,58,136,66,136,66,
104,58,76,58,176,66,175,66,140,66,7,50,8,50,172,66,
177,50,250,58,95,67,127,59,127,59,124,59,53,59,206,50,
178,58,175,58,176,58,247,58,93,59,127,51,126,51,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,94,59,95,59,94,59,93,59,91,51,
247,50,248,50,59,51,126,59,127,59,94,59,126,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,126,67,126,67,126,59,126,59,126,67,126,67,158,67,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
158,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,126,67,126,67,126,67,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
191,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
189,67,189,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
94,59,252,50,252,50,253,50,253,50,253,50,252,50,252,50,
253,50,253,50,253,50,253,50,253,50,253,50,253,50,253,50,
29,51,29,51,29,51,253,50,253,50,253,50,29,51,29,51,
252,50,219,42,217,50,214,58,147,50,113,50,112,50,144,42,
44,34,232,25,10,34,45,50,200,33,37,34,135,50,230,33,
230,33,199,33,168,33,201,41,8,42,230,33,132,25,165,25,
69,25,40,50,104,58,39,42,229,33,197,33,230,41,165,41,
98,25,132,33,133,41,68,33,67,25,100,25,69,25,104,33,
44,58,140,74,236,82,234,74,135,66,70,58,199,74,41,83,
8,75,167,66,201,74,201,74,39,58,165,41,164,41,37,58,
5,50,167,66,73,83,199,66,134,58,167,66,37,50,33,17,
229,16,229,8,5,9,167,33,104,58,168,74,70,58,196,33,
165,41,164,41,164,41,228,41,70,58,104,58,105,58,203,66,
208,66,209,66,18,75,143,58,12,42,141,58,240,66,208,66,
184,50,60,67,28,59,24,59,53,67,242,58,175,66,141,66,
235,74,47,75,17,67,238,58,171,58,177,66,24,75,246,58,
176,66,203,74,233,74,7,75,11,67,53,75,89,75,215,58,
93,59,87,67,139,50,170,33,141,33,112,50,21,67,178,50,
236,58,55,83,176,58,231,33,229,33,101,50,7,67,68,42,
66,42,166,58,104,50,236,58,8,34,100,9,195,25,100,50,
136,50,196,33,163,33,100,33,34,25,4,50,228,41,133,25,
9,34,106,42,230,33,201,41,105,58,171,66,72,50,40,42,
79,50,173,58,170,58,136,58,137,58,73,50,8,42,232,41,
36,17,2,17,131,33,41,58,39,58,133,66,103,58,41,58,
135,66,38,50,104,42,137,50,202,66,135,58,72,58,74,58,
240,66,57,67,126,67,158,59,127,59,95,59,249,58,148,50,
210,50,176,58,142,58,178,58,92,59,159,51,126,51,126,67,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,59,126,59,127,59,127,59,127,59,126,59,
59,67,26,59,91,59,157,59,127,59,95,59,126,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,159,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,67,126,67,126,67,126,59,126,59,126,67,126,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,126,67,126,67,126,59,126,59,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
158,67,158,67,126,59,126,59,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,67,126,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,190,67,190,67,190,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
191,67,191,67,158,67,158,67,158,67,158,67,158,67,158,67,
191,67,191,67,191,67,158,67,158,67,158,67,158,67,191,67,
158,67,158,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,158,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,157,67,190,67,222,75,
190,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
93,59,253,50,253,50,253,50,253,50,29,51,29,51,30,51,
29,51,29,51,253,50,253,50,29,51,29,51,29,51,29,51,
254,50,253,50,253,50,29,43,29,43,29,51,61,51,61,51,
29,51,29,51,220,42,218,50,182,50,19,34,211,17,119,34,
48,50,203,33,170,33,12,42,41,50,104,50,171,66,140,58,
40,50,231,41,39,50,5,50,99,33,162,16,163,16,227,24,
70,17,101,33,198,41,71,58,135,58,70,50,38,50,104,74,
6,50,197,41,132,33,100,33,35,25,3,17,68,25,231,49,
237,74,235,74,201,66,199,66,167,66,134,66,232,74,167,74,
232,66,8,75,41,83,199,74,167,66,70,58,5,50,229,49,
196,41,37,50,102,58,69,58,102,58,199,66,167,66,70,50,
8,50,204,41,173,41,168,33,164,33,229,49,103,58,167,58,
71,66,70,58,70,58,70,58,38,50,6,42,136,66,202,74,
235,74,12,83,202,74,107,58,77,58,141,66,205,66,175,66,
20,67,246,66,22,67,85,67,51,67,50,67,82,83,47,75,
135,58,169,66,111,58,244,66,49,67,176,50,248,58,123,51,
214,58,207,58,138,58,136,66,105,91,73,83,46,83,49,83,
122,75,211,50,209,50,147,50,54,42,152,50,122,67,23,51,
145,42,207,50,143,83,103,50,68,50,36,50,101,58,69,58,
36,50,133,58,8,67,167,50,38,34,164,25,131,25,195,33,
231,58,37,42,197,33,100,25,34,17,229,33,38,50,230,41,
7,50,201,33,201,33,105,25,200,41,169,74,171,74,232,66,
43,50,232,41,39,50,38,42,103,58,104,58,73,50,168,33,
168,49,231,49,229,41,230,41,231,49,39,58,6,42,37,42,
6,50,197,41,165,33,38,58,167,74,102,66,70,58,39,58,
144,58,25,67,91,59,191,59,125,59,95,67,124,67,251,50,
152,42,149,50,112,42,241,50,57,59,126,59,156,59,159,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,94,59,126,59,126,59,126,59,126,59,126,59,94,59,
214,50,56,59,53,59,28,51,159,59,158,51,189,59,156,59,
94,59,94,59,126,59,126,59,126,51,126,59,126,59,94,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,59,158,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,126,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,67,126,67,126,67,126,67,
158,59,158,67,158,59,126,59,126,59,158,59,126,59,126,59,
126,59,158,67,158,67,158,67,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,158,59,158,59,158,67,158,67,158,67,158,67,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
191,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,158,67,158,67,190,67,190,67,158,67,158,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,190,75,190,67,190,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,75,190,67,190,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,75,190,75,190,67,190,67,
189,67,189,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,190,67,190,67,190,67,190,67,190,75,190,67,
189,67,189,67,190,67,190,67,190,67,190,67,189,67,189,67,
93,59,252,50,253,50,253,50,253,50,29,51,29,51,30,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
253,50,253,50,29,51,30,51,29,51,29,43,252,50,252,50,
252,50,28,51,252,50,219,50,187,58,90,50,89,42,219,58,
185,58,114,42,43,42,8,42,232,49,199,41,7,50,137,66,
135,58,6,42,197,33,130,25,66,25,3,25,3,17,35,25,
232,41,166,41,133,41,230,49,135,58,168,66,135,66,71,66,
103,66,70,58,229,49,132,33,2,17,194,16,36,25,166,41,
74,50,73,50,168,66,102,58,37,50,5,50,134,66,167,66,
167,66,232,74,8,75,199,66,167,66,70,58,38,50,6,50,
131,33,228,41,102,58,167,66,199,66,167,66,199,66,200,74,
104,66,237,74,79,83,171,66,229,41,163,33,228,41,5,42,
136,66,135,66,200,74,168,66,38,50,6,50,136,66,234,82,
168,66,168,66,200,74,11,83,13,83,11,75,10,75,204,66,
203,66,45,75,14,67,207,58,143,50,141,50,171,58,138,58,
136,58,137,66,106,58,204,66,11,67,204,66,242,66,55,51,
209,50,170,50,169,66,12,83,43,83,10,75,44,83,43,83,
79,67,239,58,47,67,13,67,176,58,116,50,211,58,238,50,
142,42,108,42,138,50,164,25,3,42,100,58,165,66,101,58,
36,42,100,50,40,75,199,58,70,42,164,25,131,17,195,25,
134,50,37,34,132,25,100,25,99,17,196,33,197,33,197,33,
8,42,232,33,168,17,77,17,112,33,13,50,171,58,9,67,
105,50,230,33,165,25,100,17,198,33,72,42,169,58,136,58,
234,49,73,58,6,42,229,41,197,41,198,41,198,33,40,42,
229,41,165,33,133,33,6,50,39,50,6,50,40,50,41,58,
114,58,25,67,90,59,127,59,94,51,127,67,124,67,219,42,
247,58,214,58,116,50,213,50,251,58,95,59,125,59,157,59,
157,59,125,59,126,59,127,59,127,59,126,59,125,59,157,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,94,59,
60,59,244,50,238,42,247,50,127,67,127,51,93,51,63,59,
126,67,94,59,126,59,126,59,126,51,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,59,158,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,126,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,67,126,67,126,67,126,67,126,67,
126,59,158,59,158,59,126,59,126,59,158,59,158,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,158,67,158,67,190,67,190,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
159,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,190,67,190,67,190,67,190,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
189,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
189,67,190,67,190,67,190,67,190,67,190,67,190,67,189,67,
93,59,252,50,253,50,253,50,29,51,28,51,29,51,30,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,30,51,29,51,29,51,29,51,
30,51,62,51,28,43,251,42,219,42,185,42,151,42,182,42,
180,34,181,42,145,42,137,25,40,25,135,33,197,41,6,50,
40,50,9,50,232,49,133,33,99,25,100,25,68,25,99,25,
68,17,100,25,133,33,100,33,132,33,5,42,103,58,135,66,
102,66,37,50,37,50,70,58,197,41,67,25,100,33,198,41,
166,25,68,17,132,25,164,33,6,50,70,58,37,50,36,50,
134,58,167,66,232,74,231,74,232,74,134,58,38,50,5,50,
70,58,69,50,69,50,166,66,231,74,198,66,134,66,134,66,
4,50,134,58,201,66,169,66,103,58,134,58,102,58,37,42,
70,58,134,58,200,66,134,58,102,58,168,66,168,66,136,74,
232,74,167,66,134,66,232,74,10,83,232,74,231,74,201,66,
169,66,44,83,17,75,182,66,119,50,50,42,44,34,74,34,
42,50,105,66,168,66,39,75,104,83,9,83,139,66,144,50,
210,58,204,58,201,66,10,83,202,74,202,66,11,75,42,83,
201,66,39,75,137,83,11,67,141,58,43,42,199,25,166,17,
9,34,232,33,230,33,66,9,129,25,3,42,165,58,39,75,
133,58,67,42,7,75,166,58,70,42,228,33,195,25,195,25,
36,34,37,42,99,17,67,17,132,25,196,33,164,33,132,25,
167,25,105,17,75,17,176,25,57,50,185,58,174,58,168,50,
169,66,138,58,74,50,9,42,231,41,198,33,72,50,105,58,
136,33,199,33,67,9,163,25,228,41,164,41,165,33,38,42,
38,50,165,33,166,33,7,50,7,50,8,50,107,66,172,74,
115,58,23,67,57,59,94,59,95,59,127,59,156,59,29,51,
211,42,146,42,178,50,242,58,248,58,127,67,127,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,22,51,241,58,242,58,92,67,126,59,125,59,127,67,
126,67,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,158,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,59,158,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,126,59,126,59,126,59,126,59,158,59,158,59,158,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,67,126,67,126,67,126,67,126,67,158,67,158,67,158,67,
126,59,158,59,158,59,158,59,158,59,158,67,158,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,191,67,191,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,158,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,222,75,222,75,190,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
125,59,253,50,253,50,253,50,29,51,28,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,43,29,51,29,51,29,51,28,51,
60,43,61,43,93,43,60,43,27,43,251,42,187,50,187,50,
218,50,56,34,53,34,18,26,209,33,17,50,172,41,38,33,
69,33,201,49,43,58,40,58,230,49,165,33,68,25,66,25,
67,25,35,25,3,17,195,16,3,17,197,41,135,66,167,66,
199,74,102,58,134,66,167,66,38,50,132,33,165,41,7,50,
230,33,132,25,67,25,34,17,230,49,71,58,70,58,166,66,
167,66,167,66,231,74,41,83,106,91,232,74,167,66,103,58,
8,75,167,66,4,50,36,50,134,66,198,66,166,66,101,58,
3,42,3,42,68,50,167,58,200,74,200,66,135,58,102,58,
4,42,102,58,167,66,102,50,134,58,233,82,168,74,201,82,
232,74,71,58,6,50,103,66,169,74,232,74,232,74,137,58,
104,58,170,66,239,66,23,75,29,75,220,58,217,50,182,42,
142,58,138,66,168,74,166,58,166,66,102,66,199,49,10,50,
150,58,241,74,139,66,137,66,135,66,168,66,137,66,232,74,
232,74,72,83,201,91,41,67,203,58,139,50,199,33,101,25,
134,25,166,25,197,33,131,25,65,17,65,17,194,33,165,58,
164,58,34,42,229,66,101,50,37,42,196,25,227,25,194,25,
227,25,102,50,131,25,34,17,131,25,228,33,196,33,99,17,
102,17,40,17,140,25,173,25,152,42,59,67,140,42,103,50,
137,58,234,74,169,66,136,66,71,58,231,41,105,58,139,74,
46,50,12,42,135,17,198,33,231,41,103,33,134,33,5,42,
164,33,35,17,100,25,198,41,166,33,231,41,138,66,172,66,
178,58,245,58,22,59,124,59,127,67,127,59,125,59,126,59,
217,50,117,42,147,50,175,50,211,50,94,67,127,59,159,59,
127,59,126,59,126,59,157,59,157,59,126,59,126,59,127,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
60,43,213,50,179,66,176,58,27,59,127,59,126,59,127,67,
126,67,125,59,125,59,125,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,126,59,126,59,158,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,59,158,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,59,158,59,158,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
126,59,158,59,158,59,158,59,158,59,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,67,158,67,158,67,190,67,158,67,158,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,191,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,191,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
157,67,190,67,190,75,190,75,190,67,190,67,190,67,190,75,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
125,59,29,51,253,50,253,50,29,51,29,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
252,50,29,51,29,51,29,51,29,51,28,51,251,42,186,42,
60,59,28,59,91,59,58,51,247,42,212,42,145,42,144,42,
117,50,120,50,61,67,27,51,182,42,244,58,143,58,199,41,
70,58,137,66,138,74,136,66,103,66,39,58,198,41,198,41,
164,41,132,33,100,25,68,25,101,33,230,49,38,58,4,50,
70,58,102,58,167,66,135,66,229,49,164,41,197,41,7,50,
38,42,103,58,229,41,99,33,6,50,38,50,5,50,101,58,
167,66,134,58,102,58,167,66,8,75,167,66,167,66,167,66,
166,66,199,74,134,58,101,58,101,58,101,58,133,58,133,58,
68,50,196,33,37,50,199,74,232,74,72,58,230,41,100,58,
37,50,196,41,37,50,69,50,69,50,134,66,103,66,201,82,
135,58,40,58,7,50,38,58,136,66,233,74,233,74,105,58,
5,50,38,50,137,58,14,67,84,67,120,75,153,75,118,67,
14,75,201,74,169,66,73,50,38,42,197,41,102,41,38,50,
173,58,237,74,106,58,106,66,202,74,203,66,74,58,137,66,
9,83,43,83,171,91,169,75,41,67,237,66,75,50,232,41,
165,33,165,33,132,25,132,25,66,17,66,17,130,25,69,50,
132,50,99,50,103,83,7,75,101,50,195,33,4,34,3,26,
227,33,134,50,164,25,34,17,66,17,164,33,229,33,132,25,
6,9,5,17,103,25,104,17,239,25,143,42,5,26,232,41,
48,42,175,58,140,50,107,50,76,50,236,49,44,50,43,58,
233,33,203,33,236,33,42,42,198,41,36,25,132,33,4,42,
132,25,3,17,68,25,198,41,230,41,71,50,169,66,202,66,
239,66,210,58,244,58,55,59,126,67,127,59,159,59,158,59,
179,34,81,34,146,50,175,50,211,50,93,67,126,59,125,59,
127,59,127,59,127,59,127,59,127,59,127,59,127,59,127,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,158,59,
124,59,208,42,172,58,206,66,59,75,159,67,157,51,95,51,
126,59,125,59,124,59,124,59,125,59,126,59,126,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,158,59,158,59,
158,59,158,59,126,59,126,59,158,59,158,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,158,59,158,59,158,59,158,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,126,59,126,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,67,158,67,158,67,190,67,158,67,158,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,191,67,191,67,158,67,158,67,158,67,158,67,
191,67,191,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,75,222,75,190,67,190,67,190,67,
125,59,28,51,253,50,253,50,29,51,28,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
28,51,29,51,29,51,29,51,28,51,28,51,250,50,217,42,
211,58,111,42,110,42,79,42,113,50,112,50,234,41,197,33,
231,33,12,34,215,50,58,59,210,34,11,18,168,25,71,50,
139,66,109,66,76,58,106,66,103,66,39,58,40,58,72,66,
37,50,5,50,230,41,7,50,72,58,136,74,70,58,228,41,
5,50,5,50,70,58,135,66,103,66,5,50,197,41,165,41,
197,33,103,58,70,50,229,41,201,74,10,83,136,66,69,50,
37,50,37,50,228,41,36,50,134,58,101,58,167,66,200,66,
69,50,134,66,166,66,167,66,37,50,195,41,68,50,166,66,
134,58,198,41,7,50,166,66,166,66,6,42,100,25,227,41,
5,50,164,33,37,50,102,58,37,50,102,58,135,66,135,66,
38,50,73,58,72,58,70,58,102,66,167,66,168,66,72,58,
164,49,197,49,38,58,200,66,235,74,14,67,46,75,11,59,
170,58,165,58,104,66,74,50,71,50,6,50,230,49,165,66,
197,58,166,66,103,66,202,74,44,83,205,66,109,58,139,66,
236,82,9,83,137,83,12,92,138,75,9,67,104,50,200,41,
6,42,39,50,39,42,197,33,35,17,1,9,33,17,195,33,
99,50,164,58,135,83,104,83,133,50,227,25,228,33,195,25,
3,34,102,50,196,33,67,17,34,17,131,25,196,33,196,33,
40,17,105,25,104,25,199,33,200,25,135,17,167,25,205,41,
91,34,29,67,251,58,247,66,19,67,206,58,107,50,42,42,
166,25,172,33,50,50,78,58,199,41,68,25,101,25,101,25,
100,25,3,17,36,17,101,25,165,33,38,50,135,66,200,66,
204,58,239,66,209,58,210,50,59,59,159,59,159,59,157,51,
59,59,215,58,183,66,147,58,181,58,61,67,159,67,158,59,
157,59,126,59,127,59,127,59,127,59,127,59,126,59,157,59,
126,59,158,59,126,59,126,59,126,59,126,59,126,59,158,59,
251,42,146,34,77,42,108,42,211,58,90,59,190,59,159,51,
126,59,124,59,123,59,124,59,125,67,126,67,126,59,125,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,126,59,126,59,126,59,126,59,
126,59,126,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,126,59,126,59,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,59,158,59,158,67,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,191,67,191,67,158,67,158,67,158,67,158,67,
191,67,191,67,191,67,191,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,158,67,190,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,190,75,190,75,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,75,222,75,190,67,190,67,190,67,
125,59,29,51,253,50,29,51,29,51,28,51,28,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,61,51,29,51,29,43,28,51,59,59,58,59,24,51,
210,50,77,42,9,42,233,41,45,50,78,58,170,41,134,33,
233,49,41,50,75,42,77,42,110,42,12,34,106,25,73,25,
178,33,243,41,114,50,207,66,170,66,71,58,103,66,136,66,
135,74,168,74,135,58,229,41,165,41,165,49,197,41,228,41,
197,41,100,33,99,33,5,50,103,66,38,58,5,50,71,58,
6,50,70,50,102,58,37,50,136,66,169,66,38,50,5,50,
134,66,134,66,69,50,36,50,134,58,134,58,167,66,102,50,
69,50,37,50,37,50,70,58,196,41,130,33,37,50,166,66,
69,50,230,49,39,58,69,58,101,50,70,50,197,41,228,49,
99,33,229,49,167,66,167,66,70,50,102,58,135,66,70,50,
231,41,76,58,107,66,168,66,167,74,135,66,135,66,136,66,
73,66,230,57,196,49,37,58,70,58,40,50,108,58,174,74,
104,50,36,50,5,58,7,50,38,42,37,50,71,58,167,66,
72,58,38,58,70,58,168,74,200,66,106,50,140,58,170,58,
10,83,41,83,105,83,44,108,11,100,137,83,231,66,37,42,
132,25,197,33,70,50,103,50,196,33,225,8,225,8,34,25,
67,50,196,66,70,75,136,75,165,50,228,25,4,34,195,33,
3,34,101,50,196,33,66,17,98,25,196,33,196,33,197,33,
202,33,46,50,12,42,9,42,101,25,229,8,173,33,81,50,
30,51,223,75,124,75,21,59,46,67,74,75,199,58,200,66,
134,58,43,50,78,50,201,33,132,33,132,33,100,25,35,17,
68,25,68,25,69,25,36,25,132,33,6,50,71,58,168,66,
237,66,238,66,175,66,112,50,251,58,158,59,159,59,125,51,
57,59,19,59,210,58,177,58,19,67,59,67,127,67,127,59,
158,67,125,59,125,59,125,59,125,59,125,59,125,59,158,67,
126,59,158,59,126,59,126,59,126,59,126,59,126,59,158,59,
95,59,252,50,184,50,116,42,145,50,182,50,95,67,159,59,
126,59,124,59,90,59,91,59,125,67,126,67,126,59,157,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,126,59,126,59,126,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,126,67,126,67,126,67,
158,67,158,59,158,59,158,67,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,59,158,59,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,191,67,191,67,158,67,158,67,158,67,158,67,
191,67,191,67,191,67,191,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,190,75,190,75,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,190,75,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
125,59,29,51,29,51,29,51,29,51,28,51,28,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
29,51,29,51,61,51,29,51,60,51,91,59,57,51,247,50,
216,50,211,58,205,66,136,58,135,50,168,50,71,42,71,50,
42,58,75,58,41,50,9,50,44,58,42,50,233,41,139,33,
118,42,151,50,213,58,16,67,201,58,134,58,135,66,135,66,
10,91,233,74,70,50,164,33,197,49,6,58,197,41,99,25,
35,25,2,17,193,8,1,17,99,33,99,33,131,33,5,50,
136,58,5,42,134,66,102,66,103,66,38,50,164,33,196,33,
37,50,69,58,195,41,162,33,69,50,134,58,199,66,4,42,
228,41,5,50,70,58,168,66,37,50,163,33,228,41,4,42,
36,42,38,58,38,58,229,49,69,50,166,58,228,41,68,33,
165,49,136,66,200,74,200,74,9,75,232,74,168,66,70,58,
140,58,144,66,110,66,137,66,168,66,102,58,167,66,42,83,
202,74,38,50,165,33,73,58,106,66,230,41,230,41,139,66,
138,66,40,66,5,58,37,50,5,42,36,50,38,58,7,50,
39,58,37,58,102,66,102,58,72,50,204,33,79,50,172,58,
8,83,41,91,232,74,138,91,202,99,233,99,104,83,132,58,
6,42,67,17,163,25,101,50,102,50,98,25,1,17,1,17,
128,33,164,58,37,67,135,75,100,34,163,17,196,33,163,33,
226,33,101,50,196,33,34,17,163,33,102,58,229,41,196,33,
232,33,233,25,232,25,103,25,4,17,35,25,139,25,239,33,
184,42,54,59,174,42,232,25,8,34,170,66,137,66,169,74,
232,74,138,58,138,58,132,25,132,33,200,41,135,33,100,25,
68,25,166,41,199,41,167,41,7,50,72,58,72,58,202,74,
239,74,237,74,142,66,80,50,252,58,125,59,158,59,126,59,
55,51,17,51,144,50,111,50,242,58,24,59,125,67,126,59,
127,67,126,59,155,59,153,59,153,59,155,59,126,59,127,67,
126,59,159,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,90,43,55,43,218,58,211,58,116,50,28,67,156,59,
158,59,124,59,90,59,90,59,125,67,158,67,126,59,157,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,158,59,158,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,158,59,158,59,158,59,158,59,
126,59,158,59,158,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
126,59,126,59,126,59,126,59,126,59,126,59,126,59,126,59,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,126,59,126,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,67,158,67,158,67,158,59,158,59,158,59,
158,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,126,67,126,67,126,67,126,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,59,158,59,158,59,158,59,158,67,158,67,
158,67,158,67,158,67,191,67,191,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,191,67,191,67,191,67,191,67,191,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,190,67,190,67,158,67,158,67,190,67,191,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,75,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,222,67,222,75,
190,67,190,67,190,75,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,222,75,222,75,190,75,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,189,67,189,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
157,67,190,67,222,75,222,75,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,189,67,189,67,189,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,190,75,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
126,59,29,51,253,42,61,51,28,43,28,51,61,51,29,51,
29,51,29,51,29,51,29,51,29,51,29,51,29,51,29,51,
30,43,31,51,30,51,59,59,88,59,245,50,181,42,25,59,
250,58,246,50,210,58,140,66,75,58,107,50,167,58,104,66,
103,58,103,58,6,50,70,58,136,66,104,58,136,66,137,58,
10,34,202,33,202,41,43,58,138,66,168,66,102,58,37,50,
5,50,103,58,103,58,229,41,70,58,103,58,3,17,226,16,
3,25,227,24,194,16,161,16,194,16,3,33,68,33,100,41,
5,50,37,58,102,58,167,74,167,66,102,58,38,50,229,41,
229,49,197,41,99,33,99,33,196,41,5,50,102,58,199,74,
102,58,4,42,36,42,199,66,166,58,102,58,5,58,37,58,
37,50,4,42,102,58,134,66,102,58,134,58,135,58,131,25,
67,25,99,33,229,41,38,50,168,66,168,66,103,66,103,66,
13,75,238,74,204,74,135,58,101,50,102,50,135,66,200,74,
169,74,135,66,37,50,38,50,40,58,8,50,39,50,200,74,
41,83,9,75,41,83,167,66,70,58,196,41,5,58,168,74,
231,74,166,66,167,74,38,58,7,50,200,41,234,49,206,82,
75,91,139,99,74,83,8,67,105,83,234,107,168,99,229,74,
162,33,132,33,35,17,35,17,38,50,131,33,1,9,2,9,
32,9,68,50,164,50,6,59,100,42,130,17,130,25,228,33,
194,33,133,58,130,25,98,17,38,42,229,41,131,25,229,41,
232,33,234,33,106,25,231,8,228,8,226,16,69,25,10,42,
119,34,216,58,15,34,38,9,102,25,41,50,104,58,168,58,
167,66,233,74,201,66,73,50,9,42,232,41,232,41,232,41,
7,50,104,58,136,58,170,66,136,58,102,58,135,66,105,74,
170,74,170,74,108,58,213,58,95,67,127,59,159,59,126,59,
213,50,143,42,148,50,217,74,180,50,214,42,127,59,126,51,
127,51,157,59,118,67,50,67,49,75,111,83,111,75,83,75,
119,59,95,67,124,59,95,59,126,59,126,59,159,59,157,59,
21,51,145,42,79,34,15,59,14,59,114,58,251,66,190,59,
127,67,155,59,24,43,58,59,217,50,157,59,223,59,156,59,
157,59,159,59,158,59,127,67,126,59,189,67,94,59,158,59,
126,59,126,59,126,59,158,59,158,59,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,158,59,158,59,158,59,158,59,158,59,158,59,126,59,
126,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,126,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,67,158,59,126,59,
158,67,158,59,158,59,158,59,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,67,158,67,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,191,67,158,67,
158,59,158,67,158,67,158,67,158,67,158,67,158,67,158,59,
158,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,59,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,191,67,191,67,158,67,158,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,75,222,75,190,75,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,75,190,75,
222,75,222,75,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,222,75,222,75,190,67,190,67,190,75,222,75,190,75,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,75,190,75,222,75,222,75,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
222,75,222,75,222,75,190,67,190,67,190,67,190,67,222,75,
190,67,190,67,190,67,190,75,190,75,190,67,190,67,190,67,
190,67,190,67,222,75,222,75,190,67,190,67,189,67,189,67,
190,67,222,75,222,75,222,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,189,67,189,67,189,67,189,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,222,75,222,75,190,67,190,67,
126,59,29,51,29,43,29,51,28,43,28,43,29,51,253,50,
29,51,29,51,29,51,29,51,29,51,61,51,29,51,29,51,
60,51,92,51,91,59,57,59,246,58,215,50,185,50,155,50,
246,50,148,34,117,42,86,50,183,66,20,67,106,50,39,50,
169,66,72,50,39,50,202,74,11,83,72,58,231,49,72,58,
198,33,198,33,7,50,104,58,103,58,37,50,5,42,197,33,
67,25,164,33,5,50,196,41,229,41,71,58,35,25,3,25,
166,41,100,33,3,25,226,16,226,16,226,16,3,25,3,25,
35,25,164,41,6,50,70,58,37,50,70,50,135,58,38,50,
131,33,196,41,229,49,5,50,5,50,69,58,70,58,69,58,
134,66,232,74,232,66,8,75,167,58,69,58,228,49,4,58,
131,33,99,25,196,41,196,41,229,49,70,50,103,58,229,33,
2,17,35,25,164,33,196,33,70,58,135,58,135,66,135,66,
201,66,234,74,11,83,200,66,39,50,8,42,42,58,73,66,
135,66,233,82,233,74,168,74,169,74,137,66,39,58,71,58,
102,58,135,58,9,75,200,74,167,66,37,58,37,58,135,74,
167,74,199,74,41,91,232,82,233,74,104,58,231,49,41,58,
42,83,107,91,106,83,8,75,7,67,72,83,201,107,42,116,
166,66,1,17,193,8,35,17,67,25,131,33,1,9,34,17,
131,25,194,33,132,42,39,67,100,42,163,25,163,25,163,25,
227,33,36,42,163,25,196,33,164,33,66,17,164,33,69,50,
5,42,135,25,107,25,172,33,104,33,35,17,101,25,9,42,
203,9,52,42,88,50,245,41,144,33,203,41,103,58,198,66,
231,74,231,66,200,66,168,58,105,58,40,50,231,41,231,41,
73,58,168,58,168,66,201,66,168,66,135,58,138,66,77,66,
139,58,139,58,143,50,247,58,126,67,127,59,126,59,125,59,
185,50,181,50,141,42,178,58,248,66,55,59,123,59,191,59,
127,59,126,59,89,59,54,59,54,67,81,67,75,67,42,67,
42,59,19,59,124,67,191,67,126,59,127,59,157,67,218,42,
181,34,145,50,79,50,143,50,206,50,176,50,25,59,159,59,
126,59,126,59,26,51,53,67,23,59,95,67,127,59,125,59,
124,59,159,67,158,59,159,67,126,67,157,59,127,59,126,59,
126,59,126,59,158,59,158,59,158,59,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,158,59,158,59,158,59,158,59,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
159,67,158,67,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,67,158,67,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,191,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,190,67,190,67,158,67,158,67,190,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,75,190,75,190,75,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,190,75,190,67,190,67,190,67,190,67,190,75,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
222,75,222,75,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,222,75,190,75,190,67,190,67,190,75,190,75,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,75,190,75,222,75,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
222,75,222,75,222,75,190,67,190,67,190,67,190,67,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,75,222,75,222,75,190,67,189,67,189,67,
190,67,222,75,222,75,222,75,190,67,190,67,190,67,190,67,
190,67,190,67,222,75,190,67,190,67,189,67,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,222,75,222,75,190,67,190,67,
93,59,29,51,253,50,30,51,29,43,28,51,29,51,29,51,
29,51,29,51,29,51,29,51,29,51,61,51,29,51,29,51,
60,51,60,59,59,59,217,50,118,42,214,50,55,67,245,58,
186,42,216,50,183,42,185,42,25,59,212,50,15,42,45,50,
106,58,41,50,41,50,138,66,170,74,39,58,133,33,198,41,
196,33,196,33,5,50,37,50,228,41,228,41,229,41,198,33,
197,41,6,50,103,58,197,41,67,25,100,33,3,17,36,25,
35,25,3,17,226,8,226,8,3,25,36,25,35,25,3,17,
195,16,68,33,166,41,197,41,164,33,6,50,136,58,71,58,
196,41,196,41,228,41,163,33,131,33,5,50,102,58,37,50,
4,50,199,66,199,66,166,58,166,58,102,58,4,50,37,58,
6,50,99,25,99,33,67,25,197,41,71,58,104,58,39,50,
99,33,132,33,229,41,196,33,197,41,196,41,229,49,38,58,
136,58,137,66,202,74,201,66,105,58,140,66,140,66,73,66,
137,66,105,66,8,50,231,49,39,58,39,58,39,50,71,58,
102,58,167,66,200,74,103,66,70,58,37,50,102,58,200,74,
9,83,9,83,73,91,41,83,73,91,41,83,232,74,41,83,
167,66,232,74,41,75,40,67,40,75,40,75,137,91,11,108,
75,116,36,50,192,8,226,8,161,8,2,17,193,8,225,16,
131,25,36,42,6,67,71,67,101,42,163,17,130,17,163,25,
227,33,228,33,163,25,196,33,99,25,131,25,69,50,102,58,
69,50,167,25,171,33,236,41,103,33,68,25,133,33,168,33,
45,34,51,42,182,58,114,50,13,34,106,50,135,66,6,58,
68,50,166,66,199,66,199,66,167,66,135,58,6,50,133,33,
198,33,229,33,5,42,135,58,169,58,137,58,140,58,176,66,
145,42,178,50,213,58,59,67,127,67,127,59,158,59,125,59,
61,67,25,59,209,50,178,58,215,66,249,58,28,51,127,59,
126,67,95,59,94,51,125,51,125,59,56,59,16,59,202,58,
235,74,235,58,239,50,28,59,127,59,186,59,125,67,93,59,
63,59,18,67,203,66,143,58,146,50,147,42,214,42,124,59,
157,59,159,67,60,59,16,59,19,67,63,67,127,59,124,59,
58,51,158,67,125,59,127,67,158,59,125,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,126,59,126,59,
126,59,126,59,158,59,158,59,158,59,158,59,158,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
191,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,67,158,67,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,59,158,59,
158,59,158,59,158,67,158,59,158,59,158,67,158,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,59,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,190,67,190,67,158,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,75,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,190,67,190,67,
222,75,222,75,222,75,190,75,190,75,190,67,190,75,190,75,
222,67,222,67,222,67,222,75,222,75,222,67,190,67,190,67,
222,75,190,75,190,75,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
222,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,75,222,75,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,75,190,67,222,75,222,75,222,75,222,75,222,75,189,67,
190,67,222,75,222,75,222,75,190,67,190,67,190,67,190,67,
190,67,222,75,222,75,222,75,190,67,190,67,190,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,190,67,190,67,190,67,190,67,222,75,222,75,
190,67,190,67,190,67,190,67,222,75,222,75,190,67,190,67,
93,67,29,51,253,50,30,51,29,43,28,51,61,51,29,51,
29,51,29,51,29,51,29,51,29,51,61,51,29,51,29,51,
30,51,30,51,61,59,252,58,154,42,249,58,54,67,210,50,
187,42,25,59,213,50,248,50,212,42,236,33,14,42,172,58,
233,33,233,33,200,41,199,41,40,58,104,66,198,41,133,33,
100,33,68,25,101,33,100,33,99,25,5,42,103,58,71,50,
39,50,6,50,197,41,132,33,226,16,226,16,194,16,3,17,
161,8,162,8,162,8,194,8,3,17,36,25,36,25,194,16,
195,16,36,25,68,33,100,33,164,41,6,50,103,58,103,58,
70,58,167,66,200,74,102,58,228,41,37,50,135,66,167,66,
102,66,232,74,166,66,101,50,134,58,69,58,37,50,102,66,
71,58,164,33,229,41,229,41,6,50,38,50,197,33,68,25,
132,33,164,41,6,50,229,41,196,33,131,33,5,50,200,74,
202,66,105,66,39,58,39,50,73,50,140,66,106,66,103,66,
42,58,141,74,76,66,201,49,198,41,6,50,103,66,169,74,
200,74,200,74,200,74,70,58,37,50,5,50,102,58,200,74,
233,82,232,82,232,82,232,74,232,74,231,74,231,74,40,83,
167,66,232,74,8,75,41,75,138,83,170,91,170,91,235,99,
204,132,108,116,130,25,160,8,194,8,162,8,226,16,225,16,
2,17,195,33,230,58,169,83,231,58,195,25,163,25,195,33,
227,33,69,50,163,25,99,25,99,25,163,33,4,42,4,42,
134,58,40,42,234,33,168,33,67,25,99,25,167,33,139,33,
238,41,173,33,11,34,198,25,164,17,70,50,102,58,5,50,
35,50,165,66,198,66,133,58,134,58,167,66,71,58,229,41,
196,33,163,33,197,41,72,58,105,66,39,50,41,42,173,58,
181,50,215,58,247,66,58,67,127,67,159,59,189,59,190,59,
26,51,211,42,185,58,246,66,176,50,184,50,95,67,127,67,
157,67,126,59,159,59,191,59,159,59,62,59,217,50,115,50,
142,66,170,58,144,50,22,59,158,75,159,67,95,59,159,67,
93,51,116,42,45,42,108,42,210,58,249,66,218,58,123,59,
190,59,191,59,93,59,174,42,209,58,93,75,158,67,123,51,
25,51,157,67,125,59,127,67,159,59,125,59,126,59,126,59,
158,59,158,59,158,59,158,59,158,59,158,59,126,59,126,59,
126,59,126,59,126,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,67,158,67,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,67,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,75,190,67,190,67,
190,67,190,67,190,67,190,75,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,75,190,75,190,75,
222,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,222,67,190,67,
190,75,222,75,222,75,190,75,190,67,190,67,190,67,190,75,
222,67,222,67,222,67,222,67,222,67,222,67,190,75,190,67,
190,75,190,75,190,75,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,75,190,75,222,75,
190,67,190,67,190,67,190,75,190,75,190,67,190,67,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
222,75,222,75,222,75,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,190,75,190,67,222,75,222,75,222,75,222,75,189,67,
190,67,222,75,222,75,222,75,190,67,190,67,190,67,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,67,190,67,222,75,222,75,222,75,
222,75,190,67,190,67,190,67,222,75,222,75,190,67,190,67,
124,67,60,59,29,51,254,50,253,42,28,43,28,51,28,51,
29,51,29,51,29,51,29,51,61,51,61,51,61,51,29,51,
62,51,61,43,60,51,61,51,30,59,62,59,28,59,250,58,
22,51,244,58,145,58,212,66,143,58,200,41,10,50,135,50,
42,42,200,33,70,17,4,9,165,33,136,66,136,66,136,66,
7,50,166,41,134,33,70,25,36,25,132,33,197,33,132,33,
197,41,197,41,35,25,35,25,194,16,129,8,194,8,3,25,
194,16,194,16,162,16,130,8,130,16,162,16,130,16,98,8,
195,16,36,25,3,25,34,25,164,33,228,41,5,50,38,58,
69,50,167,66,232,74,167,66,135,66,102,58,70,58,102,58,
37,50,101,58,102,58,102,58,101,58,4,42,228,41,69,58,
5,50,163,33,70,58,70,58,37,50,229,41,164,33,100,25,
67,25,132,33,5,42,5,42,229,41,164,33,5,50,38,58,
70,50,38,58,5,50,70,58,138,58,107,58,232,49,70,58,
236,82,13,83,204,74,138,66,201,74,9,83,10,83,10,83,
232,74,200,74,232,82,232,74,200,74,5,50,4,42,70,58,
168,74,135,66,135,66,9,83,41,83,9,83,232,74,9,83,
105,91,73,83,41,75,73,75,203,91,203,91,106,83,73,75,
42,108,78,141,39,75,192,8,194,8,130,8,226,16,1,25,
193,8,163,33,129,17,40,67,12,100,37,34,163,25,163,25,
68,42,231,66,228,33,131,25,99,25,66,17,130,25,4,42,
134,58,136,58,40,42,197,33,195,33,99,25,72,25,174,41,
17,42,172,33,231,33,195,33,132,33,164,33,194,33,36,42,
68,50,133,58,166,58,166,66,167,66,135,66,70,58,38,50,
165,33,197,41,7,58,105,74,137,74,102,58,102,50,170,58,
17,67,21,75,241,66,242,58,93,67,159,59,156,51,158,51,
24,51,178,34,217,58,54,75,206,50,214,58,157,75,158,67,
122,59,124,59,157,59,157,59,157,59,127,59,62,59,219,42,
15,34,47,42,150,58,19,67,21,59,89,59,158,59,220,59,
158,51,222,42,187,50,180,50,238,58,46,75,18,59,23,43,
159,59,190,51,125,59,148,42,178,58,26,59,190,67,188,51,
56,59,155,67,126,67,159,67,159,59,126,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
126,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,67,158,67,158,59,158,59,158,59,158,59,
158,67,158,67,158,59,158,59,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,75,222,75,222,75,190,75,190,67,
190,67,190,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,190,67,222,67,222,67,222,75,
190,67,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,75,222,75,
190,75,190,75,190,75,190,75,190,75,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,75,222,75,222,75,
190,67,190,67,190,67,190,75,190,75,190,67,190,67,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,190,67,190,67,190,67,
190,67,190,75,222,75,222,75,222,75,222,75,190,75,190,67,
190,75,190,75,190,67,222,75,222,75,222,75,222,75,189,67,
190,67,222,75,222,75,222,75,190,67,190,67,222,75,222,75,
190,67,222,75,222,75,222,75,190,67,190,67,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,189,67,189,67,222,75,222,75,222,75,
222,75,222,75,190,67,190,67,222,75,222,75,222,75,190,67,
121,67,59,59,28,51,29,51,29,43,29,51,61,51,29,51,
29,51,29,51,29,51,29,51,61,51,61,51,61,51,29,51,
93,51,60,43,28,43,61,51,93,59,92,59,57,59,120,67,
19,59,111,42,109,50,108,58,73,58,40,58,41,50,71,42,
233,33,233,33,134,25,4,17,68,25,230,41,39,50,104,58,
136,66,72,58,40,50,40,50,198,33,100,25,34,17,226,16,
67,25,132,33,226,16,226,16,194,8,161,8,3,25,133,41,
3,25,226,24,194,16,194,16,162,16,97,8,97,8,130,16,
195,16,100,33,35,25,2,17,67,25,131,33,131,33,131,33,
5,50,229,41,228,41,37,50,167,66,200,74,134,66,134,58,
36,50,4,42,37,50,102,58,134,58,228,41,195,33,195,41,
163,33,130,25,69,50,134,58,134,58,37,50,228,41,164,41,
165,41,197,41,229,41,197,41,38,50,103,58,135,66,70,58,
71,58,136,66,104,66,9,83,108,91,235,74,230,41,68,58,
106,91,107,91,75,91,74,91,41,83,232,74,200,74,10,83,
9,83,41,83,74,91,74,91,74,91,200,74,200,74,200,74,
233,82,167,74,103,66,233,82,10,83,233,82,233,82,201,74,
73,83,41,83,8,75,106,83,12,100,235,91,105,75,105,75,
72,75,42,108,107,116,195,33,161,8,195,16,194,16,34,25,
3,17,66,17,162,25,194,25,40,67,105,75,195,25,162,25,
197,58,39,75,37,42,132,25,99,25,99,25,195,33,36,50,
4,42,102,50,38,42,5,42,38,50,133,33,6,17,139,33,
205,33,44,50,104,58,134,66,102,58,3,42,194,33,229,33,
4,42,101,50,167,66,167,66,233,74,201,74,103,58,38,42,
167,41,39,58,136,74,136,74,167,74,166,66,69,58,71,58,
12,67,238,74,202,66,172,50,25,67,159,67,158,59,159,59,
251,50,183,42,177,50,177,50,148,50,245,58,56,59,125,59,
124,59,92,59,94,59,126,67,125,59,158,67,191,67,157,51,
218,50,213,50,242,58,211,58,178,58,241,50,56,51,190,67,
223,67,122,59,120,59,26,59,180,58,203,66,13,67,249,58,
159,67,190,59,189,59,25,67,213,66,215,50,158,59,190,59,
246,58,24,59,93,67,126,59,158,59,127,59,158,59,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,67,158,67,158,67,158,59,158,59,158,59,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
158,59,158,59,158,67,191,67,191,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,75,222,75,222,75,222,75,190,75,190,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,75,222,75,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,190,67,190,67,222,67,222,75,222,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
190,67,190,67,190,67,190,75,190,75,190,75,190,75,190,75,
190,67,190,75,190,75,190,75,190,75,190,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,190,67,190,67,190,67,
190,67,190,67,222,75,222,75,222,75,222,75,190,67,190,67,
190,75,190,67,222,75,222,75,222,75,222,75,222,75,189,67,
190,67,222,75,222,75,222,75,190,67,190,67,222,75,222,75,
190,67,222,75,222,75,222,75,190,67,190,67,190,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,190,67,190,67,222,75,222,75,222,75,222,75,
55,59,25,51,27,51,29,51,30,51,61,51,61,51,61,51,
61,51,29,51,29,51,29,51,61,51,61,51,61,51,29,51,
61,51,61,51,61,51,93,51,92,59,56,51,20,51,241,50,
243,66,179,50,211,50,108,50,202,41,235,41,168,33,134,25,
168,25,233,33,135,33,37,17,37,17,101,25,166,33,199,33,
167,33,9,50,105,58,168,58,135,58,37,50,197,41,165,41,
196,41,164,41,226,16,161,8,226,16,36,25,35,25,3,25,
226,16,226,16,226,16,194,16,161,8,129,8,130,8,162,16,
195,8,4,25,35,25,3,25,35,25,35,25,67,33,67,33,
100,33,100,33,132,33,229,49,70,58,134,66,167,66,199,74,
199,74,134,58,102,58,102,58,167,66,102,58,102,58,134,58,
135,66,69,50,4,42,4,42,37,50,196,41,132,33,132,33,
6,50,197,41,99,25,67,25,164,33,5,42,135,66,70,58,
38,58,72,66,7,58,135,66,168,66,136,58,197,41,69,58,
201,74,9,83,41,83,232,74,9,83,41,83,233,82,200,74,
74,83,106,91,41,83,232,82,232,82,167,66,135,74,103,66,
200,82,167,74,135,66,42,91,10,83,9,83,9,83,200,74,
232,74,41,83,9,83,9,75,73,83,73,75,73,75,169,83,
170,83,135,75,106,108,71,75,67,25,130,8,96,0,225,16,
2,17,66,25,162,25,3,34,3,34,166,50,105,75,162,25,
37,75,230,66,227,33,131,25,35,17,99,25,228,41,228,41,
228,41,69,50,70,42,229,33,198,41,134,33,69,25,102,17,
37,17,105,58,200,66,135,66,38,50,194,33,192,33,195,33,
36,42,167,58,232,74,168,66,200,66,233,74,200,66,167,58,
104,66,169,74,233,74,202,74,234,74,40,83,232,74,201,82,
201,66,169,66,168,66,170,66,243,66,123,75,157,67,125,59,
92,67,24,59,242,58,117,50,185,58,23,59,26,51,127,59,
157,75,90,59,93,59,127,67,127,59,126,59,191,59,157,59,
215,42,239,42,173,42,204,50,13,59,143,42,174,42,92,75,
126,67,180,42,77,26,178,42,216,58,210,66,238,74,15,67,
88,67,189,67,152,59,53,67,243,66,213,50,94,59,158,59,
213,58,182,50,93,67,126,59,127,59,127,59,157,59,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,67,158,59,158,59,158,59,158,59,158,59,158,59,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,59,158,67,158,67,158,67,
158,59,158,59,158,59,158,67,158,67,158,67,158,59,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,59,158,59,158,59,191,67,191,67,190,67,190,67,191,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,75,190,75,190,75,190,75,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,190,67,190,75,190,75,190,67,190,67,190,67,190,75,
222,75,190,75,190,75,190,75,222,75,222,75,190,75,190,67,
222,75,222,75,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,75,
190,75,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,75,222,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,190,67,
222,75,222,75,222,75,222,75,190,67,190,67,190,67,222,75,
190,67,190,75,222,75,190,75,190,67,190,67,190,75,190,75,
190,75,190,75,190,75,222,75,222,75,190,75,190,75,190,75,
190,67,190,67,190,67,190,75,222,75,190,75,190,75,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,222,75,222,75,222,75,222,75,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
190,67,190,67,222,75,222,75,222,75,190,67,189,67,189,67,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,190,67,190,67,190,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
189,67,222,75,222,75,222,75,222,75,222,75,222,75,189,67,
222,75,222,75,190,67,190,67,222,75,222,75,222,75,222,75,
21,51,24,51,27,51,29,51,29,51,61,51,61,51,29,51,
61,51,29,51,29,51,29,51,61,51,61,51,61,51,29,51,
28,51,29,51,61,51,29,51,251,50,250,50,217,58,152,50,
86,58,218,58,57,51,207,50,76,42,47,42,43,42,137,33,
103,25,71,25,6,17,103,33,233,41,200,33,135,25,38,17,
108,33,77,58,204,66,168,58,166,58,133,58,4,50,132,33,
196,41,164,41,67,33,3,17,36,25,230,49,132,41,35,25,
99,25,164,33,132,33,2,17,226,16,100,33,133,33,68,33,
228,16,195,16,227,16,68,33,36,25,3,25,36,33,36,33,
68,33,36,25,100,33,164,41,164,41,196,41,69,58,134,66,
199,74,232,74,199,74,134,66,167,74,134,66,166,66,199,66,
74,83,9,75,70,50,196,33,5,42,131,33,35,25,100,33,
35,25,2,17,67,25,132,33,132,33,66,25,164,41,196,41,
35,50,103,66,71,66,103,66,229,41,134,25,5,25,168,49,
76,58,171,66,202,74,168,66,136,66,168,74,9,83,137,99,
9,75,200,66,199,66,41,83,41,91,102,66,70,58,102,66,
102,66,135,74,135,66,9,83,201,74,200,74,41,83,8,83,
8,83,106,91,41,83,232,74,73,83,170,91,202,83,201,83,
138,75,6,59,68,67,42,108,103,58,162,8,226,16,99,33,
3,25,98,25,3,34,100,42,68,34,162,17,68,42,100,50,
69,75,164,58,162,25,164,33,100,25,67,25,229,41,69,50,
201,74,168,66,134,50,229,33,100,25,69,25,68,17,2,9,
4,25,71,58,101,58,69,42,230,33,130,25,195,41,230,49,
68,42,198,58,9,75,9,75,168,66,103,58,134,58,199,58,
166,58,134,58,104,50,106,50,171,66,234,74,232,74,42,91,
41,75,231,74,233,82,201,74,203,58,51,67,23,59,212,42,
210,42,175,42,150,58,154,66,246,66,87,67,94,59,159,67,
121,75,52,51,87,51,189,67,158,59,126,59,159,59,157,59,
220,58,154,50,249,58,25,67,211,58,78,42,76,42,118,66,
24,59,146,50,12,34,112,42,24,67,244,74,237,74,171,66,
240,58,123,67,18,43,205,50,207,58,244,58,126,67,157,67,
22,67,181,50,125,67,191,67,159,59,159,59,157,59,159,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,59,158,59,158,59,158,59,158,59,
158,67,158,59,158,59,158,59,158,59,158,59,158,59,158,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,67,
158,59,158,59,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,158,59,158,59,158,67,158,67,158,67,158,67,158,59,
190,67,190,67,190,67,158,67,158,67,158,59,158,59,158,59,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,158,59,158,59,191,67,191,67,191,67,190,67,191,67,
158,67,158,67,158,67,191,67,191,67,158,67,158,67,158,67,
190,67,158,67,158,67,158,67,158,67,158,67,158,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,190,67,190,67,190,67,
158,67,190,67,190,67,158,67,158,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,190,67,190,67,190,75,190,75,190,75,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,190,67,190,75,190,75,190,67,190,67,190,75,222,75,
223,75,222,75,190,75,190,75,190,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,67,222,75,222,75,222,75,
190,67,190,67,222,67,222,75,222,75,222,75,222,67,222,67,
222,75,190,75,190,75,190,75,222,75,222,75,190,75,190,67,
222,67,222,67,222,75,222,75,222,75,222,75,190,75,190,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
190,67,190,67,222,75,222,75,222,75,222,75,190,67,190,67,
222,75,190,67,190,67,190,67,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,190,67,190,67,190,75,222,75,190,75,
190,75,190,75,222,75,222,75,222,75,222,75,190,75,190,75,
190,67,190,67,190,67,222,75,222,75,222,75,190,75,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,222,75,222,75,222,75,222,75,190,67,190,67,190,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,222,75,222,75,190,67,190,67,189,67,189,67,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,190,67,190,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
189,67,189,67,222,75,222,75,222,75,222,75,189,67,189,67,
222,75,222,75,190,67,190,67,222,75,222,75,222,75,222,75,
116,75,217,42,252,42,253,50,222,50,61,51,91,43,61,51,
29,51,29,51,29,51,29,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
30,43,60,59,151,75,110,34,177,17,88,42,83,42,10,26,
206,33,204,25,136,17,105,17,203,33,199,33,101,25,9,17,
84,50,146,58,111,50,45,42,234,41,197,33,229,33,165,33,
164,33,132,33,197,41,164,41,67,25,132,33,230,49,198,49,
197,41,35,25,100,33,68,33,36,25,101,33,101,33,69,33,
165,33,35,25,225,16,132,41,104,66,7,50,69,25,69,25,
228,16,36,25,101,33,230,49,229,49,195,41,5,50,102,58,
101,58,101,58,166,66,231,74,166,66,101,58,166,66,101,66,
199,74,199,74,134,58,102,58,5,50,5,50,196,41,164,41,
132,33,132,33,67,25,34,17,67,25,99,33,99,33,164,41,
164,41,230,41,73,58,73,58,200,33,231,41,133,41,165,49,
106,58,41,58,8,50,231,49,7,58,38,58,38,50,103,58,
8,50,230,49,71,58,232,74,73,91,73,91,233,82,168,66,
233,82,168,74,37,50,135,66,168,66,9,83,9,83,9,83,
73,83,41,83,232,82,9,83,167,66,232,74,73,83,200,66,
168,58,138,91,73,75,234,91,11,100,98,25,192,8,100,41,
195,33,228,33,227,33,164,50,196,50,226,25,162,25,100,50,
166,83,3,34,132,25,164,25,131,25,34,17,163,33,230,74,
8,67,70,58,37,50,38,50,200,33,171,25,171,25,7,9,
4,33,197,41,197,33,7,34,6,34,227,25,194,33,4,50,
104,58,201,74,168,74,5,50,38,58,168,66,135,58,103,58,
103,58,104,58,71,50,104,58,103,58,136,58,201,66,169,66,
233,74,41,75,231,66,232,66,234,74,171,66,140,66,172,66,
170,50,140,50,247,66,126,75,86,67,241,58,57,67,191,67,
121,59,242,50,148,50,95,83,126,67,187,59,187,59,190,67,
190,59,191,59,155,67,22,59,145,50,142,58,210,58,218,58,
124,59,186,42,150,50,206,58,240,74,48,75,140,83,77,83,
42,75,208,58,181,50,143,50,136,58,172,58,93,75,190,51,
53,67,211,58,125,59,159,59,157,67,126,67,190,51,126,59,
158,59,158,59,158,59,157,59,158,59,126,59,126,67,159,67,
158,59,158,59,158,59,158,59,158,59,158,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,59,158,67,158,67,158,67,158,59,158,67,
158,59,158,59,158,67,158,67,158,67,158,67,190,67,190,67,
158,59,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,158,67,158,59,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,190,67,190,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
222,75,222,67,190,67,190,67,190,67,190,67,190,67,222,67,
222,75,190,67,190,67,190,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,75,190,67,190,67,190,67,190,67,190,75,190,75,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,222,67,222,75,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,190,75,190,67,190,67,190,75,222,75,190,75,190,67,
222,75,190,75,190,75,190,67,190,67,190,75,190,75,222,75,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,75,
222,75,190,75,190,67,190,67,222,75,222,75,190,75,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,75,190,75,222,75,222,75,222,75,222,75,
190,67,190,67,222,75,222,75,222,75,222,75,222,75,190,75,
190,75,222,75,222,75,222,75,190,75,190,75,190,75,222,75,
222,75,190,67,222,75,222,75,222,75,222,75,190,67,222,75,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,190,75,
222,75,190,67,222,75,254,75,254,75,222,75,190,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,67,190,67,
222,75,222,75,222,75,190,67,190,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,190,67,222,75,222,75,222,75,
222,75,222,75,190,67,190,67,222,75,222,75,222,75,190,67,
190,67,222,75,222,75,222,75,222,75,222,75,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,189,67,189,67,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
16,67,218,50,63,59,61,59,254,50,62,51,60,51,253,50,
29,51,29,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
94,51,62,59,90,67,213,50,184,50,61,75,248,58,114,50,
171,25,206,33,204,33,233,41,199,33,68,25,228,8,42,25,
207,33,13,42,75,42,140,50,110,50,13,42,234,41,200,33,
197,41,164,41,197,41,197,41,164,41,6,50,168,74,201,74,
164,33,99,25,6,50,103,58,38,58,229,49,67,33,193,16,
6,50,6,50,196,41,34,25,67,33,72,58,137,66,199,41,
101,33,36,25,35,25,230,49,71,58,229,41,229,41,229,41,
4,50,195,41,228,41,37,58,4,50,228,41,4,50,69,58,
37,50,167,66,199,66,134,58,228,41,229,49,70,58,200,82,
167,66,103,58,197,41,99,25,99,33,99,33,132,33,164,41,
229,49,7,50,105,58,41,50,232,41,105,58,39,58,38,58,
137,66,169,74,137,66,104,66,104,66,71,58,197,41,67,25,
100,33,230,49,233,74,106,99,73,91,73,91,41,83,200,74,
233,82,233,82,135,66,167,66,102,58,168,74,167,74,168,74,
74,91,232,74,9,83,74,91,200,74,232,74,41,83,199,66,
168,66,232,66,231,66,137,75,76,108,8,75,0,17,131,33,
3,42,36,42,100,42,131,42,131,42,100,42,194,25,68,50,
69,75,3,34,131,25,66,17,66,17,35,17,35,25,99,25,
164,33,70,58,200,74,168,66,41,42,12,34,14,42,205,33,
133,25,104,58,135,50,70,42,228,33,228,41,196,41,132,41,
38,50,103,58,136,66,103,66,168,74,200,74,135,58,70,58,
169,66,169,66,72,58,39,50,7,42,105,58,137,66,105,58,
201,74,10,83,232,74,233,74,233,74,201,66,201,58,168,58,
137,58,137,58,178,50,251,58,24,51,242,50,21,59,125,67,
249,42,211,42,178,50,155,75,158,67,155,59,90,59,29,67,
189,59,122,59,209,50,105,42,103,58,168,58,238,58,87,67,
159,75,125,51,125,43,252,42,246,58,12,75,106,83,140,83,
39,75,209,66,114,42,145,50,142,66,141,50,60,67,191,59,
146,50,147,50,93,59,159,59,158,67,159,67,190,59,158,67,
158,67,158,59,158,59,158,59,158,59,158,59,158,67,126,67,
158,59,158,59,158,67,158,59,158,59,158,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,59,158,59,
158,59,158,59,158,59,158,67,158,67,158,67,158,67,158,67,
158,59,158,59,158,67,158,67,158,67,158,59,158,59,191,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,158,67,158,67,158,67,158,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,75,222,75,
190,75,190,67,190,75,222,75,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,67,
190,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,190,75,190,75,190,67,222,67,222,75,222,75,223,75,
222,75,190,75,190,67,190,67,190,75,222,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,75,222,75,222,75,222,75,222,75,
190,67,190,75,222,75,222,75,222,75,222,75,190,75,190,75,
190,75,222,75,222,75,222,75,190,75,190,75,190,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
49,75,27,59,62,51,59,51,28,51,62,51,29,51,253,58,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
94,51,62,59,60,59,26,59,59,59,56,67,146,50,207,33,
178,25,52,42,14,42,165,25,132,25,102,25,72,25,105,25,
137,25,169,25,9,42,75,50,78,50,80,58,46,50,11,42,
100,25,35,25,35,17,2,17,2,17,67,25,164,41,229,49,
38,50,228,41,102,58,167,66,167,66,167,74,134,66,134,66,
196,41,228,41,70,58,5,50,99,33,229,41,169,66,169,66,
104,58,6,50,197,41,6,50,8,50,167,41,197,41,5,42,
164,33,196,33,228,41,164,33,164,33,196,41,164,33,229,41,
69,58,102,58,135,66,134,58,228,41,228,41,5,50,38,58,
168,66,200,74,103,58,229,41,164,41,164,33,132,33,132,33,
197,41,7,50,73,58,231,41,133,25,231,41,71,58,168,74,
233,74,9,83,9,83,233,82,10,83,10,83,137,66,39,50,
6,50,104,66,10,83,42,91,168,74,9,83,106,91,41,83,
200,82,200,74,168,74,233,74,135,66,135,66,135,66,233,82,
232,74,200,74,232,82,9,83,167,74,168,74,232,74,9,83,
71,50,200,66,138,83,44,100,140,108,10,100,226,33,36,50,
165,58,100,50,100,42,131,42,131,42,100,42,227,33,132,58,
70,75,162,25,34,17,33,9,1,17,3,17,36,25,4,25,
99,33,70,58,199,74,167,58,136,50,137,42,42,42,234,41,
10,34,107,50,231,33,99,25,98,25,196,41,229,57,5,58,
201,66,103,58,6,50,70,58,200,74,233,82,168,66,168,66,
136,66,136,58,72,58,72,58,40,50,170,66,138,66,105,58,
103,66,201,74,234,74,202,66,171,66,139,58,138,58,105,50,
10,58,107,58,209,58,27,59,93,67,24,67,246,58,92,67,
155,67,57,59,246,58,122,67,94,67,91,59,21,59,244,74,
124,75,90,75,145,50,41,42,104,58,137,66,170,58,237,58,
113,34,247,42,187,59,156,67,85,67,170,58,136,50,197,50,
135,58,235,66,137,42,82,50,117,66,109,50,24,59,157,59,
211,50,22,59,190,67,159,59,158,67,159,67,158,59,158,67,
158,67,158,59,158,59,158,59,158,59,158,67,158,67,158,67,
158,59,158,67,158,67,158,59,158,59,158,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
158,59,158,59,158,67,158,67,158,59,126,59,158,59,191,67,
190,67,190,67,190,67,158,67,158,67,158,67,158,59,158,59,
190,67,158,67,158,67,158,67,158,67,190,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,191,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,75,
190,67,190,67,190,75,222,75,190,75,190,75,190,75,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,190,75,190,67,190,67,190,67,190,67,190,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,75,222,75,222,67,190,67,190,67,190,67,190,67,
190,75,190,75,190,75,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,75,190,75,222,75,190,75,190,75,190,75,190,75,222,75,
190,67,190,75,222,75,222,75,222,75,222,75,190,75,190,67,
222,75,190,75,190,75,190,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,67,190,75,190,75,190,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
190,75,222,75,222,75,222,75,190,75,190,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
52,75,27,59,29,43,59,51,60,51,62,51,61,51,60,59,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
28,43,29,51,28,51,60,51,123,59,53,51,143,42,14,42,
84,34,149,50,47,34,103,9,103,17,13,42,45,42,170,25,
69,17,39,17,139,33,170,33,169,33,76,50,76,50,201,33,
133,33,100,25,67,25,35,25,2,17,225,16,2,17,67,25,
164,33,99,33,196,41,196,41,228,41,102,66,232,74,40,83,
8,83,8,83,199,74,101,58,228,41,4,42,134,58,200,66,
168,66,199,66,167,66,136,58,41,50,41,50,72,58,135,58,
5,42,5,50,70,50,164,33,164,33,5,50,196,41,5,50,
228,41,228,41,102,58,167,66,37,50,196,41,197,49,230,49,
135,66,167,74,167,66,102,58,70,58,6,50,164,33,35,25,
165,41,7,50,40,50,166,33,36,17,165,33,39,58,136,66,
8,75,41,83,73,91,41,83,41,83,233,74,103,58,104,58,
229,41,5,50,71,58,71,58,6,50,167,66,73,91,40,83,
233,82,135,66,135,66,200,74,167,66,168,74,135,66,200,74,
232,74,9,83,9,83,200,74,168,74,135,66,5,50,135,66,
71,50,140,91,45,108,170,83,104,83,75,108,201,99,197,66,
37,75,165,58,67,42,196,50,164,50,3,34,3,34,229,66,
6,59,65,9,2,9,67,17,34,17,2,17,35,25,36,25,
198,49,231,49,231,49,38,50,136,50,138,50,168,25,38,17,
12,34,235,33,70,25,132,33,196,41,229,49,230,49,71,66,
41,75,70,50,164,33,229,41,38,58,103,58,200,66,42,83,
201,74,135,66,136,66,136,66,136,58,170,66,105,58,105,58,
201,74,233,82,201,74,105,58,75,58,141,58,173,58,76,50,
11,42,107,58,237,66,51,67,54,67,245,66,244,66,117,67,
152,67,91,75,27,67,124,67,159,67,125,59,244,50,205,58,
242,66,18,67,174,50,107,42,173,58,173,66,138,66,168,66,
201,50,142,50,108,50,173,58,16,75,237,66,170,50,39,42,
72,58,40,75,233,66,144,58,147,66,174,58,246,58,151,59,
243,58,56,67,190,67,191,59,125,59,94,59,158,67,158,67,
158,67,158,67,159,59,159,59,158,59,158,59,158,59,158,67,
158,59,158,67,158,67,158,59,158,59,158,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,59,158,59,
158,67,158,67,158,67,158,59,158,59,158,59,158,67,158,67,
158,67,158,67,158,67,158,67,158,59,126,59,158,59,191,67,
190,67,190,67,190,67,190,67,158,67,158,67,158,67,158,67,
190,67,158,67,158,59,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,75,190,75,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,67,
190,67,190,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,75,222,75,190,75,190,75,222,75,190,67,
222,67,222,67,222,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,75,222,75,190,67,190,67,190,67,190,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
190,75,190,75,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,67,222,67,222,67,190,67,222,67,222,75,
190,75,190,75,190,75,190,75,190,75,190,67,190,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,222,75,222,75,222,75,222,75,222,75,222,75,190,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,222,75,222,75,222,75,190,75,190,67,190,75,222,75,
190,75,190,75,222,75,222,75,222,75,222,75,190,75,190,75,
190,67,190,67,190,75,222,75,222,75,222,67,222,67,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,190,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,190,67,
189,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
153,58,253,50,62,43,93,51,62,51,62,43,61,43,60,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
93,51,126,59,93,59,62,51,63,51,25,51,213,50,149,58,
212,50,180,50,114,50,205,33,136,25,199,33,6,34,164,25,
66,17,230,16,172,41,234,41,198,33,137,58,171,66,9,42,
68,25,35,25,3,17,3,25,3,25,226,16,225,16,2,17,
162,8,194,8,226,16,226,16,34,25,196,41,70,58,102,58,
102,66,102,58,102,58,232,74,41,83,167,66,167,66,74,91,
232,74,199,66,166,66,135,58,106,58,106,58,72,50,69,50,
167,66,102,58,167,66,135,66,102,58,102,58,37,50,69,58,
37,50,228,41,102,58,167,66,196,41,225,8,193,16,35,25,
38,58,37,58,5,50,5,50,102,58,135,66,5,42,67,25,
101,33,39,50,72,58,230,41,197,41,39,50,169,66,169,74,
233,74,232,74,9,83,167,66,134,66,102,58,196,41,5,50,
167,66,135,66,71,58,38,58,6,50,70,58,134,66,166,74,
200,74,167,66,103,66,70,58,102,58,200,74,200,74,135,66,
232,74,41,83,41,91,200,82,232,82,167,74,196,49,229,49,
75,91,172,99,139,91,40,75,137,83,75,108,140,116,229,66,
70,75,6,67,132,50,228,58,164,58,227,33,227,33,6,75,
166,50,99,17,68,17,36,17,34,17,98,25,163,33,100,25,
163,33,133,33,231,49,71,50,137,50,108,50,202,33,102,25,
37,9,68,17,35,25,164,41,229,49,136,74,202,74,170,66,
106,83,167,66,164,33,6,50,71,58,103,58,200,66,42,83,
171,99,74,83,9,83,200,74,136,58,201,66,136,58,136,58,
169,74,9,83,41,83,200,66,137,58,139,58,172,58,140,50,
112,42,138,50,200,66,11,67,236,66,206,66,207,66,13,59,
239,50,242,58,182,50,92,59,222,59,191,59,27,51,213,50,
209,58,238,58,201,50,135,42,137,50,203,66,235,74,168,66,
103,58,109,58,15,50,11,50,140,58,77,50,75,50,233,41,
6,50,103,58,140,58,109,58,77,50,172,50,176,42,244,50,
210,58,248,58,125,67,223,75,158,59,126,67,159,67,157,59,
157,67,158,67,159,67,159,59,158,59,157,59,158,59,158,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
191,67,158,67,158,59,158,67,158,67,158,59,158,67,158,67,
158,67,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,158,67,158,67,158,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,222,67,222,67,
190,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
190,75,190,67,190,75,222,75,190,67,190,75,222,75,190,75,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,75,222,75,222,75,190,75,190,67,190,67,190,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,190,75,190,75,190,67,190,67,190,67,190,67,190,75,
190,67,222,67,222,75,222,67,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,190,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,67,190,75,190,75,222,75,222,75,190,75,190,75,190,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,222,75,222,75,222,75,190,75,190,75,190,75,222,75,
222,75,222,75,190,75,190,75,190,75,190,75,222,75,222,75,
190,67,190,75,190,75,190,75,222,67,222,67,222,67,222,67,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,190,67,
189,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
220,58,30,51,30,43,30,51,254,50,30,43,62,43,29,43,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
30,51,62,59,61,51,62,51,63,51,60,51,24,59,216,58,
245,58,175,50,76,50,169,41,3,17,225,16,3,25,226,16,
2,17,130,0,38,25,167,41,133,33,230,41,40,50,199,41,
3,25,227,16,194,16,194,16,194,16,193,16,193,16,194,16,
162,16,130,8,129,8,129,8,194,16,67,33,132,33,99,33,
131,33,5,50,103,58,167,66,233,74,233,74,167,66,134,58,
8,75,166,66,166,58,200,66,234,74,235,74,168,66,167,66,
166,66,101,58,166,66,166,66,134,66,166,66,101,58,101,58,
70,58,4,42,102,58,167,66,5,50,225,16,161,8,195,16,
67,25,67,33,99,33,196,41,70,58,135,58,71,58,229,41,
105,58,137,58,137,66,169,66,201,74,169,66,10,83,75,91,
169,74,201,74,233,74,70,58,102,58,167,66,37,50,70,58,
167,74,70,58,229,49,38,58,168,74,9,83,106,91,170,99,
74,91,9,83,233,74,167,66,135,66,232,74,233,82,200,82,
200,74,232,82,42,91,168,82,167,74,200,82,200,82,233,82,
42,83,201,74,41,83,139,99,44,108,202,91,137,91,71,75,
4,67,132,50,99,42,164,58,164,58,35,42,3,42,200,99,
134,50,131,17,68,17,4,17,35,17,163,25,197,33,168,25,
198,25,199,33,72,58,103,58,40,42,74,50,8,42,196,33,
229,33,228,41,196,41,133,33,165,33,106,83,236,99,135,50,
105,83,167,58,99,25,197,41,71,58,136,66,168,66,232,74,
8,75,41,83,9,75,232,74,167,66,41,75,41,83,9,75,
169,66,233,74,41,83,233,74,169,66,140,58,141,58,174,58,
215,50,171,50,136,58,138,66,170,66,204,74,206,74,139,50,
233,58,233,58,144,50,219,50,159,59,223,51,159,59,94,67,
250,50,208,50,170,58,135,58,102,50,168,66,10,67,168,58,
72,66,176,66,186,50,182,42,173,50,234,41,232,49,229,41,
41,50,41,50,77,58,107,58,45,50,141,50,140,42,179,58,
176,58,248,58,91,59,190,75,190,59,158,67,159,67,157,59,
155,67,157,67,158,67,159,67,158,59,157,59,158,67,159,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
191,67,158,67,158,59,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,158,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,222,67,222,75,190,75,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,222,67,222,75,222,75,222,75,222,75,
190,75,190,67,190,75,190,75,190,67,190,75,222,75,190,75,
222,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,222,75,190,75,190,75,190,67,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,67,190,67,190,67,222,67,
222,75,222,75,222,75,222,75,222,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,190,67,190,75,190,75,190,75,190,75,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,190,75,222,75,222,75,
222,75,222,75,190,75,190,75,190,75,190,75,222,75,222,75,
223,75,222,75,190,75,190,67,190,67,222,75,222,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
184,83,90,59,28,43,92,67,90,67,59,51,61,51,29,43,
29,51,29,51,29,51,61,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
62,51,62,51,61,59,61,51,94,51,92,51,57,51,217,50,
187,50,147,42,11,34,103,25,3,17,4,17,5,17,36,17,
4,17,194,8,193,8,3,17,195,16,195,16,3,25,228,16,
3,25,227,24,194,16,161,8,129,16,162,16,162,16,129,8,
130,16,97,8,129,8,129,8,161,8,193,16,161,8,128,8,
2,25,2,25,35,25,165,33,38,50,197,41,98,25,98,33,
37,50,4,50,69,58,134,58,135,66,102,58,70,50,134,58,
134,58,37,50,196,33,163,33,37,50,102,58,70,58,69,50,
196,33,196,41,102,58,166,66,37,50,2,17,194,16,228,24,
227,16,3,25,132,33,5,50,102,58,102,58,38,50,6,42,
234,74,72,58,197,41,38,50,168,66,71,58,104,58,104,58,
136,66,233,74,200,74,102,58,135,58,135,58,6,50,229,49,
167,66,37,50,229,41,38,58,135,66,167,74,200,74,200,74,
74,91,233,82,9,83,232,74,103,58,70,58,102,58,168,74,
232,74,232,82,74,99,200,82,135,74,168,82,42,99,74,99,
200,74,232,82,139,99,74,91,41,83,8,75,166,58,166,58,
5,67,165,50,68,50,132,50,164,58,35,42,2,34,232,99,
38,42,99,17,67,17,100,25,165,33,132,25,137,17,207,33,
116,50,13,34,41,50,9,50,10,50,41,50,230,33,164,25,
7,42,38,42,231,41,170,41,169,33,233,74,72,75,4,34,
105,83,73,83,229,41,197,41,197,41,229,41,5,42,70,50,
38,50,168,66,200,74,233,74,167,58,200,66,232,66,200,66,
42,83,200,74,135,58,136,58,204,66,206,74,142,66,175,66,
84,67,203,66,103,66,73,58,104,58,202,74,235,74,169,58,
200,66,200,66,173,66,23,67,157,67,222,59,190,59,126,67,
58,51,174,42,104,50,39,58,197,41,196,33,6,34,231,33,
232,49,203,58,86,59,60,59,179,50,200,33,230,41,5,50,
201,58,141,66,108,66,168,66,110,50,113,58,46,42,77,50,
45,50,248,58,249,50,91,59,158,59,158,59,127,67,222,59,
122,67,156,67,158,67,191,67,190,59,189,59,158,67,159,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,158,67,191,67,158,67,158,59,158,59,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,222,75,222,75,190,75,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,222,67,222,75,222,75,222,75,222,75,
190,75,190,67,190,75,222,75,190,67,190,75,222,75,190,67,
190,67,190,67,222,67,222,67,222,75,222,67,222,67,222,67,
222,75,190,75,190,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,75,
222,75,222,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,67,222,67,222,67,222,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,67,190,67,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,221,75,221,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
240,75,53,51,59,59,91,100,56,100,88,59,28,51,60,51,
29,51,29,51,29,51,29,51,61,51,61,51,61,51,61,51,
61,51,61,51,61,51,61,51,61,51,61,51,61,51,61,51,
124,59,61,51,92,59,60,51,61,51,94,51,61,51,31,59,
60,51,24,51,116,42,240,33,203,33,106,25,42,17,73,9,
197,16,227,16,160,8,130,8,163,16,161,8,162,16,163,16,
193,16,161,16,161,16,129,8,129,16,194,24,195,24,130,16,
129,16,97,8,129,8,161,16,129,8,96,8,161,8,161,16,
96,8,194,16,194,8,162,8,3,17,2,17,225,16,99,33,
36,50,36,50,69,58,68,50,68,50,165,66,7,75,106,91,
232,74,135,58,196,33,228,41,135,58,5,50,131,33,131,33,
229,41,37,50,166,66,134,58,37,50,34,25,194,16,195,16,
228,24,227,16,35,25,229,49,102,58,102,58,229,41,132,25,
230,41,230,41,132,33,131,33,6,50,6,50,104,58,231,49,
71,58,168,74,70,58,37,50,5,42,164,33,197,41,230,49,
5,50,196,41,228,41,37,50,5,50,69,58,167,74,232,74,
9,91,9,83,139,99,74,91,200,74,167,66,168,74,200,74,
232,74,9,83,74,99,9,91,42,99,233,90,200,90,135,74,
232,82,200,74,232,82,168,74,167,66,106,91,199,66,69,50,
131,42,231,66,101,50,132,50,197,66,133,58,132,58,199,91,
229,33,98,17,66,17,100,25,197,33,199,25,239,33,153,58,
123,75,141,42,70,42,105,58,172,74,169,66,37,42,198,33,
134,25,196,33,233,33,49,58,240,49,9,42,38,42,8,50,
166,58,8,75,197,33,165,33,133,33,164,33,132,25,163,25,
132,33,39,50,136,58,233,74,200,66,168,66,233,74,233,74,
233,74,168,66,136,58,169,58,202,66,138,58,72,50,169,66,
76,67,235,74,201,82,201,66,169,58,169,66,201,74,199,66,
135,66,73,58,137,66,46,75,184,67,158,59,191,67,127,75,
93,67,175,50,73,50,10,50,166,33,163,33,38,50,106,66,
168,66,71,50,72,42,146,50,182,58,81,42,110,50,72,42,
198,50,234,74,138,66,138,58,142,58,239,66,79,50,11,50,
12,50,57,67,25,59,91,59,190,59,191,67,95,67,222,59,
88,59,123,67,158,67,191,67,190,67,189,59,190,67,191,67,
158,67,158,67,158,67,158,67,158,59,158,59,158,67,158,67,
158,59,158,59,158,59,158,59,158,67,158,67,158,67,158,67,
158,59,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
158,67,158,67,191,67,191,67,158,67,158,59,158,59,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,222,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,222,67,222,75,222,75,222,75,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,222,67,222,67,222,67,222,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,75,222,75,190,75,190,75,190,75,190,67,
190,67,190,67,222,67,222,75,222,75,222,75,222,67,222,67,
190,75,190,75,190,75,222,75,223,75,223,75,222,75,190,75,
190,67,190,67,222,67,222,67,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,222,75,
222,67,222,67,190,67,222,67,222,75,222,75,222,75,222,75,
190,75,190,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,190,75,190,75,190,67,190,67,190,75,190,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,190,75,222,75,222,75,222,75,222,75,190,75,
190,75,222,75,222,75,222,75,222,75,222,75,222,75,190,75,
190,67,222,75,222,75,222,75,222,75,222,75,222,67,190,67,
222,75,222,75,190,75,222,75,222,75,223,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,221,75,221,75,221,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
148,83,153,51,250,58,155,83,118,75,119,59,93,35,92,59,
29,59,61,59,62,51,62,51,94,51,62,51,61,51,29,51,
30,59,29,59,29,51,60,51,93,51,62,51,93,51,125,59,
94,59,94,59,62,51,93,51,93,59,94,51,94,51,157,51,
93,59,59,51,59,51,23,51,148,42,52,42,205,33,38,17,
101,25,101,33,194,8,130,8,129,16,129,16,96,8,162,16,
162,16,130,16,97,8,96,8,194,24,162,16,162,16,97,8,
97,8,129,16,97,8,97,8,129,16,129,8,129,8,226,16,
161,16,96,8,97,8,162,16,162,8,130,8,195,16,228,16,
34,33,67,33,132,41,131,33,98,25,102,58,231,66,38,75,
231,74,232,74,232,74,135,66,70,58,5,50,228,41,228,41,
101,58,133,58,68,50,134,58,102,58,164,33,193,8,226,16,
99,33,99,33,132,33,5,50,196,41,196,41,228,41,163,33,
165,33,6,50,99,25,68,25,166,41,106,58,170,66,202,66,
168,74,70,58,229,49,229,41,164,33,99,33,196,41,5,50,
229,41,197,41,230,49,165,41,229,49,167,74,199,74,8,75,
232,74,9,83,199,74,200,74,232,74,200,74,233,74,233,74,
200,66,200,74,9,91,106,99,171,107,74,91,200,74,103,74,
135,74,70,66,168,82,10,91,201,82,200,74,199,66,101,42,
194,33,99,50,71,83,6,75,229,66,100,58,6,83,135,75,
196,41,99,17,66,17,67,17,39,17,206,33,148,42,250,50,
139,58,138,58,10,75,107,91,205,99,205,91,139,75,69,34,
37,25,35,25,229,33,90,75,27,59,204,25,13,42,238,33,
110,42,140,50,7,42,165,33,101,33,69,33,133,33,229,41,
230,49,197,49,70,58,200,74,201,74,233,74,41,83,72,83,
201,66,233,74,200,66,167,66,199,66,168,66,137,58,105,58,
105,58,202,74,233,74,233,82,200,74,167,66,38,50,136,58,
200,66,231,74,169,66,202,66,236,66,89,75,159,75,221,67,
191,59,27,51,148,50,234,66,168,66,197,33,73,58,135,58,
167,66,38,50,6,42,49,50,117,50,112,42,45,42,103,50,
137,50,138,58,202,74,169,66,138,66,175,66,112,50,238,25,
150,42,122,75,90,67,56,51,188,67,159,67,191,67,189,59,
86,67,121,59,191,67,158,59,158,67,159,67,190,67,189,59,
158,67,158,67,158,67,158,59,158,59,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
158,59,158,67,158,67,158,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,190,67,190,67,190,67,190,67,
222,75,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,223,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,75,222,67,190,67,190,67,190,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,222,75,222,75,222,75,222,75,222,75,222,75,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,75,222,75,222,75,190,67,190,67,190,67,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,190,75,190,75,190,75,190,75,
190,75,190,67,190,67,190,67,190,75,190,75,222,75,222,75,
190,75,190,75,190,75,190,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,75,222,75,222,75,
222,75,222,67,222,67,222,67,222,67,222,67,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,67,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,190,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
190,75,190,75,190,75,190,75,190,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,190,75,190,75,222,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,223,75,223,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
221,75,221,75,221,75,221,75,221,75,221,75,221,75,221,75,
148,58,83,59,183,58,28,51,211,59,207,50,186,42,62,59,
62,59,61,51,61,51,61,51,92,51,60,51,60,51,60,59,
61,51,30,51,30,51,93,59,94,59,31,51,31,51,92,59,
62,51,58,59,60,59,62,51,92,51,61,59,61,51,187,51,
151,51,149,59,20,51,112,34,15,34,50,42,45,42,135,17,
70,25,135,33,36,25,227,24,194,16,162,16,97,16,130,16,
130,8,97,8,97,8,227,24,35,25,194,16,129,8,129,8,
227,24,227,24,130,16,97,8,129,16,162,16,3,25,133,41,
133,41,35,25,161,16,97,0,129,8,195,16,227,16,163,8,
131,16,3,25,35,25,68,25,165,33,4,42,36,50,101,58,
37,50,228,41,196,41,196,41,228,41,102,58,135,66,70,58,
229,41,196,41,131,25,5,42,135,58,70,58,67,25,226,16,
132,33,229,41,5,50,70,58,229,49,196,41,228,41,5,50,
197,41,70,50,132,33,68,25,199,41,171,66,204,74,171,66,
168,74,103,58,38,58,37,50,38,58,70,58,37,50,228,41,
228,41,164,41,229,49,6,58,38,58,70,58,37,50,102,58,
102,66,102,66,69,58,102,58,167,66,167,74,200,74,168,74,
232,74,9,83,42,99,41,91,9,83,41,83,233,82,136,74,
70,66,168,74,233,90,42,91,42,91,200,74,166,58,101,50,
3,42,68,50,101,58,231,74,132,50,67,58,71,91,37,59,
69,25,68,17,4,9,6,9,139,33,239,41,48,42,210,50,
169,58,9,75,40,75,104,83,235,99,73,75,102,42,130,17,
68,25,166,41,39,42,14,59,176,50,234,33,110,58,21,50,
146,58,10,34,196,33,229,41,229,49,36,50,166,66,168,66,
9,83,200,74,102,58,134,58,232,74,232,74,168,66,168,66,
135,58,168,66,200,66,167,66,135,58,103,58,136,58,170,66,
172,58,139,58,105,58,169,74,233,74,200,74,102,58,38,50,
135,66,167,66,138,66,172,66,171,58,50,67,154,75,156,67,
187,67,61,59,24,67,234,58,39,50,165,33,7,42,102,50,
70,58,38,50,167,33,232,33,78,42,82,50,172,58,71,50,
136,58,201,66,11,83,170,74,106,58,144,58,181,58,185,58,
25,59,122,75,23,59,248,50,125,67,93,59,157,67,189,67,
22,59,89,59,191,67,158,59,190,67,159,67,190,67,158,59,
158,67,158,67,158,67,158,67,158,67,158,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,158,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,158,67,158,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,158,67,
158,67,190,67,190,67,190,67,190,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,67,222,67,190,67,190,67,222,67,222,67,222,67,190,67,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,75,222,75,190,67,190,67,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,75,222,75,222,75,190,67,190,67,190,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,75,190,75,190,75,222,75,222,75,222,75,222,75,222,75,
222,75,190,75,190,75,190,75,190,75,190,75,190,75,190,75,
190,75,190,75,190,75,190,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,67,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,190,75,190,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,221,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
85,75,44,67,18,67,155,51,81,43,75,42,153,50,62,59,
92,51,60,51,61,51,93,51,61,51,61,51,93,51,93,51,
157,51,124,51,92,51,61,51,61,59,93,59,91,59,90,59,
149,51,112,51,115,59,90,59,123,59,124,67,92,59,122,51,
148,59,211,75,114,67,206,50,143,42,146,50,142,50,201,17,
104,25,103,25,5,17,195,16,129,8,129,8,130,16,130,16,
227,16,227,16,226,16,132,33,68,25,36,25,227,16,195,16,
194,16,194,16,130,16,97,8,129,16,162,16,227,24,100,33,
230,49,198,49,68,33,129,8,97,8,195,16,195,16,195,16,
198,8,196,8,196,8,136,33,41,50,229,41,163,33,99,33,
131,33,33,17,33,17,99,25,196,33,102,58,167,66,37,50,
132,33,165,41,132,33,197,41,38,50,38,58,164,41,67,33,
196,41,164,33,67,25,132,33,196,41,229,41,196,41,196,41,
197,41,6,50,67,25,194,16,37,25,41,58,139,66,106,58,
168,74,135,66,135,66,135,66,167,74,232,82,167,74,102,66,
166,66,4,50,196,41,5,58,70,58,38,58,229,49,229,41,
163,41,37,50,200,74,232,82,200,74,167,74,135,66,103,58,
200,74,200,74,9,91,74,99,42,91,233,82,201,82,201,82,
9,83,139,99,42,91,42,91,139,99,139,99,106,91,232,74,
163,33,66,17,67,25,102,58,230,66,38,91,38,91,37,59,
101,33,135,25,104,17,138,25,236,41,202,41,7,42,103,42,
74,83,232,66,197,58,164,58,100,42,163,25,99,17,226,8,
131,25,195,33,38,50,165,50,229,25,68,17,37,42,203,33,
171,33,133,25,227,33,134,66,200,74,7,75,40,83,234,74,
136,91,171,99,9,75,104,58,168,66,167,66,71,50,137,58,
200,74,168,66,135,66,136,66,135,58,104,58,136,66,169,66,
238,74,172,66,41,50,105,58,169,66,201,74,168,66,70,50,
71,58,136,66,138,66,173,66,171,58,235,58,240,58,22,67,
150,59,61,59,156,75,204,50,198,33,165,33,38,50,167,58,
39,50,229,41,202,41,134,25,201,25,147,58,206,66,104,58,
6,50,104,66,201,74,201,74,234,74,14,75,244,66,59,75,
91,67,119,67,52,59,56,59,157,75,125,67,124,67,92,67,
53,59,89,59,191,67,191,59,189,67,158,67,158,67,127,59,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,158,67,158,59,158,59,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,222,67,222,67,222,67,222,67,222,67,222,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,67,190,67,190,67,222,67,222,67,222,75,222,67,190,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,67,222,75,
222,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,222,75,222,67,190,67,190,67,222,67,222,75,222,67,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
190,75,222,75,222,75,190,75,190,75,190,75,190,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,75,190,75,190,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,190,67,190,75,190,75,
190,75,190,75,190,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,67,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,190,75,190,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,190,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,221,75,221,75,221,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
123,67,176,75,139,75,240,42,150,50,156,74,191,58,62,51,
94,51,30,51,93,59,93,59,62,59,61,59,92,51,92,51,
123,51,94,51,95,51,60,51,60,51,126,59,156,59,150,51,
108,51,46,43,47,51,82,67,56,59,60,51,90,51,53,51,
75,59,204,75,206,83,205,75,45,51,110,34,44,42,171,33,
169,25,71,17,196,8,194,8,161,8,162,16,162,16,130,8,
195,16,3,25,3,25,165,41,35,25,68,33,227,16,195,16,
129,8,162,16,129,8,97,8,97,8,97,8,129,8,194,16,
35,25,132,33,68,33,194,16,97,8,129,8,162,16,195,24,
73,17,42,17,106,25,104,25,102,25,196,8,35,25,65,33,
67,25,132,33,37,50,135,66,102,58,38,50,37,50,228,41,
100,33,229,49,5,50,163,33,99,25,131,33,99,33,67,33,
164,41,67,25,2,17,99,25,99,33,99,25,99,25,164,33,
164,33,229,41,99,33,35,25,101,33,72,58,137,66,137,66,
103,66,102,58,200,74,200,74,200,74,200,74,102,66,134,66,
134,58,102,66,102,58,135,66,135,66,135,66,167,66,135,66,
102,58,70,58,167,74,199,74,200,74,41,83,233,82,168,74,
135,66,103,66,135,74,9,91,42,91,135,66,71,58,136,74,
233,82,233,82,168,74,42,91,42,91,42,91,74,91,167,74,
5,42,6,42,235,82,42,83,133,58,103,99,42,124,134,75,
200,33,175,33,242,33,16,34,238,41,41,50,199,66,135,66,
103,50,37,42,163,25,162,25,195,25,66,17,3,17,68,25,
7,42,161,25,6,50,70,58,100,25,36,17,68,50,103,50,
231,41,72,58,135,66,167,74,9,75,201,74,168,58,168,58,
233,66,140,91,11,75,72,50,104,58,136,58,168,66,42,75,
73,83,232,74,200,66,201,74,169,66,169,66,168,66,103,58,
139,58,204,66,106,58,170,66,169,66,168,66,168,66,102,50,
8,58,169,74,168,66,203,66,237,74,202,58,169,58,48,83,
209,58,216,50,58,51,143,34,167,25,197,41,5,50,103,50,
40,58,70,50,173,66,238,41,204,33,147,58,149,58,75,42,
234,41,106,66,170,74,202,74,42,83,9,75,204,66,51,75,
61,67,55,67,243,50,245,58,89,67,56,59,54,59,244,50,
82,67,120,67,191,67,191,67,158,67,126,67,158,67,159,59,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,222,67,190,75,190,75,
190,67,190,67,190,67,222,67,222,67,222,67,190,67,190,67,
190,67,222,67,222,67,222,75,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,75,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
222,67,222,67,222,67,190,67,190,67,222,67,222,67,222,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,222,67,
222,67,190,67,190,67,222,67,222,75,222,75,222,67,190,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,75,222,75,222,67,222,67,190,67,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,222,75,190,75,190,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,75,190,75,190,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,190,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,190,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
221,75,221,75,221,75,221,75,221,75,221,75,221,75,221,75,
222,75,222,75,222,75,221,75,221,75,221,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
159,67,87,51,142,59,166,58,110,74,122,50,63,59,94,51,
61,51,61,51,89,59,55,59,25,59,91,59,91,59,93,51,
124,59,93,59,94,59,126,59,125,59,123,59,150,59,114,51,
172,50,181,50,245,66,80,83,244,66,253,42,91,51,49,51,
233,50,41,67,76,83,238,91,237,83,44,67,12,67,238,66,
139,42,232,25,69,17,3,9,226,8,161,8,162,16,130,16,
194,16,162,16,162,16,100,41,194,16,129,16,97,8,130,8,
162,8,194,16,129,16,97,8,129,16,129,16,129,8,129,16,
129,8,194,16,194,16,162,16,194,16,162,16,162,16,3,33,
106,25,205,33,13,42,40,9,197,0,132,0,195,16,193,24,
2,17,132,33,5,50,70,58,196,41,66,25,66,25,164,33,
37,58,134,66,134,66,228,41,196,41,4,42,229,49,196,41,
34,25,2,17,67,25,164,41,35,25,2,17,99,33,229,49,
5,50,196,41,132,33,164,41,229,49,103,66,136,66,169,74,
70,58,38,50,103,66,102,58,103,66,167,66,102,58,167,66,
103,58,103,66,102,66,103,66,102,66,102,66,167,74,167,66,
168,66,70,58,102,66,167,66,9,83,106,99,9,83,136,74,
136,66,168,74,70,66,103,74,233,82,200,74,136,66,104,66,
71,58,6,50,38,58,9,83,233,82,168,74,42,91,9,91,
234,74,109,83,12,83,104,58,133,58,6,83,140,140,73,100,
71,9,20,42,216,58,146,42,80,42,138,58,166,58,198,41,
131,25,66,17,164,25,197,25,67,17,132,25,198,33,134,33,
138,50,6,34,135,58,134,66,132,41,36,25,165,33,166,33,
68,25,166,41,133,33,165,41,103,58,103,58,39,50,105,58,
109,50,172,66,137,58,137,66,170,74,169,66,168,66,167,58,
232,74,232,74,9,75,10,83,202,74,201,74,201,74,167,66,
136,58,43,75,169,66,136,58,136,58,168,66,168,66,135,66,
7,58,169,74,199,74,200,66,13,75,204,74,136,58,202,74,
241,74,243,50,214,42,115,34,9,34,196,41,165,33,166,25,
165,33,71,58,139,58,177,66,176,58,212,58,60,75,242,42,
79,50,77,50,41,50,41,50,138,66,168,66,104,58,203,74,
86,67,243,58,113,42,148,42,216,50,247,50,18,59,46,67,
79,67,85,67,190,75,159,67,191,67,159,67,190,67,158,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,59,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,158,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,190,67,
190,67,190,67,190,67,190,67,190,67,222,67,190,75,190,75,
190,67,190,67,190,67,222,67,222,67,222,67,190,67,190,67,
190,67,222,67,222,75,222,75,222,75,222,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,222,67,222,75,222,75,222,75,222,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,222,67,222,67,222,75,222,75,222,67,190,67,190,67,
222,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
222,67,222,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,67,190,67,
222,67,222,67,222,67,190,67,222,67,222,67,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,75,222,75,222,75,
190,67,222,67,222,67,222,75,222,75,222,67,222,67,190,67,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,222,75,190,75,190,75,222,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,222,75,222,75,222,75,222,75,222,75,
222,75,190,75,190,75,190,75,190,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,221,75,221,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,126,51,55,51,73,99,203,173,205,75,87,51,92,51,
30,51,91,59,116,67,13,51,17,59,117,67,118,59,91,51,
121,67,51,51,52,43,91,51,89,51,111,43,105,51,75,51,
171,66,175,58,17,83,80,99,19,75,91,59,157,59,246,58,
239,42,204,58,206,90,144,123,15,124,171,91,103,67,105,67,
107,67,233,50,71,42,197,33,35,17,128,8,129,8,129,8,
227,24,162,16,161,16,193,24,128,16,161,16,36,33,101,41,
162,8,194,16,129,16,129,16,129,16,129,16,129,16,130,16,
129,8,129,8,97,8,161,8,194,16,129,16,162,16,3,25,
105,33,137,25,105,17,232,8,105,25,70,25,162,8,131,16,
100,25,100,33,131,33,163,33,163,33,98,25,131,33,5,50,
36,58,69,58,69,58,36,42,69,50,134,58,135,58,37,50,
99,33,34,25,132,33,197,41,67,25,35,25,100,33,197,41,
69,50,164,33,67,25,100,33,164,41,5,50,5,50,39,58,
38,58,229,49,197,41,132,33,229,41,135,66,135,66,135,66,
136,66,38,50,37,50,102,66,167,74,200,74,200,74,200,74,
136,66,167,66,200,74,200,74,200,74,233,82,200,82,168,74,
103,58,103,66,6,66,103,74,233,82,9,83,168,74,229,49,
39,58,103,66,70,58,135,66,200,74,9,83,140,107,140,107,
75,75,39,34,198,33,197,33,135,50,105,99,112,165,142,141,
169,17,52,42,181,50,78,34,142,50,9,42,195,25,164,33,
98,17,228,33,132,25,2,9,67,17,230,33,231,33,9,42,
199,25,14,42,139,58,36,58,196,49,131,33,99,25,3,17,
228,16,2,17,34,17,68,25,197,41,228,41,199,33,13,50,
211,66,109,50,38,42,134,58,135,66,72,58,104,58,102,50,
167,66,232,74,233,74,201,74,169,66,169,66,201,74,200,74,
200,66,74,83,135,58,6,42,6,42,103,58,103,58,135,66,
102,66,137,66,200,74,167,58,202,66,204,74,169,66,103,58,
240,82,47,75,242,58,180,58,41,42,196,33,6,42,40,50,
37,50,105,58,105,50,201,58,236,66,243,66,89,67,86,51,
238,58,139,50,8,42,8,50,170,66,202,82,169,74,201,82,
75,67,171,58,79,42,248,58,93,67,25,59,241,58,45,75,
236,74,17,67,155,75,189,67,191,67,127,67,190,67,157,59,
190,67,190,67,190,67,158,67,158,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,222,67,222,67,222,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,75,
222,67,190,67,190,67,190,67,190,67,190,67,222,67,222,75,
190,67,190,67,222,67,222,67,222,75,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,222,67,222,67,222,67,222,75,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,222,67,222,75,222,75,222,75,222,67,190,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,67,222,75,
222,75,222,67,222,67,222,67,222,75,222,75,222,67,190,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,222,75,190,75,222,75,222,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,190,75,190,75,190,75,190,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,254,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
152,75,24,67,58,59,239,66,167,83,68,26,174,50,53,59,
253,50,92,67,114,67,233,50,12,59,176,75,145,59,117,51,
91,67,249,50,27,43,94,51,92,59,53,59,47,67,44,75,
199,66,164,74,136,107,173,107,81,75,180,67,151,67,59,59,
13,35,168,50,201,98,141,131,15,140,171,99,69,67,166,67,
103,51,104,59,7,59,69,42,164,33,225,8,193,16,193,16,
128,8,160,8,193,16,96,8,160,8,193,16,132,41,165,41,
162,8,194,16,194,16,162,16,129,16,129,16,129,16,97,8,
129,8,97,8,97,8,129,8,161,16,161,8,162,16,3,25,
38,33,38,25,197,0,231,8,105,25,70,17,163,8,5,25,
100,33,132,33,164,33,4,42,69,50,37,50,5,50,38,50,
196,41,196,41,4,42,4,42,69,50,102,50,134,58,37,42,
99,33,67,25,99,33,132,33,100,33,197,41,197,41,197,41,
195,33,131,25,100,25,132,33,100,33,165,41,101,33,102,33,
230,49,229,41,164,33,99,33,164,41,229,49,229,49,229,41,
71,58,229,41,37,58,135,66,135,66,135,66,71,58,103,58,
136,66,200,74,200,74,200,74,200,74,167,74,200,74,200,82,
233,82,135,74,135,74,9,91,74,91,41,83,200,74,164,41,
165,49,169,74,136,66,37,50,135,66,9,83,10,83,168,74,
104,42,6,34,5,42,229,33,135,50,10,91,44,124,77,133,
108,42,50,42,215,58,145,50,173,58,8,42,133,25,165,25,
131,17,67,17,34,17,2,17,35,17,106,50,174,58,79,42,
78,42,213,58,175,58,231,41,198,49,229,41,164,33,2,25,
36,25,1,17,34,25,68,25,67,25,98,25,102,33,205,49,
111,50,10,42,229,33,69,50,70,58,39,58,136,66,103,50,
38,50,70,58,103,58,103,58,136,66,168,66,233,74,9,83,
41,83,74,83,201,74,136,58,104,58,136,66,103,66,135,66,
135,66,39,50,71,58,38,50,104,58,170,66,234,74,201,66,
106,58,202,66,204,66,143,58,7,42,6,42,135,58,201,66,
168,66,104,58,103,50,68,42,136,58,240,74,210,58,53,59,
203,58,139,50,107,50,73,50,72,50,104,58,136,66,169,74,
200,66,137,58,112,50,93,75,223,75,88,59,108,42,104,58,
138,74,206,66,118,75,153,67,189,67,127,67,158,67,189,59,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
158,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,190,67,222,67,222,67,222,67,190,67,
222,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,222,67,222,67,222,67,222,67,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,67,222,67,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,75,190,67,190,67,190,67,190,75,190,75,222,75,222,75,
222,75,222,67,222,67,222,67,222,75,222,75,222,75,222,67,
190,67,222,67,222,75,222,75,222,75,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,67,222,75,222,75,222,67,222,75,223,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
190,75,190,75,222,75,222,75,222,75,222,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,223,75,222,75,222,75,222,75,222,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
139,67,107,58,55,67,153,67,174,34,39,42,228,57,171,50,
54,51,182,75,174,75,200,50,14,67,180,83,83,59,55,51,
88,59,57,51,91,51,157,59,123,59,54,67,239,74,105,74,
231,66,135,90,10,148,107,116,108,67,141,75,142,67,247,67,
80,59,5,42,196,65,202,106,240,131,206,107,37,67,133,75,
101,51,102,51,197,42,195,25,98,17,66,25,196,41,5,50,
2,17,34,25,196,41,131,33,196,41,225,16,34,17,193,8,
227,16,3,25,35,25,195,24,129,16,97,16,129,16,129,16,
162,16,129,16,129,16,161,16,227,24,36,33,68,33,35,25,
36,33,135,41,38,17,103,17,71,17,39,17,229,8,4,17,
2,17,99,25,5,50,69,50,3,42,228,41,37,50,102,58,
165,41,132,33,197,41,196,33,37,42,37,42,37,42,195,33,
67,25,34,25,2,17,2,17,132,33,39,58,165,41,68,25,
97,17,131,25,165,33,101,33,36,25,134,41,136,33,105,33,
6,50,6,50,197,41,165,41,132,33,100,33,164,33,229,49,
102,58,195,41,228,49,37,58,70,58,136,66,104,66,137,66,
70,50,136,66,103,58,102,58,135,66,103,66,232,82,42,91,
74,91,167,74,135,82,42,99,41,91,41,83,9,83,197,41,
68,41,136,74,201,74,70,58,135,66,200,74,168,74,136,66,
230,33,228,25,195,25,232,66,10,67,202,74,170,107,169,108,
103,42,204,33,215,66,177,58,167,50,198,66,201,66,102,50,
133,17,68,17,100,33,100,33,36,17,235,41,178,58,247,58,
114,50,207,50,170,42,6,42,103,58,102,50,38,50,133,41,
2,17,4,17,37,25,36,25,67,25,131,33,132,33,167,41,
231,25,230,25,165,25,165,33,197,41,71,58,168,66,69,50,
229,41,38,50,103,58,135,66,168,66,135,58,103,58,168,66,
232,74,233,74,201,74,169,66,72,58,72,58,71,66,168,74,
6,42,100,25,197,33,39,50,170,66,73,50,39,42,71,50,
103,66,168,66,168,74,139,66,38,42,72,42,69,42,229,41,
7,42,101,50,37,42,230,41,104,66,171,74,174,66,209,58,
207,66,112,58,79,58,10,42,198,33,6,42,105,58,169,66,
137,74,169,66,144,58,61,67,223,67,119,59,76,42,202,49,
41,66,140,66,51,67,150,59,155,67,127,67,191,67,191,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,190,67,190,67,190,67,222,67,222,67,
222,67,190,67,190,67,190,67,222,67,222,67,222,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,75,222,67,222,67,190,67,190,67,
222,67,222,75,222,75,222,67,222,67,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,67,222,67,222,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,190,67,222,67,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,67,222,75,222,75,
222,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
190,67,190,67,190,67,190,67,190,75,222,75,222,75,222,75,
222,75,222,75,222,67,190,67,222,67,222,75,222,75,222,75,
190,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
222,75,222,67,222,75,223,75,223,75,222,75,222,67,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
190,67,190,75,222,75,222,75,222,75,222,75,190,75,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,190,75,190,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,223,75,223,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,223,75,222,75,222,75,222,75,222,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
221,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
45,67,111,83,210,58,212,50,172,42,136,75,11,92,10,51,
10,67,46,75,139,75,39,59,139,42,177,42,53,59,56,51,
186,67,142,59,13,51,53,59,83,83,105,82,103,114,134,114,
132,82,70,99,12,149,41,116,197,66,103,75,199,83,72,100,
103,67,36,42,101,57,74,90,111,123,178,148,236,83,231,50,
36,51,105,67,138,42,231,25,68,34,3,51,132,67,68,59,
164,58,34,34,34,34,132,50,7,67,228,41,67,33,227,24,
132,33,164,49,132,57,3,41,162,16,129,0,193,8,99,33,
4,51,198,50,100,17,194,16,34,33,4,50,101,50,99,33,
68,41,6,50,198,33,227,24,163,24,195,16,195,16,195,16,
193,16,35,25,164,41,2,17,35,25,66,33,195,41,228,41,
69,50,199,74,166,66,101,58,163,33,99,33,67,25,35,25,
67,25,35,25,35,25,3,17,3,17,198,41,230,41,68,25,
4,17,68,25,99,25,164,33,229,41,231,41,199,33,168,41,
229,49,197,41,230,49,7,50,230,49,133,33,133,33,165,41,
71,58,103,58,5,50,196,41,5,50,38,50,72,58,169,74,
103,50,103,58,5,50,37,50,200,74,9,83,40,75,40,75,
168,74,70,58,135,66,10,83,200,74,167,74,9,83,168,74,
196,41,103,58,201,74,169,66,137,66,233,74,168,66,5,42,
200,33,197,33,198,58,71,67,199,58,167,58,171,99,198,74,
41,75,70,42,73,42,236,66,8,67,39,67,41,75,228,33,
171,25,168,25,68,17,196,33,195,33,168,25,145,50,242,58,
215,42,58,67,174,50,38,42,39,50,135,66,131,58,39,50,
3,25,2,25,34,25,99,33,196,41,165,41,100,25,134,33,
105,25,136,33,134,25,133,33,196,33,229,41,38,50,229,41,
197,41,164,41,38,50,168,74,136,66,104,58,136,66,104,58,
104,58,71,58,136,58,233,66,169,66,136,58,104,66,6,50,
133,17,102,25,231,41,135,58,168,58,9,34,8,42,71,50,
69,50,102,58,168,66,169,66,106,58,233,41,198,33,164,33,
163,33,70,58,136,58,104,58,168,66,71,50,202,74,170,66,
208,50,244,58,181,50,145,50,137,50,135,66,137,74,136,66,
198,66,136,58,179,58,191,75,27,76,209,42,115,50,80,42,
43,42,134,74,212,66,148,67,116,75,127,67,255,59,158,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,158,67,158,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,222,67,222,67,190,67,190,67,222,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,75,222,75,222,67,222,67,222,67,190,67,190,67,190,67,
222,75,222,75,222,67,190,67,190,67,190,67,222,67,222,67,
222,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,190,67,190,67,190,67,190,67,222,67,222,67,222,67,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,67,190,67,190,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,67,222,75,222,75,
190,67,222,67,222,67,190,67,190,67,222,75,222,75,222,67,
222,75,222,75,222,75,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,190,75,190,75,222,75,222,75,222,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,221,75,221,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,253,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
203,91,142,83,84,67,90,59,25,59,209,58,173,50,17,59,
84,59,18,51,236,42,10,51,240,50,87,59,151,67,53,59,
16,59,13,59,11,51,47,51,50,67,171,74,133,82,4,74,
132,74,197,82,103,107,197,90,164,74,103,83,69,75,133,67,
70,67,4,42,4,49,73,98,236,114,81,140,173,91,231,58,
138,67,139,75,201,50,168,42,231,58,229,50,5,51,38,59,
135,83,37,67,4,59,228,50,4,59,164,50,165,58,100,58,
37,59,164,50,99,50,226,41,162,33,227,33,2,34,132,50,
163,42,71,67,4,34,33,17,68,50,164,58,132,50,162,33,
193,24,164,33,132,25,67,25,2,25,34,17,196,33,130,25,
2,17,3,17,35,25,227,16,68,25,68,33,132,33,132,33,
70,58,167,66,4,50,163,33,66,25,66,25,34,25,35,25,
230,49,100,33,35,25,2,17,2,17,68,25,100,33,68,25,
100,25,68,25,68,25,133,33,231,41,166,41,101,25,101,25,
132,33,132,33,133,33,198,41,6,50,165,41,165,41,6,50,
136,66,135,66,38,50,6,50,6,50,229,41,71,58,136,66,
233,74,200,74,135,66,135,66,233,82,8,75,231,66,167,66,
168,74,5,50,38,58,200,74,168,74,167,66,9,83,41,91,
70,66,38,58,71,66,135,66,136,66,233,82,10,83,168,74,
39,50,200,66,69,42,37,42,38,42,233,74,202,99,136,99,
9,83,134,66,71,58,233,74,8,75,101,58,229,41,228,41,
166,33,37,17,36,17,101,33,167,41,201,33,238,33,151,58,
60,67,180,50,10,26,232,33,196,33,133,33,165,33,230,41,
101,33,36,25,35,25,68,25,165,33,197,41,69,25,69,25,
169,33,201,33,102,25,68,25,99,25,132,33,229,41,230,41,
197,41,229,41,6,50,71,58,168,66,168,66,136,66,137,66,
38,58,39,50,136,58,201,66,169,58,104,50,72,58,7,50,
12,42,202,41,73,58,169,66,136,58,199,33,201,41,106,66,
39,50,39,50,104,58,137,66,105,58,40,50,71,50,102,50,
6,50,71,58,201,66,168,66,201,66,136,58,169,66,169,66,
171,58,240,66,211,66,239,66,168,58,134,66,136,66,199,66,
168,74,137,66,208,66,118,67,151,67,178,50,145,50,177,50,
12,42,7,50,210,58,183,67,178,83,155,75,222,67,158,75,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,222,67,222,67,190,67,190,67,222,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,67,222,67,190,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,67,222,67,222,67,222,75,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,67,222,75,222,75,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,222,75,222,75,190,67,190,67,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,253,75,253,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
254,75,253,75,253,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
71,75,232,58,238,83,178,67,53,59,179,58,113,42,56,67,
155,67,249,67,114,59,46,59,236,50,109,51,44,51,105,50,
167,66,11,67,138,75,138,67,46,67,203,58,165,58,67,58,
68,58,3,58,3,66,2,74,132,82,103,91,166,75,197,67,
37,59,37,42,133,65,201,106,169,98,111,115,77,83,41,67,
167,42,42,59,202,50,169,50,169,50,200,50,39,59,37,51,
37,67,228,58,102,67,69,67,3,51,227,50,69,67,36,59,
132,59,67,51,68,59,228,58,67,50,164,58,131,58,4,67,
37,75,228,50,66,26,34,34,196,50,196,42,228,50,99,50,
163,41,195,33,36,42,66,25,224,8,3,34,196,50,38,67,
196,33,34,17,165,41,39,50,197,41,229,41,6,50,131,33,
196,41,5,50,163,41,195,41,4,50,37,50,196,33,99,25,
132,33,67,25,34,25,67,25,67,25,34,17,2,17,35,17,
66,25,2,17,4,17,135,33,232,41,134,33,67,25,131,25,
132,33,133,33,68,25,35,17,100,25,67,25,67,25,229,41,
70,58,70,58,6,50,104,66,104,66,38,50,70,58,37,50,
168,66,168,66,200,74,200,74,9,83,41,83,232,74,199,66,
168,74,38,58,70,58,135,66,103,66,102,66,168,74,74,91,
10,91,103,74,71,66,168,74,168,74,201,82,10,91,42,91,
41,83,200,66,228,33,197,33,169,58,233,74,202,99,8,108,
167,82,230,90,137,107,40,91,227,49,131,33,132,33,131,33,
196,41,2,17,193,16,35,25,199,41,8,42,170,25,82,50,
246,50,46,26,207,17,53,42,235,33,104,17,73,25,135,25,
135,33,167,41,232,49,230,41,165,33,133,33,101,25,69,25,
103,25,70,25,4,17,35,17,100,33,165,33,230,41,39,50,
137,66,137,66,39,58,229,41,38,50,103,58,71,58,103,58,
6,50,39,58,104,58,169,66,169,66,104,58,72,50,40,50,
105,58,7,50,168,66,169,74,72,58,199,41,199,41,232,49,
105,58,8,50,8,50,105,58,234,74,233,74,200,66,168,66,
41,58,72,50,232,74,200,66,201,66,137,58,138,58,170,58,
170,66,234,66,205,66,175,66,105,58,69,58,70,58,105,58,
137,66,171,74,15,83,238,58,211,58,181,66,208,66,242,58,
175,66,41,50,246,66,82,67,46,75,84,75,190,67,189,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,190,67,222,67,222,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,190,67,190,67,222,67,222,67,190,67,190,67,222,67,
222,67,222,67,190,67,190,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,75,222,75,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
190,67,222,67,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,75,222,75,222,67,222,67,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,75,222,75,222,75,222,75,222,75,222,75,222,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,223,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,222,75,222,75,222,75,222,75,254,75,
254,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,253,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
253,75,221,75,221,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
9,67,164,25,102,50,137,50,172,58,140,58,237,58,244,75,
218,75,52,76,140,67,140,83,172,83,201,67,37,59,130,66,
4,75,102,67,233,75,169,75,73,67,232,50,198,50,162,58,
68,50,162,41,194,49,35,66,132,74,70,83,166,75,197,67,
69,59,166,50,103,74,138,115,74,107,109,107,174,75,140,75,
232,50,104,34,7,26,8,34,72,42,8,59,135,67,4,51,
132,42,132,42,38,67,6,59,99,42,66,34,196,50,197,58,
69,67,69,67,37,67,99,50,0,25,34,49,130,49,3,58,
132,66,163,50,36,59,134,75,195,50,163,34,37,59,228,66,
132,66,165,50,230,58,4,42,194,33,164,50,163,42,4,59,
198,58,194,33,195,41,102,58,102,58,167,66,102,58,98,25,
34,25,67,33,67,33,228,41,135,66,232,74,167,66,37,42,
34,25,67,25,67,25,67,25,99,33,35,25,2,17,35,25,
2,17,2,17,68,25,135,33,199,41,101,33,99,25,163,33,
100,33,198,41,165,33,132,33,197,33,164,33,131,33,228,41,
164,41,5,50,6,50,72,58,7,50,38,50,232,74,199,74,
135,58,9,75,42,83,232,82,9,83,9,83,167,66,134,66,
135,66,37,50,102,66,135,66,168,74,41,83,106,99,204,107,
74,99,200,82,136,74,137,74,137,74,169,74,10,91,74,99,
41,83,70,58,5,42,6,42,201,66,9,75,76,116,9,108,
72,91,168,99,169,99,133,58,134,58,200,66,168,58,102,42,
101,58,68,58,2,17,163,8,136,33,238,41,17,42,81,42,
123,34,152,34,25,51,61,67,84,42,206,25,201,33,101,25,
135,33,41,58,170,74,105,58,165,33,165,33,165,33,100,25,
8,42,199,33,68,17,3,17,68,25,132,33,165,33,231,41,
230,41,7,50,230,41,197,41,5,50,103,58,103,58,6,50,
39,58,104,66,104,66,169,66,201,66,169,58,137,58,73,50,
39,42,6,34,169,58,168,58,104,58,169,66,71,58,197,41,
73,58,232,41,166,33,7,50,233,74,200,66,104,58,73,58,
170,66,72,50,103,50,134,58,233,74,170,58,107,58,140,58,
138,66,168,58,137,50,171,58,73,50,231,49,232,49,40,50,
39,50,74,66,171,74,169,50,174,50,176,58,141,50,146,42,
142,58,137,50,58,75,45,59,202,74,47,75,187,67,221,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,75,222,75,190,67,190,67,190,67,222,67,
190,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,75,222,75,
190,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,222,67,222,67,222,67,222,67,190,67,
222,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,75,222,75,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,67,222,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
254,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
253,75,253,75,253,75,222,75,222,75,254,75,254,75,254,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
202,66,164,33,165,41,103,58,40,75,167,66,73,50,140,42,
176,42,78,59,233,50,106,75,138,75,71,59,4,59,227,74,
69,75,131,59,134,67,72,67,70,67,38,59,165,50,97,50,
101,50,227,33,35,42,6,67,102,75,101,75,102,75,69,67,
103,67,103,59,72,83,201,99,170,91,74,83,139,67,172,67,
9,59,230,25,197,17,135,42,165,50,163,42,5,51,6,51,
229,50,164,42,165,58,101,50,162,33,3,42,101,58,166,66,
230,66,197,66,100,58,227,41,128,24,130,48,36,65,131,57,
133,74,70,75,37,67,37,59,131,42,103,67,136,83,197,74,
200,99,9,92,165,50,162,33,3,42,132,42,197,50,196,58,
6,67,231,74,4,50,131,41,196,41,163,33,33,17,1,17,
34,25,34,25,67,25,131,33,196,41,70,58,167,58,37,42,
66,25,196,41,164,41,67,33,99,33,100,33,67,25,34,25,
3,17,3,17,36,25,68,25,68,25,35,17,34,17,99,25,
67,25,165,33,165,33,100,25,164,33,197,41,196,41,196,41,
131,33,5,50,71,58,71,58,6,50,70,58,232,74,134,66,
102,58,232,74,9,83,232,74,73,83,9,83,167,66,200,74,
9,83,102,58,135,66,167,74,200,74,74,91,41,91,41,91,
138,99,139,99,12,83,139,74,172,74,236,82,75,91,171,107,
74,91,200,74,102,58,200,66,135,58,232,66,137,91,71,91,
168,91,72,83,8,75,102,58,41,83,105,75,40,67,231,50,
165,66,169,91,103,58,101,25,200,33,46,50,114,50,47,34,
31,51,159,67,222,67,60,59,19,26,174,25,232,33,167,33,
134,33,105,58,11,83,136,66,164,33,196,33,70,50,38,50,
166,33,133,25,68,17,36,25,100,25,101,33,133,33,230,41,
7,50,230,41,230,41,197,41,6,50,71,58,6,50,165,33,
71,58,104,66,103,58,136,66,201,66,202,66,202,66,170,58,
16,42,240,33,45,42,199,25,164,25,137,58,202,74,135,58,
168,66,169,66,72,50,71,50,200,66,103,58,8,42,107,58,
70,50,38,50,197,41,38,50,200,66,169,58,205,66,18,75,
113,58,172,50,170,42,203,58,105,50,8,42,8,50,38,50,
172,66,108,66,76,58,174,58,205,58,171,50,144,50,24,59,
107,50,201,58,117,75,205,58,232,74,13,75,118,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,67,190,67,190,67,190,67,222,67,
222,67,222,67,222,75,222,67,190,67,190,67,190,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,190,67,190,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,190,67,190,67,222,67,222,67,222,75,
222,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,67,222,67,222,67,
222,67,222,67,222,67,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,75,222,75,222,75,222,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
254,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
198,41,102,33,172,33,46,34,8,34,99,25,134,41,230,41,
12,59,238,58,172,50,106,67,104,67,164,42,196,50,227,50,
4,59,35,59,4,51,7,67,38,67,68,67,195,58,131,58,
230,66,197,50,164,42,4,51,68,51,195,42,131,42,164,58,
165,58,37,59,38,75,71,67,7,67,231,66,72,59,74,67,
169,75,134,42,164,17,227,25,99,34,162,42,163,42,164,42,
162,34,163,42,132,50,3,50,162,41,36,58,4,50,36,50,
132,42,35,50,227,41,36,42,99,33,227,48,165,73,195,57,
3,50,165,58,229,58,197,58,67,42,6,67,6,75,3,66,
168,99,233,99,230,66,227,41,35,42,68,34,35,34,3,42,
7,67,73,91,103,74,197,57,39,66,164,33,194,8,226,16,
193,16,34,25,132,33,99,33,99,25,196,33,69,50,4,42,
99,33,197,41,196,41,67,25,35,25,132,33,132,33,35,25,
133,33,100,33,100,33,99,33,131,33,132,33,132,33,165,33,
229,49,6,50,197,33,100,25,164,33,5,42,229,49,196,41,
37,50,103,66,103,58,38,50,6,50,103,58,134,66,4,50,
200,74,200,74,135,58,167,66,9,75,167,74,135,74,9,91,
106,99,200,74,9,83,41,91,9,83,9,83,200,74,232,82,
73,91,107,91,235,82,139,74,172,74,236,82,10,83,41,83,
75,99,9,83,102,58,101,50,166,66,231,74,105,91,72,91,
229,74,134,66,135,66,37,58,5,50,4,42,3,34,131,17,
97,25,70,50,70,50,165,33,133,25,132,25,166,25,236,33,
214,34,57,51,57,59,23,59,111,34,236,33,202,33,234,41,
100,25,39,50,169,66,38,50,99,25,164,33,103,58,168,66,
39,50,165,33,35,17,3,17,68,33,198,41,7,50,71,58,
136,58,71,50,165,33,132,33,230,41,6,50,198,41,231,41,
168,66,168,66,168,66,168,66,169,66,169,66,170,66,171,58,
180,58,214,58,180,58,75,42,198,25,232,41,73,58,134,58,
167,66,233,74,168,66,168,66,168,66,7,50,199,33,42,50,
4,42,6,50,166,41,230,49,103,58,71,50,108,50,210,66,
219,66,212,50,144,42,176,50,109,50,73,50,8,50,7,42,
202,58,205,74,175,74,245,74,208,58,104,42,46,42,146,42,
172,66,10,67,46,75,140,50,171,66,9,67,19,59,157,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,222,67,222,67,190,67,222,67,222,67,
222,67,222,75,222,75,222,67,190,67,190,67,190,67,222,67,
222,67,222,75,222,75,222,67,222,67,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,222,67,222,67,222,67,222,75,222,75,222,75,
222,67,222,67,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,75,222,75,223,75,
222,67,222,67,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,223,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,222,75,253,75,253,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,253,75,253,75,253,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
117,50,246,41,219,58,89,59,46,26,103,17,166,33,104,58,
234,91,201,58,133,42,71,51,105,75,230,82,199,99,37,59,
228,58,165,66,67,50,165,58,230,66,196,58,195,58,229,58,
5,59,102,67,135,67,166,67,166,67,36,59,132,58,101,66,
133,82,198,66,165,66,5,59,196,58,73,99,231,74,133,66,
134,67,103,67,230,58,68,34,227,25,35,34,99,34,33,26,
130,34,5,59,197,66,100,58,36,58,133,66,3,42,165,50,
164,34,226,33,194,41,101,50,102,50,132,49,70,82,166,74,
5,75,164,42,231,50,72,75,6,67,135,83,168,99,36,74,
195,57,68,66,7,91,165,74,197,66,103,67,164,42,133,58,
170,99,74,107,169,98,169,98,108,107,136,66,68,25,194,16,
98,25,229,41,5,50,99,25,99,33,131,33,228,41,196,41,
164,41,132,33,99,33,35,25,2,25,67,33,132,33,68,33,
197,41,132,33,99,33,99,33,132,33,132,33,132,33,100,33,
197,41,229,49,164,33,99,25,164,33,164,33,99,33,99,33,
228,41,70,58,168,74,167,66,135,66,103,66,5,50,6,50,
200,74,200,74,70,58,135,58,135,66,70,58,200,82,42,91,
233,82,200,74,233,82,9,83,232,82,200,74,200,74,41,91,
8,83,200,74,169,74,170,74,203,82,234,90,233,82,233,82,
74,99,74,91,135,66,163,33,101,58,231,74,170,99,231,74,
40,83,232,82,100,66,196,82,227,49,228,49,130,33,67,17,
65,17,164,33,5,50,5,50,197,41,67,25,69,25,205,49,
116,42,117,50,47,34,11,34,166,17,72,17,38,17,69,25,
68,25,133,33,165,33,165,33,100,33,132,33,6,50,38,58,
135,58,197,33,132,33,132,33,198,41,71,58,103,58,70,58,
38,50,229,41,197,33,229,41,230,41,198,41,231,49,105,66,
106,83,74,83,9,83,233,82,201,74,169,66,138,58,73,50,
79,42,178,50,112,42,44,34,167,33,167,41,72,58,200,66,
136,66,135,58,135,58,135,58,136,58,39,50,6,42,230,41,
228,41,165,41,198,41,231,49,71,58,72,50,10,42,45,42,
182,66,182,50,117,42,145,50,75,50,11,50,235,49,231,41,
68,42,200,66,172,66,208,66,140,58,137,58,170,66,170,58,
139,58,203,66,172,66,138,58,174,66,11,67,242,58,90,67,
190,67,189,67,189,67,189,67,190,67,222,67,190,67,189,67,
157,59,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,75,222,75,222,67,190,67,190,67,222,67,222,75,
222,67,222,75,222,75,222,67,222,67,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,67,222,67,222,67,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,223,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,253,75,221,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,253,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
50,35,249,50,94,59,92,59,248,50,208,58,230,25,36,26,
134,58,233,82,106,83,199,42,101,50,163,123,169,181,233,91,
102,91,166,74,163,41,133,50,38,67,164,58,164,50,70,59,
4,51,4,51,228,50,163,42,130,42,131,50,35,50,164,41,
133,106,200,90,232,82,135,91,228,74,12,132,41,99,164,90,
136,75,69,59,68,67,228,50,2,26,195,17,228,25,195,17,
66,34,197,50,68,50,228,41,195,41,4,42,3,26,136,67,
103,51,227,41,195,49,101,50,167,50,132,41,164,57,4,58,
195,50,132,34,8,51,69,42,67,42,4,67,200,107,68,74,
225,48,33,41,3,66,67,74,131,58,101,67,134,67,197,58,
6,83,73,107,41,115,9,115,42,99,99,33,193,8,100,33,
134,58,167,66,229,41,160,8,2,17,99,33,229,49,37,58,
165,41,67,25,132,33,197,41,100,33,68,33,35,33,226,16,
131,33,34,25,34,25,100,33,133,33,100,33,67,25,67,25,
70,58,103,66,229,49,132,33,165,41,132,33,99,33,229,49,
37,58,70,58,135,66,135,66,167,74,102,58,229,49,104,66,
167,66,200,74,167,66,200,74,102,58,70,58,9,91,233,90,
168,74,232,74,168,74,167,74,9,83,41,91,9,83,74,91,
9,91,103,66,70,66,168,82,168,82,168,82,201,90,234,90,
8,91,8,83,200,74,200,66,69,50,101,58,198,74,3,50,
9,75,36,50,194,66,9,149,226,49,34,25,66,25,101,25,
227,24,196,41,102,66,229,82,37,83,199,74,136,74,102,66,
74,42,49,50,174,41,106,33,70,25,105,33,101,33,35,17,
67,25,100,33,197,41,7,50,198,41,100,33,164,41,197,49,
229,33,132,25,165,33,165,33,132,33,230,49,70,58,102,58,
229,41,164,33,38,50,168,66,39,50,231,41,106,66,12,83,
171,91,106,83,41,83,41,83,10,83,10,83,203,74,106,58,
17,34,178,58,13,34,201,25,133,33,164,41,38,58,137,66,
73,58,230,41,5,42,70,50,6,42,7,50,70,50,3,42,
165,33,165,41,137,74,137,74,230,49,199,41,168,33,10,34,
232,33,78,42,179,58,177,58,8,42,165,33,199,41,232,41,
233,41,105,66,138,66,202,66,137,58,140,66,171,74,107,58,
105,58,142,66,108,66,138,58,204,58,209,58,16,59,56,67,
221,67,189,67,189,67,189,67,189,67,221,67,189,67,189,67,
157,59,158,67,190,67,190,67,190,67,190,67,190,67,222,67,
190,67,222,67,222,67,190,67,190,67,222,67,222,67,190,67,
190,67,190,67,190,67,190,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,223,75,223,75,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,67,190,67,190,67,222,67,222,75,
222,67,222,75,222,75,222,67,222,67,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,190,67,
223,75,222,75,222,75,222,67,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,67,222,75,222,75,222,75,222,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,223,75,222,75,222,75,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,223,75,223,75,
223,75,223,75,223,75,223,75,223,75,223,75,223,75,223,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,254,75,254,75,254,75,254,75,222,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
255,75,254,75,254,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
253,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,222,75,221,75,221,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
221,75,222,75,222,75,254,75,254,75,254,75,253,75,253,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
74,42,119,58,61,59,157,51,216,59,138,34,164,17,133,17,
196,41,9,67,169,67,233,75,35,42,166,74,230,74,194,58,
165,58,100,50,6,74,201,106,132,65,131,57,68,50,164,58,
131,50,35,50,68,58,100,50,132,50,68,66,163,57,2,41,
70,98,135,106,134,82,40,83,166,74,233,106,74,123,233,90,
168,91,134,75,198,75,102,59,132,42,69,42,228,33,37,42,
101,50,36,42,4,34,162,17,35,34,197,50,99,34,196,58,
165,50,5,43,131,58,41,107,10,91,203,98,203,122,6,74,
36,42,68,66,166,74,165,58,194,33,98,49,99,65,38,74,
162,40,6,74,167,90,102,82,166,74,71,67,7,59,198,66,
7,75,167,74,71,90,75,123,200,90,1,25,2,17,69,33,
133,41,68,33,3,25,193,8,2,17,34,25,131,33,229,49,
99,33,34,25,132,33,100,33,2,25,67,33,35,33,35,25,
132,33,132,33,2,17,35,25,100,33,99,33,34,25,131,33,
103,66,135,66,5,50,196,41,70,58,196,41,196,41,5,50,
37,50,232,74,167,66,134,58,134,66,37,50,6,50,104,66,
103,66,168,74,103,66,70,66,70,66,136,74,200,90,168,82,
41,91,9,83,232,74,167,66,102,66,167,74,9,83,9,91,
106,83,9,83,200,74,70,66,168,82,168,82,168,74,136,66,
104,74,201,82,232,82,199,66,133,58,37,50,4,50,196,41,
7,50,201,41,134,33,105,91,101,58,135,33,4,17,98,25,
67,17,164,33,4,42,166,66,200,91,73,108,105,116,72,108,
76,116,142,124,78,116,205,107,10,83,38,58,132,41,3,25,
68,33,100,33,6,50,103,58,71,58,229,41,6,50,7,50,
196,33,5,42,6,50,100,33,35,25,67,25,165,41,72,66,
230,41,229,49,71,58,70,58,135,66,74,83,107,83,107,83,
74,83,106,91,41,83,9,83,41,83,42,75,234,66,170,58,
77,42,181,66,77,50,198,25,234,41,167,33,229,41,166,66,
104,66,100,33,165,33,6,50,103,58,6,42,38,50,229,41,
132,33,39,50,201,66,9,75,200,66,70,50,72,50,172,74,
180,50,78,34,106,42,44,50,198,41,199,41,197,41,39,58,
136,58,171,58,139,58,169,66,137,74,40,58,108,50,211,58,
144,58,203,66,144,58,108,50,172,58,16,75,174,50,95,75,
223,67,189,67,151,67,121,67,191,75,189,67,188,67,188,75,
155,67,189,67,190,67,191,59,190,67,190,67,190,67,223,75,
190,67,222,67,222,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,67,190,67,222,67,222,75,222,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,75,222,75,222,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,75,222,67,222,67,222,75,222,75,190,67,190,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,222,75,222,75,222,67,222,67,222,75,223,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,75,190,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,67,
190,67,190,75,222,75,222,75,255,75,222,75,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,254,75,254,75,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,223,75,222,75,222,75,190,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,222,75,254,75,254,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,254,75,254,75,254,75,254,75,222,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,253,75,253,75,253,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
221,75,221,75,221,75,221,75,254,75,254,75,254,75,254,75,
10,50,145,33,251,66,126,67,247,50,11,34,201,41,137,25,
132,33,229,33,36,34,165,50,165,58,70,58,166,74,197,66,
68,50,101,58,103,82,200,90,34,41,1,33,194,33,35,50,
194,65,4,90,5,82,134,82,100,74,68,74,103,98,165,73,
34,49,196,73,69,74,101,74,105,107,74,115,168,98,38,66,
6,75,167,83,198,75,4,43,99,26,198,50,101,42,194,25,
35,34,67,34,35,34,100,42,133,42,165,50,100,42,132,42,
100,42,228,58,37,75,39,91,233,98,170,106,10,115,138,107,
199,74,195,41,37,58,101,66,4,50,162,41,4,66,228,73,
131,65,4,74,134,82,165,82,100,58,67,34,164,50,136,83,
73,91,201,90,169,106,141,139,75,115,196,49,193,16,226,16,
1,17,34,17,98,25,98,25,102,58,167,66,37,58,37,58,
132,33,2,17,2,17,2,25,193,16,35,25,2,25,2,25,
34,25,34,25,35,25,100,33,100,33,229,41,197,41,66,25,
164,41,229,49,229,49,196,41,5,50,229,41,38,58,168,66,
134,58,70,58,69,58,101,58,37,50,37,50,168,66,136,66,
135,66,200,74,71,58,70,66,168,74,135,74,103,74,200,82,
167,74,200,74,135,66,102,58,200,74,9,83,232,82,200,82,
138,91,106,91,9,83,135,74,74,107,9,91,233,82,9,83,
233,90,135,74,70,58,70,58,37,58,196,41,131,33,99,33,
138,33,210,49,51,66,74,58,166,58,39,50,36,17,66,17,
132,25,100,25,67,25,196,33,101,50,231,66,72,83,71,75,
232,91,41,100,42,108,171,116,12,133,171,124,169,99,167,66,
40,58,198,41,132,33,164,33,37,50,5,50,5,50,196,41,
132,33,165,41,197,41,100,33,2,17,2,17,100,33,38,58,
102,58,167,66,200,74,167,74,167,66,233,74,10,75,11,75,
167,58,167,66,103,58,168,66,10,83,42,83,233,66,135,50,
73,42,237,33,140,25,102,17,230,33,199,41,230,41,105,66,
202,74,6,50,230,41,198,41,6,42,229,41,6,42,197,33,
68,33,198,41,136,66,41,83,8,75,38,50,199,41,42,50,
180,50,182,50,152,50,83,34,234,25,39,42,39,50,38,50,
136,58,171,66,138,58,104,58,71,58,72,58,138,58,45,42,
76,50,200,58,79,58,81,50,140,50,237,66,210,58,159,75,
255,67,190,67,88,59,56,59,191,75,223,75,188,67,121,59,
123,67,189,67,222,75,223,67,222,67,190,67,190,67,158,67,
190,67,222,67,222,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,190,67,190,67,222,75,222,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,222,67,222,75,222,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,67,190,67,222,75,222,75,190,67,190,67,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,67,
190,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,254,75,254,75,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,222,75,222,75,254,75,254,75,254,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
221,75,221,75,221,75,221,75,254,75,254,75,254,75,254,75,
196,25,72,9,149,42,28,59,214,42,77,34,110,50,241,58,
9,42,73,42,72,42,69,42,8,67,135,58,69,50,68,50,
133,66,4,42,99,41,99,33,193,16,66,41,162,33,129,33,
131,81,71,122,229,89,38,106,102,90,36,58,5,82,230,89,
193,24,193,32,167,98,170,123,133,82,4,74,164,57,6,58,
68,50,37,59,101,59,228,42,34,26,35,34,67,42,99,42,
131,34,164,42,68,34,36,42,167,66,101,50,68,34,101,42,
198,66,132,58,132,58,40,99,10,115,202,114,111,140,137,99,
167,66,67,33,229,57,107,107,168,74,102,66,231,82,198,82,
133,74,3,66,100,74,71,91,103,83,197,58,164,58,230,66,
134,74,104,90,203,122,106,114,169,98,164,41,34,17,131,33,
3,34,35,42,39,75,165,58,4,42,70,58,102,66,70,58,
132,41,2,25,226,16,2,17,194,16,2,25,194,16,226,16,
67,25,35,25,2,17,68,33,68,25,99,33,132,33,229,41,
38,58,103,66,200,74,168,74,168,74,168,66,168,66,168,66,
102,58,102,58,134,58,167,66,37,50,5,50,70,58,71,58,
167,66,9,75,200,74,232,74,9,83,102,66,70,58,232,82,
232,82,74,91,9,83,167,66,167,74,200,74,200,74,232,82,
106,91,106,91,171,107,138,107,171,115,74,99,74,91,9,83,
199,82,134,66,102,66,71,58,197,41,35,25,35,33,100,41,
136,33,137,41,108,66,233,41,231,41,68,17,228,8,104,33,
230,41,67,17,66,17,5,42,135,58,135,58,199,66,232,66,
136,75,201,83,201,83,200,83,168,83,136,83,7,67,8,67,
235,99,169,91,166,66,227,33,163,33,98,25,67,25,2,17,
194,8,3,17,100,25,68,25,67,25,196,41,70,58,200,74,
8,83,41,83,8,83,232,74,233,74,201,74,137,58,232,41,
232,41,41,50,73,58,138,66,170,74,170,66,169,66,137,58,
168,50,106,50,112,58,201,41,130,25,100,25,198,41,139,74,
136,58,197,33,165,33,229,41,71,58,6,50,6,50,5,50,
133,41,230,57,103,66,232,74,9,83,104,58,200,33,235,41,
82,42,48,42,153,50,125,59,247,42,106,42,231,49,165,41,
39,50,41,50,73,50,72,50,40,50,137,58,201,66,8,34,
42,42,169,66,172,66,146,58,113,50,208,66,243,58,157,75,
254,67,191,75,57,59,57,51,191,67,223,67,221,75,86,51,
89,67,188,75,222,75,255,67,223,67,222,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,222,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,190,67,190,67,222,75,222,75,222,67,222,67,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,254,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,254,75,254,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,221,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,253,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,221,75,
221,75,221,75,221,75,254,75,254,75,254,75,254,75,254,75,
231,58,196,25,170,17,52,34,242,58,75,42,15,42,211,50,
209,50,208,58,42,42,38,34,41,59,138,67,134,42,35,42,
69,58,130,25,225,16,226,16,226,24,164,49,195,33,129,25,
131,65,135,114,69,82,196,81,199,90,165,42,192,32,2,57,
161,24,161,32,99,65,40,107,100,66,3,50,229,57,136,74,
129,25,229,58,70,67,164,42,226,25,227,41,68,58,100,58,
5,59,197,50,100,50,4,50,70,66,135,74,228,41,163,25,
6,50,167,66,228,57,39,82,142,131,203,106,71,66,134,58,
131,25,68,49,137,98,47,132,38,58,66,41,3,58,5,67,
197,74,3,66,35,66,39,75,201,83,169,91,39,83,100,50,
200,82,39,82,41,106,208,155,210,164,49,157,167,66,134,58,
38,67,70,67,104,75,165,50,3,34,5,42,196,33,67,25,
100,33,67,25,35,25,67,25,226,16,194,16,161,8,3,25,
3,25,68,33,35,25,2,17,193,8,226,16,132,33,6,50,
5,50,38,50,168,66,135,66,103,66,168,74,135,66,70,58,
69,50,69,50,102,58,102,58,5,50,196,41,229,41,38,50,
135,66,167,66,232,74,171,99,12,108,171,99,73,83,8,75,
232,82,9,83,74,91,9,83,167,66,200,74,106,99,171,107,
204,107,138,99,235,107,203,115,138,107,73,99,139,99,106,91,
73,99,105,99,73,91,135,66,132,41,2,25,2,25,2,25,
198,41,132,33,163,41,199,74,38,50,101,33,166,33,71,58,
103,58,131,25,33,9,4,42,167,58,167,58,167,58,167,58,
8,67,8,67,200,58,136,50,136,50,200,58,232,58,138,83,
70,67,70,75,6,67,165,58,134,66,38,50,229,49,100,33,
36,25,101,25,101,33,67,25,164,33,167,66,41,83,106,91,
171,99,74,91,199,66,134,66,168,66,169,66,72,50,231,41,
236,49,108,58,139,66,137,66,136,66,137,66,170,66,171,66,
169,58,9,42,237,41,200,33,196,41,197,41,6,50,105,66,
168,58,39,42,6,42,6,42,39,50,229,41,6,50,71,58,
7,58,39,58,103,66,200,74,42,83,203,66,44,42,80,50,
146,50,169,33,48,42,189,75,57,59,232,41,164,49,230,49,
39,58,232,49,39,50,105,50,107,58,171,66,169,66,5,42,
40,42,138,66,205,66,210,58,115,50,239,66,48,67,158,75,
223,67,191,75,121,59,122,59,190,67,190,67,254,75,56,51,
56,59,122,67,189,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,67,190,67,190,67,190,67,222,67,222,67,190,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,222,67,
222,67,222,67,190,67,190,67,190,67,190,67,222,67,222,67,
222,67,190,67,190,67,222,75,222,75,222,67,222,67,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,190,67,190,67,222,67,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,254,75,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,222,75,222,75,222,75,
254,75,254,75,221,75,221,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,253,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,253,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,221,75,221,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
106,75,166,50,12,34,88,42,181,50,173,25,242,33,246,50,
17,59,142,50,71,25,6,42,41,75,41,67,231,66,6,75,
227,33,65,9,192,16,161,16,161,24,35,49,163,33,129,17,
97,33,4,74,3,42,98,49,36,66,133,34,128,24,160,40,
227,48,67,57,134,90,39,99,168,99,103,75,195,33,1,25,
36,42,132,50,132,42,68,42,195,41,99,41,228,57,134,74,
197,58,35,42,36,58,167,90,5,82,107,123,200,90,65,33,
164,33,196,41,226,40,72,98,206,123,234,90,100,49,99,25,
164,33,72,82,174,139,80,140,234,90,131,49,68,66,6,67,
165,66,101,74,166,74,72,75,169,75,235,99,203,99,8,75,
167,82,103,90,73,106,109,139,176,156,20,182,137,91,166,58,
38,59,71,67,71,67,7,59,134,50,70,50,229,41,67,25,
131,33,34,25,2,17,35,25,35,25,3,25,194,16,3,25,
3,25,226,24,100,33,197,41,67,25,67,25,229,41,229,41,
196,41,196,41,5,50,196,41,164,41,103,58,168,74,200,74,
70,50,196,33,164,33,164,33,131,33,229,41,103,58,135,66,
134,66,167,66,73,83,235,99,203,99,106,83,106,91,8,75,
9,83,200,74,41,83,41,83,167,74,199,74,9,83,9,83,
9,83,232,82,232,82,8,83,105,99,105,91,105,91,106,99,
8,83,8,83,9,91,167,74,38,58,38,58,196,49,1,25,
67,41,198,57,132,41,168,82,166,74,133,66,68,58,196,41,
38,50,5,42,164,33,228,33,134,58,167,58,134,50,134,50,
69,42,4,42,196,33,229,33,103,50,233,66,41,75,12,100,
137,75,166,50,68,42,36,42,4,50,228,49,69,58,69,58,
69,25,101,33,133,33,165,33,71,58,9,83,73,83,8,83,
233,74,233,74,200,74,103,58,135,66,136,66,7,50,72,50,
107,58,171,66,137,58,135,58,135,58,200,74,233,74,169,74,
169,66,233,41,166,33,199,41,73,58,72,58,136,66,168,74,
168,58,201,66,136,58,197,33,164,33,197,41,71,58,168,74,
71,58,6,50,135,58,9,75,10,75,237,66,176,58,179,50,
47,34,108,33,176,33,214,50,207,50,198,41,69,58,232,66,
103,66,39,58,71,50,137,58,206,66,238,74,202,66,103,58,
75,50,138,58,206,66,175,58,145,50,15,67,78,67,156,75,
158,67,189,75,86,59,89,59,191,67,221,67,30,76,155,67,
87,67,121,67,188,75,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,75,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
190,67,190,67,190,67,190,67,190,67,222,67,222,67,222,67,
222,75,222,67,190,67,190,67,190,67,190,67,222,67,222,75,
222,75,190,67,190,67,222,75,222,75,222,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,222,75,222,67,222,67,222,75,222,75,222,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,222,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,221,75,221,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
221,75,221,75,254,75,254,75,254,75,254,75,254,75,254,75,
253,75,253,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
170,75,169,75,13,59,56,59,151,75,13,26,16,26,242,42,
232,25,102,25,194,24,228,57,8,99,164,57,4,66,3,74,
133,58,195,17,160,16,64,8,129,32,36,57,196,49,65,17,
163,33,98,33,129,17,162,41,130,33,163,33,100,57,229,73,
3,57,131,57,231,90,42,124,232,99,232,83,197,58,4,50,
194,33,35,42,35,42,227,33,196,49,132,49,131,49,227,57,
226,41,96,25,195,49,4,66,70,98,233,122,236,131,195,49,
228,41,69,50,225,40,39,106,9,83,228,41,99,49,196,41,
99,33,6,66,170,98,11,115,10,107,135,74,69,66,36,58,
166,66,167,74,232,74,203,83,235,83,170,83,137,83,40,83,
39,83,200,90,75,123,136,90,231,82,230,66,164,58,133,58,
197,58,6,67,104,75,105,75,69,42,196,33,229,41,164,33,
229,49,196,41,164,33,164,33,67,25,2,17,194,16,2,17,
35,33,67,33,38,58,233,82,168,74,229,49,6,50,38,50,
5,50,229,41,164,41,132,33,132,33,38,50,70,58,70,58,
229,49,196,41,196,41,164,41,197,41,197,41,197,41,38,58,
69,66,37,58,166,66,105,83,138,91,73,83,8,75,134,66,
167,74,167,74,232,74,9,83,200,74,135,66,135,66,135,66,
168,74,167,74,232,74,41,91,73,91,73,91,105,91,41,91,
9,83,232,82,200,82,102,66,37,58,71,58,104,58,230,41,
225,32,33,41,164,57,136,82,7,83,102,91,38,83,5,50,
164,33,229,41,196,33,5,42,135,58,103,50,5,42,228,33,
6,42,102,58,101,50,166,58,135,58,168,58,201,66,205,99,
73,67,228,25,66,17,99,25,34,25,225,16,229,49,168,74,
7,50,198,41,230,41,71,58,168,66,200,74,102,58,5,42,
133,33,230,41,103,58,135,58,168,66,136,66,230,41,103,58,
137,66,170,66,105,58,73,50,105,58,201,74,9,75,199,66,
135,58,105,58,38,50,166,33,169,41,232,49,106,66,168,66,
39,50,71,50,230,41,132,25,132,33,229,41,38,50,38,50,
71,50,6,42,168,66,169,66,71,42,172,58,240,66,113,42,
47,26,49,50,49,50,114,42,12,51,73,50,7,42,168,50,
71,58,39,58,103,58,137,58,238,74,14,75,235,74,202,74,
109,58,140,66,12,75,235,58,209,66,16,75,44,67,87,67,
125,67,188,75,53,51,23,51,223,75,221,67,188,67,155,75,
21,59,55,67,155,67,222,75,222,67,222,67,222,67,223,67,
190,67,190,67,190,67,222,67,222,67,190,67,190,67,222,67,
222,75,190,67,190,67,190,67,222,67,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,254,75,
190,67,190,67,190,67,190,67,222,67,222,75,222,67,222,67,
222,75,222,75,222,67,190,67,190,67,222,67,222,75,222,75,
222,75,222,67,222,67,222,75,222,75,222,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,67,222,75,222,67,222,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,255,75,222,75,222,75,222,67,222,67,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,255,75,255,75,255,75,255,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,223,75,223,75,222,75,222,75,222,75,222,75,223,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,254,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,255,75,255,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,253,75,253,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,221,75,221,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
37,42,71,83,230,58,172,50,44,67,165,33,136,25,173,50,
229,33,3,25,128,16,224,40,229,89,100,73,132,73,4,90,
36,50,4,34,34,25,128,8,129,32,4,65,229,65,192,24,
131,41,98,33,194,33,165,58,163,41,34,33,229,65,232,90,
131,57,133,66,193,33,233,107,135,99,5,67,102,75,5,75,
101,66,3,42,193,33,64,17,97,33,130,41,35,50,70,83,
131,58,67,50,197,66,227,49,102,82,196,65,73,99,36,50,
68,50,36,42,66,41,67,49,196,41,131,41,99,49,196,49,
5,58,6,66,6,74,38,82,229,65,229,65,229,65,71,82,
73,91,73,83,73,75,235,91,44,92,137,67,72,75,72,83,
38,75,40,91,105,107,72,91,38,75,135,75,197,58,3,50,
100,50,198,66,133,58,166,58,166,58,101,58,36,50,134,66,
102,58,167,74,200,74,135,66,164,33,34,25,226,16,35,25,
226,24,229,57,168,74,232,82,9,83,167,66,135,58,70,58,
38,58,38,50,164,41,196,41,229,49,38,50,229,49,196,41,
229,49,70,58,71,58,6,58,38,58,197,49,67,33,163,41,
163,49,69,66,8,83,73,83,8,75,199,66,167,66,102,58,
102,66,167,74,200,74,232,74,232,74,167,66,135,66,167,74,
233,82,200,74,41,83,73,91,200,74,232,82,41,91,232,82,
233,82,9,83,74,91,233,82,6,50,198,41,233,41,201,33,
5,66,68,41,230,57,230,82,135,91,135,91,135,91,194,58,
101,66,4,50,163,33,5,50,135,66,70,50,197,33,164,25,
198,41,168,66,200,66,74,83,43,75,235,66,170,58,44,75,
199,50,196,25,34,17,227,16,194,16,162,8,133,41,39,58,
136,66,6,50,230,41,38,50,71,58,103,58,38,50,5,42,
197,33,6,42,6,50,5,50,70,58,5,50,164,33,6,42,
104,66,106,66,107,58,107,58,107,58,170,66,234,74,232,74,
104,58,39,50,232,41,136,33,8,42,136,58,138,66,39,50,
197,41,100,25,67,25,197,41,71,50,168,66,168,58,103,50,
6,42,38,50,136,66,38,58,229,41,170,58,205,66,142,50,
110,50,203,58,172,58,109,42,205,58,107,50,232,41,40,42,
71,50,39,58,103,66,168,66,171,66,203,66,169,66,169,66,
202,66,174,74,237,66,235,58,15,67,13,83,11,67,52,67,
187,75,155,75,86,59,56,51,191,67,156,67,89,59,21,51,
211,58,213,50,58,59,189,67,222,67,190,67,190,67,222,67,
222,67,190,67,190,67,222,67,222,67,190,67,190,67,222,67,
222,75,190,67,190,67,222,67,222,75,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,254,75,
222,75,222,67,190,67,222,67,222,75,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,67,222,67,222,75,222,75,222,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
190,67,222,67,222,67,222,75,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,222,67,254,67,254,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,255,75,
222,75,222,75,222,75,255,75,222,75,222,75,222,67,222,67,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,255,75,255,75,222,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,222,75,222,75,255,75,255,75,255,75,255,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,223,75,223,75,222,75,222,75,222,75,222,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,255,75,255,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,221,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
168,58,41,83,105,50,172,17,110,50,233,41,10,42,203,58,
7,42,4,17,162,16,96,24,194,48,166,89,68,73,231,114,
130,41,68,42,228,41,225,16,129,24,36,65,71,90,1,49,
226,32,163,49,36,50,100,42,98,17,225,32,131,41,8,75,
68,58,229,58,164,50,6,91,197,90,163,66,4,59,3,59,
163,41,36,58,165,58,2,34,132,58,39,75,37,67,68,67,
101,75,69,67,135,75,165,58,97,33,192,24,130,33,98,17,
162,25,134,58,38,58,132,41,100,49,68,41,104,74,198,57,
5,50,197,65,10,115,74,99,41,99,198,73,231,81,39,82,
40,91,170,91,138,83,202,91,202,83,39,51,38,59,71,91,
9,100,103,83,104,91,200,91,134,75,102,67,6,67,133,66,
133,58,100,58,3,42,227,33,226,33,36,50,100,58,7,83,
167,66,166,66,134,66,200,74,168,66,103,66,197,41,2,17,
226,24,34,33,5,58,167,74,232,82,199,74,200,74,70,50,
38,58,103,58,196,41,229,41,229,49,5,50,5,50,70,58,
168,74,103,66,104,66,72,66,39,58,71,66,38,66,5,58,
37,74,199,82,8,91,134,66,4,42,101,58,232,74,135,66,
135,66,200,74,232,82,8,75,41,83,232,74,167,74,167,74,
136,74,201,82,9,83,41,83,73,91,106,91,41,91,41,83,
200,82,232,82,74,99,42,91,104,66,201,41,170,33,74,17,
197,49,230,57,6,58,134,66,198,66,164,58,197,58,164,50,
131,66,99,58,34,50,100,58,101,58,4,42,229,41,229,33,
163,25,101,50,37,42,201,58,11,67,203,58,72,42,71,34,
41,34,8,42,135,33,4,25,227,24,227,24,132,33,163,33,
197,41,132,33,164,33,197,33,229,41,6,42,230,41,230,41,
197,33,38,50,229,41,196,41,6,50,197,41,165,33,72,58,
104,66,104,66,105,58,170,66,170,58,202,66,10,75,9,75,
40,50,164,33,205,49,45,58,167,58,133,58,229,41,165,33,
132,33,67,25,35,17,132,33,229,41,103,58,103,58,5,42,
197,41,6,50,39,58,6,58,103,66,136,66,105,50,45,75,
170,74,229,66,233,66,41,42,235,41,230,41,198,41,197,57,
38,42,198,41,38,58,167,74,137,66,104,50,70,50,104,58,
235,66,236,74,169,58,140,50,205,58,204,74,240,74,110,75,
88,67,26,59,88,67,122,67,158,67,189,67,153,67,17,51,
243,58,245,58,57,67,221,75,254,75,222,67,222,67,223,67,
222,67,222,67,222,67,222,67,222,67,190,67,190,67,222,67,
222,75,190,67,190,67,222,75,222,75,190,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,67,222,67,222,67,222,75,222,75,222,75,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,67,222,67,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,67,190,67,190,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,254,75,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,67,254,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,222,67,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
255,75,255,75,255,75,255,75,255,75,255,75,255,75,255,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,67,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
223,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,223,75,223,75,223,75,222,75,222,75,223,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
255,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
37,50,233,66,137,50,140,42,74,42,170,50,175,58,241,66,
105,50,4,17,228,24,33,16,226,56,228,81,97,57,162,49,
96,17,98,33,100,49,4,41,36,49,6,82,100,65,3,65,
99,49,33,33,164,41,132,41,2,25,98,33,68,50,5,67,
39,83,70,83,101,83,228,74,99,66,2,66,229,98,196,82,
66,57,66,49,198,74,69,67,132,67,99,75,229,83,100,51,
36,67,228,58,5,59,6,67,133,58,33,25,161,16,96,8,
161,24,35,41,168,82,165,41,133,25,40,50,137,66,202,82,
137,66,108,99,169,74,10,91,110,132,171,115,37,82,228,89,
166,82,230,74,136,75,201,83,103,75,39,75,100,50,165,50,
166,58,71,67,103,75,233,91,9,108,136,91,135,83,103,75,
197,58,166,66,36,58,195,49,194,41,194,41,35,50,133,58,
229,66,133,58,199,66,168,66,102,58,200,74,232,82,5,50,
66,33,99,33,132,33,38,50,71,58,229,49,229,49,38,66,
5,50,5,50,71,58,229,49,229,49,229,49,131,33,5,50,
201,74,135,66,70,66,37,58,102,66,135,66,102,66,134,66,
70,66,70,66,37,58,37,50,70,66,38,58,168,74,167,66,
135,66,167,74,9,83,106,99,232,74,167,74,9,83,167,66,
135,66,200,74,8,83,138,91,73,83,106,91,106,99,40,83,
231,82,40,83,41,91,9,83,169,74,74,58,78,58,206,33,
169,49,100,58,38,58,199,49,5,50,70,58,35,42,195,33,
5,50,101,66,131,66,131,66,99,58,194,41,66,25,68,25,
3,42,39,50,41,42,231,25,103,50,104,58,8,50,7,50,
105,58,169,33,202,41,232,41,165,33,67,17,38,50,101,58,
69,25,32,25,99,41,69,33,100,33,164,33,68,25,230,41,
71,58,6,50,6,50,132,33,164,33,164,33,71,50,168,58,
202,74,6,50,38,50,169,74,43,83,235,74,234,66,140,83,
11,67,9,42,74,50,202,66,230,41,133,33,132,33,36,50,
230,41,198,41,133,33,69,25,101,33,7,50,105,66,136,66,
6,42,229,41,132,33,229,41,201,74,233,74,167,66,9,75,
233,74,200,66,167,58,135,58,104,58,72,58,7,50,230,41,
198,41,71,50,168,66,200,66,200,66,71,50,39,50,72,58,
203,66,205,58,205,66,170,58,177,58,25,67,17,59,108,75,
113,67,83,75,53,67,90,59,31,68,157,51,121,59,54,67,
212,58,215,58,55,67,222,67,253,67,223,75,191,75,254,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,190,67,190,67,190,67,190,67,190,67,190,67,
222,67,190,67,222,67,222,67,222,67,223,75,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,75,222,75,
222,75,222,75,222,75,222,67,222,67,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,190,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,254,75,
255,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,223,75,223,75,223,75,223,75,223,75,
255,75,255,75,255,75,255,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
223,75,223,75,222,75,222,75,222,75,222,75,222,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,254,75,254,75,254,75,
223,75,223,75,223,75,223,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,255,75,255,75,
222,75,254,75,254,75,255,75,255,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,254,75,
253,75,254,75,254,75,254,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,221,75,
37,42,8,34,177,58,243,58,77,42,77,50,170,50,133,34,
134,25,4,17,102,33,197,32,131,32,98,57,35,66,194,49,
99,17,33,25,66,33,98,49,196,57,39,74,100,57,34,57,
233,98,196,49,33,25,2,25,35,25,99,33,162,25,192,25,
129,33,164,58,98,50,228,66,103,91,133,74,136,107,136,107,
3,42,129,33,193,41,33,26,67,51,99,59,36,67,228,50,
5,59,37,59,198,83,68,67,36,67,230,66,195,33,226,16,
161,24,226,24,38,58,230,49,198,41,231,49,137,66,201,74,
173,99,47,116,206,107,140,99,172,99,171,107,74,107,6,74,
166,82,133,66,71,75,71,67,136,83,165,58,198,58,67,42,
3,42,100,50,229,58,168,83,201,99,135,91,168,91,200,83,
6,67,133,58,166,66,134,66,3,50,226,41,3,50,101,58,
132,58,230,66,8,75,8,75,73,83,40,83,8,83,9,83,
38,58,70,58,5,50,5,50,38,58,70,58,71,66,38,58,
197,41,229,41,38,58,229,49,196,41,5,50,6,50,38,58,
168,74,168,74,103,66,37,58,37,58,37,58,5,50,5,50,
5,58,69,58,102,58,37,58,37,58,38,66,233,82,9,83,
42,91,74,91,73,91,106,91,73,91,41,83,74,91,41,83,
74,91,74,91,73,91,138,99,73,83,106,91,138,99,73,91,
40,91,138,99,106,99,8,83,42,91,235,74,206,66,78,50,
136,33,228,41,70,58,71,58,5,50,99,25,131,33,2,17,
34,25,228,49,67,58,99,58,164,66,198,74,4,50,34,17,
163,41,133,33,40,50,104,50,39,50,41,58,74,58,8,50,
42,50,201,33,135,25,199,33,197,33,229,41,38,50,37,50,
68,25,3,17,229,49,37,58,100,33,36,17,133,25,103,58,
103,58,38,50,197,41,132,33,6,50,6,50,71,58,71,50,
197,41,103,58,168,66,168,66,201,74,202,74,234,74,74,75,
75,83,137,58,40,50,6,42,100,25,101,33,101,33,198,41,
229,41,165,33,197,33,230,41,6,50,71,58,168,66,201,74,
103,50,6,42,164,33,197,41,70,58,135,66,168,66,232,74,
10,75,200,66,134,58,70,50,71,50,73,58,40,50,166,33,
198,41,136,66,233,74,202,74,105,58,6,42,229,41,40,50,
139,66,174,66,143,58,135,50,208,58,91,75,47,59,237,66,
45,67,48,75,210,58,86,59,255,75,189,59,214,42,244,66,
52,67,245,66,24,59,189,67,253,67,255,75,191,67,221,59,
222,67,222,67,190,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,190,67,190,67,190,67,222,67,222,67,222,67,
223,75,222,67,190,67,190,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
255,75,255,75,255,75,255,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,223,75,223,75,254,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,223,75,223,75,223,75,223,75,223,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,221,75,
14,67,140,42,51,67,80,67,44,59,75,42,41,34,106,42,
13,17,207,41,78,50,6,17,68,25,70,66,36,50,3,42,
134,25,67,25,129,33,226,49,68,58,228,57,193,24,161,32,
164,57,66,33,225,16,67,25,132,41,229,49,36,50,1,34,
64,33,100,58,196,58,103,75,7,67,36,50,104,91,71,83,
229,50,197,58,131,50,4,51,100,59,133,67,196,58,5,67,
166,67,8,84,102,75,200,83,71,75,137,83,77,108,134,50,
3,25,226,24,99,41,165,49,72,66,137,66,168,74,232,74,
140,91,46,108,78,116,237,99,41,75,107,91,46,124,75,99,
170,115,133,66,39,83,6,67,71,75,39,75,198,58,100,50,
2,42,2,42,35,42,165,58,197,66,197,66,70,75,135,75,
103,67,230,58,7,67,198,66,165,66,165,66,35,50,3,42,
3,34,100,50,101,50,166,58,39,83,7,75,199,66,232,74,
200,82,135,66,37,58,5,50,228,41,164,33,196,41,196,41,
67,25,99,33,229,41,229,41,99,33,196,41,103,66,70,58,
5,58,168,74,135,66,38,58,38,58,103,66,103,66,38,58,
196,49,38,58,135,66,5,50,196,49,102,66,9,83,9,83,
200,74,233,82,135,66,167,74,9,83,41,83,41,83,41,83,
41,91,9,83,9,83,74,91,41,83,41,83,8,83,167,74,
8,83,106,99,73,91,232,82,41,91,169,66,233,41,105,17,
134,25,101,25,4,42,3,42,69,58,195,33,196,41,3,17,
2,17,99,33,163,41,227,49,132,58,197,74,68,58,129,33,
194,16,194,16,132,33,38,50,72,66,43,66,76,58,10,42,
234,33,199,33,36,17,100,33,132,33,37,50,228,41,131,25,
98,25,68,33,6,58,36,58,68,25,36,17,164,33,5,50,
6,50,71,50,164,33,164,33,6,50,38,50,103,58,38,50,
70,50,200,74,135,66,135,66,201,74,201,66,9,75,73,75,
8,75,201,66,39,50,131,25,100,25,168,41,168,41,233,49,
135,66,71,58,103,58,135,58,103,58,136,66,233,74,9,83,
233,74,39,50,165,33,197,41,6,50,38,58,103,66,200,74,
10,75,103,58,102,58,168,58,72,50,8,42,232,41,167,33,
102,33,38,50,104,58,139,66,172,66,104,58,38,50,8,50,
8,50,111,58,146,58,138,50,178,58,88,75,11,59,234,66,
202,66,13,75,239,66,54,67,157,67,222,75,213,50,209,58,
51,67,243,66,249,58,189,67,222,67,254,75,222,75,221,59,
222,67,190,67,190,67,190,67,222,67,222,67,222,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
255,75,222,67,222,67,190,67,190,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,67,254,75,
222,75,222,75,222,75,222,75,222,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,223,75,254,75,254,75,254,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
117,75,181,50,248,58,21,59,212,91,106,42,134,9,206,25,
219,33,188,58,122,67,79,26,74,34,11,67,135,50,68,42,
229,33,164,33,98,25,226,41,196,66,132,58,192,16,97,16,
129,16,129,16,160,8,193,16,67,25,37,58,230,74,162,50,
194,41,132,58,229,58,197,50,165,50,3,34,67,50,132,58,
132,58,164,66,37,75,134,75,4,67,196,74,132,58,229,58,
4,51,70,67,136,75,105,83,138,83,143,116,240,124,82,133,
10,75,164,41,132,57,229,65,103,66,168,66,232,74,40,83,
232,74,105,83,138,91,106,83,8,67,232,66,172,99,208,132,
170,115,133,74,133,66,7,75,7,67,7,67,7,67,100,50,
67,58,2,42,226,33,35,42,133,66,230,74,135,83,231,83,
168,67,6,59,40,67,40,75,71,75,71,83,230,74,165,66,
198,66,100,50,100,50,132,58,164,58,39,75,104,83,232,74,
42,91,200,82,167,74,200,74,70,58,228,41,37,50,135,66,
229,49,229,41,70,58,70,58,229,49,6,50,70,58,5,50,
229,49,103,66,38,58,229,49,6,50,6,58,39,58,229,49,
229,57,71,66,168,74,229,41,99,33,38,58,70,58,195,33,
229,49,5,58,228,49,69,58,199,74,199,74,167,74,200,74,
9,91,232,82,232,74,41,83,9,83,8,83,199,74,134,66,
73,91,41,91,199,74,134,66,200,74,71,50,200,33,137,25,
169,25,172,33,229,33,162,33,6,50,228,41,100,25,4,17,
3,17,194,16,1,17,1,17,65,25,226,41,35,50,67,50,
35,33,226,16,1,17,99,33,39,66,172,74,141,58,12,34,
12,42,199,33,66,25,164,41,39,58,168,74,70,50,164,25,
129,25,164,41,196,41,164,41,164,33,196,33,37,42,40,50,
71,50,71,50,229,41,197,41,6,50,71,58,104,66,39,58,
135,58,103,58,38,50,103,58,201,74,201,74,233,66,9,75,
166,66,168,66,70,50,131,33,100,25,200,41,201,41,10,50,
71,58,103,58,169,66,200,66,135,66,168,66,200,74,167,66,
234,74,6,42,132,33,6,50,136,66,71,58,71,58,233,74,
169,66,70,58,167,66,42,83,137,58,9,34,9,42,41,42,
166,41,38,58,71,58,138,66,171,74,72,58,229,41,231,41,
197,49,45,50,176,66,207,66,178,58,241,58,169,50,201,74,
171,66,170,66,17,75,57,75,22,51,90,59,22,59,207,50,
241,58,241,66,27,67,222,75,223,67,254,75,222,75,254,67,
222,67,222,67,190,67,190,67,222,67,222,67,222,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
255,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,254,75,254,75,222,75,222,67,254,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,255,75,254,75,254,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
247,58,220,58,57,67,145,42,144,50,198,17,40,34,180,58,
29,51,126,59,91,43,24,43,53,51,112,42,11,34,200,25,
68,34,36,34,162,25,96,17,160,17,194,33,2,17,163,16,
98,16,162,16,226,16,225,16,193,16,227,49,70,83,68,75,
34,42,66,50,163,58,67,42,100,42,3,42,161,25,99,50,
68,74,35,74,71,99,38,83,165,74,68,66,165,66,5,59,
38,67,103,75,168,83,9,108,137,91,78,116,149,157,247,165,
147,149,201,82,165,73,103,90,168,74,232,66,137,91,72,91,
6,83,230,74,72,83,105,83,105,83,199,66,199,66,77,116,
12,124,199,82,232,82,40,83,40,75,198,58,39,75,6,67,
131,66,99,58,2,42,3,42,165,66,6,75,229,66,37,67,
135,67,132,42,68,42,231,66,7,75,38,75,6,75,197,66,
40,75,133,58,165,58,197,58,131,50,229,66,71,83,199,66,
135,66,232,82,106,91,138,99,41,83,200,74,232,74,167,66,
9,83,167,66,70,58,196,41,197,41,71,58,38,58,6,50,
229,49,5,50,229,49,71,58,103,66,6,50,165,41,100,33,
132,41,39,58,168,74,5,50,67,33,229,49,102,66,134,58,
168,74,167,74,134,66,167,66,167,74,134,66,135,66,232,74,
168,74,200,74,41,91,106,91,106,91,9,83,8,83,9,83,
41,91,232,82,232,82,9,91,74,91,137,66,233,41,203,33,
206,33,18,50,10,50,132,33,134,33,5,50,67,25,102,25,
36,25,35,25,67,25,1,17,1,17,227,41,132,58,196,66,
38,58,132,33,2,17,34,17,196,41,202,66,14,67,78,42,
235,33,70,17,132,25,165,41,7,58,38,50,37,42,132,25,
132,25,163,33,66,25,68,25,133,33,136,33,201,41,72,50,
135,58,70,50,229,41,229,41,5,50,103,66,168,74,136,66,
71,50,6,42,39,50,39,58,71,58,103,58,136,58,103,58,
167,66,233,74,169,74,228,41,99,25,134,33,168,33,200,41,
166,33,230,41,104,58,169,66,136,66,168,66,168,74,136,66,
201,66,38,50,197,41,136,66,234,82,136,66,71,58,169,74,
136,58,70,58,167,66,233,74,138,58,42,42,74,50,74,50,
104,66,39,58,7,50,104,58,169,66,39,50,230,41,7,50,
232,57,41,42,172,50,207,66,174,58,205,58,172,58,140,74,
11,75,234,66,52,75,152,75,86,59,244,42,23,59,18,59,
241,66,17,67,91,75,255,75,223,67,190,67,190,67,223,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,254,75,255,75,255,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,254,75,254,75,254,75,254,75,254,75,222,67,
222,75,222,75,222,75,222,75,222,75,255,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
255,75,255,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,254,75,254,75,222,75,222,67,254,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
255,75,255,75,223,75,222,75,222,75,222,75,223,75,223,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,254,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,255,75,255,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
184,75,158,83,18,51,71,26,106,42,104,42,203,58,176,50,
154,59,125,51,59,35,87,43,183,67,148,42,14,34,74,34,
3,26,67,42,164,50,35,34,65,9,34,9,225,16,160,16,
195,24,129,8,160,8,225,16,66,25,101,58,102,83,36,75,
164,66,67,58,67,66,68,66,101,58,68,50,67,50,5,75,
227,65,4,90,133,106,198,90,68,58,230,74,229,66,38,75,
101,75,69,67,4,67,228,66,230,74,73,91,78,124,181,165,
118,174,208,148,136,90,136,90,41,83,73,75,202,99,72,91,
6,83,164,66,230,74,71,83,72,91,40,83,198,66,7,75,
11,116,8,83,73,91,9,83,134,50,101,42,35,42,230,66,
197,74,229,74,164,58,67,50,230,74,6,83,164,58,196,50,
103,67,230,58,3,34,4,34,230,66,38,75,38,83,103,91,
36,42,194,33,195,33,68,42,132,50,131,50,165,58,7,67,
101,50,232,74,41,83,73,91,41,83,9,83,232,74,102,58,
135,66,167,66,38,58,99,33,196,41,71,58,229,49,6,50,
38,58,38,58,6,58,38,58,71,58,38,58,197,49,35,25,
229,57,6,50,70,58,38,58,196,41,229,49,103,66,233,74,
42,91,42,91,41,91,41,91,232,74,167,66,167,74,232,82,
168,74,167,74,232,74,200,74,167,74,102,66,167,74,74,91,
41,91,232,82,233,90,42,91,75,99,170,74,42,50,44,42,
77,42,47,50,200,41,67,25,100,33,7,83,131,58,99,25,
100,25,68,25,132,33,67,25,66,25,163,33,195,41,227,41,
101,58,101,58,132,25,35,17,99,25,70,50,138,50,109,42,
234,33,103,17,199,33,199,41,232,49,198,33,230,41,132,25,
102,25,36,25,3,25,67,25,135,33,239,49,80,58,104,58,
197,41,164,33,229,41,229,41,229,41,71,58,168,74,9,83,
104,58,39,50,105,58,104,58,38,50,103,58,103,58,71,50,
167,66,234,82,234,74,5,50,132,33,134,33,167,33,133,33,
167,33,166,41,40,50,137,66,169,66,136,66,168,66,168,66,
168,66,103,58,103,66,201,74,233,82,168,74,136,66,136,66,
201,58,102,58,102,66,170,74,172,58,75,42,9,42,40,50,
234,74,72,58,231,49,72,50,72,50,7,42,231,41,72,58,
45,66,105,50,174,50,175,66,75,50,172,58,203,66,138,66,
200,58,13,75,49,67,50,67,149,75,242,50,244,58,22,67,
49,75,15,67,55,75,254,75,223,67,190,75,190,75,223,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,190,67,190,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,223,75,223,75,222,67,
222,67,222,67,254,75,255,75,255,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,67,222,67,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,254,75,254,75,222,75,254,75,254,75,
254,75,222,75,222,75,222,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
255,75,255,75,255,75,223,75,223,75,223,75,223,75,223,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,255,75,255,75,255,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
180,75,151,75,145,42,76,34,175,58,13,75,140,75,14,84,
123,100,218,75,217,67,115,51,240,42,174,50,170,42,132,34,
227,25,193,17,1,34,67,34,226,25,163,25,2,17,128,16,
161,16,225,16,33,17,33,17,33,25,195,41,132,58,196,58,
226,57,162,65,130,65,130,57,229,57,69,58,68,42,229,58,
195,49,4,74,36,82,165,82,68,58,137,99,38,75,69,67,
3,59,98,42,163,50,164,58,68,50,165,66,137,99,11,116,
212,173,183,206,143,140,70,66,196,49,228,41,69,58,198,74,
230,82,133,66,133,58,197,66,198,74,7,83,72,83,6,67,
230,66,40,83,232,74,74,91,199,66,68,34,162,25,226,41,
197,66,229,66,229,66,163,58,229,74,229,74,100,50,197,58,
132,50,40,75,166,58,227,33,100,50,229,74,70,83,10,108,
198,66,36,42,195,33,4,34,100,50,99,50,132,50,6,67,
231,58,199,66,134,58,134,66,134,66,134,66,135,66,102,66,
135,66,200,74,38,58,164,33,229,49,6,50,229,49,71,58,
103,66,71,58,38,58,229,49,5,50,168,74,200,74,70,66,
71,66,229,49,131,33,6,50,71,58,38,58,197,41,164,33,
229,49,167,74,41,91,73,91,41,91,8,83,200,74,200,74,
201,82,167,74,200,74,167,66,167,66,37,58,5,50,102,66,
167,74,200,82,233,82,200,82,106,99,74,83,170,66,139,58,
40,34,165,25,2,17,33,25,228,49,168,99,133,91,163,25,
165,33,99,25,164,33,164,33,131,33,66,25,66,25,196,41,
101,66,198,74,4,42,132,25,67,25,98,25,132,25,9,42,
9,42,202,33,203,33,169,33,233,33,41,42,7,42,197,33,
166,33,5,17,35,25,98,33,134,33,238,41,13,50,164,33,
67,25,164,33,6,50,38,50,103,58,38,50,168,66,74,83,
103,58,6,42,71,58,169,74,200,74,200,74,168,66,135,58,
69,50,71,58,71,58,196,33,196,33,165,33,165,33,99,33,
167,33,199,41,7,50,104,58,168,66,103,58,70,58,71,58,
136,66,135,66,103,66,135,66,168,74,201,74,233,74,233,74,
74,75,200,66,103,66,170,66,205,66,75,42,8,42,103,58,
71,58,6,42,9,50,76,58,235,41,200,33,7,42,136,58,
78,66,174,58,17,67,238,66,43,50,109,58,139,58,137,58,
103,50,238,74,12,67,205,50,79,67,16,67,238,58,243,66,
48,75,205,58,17,59,188,67,223,67,223,75,223,75,254,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,223,75,223,75,222,67,
222,67,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,255,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,254,75,254,75,254,75,254,75,
222,67,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
223,75,223,75,223,75,223,75,223,75,223,75,223,75,223,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,222,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
255,75,255,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,30,76,
30,76,254,75,254,75,254,75,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
205,50,105,26,168,9,105,42,136,50,105,50,237,66,246,99,
116,133,80,125,173,67,178,50,21,67,13,59,40,59,168,42,
101,34,195,25,129,9,66,34,164,50,67,42,1,25,162,24,
224,24,162,33,36,50,195,41,228,49,70,58,36,50,67,42,
163,65,66,65,71,106,6,90,3,41,229,49,101,42,67,34,
163,33,227,41,39,83,100,58,100,58,166,82,102,83,67,51,
4,34,133,42,229,58,229,58,196,50,230,66,171,107,200,82,
234,90,147,165,118,182,45,116,168,82,168,90,102,66,39,75,
231,74,40,83,7,75,104,83,72,91,40,83,169,91,104,75,
198,58,231,74,171,99,41,75,203,91,199,58,227,33,194,33,
35,42,99,42,228,58,196,58,228,74,229,74,164,58,6,67,
99,58,198,66,41,83,134,58,3,42,164,66,5,75,103,91,
6,67,101,50,69,50,102,50,68,42,99,42,164,50,164,50,
166,50,198,58,166,58,199,74,8,83,200,74,167,66,134,66,
167,74,135,66,164,41,196,41,103,66,6,50,197,41,6,50,
38,58,197,41,38,58,103,66,70,58,167,74,135,74,102,66,
135,74,135,66,229,41,6,50,229,49,100,41,35,25,35,17,
164,41,135,74,200,74,167,74,199,74,232,82,200,74,232,82,
233,82,135,66,135,66,167,74,9,83,167,66,69,58,70,66,
102,66,9,91,42,91,200,82,138,99,106,91,135,58,7,42,
71,42,130,25,35,25,6,58,137,74,231,74,69,75,198,33,
196,33,164,25,229,41,229,41,164,33,100,33,197,41,234,74,
199,82,197,74,100,50,6,42,36,25,34,25,163,33,38,50,
166,25,44,50,46,50,203,33,39,9,168,25,166,33,230,41,
4,42,4,17,68,33,228,41,197,33,199,33,197,33,132,25,
197,41,103,66,136,66,168,66,42,83,70,50,135,58,233,74,
134,58,38,50,197,41,38,50,167,66,167,66,200,74,167,58,
69,50,229,41,132,33,131,25,230,41,166,41,165,41,196,41,
199,41,231,49,230,41,5,42,70,58,102,58,70,58,102,58,
200,82,168,74,38,58,5,50,168,74,200,74,200,66,74,83,
9,59,232,66,103,66,41,50,75,50,43,34,40,42,167,74,
229,41,164,33,233,41,47,50,239,49,233,33,6,42,6,42,
10,50,112,50,13,59,43,75,172,66,144,66,114,58,143,58,
141,66,204,66,236,66,74,67,235,58,75,75,236,66,45,75,
47,75,171,58,12,51,187,67,221,67,222,75,190,75,221,67,
190,67,222,67,222,67,222,67,190,67,190,67,222,67,222,67,
223,75,222,67,222,67,222,67,222,67,222,67,223,75,255,75,
222,67,222,67,222,67,223,75,255,75,223,75,222,67,222,67,
222,67,222,67,223,75,222,67,222,67,223,75,223,75,222,67,
254,75,254,75,222,67,222,67,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,67,222,67,222,67,254,75,255,75,255,75,
222,75,222,75,255,75,255,75,222,75,222,75,222,75,255,75,
255,75,255,75,255,75,255,75,222,75,222,75,222,75,222,75,
222,67,222,67,222,67,222,67,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,254,75,254,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,223,75,223,75,223,75,223,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
31,76,255,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,254,75,255,75,31,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,254,75,254,75,30,76,30,76,30,76,30,76,
30,76,254,75,254,75,254,75,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
229,33,68,9,102,9,7,34,230,41,135,25,80,42,216,58,
147,75,241,100,246,67,123,67,113,67,234,58,139,50,135,50,
196,50,228,50,65,34,1,34,99,50,67,50,194,41,129,33,
67,50,196,58,195,50,196,50,164,58,165,66,162,41,163,41,
99,65,2,57,169,114,169,122,2,49,98,41,102,58,228,33,
226,33,165,50,134,66,102,74,133,58,133,66,132,66,102,75,
102,75,196,58,34,34,197,58,8,75,134,58,134,58,41,83,
73,91,8,83,142,140,113,165,137,91,231,66,104,83,198,66,
6,75,104,83,201,83,169,83,10,92,136,83,71,83,136,99,
71,75,135,83,70,75,71,75,73,75,170,83,133,42,68,34,
36,42,36,34,132,42,164,50,197,50,5,67,196,58,132,58,
165,58,3,34,166,50,7,67,101,50,227,33,100,50,230,74,
6,75,197,58,165,50,231,58,134,42,101,50,198,66,68,58,
132,50,198,58,166,58,199,66,134,58,136,66,201,82,72,66,
167,66,135,66,103,58,136,66,103,58,132,33,99,33,5,50,
100,41,165,41,71,58,103,58,6,50,197,41,6,58,71,66,
168,74,168,74,5,50,197,41,197,41,99,33,99,33,99,33,
197,41,71,58,200,82,41,91,8,83,8,83,73,91,41,83,
8,83,199,74,102,66,167,74,200,74,232,82,135,66,70,58,
72,66,137,74,201,74,168,74,233,82,233,74,100,25,67,17,
166,33,230,41,131,25,199,66,167,66,167,66,101,58,231,66,
43,42,103,25,165,33,228,33,68,50,228,65,70,66,232,66,
170,107,69,75,164,50,4,42,99,33,35,25,8,50,201,58,
5,50,7,42,200,33,5,17,3,17,67,33,67,25,36,9,
4,25,226,16,133,33,7,50,133,33,101,33,101,33,101,25,
229,41,70,58,38,50,137,66,169,66,6,50,103,58,201,74,
71,58,229,41,229,41,70,50,135,58,168,66,167,66,102,50,
135,66,135,58,230,41,132,33,68,25,68,25,197,41,39,50,
72,58,136,66,39,50,70,58,168,74,103,66,229,49,6,50,
234,82,71,58,164,41,71,58,168,66,168,66,233,74,135,66,
71,58,136,58,104,50,75,50,45,42,236,33,43,42,232,33,
4,33,38,58,137,33,82,58,242,74,73,42,41,50,236,49,
13,42,232,33,138,58,240,74,175,66,177,58,88,75,50,59,
12,67,203,66,234,74,170,66,234,66,235,66,108,58,74,83,
202,66,236,66,172,58,82,75,220,83,31,76,255,67,223,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,223,75,223,75,223,75,223,75,222,75,222,75,
222,75,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,222,67,254,75,254,75,254,75,
222,75,222,75,222,75,255,75,255,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,255,75,255,75,
222,75,222,75,223,75,222,75,222,75,222,75,222,75,223,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,222,75,222,75,222,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
166,58,166,33,169,33,233,41,132,25,164,33,170,58,43,42,
233,33,8,26,176,42,209,50,170,42,233,58,71,42,99,42,
228,42,164,34,5,51,102,59,38,67,197,58,6,67,197,66,
229,66,229,58,135,83,135,83,71,91,198,82,195,49,163,41,
98,57,1,49,67,65,229,81,164,57,131,41,228,49,98,33,
162,33,198,58,101,58,133,66,168,91,103,91,99,74,228,82,
99,74,67,66,133,74,166,74,70,58,5,50,135,66,41,83,
134,58,167,74,170,107,238,148,79,149,136,91,230,66,35,42,
198,66,71,75,201,83,201,83,201,83,104,75,71,75,71,83,
38,67,103,75,135,83,103,75,230,58,8,67,133,50,165,50,
101,50,101,50,100,42,132,42,197,50,6,67,229,66,99,50,
39,67,227,25,162,17,4,34,101,50,227,33,227,41,165,66,
196,66,197,58,165,50,166,50,101,42,101,50,133,58,68,58,
132,50,7,67,137,91,101,50,134,58,232,74,103,66,135,66,
102,58,70,58,103,58,136,66,5,50,131,33,228,49,228,49,
197,49,229,49,6,50,197,41,229,49,229,49,6,58,6,58,
5,50,70,58,38,50,70,58,5,50,67,25,67,25,99,33,
100,33,103,66,74,91,138,99,8,83,8,83,105,91,73,91,
8,83,199,74,134,66,135,66,200,74,9,91,200,74,103,66,
104,66,136,74,233,82,233,82,74,91,42,83,133,33,36,17,
101,33,38,50,5,50,73,83,41,83,167,66,198,66,103,83,
114,58,41,42,196,41,230,41,233,74,41,83,106,99,42,116,
70,83,198,66,37,42,164,33,37,25,70,25,73,50,9,67,
134,58,167,58,196,33,226,8,4,17,5,25,101,25,132,25,
2,25,2,25,34,25,131,25,165,33,67,25,133,33,198,41,
164,33,229,41,197,41,71,58,6,50,164,33,71,58,168,66,
71,50,70,50,71,58,103,58,135,66,103,58,70,58,102,58,
200,66,201,74,6,42,100,25,68,25,68,25,198,41,104,58,
136,66,71,58,103,58,168,66,169,74,39,58,165,41,7,58,
136,66,136,66,6,50,38,50,103,58,168,66,200,66,70,50,
104,58,169,66,137,58,140,58,77,50,13,42,76,50,168,33,
101,41,6,50,166,33,108,58,43,75,135,50,104,50,8,50,
12,42,10,42,169,58,45,83,46,75,205,58,17,67,48,59,
172,58,137,58,169,66,172,66,173,66,236,66,171,66,11,75,
202,66,204,66,106,50,173,58,55,67,222,67,255,67,190,75,
222,67,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,223,75,223,75,222,75,222,75,222,75,
222,75,222,67,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,254,75,254,75,222,67,222,67,222,67,
222,67,222,67,222,67,222,67,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,255,75,255,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,223,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,222,75,222,75,222,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
41,75,38,50,230,41,166,33,167,25,40,42,103,42,97,9,
101,33,42,50,205,58,170,50,103,42,133,58,132,58,196,66,
165,42,100,34,165,42,70,59,200,83,135,75,200,91,233,99,
70,67,229,58,103,83,136,107,68,74,166,90,227,57,166,74,
166,90,66,49,1,49,131,57,228,57,164,49,225,24,160,24,
100,41,168,66,102,58,4,50,165,58,230,74,68,74,35,66,
67,74,227,57,196,57,6,66,169,82,169,82,135,74,106,99,
166,58,166,66,40,83,137,99,140,124,75,116,164,58,165,66,
198,74,230,66,71,75,168,75,168,75,136,75,71,67,7,67,
6,67,70,75,135,83,201,83,231,66,199,58,166,50,133,50,
101,50,133,58,68,42,100,42,100,50,165,50,198,58,132,50,
7,59,68,34,130,17,130,17,4,42,163,33,130,33,101,58,
37,83,38,75,100,50,35,34,35,34,133,50,101,58,166,66,
165,58,39,75,138,91,166,58,199,66,231,74,232,74,134,66,
37,58,70,66,135,74,136,74,6,50,229,49,167,66,134,66,
38,58,38,58,38,58,229,41,71,58,70,58,5,50,229,49,
229,49,229,49,196,41,5,42,229,41,196,41,229,49,6,58,
71,66,42,91,204,107,204,107,106,99,106,99,106,99,8,83,
167,74,167,74,134,66,70,58,167,74,9,83,9,83,135,66,
135,66,168,74,41,91,106,99,172,107,43,91,166,33,134,33,
132,33,38,50,37,50,8,75,106,91,73,83,137,91,233,99,
136,42,10,42,77,58,234,82,200,91,8,92,169,91,40,91,
197,50,6,42,99,25,131,25,167,33,168,25,198,33,8,42,
199,58,167,58,196,33,34,17,135,33,13,50,234,49,165,33,
1,17,196,41,164,33,164,33,229,41,99,25,165,33,100,33,
132,33,230,41,230,41,230,41,6,50,38,50,168,66,167,66,
168,58,201,66,136,66,70,58,103,58,38,58,229,49,229,49,
135,58,135,58,132,33,226,8,35,25,100,25,132,33,198,41,
39,50,39,50,104,58,6,50,39,58,7,50,166,41,232,49,
136,66,136,66,135,58,168,66,233,74,201,66,135,58,103,50,
37,50,135,58,201,66,203,66,107,50,76,50,107,50,199,33,
100,33,197,41,165,33,135,58,232,74,73,58,76,58,200,33,
138,25,46,50,137,58,168,58,11,75,233,66,234,58,171,50,
205,66,203,66,171,66,172,66,142,58,206,66,11,67,170,66,
201,66,13,75,203,66,203,66,18,67,189,75,255,75,254,75,
222,67,222,67,222,67,222,67,254,75,222,67,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,67,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,222,67,254,75,254,75,222,67,222,67,222,67,
222,67,222,67,222,67,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
222,75,222,75,254,75,254,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,254,75,254,75,
222,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
170,75,39,67,197,58,37,34,12,59,18,84,172,42,134,9,
67,25,234,41,45,75,197,50,193,25,37,50,101,58,99,58,
164,41,37,58,166,74,137,99,9,100,9,100,233,107,75,124,
196,42,164,50,197,74,68,74,4,82,203,131,232,98,68,58,
199,74,65,33,33,41,131,49,99,49,34,33,226,32,2,33,
195,32,67,33,99,41,131,49,4,50,8,83,232,90,135,74,
67,50,133,58,196,41,100,41,105,74,11,99,201,90,42,107,
8,67,7,75,166,66,197,74,6,75,74,108,233,99,229,74,
234,115,104,91,38,75,135,83,135,75,136,75,7,59,230,58,
39,67,71,75,168,83,42,100,137,83,40,75,8,67,198,58,
164,58,133,58,133,50,133,58,133,50,101,50,133,50,100,50,
230,58,68,34,130,17,1,9,131,33,163,33,195,41,227,41,
196,66,70,83,229,66,99,42,226,33,36,42,36,50,166,66,
231,74,101,58,72,83,7,75,165,58,230,66,72,83,6,75,
5,58,70,66,229,57,164,41,164,41,197,41,135,66,200,74,
233,82,233,82,136,66,196,41,229,49,229,49,228,41,196,41,
37,58,70,58,37,50,37,50,229,41,229,41,5,50,5,50,
5,50,103,66,233,82,41,91,74,91,106,99,41,83,134,66,
199,74,167,74,167,74,37,58,102,66,167,74,232,82,135,74,
135,66,135,66,135,74,232,82,107,99,234,82,100,25,101,25,
67,25,196,41,228,41,37,50,74,91,171,99,234,99,200,91,
74,75,241,74,17,75,74,91,139,91,169,83,7,67,39,50,
78,42,233,41,101,33,232,41,109,50,9,34,197,25,72,50,
4,34,100,25,100,33,67,25,136,33,111,58,171,41,68,33,
36,25,198,41,165,33,165,33,68,25,35,17,165,33,67,25,
100,25,6,50,197,41,229,41,136,66,200,74,168,66,135,58,
168,66,10,75,168,66,70,58,38,58,229,49,164,41,164,49,
5,50,6,50,100,25,226,8,35,25,100,33,100,33,100,33,
197,41,72,58,104,58,7,50,40,58,105,58,8,50,232,49,
103,58,6,50,71,50,168,66,233,74,168,58,38,42,70,50,
69,50,135,58,168,66,202,66,138,58,107,58,139,58,8,34,
200,41,40,50,71,58,167,74,168,74,44,58,80,58,236,41,
170,33,113,58,75,58,7,42,170,66,8,75,233,66,171,58,
137,58,204,74,238,82,203,66,142,58,209,66,44,75,233,66,
168,58,236,74,235,74,200,74,239,74,155,75,255,75,254,67,
222,67,222,67,222,67,254,75,254,75,254,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,67,222,67,222,67,222,67,222,67,
222,67,222,67,254,75,254,75,254,75,254,75,222,67,222,67,
222,67,222,67,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,254,75,254,75,254,75,222,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,222,75,222,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,84,
254,75,30,84,254,75,254,75,254,75,254,75,254,75,30,84,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,254,75,254,75,
10,84,104,75,8,67,138,75,109,92,14,84,172,42,13,34,
165,33,102,42,231,50,133,34,2,34,34,50,35,50,130,33,
226,40,2,49,5,74,138,115,230,74,70,83,38,83,38,83,
196,42,196,50,7,83,4,74,200,106,106,123,105,107,36,58,
133,42,227,41,192,24,99,49,132,57,67,41,197,49,100,41,
163,41,130,25,65,41,4,74,199,90,41,107,107,115,78,132,
2,42,227,41,164,41,166,49,166,57,72,74,201,90,135,82,
40,75,134,58,198,74,165,66,164,58,103,83,106,116,103,91,
170,115,137,107,39,83,136,83,136,83,168,83,6,67,198,58,
198,58,38,67,103,75,233,91,137,83,73,75,73,75,105,75,
104,83,6,75,198,66,133,58,101,50,166,58,165,58,133,50,
7,59,36,34,98,17,225,8,225,16,164,41,102,58,4,50,
33,50,228,66,38,75,197,58,100,50,197,58,198,66,72,83,
137,91,198,66,100,58,7,75,165,58,230,66,104,83,230,66,
70,66,103,74,229,49,164,41,229,49,5,50,102,58,167,66,
135,66,168,74,200,74,37,58,38,58,135,66,167,74,102,66,
9,83,9,83,232,74,200,74,135,66,70,50,37,50,5,50,
5,50,37,58,135,66,233,82,41,91,9,83,167,74,69,58,
102,66,135,66,232,82,200,74,9,83,9,83,41,91,200,82,
169,74,169,74,168,74,168,74,200,74,168,74,132,33,35,17,
132,33,229,41,4,42,163,33,200,74,106,91,137,91,169,91,
141,132,59,116,26,75,235,74,72,91,37,75,139,50,148,58,
179,50,10,34,69,25,172,49,81,50,46,34,104,17,134,33,
4,26,36,17,133,41,229,41,133,25,137,25,6,17,100,33,
201,41,168,41,71,25,200,33,5,17,36,17,68,25,132,33,
100,33,197,41,197,41,70,58,201,74,168,66,70,58,135,58,
103,50,168,66,200,74,200,74,70,58,164,41,196,49,230,57,
196,33,164,33,132,33,35,17,226,16,68,25,133,33,133,33,
101,33,166,41,199,41,8,50,7,50,231,49,72,58,104,58,
71,50,6,42,103,58,136,58,168,58,200,66,103,50,70,42,
40,50,104,58,72,50,138,58,205,74,238,74,238,74,205,66,
140,66,169,66,168,74,168,74,103,66,9,50,76,58,41,42,
139,58,175,66,76,58,10,50,74,58,38,42,104,50,169,66,
103,50,171,66,14,83,235,66,174,58,145,58,171,58,233,66,
136,66,137,58,136,58,102,58,172,66,121,75,255,75,253,67,
222,67,222,67,222,67,254,75,254,75,254,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,222,75,
254,75,222,75,222,75,222,75,254,75,254,75,254,75,222,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,84,30,84,
254,75,30,84,30,84,254,75,254,75,254,75,254,75,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,254,75,
8,75,200,66,9,75,175,116,44,100,198,50,102,42,198,33,
228,33,230,50,67,26,99,34,227,50,66,42,100,58,34,42,
131,49,192,32,98,57,40,107,165,66,70,75,38,67,229,58,
164,42,35,34,100,50,228,57,37,74,98,49,4,58,101,58,
227,25,4,42,0,25,1,33,163,49,131,41,66,33,34,33,
4,51,163,42,34,58,68,82,3,74,163,65,37,90,171,123,
69,74,1,33,161,32,134,65,199,65,39,74,233,90,167,82,
166,66,195,49,166,74,39,83,197,66,229,58,71,83,201,99,
230,82,6,83,230,74,7,75,136,91,233,99,103,83,197,58,
166,58,6,67,71,75,168,83,234,91,202,91,170,83,234,91,
169,91,136,83,71,83,165,58,100,50,165,66,165,58,133,50,
6,59,3,34,163,33,67,25,161,8,34,25,134,58,101,58,
99,58,5,75,6,75,164,58,132,50,165,58,230,66,230,66,
72,83,202,99,100,50,39,75,39,75,7,75,105,83,7,75,
167,74,38,58,38,58,71,58,38,58,70,58,102,58,102,58,
135,66,102,58,167,74,167,74,232,82,9,83,74,91,138,91,
73,91,9,83,200,74,232,74,200,74,135,58,70,58,103,66,
70,66,5,50,38,58,168,74,233,82,200,74,135,66,134,66,
135,66,167,74,9,83,138,99,171,107,139,99,74,91,9,83,
169,74,10,91,139,107,106,99,9,83,42,91,103,58,100,25,
105,66,104,58,38,50,196,41,9,75,139,91,203,99,77,116,
140,132,150,124,185,91,139,83,36,83,102,58,19,50,251,74,
114,42,233,33,133,33,201,49,170,33,172,25,138,25,134,25,
132,17,133,25,133,33,36,50,227,33,197,33,6,42,135,58,
43,50,234,41,169,33,10,50,135,33,166,33,36,17,100,33,
165,33,229,41,103,58,135,66,103,58,70,50,71,58,104,58,
71,50,39,50,135,58,41,83,167,74,196,41,196,41,229,49,
131,33,67,25,100,25,35,17,194,8,3,17,100,25,100,33,
134,33,166,33,8,50,137,66,39,50,231,41,201,74,201,74,
229,41,6,42,103,58,103,58,103,50,135,58,103,50,38,42,
104,58,169,66,169,66,137,58,170,66,171,58,237,66,47,75,
12,75,9,75,232,74,233,74,168,66,105,58,75,50,41,42,
72,50,105,58,106,58,76,58,40,50,164,33,8,42,136,58,
136,58,103,58,137,58,171,58,207,58,209,58,139,50,234,66,
168,66,136,58,169,58,103,58,172,66,88,75,223,75,254,75,
222,67,222,67,222,67,254,75,254,75,254,75,222,67,222,67,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,76,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
137,74,139,91,170,83,137,83,133,50,134,50,72,75,132,42,
197,41,2,34,6,51,231,50,165,50,131,42,99,42,131,42,
133,58,36,58,101,90,72,107,38,83,38,67,228,50,196,42,
35,34,194,25,97,17,130,33,99,41,98,41,163,41,195,41,
96,25,3,42,68,58,194,33,2,42,67,50,193,41,3,66,
228,58,66,34,2,50,36,74,130,49,33,49,66,65,163,57,
98,41,1,33,225,32,68,49,230,73,39,74,38,66,228,57,
37,74,36,66,69,74,137,99,71,75,6,67,229,58,39,75,
168,91,39,75,230,66,198,66,40,75,168,91,167,91,36,75,
166,58,165,58,229,66,71,75,201,91,11,92,170,75,105,75,
7,67,39,75,103,83,70,83,229,74,164,66,100,58,68,50,
197,58,194,33,98,25,34,25,161,8,1,17,4,42,3,42,
35,42,6,75,71,83,229,66,229,58,164,50,230,66,197,58,
99,50,103,83,6,75,132,58,68,50,166,66,167,66,41,83,
232,74,37,50,135,66,135,66,6,50,70,58,135,66,167,66,
134,58,102,58,167,74,200,74,41,91,9,83,9,83,73,83,
232,74,9,83,41,83,73,83,41,83,232,74,200,74,232,74,
232,82,70,58,38,58,103,66,168,74,168,74,167,74,232,82,
74,99,9,83,9,83,41,91,9,83,9,83,9,83,232,82,
200,82,232,82,41,91,106,99,139,107,205,107,137,66,101,25,
167,41,231,41,164,33,196,41,74,91,204,99,46,116,176,124,
173,132,237,132,49,108,140,83,71,50,5,50,49,58,183,58,
149,50,236,33,69,17,69,25,5,17,167,25,135,25,168,25,
70,17,134,25,132,25,227,33,162,33,69,50,168,66,168,58,
40,50,8,50,8,42,232,41,231,41,166,33,100,25,164,33,
229,41,70,58,168,66,70,58,229,41,71,50,136,58,72,58,
169,66,71,50,71,58,41,83,8,75,70,50,6,50,229,41,
197,41,132,33,132,33,100,25,35,25,68,25,100,25,100,33,
132,33,6,50,137,66,170,74,137,66,104,58,169,66,103,58,
230,41,6,50,71,58,71,58,71,50,103,50,38,50,5,42,
103,58,200,66,200,74,135,58,38,50,72,50,203,58,13,75,
169,58,168,58,201,66,10,75,10,75,139,66,12,50,234,41,
39,50,72,58,137,66,139,58,73,50,230,33,42,50,72,50,
168,66,103,58,71,50,139,58,207,58,209,58,175,58,169,58,
104,66,168,58,234,66,138,66,173,66,55,67,222,75,254,75,
222,67,222,67,222,67,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
255,75,222,75,222,75,222,75,222,75,222,75,222,75,255,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,222,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,254,75,254,75,30,84,30,84,
254,75,30,84,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,30,76,30,84,30,84,30,84,29,84,
30,84,254,75,254,75,254,75,254,75,30,84,30,84,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
232,74,77,108,11,84,197,42,35,26,231,58,42,67,234,50,
3,33,198,41,233,58,168,50,102,42,4,26,2,26,99,34,
67,42,35,58,199,98,231,106,198,82,164,58,132,42,35,34,
226,33,129,17,162,17,98,17,98,25,33,25,163,33,97,25,
35,58,132,66,70,83,37,59,228,50,69,67,5,83,132,90,
4,58,98,33,66,33,230,65,229,49,131,49,66,41,65,33,
101,42,4,42,163,33,66,33,99,41,131,49,131,41,5,58,
102,90,134,90,138,115,39,91,6,75,71,75,6,67,7,75,
200,83,38,59,40,67,72,67,72,75,71,75,199,91,165,83,
135,66,100,58,197,66,5,67,136,75,202,83,105,67,40,59,
8,59,198,58,229,66,102,83,70,83,164,66,132,58,101,58,
197,58,194,33,33,17,193,16,193,8,1,17,227,33,226,33,
194,33,198,66,6,75,165,58,38,75,164,58,229,58,197,58,
70,75,168,91,38,75,68,50,3,42,102,58,9,83,232,74,
135,66,229,41,200,74,200,74,38,58,70,58,38,58,70,58,
232,74,41,83,232,74,37,58,102,66,167,74,167,66,199,66,
232,74,41,91,41,83,8,75,106,91,171,99,74,91,232,74,
232,82,135,66,168,74,201,74,233,82,201,74,232,82,106,99,
200,74,135,74,135,66,200,74,135,66,200,74,8,83,41,91,
106,99,41,91,199,82,232,82,107,99,11,91,134,33,228,16,
71,25,8,50,132,33,228,41,106,91,237,107,209,132,18,141,
82,149,79,149,143,99,74,50,107,25,231,41,42,42,75,34,
79,34,234,25,69,17,40,25,11,25,138,33,106,25,243,49,
204,41,168,25,197,25,228,33,66,25,71,58,169,66,137,50,
37,42,5,42,103,50,7,42,72,50,100,25,132,33,196,41,
103,58,168,66,167,66,5,50,5,50,136,66,169,66,137,66,
201,74,169,66,168,66,8,75,8,75,200,66,168,66,71,50,
38,50,5,42,230,41,165,33,100,33,68,25,100,33,230,41,
5,50,135,66,103,58,39,50,104,58,137,58,71,50,104,50,
39,58,104,58,6,50,197,41,38,50,71,50,38,50,38,42,
169,66,201,66,168,66,71,58,6,42,104,50,171,58,140,58,
105,58,137,58,234,66,73,75,137,83,234,66,42,50,73,50,
72,58,73,58,103,58,73,50,41,50,41,42,141,66,107,58,
195,41,40,58,137,66,203,58,173,50,178,58,244,66,168,58,
104,74,135,58,234,58,107,58,174,66,87,75,255,83,31,76,
222,67,222,67,222,67,222,67,222,67,254,75,254,75,254,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,222,75,222,75,255,75,255,75,222,75,222,75,222,75,
222,75,222,75,254,75,254,75,254,75,254,75,222,75,222,75,
255,75,222,75,222,75,222,75,222,75,222,75,222,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,222,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,222,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,255,75,255,75,
222,75,222,75,222,75,254,75,255,75,255,75,255,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,30,76,30,76,254,75,254,75,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,29,84,29,84,
30,84,254,75,254,75,254,75,30,84,30,84,30,84,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,30,84,30,84,254,75,
168,74,228,33,69,50,101,50,164,33,198,41,42,75,41,67,
43,67,168,82,135,67,5,43,165,50,35,42,133,66,162,33,
32,33,195,73,4,90,194,73,68,66,166,66,1,25,225,24,
1,17,1,17,34,17,66,25,66,25,163,25,228,33,195,33,
196,66,39,107,231,99,166,75,133,67,4,67,38,91,102,67,
37,59,165,58,69,58,71,74,201,98,106,107,198,74,99,50,
65,34,4,59,196,58,194,41,66,41,131,49,69,66,67,58,
67,66,165,74,36,58,227,41,228,33,198,66,71,75,38,75,
165,50,198,58,7,67,7,67,7,75,6,67,6,67,103,75,
70,75,131,50,132,50,6,75,39,75,72,75,105,75,231,58,
198,58,165,58,230,66,230,74,39,83,38,83,163,58,196,66,
230,66,4,42,65,17,225,16,225,16,2,17,66,25,163,25,
227,41,3,50,100,58,99,50,132,50,165,58,165,58,6,67,
135,75,101,83,134,83,197,50,7,67,199,74,135,66,6,50,
167,74,135,66,232,82,74,91,135,66,5,50,229,49,103,66,
201,66,136,66,5,50,197,41,164,41,135,66,168,74,70,58,
167,66,167,66,232,74,105,91,41,83,232,74,41,83,8,75,
200,74,135,66,70,58,135,66,167,66,167,74,232,82,9,83,
102,58,102,66,103,74,135,74,232,82,74,91,8,83,167,74,
41,91,9,91,136,82,200,82,72,91,233,66,76,17,23,42,
179,50,203,33,101,25,132,41,11,99,111,132,50,141,208,116,
239,140,13,141,205,124,78,42,212,33,170,33,199,41,232,49,
134,25,4,17,37,25,168,33,202,33,107,25,209,25,157,75,
244,58,42,34,163,33,3,50,162,33,164,33,230,41,195,33,
166,33,39,50,169,66,136,58,198,41,3,17,133,33,7,50,
39,58,39,58,39,50,6,50,104,58,169,66,136,58,201,66,
200,66,38,42,200,66,74,83,167,58,102,58,135,58,37,42,
103,58,38,50,229,41,99,33,229,41,229,41,38,50,135,66,
39,50,6,50,229,49,229,49,197,41,104,58,137,58,73,50,
169,66,137,58,71,50,6,42,168,66,39,50,230,49,71,58,
232,74,201,74,103,58,69,50,71,50,75,50,173,50,41,34,
7,42,40,50,137,58,201,66,11,75,11,75,203,66,138,58,
39,50,7,50,232,49,9,50,9,50,106,50,205,58,75,42,
132,33,3,42,39,42,204,66,11,75,172,58,174,66,105,42,
134,50,106,58,203,74,200,66,174,58,241,50,188,75,255,75,
223,75,31,76,254,75,190,67,223,75,254,75,221,75,222,75,
254,75,222,75,254,75,254,75,30,76,189,67,222,67,222,67,
222,75,254,75,222,75,254,75,254,75,254,75,222,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,222,75,
222,75,223,75,223,75,255,75,255,75,223,75,223,75,222,75,
254,75,254,75,222,75,222,75,222,75,222,75,222,75,254,75,
222,75,222,75,223,75,223,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,30,84,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,30,76,30,76,254,75,254,75,30,76,30,76,254,75,
30,84,254,75,254,75,30,84,30,84,254,75,254,75,30,84,
254,75,254,75,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,30,84,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,76,30,76,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
254,83,254,83,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
165,58,100,42,35,34,165,50,68,42,194,33,40,75,105,83,
204,91,235,107,8,92,4,43,195,50,130,42,131,50,34,42,
225,32,160,32,197,73,70,82,164,49,2,17,226,16,162,16,
34,17,1,9,1,17,224,8,1,17,33,17,33,17,98,25,
164,74,75,148,41,116,196,58,70,75,5,67,100,66,229,58,
6,59,198,66,233,90,11,107,141,131,46,140,8,91,7,75,
196,58,4,59,70,75,197,66,101,66,228,57,36,58,165,66,
6,83,68,58,162,41,163,41,163,33,4,42,68,50,164,58,
165,58,198,58,198,66,198,66,198,58,165,58,197,58,6,67,
38,75,197,58,164,58,165,58,230,66,40,67,72,67,40,67,
7,59,198,58,197,58,197,66,70,83,135,91,37,75,5,75,
7,67,36,42,65,17,225,16,193,8,193,8,1,17,98,25,
196,41,101,58,198,74,67,50,165,58,230,66,67,42,6,67,
103,75,70,75,167,91,137,75,41,75,196,41,131,33,6,50,
200,74,232,82,232,74,41,83,9,75,167,66,70,58,71,58,
196,41,164,33,131,33,229,49,103,66,9,83,9,83,200,74,
200,74,232,74,41,83,8,83,167,66,199,66,232,74,135,66,
70,58,38,58,5,50,5,50,102,58,200,74,232,82,135,66,
168,66,103,66,5,58,38,66,41,91,171,99,167,74,196,41,
168,74,41,91,200,82,200,82,42,91,234,74,138,25,114,50,
234,25,68,9,98,25,163,41,103,66,74,83,108,83,143,83,
78,116,46,149,12,133,203,58,239,33,167,33,231,41,40,50,
201,33,5,25,5,25,70,25,70,17,40,17,141,17,182,50,
180,50,46,34,166,25,164,33,67,25,101,25,166,33,69,33,
41,50,170,66,40,50,39,50,229,41,67,25,197,41,71,58,
104,66,6,50,6,50,71,58,104,58,6,50,197,33,71,50,
168,66,103,58,135,58,167,66,102,58,70,50,102,58,135,58,
168,66,135,66,229,41,99,25,99,25,6,50,103,58,135,66,
39,50,229,41,164,41,197,41,197,41,72,58,170,66,170,58,
71,50,39,50,135,58,102,58,38,50,229,41,38,50,71,58,
134,58,9,83,8,75,167,58,40,50,45,50,146,58,49,42,
72,50,137,66,230,41,71,50,201,66,201,66,11,75,202,66,
103,58,72,58,73,58,138,66,170,66,170,58,170,58,74,42,
133,25,134,33,232,41,106,58,203,66,203,66,74,50,41,42,
72,50,137,66,171,66,110,58,148,66,209,58,122,67,191,75,
253,67,253,75,31,76,255,67,223,67,254,67,254,67,255,67,
222,67,222,67,31,76,254,75,255,75,255,75,255,75,223,75,
255,75,255,75,222,75,222,75,254,75,254,75,222,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
222,75,223,75,223,75,223,75,223,75,223,75,223,75,222,75,
254,75,254,75,254,75,222,75,222,75,222,75,222,75,254,75,
223,75,223,75,223,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,30,76,30,76,254,75,254,75,30,76,30,76,254,75,
30,84,254,75,254,75,30,84,30,84,254,75,254,75,30,84,
254,75,254,75,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,30,84,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,76,30,76,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,254,75,30,84,30,84,
254,83,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
136,83,166,50,36,34,3,26,226,33,226,41,166,82,9,91,
42,75,6,67,163,50,163,42,131,34,130,34,163,34,231,74,
135,74,103,74,234,106,68,57,162,24,129,16,3,17,100,17,
196,33,66,17,1,17,192,8,1,25,66,25,1,17,131,33,
5,83,103,107,226,49,193,41,39,83,231,66,166,66,7,67,
70,67,198,66,168,90,137,98,11,123,47,148,9,99,105,99,
70,75,37,67,228,58,229,66,72,91,231,82,105,91,133,66,
165,66,3,50,163,41,99,41,1,25,163,41,36,50,198,66,
6,75,71,75,7,75,230,66,198,58,133,50,165,58,165,58,
100,50,133,58,100,50,133,50,230,66,72,75,137,75,202,83,
72,75,71,75,39,75,230,66,5,75,102,83,102,83,70,83,
71,75,68,42,65,17,1,17,1,17,192,8,225,8,163,33,
99,33,102,58,231,74,68,50,166,58,198,58,68,42,6,67,
169,83,103,83,168,91,12,100,234,66,2,17,225,16,6,42,
70,58,200,74,134,58,199,66,41,83,200,74,70,58,37,50,
196,41,131,41,228,49,135,74,232,82,232,82,135,66,232,74,
200,74,232,74,232,74,199,74,199,74,41,83,41,83,167,66,
200,74,168,74,70,58,228,41,229,49,135,66,9,83,167,66,
102,58,103,66,6,58,70,66,200,74,167,66,102,58,135,66,
234,82,105,99,231,82,168,74,44,91,203,74,5,9,71,17,
74,9,72,17,70,25,166,41,230,49,201,74,170,66,140,58,
140,91,47,141,77,141,136,75,232,33,100,25,6,50,72,50,
231,41,3,25,4,25,4,17,4,9,71,25,173,33,84,42,
213,50,179,50,9,34,133,33,102,33,71,25,69,25,71,33,
9,50,41,50,231,41,104,58,200,66,70,58,37,50,70,58,
71,58,168,66,136,66,6,50,5,42,71,58,38,50,197,41,
71,58,168,66,135,66,135,58,168,66,102,58,228,41,5,50,
71,58,70,58,229,41,38,50,164,33,229,41,38,50,38,50,
38,50,6,50,6,50,230,49,7,50,39,50,105,58,137,58,
6,42,6,42,136,58,103,58,5,42,5,50,102,58,5,42,
38,50,201,66,233,74,168,66,105,50,175,58,210,66,113,50,
104,58,201,66,38,50,38,42,135,58,168,58,9,75,9,75,
135,58,72,58,104,58,169,58,233,66,201,66,103,50,71,50,
9,42,138,33,136,33,232,41,171,66,234,74,168,58,172,58,
204,74,171,66,107,66,174,66,19,75,210,50,90,67,221,75,
119,59,154,67,254,75,31,76,222,67,222,67,255,75,255,75,
254,67,255,75,255,75,222,67,255,75,255,75,255,75,223,75,
223,75,255,75,223,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,222,75,222,75,222,75,254,75,
223,75,223,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,254,75,254,75,30,84,30,84,254,75,254,75,30,84,
254,75,254,75,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,76,30,76,254,75,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
200,74,167,66,70,42,195,25,163,33,162,49,228,65,233,98,
42,83,6,51,132,58,6,67,229,50,130,34,1,18,102,74,
78,148,107,115,136,82,129,24,129,24,194,24,2,17,67,17,
131,25,1,17,1,17,34,25,131,41,99,41,1,25,98,33,
132,66,226,49,64,33,33,33,69,66,40,75,198,58,71,67,
167,75,164,58,4,66,197,73,231,81,10,107,168,82,106,99,
169,91,9,92,228,50,229,58,165,58,170,107,12,124,134,74,
7,75,101,66,163,49,2,33,160,24,67,41,228,49,4,50,
164,58,6,75,230,66,197,58,165,58,100,50,133,50,68,50,
194,33,3,42,35,42,36,42,133,58,198,58,230,58,39,67,
104,75,71,75,230,66,197,58,164,58,228,66,37,75,228,66,
71,75,132,50,130,25,33,17,34,25,1,17,34,17,196,33,
100,33,70,58,134,58,68,50,101,50,101,50,133,50,197,58,
230,58,229,66,201,91,77,108,104,50,3,17,132,41,103,58,
70,58,9,83,168,66,232,74,106,83,233,74,135,66,102,58,
37,58,5,58,200,82,138,107,171,107,73,91,167,66,200,74,
41,83,41,83,8,83,8,83,199,66,134,58,135,66,135,66,
135,66,135,66,102,58,37,50,229,49,102,58,200,74,168,74,
135,66,168,74,38,66,38,58,233,82,74,91,233,82,70,66,
7,58,199,74,7,83,233,82,11,83,105,58,195,8,196,8,
209,41,79,50,12,50,46,83,171,66,137,58,169,58,204,66,
202,58,12,108,110,149,39,100,228,33,98,33,6,50,5,34,
67,25,161,16,194,24,227,16,227,8,70,25,139,33,49,42,
49,34,144,50,232,33,196,33,41,50,169,33,37,17,198,41,
167,33,102,33,7,50,39,50,103,58,70,58,37,50,37,50,
71,58,103,58,136,66,38,50,5,42,103,58,168,66,38,50,
168,74,74,91,135,66,69,58,102,66,229,49,67,25,132,33,
168,66,168,66,103,58,136,66,5,50,196,41,38,50,136,66,
5,50,38,50,71,58,39,50,104,58,72,58,104,58,104,58,
230,33,7,42,39,50,6,42,5,42,37,50,70,50,229,41,
39,42,103,50,201,66,233,66,170,58,13,67,13,67,203,58,
231,41,72,50,137,58,71,50,71,50,70,50,103,58,233,74,
136,66,71,50,104,50,135,50,167,58,167,58,37,50,38,50,
171,66,110,58,43,50,137,58,202,66,167,58,199,66,171,66,
203,74,204,74,173,66,172,66,14,67,52,67,219,83,150,59,
179,50,57,67,190,83,255,83,221,75,222,75,254,75,222,75,
254,75,254,75,254,75,222,67,222,67,254,75,254,75,254,75,
223,75,255,75,255,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
255,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,254,75,254,75,30,84,30,84,254,75,254,75,30,84,
254,75,254,75,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,30,84,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,84,30,84,30,84,
30,84,254,75,254,75,254,75,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,76,30,76,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
233,82,167,66,100,42,165,50,68,42,69,58,7,83,197,82,
36,50,228,50,163,58,229,74,69,75,134,83,228,66,102,90,
139,139,50,181,237,123,233,82,71,58,194,16,161,16,194,24,
2,17,193,8,225,16,67,33,67,33,34,33,34,33,66,33,
98,33,131,41,99,57,229,73,37,74,198,74,198,66,100,50,
4,51,67,42,69,66,168,98,103,82,103,74,37,58,232,82,
137,91,6,67,5,59,6,59,71,83,8,91,200,90,135,82,
232,74,5,50,225,24,226,32,161,24,161,16,66,33,131,33,
35,50,230,66,198,66,230,66,198,58,165,58,166,58,101,50,
227,33,227,33,227,41,36,42,100,50,133,58,165,50,165,58,
71,67,7,67,6,67,229,66,164,58,196,58,37,75,37,75,
5,67,165,58,195,33,1,17,225,16,66,25,98,25,131,25,
165,33,167,66,40,75,8,75,101,50,36,42,230,58,104,75,
104,75,102,83,232,91,234,91,70,42,229,41,102,66,134,58,
196,41,103,58,102,58,232,66,74,83,9,75,233,74,233,74,
70,66,37,58,199,82,8,91,73,99,203,107,138,99,73,91,
9,83,9,83,8,75,8,83,199,66,37,50,70,50,167,66,
70,58,71,58,102,58,102,58,70,58,135,66,167,74,135,66,
103,58,6,50,197,49,71,66,233,82,9,83,9,83,200,74,
71,66,200,74,9,83,169,74,40,58,166,33,229,16,105,33,
173,33,234,41,132,25,169,58,39,42,71,50,43,83,15,108,
10,75,233,74,15,149,169,124,4,42,34,25,132,33,131,25,
228,16,130,16,195,24,35,25,67,25,35,17,70,25,13,42,
80,42,75,50,6,42,196,33,231,33,171,33,170,33,229,33,
133,33,7,50,10,83,6,50,70,58,136,66,233,74,200,66,
135,58,38,50,38,50,103,58,233,74,168,66,168,66,168,66,
168,74,106,91,135,66,37,58,37,58,164,41,67,33,164,41,
99,33,70,58,103,58,229,41,229,41,197,41,70,58,70,58,
164,41,197,41,6,50,230,41,7,50,230,41,6,42,39,50,
230,41,199,41,167,33,231,41,39,42,38,42,38,42,104,58,
135,58,134,58,199,58,233,66,202,58,43,75,202,58,169,50,
231,41,231,41,137,58,137,66,39,50,230,41,38,50,168,66,
6,42,7,42,137,50,168,58,167,58,167,66,135,66,136,66,
7,34,42,42,74,50,170,66,135,58,69,50,167,66,203,74,
9,67,73,75,11,67,175,58,241,58,21,59,119,67,211,34,
182,50,91,67,223,83,255,75,254,75,253,75,220,67,188,67,
188,67,189,67,222,75,255,75,255,75,222,75,222,75,254,75,
255,75,255,75,254,75,222,75,222,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,222,75,222,75,222,75,222,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
30,84,30,84,254,75,254,75,254,75,30,84,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,30,84,30,84,254,75,254,75,30,84,30,84,254,75,
30,84,30,84,254,75,30,84,30,84,30,84,30,84,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,30,84,30,84,
30,84,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,76,30,76,30,76,30,76,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
11,75,74,75,202,75,169,75,199,50,41,75,137,83,164,50,
4,58,196,58,229,74,165,66,99,50,228,74,71,99,167,90,
204,123,237,123,75,107,47,132,105,74,194,16,36,17,4,17,
225,8,225,16,1,17,34,25,225,24,225,24,131,41,196,41,
67,33,67,49,43,139,13,156,134,90,167,98,231,90,231,90,
70,67,132,58,101,74,200,90,38,66,196,41,195,41,228,49,
68,58,68,50,36,42,166,66,235,115,73,107,9,99,42,107,
38,58,196,49,67,33,198,57,68,41,96,8,193,16,100,33,
194,33,100,58,165,58,197,58,197,58,165,58,165,58,100,50,
3,42,162,25,130,25,195,33,4,42,68,50,101,50,133,50,
133,50,165,50,198,66,230,66,132,58,99,58,197,66,38,75,
196,58,99,42,194,33,65,17,1,17,66,25,131,25,196,33,
165,33,200,66,170,91,8,75,69,50,4,34,101,50,104,83,
80,133,171,116,40,100,71,67,228,33,229,49,4,50,195,33,
196,41,229,49,37,50,135,66,9,75,200,74,233,82,233,82,
134,66,167,74,73,91,231,82,199,74,106,99,139,99,233,74,
167,66,199,74,166,66,166,66,167,66,70,58,70,58,135,66,
200,74,168,74,102,66,102,66,167,66,168,74,167,74,102,66,
103,58,70,58,103,66,103,66,135,66,200,74,232,74,167,74,
201,74,200,82,10,91,202,82,137,74,231,49,6,17,107,33,
105,25,231,33,166,58,41,83,201,66,233,74,168,66,233,74,
204,91,135,66,78,124,170,124,229,41,227,24,35,33,66,25,
194,8,129,16,161,16,3,17,67,25,226,16,229,16,172,33,
45,50,201,33,73,58,71,50,198,33,236,41,13,42,67,9,
2,17,6,50,136,66,38,50,201,74,168,66,234,74,136,66,
200,74,103,58,5,42,70,50,74,91,200,74,103,58,168,66,
135,66,233,82,102,66,200,74,200,74,103,66,197,41,99,33,
34,25,71,58,168,66,229,41,71,58,6,50,197,41,132,33,
100,33,100,33,165,33,6,42,39,50,230,41,39,50,72,58,
72,50,200,33,200,33,106,58,202,66,168,58,103,50,137,58,
105,58,134,50,166,58,199,58,200,58,10,75,72,50,41,50,
40,50,231,41,8,42,138,66,105,58,7,50,104,58,103,58,
6,42,39,50,202,66,234,74,168,66,135,58,135,58,136,66,
39,42,38,42,202,66,234,74,199,66,199,66,201,66,10,75,
200,66,6,67,232,66,206,66,50,67,246,58,54,59,89,67,
58,59,188,75,254,75,255,67,31,68,219,59,184,59,184,59,
120,67,153,67,187,67,254,75,255,75,255,75,223,75,223,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,30,84,30,84,254,75,254,75,30,84,30,84,254,75,
30,84,30,84,254,75,254,75,30,84,30,84,30,84,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
137,58,237,91,13,92,199,50,69,42,133,50,35,42,6,59,
167,82,166,74,230,66,167,66,165,58,3,50,134,82,136,58,
73,75,203,107,9,99,172,115,74,91,103,50,165,17,68,9,
160,8,225,16,2,25,1,25,225,16,34,25,99,33,163,33,
196,41,196,57,201,130,142,156,198,90,166,98,73,107,70,74,
3,42,66,33,66,41,132,49,131,41,1,17,33,25,1,33,
69,82,171,123,5,66,38,66,164,57,102,74,38,66,164,49,
194,24,2,33,3,33,165,49,68,33,161,16,161,16,3,25,
65,33,3,50,132,50,164,50,164,50,165,58,165,58,165,58,
100,50,227,33,130,25,162,33,195,33,227,41,228,33,227,33,
68,42,36,42,133,58,133,58,100,58,100,58,132,58,197,66,
196,50,2,34,161,25,98,25,33,25,34,17,163,33,5,42,
99,17,4,42,36,42,162,25,130,17,98,17,130,17,36,42,
170,83,168,91,104,108,200,83,69,42,197,41,164,41,196,41,
164,41,132,33,197,41,38,50,167,66,167,66,200,74,200,74,
167,66,232,74,105,91,231,82,101,66,102,66,200,74,168,74,
73,83,171,99,41,83,134,66,102,58,38,50,38,50,38,50,
103,66,70,58,37,50,103,66,200,74,135,66,102,66,135,66,
167,66,102,58,233,82,74,99,41,83,199,66,134,66,41,91,
232,82,232,82,200,82,169,82,203,82,40,58,5,17,73,17,
106,25,70,17,39,50,103,66,136,66,102,58,37,50,135,58,
168,66,101,66,41,91,41,108,99,25,97,8,161,16,226,16,
193,16,193,24,194,24,3,17,35,17,3,17,7,17,205,33,
136,25,104,25,233,49,165,33,165,33,234,41,202,41,36,25,
226,16,132,33,164,33,71,58,200,74,38,50,71,58,71,50,
42,83,103,58,196,33,5,50,233,74,38,50,38,50,200,74,
9,83,9,83,102,58,9,83,41,83,200,74,38,50,67,25,
132,33,6,50,38,50,197,41,229,41,197,41,99,33,197,41,
133,41,165,41,197,41,38,42,6,42,39,50,39,50,231,41,
39,50,232,41,233,41,106,58,202,66,9,67,135,50,39,42,
232,41,103,50,40,75,74,75,9,67,9,75,38,50,170,66,
72,50,198,33,133,25,7,50,40,50,39,50,104,58,103,58,
135,58,136,58,136,58,169,66,201,74,136,58,136,58,169,66,
136,58,102,50,233,66,234,74,233,74,9,75,136,58,167,58,
169,74,232,74,231,66,169,58,206,66,246,74,53,67,87,75,
120,67,117,59,183,59,253,67,253,75,182,59,177,59,209,67,
178,67,146,67,84,59,152,67,187,67,253,75,254,75,254,67,
252,75,252,75,253,75,30,76,254,75,222,75,255,75,223,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,76,30,76,30,84,30,84,30,76,30,76,30,84,
254,75,30,84,30,84,254,75,254,75,30,84,30,84,254,75,
30,84,30,84,254,75,254,75,30,84,30,84,30,84,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,76,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
134,58,167,58,37,42,166,66,103,91,232,107,9,108,42,108,
170,123,39,91,132,42,72,75,176,149,9,108,166,82,166,34,
133,66,43,116,104,91,139,108,78,117,136,59,5,26,35,25,
2,17,2,25,34,25,160,8,225,16,98,33,66,25,131,33,
195,17,163,41,228,89,10,116,229,74,36,74,134,74,38,58,
164,41,193,32,227,40,165,57,229,49,225,16,225,24,100,57,
134,106,168,106,7,82,165,65,132,57,225,32,34,33,225,8,
96,16,194,24,194,24,3,25,226,16,194,16,194,16,3,25,
98,33,4,50,133,50,132,50,132,42,164,50,132,58,165,58,
100,50,36,42,162,33,162,33,228,41,4,42,195,33,195,33,
194,25,194,33,68,50,35,50,227,41,3,50,226,41,100,58,
196,50,99,42,226,33,65,25,224,8,33,17,163,33,163,25,
131,25,101,50,3,34,194,25,195,33,228,33,167,58,8,67,
9,67,38,75,137,116,200,83,195,25,99,33,6,50,168,66,
6,58,229,49,38,50,38,50,135,66,103,66,135,66,167,74,
199,66,200,74,105,91,235,107,170,107,200,74,9,91,107,99,
106,91,138,91,167,66,4,42,5,50,37,50,229,41,164,33,
164,41,164,41,164,41,102,58,168,74,5,50,37,58,41,83,
41,75,70,58,135,74,200,82,41,83,200,74,37,50,167,74,
134,66,101,66,5,66,7,66,236,90,138,66,69,17,135,17,
137,25,37,17,4,17,226,16,164,41,101,58,199,66,71,50,
5,42,72,91,106,99,138,116,132,33,130,16,129,16,162,16,
163,8,195,24,227,24,227,8,225,8,226,16,37,25,171,33,
164,17,235,41,169,41,66,17,229,41,134,33,227,16,4,25,
35,25,100,33,197,41,201,74,103,58,38,50,37,50,168,66,
9,75,135,58,6,50,6,50,103,58,5,50,103,58,168,74,
41,83,41,83,102,58,9,83,232,74,135,66,38,58,164,41,
132,33,6,50,103,58,136,66,71,58,70,58,132,33,38,50,
199,49,6,50,5,50,37,42,5,42,168,66,137,66,231,49,
100,25,231,41,200,33,167,33,6,34,167,58,102,50,229,33,
70,58,165,58,105,83,45,108,238,99,171,91,134,58,75,91,
233,74,38,42,197,33,133,33,197,33,6,50,6,50,135,66,
73,83,9,75,38,50,71,58,201,74,168,66,168,58,202,58,
10,75,10,75,201,66,136,58,104,58,71,50,70,50,134,58,
169,82,103,66,102,66,104,58,140,58,178,66,237,58,239,66,
50,67,204,50,16,51,186,75,187,83,146,75,171,75,234,83,
12,76,204,67,45,51,17,51,85,51,250,67,252,75,29,76,
219,67,219,67,220,67,253,75,254,75,254,75,255,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,222,75,254,75,254,75,255,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
31,76,254,75,254,75,254,75,254,75,254,75,254,75,222,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,30,84,30,84,30,84,254,75,254,75,254,75,30,84,
30,84,30,84,254,75,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,76,30,76,30,84,30,84,30,76,30,76,30,84,
254,75,30,84,30,84,254,75,254,75,30,84,30,84,254,75,
30,84,30,84,254,75,254,75,30,84,30,84,30,84,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
168,58,5,34,4,34,136,75,200,91,167,99,36,91,40,132,
10,166,195,74,36,34,166,50,172,100,201,67,36,42,35,50,
68,74,231,82,70,51,71,67,171,108,199,51,2,26,194,17,
99,33,225,16,160,8,1,17,131,33,195,33,195,33,65,17,
130,16,161,24,161,40,196,73,4,66,4,74,207,156,40,75,
161,8,130,24,68,57,200,82,132,33,3,25,162,32,42,107,
135,98,74,107,74,107,132,49,194,40,227,48,129,16,193,8,
130,16,3,33,2,25,225,16,160,8,161,16,161,16,227,24,
98,33,162,33,162,33,130,25,3,42,35,42,133,50,133,58,
100,42,67,42,227,33,162,25,163,33,69,50,196,33,5,42,
228,33,69,42,166,58,166,66,100,50,67,58,67,50,197,74,
37,75,4,59,2,34,34,25,2,25,0,17,4,42,67,17,
67,25,4,42,227,41,35,42,36,34,101,42,133,42,199,50,
200,58,231,74,73,116,102,83,131,25,5,50,133,66,201,66,
200,74,70,58,6,50,6,58,6,50,70,58,167,66,135,58,
135,66,41,83,74,91,73,91,170,107,105,99,41,91,73,91,
41,83,41,91,167,74,37,58,228,41,37,50,5,50,229,49,
6,50,6,50,38,58,103,66,5,50,196,41,37,58,167,66,
232,82,168,74,135,66,168,74,233,74,136,66,6,50,6,50,
164,41,132,41,230,49,234,82,76,91,137,58,226,8,226,16,
6,33,228,16,3,17,228,41,228,41,163,41,37,50,38,50,
233,74,170,99,140,116,172,124,97,25,128,8,97,16,33,16,
130,16,162,8,227,24,162,16,130,16,227,24,194,8,35,17,
132,25,198,41,230,24,36,25,5,50,36,33,2,17,3,17,
67,25,197,33,200,58,232,66,5,42,229,41,38,50,168,66,
74,83,233,74,103,58,103,58,168,66,135,58,135,66,167,74,
73,91,106,91,200,74,9,83,233,82,168,74,103,66,38,58,
102,66,200,82,9,91,232,74,200,66,167,58,38,50,100,33,
198,49,166,49,100,25,5,42,135,50,201,58,235,74,232,41,
136,33,134,25,230,41,166,33,101,25,169,66,135,58,197,33,
229,41,38,50,6,42,13,75,171,83,11,100,105,50,234,99,
139,83,103,50,165,33,6,50,38,50,102,58,103,58,103,58,
102,58,102,58,37,50,37,50,232,74,232,74,70,50,200,74,
9,83,233,82,169,74,39,58,198,41,6,50,103,58,200,66,
166,66,170,66,201,74,9,75,17,75,246,74,176,58,233,66,
171,58,169,58,234,74,143,83,245,91,213,75,209,75,74,67,
138,59,170,75,136,42,137,42,48,59,184,67,121,59,186,67,
153,75,116,59,212,67,63,84,253,67,28,68,223,67,255,83,
29,76,254,75,31,76,255,75,254,75,254,75,223,75,223,75,
30,76,254,75,222,75,255,75,255,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,76,254,75,254,75,30,76,30,84,31,84,31,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
254,75,30,84,30,84,30,84,30,84,254,75,254,75,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,29,84,29,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
37,50,195,33,68,42,100,50,100,50,133,58,7,83,76,124,
167,100,2,42,65,9,131,25,198,50,72,59,199,58,231,58,
134,66,228,49,68,50,198,74,102,75,134,59,197,58,226,33,
99,25,1,17,193,8,99,33,228,49,163,33,130,25,65,17,
193,16,161,24,129,56,39,114,167,114,69,90,11,132,165,42,
2,17,195,32,101,57,70,66,34,17,2,25,132,49,138,115,
133,74,72,91,232,74,66,33,161,32,35,57,2,49,160,24,
129,16,161,16,226,24,128,8,161,16,161,16,97,8,162,16,
163,33,37,58,102,58,69,50,101,50,68,42,68,50,67,42,
67,42,35,34,226,33,129,25,98,25,37,50,37,50,36,42,
134,50,69,50,166,58,40,75,197,66,164,58,132,58,196,66,
5,75,4,59,99,42,99,33,35,33,33,17,4,42,99,25,
34,25,4,50,3,42,132,58,133,50,166,50,166,50,198,50,
168,58,7,75,232,99,37,67,163,25,228,41,3,42,102,50,
134,58,102,58,37,50,164,41,131,33,196,41,38,50,135,58,
102,58,167,66,102,66,69,58,41,91,171,107,203,107,138,99,
106,91,199,66,69,58,102,58,69,58,37,50,5,50,102,58,
103,66,38,58,5,50,38,58,102,66,167,66,167,74,167,66,
135,66,135,66,135,66,168,74,233,74,168,74,70,58,197,41,
102,66,6,58,6,58,202,82,108,91,136,58,194,8,129,8,
164,16,4,17,35,17,67,25,131,33,163,41,102,58,41,83,
143,124,77,116,172,124,10,100,130,25,96,0,130,16,66,16,
161,16,68,33,226,16,227,24,130,16,162,16,36,25,36,17,
136,17,139,25,6,9,132,33,166,41,194,8,194,16,228,16,
132,33,229,41,200,66,70,42,131,25,229,49,229,41,168,66,
168,66,233,74,168,66,38,50,71,50,103,58,135,66,9,83,
106,91,41,83,167,74,9,83,233,82,200,74,168,74,201,82,
74,91,41,91,9,83,9,83,9,75,168,58,230,41,100,33,
231,57,40,58,6,42,103,50,168,58,136,50,168,58,234,74,
7,42,198,33,199,41,234,41,201,41,73,50,104,50,40,42,
198,33,133,25,198,33,170,58,9,67,235,91,232,66,231,66,
232,66,135,58,230,41,71,50,168,66,200,74,70,50,6,42,
167,66,168,66,9,75,233,74,167,66,200,74,232,74,232,74,
135,66,135,66,136,66,104,58,105,66,136,66,168,66,168,66,
168,66,103,58,233,74,42,75,173,50,212,66,211,66,107,50,
175,58,236,74,42,83,10,75,176,75,85,92,18,92,137,42,
134,34,8,59,234,66,136,42,236,50,84,59,116,67,117,67,
55,59,19,51,82,51,223,75,255,67,61,68,223,75,222,75,
30,76,254,75,255,75,254,75,254,75,254,75,254,75,223,75,
254,75,254,75,222,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,29,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
5,50,37,50,4,42,102,50,69,50,171,91,73,83,138,83,
132,59,132,50,68,34,162,33,2,34,38,59,165,50,75,92,
73,75,196,57,70,74,235,123,9,108,37,67,100,66,198,82,
37,50,131,33,224,8,1,17,164,41,4,50,68,50,68,50,
5,66,131,57,196,81,77,164,235,139,227,73,72,99,71,67,
68,33,101,49,137,90,102,66,33,17,2,17,33,25,225,41,
162,50,5,59,100,42,65,25,225,32,99,65,164,73,131,57,
131,49,225,32,193,24,194,24,161,16,161,16,161,16,161,16,
34,25,196,41,69,50,101,50,133,50,68,42,165,58,230,66,
197,58,100,42,35,42,3,42,130,25,195,33,4,42,227,33,
69,50,166,58,167,58,198,58,100,50,165,58,6,67,197,58,
229,66,228,58,66,34,66,25,2,25,34,25,228,41,67,17,
164,41,134,66,3,42,67,50,100,50,166,58,165,50,100,42,
135,50,73,83,41,108,38,75,4,34,68,50,99,42,36,34,
36,34,69,50,4,42,196,41,38,58,135,66,200,74,9,83,
232,74,135,66,102,66,102,66,199,74,232,82,73,91,138,99,
139,99,200,74,69,50,70,58,37,50,5,50,228,41,228,41,
229,49,5,50,102,58,135,66,167,74,200,74,200,74,135,66,
134,66,167,74,9,83,232,82,200,74,233,82,233,82,103,66,
167,74,102,66,6,58,136,74,173,99,11,83,133,33,194,8,
163,16,227,16,161,8,193,8,2,25,131,41,200,74,12,108,
77,116,202,99,10,100,169,91,4,42,34,25,129,8,65,8,
128,8,132,33,35,25,194,8,97,8,227,24,227,16,101,25,
209,17,151,58,236,33,166,25,135,33,3,17,227,16,195,16,
226,16,132,33,197,33,164,33,67,25,164,41,6,50,168,66,
70,50,168,66,201,74,103,58,103,58,135,66,103,66,167,74,
200,74,135,66,168,66,233,82,9,83,233,82,168,74,233,82,
232,74,232,74,73,91,139,99,233,74,5,42,132,33,133,41,
232,49,230,41,5,42,6,42,71,50,39,42,134,58,11,108,
201,66,104,58,40,50,171,66,73,50,230,33,200,33,12,42,
236,41,170,33,10,42,39,42,102,50,199,66,101,50,39,50,
232,66,201,66,71,50,39,50,103,58,167,66,135,58,103,58,
135,66,167,66,41,83,41,83,102,58,200,66,139,91,41,83,
5,50,103,58,169,74,202,74,169,66,104,58,103,58,135,58,
7,50,102,58,42,83,43,83,137,50,240,66,19,75,173,58,
239,66,236,74,75,83,11,75,46,67,144,67,109,67,167,42,
163,25,70,50,75,83,170,50,201,42,175,42,171,42,107,42,
211,50,18,59,16,51,190,75,31,76,30,68,255,75,222,75,
254,75,254,75,255,75,254,75,29,76,29,76,254,75,254,75,
255,75,223,75,222,75,254,75,254,75,254,75,254,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
30,76,30,76,30,76,254,75,254,75,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,254,83,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
164,33,164,33,196,41,228,41,37,50,134,50,133,50,166,50,
103,67,230,66,165,50,2,42,160,25,99,42,165,50,234,83,
166,50,70,66,70,82,198,82,71,91,42,124,105,115,167,90,
7,75,195,41,33,25,225,16,192,8,0,17,35,50,169,99,
77,116,199,74,106,115,170,131,165,82,230,90,39,91,131,34,
7,50,106,82,203,98,168,74,66,17,225,8,227,41,229,74,
197,75,231,83,102,67,230,66,166,74,37,74,162,57,227,57,
36,74,70,74,99,41,194,24,227,24,129,8,96,8,128,16,
193,16,34,25,195,33,166,58,7,67,133,50,68,42,100,50,
68,42,68,42,3,34,162,33,33,17,130,25,36,50,36,42,
134,58,199,66,166,58,199,66,198,58,165,58,229,58,38,67,
6,75,37,59,163,42,33,17,226,16,131,33,228,33,225,8,
67,25,163,33,32,17,96,17,162,25,133,50,72,75,10,100,
199,58,198,66,8,100,231,83,165,50,164,58,36,67,5,51,
165,50,133,50,69,50,70,58,232,82,74,91,41,83,9,83,
106,91,73,91,74,91,232,82,200,74,232,82,41,91,73,91,
171,99,8,75,102,58,70,50,4,42,37,50,38,50,37,50,
38,58,5,50,37,58,135,66,167,74,167,74,135,66,134,66,
69,58,102,66,200,74,167,74,135,66,41,83,106,91,200,74,
36,50,134,74,135,74,136,74,172,107,107,91,71,58,35,25,
162,16,194,16,162,8,35,25,100,41,70,66,171,107,235,107,
203,99,137,83,136,83,104,83,228,41,132,33,97,8,97,8,
66,33,74,91,164,33,193,8,194,16,101,33,68,33,195,8,
18,34,214,66,235,33,68,17,228,8,227,16,2,25,2,25,
194,16,35,25,35,17,165,33,132,33,133,41,71,58,103,58,
229,41,70,50,233,74,135,58,70,50,103,58,38,50,38,58,
135,66,103,58,168,74,135,66,168,74,233,82,167,74,167,74,
41,75,199,66,232,74,41,83,200,66,230,41,165,41,231,57,
137,66,164,33,196,33,132,25,133,25,165,33,37,50,168,99,
200,66,38,50,229,41,104,50,71,50,132,17,103,17,47,50,
110,50,12,34,14,50,105,33,233,49,73,58,167,58,200,66,
41,75,42,75,169,66,39,50,228,41,102,58,200,66,233,74,
199,66,167,66,9,75,9,75,103,58,168,66,74,91,10,83,
135,66,168,66,201,74,201,74,201,74,136,66,71,50,70,50,
7,50,168,66,41,83,42,75,200,58,44,67,45,75,204,66,
170,58,169,58,235,74,204,66,15,67,144,75,140,75,71,67,
102,50,6,42,201,66,172,50,170,42,176,50,169,50,199,58,
238,50,16,59,205,42,155,75,31,76,254,67,31,76,222,75,
254,75,255,75,254,75,29,76,29,76,29,76,253,75,254,75,
255,75,255,75,254,75,254,75,254,75,254,75,255,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
222,75,254,75,254,75,254,75,254,75,30,76,30,76,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
30,76,30,76,30,76,254,75,254,75,30,76,30,76,30,76,
30,84,254,75,254,75,254,75,254,75,254,75,30,84,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,84,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,84,31,84,30,84,30,76,30,76,30,76,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
73,75,232,66,36,34,195,33,36,42,68,50,101,50,133,50,
6,50,41,91,72,75,100,50,100,50,3,34,66,33,34,17,
227,41,195,49,36,66,165,66,226,49,101,90,200,106,42,115,
105,91,227,41,195,41,98,33,131,33,36,50,194,33,226,33,
105,83,170,91,171,115,235,123,170,99,8,91,69,74,3,34,
36,25,77,107,236,90,201,74,225,8,161,0,37,50,164,58,
35,67,68,67,69,67,135,75,136,83,39,83,99,58,132,58,
231,98,167,82,70,74,226,24,162,16,3,25,67,33,193,24,
194,24,34,25,131,33,133,50,198,58,68,42,226,33,3,34,
101,50,69,42,163,33,131,33,131,33,131,33,228,41,227,41,
4,42,69,50,4,42,134,58,231,66,230,66,230,58,5,59,
164,58,69,67,36,59,129,25,225,16,196,33,228,33,193,8,
67,25,34,25,0,17,130,25,228,33,199,58,40,75,76,108,
43,100,39,83,41,108,170,116,103,75,4,67,132,75,167,67,
7,67,198,58,133,58,135,66,232,82,9,83,8,83,8,75,
232,74,232,74,73,91,232,82,135,66,135,66,200,74,9,83,
232,74,102,58,70,50,167,66,102,58,37,50,5,50,38,50,
167,66,102,66,102,58,135,66,167,74,135,66,70,58,37,50,
69,58,5,50,69,58,134,66,167,74,41,91,41,91,102,66,
227,41,199,74,74,99,42,99,205,107,140,99,233,74,38,58,
225,16,2,17,67,25,3,25,68,41,201,90,235,107,105,91,
170,83,72,75,40,75,199,66,99,25,68,33,129,8,227,24,
196,41,9,83,66,17,225,8,161,8,194,16,68,25,166,41,
205,58,200,33,4,9,66,17,226,16,5,25,36,25,34,25,
3,25,226,16,68,25,133,33,68,33,197,49,39,50,103,58,
196,41,38,50,135,58,229,33,164,33,5,42,5,50,71,58,
136,66,136,66,201,74,103,66,135,66,9,83,167,66,102,58,
8,75,102,58,102,58,167,66,168,66,103,58,7,58,8,66,
10,75,228,41,227,33,131,25,133,25,72,58,167,66,136,91,
166,58,195,33,100,25,103,25,199,33,133,25,136,25,143,58,
176,50,140,50,18,83,77,58,170,74,203,74,10,75,168,66,
232,66,233,74,168,66,103,58,38,50,134,58,167,66,233,74,
199,66,102,58,232,74,9,75,135,66,135,66,168,66,201,74,
200,74,232,74,200,66,136,66,168,66,168,66,103,58,70,50,
102,58,70,58,71,58,201,66,235,66,10,67,201,58,105,50,
137,58,71,50,200,66,201,66,236,66,77,75,108,75,41,75,
41,75,229,33,197,25,44,34,76,34,211,58,135,42,131,50,
11,59,14,59,201,42,151,67,31,84,254,75,31,76,190,75,
254,75,30,84,30,76,252,75,251,75,251,75,220,75,254,75,
255,75,254,75,254,75,254,75,254,75,254,75,255,75,255,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,254,75,254,75,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,254,75,254,75,30,76,30,76,30,76,
30,84,30,84,30,84,254,75,254,75,254,75,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,84,31,84,31,84,30,76,30,76,30,76,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
230,58,197,50,226,25,35,34,3,34,37,42,4,42,102,50,
71,66,145,173,114,166,229,58,36,42,227,33,160,16,193,24,
161,41,166,66,68,58,100,50,165,66,166,98,102,82,42,115,
106,99,130,33,130,33,163,41,162,33,36,50,3,34,101,50,
37,58,228,41,102,66,167,66,166,58,41,99,233,114,228,65,
67,17,72,66,105,74,43,83,197,33,194,8,160,0,34,34,
68,67,68,67,102,75,135,75,70,67,168,83,5,59,131,50,
72,99,134,74,70,66,229,57,2,25,104,74,100,41,226,32,
226,32,67,33,131,33,36,42,100,42,35,42,227,33,4,42,
162,25,227,33,195,33,163,33,195,41,195,33,68,50,133,58,
3,42,4,42,228,41,37,42,69,42,133,50,165,50,132,50,
100,50,101,67,230,75,2,42,1,17,164,33,163,33,2,17,
164,33,69,50,133,58,101,50,8,67,77,116,235,99,170,99,
14,133,140,124,203,132,232,91,229,58,69,75,133,75,70,59,
101,50,36,42,228,41,69,58,200,74,232,82,8,75,40,83,
232,74,167,74,41,91,9,83,167,74,70,58,135,66,9,83,
41,83,167,66,70,50,103,58,37,50,37,50,38,58,103,66,
102,58,167,66,167,74,135,66,134,66,135,66,135,66,167,66,
69,58,37,50,70,58,167,66,200,74,41,83,41,91,200,74,
101,58,70,58,168,82,233,90,139,99,106,91,200,74,167,66,
6,50,196,41,6,50,100,33,132,41,201,82,41,83,105,91,
137,83,7,67,39,75,4,42,226,16,162,8,194,16,3,25,
37,58,196,41,98,17,196,33,34,25,226,16,35,25,72,58,
200,33,68,17,6,25,36,25,4,25,39,33,37,25,35,17,
3,25,35,25,100,25,68,25,3,25,197,49,103,58,135,58,
197,41,71,58,5,42,66,17,164,33,38,50,38,50,136,66,
136,66,70,58,135,66,70,50,70,58,70,58,229,49,196,41,
103,50,38,50,5,50,228,41,38,50,103,58,72,58,105,74,
9,75,102,50,4,42,131,25,198,41,169,66,233,74,137,91,
168,66,229,41,134,33,38,17,102,25,166,33,168,33,45,50,
78,50,105,42,171,66,201,66,9,100,202,99,202,74,39,50,
167,66,168,66,6,50,38,50,167,66,199,66,134,58,200,66,
167,66,37,50,232,74,41,83,168,66,70,50,6,50,104,58,
135,66,200,74,200,74,168,66,168,66,135,58,38,50,229,41,
100,50,38,50,6,50,235,74,47,75,204,58,72,42,140,58,
136,58,135,58,41,75,232,66,71,50,137,50,10,75,201,66,
73,75,71,42,100,17,11,34,109,34,211,58,6,26,193,25,
4,26,172,58,8,51,148,75,30,84,254,67,30,76,223,75,
30,76,62,84,28,76,250,75,248,75,216,75,217,75,251,83,
253,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,76,30,76,30,76,30,76,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,76,30,76,254,75,254,75,254,75,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
40,67,227,25,101,42,8,59,137,75,134,50,36,42,102,50,
171,115,45,149,46,150,37,59,226,33,68,50,1,33,128,8,
162,25,40,67,227,49,129,25,164,66,6,91,100,58,229,65,
196,49,66,33,195,49,3,50,3,50,166,58,231,66,73,75,
39,67,198,58,228,57,228,65,4,58,70,74,41,107,198,66,
162,25,34,25,67,33,66,25,2,17,36,25,225,8,99,42,
103,67,102,67,167,75,232,83,69,59,70,67,229,66,132,58,
165,74,231,82,70,66,70,66,164,49,136,74,193,24,2,33,
162,32,2,33,66,25,227,33,35,42,227,33,97,25,33,17,
35,42,230,66,231,74,36,50,3,42,67,50,229,74,38,83,
36,42,97,25,33,9,130,25,65,17,33,9,129,25,100,50,
229,66,133,67,6,84,131,50,131,33,228,41,163,33,163,41,
198,66,137,91,104,83,165,50,133,50,105,83,198,66,100,58,
165,58,105,91,75,116,229,66,101,50,103,83,70,75,100,42,
228,33,196,33,99,33,196,41,167,74,232,82,231,74,7,75,
199,74,167,74,232,82,167,74,167,74,233,82,232,82,168,74,
232,74,168,66,37,50,229,49,228,41,38,58,70,58,70,58,
229,49,38,58,103,66,135,66,168,74,200,74,168,74,168,66,
135,66,168,66,200,74,167,74,135,66,102,66,103,66,167,74,
9,75,229,49,230,57,169,82,139,99,139,99,135,66,134,58,
135,66,196,41,5,42,229,49,70,66,135,74,102,58,40,75,
235,91,40,75,40,75,5,50,194,16,97,8,162,16,226,24,
66,25,131,33,228,33,167,58,229,41,164,41,197,41,34,25,
72,25,78,58,110,66,103,33,4,17,228,16,3,17,3,17,
3,25,165,41,100,25,100,33,100,33,6,50,168,66,167,58,
7,50,71,58,229,41,196,33,70,50,103,58,71,58,71,66,
9,83,135,66,135,58,38,50,5,42,196,41,196,41,229,41,
6,42,39,50,6,50,164,33,70,50,168,66,39,58,230,57,
102,58,37,50,196,33,132,33,6,50,136,58,200,66,8,75,
202,66,169,66,168,66,7,42,230,41,39,50,105,66,75,66,
201,66,106,83,171,83,73,75,136,83,230,66,39,50,201,74,
8,75,167,66,197,41,197,41,102,66,167,66,102,58,232,74,
200,66,167,58,232,74,9,75,168,66,38,50,6,42,71,50,
135,66,200,66,232,74,232,74,233,74,103,58,196,33,132,25,
36,42,103,58,104,58,234,66,171,58,9,34,200,33,74,58,
101,50,8,75,73,75,103,50,6,42,168,66,74,83,231,66,
106,75,42,75,199,33,199,25,9,34,44,34,197,25,98,17,
132,25,16,75,139,75,146,67,254,83,254,75,29,76,31,84,
29,76,61,84,26,76,23,76,22,76,244,75,213,75,214,75,
252,75,253,75,254,75,255,75,255,75,255,75,254,75,253,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,30,76,30,76,30,76,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,254,75,254,75,254,75,254,75,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,254,75,254,75,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
202,74,230,33,200,58,138,75,137,67,169,75,7,67,39,75,
13,116,199,99,132,67,196,50,163,33,66,17,229,49,136,66,
199,50,101,34,131,41,4,58,100,58,229,66,229,50,65,33,
2,33,225,24,130,41,3,50,2,42,100,50,73,75,45,100,
136,75,197,58,133,66,68,58,68,50,36,50,133,66,6,59,
164,50,36,50,131,33,1,17,1,17,35,25,99,33,34,34,
136,59,102,51,37,51,231,75,228,50,66,42,100,50,198,74,
101,58,167,74,8,83,163,41,225,16,34,33,38,66,132,49,
3,41,100,49,130,33,195,33,129,25,97,17,195,33,135,66,
38,75,132,50,164,58,38,75,168,99,70,83,37,75,69,83,
137,91,166,66,228,41,196,33,196,33,195,33,195,33,198,66,
6,67,226,50,66,51,66,42,195,41,102,58,37,50,134,66,
132,58,66,42,1,34,196,50,198,50,133,50,3,42,197,66,
166,58,232,82,235,107,166,58,228,41,133,66,132,58,70,42,
6,50,70,58,197,41,197,49,168,74,8,83,231,74,72,83,
232,74,134,66,167,74,102,66,167,74,200,74,233,82,9,83,
9,83,200,74,5,50,164,41,196,41,70,58,70,58,38,58,
135,66,70,58,38,58,103,58,135,66,71,58,6,50,38,50,
38,50,168,66,200,74,167,66,103,66,70,58,70,58,167,74,
168,66,99,33,165,49,201,90,139,107,171,99,101,58,36,42,
103,58,164,33,66,25,37,58,200,82,167,74,200,74,41,75,
105,83,231,66,231,74,168,74,3,25,195,16,162,16,162,16,
2,25,99,25,200,58,232,66,196,41,132,33,67,33,34,25,
7,34,237,41,168,33,2,9,227,16,1,17,66,25,2,17,
226,16,35,25,100,25,99,33,229,49,168,74,70,50,168,58,
104,58,6,50,38,50,168,66,167,58,38,50,38,50,38,58,
167,66,70,58,102,58,37,50,229,41,164,33,197,41,229,41,
230,41,39,58,230,49,67,25,38,42,200,66,71,58,6,58,
38,50,38,50,230,41,71,58,168,66,199,66,199,66,167,58,
166,58,7,75,41,75,71,50,165,33,228,49,198,74,165,66,
166,58,9,75,136,83,72,67,7,67,39,75,202,74,11,83,
73,83,200,66,6,50,229,49,37,50,102,58,134,58,232,74,
167,66,167,66,70,50,70,50,135,58,70,50,38,50,103,58,
70,50,167,66,232,74,232,74,134,58,164,33,132,25,5,42,
169,66,200,66,234,74,234,74,5,34,8,34,139,58,103,58,
167,58,41,75,232,66,103,50,103,58,70,50,199,66,72,83,
8,67,75,83,232,41,164,25,5,34,230,25,38,42,72,50,
109,83,217,140,176,116,179,75,31,92,63,84,252,67,255,75,
29,76,61,84,58,84,54,84,116,84,50,84,209,75,178,75,
219,67,252,75,30,84,255,83,255,75,255,75,30,76,29,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,30,84,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
30,84,30,84,30,84,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,254,75,254,75,254,75,254,75,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,84,30,84,30,76,30,76,30,76,
30,76,30,76,30,84,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
31,84,30,84,254,75,254,75,30,84,31,84,31,84,31,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,254,75,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
132,33,197,33,73,75,40,67,230,58,165,42,165,50,40,67,
203,99,202,75,2,26,36,42,69,58,33,25,170,91,108,84,
69,67,165,58,35,50,7,106,40,123,39,59,164,42,65,17,
195,16,67,33,33,25,195,41,229,49,168,66,106,83,234,91,
235,91,7,59,72,75,169,91,166,58,198,66,105,83,68,50,
70,58,200,74,199,74,166,58,194,33,130,17,3,34,4,34,
164,42,99,34,229,50,100,42,3,50,65,41,97,49,36,74,
37,58,102,66,164,41,161,8,64,16,226,32,38,74,131,49,
2,33,2,33,65,33,64,25,227,41,198,66,165,58,227,33,
162,33,100,58,230,66,103,83,167,83,133,75,198,83,40,92,
102,75,103,75,230,66,101,50,69,50,163,33,194,33,3,42,
132,50,131,42,195,50,65,34,161,25,228,41,67,33,68,33,
66,25,224,16,66,25,66,25,228,41,5,42,5,42,41,75,
73,91,106,91,203,99,138,91,166,58,68,50,36,42,68,58,
231,74,101,58,167,66,232,74,199,66,232,74,231,74,199,74,
167,66,134,66,102,58,37,50,38,58,168,74,41,91,138,99,
138,99,105,91,134,58,196,33,5,50,103,66,71,58,71,58,
103,66,38,58,229,49,38,58,70,58,5,50,70,58,135,66,
135,66,135,66,70,58,70,58,135,66,168,74,167,66,102,58,
70,58,134,66,232,82,233,82,140,91,73,83,198,66,37,50,
102,58,70,58,67,33,228,49,8,83,39,83,72,83,72,83,
135,91,165,66,198,66,167,66,197,41,2,17,162,8,161,8,
226,8,35,17,168,58,200,66,102,50,131,25,164,25,132,25,
68,33,4,25,162,8,227,16,99,33,99,33,100,25,227,16,
99,24,195,24,196,33,4,42,104,58,71,58,135,58,103,50,
229,41,5,50,103,58,135,58,70,58,102,50,135,58,5,42,
38,50,5,50,70,50,131,25,164,33,197,41,68,25,100,33,
103,66,200,74,99,33,99,25,103,58,42,83,39,58,230,49,
38,42,167,58,38,42,168,58,200,66,168,58,38,42,70,50,
102,50,70,50,233,66,5,42,164,33,103,58,167,66,102,58,
133,58,7,75,199,66,166,66,8,75,232,74,8,75,73,83,
199,66,200,74,168,66,102,58,8,75,7,75,8,75,199,66,
38,50,135,58,38,50,38,50,229,41,229,33,38,50,70,50,
103,58,167,66,200,74,9,75,70,58,100,25,198,41,72,58,
135,74,167,66,139,83,168,58,198,33,7,50,103,58,199,66,
9,67,9,75,200,66,8,75,231,66,101,50,166,58,231,66,
199,74,168,66,10,75,100,25,67,17,197,25,5,34,73,75,
143,83,249,75,111,67,45,75,188,75,255,75,220,83,31,76,
27,76,221,75,27,84,87,92,83,92,179,108,178,108,208,83,
111,59,29,84,31,76,254,75,31,76,254,75,255,75,253,67,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
31,76,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,254,75,30,76,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
254,75,254,75,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
254,75,254,75,254,75,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,254,75,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,30,84,30,84,30,84,30,84,30,84,30,84,29,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
35,25,131,33,228,33,227,25,231,58,230,58,100,42,100,42,
106,91,108,92,71,59,169,75,136,67,3,34,8,75,8,51,
201,83,104,91,68,74,137,130,15,181,108,100,97,9,96,8,
162,16,67,33,33,25,131,33,6,50,201,66,74,75,137,75,
234,99,202,91,138,83,106,83,105,83,72,83,135,91,134,91,
196,74,5,83,5,83,70,83,39,83,35,42,4,42,228,33,
67,34,99,42,197,58,101,50,164,49,194,32,34,41,65,41,
66,33,197,49,229,49,35,33,161,24,2,41,164,57,66,41,
100,49,34,33,163,41,4,50,101,58,227,33,194,33,35,42,
198,66,7,75,6,67,6,67,5,67,196,58,37,67,135,83,
102,75,5,59,229,58,230,66,198,58,36,42,67,50,132,50,
38,75,4,67,166,83,7,92,37,67,227,33,193,8,100,33,
196,41,164,41,70,58,66,25,196,41,8,75,134,58,166,58,
231,74,170,99,11,108,235,99,231,74,4,42,195,33,4,50,
134,58,101,58,102,58,102,58,70,58,102,66,134,66,134,66,
167,74,102,66,70,58,70,58,70,58,37,58,135,66,138,99,
73,91,232,74,228,41,131,33,5,50,135,66,136,66,104,66,
38,58,5,50,5,50,102,66,70,58,196,41,229,49,70,58,
200,74,200,74,135,66,168,74,168,74,70,58,5,50,196,33,
197,41,228,49,168,82,108,99,112,124,232,74,102,50,103,58,
199,74,167,66,132,33,228,49,40,91,137,99,169,91,137,91,
230,74,133,58,231,74,9,75,6,50,35,25,193,8,194,16,
3,17,165,33,164,33,131,33,164,33,99,25,229,41,165,33,
35,25,162,8,4,25,36,25,197,41,99,33,165,41,3,25,
66,33,198,41,230,33,164,25,229,41,197,41,165,33,166,33,
5,50,229,41,70,58,71,58,70,50,103,58,233,74,135,58,
196,41,168,66,172,91,5,42,99,25,197,41,67,25,67,33,
200,82,103,66,131,33,131,25,229,41,164,33,226,16,67,33,
196,33,74,83,41,75,233,74,42,75,135,58,229,33,70,50,
135,58,102,50,107,83,232,66,5,42,38,50,135,58,200,74,
166,58,199,66,199,74,8,75,8,75,167,66,102,58,102,58,
8,75,200,66,103,58,102,58,40,83,105,91,105,91,9,75,
5,42,37,50,38,50,135,66,5,50,5,42,103,50,103,50,
38,50,135,58,200,74,200,74,102,58,5,42,38,50,136,66,
167,74,200,66,233,58,71,42,230,33,198,41,38,50,167,58,
70,42,70,50,135,58,200,66,8,75,8,75,40,75,8,75,
199,66,201,74,43,83,133,33,68,17,198,33,99,17,131,17,
73,42,220,75,18,59,229,33,20,51,62,84,31,84,31,68,
255,75,219,67,120,67,117,67,209,83,18,92,83,108,210,116,
175,75,184,75,30,84,31,76,254,75,30,76,31,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,30,76,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,254,75,30,76,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
254,75,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,84,30,84,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,254,75,30,84,30,84,
254,75,254,75,254,75,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
196,41,99,25,164,25,163,17,69,34,68,42,68,42,133,50,
199,66,76,92,169,75,137,75,136,59,198,42,231,66,101,42,
199,66,136,91,104,107,230,97,201,139,11,100,161,0,130,24,
34,25,228,49,4,50,231,74,172,99,79,108,171,83,198,50,
134,58,199,66,73,83,137,91,201,99,232,99,232,99,72,108,
104,124,72,124,40,116,8,108,106,124,70,91,132,66,128,33,
227,33,195,33,130,25,228,49,5,66,67,49,230,65,133,41,
161,16,161,16,193,16,226,24,99,49,197,65,67,49,33,33,
35,49,226,32,5,50,227,41,129,25,226,33,72,75,169,91,
39,75,198,66,100,50,164,58,6,67,230,66,197,58,165,58,
229,58,132,50,164,50,165,58,165,58,133,50,165,58,3,34,
100,50,98,50,36,67,165,83,101,75,67,42,0,9,66,25,
164,41,34,25,34,25,66,25,134,58,170,91,72,75,36,34,
38,75,10,100,10,100,76,108,203,99,167,66,164,41,67,25,
4,42,4,42,228,41,229,41,38,50,38,58,102,58,134,66,
102,58,135,66,135,66,102,58,70,58,229,49,228,41,135,66,
74,91,200,74,37,50,70,50,135,66,135,66,135,66,70,58,
70,58,38,58,70,58,168,74,135,66,38,58,5,50,37,50,
167,66,233,82,9,83,9,83,135,66,229,49,70,50,102,58,
3,17,2,25,72,66,77,99,81,124,103,58,70,50,7,58,
69,50,135,66,71,58,167,74,105,99,72,91,40,83,8,75,
166,74,101,58,167,66,233,74,38,50,35,17,193,8,35,25,
35,25,133,41,3,25,2,17,35,25,2,17,100,25,35,25,
194,8,3,17,231,49,137,66,230,49,100,33,68,33,3,25,
99,17,235,41,236,33,166,25,131,25,163,33,163,33,197,41,
229,49,197,41,6,50,6,50,229,49,71,58,201,74,103,58,
5,50,135,58,106,83,38,50,99,25,132,33,164,41,38,58,
229,49,229,49,229,41,99,25,197,33,229,41,132,33,132,33,
5,42,232,74,232,66,135,58,102,50,163,25,196,33,135,58,
167,58,200,66,107,83,233,66,37,42,5,42,102,50,134,58,
166,58,167,66,231,74,199,74,102,58,37,50,134,66,167,66,
232,74,232,74,168,66,135,58,167,66,72,83,73,83,9,75,
135,58,38,50,38,50,135,66,6,50,70,50,168,66,103,50,
229,41,70,50,200,74,200,74,200,74,167,66,38,50,103,58,
231,74,41,75,234,66,136,50,38,42,196,33,38,50,104,58,
135,50,38,42,5,42,70,50,167,66,73,83,73,83,8,75,
167,66,167,66,233,74,39,50,198,33,230,33,132,25,132,25,
109,42,221,75,85,67,229,25,243,42,219,67,190,75,61,68,
191,67,188,75,86,59,177,42,142,42,204,58,109,75,16,100,
15,92,114,67,252,83,31,84,221,75,30,76,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,254,75,30,76,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
30,76,30,76,30,76,30,76,30,76,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,254,75,254,75,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,29,84,29,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,253,83,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,29,84,62,84,62,84,62,84,62,84,29,84,29,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
236,107,228,33,4,34,37,34,134,42,166,50,35,34,133,50,
101,42,133,50,69,58,232,82,11,100,8,67,102,58,69,42,
163,49,107,116,173,124,200,98,166,98,229,57,163,8,129,16,
132,41,228,49,195,41,37,50,10,75,48,108,14,92,41,59,
102,58,231,74,233,99,41,108,7,100,105,108,106,116,106,116,
73,116,73,116,137,124,72,116,202,132,234,140,201,132,164,99,
99,50,130,33,2,17,3,33,160,24,33,41,135,74,3,25,
97,16,97,8,64,0,193,24,132,49,196,65,192,24,1,25,
35,49,2,33,99,33,66,17,36,42,166,58,166,58,35,42,
133,50,165,58,197,58,229,66,229,66,197,58,164,58,165,58,
133,58,101,50,133,58,132,50,132,58,198,66,166,66,162,25,
130,33,194,33,98,50,129,42,162,50,163,50,161,25,0,9,
98,33,33,25,163,41,232,74,199,66,36,42,231,58,170,83,
10,100,107,108,202,91,170,91,41,75,135,66,38,58,6,58,
163,33,99,25,66,25,164,33,38,50,38,58,135,66,103,66,
5,50,70,58,70,58,5,50,5,50,37,50,228,41,4,50,
38,50,70,58,103,58,168,66,135,66,70,58,135,66,135,66,
103,66,135,66,135,66,135,66,102,58,135,66,103,66,103,66,
102,58,167,66,135,66,103,66,38,58,5,50,37,50,196,33,
194,8,193,8,198,49,45,99,48,124,71,50,70,58,136,66,
69,50,103,66,103,66,103,66,134,66,68,58,133,58,166,58,
200,74,37,50,5,42,135,66,103,58,132,33,226,16,35,25,
36,25,226,16,161,8,226,16,3,25,35,25,3,17,194,16,
161,8,3,17,101,33,231,49,35,25,67,25,35,25,68,25,
41,42,49,50,181,66,142,58,133,17,132,25,67,25,100,25,
229,49,6,50,38,58,229,49,197,41,197,41,230,49,164,41,
5,50,229,41,38,50,102,58,5,42,131,33,38,50,136,66,
168,74,103,58,71,58,229,41,71,50,135,58,38,50,71,50,
37,42,37,42,37,42,228,41,5,42,131,25,228,33,5,42,
37,42,135,58,9,67,41,75,168,58,135,50,232,66,134,58,
167,66,167,58,167,66,199,66,232,74,41,83,41,83,199,66,
167,66,41,83,9,75,167,66,37,50,8,75,232,74,135,66,
200,66,69,50,5,42,38,50,5,42,136,66,201,66,70,50,
135,66,70,58,103,58,135,66,200,74,135,66,164,33,70,58,
198,66,233,66,202,66,169,58,37,42,228,33,102,58,6,50,
168,58,6,42,164,33,6,42,135,58,9,75,232,66,102,50,
134,66,134,66,231,74,233,74,6,42,99,17,132,25,165,25,
146,42,90,51,84,67,41,34,182,50,122,59,155,67,219,59,
221,75,155,67,245,50,112,42,76,34,104,50,9,67,46,75,
46,100,143,75,219,75,255,75,222,75,31,84,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,29,84,29,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,62,84,62,84,62,84,62,84,62,84,62,84,29,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
138,83,167,50,41,67,106,67,203,83,231,58,97,9,227,33,
68,34,166,50,134,66,13,124,113,141,231,58,69,50,195,33,
36,58,102,75,229,58,4,58,101,74,33,25,194,0,193,16,
227,16,2,17,2,17,165,33,203,66,114,116,242,124,46,92,
43,108,108,116,106,108,199,91,198,83,8,100,200,91,168,83,
135,83,200,91,200,91,199,91,198,91,136,116,232,132,231,132,
233,132,7,108,67,58,33,33,226,40,35,41,99,41,160,0,
65,8,129,16,128,8,226,24,67,41,132,49,34,33,66,25,
100,49,193,24,34,25,228,33,231,66,101,50,227,33,3,42,
68,42,165,58,38,67,70,75,70,75,37,75,5,75,5,75,
165,66,100,58,100,58,67,58,100,58,132,66,198,74,132,66,
2,25,33,25,226,33,98,50,195,50,37,67,229,66,100,50,
162,41,3,50,40,83,138,91,231,66,199,58,199,50,9,59,
105,75,235,91,11,100,44,100,138,91,8,75,167,66,102,66,
229,49,67,25,34,25,164,33,6,50,229,41,70,50,5,50,
5,50,196,41,229,41,6,50,6,50,5,50,196,41,196,41,
196,41,229,41,38,50,135,66,102,58,70,58,167,66,167,66,
70,58,200,74,9,83,200,74,103,66,167,66,135,66,167,66,
135,58,102,58,5,50,228,49,229,49,229,49,196,41,34,17,
225,8,196,41,39,58,109,99,15,116,135,58,37,50,135,66,
5,50,5,50,38,58,5,50,102,58,166,66,232,74,167,66,
70,58,70,58,70,58,200,66,103,58,164,33,2,17,67,25,
133,33,3,25,227,16,194,16,162,8,3,25,194,16,194,16,
128,8,227,24,36,25,228,16,35,17,100,25,165,33,198,33,
166,58,233,41,107,58,169,50,134,17,200,33,132,25,228,33,
136,66,168,66,104,66,71,58,39,58,100,33,67,25,100,33,
6,50,5,50,37,50,103,58,102,58,37,50,135,66,70,58,
71,50,6,50,196,33,197,41,229,41,38,50,132,25,5,42,
70,50,167,66,9,75,167,58,200,66,70,50,103,50,70,50,
38,50,232,66,233,66,106,75,200,58,70,42,232,66,134,58,
69,50,200,66,41,83,9,75,167,66,102,58,102,58,167,66,
8,75,74,83,9,83,200,66,70,58,41,83,168,66,6,50,
41,75,102,50,37,42,103,58,135,66,9,75,233,74,167,58,
233,74,103,58,70,58,70,58,168,66,70,58,163,33,70,58,
232,74,136,66,72,58,105,58,71,50,71,50,135,58,38,58,
136,58,6,42,132,25,6,42,103,58,233,74,232,66,37,42,
134,58,39,75,39,83,73,83,37,42,98,17,70,42,137,58,
89,67,57,51,83,59,141,50,182,58,247,50,26,59,91,59,
223,75,251,75,184,75,151,83,207,58,199,25,42,50,172,66,
205,99,207,83,219,83,255,75,30,76,31,84,30,76,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,29,84,62,84,62,84,62,84,62,84,29,84,29,84,
62,84,62,84,62,84,62,84,62,84,29,84,29,84,29,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,29,84,29,84,29,84,
4,34,69,42,134,42,134,42,199,50,102,42,163,25,130,25,
36,42,3,26,199,58,105,75,173,92,137,67,36,42,37,50,
104,75,224,25,64,33,160,41,101,58,197,50,163,17,128,16,
225,16,65,25,36,50,232,74,172,99,208,124,48,133,140,108,
137,108,106,108,233,91,104,75,169,83,43,108,9,100,167,83,
167,83,199,91,134,75,134,83,69,75,231,99,165,91,38,108,
38,108,40,141,104,149,229,107,226,57,226,32,227,24,193,8,
129,16,97,8,129,8,161,16,193,24,164,49,38,58,228,33,
67,33,193,16,99,33,5,42,196,33,65,17,194,33,198,66,
40,75,104,75,136,83,38,75,228,66,228,66,5,75,70,75,
135,91,102,91,70,83,5,83,228,74,163,74,196,74,163,74,
70,58,196,41,4,42,67,42,98,42,163,50,196,58,132,50,
226,41,197,66,7,75,100,50,4,34,8,67,106,75,232,58,
41,75,203,91,44,108,142,116,109,116,44,108,138,91,8,83,
38,58,99,33,99,33,164,41,229,49,196,41,37,50,5,50,
5,50,164,33,229,41,38,50,229,49,196,41,164,33,196,41,
197,41,196,41,5,50,70,58,70,58,103,66,103,66,70,58,
70,58,167,66,233,82,233,82,167,66,200,74,103,66,167,66,
167,66,168,66,168,74,135,66,70,58,38,58,229,49,5,50,
200,66,74,91,75,91,239,115,76,91,70,50,134,58,70,58,
37,50,38,58,230,49,67,25,196,41,167,74,41,83,200,66,
38,58,200,74,233,74,41,75,70,50,164,33,67,25,99,25,
67,25,35,17,227,16,194,16,226,16,194,16,194,16,226,16,
193,8,132,33,101,33,101,33,133,25,6,42,165,33,230,33,
198,41,36,25,132,25,6,42,236,33,81,50,170,33,103,50,
233,74,168,66,136,66,136,66,71,58,2,25,2,17,197,41,
71,58,6,50,70,50,5,42,70,50,200,66,135,66,229,41,
67,17,197,41,132,33,100,25,67,25,70,50,5,42,103,50,
70,50,196,33,5,42,38,42,103,50,102,50,103,58,196,33,
38,50,232,66,168,58,200,66,102,50,70,42,232,66,134,58,
167,66,167,66,167,66,135,66,102,58,4,42,5,50,232,74,
106,91,41,83,201,74,168,66,102,58,232,74,135,66,71,58,
138,83,167,58,70,50,167,66,168,66,168,66,103,58,135,58,
9,75,9,75,168,66,103,58,135,58,70,50,5,42,103,58,
234,82,168,74,104,58,138,58,141,58,109,50,41,42,71,50,
201,58,168,58,229,33,38,50,70,50,9,75,41,75,134,58,
37,50,6,75,71,83,106,83,134,58,129,17,36,34,40,42,
56,59,25,51,83,59,141,50,79,42,116,34,59,59,191,75,
223,75,220,75,214,50,180,50,179,58,14,42,12,42,75,42,
42,75,210,91,252,83,255,75,31,76,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,254,75,30,76,30,76,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,254,75,30,76,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,84,30,84,30,84,30,84,30,76,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
30,84,30,76,30,76,30,76,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,62,84,62,84,62,84,62,84,62,84,62,84,29,84,
62,84,62,84,62,84,62,84,62,84,62,84,29,84,29,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,29,84,62,84,62,84,62,84,62,84,62,84,62,84,
195,33,4,42,69,42,37,42,163,25,163,33,196,41,34,25,
227,41,166,50,166,50,138,75,202,67,231,50,199,66,73,83,
11,92,165,58,163,90,36,124,164,58,134,75,197,50,129,16,
65,17,129,25,226,41,35,50,101,58,231,66,103,75,166,83,
198,83,167,83,104,83,138,83,203,99,77,116,75,116,102,83,
166,83,102,75,37,67,5,67,5,75,134,83,36,75,133,83,
134,91,132,91,35,100,197,124,233,140,71,99,98,33,35,25,
226,24,128,8,161,16,129,16,97,8,3,25,5,50,36,34,
1,9,34,17,225,16,1,17,99,33,36,50,134,58,137,91,
234,99,104,83,39,75,71,75,233,99,107,108,107,116,107,108,
41,100,42,108,75,108,10,108,233,107,168,99,70,91,131,74,
5,83,100,58,3,42,226,33,1,34,33,42,131,50,67,50,
100,50,197,66,100,50,198,58,231,66,8,67,106,75,171,83,
106,83,77,108,12,100,236,99,202,91,105,83,40,75,231,66,
228,49,99,33,132,33,132,33,5,50,229,41,38,50,102,58,
70,58,38,50,6,50,196,41,99,25,99,25,164,33,5,50,
102,58,70,50,135,66,135,66,103,58,70,58,5,50,5,50,
167,66,135,66,135,58,102,58,38,50,200,74,135,66,168,66,
9,75,200,74,135,66,196,41,164,41,229,49,196,41,70,58,
167,58,69,50,233,74,178,132,239,107,229,33,134,58,37,50,
5,42,71,58,6,50,34,25,5,50,167,66,200,74,200,66,
135,66,167,74,167,66,41,75,167,58,5,42,100,25,100,25,
67,17,67,17,230,41,133,33,132,33,100,33,67,25,67,25,
200,66,10,75,39,42,8,42,133,33,71,50,35,17,68,25,
3,17,36,25,98,25,230,41,109,50,110,58,167,33,37,50,
135,58,103,58,135,58,168,66,70,58,34,25,67,25,6,50,
104,66,39,58,136,66,136,58,10,75,107,91,200,74,5,42,
197,33,132,33,35,25,226,16,225,16,164,33,6,42,103,50,
5,42,132,25,70,50,71,50,164,33,100,25,38,50,229,41,
5,50,167,66,168,58,135,58,102,50,168,58,167,58,4,42,
70,50,5,42,5,50,102,58,135,58,70,50,37,50,200,74,
8,75,168,66,168,66,168,66,135,58,167,66,103,58,136,66,
203,91,232,66,167,58,200,66,135,58,135,58,70,50,135,58,
232,74,41,83,103,58,38,50,104,58,136,58,234,74,42,83,
170,66,233,74,200,66,238,66,212,58,181,58,79,42,73,42,
201,66,233,66,103,58,135,58,103,58,232,74,232,74,166,58,
71,50,197,58,71,75,74,83,9,67,227,33,228,25,72,42,
148,42,89,67,146,75,108,50,10,34,214,50,30,84,31,84,
220,67,220,75,119,67,243,50,213,58,211,58,174,50,140,42,
10,67,215,91,253,83,254,75,31,76,222,75,222,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,30,76,30,76,
30,76,30,76,254,75,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,76,30,76,30,76,254,75,254,75,254,75,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
30,76,254,75,254,75,254,75,30,76,30,76,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,84,30,84,30,84,30,84,30,76,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
30,84,30,76,30,76,30,76,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,76,
30,76,30,84,30,84,30,84,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,29,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,29,84,
29,84,29,84,29,84,29,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,30,84,30,84,30,84,30,84,30,84,30,84,29,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,29,84,29,84,29,84,62,84,62,84,62,84,62,84,
5,50,163,33,4,42,4,42,98,25,163,33,132,41,35,33,
97,25,194,25,69,50,167,66,41,75,203,99,195,41,195,25,
228,33,162,25,230,123,8,182,65,50,194,58,225,17,227,16,
67,17,34,17,33,17,164,33,201,74,74,83,72,83,102,75,
136,83,169,91,137,83,203,99,77,116,141,124,108,124,201,107,
200,91,5,67,229,66,197,66,196,66,4,75,101,83,230,99,
100,91,134,83,134,83,36,75,229,99,41,149,7,116,34,50,
66,33,128,8,129,8,129,8,130,16,161,8,34,17,195,17,
163,25,131,25,99,33,132,33,131,33,135,66,7,75,39,75,
72,75,71,75,202,91,108,116,205,124,109,116,138,91,40,75,
39,67,230,58,8,67,73,83,236,107,174,132,238,140,10,116,
67,83,195,66,132,50,67,42,99,42,34,42,99,50,100,58,
2,34,227,33,35,42,165,58,40,75,105,75,166,50,8,67,
232,74,77,108,235,99,235,99,235,91,105,83,73,83,8,75,
228,49,164,41,196,41,99,33,5,50,228,41,196,41,228,41,
131,33,164,33,164,33,132,33,132,33,196,41,70,50,233,74,
135,66,228,41,229,41,37,50,103,66,168,66,6,50,229,49,
167,66,168,66,168,66,102,58,5,50,232,74,135,66,167,66,
200,66,232,74,232,74,5,50,70,58,168,74,196,41,196,41,
228,33,196,33,103,58,49,116,146,124,229,33,4,42,196,41,
196,41,70,58,6,50,99,33,135,66,134,66,228,41,5,42,
37,58,37,50,69,50,105,83,232,66,5,42,100,25,197,41,
103,50,10,75,242,132,10,75,133,33,197,33,197,33,229,41,
105,67,42,67,104,42,198,33,101,25,165,33,3,17,35,25,
66,17,165,41,68,25,68,25,135,25,133,25,66,25,133,41,
102,50,167,58,9,75,9,75,135,66,229,41,70,58,135,66,
7,58,104,58,169,66,233,74,75,83,42,83,201,74,6,50,
165,33,35,25,2,17,2,17,67,33,229,41,135,58,38,42,
196,33,164,33,229,41,164,33,164,33,197,33,39,50,39,50,
38,50,70,58,135,58,135,58,70,50,135,58,37,42,37,42,
70,50,38,42,103,58,200,66,232,74,167,66,37,50,102,58,
167,66,167,66,233,74,9,75,200,74,167,66,229,41,197,41,
105,75,199,58,200,66,167,58,70,50,135,66,70,50,70,50,
232,66,74,83,70,50,39,50,136,58,136,58,10,75,234,74,
171,58,9,67,9,67,48,67,25,67,158,75,87,67,141,42,
168,58,200,66,135,58,135,58,70,50,167,66,134,58,167,58,
170,66,231,66,169,91,139,83,140,83,133,50,228,25,41,42,
81,42,115,50,203,50,109,50,43,42,24,59,126,84,28,76,
216,59,152,59,217,75,118,67,50,59,50,67,208,50,171,42,
76,75,250,91,30,84,30,68,31,76,254,75,255,83,253,83,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,254,75,254,75,30,76,30,76,30,76,30,76,
30,84,30,76,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,84,30,84,30,76,30,76,30,76,
30,84,30,76,254,75,254,75,30,84,30,84,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,84,30,84,30,84,30,84,30,84,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,84,30,76,30,76,
30,84,30,76,30,76,30,76,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,76,30,76,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,92,30,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,29,84,29,84,29,84,29,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,29,84,29,84,29,84,29,84,29,84,29,84,
165,58,68,50,102,66,200,74,167,66,228,33,132,33,100,41,
227,32,1,33,66,58,40,116,101,83,103,83,198,66,227,33,
229,33,1,9,195,41,4,50,64,25,69,50,37,42,192,0,
162,24,2,25,130,25,230,58,70,67,229,66,197,66,7,83,
104,91,72,83,235,99,171,99,207,132,173,132,141,132,136,99,
136,83,99,42,230,58,197,66,164,66,196,74,68,75,230,91,
4,84,165,75,38,75,225,33,228,74,68,83,230,99,104,108,
98,50,32,17,97,8,66,16,98,16,97,16,160,8,34,17,
99,25,99,33,225,24,164,41,200,82,167,74,101,50,198,66,
39,67,234,91,43,100,11,92,137,75,8,67,166,58,167,66,
103,58,233,74,14,108,144,124,110,116,13,108,77,116,80,141,
44,141,198,99,132,58,130,25,0,9,161,25,98,25,130,25,
131,33,134,66,165,66,7,67,11,92,203,83,133,50,198,74,
11,92,105,75,134,58,69,50,135,66,134,58,134,50,7,67,
37,50,228,41,70,50,38,50,229,41,196,41,38,58,164,41,
197,41,229,49,6,50,164,33,164,33,164,33,164,25,38,42,
68,25,100,33,164,33,6,50,103,58,167,66,135,58,228,41,
135,66,41,83,233,74,167,66,167,66,167,66,167,66,167,66,
135,58,200,66,9,75,232,74,167,66,134,58,135,66,37,50,
197,33,133,33,73,66,78,99,81,124,198,41,229,41,164,41,
229,41,70,50,135,66,71,58,168,66,103,58,229,41,5,42,
5,42,196,33,103,66,136,66,38,50,163,25,68,34,169,75,
134,42,5,34,171,75,74,67,99,33,229,49,38,42,6,42,
230,41,167,50,163,33,1,17,197,33,35,17,36,33,197,41,
164,25,164,33,67,25,35,25,35,25,101,33,134,33,167,33,
72,50,136,58,201,66,9,75,167,66,228,41,38,50,102,58,
136,58,201,66,42,83,136,66,201,74,201,74,71,58,67,25,
166,49,68,33,3,17,67,25,230,49,71,58,70,50,70,50,
229,41,131,25,164,33,132,25,38,42,136,58,168,66,6,42,
70,42,135,50,71,50,5,42,99,25,103,50,70,50,5,34,
37,50,134,58,167,58,232,66,167,58,70,50,228,41,134,58,
200,74,168,66,42,83,74,83,200,66,229,41,99,33,197,41,
232,66,70,42,196,33,6,42,71,58,103,58,37,50,5,42,
200,66,201,66,168,66,136,58,136,58,42,83,41,83,167,66,
167,66,136,58,18,83,178,75,211,59,31,76,56,67,136,50,
104,58,71,50,136,58,103,50,168,58,168,58,199,66,8,67,
105,75,74,75,139,91,237,99,171,91,164,50,228,25,47,50,
179,50,40,26,236,58,138,50,106,42,182,50,255,83,29,76,
185,75,152,67,151,59,151,67,240,58,205,58,81,75,237,58,
180,75,61,92,255,83,223,75,62,76,30,76,255,75,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,254,75,254,75,254,75,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,76,30,84,30,84,30,76,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,84,30,84,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,84,30,84,62,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,84,30,84,30,84,30,84,30,76,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,29,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,30,84,62,84,62,92,62,92,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
171,83,229,41,165,41,40,58,73,58,171,74,198,49,2,25,
68,33,66,33,197,74,167,91,66,42,165,58,40,75,4,34,
164,33,2,17,1,17,192,16,96,0,66,25,196,33,98,17,
2,17,34,17,162,25,100,42,67,42,68,50,231,82,235,115,
137,91,235,99,203,91,12,100,109,116,142,124,11,108,169,99,
165,58,100,42,133,50,133,50,3,42,66,50,69,83,166,83,
69,75,1,42,193,33,68,58,196,66,163,58,133,83,198,83,
9,100,39,75,130,33,96,8,64,8,98,16,97,8,96,8,
193,16,34,25,67,33,5,58,167,74,134,66,134,66,39,83,
169,91,11,100,170,83,7,59,101,42,102,50,101,50,166,58,
107,83,46,108,176,124,111,116,77,108,12,108,11,100,141,116,
237,140,43,141,69,83,227,33,162,25,161,25,68,50,228,41,
102,66,102,66,100,58,198,58,105,67,137,75,7,75,169,99,
11,92,231,58,101,50,70,50,228,41,196,33,4,34,4,34,
5,42,98,25,164,33,229,41,5,50,229,49,6,50,197,41,
197,41,164,41,132,33,131,33,131,25,164,33,5,42,135,58,
197,41,99,25,99,25,229,41,71,58,103,58,103,58,135,58,
103,58,167,66,135,66,168,66,200,74,135,66,135,66,135,66,
168,66,232,74,167,66,70,58,200,66,9,75,9,75,167,58,
229,41,35,25,105,66,109,99,44,83,35,17,1,17,131,41,
37,50,135,58,103,58,70,50,102,58,135,58,42,83,42,83,
163,33,5,50,168,74,103,58,38,50,102,50,166,58,40,75,
70,34,197,41,37,42,228,25,196,25,228,33,164,25,136,74,
45,108,166,50,68,42,134,50,74,75,70,50,67,25,196,33,
131,25,99,25,225,16,2,25,99,33,230,49,230,41,7,42,
71,50,104,58,71,50,168,66,135,66,102,58,5,50,70,58,
200,66,9,75,200,66,229,41,6,50,6,50,229,41,67,25,
230,49,68,33,35,25,197,41,39,50,229,41,196,33,38,42,
5,42,228,33,38,50,135,58,167,66,103,58,103,58,103,58,
232,66,232,66,168,66,229,41,132,33,196,33,38,42,37,42,
37,50,102,50,70,50,103,50,38,42,5,42,37,50,167,66,
102,58,167,66,74,83,41,83,5,42,197,41,164,33,6,50,
9,67,38,42,132,25,197,33,229,41,5,50,196,41,228,41,
70,50,70,50,168,66,234,74,136,58,233,74,9,75,167,66,
167,66,201,74,49,83,146,75,115,59,122,59,178,50,6,34,
136,58,38,50,103,58,103,58,9,75,74,83,9,75,41,75,
41,67,232,66,14,108,79,116,236,99,38,67,229,25,174,58,
177,58,6,26,169,58,170,58,171,58,51,67,26,92,152,67,
50,51,116,59,213,75,182,75,209,58,205,58,46,67,237,58,
247,75,29,92,255,83,254,75,29,76,31,76,31,84,253,83,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
254,75,254,75,30,76,30,76,30,76,30,76,254,75,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,84,30,84,30,84,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,84,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,30,84,62,84,62,84,62,92,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
172,83,71,50,39,66,104,74,71,74,38,66,38,66,164,41,
133,41,1,17,65,25,129,25,129,25,36,42,102,50,131,25,
193,16,161,16,96,8,64,8,96,8,193,16,1,17,66,17,
98,17,98,17,162,25,227,33,162,33,166,66,137,99,40,91,
40,83,235,99,171,91,204,91,171,83,12,92,137,83,169,83,
227,41,101,50,4,42,101,50,36,50,132,58,135,83,69,67,
3,50,64,25,162,33,68,58,132,58,228,66,228,58,37,67,
229,66,232,91,36,75,161,33,192,16,97,8,97,16,97,16,
129,16,194,16,35,33,164,41,196,41,195,41,36,58,166,74,
105,83,40,75,166,50,101,42,4,34,101,42,40,75,12,108,
45,108,13,100,142,116,239,124,174,116,76,108,10,100,201,99,
109,124,142,157,234,132,196,58,195,33,35,42,132,58,228,41,
66,25,33,17,129,25,100,42,7,59,39,67,72,75,43,108,
39,67,133,50,195,33,195,33,37,50,69,50,36,42,36,42,
131,25,66,17,163,33,196,41,197,41,132,33,131,33,99,25,
35,25,99,33,132,33,132,33,99,33,131,33,37,50,103,58,
38,50,164,33,164,33,197,41,229,41,5,50,37,50,135,66,
168,66,102,58,70,58,168,66,232,74,135,66,102,58,134,58,
103,66,200,74,135,58,37,50,232,66,41,75,73,75,73,75,
135,58,34,17,39,58,15,116,173,99,197,33,2,17,70,66,
200,66,167,66,102,58,70,58,102,58,167,66,74,83,200,66,
195,41,5,50,70,58,229,41,197,33,6,42,164,33,5,42,
135,58,38,58,9,75,167,50,5,34,70,42,135,58,103,74,
52,166,199,58,198,50,169,75,105,83,69,42,37,42,195,33,
100,33,67,25,225,16,225,16,67,33,197,41,6,42,38,50,
39,50,103,58,168,66,42,83,70,50,70,50,5,42,38,50,
232,66,9,75,9,75,200,66,135,58,132,33,164,33,197,41,
166,49,133,33,165,41,6,50,6,50,132,33,132,25,229,41,
73,83,232,66,134,58,231,66,8,75,102,50,135,58,9,75,
9,67,9,75,167,58,164,33,164,33,6,50,38,50,196,33,
70,58,70,50,5,42,38,50,196,33,132,25,5,42,135,66,
135,66,167,66,41,83,232,66,163,25,70,50,5,50,229,41,
102,50,228,33,99,25,197,41,38,50,103,58,135,66,200,74,
167,66,167,66,135,66,168,66,168,66,200,66,233,74,41,83,
8,75,232,74,204,66,240,66,52,59,53,59,173,50,6,42,
136,58,103,58,169,66,136,58,168,58,135,58,167,58,9,75,
231,66,9,67,140,91,47,108,173,124,71,75,99,17,40,34,
141,50,76,50,138,58,137,58,138,58,238,58,147,75,178,67,
116,67,54,59,115,67,82,67,16,67,12,67,45,67,146,75,
59,92,30,84,31,84,62,76,29,76,255,75,31,84,253,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,254,75,30,76,30,76,254,75,254,75,
254,75,30,76,30,76,30,76,30,76,30,76,30,76,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,76,30,76,30,76,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,76,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,30,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,92,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
137,83,167,66,70,66,132,74,103,132,197,115,42,124,197,49,
197,41,164,41,34,25,33,17,163,33,163,33,34,25,1,17,
225,16,226,24,161,16,162,16,194,16,225,16,98,25,3,42,
162,17,162,25,195,33,163,33,65,25,195,41,133,66,133,66,
72,91,137,91,171,91,41,75,138,75,203,83,137,75,165,50,
195,33,166,58,36,42,166,66,198,74,6,75,103,83,228,58,
162,33,36,50,100,50,35,42,196,66,38,75,164,58,132,50,
197,66,36,75,165,83,8,100,132,58,192,8,96,8,65,8,
97,16,97,16,194,16,67,25,99,33,163,41,69,66,166,82,
134,66,166,58,199,58,8,67,40,67,138,83,170,83,137,91,
12,100,142,108,141,108,108,108,75,100,201,91,168,91,42,108,
78,116,205,132,140,149,198,91,162,25,3,42,160,33,33,17,
34,25,195,33,68,42,39,75,72,75,132,42,38,67,204,124,
165,50,68,42,4,42,195,33,196,33,37,50,37,42,130,25,
99,25,196,33,196,33,99,25,99,25,99,25,99,25,67,25,
34,25,197,49,38,58,38,58,38,58,38,58,168,74,200,74,
38,50,229,41,5,50,196,41,5,42,135,58,102,58,102,58,
70,50,70,50,103,58,168,66,167,66,70,58,37,50,37,50,
135,66,168,74,135,58,135,58,8,75,200,66,231,66,8,67,
232,74,70,50,6,50,108,99,205,107,136,58,196,41,102,66,
200,66,37,50,70,58,102,58,199,66,8,75,167,66,228,41,
37,50,196,41,229,49,68,33,226,16,39,50,70,50,196,25,
99,25,229,41,171,83,40,59,70,50,200,66,73,67,232,66,
232,58,134,58,133,42,133,42,142,116,175,124,74,75,164,33,
194,16,194,16,162,16,161,16,226,16,67,25,197,33,38,42,
71,50,71,50,201,74,9,75,37,50,5,42,229,41,38,50,
167,58,167,58,232,66,9,75,70,50,34,17,5,42,168,66,
101,41,39,58,169,74,104,66,6,50,229,41,6,42,5,42,
231,66,40,75,199,66,137,91,12,108,231,66,102,50,232,66,
41,75,167,58,164,33,229,41,164,41,38,50,5,50,37,50,
70,58,38,50,38,50,229,41,100,25,164,33,103,58,233,74,
199,74,232,74,41,83,135,58,5,42,200,66,70,50,196,33,
70,42,38,42,6,42,71,50,71,58,103,58,135,66,200,74,
231,74,232,74,200,66,168,66,168,66,135,66,70,58,135,58,
8,75,41,75,169,66,207,66,85,75,114,75,10,67,136,58,
70,50,38,50,71,50,71,50,71,50,103,50,135,58,9,75,
231,66,232,66,108,83,79,116,205,124,201,91,167,50,166,50,
8,67,207,66,140,58,137,58,141,58,209,66,86,75,212,83,
85,67,23,67,246,58,246,66,19,75,172,58,175,50,183,83,
62,92,254,83,31,84,62,84,254,75,255,75,31,84,253,75,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,76,254,75,254,75,30,76,30,84,31,84,30,76,254,75,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
30,84,30,84,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,76,30,76,30,76,
30,84,30,84,30,84,254,75,254,75,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,76,30,76,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,76,30,76,
30,76,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,30,84,30,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,92,62,92,62,92,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
7,75,69,58,228,49,228,90,42,165,69,124,171,140,4,50,
197,49,71,66,6,50,5,50,66,25,224,16,160,8,160,16,
0,17,225,16,226,16,226,16,193,8,225,8,227,33,165,50,
97,17,98,25,224,8,224,8,195,33,4,42,35,42,35,42,
68,58,198,74,72,83,100,50,40,75,169,83,72,75,194,25,
227,41,133,58,100,50,165,58,100,58,164,66,228,66,163,58,
132,50,38,67,228,58,5,59,38,67,67,42,166,66,227,41,
164,66,228,74,65,42,3,67,198,91,99,50,192,8,129,8,
97,16,97,8,161,16,2,25,67,33,99,41,163,49,4,66,
37,58,134,66,73,83,45,108,44,100,235,91,105,83,39,75,
11,92,76,100,108,100,169,83,197,58,38,75,9,100,42,108,
110,116,142,124,76,141,74,133,1,34,33,17,129,25,97,25,
134,58,105,91,197,58,165,50,230,58,230,58,71,75,38,67,
3,34,68,50,101,50,228,41,163,33,164,33,163,33,130,25,
164,33,5,42,229,41,164,33,196,41,229,41,132,33,35,25,
132,33,197,41,132,33,6,50,200,74,200,74,168,66,103,66,
38,50,37,50,102,58,37,50,70,50,167,66,135,58,135,66,
71,58,70,50,103,58,167,66,168,66,135,66,135,58,103,58,
70,58,70,58,102,58,167,66,200,66,167,58,232,66,8,67,
167,66,199,66,103,66,168,74,107,91,168,58,229,41,229,49,
70,58,196,41,37,50,102,58,200,74,200,74,134,58,69,50,
70,42,230,41,198,49,36,33,194,24,38,58,199,58,72,59,
166,50,131,25,69,34,4,26,228,41,232,66,235,75,43,84,
134,58,228,41,236,99,167,50,37,50,13,108,13,100,35,17,
228,16,195,16,163,16,130,8,194,16,35,25,132,25,196,33,
6,50,103,58,233,74,168,66,167,66,228,33,131,25,5,42,
135,58,135,50,103,58,38,50,131,25,131,25,200,66,233,74,
227,24,165,41,39,58,197,41,132,33,6,50,168,66,200,66,
198,66,40,75,199,66,40,75,105,83,199,66,166,58,232,66,
9,75,37,42,67,17,38,50,6,50,70,58,37,50,37,50,
38,50,5,50,71,58,197,41,99,25,197,41,70,58,135,66,
134,58,9,83,73,83,102,50,200,66,200,66,38,50,197,33,
229,33,38,42,6,42,230,41,197,41,6,50,38,50,70,58,
102,58,167,66,200,74,167,66,135,58,167,66,232,74,200,66,
134,58,199,74,135,58,109,50,178,66,236,58,73,75,44,83,
168,66,71,50,6,42,7,42,104,58,136,58,135,58,167,58,
8,67,41,75,238,99,46,108,75,108,233,91,39,67,233,91,
75,100,240,66,43,42,73,50,109,50,18,75,150,83,147,75,
49,67,49,67,239,58,15,67,43,67,234,58,21,67,254,91,
31,84,255,83,30,84,30,76,30,76,255,75,255,75,30,76,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,76,30,76,30,76,30,84,30,84,30,76,254,75,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,76,30,76,30,76,30,76,30,84,
30,84,30,84,30,84,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,76,30,76,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,62,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,92,62,92,62,92,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
135,66,5,50,196,41,5,58,36,66,162,49,165,74,2,42,
66,33,5,50,229,49,200,74,69,50,195,41,195,41,196,41,
130,25,0,9,1,17,225,16,160,8,192,8,65,17,96,17,
33,25,98,33,65,25,33,17,195,33,68,42,165,50,132,42,
226,41,165,66,198,74,194,33,36,50,166,66,36,50,33,17,
36,50,3,42,133,58,67,50,226,41,164,74,229,74,196,66,
38,75,164,50,101,75,167,75,99,34,64,17,69,58,98,33,
229,74,38,83,5,75,4,67,133,83,199,91,230,66,1,9,
129,16,129,8,129,8,161,16,161,16,161,16,225,24,66,41,
5,58,70,58,9,83,44,108,170,91,7,67,230,58,104,75,
104,75,104,75,71,67,71,67,136,75,168,83,169,91,234,99,
11,100,142,116,236,124,204,149,36,75,227,33,69,58,132,58,
231,74,165,58,67,42,71,75,202,91,7,67,71,67,196,50,
36,42,165,58,69,50,228,41,5,42,228,41,163,33,5,50,
196,33,164,33,66,17,2,17,35,25,100,33,35,25,35,25,
197,41,164,33,67,25,196,41,168,74,103,58,196,41,196,41,
37,50,228,41,5,42,70,50,135,58,135,66,70,50,102,58,
135,66,71,58,103,58,168,66,168,66,135,66,102,58,135,66,
102,58,102,58,134,58,134,58,101,50,102,50,231,66,167,58,
199,66,199,66,9,83,200,74,107,91,200,66,5,50,228,49,
5,50,164,33,164,33,37,50,135,66,69,50,134,58,134,66,
38,34,68,25,133,41,36,33,3,33,6,50,199,58,169,75,
76,76,199,58,196,33,196,33,233,74,41,67,132,26,166,42,
232,74,168,74,45,108,232,66,195,33,102,50,135,50,68,25,
166,33,36,25,195,8,130,8,227,16,100,33,229,41,229,33,
71,58,135,58,200,74,135,58,200,66,5,42,228,33,5,42,
38,42,229,33,196,33,132,33,66,17,197,41,136,66,197,41,
3,25,67,33,197,41,6,50,229,41,38,50,103,58,103,50,
167,66,232,74,231,66,7,75,231,66,41,75,106,91,41,83,
167,58,5,42,229,41,38,50,102,58,102,58,134,58,166,58,
167,58,196,33,5,42,197,41,197,41,5,42,38,50,167,58,
167,66,41,83,8,75,70,42,9,67,135,50,229,33,132,25,
37,42,70,50,229,41,132,33,67,25,197,41,196,41,164,33,
103,58,135,66,167,66,135,58,135,58,167,66,167,66,102,58,
36,50,135,58,199,66,205,66,16,75,235,66,10,67,13,75,
9,75,168,58,39,42,7,42,72,50,137,58,168,66,200,66,
139,91,106,83,233,66,74,75,235,91,136,75,103,75,139,108,
234,58,76,50,41,42,138,58,205,66,46,67,77,67,46,59,
13,67,206,58,141,50,109,50,138,42,15,59,219,83,63,84,
255,75,255,75,31,84,30,76,30,76,254,75,254,75,30,84,
254,75,254,75,254,75,254,75,254,75,254,75,254,75,254,75,
30,84,30,76,30,76,30,76,30,84,30,84,30,76,30,76,
30,84,30,84,30,76,30,76,30,76,30,76,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,76,30,76,30,84,30,84,30,84,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,76,30,76,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
71,66,71,58,39,58,39,58,40,66,137,74,232,74,35,42,
195,41,199,66,166,58,137,83,136,83,99,42,100,50,68,42,
195,33,33,17,225,16,160,8,193,16,34,25,2,25,225,16,
226,24,128,8,192,8,64,17,161,25,161,25,68,42,133,42,
67,50,132,50,68,42,161,25,194,33,4,50,99,33,34,33,
4,42,4,42,230,66,3,42,3,50,39,91,198,74,165,66,
68,58,226,41,103,83,229,58,64,9,162,25,195,41,65,33,
37,75,102,83,102,83,5,67,163,58,196,66,197,66,68,50,
35,25,161,8,96,8,97,8,129,16,194,24,34,33,132,41,
131,49,70,66,232,82,106,83,169,83,234,91,168,83,71,75,
230,66,230,58,104,75,10,100,233,91,137,83,202,91,202,91,
76,108,140,116,172,116,76,141,72,108,132,58,196,41,161,33,
194,33,67,42,38,67,201,83,72,75,198,58,104,75,6,59,
132,58,3,42,4,42,37,50,5,42,37,50,70,50,228,41,
99,25,99,25,34,25,35,25,35,25,35,25,3,25,132,41,
38,50,38,50,38,50,70,50,102,58,5,50,196,41,70,58,
70,58,4,42,196,33,37,50,200,66,232,74,135,58,37,50,
6,50,71,58,201,74,42,83,41,83,200,74,200,74,74,91,
8,75,167,58,134,58,134,58,167,58,199,66,8,75,166,58,
232,66,9,75,233,82,135,66,233,74,232,66,135,58,228,49,
196,41,132,33,132,33,5,50,70,58,5,50,102,58,134,58,
168,66,132,33,201,74,104,58,2,9,5,42,232,58,36,34,
134,34,167,58,168,66,135,58,164,33,228,25,231,50,137,83,
170,99,142,116,41,75,4,34,105,75,170,83,102,50,70,42,
38,42,132,25,3,9,194,8,36,25,197,41,71,58,70,50,
103,58,71,58,70,58,5,50,70,50,135,58,200,66,103,50,
197,41,35,17,226,8,2,17,2,17,67,25,68,33,226,16,
3,25,2,25,132,33,38,50,6,50,6,50,70,50,70,50,
37,50,167,66,200,74,231,74,134,58,232,74,232,74,103,58,
102,50,229,41,37,50,38,50,167,66,199,66,199,58,137,83,
204,99,70,50,229,41,197,41,5,42,5,42,70,50,232,66,
232,74,41,83,102,58,5,34,168,58,103,50,6,42,165,25,
70,42,70,50,229,41,132,33,100,33,229,41,229,41,196,41,
132,33,229,41,70,58,135,66,74,83,9,83,232,74,200,74,
167,74,136,66,166,66,170,66,237,74,169,58,171,58,173,58,
41,75,233,66,71,50,7,42,40,50,137,58,136,58,168,66,
234,74,74,83,170,83,77,108,74,75,197,58,73,100,43,100,
71,42,38,42,136,58,201,66,236,74,236,66,202,58,45,67,
237,66,238,66,76,67,234,58,172,50,117,75,30,84,62,76,
30,76,254,75,31,84,254,75,30,76,30,84,30,76,31,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,76,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,30,84,62,92,62,92,62,92,62,92,
62,92,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
167,82,70,66,103,58,135,58,9,83,102,58,102,58,4,34,
165,58,169,83,39,67,71,67,134,67,162,42,70,67,132,42,
98,25,2,17,226,24,64,8,129,16,162,24,129,8,129,8,
194,16,67,25,66,25,129,17,35,34,193,25,161,17,194,25,
100,42,3,34,36,42,227,33,130,25,34,25,2,25,35,33,
98,17,37,42,40,75,195,33,36,58,8,91,227,57,194,41,
33,41,227,57,165,66,161,25,32,9,134,58,130,33,32,25,
37,67,36,67,133,75,102,83,230,74,100,50,3,42,67,50,
197,41,193,8,64,0,96,8,129,16,226,24,35,33,67,33,
66,41,69,66,199,74,40,83,169,91,107,108,201,83,196,58,
198,66,234,99,75,108,201,91,71,75,137,83,44,100,12,100,
234,99,41,108,74,108,45,133,202,124,1,42,130,33,130,33,
3,42,164,50,37,67,99,42,226,33,166,58,137,75,132,42,
68,50,68,50,69,50,69,50,70,50,70,50,196,41,66,25,
99,33,99,33,2,17,2,25,2,17,3,25,35,25,165,41,
70,50,5,42,196,33,131,25,228,41,70,58,37,50,70,58,
102,58,232,74,232,74,167,66,199,66,232,74,200,66,70,50,
168,74,168,66,168,66,168,66,9,83,41,83,9,75,106,91,
138,91,9,75,8,75,73,83,73,83,8,75,40,75,231,66,
135,58,168,66,38,50,168,66,9,75,134,58,134,58,70,58,
197,41,132,33,6,50,70,58,70,58,38,50,70,58,135,66,
102,66,200,74,208,132,237,91,229,25,131,17,37,42,167,58,
69,50,172,99,204,91,107,75,197,41,131,33,134,58,199,66,
165,66,230,58,105,75,231,66,6,51,234,83,40,75,8,51,
232,58,135,50,38,50,165,33,165,41,196,41,5,50,4,42,
132,33,71,58,70,58,37,50,37,50,103,58,168,66,103,58,
197,41,35,25,2,17,35,25,35,25,35,25,194,16,194,16,
193,16,226,16,164,41,6,50,229,41,6,50,70,50,37,42,
196,41,168,66,9,75,167,66,70,58,135,66,103,58,103,58,
5,42,5,42,196,33,38,50,106,83,142,116,8,67,198,50,
106,83,135,50,5,42,197,41,6,50,38,50,135,50,135,50,
232,74,232,74,5,42,229,33,38,42,103,50,169,58,104,50,
229,33,6,42,229,41,197,41,165,41,38,50,38,58,37,50,
7,50,165,33,229,41,38,50,70,58,102,58,41,83,106,91,
74,91,169,66,167,66,136,58,169,58,169,50,174,58,239,58,
199,58,201,66,136,58,105,58,40,50,104,58,103,58,136,66,
202,66,42,75,169,83,73,75,103,42,168,83,234,116,72,75,
105,58,132,33,39,50,199,66,233,74,236,74,10,67,234,66,
41,75,12,67,73,67,233,58,51,75,30,100,31,84,62,68,
62,76,253,75,31,84,255,75,254,75,62,84,62,84,31,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,76,30,76,30,76,30,76,30,76,30,76,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,76,30,76,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,84,30,84,30,84,30,76,30,76,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,30,84,30,84,30,84,30,84,62,92,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,92,62,92,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,30,84,30,84,30,84,30,84,30,84,30,84,
29,84,62,84,62,84,62,92,62,92,62,84,62,84,29,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
29,84,29,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
231,65,165,49,131,33,102,58,103,50,196,25,130,17,133,50,
195,50,70,67,231,66,167,58,7,59,197,50,196,58,194,50,
67,34,65,17,128,8,96,8,194,16,194,24,97,16,65,24,
2,42,100,50,129,17,129,17,68,34,68,42,130,25,130,25,
226,25,3,34,2,34,226,25,129,17,130,25,1,17,1,17,
161,16,100,41,99,41,1,25,1,25,98,33,98,33,0,25,
229,57,163,41,65,25,192,8,101,50,166,66,224,24,36,50,
6,75,4,75,229,58,201,99,4,59,199,91,228,58,3,59,
165,50,162,25,160,8,96,16,35,41,164,49,228,49,101,58,
200,74,37,58,70,58,199,74,138,91,231,74,227,33,231,66,
11,100,10,92,135,75,135,75,10,92,233,83,200,83,72,92,
168,91,175,124,208,124,172,116,76,141,70,83,227,41,5,50,
229,41,195,33,227,41,228,33,232,66,45,100,137,75,197,50,
67,42,100,50,4,42,131,33,197,41,6,50,131,25,33,9,
35,25,35,25,162,16,68,33,71,66,102,66,134,58,36,42,
133,33,68,25,67,25,99,25,67,25,197,49,103,66,103,66,
101,58,7,75,104,83,135,75,6,67,198,66,102,58,168,74,
168,66,168,66,103,66,168,74,200,74,232,74,232,74,8,75,
200,74,135,74,102,66,8,75,199,66,199,74,8,83,8,75,
102,58,70,58,233,82,107,99,74,91,102,58,8,67,199,58,
229,33,70,42,74,83,9,75,135,58,37,50,37,50,228,49,
102,66,234,91,204,108,43,92,77,108,9,67,167,50,228,33,
103,50,17,133,13,100,5,34,229,41,196,33,66,25,229,49,
103,58,196,41,37,42,41,83,166,58,40,75,137,83,198,50,
165,50,137,75,44,100,138,75,38,42,131,25,164,41,132,41,
102,50,233,74,6,50,132,33,6,50,135,58,135,58,70,50,
196,33,131,25,99,25,67,25,35,25,3,25,195,16,194,16,
193,16,38,66,43,91,230,49,6,50,70,50,4,42,37,50,
37,58,134,58,41,83,9,75,167,58,233,66,233,66,70,50,
228,33,196,33,228,41,102,50,232,74,8,75,200,66,232,74,
102,50,38,42,70,50,229,41,197,33,71,50,135,58,167,58,
9,75,168,66,38,50,197,33,5,42,38,42,38,42,134,50,
72,75,134,58,196,33,164,41,229,49,38,58,102,58,37,50,
6,50,5,50,229,41,229,41,196,41,196,41,102,58,232,74,
74,83,233,74,199,66,231,66,167,58,105,50,141,58,209,66,
233,74,233,74,170,74,137,58,105,58,104,58,168,58,199,66,
234,74,137,58,136,58,199,58,168,83,236,124,201,91,102,50,
103,50,70,50,6,42,168,58,10,67,201,58,10,67,9,67,
9,75,8,75,169,58,16,67,221,83,30,76,62,76,255,75,
30,84,30,84,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,92,30,84,30,84,30,84,30,84,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,92,
30,84,62,84,62,84,62,84,30,84,30,84,30,84,62,84,
29,84,62,84,62,92,62,92,62,84,30,84,62,84,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,29,84,
29,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,29,84,29,84,30,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,92,62,92,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
62,84,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,84,62,92,62,92,62,84,29,84,29,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
197,49,131,33,4,50,228,41,37,50,135,58,163,25,68,42,
163,50,164,50,227,33,41,83,170,75,165,42,196,58,227,50,
197,50,67,34,162,25,33,17,225,16,161,16,160,16,225,24,
68,50,195,33,98,17,162,17,3,34,35,34,162,17,162,25,
165,50,132,42,67,34,2,26,35,34,3,34,130,25,66,17,
161,8,193,16,193,16,128,8,193,16,2,25,2,25,2,25,
34,33,1,17,224,16,163,41,166,58,165,58,64,25,165,58,
38,75,37,67,197,66,103,67,135,83,134,75,135,83,69,67,
67,34,227,33,66,25,161,16,194,24,35,33,67,33,66,25,
1,17,1,17,228,41,134,58,195,33,32,17,133,58,141,116,
39,67,105,75,73,75,11,92,9,84,70,67,9,92,6,59,
6,75,45,108,17,133,112,141,76,133,167,91,96,25,98,33,
163,33,4,42,231,66,137,91,105,83,232,58,198,50,197,50,
132,34,35,26,195,25,99,25,99,33,132,33,67,33,67,33,
2,17,67,25,197,41,103,66,167,66,8,75,170,91,169,83,
232,74,70,50,163,33,130,25,130,33,195,41,69,50,134,66,
167,58,198,66,39,75,168,83,233,91,233,99,7,75,102,58,
168,66,70,50,38,58,200,74,232,74,168,74,135,58,232,74,
9,75,200,82,135,66,167,58,102,50,135,66,232,74,40,75,
9,75,102,58,41,83,41,75,70,50,102,50,105,75,231,58,
196,25,70,50,232,66,135,58,70,50,229,49,164,41,164,41,
168,74,8,67,104,67,76,100,138,83,81,133,235,91,130,17,
197,33,135,58,70,50,5,42,38,42,99,25,163,33,229,41,
5,50,196,33,5,42,131,25,195,25,162,25,36,34,36,34,
69,42,69,42,135,50,232,66,196,33,132,33,164,41,71,66,
232,66,168,58,164,33,164,33,103,58,103,58,70,50,37,42,
196,33,132,25,132,33,100,25,2,17,226,16,162,8,194,16,
2,25,71,66,233,82,165,41,38,50,201,66,167,66,37,50,
4,42,102,58,232,74,200,66,135,58,167,58,70,50,229,41,
229,33,228,41,196,33,229,41,200,66,41,75,200,66,134,58,
103,50,5,42,38,50,38,50,6,50,71,50,168,58,41,75,
42,83,135,58,229,41,132,25,132,25,132,25,164,33,38,42,
232,66,168,66,197,41,100,33,6,50,38,58,6,50,70,50,
6,50,38,50,71,58,70,58,196,41,163,33,5,42,102,58,
167,66,167,66,200,66,232,66,200,66,201,66,105,50,200,33,
103,58,9,75,43,83,169,66,104,58,169,58,168,58,103,50,
168,58,169,58,201,66,106,75,9,92,74,100,7,67,163,25,
105,58,137,58,201,66,136,58,168,58,201,66,201,58,10,67,
73,75,233,66,139,58,51,67,255,91,253,75,29,76,31,84,
30,84,30,84,30,76,30,76,30,76,30,84,30,76,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,76,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,92,30,84,30,84,30,84,30,84,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,30,84,30,84,30,84,62,84,
29,84,62,84,62,92,62,92,62,84,30,84,62,84,62,92,
62,92,62,92,62,92,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,84,62,92,62,92,62,92,62,84,29,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
167,58,166,66,40,83,228,41,228,41,9,75,101,42,231,58,
226,25,67,34,101,58,82,157,52,166,103,75,228,58,194,42,
66,34,164,42,229,42,100,34,97,17,192,16,0,17,98,25,
98,33,224,8,33,9,98,17,193,17,35,34,2,26,35,34,
67,34,100,34,132,42,99,34,164,42,100,42,226,25,194,25,
66,25,34,17,2,17,128,0,128,0,2,17,2,25,35,25,
2,25,224,0,224,16,4,50,68,42,68,42,129,33,103,75,
70,75,197,50,197,66,228,50,201,91,228,42,8,92,38,67,
7,67,199,58,69,50,67,25,161,8,161,16,129,16,129,16,
225,8,99,25,5,50,228,41,162,33,133,58,40,83,198,66,
7,67,41,75,12,92,11,92,136,75,201,83,197,50,230,58,
136,83,142,116,115,149,173,116,109,141,233,99,129,33,163,41,
167,66,72,83,72,83,166,58,166,58,137,83,136,75,132,42,
34,18,35,26,101,42,229,33,67,25,35,25,67,25,2,17,
99,33,131,33,131,33,195,41,69,50,198,66,71,75,136,83,
136,91,10,108,10,100,168,91,136,83,168,91,136,83,103,83,
73,83,8,67,6,67,167,75,41,92,171,116,10,100,6,75,
70,50,4,42,38,50,9,83,9,83,136,66,38,50,38,50,
102,58,168,74,135,66,167,58,134,50,134,58,135,66,199,66,
8,75,167,58,42,83,168,66,5,42,228,33,166,50,8,59,
101,50,69,42,36,42,4,42,163,33,164,33,196,41,5,50,
103,74,69,50,194,17,4,34,74,83,106,75,138,83,133,50,
2,17,2,17,35,25,67,25,164,33,196,33,9,75,135,50,
229,41,196,33,200,66,98,17,98,17,101,50,8,67,4,34,
99,25,229,41,139,91,9,75,67,17,6,50,136,66,168,74,
167,58,70,50,164,33,229,41,70,58,229,41,229,41,69,50,
197,41,132,33,100,33,35,17,193,8,161,8,226,16,67,25,
230,49,38,50,6,50,100,25,6,42,168,66,200,66,103,58,
70,58,167,66,167,58,69,50,102,50,135,58,70,50,38,50,
103,58,70,50,5,42,70,50,135,58,70,50,229,41,37,42,
103,50,6,42,38,50,71,50,70,50,70,50,135,58,9,75,
106,91,167,58,5,42,197,33,67,25,35,17,2,17,2,17,
100,25,39,50,165,41,132,41,71,66,6,50,165,33,71,50,
103,58,38,50,38,50,70,50,70,50,102,58,135,58,135,58,
69,58,167,66,233,74,233,74,9,75,41,75,199,66,134,50,
135,58,42,83,139,91,9,75,168,66,201,66,168,66,71,50,
233,66,42,75,42,75,105,75,169,83,42,92,105,75,37,34,
237,74,171,66,235,74,168,58,168,66,9,75,168,58,233,66,
8,67,10,67,240,66,152,83,31,92,186,67,186,67,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,76,
30,76,30,76,30,76,30,76,30,76,30,76,30,76,30,76,
30,76,30,76,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
254,75,254,75,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,63,84,63,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,63,84,63,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,92,62,92,62,92,62,92,
30,84,30,84,62,92,62,92,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,30,84,30,84,62,84,62,84,
29,84,62,84,62,92,62,92,62,84,62,84,62,84,62,92,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,92,62,92,62,92,62,84,62,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,30,84,30,84,62,84,62,92,62,92,62,84,29,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,92,62,92,62,92,62,84,29,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
230,58,231,66,40,83,101,58,228,41,37,50,228,33,101,42,
100,42,194,25,228,49,110,132,181,182,233,91,41,100,73,84,
163,42,34,26,66,26,100,34,35,34,162,25,130,25,195,33,
225,16,160,0,225,16,98,25,194,25,67,34,66,34,164,42,
226,25,100,34,164,42,228,42,228,42,196,42,34,26,226,17,
162,25,163,33,4,42,130,25,192,0,1,9,2,17,225,8,
225,16,33,9,131,33,228,41,226,25,35,42,35,42,200,83,
38,67,36,42,5,59,229,66,103,59,165,50,199,83,133,58,
233,91,39,67,68,42,162,25,1,17,161,8,96,8,129,24,
66,25,196,33,70,50,163,33,163,33,102,58,101,58,101,58,
232,66,202,91,75,108,201,83,169,83,198,58,104,75,139,108,
137,83,240,132,143,116,173,116,78,133,107,108,133,58,70,58,
230,66,198,58,7,67,7,67,104,75,104,75,197,50,131,42,
161,25,227,33,69,50,5,42,67,25,132,33,197,41,100,25,
67,25,164,41,37,50,102,58,166,66,166,58,68,42,68,50,
5,67,168,91,74,108,107,108,42,100,200,83,233,83,42,92,
202,91,137,83,103,75,135,75,199,83,74,100,9,92,103,75,
73,75,199,66,232,66,41,83,135,66,132,33,67,25,132,33,
196,33,135,66,168,74,135,50,69,42,228,41,5,50,134,58,
232,66,167,66,168,66,70,50,5,42,196,33,69,42,73,75,
198,66,227,33,36,42,167,58,98,25,66,25,5,50,37,50,
196,49,170,91,8,59,196,33,41,83,70,42,69,42,163,33,
35,25,3,25,193,16,34,25,229,41,135,58,139,83,167,50,
103,58,102,50,102,50,8,67,199,66,134,50,134,50,227,25,
160,8,71,58,148,157,111,116,37,42,164,33,102,50,102,58,
5,42,228,41,164,33,229,41,6,50,229,41,229,41,5,42,
68,25,3,25,3,17,226,16,193,8,225,16,67,25,165,41,
71,58,197,41,132,25,164,33,38,42,38,50,38,50,229,41,
102,50,134,58,69,42,5,42,103,58,135,58,6,50,229,49,
164,33,38,50,71,50,38,50,6,42,5,42,5,42,38,50,
38,42,229,33,230,41,6,42,38,50,134,58,167,58,8,75,
8,75,102,50,38,50,230,41,165,41,197,41,100,33,194,16,
100,33,230,49,70,58,102,66,70,58,196,41,164,33,229,41,
200,66,70,50,228,33,229,41,135,58,200,66,135,58,70,50,
69,58,135,66,168,66,168,66,233,74,166,66,165,58,72,83,
232,74,41,83,73,83,41,83,8,75,233,74,169,66,136,58,
232,66,41,75,106,75,235,91,43,92,202,83,73,67,168,50,
202,66,72,50,72,50,136,58,201,66,9,75,9,75,232,66,
9,67,44,67,52,67,56,67,123,75,53,59,152,67,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,92,62,92,62,92,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,92,
62,92,30,84,30,84,30,84,30,84,62,92,30,84,30,84,
30,84,62,84,62,92,62,84,62,84,30,84,62,84,62,84,
30,84,62,84,62,92,62,92,62,92,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,84,30,84,62,84,62,92,
62,92,62,92,62,84,30,84,30,84,30,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,84,62,84,62,84,62,84,
62,92,30,84,30,84,62,84,62,92,62,92,62,84,29,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,92,62,92,62,84,29,84,29,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
230,58,3,34,4,42,134,66,102,58,98,25,33,9,195,25,
68,42,162,17,4,50,41,91,108,108,165,50,229,58,37,59,
229,50,164,50,35,34,226,25,35,34,134,50,4,34,192,8,
160,8,96,0,161,8,98,25,194,33,99,42,131,42,164,42,
100,34,132,42,99,26,228,42,196,42,38,59,34,26,225,17,
2,26,161,25,68,42,68,42,97,17,0,9,66,17,131,25,
98,17,4,26,195,33,130,25,227,25,35,34,197,66,168,83,
229,58,4,42,6,59,38,75,6,43,137,75,197,50,131,33,
70,75,71,67,229,58,132,42,162,25,33,25,226,24,133,57,
70,58,197,41,131,33,99,25,163,33,131,33,98,25,134,66,
199,66,136,83,135,83,70,75,165,58,43,100,42,100,197,58,
12,100,12,100,77,108,174,116,46,133,45,133,165,58,36,50,
71,75,234,91,104,75,100,42,198,58,104,75,6,67,67,42,
227,41,195,33,228,41,196,41,67,25,67,33,100,41,3,25,
67,33,67,33,37,58,102,66,101,58,166,66,199,74,231,74,
197,58,6,67,136,83,201,91,168,83,104,75,168,75,233,83,
42,100,10,100,9,92,74,100,9,92,200,83,71,75,72,75,
138,91,9,75,41,75,74,83,71,58,2,17,2,17,165,41,
70,50,167,74,167,66,102,50,69,42,229,41,5,50,167,58,
167,66,70,58,197,41,6,50,197,41,196,41,102,58,232,74,
198,66,166,58,203,99,142,124,37,50,99,25,103,58,70,50,
36,50,231,58,199,50,163,25,196,33,38,50,228,33,34,25,
2,25,67,33,128,8,99,33,229,41,5,42,199,58,171,83,
110,108,232,66,4,34,166,50,36,34,134,50,69,42,195,25,
196,33,168,66,139,83,42,67,135,42,70,42,106,83,8,67,
5,42,196,41,164,33,229,41,70,50,38,50,197,41,67,25,
35,25,226,16,194,8,193,8,194,16,35,25,197,41,38,50,
133,33,100,25,67,25,164,25,38,42,71,50,103,58,229,41,
70,50,70,50,37,42,37,42,103,58,102,58,5,50,196,41,
131,25,5,42,70,50,38,50,6,42,229,41,229,41,6,42,
6,42,165,33,165,33,197,41,5,42,102,58,200,66,73,83,
232,74,102,50,70,50,38,50,39,50,72,66,39,58,165,41,
229,49,74,91,200,74,36,50,134,66,4,50,163,25,70,50,
70,50,38,50,196,33,196,33,70,50,103,50,38,42,38,42,
37,50,71,58,71,58,103,58,232,74,167,66,70,50,200,66,
200,66,167,66,199,66,7,75,8,75,200,74,200,66,201,74,
8,67,41,75,106,75,138,75,169,83,105,75,232,58,168,58,
102,50,5,42,71,50,104,50,72,50,201,66,41,75,231,66,
75,83,78,75,53,67,22,59,86,67,18,59,153,67,30,84,
30,84,30,84,30,84,30,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,92,30,84,30,84,30,84,62,92,62,92,30,84,30,84,
62,84,62,84,62,92,62,92,62,84,30,84,62,84,62,92,
30,84,62,84,62,92,62,92,62,92,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,84,62,84,62,92,62,92,
62,92,62,92,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,92,62,92,62,84,29,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,84,29,84,29,84,62,84,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
61,92,61,92,61,92,61,92,61,92,61,92,62,92,62,92,
195,33,195,33,228,41,66,25,130,33,228,41,163,25,33,9,
97,17,162,17,134,66,73,91,165,50,35,34,35,42,132,50,
230,58,133,58,68,50,133,50,133,42,36,26,131,25,225,16,
161,8,97,8,161,16,225,24,97,33,164,58,197,50,2,26,
100,34,131,34,66,26,163,42,131,34,229,50,35,34,194,17,
1,26,196,50,229,58,226,25,32,9,163,25,227,33,33,9,
194,25,100,34,65,9,32,17,227,25,161,25,198,74,229,58,
35,42,36,42,101,58,229,50,230,58,11,84,162,33,193,16,
103,75,168,83,103,75,6,59,132,50,4,50,34,25,193,24,
193,8,2,17,193,8,1,17,66,25,33,25,228,49,200,74,
6,75,165,58,198,58,2,34,102,75,167,83,67,42,166,58,
138,83,235,91,48,133,142,108,238,116,78,141,70,75,198,66,
229,66,72,75,100,42,3,34,133,50,165,58,230,66,166,66,
100,42,101,42,4,42,130,25,34,25,68,41,133,57,101,57,
7,58,165,41,163,41,130,33,162,33,36,50,102,58,167,66,
198,66,198,66,230,66,198,58,197,58,6,59,104,75,137,75,
232,91,199,83,167,83,42,100,233,91,39,75,230,58,40,67,
74,83,200,66,167,58,135,58,5,42,34,17,2,17,132,33,
37,50,103,66,168,74,135,50,37,42,131,33,67,33,164,33,
5,50,196,41,165,41,234,90,137,74,164,41,229,49,69,50,
165,66,133,58,134,58,200,66,164,33,164,33,232,74,167,58,
39,67,198,50,101,34,131,17,66,17,163,25,4,34,33,17,
5,50,136,66,34,17,66,25,37,50,167,58,69,42,134,42,
41,67,138,75,8,59,68,34,35,34,231,58,232,58,70,42,
103,58,135,58,204,91,45,100,106,75,142,108,12,100,73,75,
6,50,5,50,38,50,70,50,38,50,164,33,35,25,194,8,
193,8,226,16,35,25,100,33,68,33,68,33,68,33,3,25,
194,16,226,16,35,17,164,33,70,50,168,66,168,66,6,50,
229,41,38,50,70,50,103,58,135,58,70,50,5,50,5,50,
229,41,38,50,70,50,103,50,38,50,229,41,197,33,38,50,
5,42,164,33,165,33,6,50,6,50,70,58,232,66,73,83,
199,66,69,50,5,42,6,50,39,58,104,58,71,58,71,58,
164,33,200,74,167,66,228,41,3,42,133,58,134,58,4,42,
228,33,5,42,229,41,196,33,5,42,5,42,5,42,70,50,
38,50,71,58,201,74,200,74,232,74,41,75,168,66,40,50,
103,58,135,58,167,66,199,66,231,74,199,74,200,74,200,74,
200,66,8,67,8,67,167,58,105,75,235,91,41,75,70,42,
69,42,196,33,71,50,40,50,40,50,201,66,200,74,8,75,
11,75,15,67,120,67,85,67,116,75,18,59,155,75,62,84,
30,84,30,84,30,84,30,84,30,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,76,30,76,30,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,84,62,84,62,84,
62,92,62,92,62,92,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,92,62,92,62,92,62,84,30,84,30,84,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,62,92,62,92,30,84,
62,92,62,92,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,92,62,92,62,84,62,84,62,84,62,92,
30,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,30,84,62,84,62,84,62,92,62,92,62,84,29,84,
62,92,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,29,84,29,84,62,84,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,62,92,62,92,62,92,
163,33,34,17,68,25,99,25,163,33,130,25,98,25,99,25,
130,25,3,34,36,42,166,66,194,17,226,25,4,50,134,58,
166,66,68,50,35,34,68,34,35,34,227,25,195,25,99,25,
226,16,194,16,194,24,161,16,65,33,165,66,132,50,226,25,
99,34,131,34,196,42,196,42,99,34,99,34,3,34,195,25,
225,17,99,42,34,34,226,25,3,34,162,25,98,17,98,17,
66,26,164,34,96,9,163,33,36,42,194,33,165,66,100,50,
162,25,68,50,227,49,35,34,72,75,231,50,225,16,161,24,
198,58,229,58,5,59,5,59,35,42,4,42,34,25,193,16,
193,8,225,16,193,8,226,16,225,16,192,16,131,41,5,58,
133,58,166,66,68,50,71,75,38,75,164,58,231,66,167,66,
171,83,238,124,11,92,175,116,238,124,208,149,139,116,165,58,
6,75,166,58,198,58,40,67,197,58,128,25,129,25,101,66,
68,34,165,50,36,34,130,25,131,33,132,41,133,49,133,57,
164,41,5,50,69,50,133,50,198,58,133,58,3,42,227,33,
69,50,37,42,69,50,166,58,166,58,165,50,198,58,39,75,
37,75,37,75,37,75,71,75,230,66,198,58,199,58,199,58,
38,58,38,50,70,50,38,42,70,50,228,33,131,33,99,33,
34,25,5,58,10,91,200,66,5,42,67,33,100,33,164,33,
196,41,229,41,6,50,238,115,141,107,6,50,196,41,101,58,
166,66,69,50,33,17,34,17,164,33,229,33,134,58,195,25,
36,42,235,83,41,59,38,34,227,33,39,67,10,84,165,42,
167,50,41,75,37,50,33,17,130,25,167,58,199,58,101,42,
106,67,138,75,7,51,169,75,169,75,105,67,236,91,70,42,
232,74,232,66,102,50,74,75,37,34,167,50,41,75,4,34,
164,41,229,49,70,58,37,50,131,33,193,8,129,8,227,16,
2,17,67,25,100,33,68,33,226,24,162,16,162,16,64,8,
162,16,3,25,164,41,38,50,135,66,168,66,38,50,132,25,
67,25,229,41,70,50,168,58,135,58,5,42,196,33,196,33,
37,50,167,66,167,58,37,50,229,41,5,42,6,42,38,50,
70,50,196,33,197,41,38,50,38,50,135,58,9,75,9,75,
167,58,70,50,229,41,229,41,71,50,38,50,164,33,164,33,
98,25,200,66,167,58,163,33,228,33,102,58,69,50,195,33,
131,25,131,25,164,33,196,33,197,33,5,42,70,50,136,58,
70,50,71,50,234,74,233,74,168,66,9,75,201,66,39,50,
103,58,135,58,167,66,167,66,199,74,8,83,8,83,199,74,
233,74,167,58,70,42,135,50,138,83,139,83,8,67,69,42,
231,33,166,25,198,33,198,33,71,50,168,66,168,66,9,83,
170,74,241,66,154,75,53,59,18,59,211,58,190,83,95,84,
30,84,30,84,30,76,30,76,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,63,84,63,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,92,62,84,62,84,30,84,62,84,62,92,
30,84,30,84,30,84,30,84,62,92,62,92,62,92,30,84,
62,92,62,92,62,92,62,92,30,84,30,84,30,84,30,84,
62,84,62,92,62,92,62,92,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,92,30,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,84,62,84,62,84,62,92,
30,84,62,84,62,84,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,84,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,62,92,62,92,62,92,62,92,
197,49,3,25,194,8,35,17,98,17,224,0,66,17,67,17,
97,17,35,34,194,33,35,42,2,18,162,17,5,58,200,74,
231,74,68,42,225,17,2,18,194,17,97,17,98,17,98,9,
226,16,97,8,97,16,128,16,66,41,68,58,226,33,100,42,
99,34,99,34,5,59,164,42,67,34,226,33,36,42,195,33,
100,34,198,50,194,17,129,17,227,33,65,9,0,9,131,25,
228,42,196,34,161,17,195,33,162,25,98,25,195,49,2,42,
130,25,68,58,195,41,195,41,201,83,33,9,161,8,35,49,
73,75,165,50,164,50,229,58,194,25,130,25,34,25,68,25,
226,16,161,8,225,16,225,16,160,16,192,16,225,24,34,33,
136,66,231,74,137,91,71,75,166,58,102,50,167,66,73,83,
109,108,43,100,137,75,77,100,141,108,142,141,77,141,137,91,
71,83,133,58,8,67,166,58,100,50,132,58,36,50,232,82,
72,75,7,67,35,34,227,25,102,50,37,42,197,41,6,58,
4,42,36,42,133,50,38,67,103,75,71,67,6,59,100,50,
69,50,102,58,36,42,4,42,133,58,231,66,39,75,104,83,
38,75,200,99,201,99,103,83,165,58,7,75,72,83,166,58,
38,58,104,66,168,66,168,58,200,66,102,50,135,58,200,74,
228,49,38,66,233,90,103,58,164,33,100,33,197,49,197,41,
102,50,37,42,229,41,141,99,108,91,168,66,167,58,199,66,
134,66,8,75,38,50,197,33,38,42,196,33,167,58,167,58,
163,33,167,50,9,59,103,42,4,34,38,51,170,92,134,59,
102,42,36,34,4,42,98,25,33,17,163,33,101,50,68,42,
138,67,76,84,202,75,230,50,40,59,170,75,167,42,70,34,
130,33,4,42,37,42,228,33,130,17,228,33,195,33,196,41,
67,33,100,33,132,33,99,25,2,17,161,8,162,8,4,25,
131,33,196,41,132,33,2,25,97,8,64,8,130,16,97,16,
194,24,132,41,71,66,102,58,134,58,167,58,5,42,131,25,
99,33,229,49,6,50,103,50,103,50,196,33,131,25,196,33,
37,50,69,50,5,42,228,41,5,42,5,42,70,50,136,58,
232,66,70,50,229,41,229,41,229,41,135,66,233,74,135,58,
135,58,135,58,6,42,6,42,168,66,168,66,229,41,131,25,
70,50,171,91,233,74,196,33,229,33,5,42,195,33,227,41,
196,41,164,33,196,41,5,42,196,33,229,41,38,50,38,50,
37,42,196,33,71,50,168,58,168,58,200,66,167,66,200,66,
135,58,135,58,102,58,102,58,200,74,73,83,73,91,231,74,
168,66,200,66,102,50,167,58,41,75,167,58,134,50,228,33,
169,33,107,58,231,33,164,33,70,50,135,58,169,74,202,74,
169,74,242,66,221,83,86,59,19,67,23,75,255,91,61,76,
30,84,30,84,30,76,30,76,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,76,30,76,30,76,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,62,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,63,84,63,84,63,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,63,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,30,84,30,84,62,84,62,84,62,92,
62,92,62,92,62,92,62,92,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,62,84,62,92,62,92,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,92,62,92,62,92,30,84,
30,84,62,92,62,92,62,92,30,84,30,84,30,84,62,92,
62,84,62,92,62,92,62,92,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,84,
30,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,30,84,30,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,84,62,84,62,84,62,92,
30,84,62,84,62,84,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,62,92,62,92,62,92,62,92,
163,33,33,17,160,0,161,8,226,16,226,16,225,16,67,25,
162,25,97,9,194,25,228,33,99,33,67,33,69,66,72,91,
69,42,162,25,129,17,226,25,132,34,132,34,226,25,130,25,
66,25,225,16,160,8,66,25,195,41,130,33,98,33,228,49,
162,33,194,33,3,42,4,50,66,25,131,33,163,41,36,50,
164,34,164,34,131,17,194,8,1,25,224,16,2,9,226,25,
131,34,226,17,98,9,228,33,130,33,162,33,195,25,130,9,
36,41,66,41,161,41,165,58,228,33,194,16,101,41,104,74,
45,92,167,50,198,50,197,50,34,34,226,33,37,50,99,25,
1,17,225,16,161,16,161,16,161,16,96,8,96,8,35,25,
73,83,72,75,137,83,36,50,3,50,133,50,231,66,170,99,
109,100,137,75,105,75,138,83,141,116,140,116,45,133,40,100,
232,82,134,58,198,58,100,42,227,25,167,74,200,98,205,147,
47,124,229,41,163,25,36,42,36,50,228,41,37,50,70,50,
68,42,133,50,100,50,133,58,230,66,198,66,166,58,166,58,
132,50,100,50,101,50,69,50,37,50,4,50,68,58,40,91,
231,107,167,99,71,83,104,83,72,83,198,74,104,83,7,67,
133,66,68,58,102,58,167,66,168,66,135,66,70,58,38,58,
232,66,200,66,167,58,69,50,4,42,102,58,102,58,131,33,
69,58,134,58,102,50,134,50,69,42,134,50,133,58,198,66,
134,58,198,66,231,58,134,42,165,42,229,50,6,67,69,42,
36,42,228,25,135,50,204,83,9,59,201,58,167,50,233,66,
165,34,133,42,163,33,34,25,2,25,132,33,131,25,130,25,
37,34,106,83,178,165,167,74,227,33,203,83,9,59,103,42,
36,25,132,33,229,41,33,17,228,33,103,50,71,50,230,41,
67,17,3,25,97,8,162,8,162,8,65,16,97,16,68,33,
6,34,36,41,134,57,169,74,162,16,66,32,33,24,68,25,
6,50,103,58,102,50,166,58,199,66,102,58,5,50,68,25,
230,49,164,41,163,33,37,50,200,66,102,50,5,42,230,41,
229,41,5,50,71,58,39,50,38,50,70,50,135,58,70,50,
199,66,37,50,37,42,69,50,102,50,135,58,135,58,168,58,
168,66,168,66,37,42,37,42,200,66,233,66,168,66,103,58,
168,66,200,58,168,50,135,42,163,25,165,25,9,34,230,25,
102,33,100,33,164,33,5,42,37,42,4,42,196,33,101,33,
228,41,196,33,38,50,136,58,103,58,103,58,200,66,232,74,
6,42,38,50,38,58,135,66,199,74,8,83,106,91,73,83,
167,66,200,74,102,58,196,33,196,33,70,50,135,58,37,42,
234,33,140,58,6,34,4,34,198,33,138,58,234,74,138,58,
9,67,208,66,89,83,151,75,243,42,156,67,63,84,61,76,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,92,
30,84,30,84,62,84,62,84,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,62,92,62,92,62,92,62,92,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,30,84,30,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,61,92,61,92,61,84,61,84,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,62,92,62,92,30,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,62,92,62,92,94,92,94,92,62,92,62,92,61,92,
132,33,226,16,161,8,194,8,194,8,194,16,226,16,225,16,
33,17,97,17,130,25,98,25,225,16,226,24,98,33,195,41,
98,9,130,25,227,33,68,42,165,50,165,42,3,34,130,25,
1,17,1,17,34,17,99,25,130,33,65,17,0,17,66,25,
130,33,69,58,134,74,37,58,225,24,192,16,32,25,68,58,
3,34,67,42,130,25,161,8,128,8,0,17,163,25,34,26,
196,42,226,17,130,9,195,25,66,17,131,33,228,33,98,9,
130,16,35,41,69,66,100,50,66,17,194,16,35,33,167,66,
232,58,134,42,39,67,6,67,194,25,35,42,195,33,131,33,
102,58,131,33,2,25,96,8,64,8,161,16,161,16,100,33,
134,58,166,58,227,33,3,42,100,50,101,58,199,66,142,116,
77,100,170,83,170,83,202,83,43,100,10,100,171,116,232,91,
70,58,101,50,198,58,132,42,35,34,163,41,233,106,116,197,
17,157,232,74,195,33,194,33,68,50,165,66,230,66,166,58,
6,75,71,75,6,75,197,66,230,74,6,75,230,74,165,58,
102,50,134,58,69,50,4,42,36,50,165,66,39,83,136,99,
197,66,68,50,68,42,166,58,198,66,165,66,39,75,40,75,
8,75,134,58,232,66,41,75,167,58,69,50,102,50,167,66,
42,75,233,74,200,66,70,50,229,41,164,33,100,33,67,25,
70,58,135,58,200,66,168,58,102,50,69,42,69,50,102,58,
166,58,100,50,169,83,8,59,198,50,42,92,169,83,37,42,
40,67,231,58,166,50,105,67,203,83,12,92,41,67,166,50,
166,42,8,59,233,66,35,17,161,8,132,33,132,25,66,17,
228,25,70,50,73,91,166,58,227,33,36,26,98,9,197,25,
100,25,164,33,98,25,102,50,166,58,9,67,143,116,140,83,
196,33,226,24,129,16,161,8,129,0,194,16,194,24,34,25,
100,25,226,24,201,82,118,174,38,34,96,8,68,41,230,49,
201,74,103,58,167,66,167,58,167,58,102,58,197,41,132,33,
6,50,132,33,163,25,167,58,171,91,106,83,233,66,6,42,
38,50,6,50,197,41,197,41,38,50,197,33,99,25,164,33,
5,42,5,42,5,42,167,58,199,66,70,50,102,50,37,50,
102,58,167,66,134,58,167,58,9,75,9,75,233,74,200,66,
167,66,198,58,72,67,105,75,163,25,169,33,179,66,16,50,
136,25,68,25,164,33,6,50,6,42,196,33,163,33,197,41,
229,41,70,50,135,58,136,58,136,58,103,58,102,50,69,50,
6,42,136,66,233,74,41,83,73,91,9,75,9,75,41,75,
135,66,135,58,70,50,131,33,131,25,102,50,167,58,70,50,
136,50,7,42,39,42,104,58,6,42,169,58,169,58,106,50,
234,66,13,75,243,66,21,59,119,67,30,84,63,84,61,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,84,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,92,
62,84,30,84,30,84,62,84,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,92,62,92,62,92,62,92,62,92,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,61,92,61,92,61,92,61,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,62,92,62,92,94,92,94,92,62,92,62,92,61,92,
165,41,68,33,194,16,129,8,162,8,194,8,193,8,193,16,
34,17,34,17,1,9,2,9,2,17,162,16,225,16,98,25,
228,33,195,33,195,33,227,33,194,25,162,25,66,17,66,25,
34,17,225,8,225,8,66,17,98,25,33,9,224,8,225,8,
34,41,38,74,10,99,201,90,68,41,225,16,97,33,197,74,
35,50,165,66,130,33,128,8,224,16,130,25,100,42,227,42,
2,26,193,17,161,9,162,17,34,17,99,33,99,25,224,8,
161,8,67,41,5,58,131,33,161,8,161,16,192,16,4,42,
130,17,36,34,231,58,101,50,162,25,100,50,68,50,36,42,
228,41,66,25,1,17,161,16,193,16,34,25,34,25,131,33,
134,50,69,58,199,74,44,108,165,58,228,49,171,99,174,124,
134,50,170,83,11,92,201,83,201,83,135,83,168,83,136,83,
37,50,231,66,169,83,164,50,34,42,130,41,107,123,210,180,
208,156,13,124,8,83,134,58,36,50,68,50,132,50,131,50,
132,50,6,67,72,83,7,75,36,50,195,41,228,41,4,42,
38,50,38,50,4,42,68,50,229,66,167,91,135,91,130,50,
227,33,228,33,102,42,102,50,101,58,166,66,40,75,7,67,
169,66,104,58,169,66,201,66,103,58,6,42,38,50,135,66,
102,50,4,42,228,41,228,41,196,33,131,33,34,25,99,33,
132,33,164,33,168,66,42,75,74,83,200,66,233,66,168,66,
199,66,105,83,76,100,231,50,161,17,229,50,38,67,102,42,
68,34,132,42,72,67,174,108,105,67,8,51,8,59,68,34,
69,34,135,42,42,75,67,17,100,25,230,41,99,25,131,25,
4,34,163,25,101,50,137,83,231,58,166,50,69,34,99,9,
99,25,196,33,131,25,199,58,138,83,231,58,204,83,208,116,
71,50,2,17,225,16,132,25,1,9,66,25,196,41,195,25,
200,66,233,82,135,58,80,117,202,67,195,25,200,74,203,91,
71,58,5,50,167,66,199,66,167,58,37,42,229,41,38,50,
197,33,132,25,196,25,41,75,44,100,73,75,168,58,136,50,
196,41,164,33,132,33,197,41,71,50,164,33,99,25,5,42,
71,50,5,42,228,33,5,42,167,66,102,50,37,50,69,50,
134,58,167,66,199,66,73,83,41,75,102,50,70,50,135,58,
136,58,232,66,167,50,40,67,4,34,104,25,240,41,81,50,
234,33,133,25,229,41,229,41,166,33,6,42,102,50,199,66,
168,66,9,75,233,74,135,58,38,50,5,42,70,50,200,66,
103,58,103,58,135,58,200,66,232,74,232,74,9,75,73,83,
8,75,167,66,167,66,102,58,38,50,103,58,70,50,5,42,
137,50,39,42,39,50,103,58,4,42,72,50,44,42,79,50,
171,66,170,58,178,58,121,75,29,84,95,92,254,75,223,83,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,30,84,30,84,30,84,
62,92,62,92,62,92,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,30,84,62,84,62,92,62,92,62,92,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,61,92,61,92,61,92,61,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
100,33,67,25,2,17,227,16,227,16,162,16,98,8,98,8,
226,24,2,17,224,8,1,9,35,25,193,8,225,8,196,33,
196,33,66,17,0,9,32,9,65,17,33,17,1,17,34,25,
66,25,225,16,161,8,225,16,33,17,33,17,33,17,1,9,
193,32,161,32,68,49,133,49,194,24,33,25,35,50,5,67,
230,74,71,83,36,42,33,17,33,17,130,25,132,42,4,43,
65,9,35,34,99,34,162,17,225,8,162,8,161,8,192,16,
3,17,35,33,226,32,193,16,129,8,129,16,1,25,162,25,
162,25,4,42,37,42,98,17,228,33,134,58,7,75,100,50,
97,17,228,41,98,25,196,41,136,74,196,41,66,25,163,33,
228,33,102,58,41,83,166,66,227,33,102,66,236,107,232,66,
9,75,44,100,10,92,200,75,168,75,135,75,38,75,104,83,
232,74,76,108,201,83,66,34,132,50,3,58,103,82,170,106,
75,115,43,99,197,49,99,33,66,25,130,25,35,42,99,42,
3,34,101,50,199,66,102,58,132,33,2,17,67,25,132,25,
131,33,130,33,3,42,39,75,38,83,196,66,196,58,34,42,
3,42,166,58,73,75,199,58,133,58,166,66,166,66,69,50,
37,58,70,66,38,58,5,50,5,58,37,58,70,66,200,82,
70,58,229,41,37,50,102,58,70,58,135,66,102,66,70,58,
228,41,130,33,228,41,69,50,135,58,168,66,10,75,234,66,
167,58,105,75,105,75,73,67,7,59,136,75,39,67,196,25,
162,17,105,75,227,25,232,58,167,50,69,34,8,59,199,58,
70,42,196,25,135,50,196,25,42,75,168,66,99,25,228,41,
69,42,101,42,198,58,11,92,234,83,105,67,41,67,167,50,
37,42,37,42,199,58,134,50,166,50,36,34,8,59,141,100,
229,41,196,33,232,66,203,91,106,75,105,75,40,67,40,67,
72,67,105,83,73,75,76,92,43,84,231,58,76,100,108,92,
132,33,5,50,200,66,9,75,102,58,131,25,5,42,38,50,
165,33,131,25,164,25,135,50,138,83,41,75,135,58,71,50,
228,41,66,17,67,17,197,33,6,42,164,33,6,50,168,66,
103,58,38,50,196,33,228,33,167,66,102,58,166,58,232,74,
4,42,134,58,166,58,40,75,199,66,37,42,200,66,232,74,
74,75,74,75,103,50,135,50,228,33,101,17,168,25,105,50,
171,42,197,25,5,42,230,49,230,41,233,66,8,75,200,66,
168,66,103,58,38,50,38,50,71,50,38,50,70,50,200,66,
37,50,4,42,70,50,167,58,134,58,167,58,41,75,74,83,
232,74,167,66,135,66,167,66,135,66,70,58,70,50,103,58,
76,50,169,58,103,58,103,58,229,41,234,41,146,58,21,67,
174,74,139,50,246,66,222,83,28,76,28,76,30,84,63,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
63,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,30,84,30,84,30,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,92,62,92,62,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,92,62,92,62,92,62,92,
29,84,29,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,84,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
4,34,130,17,66,17,34,17,226,8,162,16,163,16,99,24,
128,8,66,25,98,25,65,17,66,17,1,9,224,8,65,17,
1,9,33,9,130,17,162,25,195,33,195,33,33,25,192,8,
160,8,193,16,162,16,129,8,193,16,99,33,99,33,2,17,
194,32,97,16,129,16,129,16,128,0,130,25,131,42,196,50,
228,58,38,67,38,59,100,42,33,9,98,17,164,50,131,34,
1,9,194,25,100,42,130,25,160,8,65,8,96,8,128,8,
193,8,193,16,97,16,162,16,162,16,194,24,196,49,35,42,
4,42,228,41,98,25,160,0,228,41,134,58,166,58,226,33,
166,58,227,33,98,25,196,41,132,33,34,25,131,33,98,25,
228,49,37,42,69,50,130,33,69,58,40,75,41,75,167,66,
13,100,171,91,136,75,233,83,103,75,135,75,136,83,234,99,
44,100,169,83,165,50,67,42,35,50,227,49,197,65,6,82,
103,90,10,99,5,50,229,41,228,41,36,42,198,58,196,50,
166,50,134,42,37,34,5,34,6,42,230,41,196,33,132,25,
3,50,230,74,104,91,38,75,35,42,3,42,166,58,102,50,
101,58,232,66,166,58,3,42,67,58,164,74,197,82,197,74,
4,83,134,99,231,107,8,116,106,132,106,124,168,107,103,99,
6,83,197,66,5,75,134,91,198,99,137,124,137,124,137,124,
10,108,104,91,165,66,101,58,101,50,9,75,9,75,104,50,
9,75,199,58,73,75,236,91,105,75,136,75,7,59,196,25,
98,25,196,33,131,25,131,25,229,25,103,42,139,83,73,75,
195,25,162,17,8,67,41,75,142,116,106,83,36,42,101,50,
106,83,4,34,227,25,165,42,231,58,199,50,170,83,45,100,
73,75,199,58,133,42,166,50,7,59,231,50,169,75,76,92,
163,25,37,34,105,75,73,67,138,75,11,92,101,34,101,42,
101,42,231,66,73,83,40,67,39,59,137,75,39,67,104,67,
38,50,102,50,102,50,134,58,4,42,163,33,38,42,229,33,
164,41,132,33,5,42,228,41,102,50,200,66,71,50,196,33,
102,50,131,25,131,25,196,33,6,42,6,50,103,58,135,58,
103,58,38,50,5,42,134,58,167,66,101,50,231,66,134,58,
68,50,7,67,133,50,134,50,102,50,166,58,139,91,41,75,
198,58,138,83,71,50,164,25,102,50,103,50,39,42,138,83,
236,75,135,50,229,41,101,33,164,33,69,50,4,42,230,41,
103,58,229,41,229,41,135,58,233,74,200,66,168,58,168,66,
167,66,199,66,9,75,9,75,168,66,167,66,9,75,232,74,
232,74,73,83,199,66,167,66,135,58,197,41,230,41,6,50,
41,42,197,33,7,50,139,66,41,50,44,50,145,58,177,50,
110,50,177,58,120,75,219,75,252,75,28,76,59,76,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
63,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,62,84,62,84,62,92,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,30,84,30,84,30,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,92,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,92,62,92,62,84,30,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,62,92,62,92,62,92,62,92,
29,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,61,92,61,92,61,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
165,50,165,50,3,26,195,25,229,41,100,33,162,16,130,16,
225,16,162,33,194,25,129,17,163,25,163,25,33,9,224,0,
192,0,33,9,195,25,3,34,227,33,195,33,98,25,98,17,
225,16,193,8,97,8,129,16,226,24,67,41,67,33,2,25,
96,8,129,16,129,8,128,0,65,17,132,42,228,50,196,42,
164,42,38,59,166,67,164,42,0,1,1,9,195,33,64,17,
225,16,225,8,163,33,34,25,96,8,97,16,161,16,96,8,
128,0,96,8,129,16,161,16,194,16,35,41,196,49,4,42,
196,41,99,33,1,17,1,17,37,50,8,75,134,58,36,42,
166,58,195,33,33,17,1,17,67,33,34,25,225,8,98,25,
38,58,163,25,130,25,195,49,199,82,236,107,8,75,232,82,
77,108,170,83,39,75,136,83,38,67,103,75,169,83,43,100,
105,75,198,58,128,17,161,25,194,33,162,41,131,49,201,98,
134,90,236,123,203,107,105,91,7,75,71,75,9,92,41,92,
234,83,104,67,198,50,69,42,4,34,163,25,194,25,68,42,
70,83,38,83,197,66,165,58,227,41,130,25,38,42,135,58,
5,50,135,66,134,58,133,58,232,107,202,140,11,149,202,132,
10,133,169,124,169,124,72,116,198,99,134,91,228,66,131,50,
168,74,37,50,228,41,69,58,7,83,201,107,104,91,168,99,
168,91,75,116,204,132,140,124,7,75,166,66,135,58,168,58,
41,75,134,58,69,42,41,75,8,67,230,58,198,58,131,17,
132,33,34,17,67,25,6,42,132,25,140,91,168,58,200,66,
166,58,39,67,11,100,73,83,73,75,8,67,199,58,101,42,
195,25,97,9,101,42,68,34,36,34,232,66,110,108,207,116,
166,42,40,59,69,34,199,58,137,83,39,67,7,59,141,100,
70,50,231,58,105,67,8,59,166,50,231,50,69,34,4,34,
130,33,69,50,73,75,105,75,133,42,206,116,137,83,72,75,
203,83,232,58,228,33,164,33,99,25,228,41,131,25,34,17,
132,41,164,41,229,41,197,41,38,42,229,41,103,58,172,99,
105,83,232,66,102,50,228,33,5,42,5,42,37,50,70,50,
136,58,229,33,41,75,9,75,228,33,4,42,5,42,4,42,
137,83,72,83,165,50,7,67,40,75,8,67,171,91,139,91,
167,50,37,42,229,41,196,33,37,42,38,34,39,34,69,42,
197,50,101,42,198,41,69,25,68,25,98,17,2,9,102,33,
165,33,197,33,38,50,103,58,103,58,70,50,38,50,70,50,
70,58,167,66,200,66,200,66,232,66,9,75,8,75,73,83,
41,83,170,99,200,74,200,66,71,58,100,25,165,33,230,41,
229,33,230,41,171,66,203,66,168,58,202,66,141,50,111,50,
210,58,87,75,119,75,117,59,254,83,221,75,215,67,60,84,
30,84,30,84,62,84,62,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,63,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,30,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,62,84,62,84,62,92,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,30,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,30,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,61,92,61,92,61,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
35,34,198,58,197,50,165,50,7,67,69,42,225,8,128,0,
67,25,130,25,162,17,194,17,227,25,196,33,130,25,32,9,
131,25,162,25,3,26,35,34,3,34,194,33,195,25,36,34,
228,33,2,17,96,0,193,16,67,33,2,33,161,16,161,16,
161,16,162,16,129,8,192,8,194,33,164,50,196,42,164,34,
34,34,197,50,133,67,162,42,1,9,193,8,225,16,128,8,
128,16,96,8,161,16,96,16,193,32,193,32,64,8,129,8,
161,8,96,8,129,16,96,0,161,16,226,32,2,33,66,25,
226,24,193,16,1,17,66,25,5,42,135,58,102,50,102,50,
36,42,98,25,66,25,192,8,193,16,67,33,34,17,66,25,
163,33,66,25,65,25,4,50,167,74,200,74,167,66,143,124,
44,100,169,83,231,66,6,75,38,75,169,91,201,83,43,92,
104,83,165,58,162,25,195,33,33,25,1,25,66,33,229,57,
134,82,105,99,201,99,71,75,38,75,71,75,71,67,38,59,
68,34,227,25,163,25,65,17,0,17,97,25,67,50,70,83,
35,50,194,33,162,33,195,33,228,41,164,33,5,42,135,58,
166,66,40,75,169,91,136,91,41,108,73,116,134,91,195,58,
99,50,67,42,164,66,197,74,131,58,100,50,132,58,132,50,
135,66,5,50,195,41,68,50,166,66,72,83,133,58,166,66,
137,83,39,75,39,83,169,99,10,108,11,108,8,75,227,33,
135,58,8,75,69,50,5,42,232,66,7,67,166,50,164,25,
34,17,66,17,34,17,34,9,66,9,228,25,200,58,102,42,
198,58,40,75,138,91,232,74,199,66,236,91,77,92,9,51,
163,25,134,50,134,42,130,17,163,33,41,75,175,116,17,125,
230,42,170,75,203,83,199,58,101,50,227,33,100,42,137,75,
74,83,202,75,40,51,73,67,203,83,12,84,139,75,201,66,
131,25,131,25,167,58,232,66,199,66,105,83,199,58,231,66,
170,75,40,59,37,34,102,50,5,42,70,50,131,25,98,25,
164,41,197,41,38,50,9,75,42,75,229,33,70,50,204,99,
76,108,108,108,170,91,166,58,167,58,102,58,70,50,102,58,
196,33,228,41,77,116,12,108,37,50,70,50,196,33,70,50,
201,91,39,75,6,67,72,67,73,75,231,66,167,58,232,66,
74,67,38,42,197,41,5,50,231,66,37,34,230,33,69,42,
228,33,228,33,165,33,70,25,37,17,3,9,36,17,233,49,
100,25,230,41,70,50,38,50,5,42,229,41,197,33,197,33,
197,41,103,66,201,74,200,66,9,75,9,75,232,74,73,83,
105,91,105,91,167,66,167,66,229,41,3,17,133,33,198,41,
164,33,138,66,78,83,170,58,136,50,200,58,170,58,240,74,
81,67,148,83,82,75,49,67,217,91,152,75,82,59,216,75,
29,76,29,84,62,84,62,84,30,84,30,84,30,84,31,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,63,84,63,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,30,84,30,84,62,84,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,94,92,94,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,61,92,61,92,61,92,61,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
94,92,62,92,62,92,61,92,61,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
93,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,61,92,61,92,62,92,62,92,62,92,
36,42,36,42,100,34,67,26,1,18,67,34,68,34,194,25,
193,8,66,17,195,17,227,17,130,9,66,17,66,17,66,9,
33,17,129,17,2,26,2,26,2,26,2,34,194,25,194,17,
195,25,66,9,161,8,2,25,99,41,1,25,160,8,161,8,
161,16,129,16,2,17,66,25,161,25,225,25,34,26,165,42,
226,33,100,42,198,83,69,67,66,25,162,16,161,16,65,8,
64,8,129,16,32,8,129,24,10,115,168,90,128,16,162,8,
226,16,162,16,97,8,64,0,160,8,96,16,161,24,226,16,
194,24,194,16,34,25,1,17,196,33,66,17,37,42,38,42,
195,33,130,25,99,33,1,17,193,16,100,33,196,41,66,25,
33,17,1,25,98,33,163,33,69,50,102,66,42,91,77,116,
39,59,198,50,230,66,72,83,230,74,39,75,104,75,136,75,
39,75,100,50,97,25,228,41,5,50,164,41,228,49,70,66,
70,74,134,66,72,83,165,58,36,42,3,34,163,17,195,17,
99,17,34,9,2,17,193,8,34,25,101,66,133,66,193,41,
227,33,98,25,163,33,70,50,135,58,4,42,4,42,231,74,
74,108,168,83,200,83,37,67,163,58,163,58,100,50,198,58,
69,58,195,41,227,49,68,66,198,82,39,91,7,83,166,66,
165,66,165,66,230,74,39,83,197,66,39,83,133,58,133,58,
167,58,167,58,198,66,68,58,6,83,169,99,137,99,100,58,
66,17,232,74,171,99,38,50,232,74,137,83,36,42,164,25,
37,42,4,42,37,42,9,67,69,34,69,34,4,26,133,42,
166,50,8,75,105,91,73,83,41,83,111,108,208,108,237,67,
102,42,232,58,199,58,200,66,164,33,228,41,41,75,203,83,
43,76,105,59,73,67,69,42,202,91,40,75,234,91,39,67,
106,83,76,92,7,51,162,17,41,67,12,84,201,58,15,116,
49,125,196,25,5,42,42,99,53,190,106,91,40,67,166,42,
7,43,138,67,41,67,45,108,42,75,103,58,196,33,228,41,
196,33,229,41,168,58,74,75,135,50,229,33,233,66,200,58,
165,58,72,75,105,83,40,75,171,91,74,91,167,66,37,50,
4,42,102,50,134,58,167,58,130,25,196,33,70,50,200,66,
6,67,104,83,201,91,230,58,231,58,138,83,199,66,134,58,
104,67,100,42,196,41,5,50,7,75,37,34,169,58,73,75,
230,41,35,17,36,17,201,41,10,42,167,25,167,33,74,66,
7,50,136,58,70,50,196,33,196,33,196,33,132,33,229,41,
38,58,38,58,71,58,103,58,200,66,232,74,166,66,166,66,
231,74,8,75,200,74,168,66,229,41,132,33,198,41,133,33,
165,33,42,50,172,66,13,67,238,66,236,66,234,74,106,58,
107,67,137,67,235,58,74,42,171,58,237,58,47,59,82,67,
253,75,29,84,62,84,62,84,30,84,30,84,30,84,63,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,63,84,63,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,30,84,30,84,62,84,62,84,
62,92,62,84,62,84,62,84,30,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,30,84,62,84,62,84,62,92,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,30,84,30,84,62,84,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,30,84,30,84,30,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,84,62,84,62,84,94,92,94,92,94,92,62,92,
62,92,62,92,94,92,94,92,62,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,84,62,92,62,92,62,92,
62,92,61,92,61,92,61,92,61,92,61,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,94,92,94,92,94,92,94,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
94,92,94,92,62,92,61,92,61,92,62,92,94,92,94,92,
62,92,62,92,62,92,94,92,94,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,61,92,61,92,62,92,62,92,62,92,
71,67,132,42,225,25,1,26,131,42,228,50,4,51,228,50,
36,34,65,9,131,25,66,17,99,25,132,25,225,8,225,8,
2,17,225,8,98,17,163,33,99,25,34,17,34,17,98,17,
225,16,225,16,193,16,194,16,193,8,193,16,225,16,224,16,
1,9,33,9,195,25,226,25,96,9,162,17,227,25,195,25,
100,50,38,67,70,75,228,58,2,26,100,42,133,50,193,17,
129,8,129,8,129,16,2,41,135,82,166,74,162,25,100,42,
6,51,36,34,225,8,65,8,66,16,65,16,97,16,96,16,
1,17,99,33,1,17,2,17,34,17,66,17,228,33,4,34,
2,17,34,25,193,24,66,33,164,41,195,33,228,41,163,33,
164,33,5,50,37,58,5,50,4,50,105,83,201,91,38,67,
227,41,36,42,105,83,230,66,197,66,6,75,7,75,8,67,
229,66,72,83,36,42,228,41,70,58,107,99,200,74,229,49,
228,33,36,50,133,58,198,66,102,50,5,34,99,17,34,17,
2,17,192,8,0,9,162,33,35,50,194,41,130,33,163,41,
67,74,167,82,195,41,203,124,106,108,37,42,39,42,166,58,
136,83,197,58,68,42,105,83,198,66,7,75,133,50,230,66,
101,66,71,91,233,107,5,75,197,66,40,83,170,99,231,74,
231,82,170,107,137,99,7,75,72,83,105,91,166,66,4,42,
36,42,105,83,202,99,72,83,7,75,230,66,8,75,199,66,
197,33,171,91,138,91,231,66,105,75,170,83,138,75,171,75,
139,92,103,67,72,75,105,75,198,42,7,51,105,75,167,74,
10,75,139,91,41,83,137,91,202,99,231,66,105,67,73,59,
39,67,69,50,135,50,73,75,102,58,231,66,105,67,69,42,
8,51,101,50,101,34,41,75,48,125,11,76,203,83,11,84,
44,108,179,157,167,58,4,42,167,58,134,50,167,58,236,91,
206,116,73,67,166,50,109,108,52,166,106,83,73,75,232,66,
166,50,198,58,72,75,19,166,44,100,4,34,5,42,164,33,
164,25,197,33,165,33,230,41,229,41,196,33,6,42,6,42,
39,50,71,58,200,66,73,83,170,91,141,116,234,99,165,58,
69,50,70,50,103,50,167,58,228,33,195,33,198,66,201,99,
231,58,39,67,104,75,10,92,39,67,166,50,170,83,204,91,
169,67,7,51,37,34,165,33,136,58,167,58,133,42,230,50,
163,33,230,49,39,50,76,42,109,42,105,50,202,66,70,42,
71,50,136,58,38,50,164,33,131,25,196,33,196,33,38,50,
71,58,229,41,5,42,70,50,103,58,167,58,167,66,102,58,
102,66,200,74,167,66,8,75,167,66,165,33,133,33,167,41,
169,33,10,50,207,99,173,91,43,75,75,83,9,75,166,66,
200,74,200,74,9,83,70,50,233,74,137,66,235,74,12,75,
112,83,215,83,125,92,95,84,63,76,62,76,255,75,93,76,
253,83,253,83,62,84,28,76,95,92,255,75,95,92,61,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,30,84,30,84,30,84,30,84,30,84,30,84,62,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,30,84,30,84,30,84,62,84,62,84,62,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
30,84,62,84,62,84,62,92,62,92,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
30,84,30,84,30,84,62,92,62,92,62,92,62,92,30,84,
62,84,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,92,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,30,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,30,84,62,92,30,84,30,84,30,84,30,84,30,84,
62,92,62,92,62,92,30,84,30,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,84,29,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,29,84,
62,92,62,92,62,92,62,92,30,92,30,92,62,92,62,92,
62,92,62,92,62,92,62,92,30,92,30,92,30,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,94,92,94,92,94,92,94,92,94,92,94,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,61,92,61,92,61,92,61,92,61,92,61,92,29,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
71,67,165,50,164,42,131,42,131,34,228,50,69,59,69,59,
101,50,65,17,66,17,1,9,225,8,1,17,224,8,224,16,
161,16,192,8,33,17,98,25,225,16,96,8,128,8,225,16,
192,8,193,16,193,16,193,16,161,8,161,8,193,8,225,16,
33,9,163,25,228,33,65,17,32,9,97,17,130,17,195,25,
36,42,165,50,164,50,163,50,131,42,164,50,229,58,228,50,
163,33,1,17,99,41,163,49,131,49,134,74,7,75,165,58,
197,50,35,34,33,9,128,8,129,16,129,16,97,16,96,8,
193,8,226,16,225,16,35,25,131,33,196,33,69,50,69,50,
225,8,161,16,193,16,132,41,196,41,130,33,195,33,4,50,
98,25,33,25,196,41,98,25,69,50,44,108,231,66,67,42,
194,41,231,66,40,75,230,66,100,58,168,91,169,91,40,67,
165,58,7,75,102,58,200,74,74,91,163,33,134,58,195,33,
41,75,232,74,68,50,134,58,5,34,132,25,99,17,192,8,
193,8,2,17,163,33,195,33,32,17,0,17,0,17,196,49,
170,132,234,107,198,66,41,100,6,67,5,42,70,50,198,66,
230,74,132,58,133,58,7,75,39,75,39,75,197,58,168,83,
41,91,197,74,197,74,229,74,104,83,199,66,167,66,167,66,
166,74,198,74,72,91,40,83,72,83,137,91,8,75,167,66,
105,83,170,91,72,83,7,75,72,83,7,75,166,66,69,50,
70,50,74,83,232,74,166,58,40,75,203,91,13,100,106,75,
200,75,197,50,231,66,72,75,198,42,166,42,231,66,106,91,
204,99,171,91,106,91,8,75,231,66,231,58,105,75,199,50,
230,58,37,42,204,91,105,67,134,50,72,75,137,67,40,67,
101,42,37,34,134,58,138,83,203,83,231,58,137,75,105,83,
146,149,12,100,69,42,228,33,4,34,167,58,135,50,135,50,
167,50,199,50,69,42,166,50,199,58,134,50,8,75,167,58,
138,83,199,58,166,58,12,100,203,83,199,50,38,42,164,33,
131,25,165,33,68,25,226,16,2,17,1,17,34,17,100,25,
197,41,38,50,168,58,232,66,199,58,7,67,7,75,105,83,
43,108,8,75,37,50,135,58,70,50,101,50,40,75,169,91,
134,50,167,58,199,58,231,66,167,58,73,75,110,116,13,100,
204,108,71,59,130,17,33,9,229,33,233,58,106,67,133,34,
138,91,172,99,199,33,48,42,178,58,106,50,137,58,103,50,
104,58,6,42,164,33,164,33,164,33,196,33,197,33,71,50,
197,41,229,41,38,50,103,50,135,58,135,58,135,58,135,58,
200,74,135,66,102,58,200,74,102,58,230,49,166,41,102,33,
132,25,8,42,204,66,203,58,201,66,42,75,9,75,136,66,
5,42,200,66,10,75,233,66,107,83,38,42,134,58,232,66,
103,50,73,67,114,133,245,116,251,124,157,116,93,100,30,84,
63,84,29,76,30,84,255,91,255,83,253,75,62,76,93,76,
62,84,62,84,62,84,62,84,62,84,62,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,30,84,
30,84,30,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,30,84,30,84,62,92,62,92,62,92,62,92,30,84,
62,84,62,92,62,92,62,84,62,84,62,92,62,92,62,84,
62,92,62,84,62,84,62,84,62,84,62,92,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
30,84,62,92,62,92,62,92,30,84,30,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,30,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,30,92,62,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,94,92,94,92,94,92,94,92,94,92,94,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
165,42,226,25,2,26,34,26,99,34,228,50,69,59,69,59,
35,34,64,9,129,17,129,17,65,17,129,25,227,33,3,42,
98,25,129,25,64,17,224,8,193,16,162,16,161,16,160,8,
192,8,193,16,193,16,193,16,194,16,161,8,161,8,226,16,
33,9,33,17,1,17,225,16,34,25,66,25,98,17,4,34,
4,34,3,34,34,34,164,42,38,59,37,59,69,67,68,67,
38,67,35,42,3,50,35,58,194,41,100,58,104,83,39,75,
229,58,39,67,165,58,130,25,160,8,96,8,128,16,129,16,
128,8,161,16,226,24,226,16,2,25,99,33,131,33,98,25,
34,17,225,16,226,24,2,33,225,16,224,8,66,25,131,33,
163,41,131,33,130,33,228,41,232,74,166,66,97,25,227,41,
232,82,73,91,232,74,166,58,197,66,10,108,75,116,165,58,
36,50,167,66,228,49,70,66,135,74,228,49,105,83,71,75,
167,58,167,66,200,74,103,58,164,33,67,17,225,0,1,17,
225,16,34,25,34,25,1,17,33,25,98,33,33,25,167,74,
104,108,39,67,8,67,137,83,101,50,234,74,233,74,133,58,
11,108,72,83,39,75,136,83,70,75,164,50,71,75,104,83,
134,66,36,58,35,50,164,66,137,91,41,83,8,75,41,91,
232,82,199,82,170,99,105,91,138,91,73,91,9,83,74,91,
41,83,232,74,166,66,166,66,40,83,40,75,8,75,9,83,
9,83,9,83,199,74,166,66,8,75,105,83,73,67,200,50,
6,51,166,50,199,66,232,66,134,42,199,50,167,58,41,91,
40,75,199,66,199,66,101,50,102,50,41,75,170,75,8,59,
166,50,70,42,236,83,142,100,73,67,231,50,170,75,236,99,
204,91,41,67,135,66,106,83,105,75,8,75,39,67,4,50,
207,116,174,116,167,50,228,33,163,25,167,58,70,50,41,75,
232,58,37,42,4,34,102,50,4,34,228,33,37,50,135,58,
13,100,171,83,9,75,41,67,105,75,232,50,233,66,229,41,
67,17,100,25,3,17,194,16,67,25,67,25,2,17,100,25,
38,50,38,50,167,58,9,75,167,58,134,50,134,58,232,74,
237,124,234,99,133,58,134,66,70,50,102,50,73,75,138,83,
37,42,135,50,135,58,228,33,229,33,70,50,41,75,41,75,
233,83,233,83,100,42,69,42,227,33,203,91,106,67,41,59,
74,83,74,91,199,33,242,66,80,50,232,41,39,58,7,50,
165,33,35,25,99,25,197,41,196,33,229,33,229,33,71,50,
197,41,38,50,38,50,70,50,135,58,167,58,135,58,135,58,
103,58,229,41,70,58,9,83,136,66,169,74,8,58,134,49,
232,33,12,42,204,33,12,50,139,58,169,66,168,66,39,50,
103,50,104,50,75,83,233,58,71,42,229,33,37,42,102,50,
9,75,40,75,43,75,236,99,108,116,175,124,84,133,251,116,
125,92,63,84,254,83,62,92,31,84,95,84,61,76,63,76,
30,84,62,84,30,84,30,84,30,84,30,84,30,84,30,84,
30,84,62,84,62,84,62,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,30,84,
62,84,62,92,62,92,62,92,62,84,62,92,62,92,62,92,
62,92,62,84,62,84,62,84,62,92,62,92,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
94,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,61,92,61,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,61,92,61,92,61,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,94,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
62,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,61,92,61,92,61,92,61,92,62,92,61,92,61,92,
198,50,35,34,3,26,132,42,164,42,164,42,228,50,69,59,
102,59,228,42,5,43,229,42,164,34,99,34,164,42,67,34,
6,59,71,67,132,42,129,17,34,17,194,16,129,8,161,8,
193,16,226,16,193,8,193,8,193,16,160,8,193,8,1,17,
98,17,224,8,193,8,2,25,2,25,225,16,66,25,36,50,
228,33,226,25,99,42,196,50,37,59,37,59,69,67,36,59,
37,67,38,75,103,83,168,99,136,99,71,83,135,83,41,100,
10,100,103,75,6,67,197,58,35,42,65,25,128,8,161,16,
161,16,194,24,3,25,194,16,161,8,226,16,2,17,99,33,
2,17,193,16,225,24,225,24,1,17,131,33,131,33,34,25,
37,66,130,41,228,49,134,58,4,50,33,25,33,25,166,74,
40,91,134,66,102,58,198,66,71,83,10,108,42,108,165,58,
36,58,167,82,233,98,107,115,42,107,171,107,198,66,100,42,
228,33,228,41,135,66,38,58,100,25,99,25,225,8,1,17,
2,25,2,25,225,16,2,17,99,33,131,33,5,50,106,99,
104,67,232,58,10,67,233,66,234,74,178,132,178,132,47,116,
80,141,170,83,38,67,232,83,167,75,229,58,169,91,198,66,
38,66,166,74,230,74,166,66,73,91,106,91,106,91,106,91,
41,91,138,99,203,107,232,74,41,83,102,66,70,58,107,99,
9,75,134,58,101,58,166,66,72,83,40,83,232,74,200,66,
200,74,102,58,9,83,167,66,134,58,105,83,8,67,199,58,
235,91,138,83,73,83,41,75,200,58,9,67,199,66,167,66,
7,75,7,75,40,75,199,66,167,58,167,58,166,50,231,50,
231,66,37,42,41,67,236,75,236,91,174,108,166,50,135,58,
74,75,232,58,196,33,134,58,166,50,166,58,101,50,199,74,
76,100,73,67,138,75,167,50,4,34,4,34,196,33,196,33,
5,34,70,42,9,67,167,58,102,50,135,58,135,58,103,58,
139,75,45,100,12,100,40,67,174,108,174,108,232,58,102,50,
99,25,67,25,35,25,35,25,197,41,164,33,34,17,230,41,
38,50,197,33,70,50,168,58,70,42,5,42,70,50,136,58,
136,83,39,75,101,58,199,74,200,74,167,58,41,75,105,75,
8,67,8,67,168,58,196,33,167,58,102,50,101,50,7,67,
169,83,169,83,136,83,75,108,35,34,231,58,106,67,171,75,
39,42,134,58,70,50,203,58,102,17,225,8,226,16,133,33,
3,25,2,17,99,33,229,41,5,42,5,42,197,33,164,25,
197,41,38,50,229,33,164,33,5,42,102,50,168,66,168,66,
6,50,6,50,103,58,71,58,132,33,137,74,105,74,8,66,
137,50,106,50,203,33,77,50,140,58,169,66,136,58,104,58,
202,66,137,58,43,75,201,58,38,34,229,33,39,42,108,91,
172,83,74,75,201,50,73,75,73,75,173,83,204,75,77,84,
241,116,152,108,94,100,31,76,61,76,125,84,255,83,255,83,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,92,62,84,62,84,62,84,62,84,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,30,84,
62,84,62,92,94,92,62,92,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,61,92,61,92,61,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,61,92,61,92,61,92,61,92,62,92,61,92,61,92,
133,50,3,34,35,34,165,50,132,42,99,34,229,50,37,59,
102,51,69,51,37,51,4,51,37,51,228,42,196,42,99,34,
41,92,134,67,99,34,97,9,225,8,194,16,129,8,161,8,
226,16,226,16,193,8,193,8,1,17,1,17,33,17,130,25,
98,25,34,17,193,16,161,16,161,16,193,16,1,17,98,33,
162,25,67,42,228,50,131,42,131,42,196,50,37,59,4,59,
164,58,5,75,168,99,200,99,168,91,167,91,134,75,166,75,
71,75,38,75,37,67,5,67,229,66,165,66,163,41,1,25,
2,33,226,24,226,16,161,8,193,8,193,16,35,25,71,66,
67,25,128,8,128,8,2,25,131,33,228,41,66,33,193,16,
98,41,134,74,195,41,98,25,98,33,65,25,4,58,8,99,
133,66,69,58,167,66,138,91,104,83,200,91,230,74,198,74,
137,107,138,115,45,140,75,115,107,115,204,115,232,74,36,42,
227,33,5,50,229,49,164,41,34,17,1,9,99,25,34,17,
193,16,160,8,2,17,197,41,229,41,197,41,9,83,232,74,
134,50,42,75,168,58,200,66,175,124,246,165,243,132,112,116,
112,133,169,75,103,67,102,67,102,75,38,75,71,83,198,74,
168,82,8,83,40,91,7,83,200,74,168,74,232,82,73,91,
9,83,106,99,106,91,167,66,232,74,70,58,168,74,14,116,
13,108,41,83,8,75,231,74,40,83,40,83,200,74,135,66,
200,74,232,82,9,83,102,58,167,66,232,74,102,50,106,83,
235,91,73,83,167,66,9,75,200,66,134,58,135,58,232,74,
104,83,231,74,167,58,200,66,73,75,8,67,100,42,132,42,
166,58,228,41,107,83,200,50,73,75,48,133,36,34,135,66,
41,59,171,91,102,42,69,50,105,75,173,108,198,58,36,42,
69,34,40,67,73,67,138,75,69,42,195,25,131,25,99,25,
196,33,37,42,167,58,102,50,232,66,106,83,135,58,102,58,
166,50,73,75,203,91,137,75,173,108,205,116,198,58,69,50,
164,33,35,25,3,17,2,17,99,33,132,33,99,25,7,50,
197,41,164,33,70,50,135,58,5,42,197,33,6,42,104,58,
231,66,166,58,102,58,171,99,110,124,138,91,40,75,72,67,
105,75,202,83,170,83,231,58,12,92,202,83,71,67,103,75,
40,75,231,66,43,100,136,75,6,59,230,58,7,59,40,59,
132,17,99,17,199,66,234,83,165,50,228,41,99,33,3,17,
67,25,67,25,132,33,164,33,38,50,70,50,197,33,132,25,
5,42,136,66,167,58,38,50,229,33,37,42,135,58,135,66,
71,58,229,41,5,42,38,50,100,33,197,49,39,66,76,107,
139,58,9,42,233,33,108,58,75,58,138,58,169,58,200,66,
105,58,234,74,233,74,9,75,168,58,232,66,204,99,176,132,
137,75,110,75,47,59,239,50,45,59,44,67,111,75,208,83,
138,91,205,91,244,116,124,100,63,92,253,75,255,83,61,92,
30,84,30,84,30,84,30,84,30,84,30,84,30,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,30,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,92,62,84,62,84,62,84,62,84,62,92,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,94,92,62,92,62,84,62,92,62,92,62,92,
62,84,62,92,94,92,94,92,94,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,92,94,92,94,92,94,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,61,92,61,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
94,92,94,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,62,92,62,92,62,92,62,92,61,92,62,92,62,92,
62,92,61,92,61,92,61,92,61,92,62,92,61,92,61,92,
228,41,163,33,36,42,101,50,226,33,35,34,197,50,164,50,
135,67,167,75,70,59,228,50,228,50,131,42,131,42,99,42,
228,58,195,50,229,58,227,33,160,8,97,8,65,16,129,16,
161,8,161,8,192,8,224,8,1,9,65,17,162,25,195,33,
33,9,99,25,225,8,193,8,34,25,34,25,224,16,192,16,
97,17,100,42,164,50,225,25,99,34,198,50,229,58,229,58,
229,74,229,74,6,83,197,74,229,74,134,75,69,67,4,51,
132,58,99,50,196,58,5,67,38,75,230,66,100,58,68,58,
163,41,163,41,131,33,1,9,193,8,193,8,226,16,100,33,
197,41,35,25,67,33,132,33,132,33,67,25,193,16,160,16,
160,8,5,58,98,33,65,33,98,33,163,49,41,99,134,82,
101,66,166,74,232,82,73,83,10,100,201,99,197,66,7,83,
202,115,235,123,106,115,38,74,103,74,70,66,41,83,166,58,
195,25,37,50,98,33,33,25,36,50,227,41,65,17,225,8,
160,8,132,33,71,58,168,66,5,42,5,42,139,91,42,83,
41,75,138,83,230,66,39,75,173,116,80,141,142,116,13,100,
140,100,136,75,169,83,168,91,71,83,198,74,72,91,199,74,
70,66,134,74,73,91,138,99,200,74,37,50,102,66,8,83,
74,91,41,83,41,83,199,74,102,66,5,50,169,82,108,107,
237,107,9,75,41,83,231,74,166,66,166,66,167,66,167,66,
9,83,167,74,232,82,232,82,102,58,199,66,138,83,41,75,
232,66,73,83,232,66,168,66,168,66,70,50,167,58,73,83,
199,66,167,66,167,66,8,75,73,75,104,75,71,67,136,75,
8,75,228,41,106,83,134,42,69,42,40,75,101,42,37,50,
199,50,135,58,4,34,199,66,235,91,109,92,199,66,73,75,
102,50,167,58,235,91,166,50,102,42,69,42,164,33,164,33,
5,34,167,58,70,50,37,42,102,50,74,83,102,50,200,66,
8,59,134,50,72,75,11,92,169,75,169,75,8,67,68,50,
5,42,99,25,35,17,2,17,164,41,38,50,229,41,197,33,
197,33,229,41,71,50,168,58,168,66,229,41,165,33,71,58,
74,75,41,75,232,74,139,99,45,116,73,83,199,58,231,58,
6,59,234,83,43,92,133,42,7,59,104,75,136,75,71,67,
167,58,167,58,72,75,35,34,132,42,101,42,36,34,163,17,
67,17,197,41,104,58,39,67,136,75,6,42,164,33,102,42,
164,41,164,41,229,49,229,41,38,50,229,41,164,33,133,33,
164,33,103,58,135,58,70,50,38,42,135,58,233,74,201,74,
136,66,165,33,5,42,200,66,103,58,132,33,164,41,107,107,
16,75,108,58,108,58,140,66,107,58,204,66,234,66,10,67,
203,66,234,74,201,66,233,74,105,83,109,116,77,108,41,67,
145,58,53,75,51,59,215,83,179,75,76,67,78,75,78,75,
118,116,111,83,140,108,112,108,90,108,93,100,127,92,60,76,
30,84,30,84,30,84,30,84,30,84,62,84,62,84,63,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,92,62,84,62,84,62,84,62,84,62,84,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,94,92,62,92,62,92,62,92,62,92,62,92,62,84,
62,84,62,92,94,92,94,92,94,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,84,62,92,94,92,94,92,94,92,94,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,84,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
94,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,94,92,94,92,94,92,
62,92,62,92,94,92,94,92,94,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
94,92,94,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
61,92,61,92,61,92,62,92,62,92,62,92,61,92,61,92,
61,92,61,92,62,92,62,92,61,92,61,92,62,92,62,92,
62,92,61,92,61,92,61,92,61,92,62,92,61,92,61,92,
34,25,98,33,228,49,195,41,194,33,68,42,100,50,132,50,
70,67,103,67,70,59,228,50,228,58,131,42,131,42,164,58,
36,59,4,59,102,67,227,33,128,8,162,16,97,16,96,8,
192,0,224,8,33,17,65,17,32,9,97,17,130,25,130,17,
225,8,99,25,130,25,130,25,163,25,66,25,1,25,225,24,
130,25,3,42,225,33,193,17,100,42,230,58,165,50,197,58,
196,66,5,75,5,75,164,66,164,66,229,66,6,67,6,67,
100,50,132,58,197,66,132,50,164,58,71,83,5,75,132,58,
132,66,165,66,166,58,69,42,163,25,67,25,34,17,193,16,
99,33,100,33,164,41,164,41,67,25,193,8,128,8,128,16,
224,16,66,33,5,58,99,41,163,49,4,66,4,66,133,82,
6,83,231,82,199,82,199,74,108,116,136,83,230,74,231,82,
170,107,170,107,41,91,73,91,74,91,166,58,72,75,72,75,
166,50,37,42,98,33,194,41,234,107,75,108,134,58,34,17,
2,17,136,66,41,75,73,83,232,66,73,75,233,66,135,58,
138,91,137,91,137,83,39,67,6,67,169,83,75,108,108,116,
136,83,197,66,231,82,203,115,109,140,199,82,105,99,102,58,
168,82,232,82,73,91,41,91,102,66,38,58,167,74,73,91,
73,83,232,74,41,83,41,83,167,66,38,58,169,74,173,115,
205,107,70,58,135,66,232,74,167,66,134,66,134,66,103,66,
167,66,232,82,232,82,232,74,167,66,73,83,203,91,166,50,
102,50,41,75,232,74,70,50,135,66,134,58,8,75,105,83,
9,83,199,66,199,66,40,75,169,83,75,100,10,92,9,92,
39,67,69,50,236,99,41,67,69,50,198,58,137,75,167,58,
166,58,134,66,135,66,74,91,41,75,199,50,102,50,199,58,
69,50,167,58,106,83,41,67,69,42,228,33,131,25,5,50,
69,42,69,42,228,33,70,42,102,50,232,66,102,50,232,66,
170,83,134,50,199,58,8,67,105,75,73,67,228,33,164,33,
5,42,197,33,132,33,100,33,6,50,135,58,5,42,165,33,
38,50,103,58,200,66,233,66,41,75,38,50,229,41,201,74,
74,83,74,83,74,83,41,75,73,83,232,66,200,66,232,66,
231,58,170,83,234,91,165,50,230,58,72,67,105,75,8,67,
166,58,12,108,199,58,199,58,105,75,69,42,66,17,1,9,
132,25,5,50,202,74,171,83,170,83,136,50,231,58,203,75,
6,50,229,41,38,50,229,41,196,41,100,33,68,25,68,25,
66,25,5,42,5,42,229,33,38,50,168,58,9,75,201,74,
168,66,136,66,136,58,103,58,70,50,196,33,163,33,102,66,
71,50,164,25,229,33,38,42,136,58,11,67,45,67,14,67,
206,58,143,91,172,99,137,91,202,99,140,83,205,50,49,59,
155,83,122,75,153,75,58,92,18,59,112,75,15,67,212,91,
249,83,21,67,18,100,16,100,14,92,84,92,31,92,31,76,
30,84,30,84,30,84,30,84,30,84,62,84,63,84,63,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,84,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
94,92,94,92,62,92,62,84,62,92,62,92,62,92,30,84,
62,84,94,92,94,92,94,92,94,92,94,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,94,92,94,92,94,92,94,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,94,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,94,92,94,92,94,92,
62,92,61,92,61,92,62,92,62,92,61,92,61,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,61,92,62,92,62,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,93,92,93,92,94,92,94,92,
94,92,94,92,94,92,94,92,94,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,94,92,94,92,94,92,94,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
61,92,61,92,61,92,93,92,93,92,93,92,93,92,61,92,
61,92,61,92,62,92,62,92,61,92,61,92,62,92,94,92,
93,92,61,92,61,92,61,92,61,92,93,92,61,92,61,92,
132,41,131,41,163,41,98,33,101,58,7,75,35,42,132,50,
38,51,229,42,228,42,228,42,101,59,4,51,196,42,196,50,
3,51,36,51,102,59,194,17,160,0,194,16,128,0,67,25,
162,33,227,33,36,42,35,42,162,25,130,17,163,17,99,9,
34,17,66,17,97,9,129,17,129,17,98,25,99,33,226,32,
196,33,195,33,161,25,226,25,35,34,133,50,100,42,6,67,
102,83,167,91,38,75,132,66,35,50,68,50,166,66,68,50,
67,42,164,58,71,83,230,74,99,58,164,58,164,66,4,75,
229,74,164,66,39,75,105,83,199,58,37,42,38,50,6,50,
229,49,197,41,132,41,132,33,34,25,193,8,161,16,194,24,
33,25,160,8,38,66,164,57,33,41,195,65,36,66,165,82,
165,74,165,74,69,66,105,91,108,116,103,83,72,91,105,107,
170,99,235,107,45,108,12,108,142,116,43,100,168,75,38,67,
198,50,228,33,194,41,197,74,135,91,233,99,44,108,164,33,
165,41,201,74,73,83,105,75,101,50,106,83,167,50,168,58,
40,83,137,83,170,83,134,42,101,42,40,75,169,99,43,116,
136,99,100,66,102,82,9,107,208,164,102,74,102,66,101,58,
167,82,199,82,199,82,167,74,135,66,200,74,8,83,231,82,
232,74,199,66,41,83,73,91,9,83,135,66,136,74,112,140,
238,107,164,41,196,41,134,66,134,66,134,66,167,74,168,74,
232,82,8,83,167,66,232,82,138,91,8,75,166,50,166,50,
73,75,199,58,134,58,5,42,102,58,37,42,166,58,40,67,
42,83,168,66,134,58,231,66,104,75,233,83,70,67,37,59,
6,51,232,66,41,67,41,67,199,66,7,67,235,83,170,83,
36,58,101,58,70,74,232,74,69,42,228,41,200,58,135,58,
102,58,134,58,12,108,138,83,69,42,228,33,70,50,38,50,
4,34,69,42,232,66,200,58,102,50,5,42,102,50,135,58,
204,91,107,83,9,75,167,58,232,58,228,25,34,9,35,17,
98,17,164,33,165,33,132,33,164,33,196,33,196,33,38,42,
104,58,136,58,200,66,200,66,233,66,38,50,197,41,39,58,
233,74,135,58,232,66,9,67,74,75,41,75,233,74,168,66,
199,58,232,66,7,67,198,58,40,67,199,58,167,58,201,66,
40,83,137,91,11,100,8,67,74,75,13,108,71,58,165,41,
7,50,130,33,164,33,133,42,7,51,40,67,103,67,203,67,
38,50,164,33,164,33,67,25,99,25,132,33,165,33,35,25,
66,17,103,58,168,66,200,66,9,75,233,74,168,66,71,58,
136,66,168,66,168,66,38,42,70,50,37,42,101,50,166,66,
103,58,133,33,198,33,103,58,106,83,140,83,111,75,49,67,
117,75,19,100,74,83,103,83,137,91,79,75,217,83,63,92,
60,76,220,67,189,67,249,83,18,59,52,67,182,75,217,75,
152,67,122,67,21,84,147,67,81,67,83,92,251,83,31,92,
63,84,62,84,62,84,30,84,30,84,62,84,62,84,63,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,95,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,92,62,92,62,92,62,84,
62,92,62,92,62,92,62,84,62,84,62,92,62,92,62,92,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,92,62,92,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,84,62,84,62,84,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
95,92,94,92,62,92,62,84,62,92,94,92,62,92,30,84,
62,84,94,92,94,92,94,92,94,92,94,92,62,92,94,92,
62,92,62,92,62,92,94,92,62,92,62,92,62,92,62,84,
62,92,94,92,94,92,94,92,94,92,94,92,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,94,92,94,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,94,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,84,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,94,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
62,92,62,92,94,92,94,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,94,92,94,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,94,92,94,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
61,92,61,92,61,92,94,92,94,92,94,92,94,92,94,92,
94,92,94,92,94,92,94,92,94,92,94,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,94,92,94,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,94,92,94,92,94,92,94,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,62,92,
61,92,61,92,61,92,93,92,93,92,93,92,93,92,93,92,
61,92,61,92,62,92,61,92,61,92,61,92,61,92,94,92,
93,92,61,92,61,92,61,92,61,92,93,92,61,92,61,92,
164,41,34,25,66,25,34,33,99,49,229,65,3,50,67,42,
163,50,164,42,100,42,230,58,71,67,164,42,130,34,4,43,
164,34,2,26,35,34,100,42,32,9,160,0,98,17,99,34,
99,34,163,42,36,59,4,59,163,50,132,50,194,33,165,74,
100,58,193,24,227,24,34,17,66,25,229,57,197,65,2,65,
227,57,65,33,66,33,132,41,229,57,69,58,67,58,163,66,
102,75,200,91,167,91,38,75,197,74,6,75,2,42,2,42,
131,58,229,66,131,58,131,58,37,83,229,74,228,74,196,66,
195,58,228,66,101,83,167,91,232,99,104,91,72,83,137,91,
201,83,104,75,199,66,196,33,131,33,225,16,194,24,129,16,
162,16,160,16,162,41,68,66,65,33,130,49,163,57,101,82,
37,66,36,58,100,58,137,91,10,108,169,91,202,99,235,107,
105,91,138,99,9,75,74,83,45,100,171,83,167,50,101,42,
164,33,195,33,3,42,39,75,199,66,41,75,134,58,200,66,
199,66,72,83,72,75,101,42,70,42,107,83,139,83,8,67,
105,75,73,75,12,92,8,67,40,67,72,75,165,66,6,75,
232,82,196,57,37,74,41,107,105,99,230,66,100,50,166,66,
134,66,166,74,134,66,102,66,167,74,200,74,167,66,232,74,
231,82,138,99,170,99,41,83,103,58,201,74,43,91,108,91,
74,91,229,49,163,33,37,58,102,58,38,58,70,58,200,74,
171,99,199,66,8,75,73,91,40,83,41,83,232,74,200,74,
138,83,231,66,134,50,102,50,132,50,230,66,102,58,231,74,
167,58,103,50,197,41,78,116,76,100,229,50,233,75,172,100,
40,76,233,75,39,67,7,67,8,67,238,116,233,83,230,58,
202,91,167,66,197,49,71,66,135,66,68,50,198,58,170,83,
200,66,5,42,69,50,8,75,231,66,101,50,199,58,37,42,
98,9,99,17,71,58,71,58,70,58,228,33,69,42,199,50,
40,67,167,50,200,66,5,42,38,50,39,50,164,33,67,17,
100,25,68,25,67,25,67,25,197,41,100,25,67,25,6,50,
6,50,197,41,229,41,135,58,200,66,135,58,164,33,197,41,
102,66,102,66,102,66,167,66,232,74,135,58,70,50,232,66,
168,74,103,66,167,66,232,74,167,66,135,66,167,66,135,66,
9,83,167,66,41,75,8,67,8,67,105,75,198,58,101,42,
71,58,35,25,132,25,70,50,167,50,41,67,42,67,105,42,
165,25,71,42,6,50,3,25,68,33,227,16,164,41,34,25,
1,25,131,33,5,50,168,66,168,58,201,66,9,75,200,66,
136,58,169,66,136,58,200,66,201,66,71,50,71,50,11,75,
106,83,164,33,197,41,6,50,70,50,137,50,240,66,119,83,
113,83,234,66,198,58,41,75,107,75,174,75,16,84,215,83,
220,75,189,75,61,92,151,67,89,59,220,83,248,75,93,84,
252,83,29,84,28,84,252,83,28,84,29,84,252,83,253,83,
30,84,62,84,63,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,30,84,30,84,62,84,62,84,62,84,30,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,92,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,92,62,92,62,92,62,92,62,84,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,62,84,
62,92,62,84,62,84,62,84,62,92,62,92,62,84,62,84,
62,84,62,84,62,84,62,84,62,84,62,84,62,84,61,84,
62,84,62,92,62,92,62,92,62,84,62,84,62,84,62,92,
62,92,94,92,94,92,62,92,62,84,62,84,62,92,94,92,
62,92,62,84,62,84,62,92,62,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,94,92,94,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,94,92,62,92,62,92,62,92,62,92,94,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,84,62,92,62,92,
94,92,94,92,62,92,62,92,62,92,62,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,94,92,94,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,94,92,94,92,94,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,94,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,94,92,94,92,94,92,94,92,
94,92,94,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
29,92,61,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,94,92,94,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,62,92,62,92,62,92,62,92,62,92,62,92,62,92,
94,92,94,92,94,92,94,92,94,92,94,92,94,92,94,92,
61,92,62,92,62,92,62,92,61,92,61,92,62,92,94,92,
61,92,62,92,62,92,61,92,61,92,62,92,62,92,61,92,
61,92,61,92,61,92,61,92,61,92,61,92,61,92,61,92,
62,92,61,92,61,92,61,92,62,92,62,92,94,92,94,92,
94,92,62,92,62,92,61,92,61,92,62,92,62,92,94,92,
93,92,93,92,61,92,61,92,61,92,61,92,93,92,93,92,
131,25,33,17,163,33,163,49,99,41,99,41,130,33,226,33,
164,50,132,42,132,42,6,59,229,50,99,34,131,34,196,42,
227,25,1,9,224,8,97,17,33,9,35,25,196,33,2,26,
67,34,163,42,4,51,227,50,163,42,229,66,104,99,173,148,
105,107,102,98,130,33,33,17,131,33,194,33,224,32,68,65,
99,41,160,16,160,16,1,25,195,49,199,82,39,83,38,83,
228,58,4,67,228,66,197,66,132,58,67,50,226,41,197,66,
5,67,197,58,67,42,36,50,198,74,197,74,5,83,227,74,
165,74,165,66,229,74,5,83,134,91,134,91,134,99,134,99,
41,108,71,83,165,66,68,58,195,41,66,33,2,25,161,16,
162,16,161,16,65,33,69,66,98,41,96,16,1,41,36,74,
69,66,162,49,165,74,43,116,11,116,105,91,105,91,73,91,
41,91,166,66,36,50,72,75,105,75,199,58,166,50,163,17,
196,33,166,66,68,50,7,67,101,50,228,33,135,58,167,66,
232,66,8,75,231,66,73,75,233,66,139,83,208,124,8,67,
203,91,73,75,203,91,40,67,137,83,231,66,198,66,35,50,
162,49,4,58,198,82,230,82,230,74,198,66,133,58,166,66,
167,74,102,66,70,58,37,58,70,58,102,66,135,66,232,74,
41,91,138,99,170,99,74,91,200,74,9,83,10,83,233,82,
70,58,38,58,102,66,135,66,135,66,102,58,38,58,103,66,
135,58,167,66,199,66,69,58,36,50,134,58,102,58,102,58,
198,66,136,83,41,75,167,58,165,58,7,67,167,58,135,58,
37,42,229,41,229,49,236,107,11,100,136,75,42,92,9,84,
136,59,234,83,199,66,41,75,8,67,105,75,7,59,201,83,
80,141,236,99,197,49,229,49,167,66,8,75,105,83,76,108,
236,99,4,42,98,25,69,50,167,58,228,33,195,25,228,33,
99,17,196,33,196,41,5,50,229,49,163,33,5,42,134,50,
4,34,70,50,6,50,165,41,100,33,198,49,35,25,226,16,
2,17,67,25,100,25,67,25,132,33,67,25,3,17,100,25,
100,33,35,17,229,41,9,75,9,75,168,66,197,41,165,33,
37,58,135,66,135,66,102,58,135,58,102,58,135,58,9,75,
168,74,200,74,233,82,233,74,102,58,37,50,135,66,232,74,
135,66,167,66,8,75,232,66,231,58,73,75,8,67,36,42,
6,50,165,41,71,58,168,66,200,66,41,75,233,66,169,58,
37,34,139,83,9,75,193,8,193,16,34,25,67,33,1,17,
34,25,99,33,164,33,38,50,38,42,135,58,168,58,167,58,
71,50,168,58,71,50,38,50,103,50,201,66,172,91,111,116,
44,108,229,41,198,41,39,50,38,50,71,42,204,58,81,75,
13,67,169,58,237,74,237,66,46,75,43,59,239,58,1