#include "typedefs.h"

/*New Macro*/
/*Macros for read delay programming. 6 bit Macro RDLY_X_XX = [rdly[3:0],half_dqs_dly,quart_dqs_dly]*/
#define RDLY_0_75 0x21    //100001
#define RDLY_1_00 0x22    //100010
#define RDLY_1_25 0x23    //100011
#define RDLY_1_50 0x10    //010000
#define RDLY_1_75 0x11    //010001
#define RDLY_2_00 0x12    //010010
#define RDLY_2_25 0x13    //010011
#define RDLY_2_50 0x08    //001000
#define RDLY_2_75 0x09    //001001
#define RDLY_3_00 0x0A    //001010
#define RDLY_3_25 0x0B    //001011
#define RDLY_3_50 0x04    //000100
#define RDLY_3_75 0x05    //000101
#define RDLY_4_00 0x06    //000110
#define RDLY_4_25 0x07    //000111
#define RDLY_4_50 0x00    //000000
#define RDLY_4_75 0x01    //000001
#define RDLY_5_00 0x02    //000010
#define RDLY_5_25 0x03    //000011

/*CAS Latency value as per frequency and speed grade of memory device used*/
#define CAS_LATENCY 5

#define CLK_FREQ_MHZ                 333         /*clock frequency in Mhz. Only for DRAM controller's timing parameters programming*/
#define RDLY_HALFDQSDLY_QUARTDQSDLY  RDLY_5_25   
#define WDLY                         4
#define EARLYODT_ENABLE              1
#define ONDIETERMINATE_ENABLE        1
#define DRAM_COMMAND_TIME            0x28        //Fixed from Ankit
#define BANK_PRE_TIME                0x1E        //Fixed from Ankit
#define REFRESH_TIME_TIME            0x01F4      //Fixed from Ankit
//#define REFRESH_TIME_NS 3900

/* Timing parameters for 1Gb MT47H64M16HR-3 . *_NS = nsec */
#define RFC_NS          127.5
#define WR_NS           15
#define WTR_NS          7.5
#define RRD_NS          10
#define RC_NS           55
#define RAS_NS          40
#define RCD_NS          15
#define FAW_NS          50
//#define RTW_NS          7.5
#define CCD             2<<ddr_sdr_bit_mode_conf       /*DRAM_TIME_CCD2 = max(tCCD,2) (32-bit mode), max(tCCD,4)(16-bit mode)*/
#define RTP_NS          7.5
#define RP_NS           15
#define RPA_NS          18
#define BTA_NS           1   /*bus turn-around time. tBTAis the minimum dead time that needs to be put on the bus between the driving the bus and the DRAM driving the bus to take into account the transit delay on the PCB, the pad delay, the DRAM skew, and the on-chip delay.*/


#define TIME_CONFIG_0  (((REFRESH_TIME_TIME)<<16) | ((DRAM_COMMAND_TIME)<<8) | ((BANK_PRE_TIME)<<0))
#define TIME_CONFIG_1  (((unsigned int)((RFC_NS*CLK_FREQ_MHZ)/1000 + 1))<<25) | \
                       (((unsigned int)((WR_NS*CLK_FREQ_MHZ)/1000 + 1 + WDLY + (2<<ddr_sdr_bit_mode_conf)))<<20) | \
		       (((unsigned int)((WTR_NS*CLK_FREQ_MHZ)/1000 + 1 + WDLY + (2<<ddr_sdr_bit_mode_conf)))<<16) | \
		       (((unsigned int)((RRD_NS*CLK_FREQ_MHZ)/1000 + 1))<<11) | \
		       (((unsigned int)((RC_NS*CLK_FREQ_MHZ)/1000 + 1))<<5) | \
		       (((unsigned int)((RAS_NS*CLK_FREQ_MHZ)/1000 + 2))<<0)    //As per AG RAS=14 
#define TIME_CONFIG_2  (((unsigned int)((RCD_NS*CLK_FREQ_MHZ)/1000 + 1))<<28) | \
                       (((unsigned int)((FAW_NS*CLK_FREQ_MHZ)/1000 + 1))<<23) | \
                       (((unsigned int)((BTA_NS*CLK_FREQ_MHZ)/1000 + 2 + 2<<ddr_sdr_bit_mode_conf))<<19) | \
                       ((CCD)<<15) | \
                       (((unsigned int)((RTP_NS*CLK_FREQ_MHZ)/1000 + 1 + 2*ddr_sdr_bit_mode_conf))<<10) | \
                       (((unsigned int)((RP_NS*CLK_FREQ_MHZ)/1000 + 1))<<5) | \
                       (((unsigned int)((RPA_NS*CLK_FREQ_MHZ)/1000 + 1))<<0)


/*Earlier Macros*/

#define COMMAND 0
#define COMPACT_COMMAND 1

#define DDRII 0
#define DDRI 1
#define MOBILE_DDR 2
#define SDR  3

#define LOAD_MODE_REGISTER					0x00000000	
#define LOAD_EXTENDED_MODE_REGISTER_1		CMD_REG_SET_BANK_0 | 0x00000000						// Enabling DLL is different
#define LOAD_EXTENDED_MODE_REGISTER_2		CMD_REG_SET_BANK_1 | 0x00000000
#define LOAD_EXTENDED_MODE_REGISTER_3		CMD_REG_SET_BANK_0 |CMD_REG_SET_BANK_1 | 0x00000000

#define MR_BURST_LENGTH_4						0x2
#define MR_BURST_LENGTH_8						0x3
#define MR_BURST_TYPE_SEQUENTIAL				0x0
#define MR_BURST_TYPE_INTERLEAVE				0x1
#define MR_CAS_LATENCY_2						0x20					
#define MR_CAS_LATENCY_3						0x30
#define MR_CAS_LATENCY_4						0x40
#define MR_CAS_LATENCY_5						0x50
#define MR_CAS_LATENCY_6						0x60
#define MR_CAS_LATENCY_7						0x70
#define MR_MODE_TEST							0x80
#define MR_NORMAL_TEST							0x00
#define MR_DLL_RESET							0x100
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_2	0x200
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_3	0x400
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_4	0x600
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_5	0x800
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_6	0xA00
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_7	0xC00
#define MR_WRITE_RECOVERY_FOR_AUTO_PRECHARGE_8	0xE00
#define MR_ACTIVE_POWER_DOWN_EXIT_TIME_FAST     0x0000
#define MR_ACTIVE_POWER_DOWN_EXIT_TIME_SLOW     0x1000

#define EMR1_DLL_ENABLE						0x1
#define CMD_REQ_CLEAR						0x00000000
#define CMD_REQ_SET							0x01000000

#define CMD_REG_SET_BANK_0		0X00010000
#define CMD_REG_SET_BANK_1		0X00020000
#define CMD_REG_SET_BANK_2		0X00040000
#define CMD_REG_READ_CMD		CMD_REG_RAS|CMD_REG_WEB	
#define CMD_REG_WRITE_CMD		CMD_REG_RAS
#define CMD_REG_WEB				0x00080000
#define CMD_REG_CAS				0x00100000
#define CMD_REG_RAS				0x00200000
#define CMD_REG_CS				0x00400000
#define CMD_INHIBIT				CMD_REG_CS
#define NO_OPERATION_CMD		CMD_REG_RAS | CMD_REG_CAS | CMD_REG_WEB

#define PRECHARGE_ALL_CMD		CMD_REG_WEB | 0X00008000 | 0x00000000
#define AUTO_REFRESH_CMD		CMD_REG_WEB | 0x00000000

#define DDR_SYS_CONFIG_REGISTER_RESET_VALUE					0X10000000
#define	DDR_TIME_CONFIG0_REGISTER_RESET_VALUE				0X00000000
#define	DDR_TIME_CONFIG1_REGISTER_RESET_VALUE				0X00000000
#define	DDR_TIME_CONFIG2_REGISTER_RESET_VALUE				0X00000000
#define	DDR_COMMAND_REGISTER_RESET_VALUE			0X00000000
#define	DDR_COMPACT_CMD_REGISTER_RESET_VALUE			0X00000000
#define	DDR_SELF_REFRESH_CMD0_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD1_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD2_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD3_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD4_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD5_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD6_REGISTER_RESET_VALUE			0X0000
#define	DDR_SELF_REFRESH_CMD7_REGISTER_RESET_VALUE			0X0000
#define	DDR_DQS_CONFIG_OFFSET_COUNT_REGISTER_RESET_VALUE	0X00000000
#define	DDR_DQS_CONFIG_OFFSET_TIME_REGISTER_RESET_VALUE		0X00000000
#define	DDR_DELAY_STATUS_REGISTER_RESET_VALUE				0X00000000
#define	DDR_AUX_CONFIG_REGISTER_RESET_VALUE					0X00000000
#define	DDR_SELF_TEST_DATA_OUT_HIGH_REGISTER_RESET_VALUE	0X00000000
#define	DDR_SELF_TEST_DATA_OUT_LOW_REGISTER_RESET_VALUE	    0X00000000
#define	DDR_SELF_TEST_DATA_EXPECT_HIGH_REGISTER_RESET_VALUE	0X00000000
#define	DDR_SELF_TEST_DATA_EXPECT_LOW_REGISTER_RESET_VALUE	0X00000000
#define	DDR_READ_DATA_ERROR_HIGH_REGISTER_RESET_VALUE		0X00000000
#define	DDR_READ_DATA_ERROR_LOW_REGISTER_RESET_VALUE		0X00000000
#define	DDR_EXTRA_ATTRIBUTES_REGISTER_RESET_VALUE		0X00000000


#define	DMA_FILL_VALUE			0xFFFFFFFF
#define CPU_ARRAY_SIZE			100

#define SELF_REFRESH_ENTRY		0x00000000
#define SELF_REFRESH_EXIT		0x00000000

typedef enum{
   DDR_32_BIT_MODE, 
   DDR_16_BIT_MODE,
   SDR_16_BIT_MODE
}ddr_sdr_bit_mode;


vuint32_t basic_memory_read_write_test();
void write_self_test_data_out_upper_register(vuint32_t write_value);
vuint32_t read_self_test_data_out_upper_register();
void write_self_test_data_out_lower_register(vuint32_t write_value);
vuint32_t read_self_test_data_out_lower_register();
void write_self_test_data_out_register(vuint32_t write_value);
void write_self_test_data_expect_upper_register(vuint32_t write_value);
vuint32_t read_self_test_data_expect_upper_register();
void write_self_test_data_expect_lower_register(vuint32_t write_value);
vuint32_t read_self_test_data_expect_lower_register();
void write_self_test_data_expect_lower_register(vuint32_t write_value);
void write_self_test_data_expect_register(vuint32_t write_value);
vuint32_t read_data_error_register_upper();
vuint32_t read_data_error_register_lower();
void write_sys_config_register(vuint32_t write_value);
vuint32_t read_sys_config_register();
void write_time_config0_register(vuint32_t write_value);
vuint32_t read_time_config0_register();
void write_time_config1_register(vuint32_t write_value);
vuint32_t read_time_config1_register();
void write_time_config2_register(vuint32_t write_value);
vuint32_t read_time_config2_register();
void write_command_register(vuint32_t write_value);
vuint32_t read_command_register();
void write_compact_command_register(uint16_t write_value);
uint16_t read_compact_command_register();
void write_self_refresh_command_register(vuint32_t write_value,int self_refresh_register_number);
vuint32_t read_self_refresh_command_register(int self_refresh_register_number);
void write_dqs_config_offset_count_register(vuint32_t write_value);
vuint32_t read_dqs_config_offset_count_register();
void write_dqs_config_offset_time_register(vuint32_t write_value);
vuint32_t read_dqs_config_offset_time_register();
void write_dqs_delay_status_register(vuint32_t write_value);
vuint32_t read_dqs_delay_status_register();
void write_ddr_aux_config_register(vuint32_t write_value);
vuint32_t read_ddr_aux_config_register();
void write_ddr_extra_attributes_register(vuint32_t write_value);
vuint32_t read_ddr_extra_attributes_register();


void set_cmd_mode_bit();
void clear_cmd_mode_bit();
void set_wdata_inject_bit();
void clear_wdata_inject_bit();
void set_rdata_compare_bit();
void clear_rdata_compare_bit();
void set_loop_back_bit();
void clear_loop_back_bit();
void delay_function();
void set_rst_b_bit();
void clear_rst_b_bit();
void set_clk_on_bit();
void clear_clk_on_bit();
void set_clk_enable();
void clear_clk_enable();
void set_fifo_overflow_enable();
void clear_fifo_overflow_enable();
int read_fifo_overflow_pending();
void set_fifo_underflow_enable();
void clear_fifo_underflow_enable();
int read_fifo_underflow_pending();
void clear_fifo_overflow_pending();
void clear_fifo_underflow_pending();
void set_16bit_mode();
void clear_16bit_mode();
void set_n_wait_till_reset();
//void edma_cpu_dram_memory_access();
vuint32_t fifo_underflow_test();
vuint32_t loop_back_mode_test();
void basic_main_lut_test();
void basic_alternate_lut_test();
void basic_ack_sel_test();
void basic_alternate_ack_sel_test();
void edma_basic_ack_test();
void edma_alternate_ack_test();
void free_run_timer_no_reload();
void free_run_timer_reload();
void free_run_timer_interrupt_pending();
void free_run_timer_interrupt_to_intc();
void reset_test_case();
void write_ack_cycle_select(int ack_cnt_field,uint8_t cycles);
void write_ack_select(int ack_sel_field,int value);
void write_look_up_table_select(int i,int value);
uint32_t read_grant_count(int gnt_ack_field);
uint32_t read_performace_monitor_counter(int counter);
void write_performace_monitor_counter(int counter,uint32_t value);
uint32_t read_main_lut_upper(int lut_number);
uint32_t read_main_lut_lower(int lut_number);
void write_main_lut_upper(int lut_number,uint32_t value);
void write_main_lut_lower(int lut_number,uint32_t value);
uint32_t read_alt_lut_upper(int lut_number);
uint32_t read_alt_lut_lower(int lut_number);
void write_alt_lut_upper(int lut_number,uint32_t value);
void write_alt_lut_lower(int lut_number,uint32_t value);
int read_interrupt_pending_bit();
void clear_interrupt_pending();
void write_interrupt_enable_bit(int i);
int read_interrupt_enable_bit();
int read_event_counter_free_run_bit();
void write_event_counter_free_run_bit(int i);
void write_event_timer_register(uint32_t value);
void write_event_preset_register(uint32_t value);
uint32_t read_event_timer_register();
uint32_t read_event_preset_register(uint32_t value);
int check_event_timer_running();
void drampm_isr();

vuint32_t clk_enable_disable();
