using System;
using System.Reflection;

namespace AsicSimSuite.AsicSimulator.Feedback
{
    /// <summary>
    /// An external method to calculate the current in the actuators
    /// </summary>
    public class Current : MarshalByRefObject,IRemoteInterface
    {
        public Current()
        {
        }

        // it is possible to add static fields to memorize a status
        private static int[] status;

        public static int EvaluateCurrent(bool Flag0Out, bool Flag1Out, bool Flag2Out, bool Irq,
                                          bool Hs1Command, bool Hs2Command, bool Hs3Command,
                                          bool Hs4Command, bool Hs5Command,
                                          bool Ls1Command, bool Ls2Command, bool Ls3Command,
                                          bool Ls4Command, bool Ls5Command, bool Ls6Command,
                                          bool Ls7Command,
                                          bool Oaout1FlagOut, bool Oaout2FlagOut,
                                          bool Start1FlagOut, bool Start2FlagOut, bool Start3FlagOut,
                                          bool Start4FlagOut, bool Start5FlagOut, bool Start6FlagOut,
                                          bool Debug,
                                          ulong time, 
                                          int oldCurrentValue,
                                          int[] oldCurrentValues)
        {

            // The following signal are the states of the corresponding output pins
            //
            // All the parameters of this function, except the last 3, are outputs of the device

            // "time" is number of the period under simulation. 
            //" time" * (Cksys period) is the current simulation time. Cksys period must be known
            // from the simulation, and here only the variable "time" should be used as a measure
            // of time.

            // "oldCurrentValue" is the current value flowing in the relevant actuator
            // at the preceding simulation step, expressed a uA. They are integer numbers.

            // "oldCurrentValues" containt the list of the current values flowing in all the actuators 
            // at the preceding simulation step, expressed a uA. They are integer numbers.

            // status[] contains the status of the actuators (number not known at compile time). 
            // These objects can be used to mantain memory of some condition between different iteration 
            // of this function

            // newCurrentValue should contain the new current value, expressed as an integer number of uA. 
            int newCurrentValue = oldCurrentValue;

            // BEGIN USER CODE
                 
            
            newCurrentValue -= 100;    // boost drop in 1 ck cycle
            
            if(!Flag0Out)
            newCurrentValue -= 1000;   // big discharge since boost off
                
                
            //increase in charge (uV) of boost cap = I(uA) x time (41ns) / Capacitanceboost (2mF)   
            if(!Ls7Command)
            newCurrentValue += (int)(oldCurrentValues[5] / 50.0);    //1000000 time/cap change to see something
                
            //Vboost cannot go lower than vbatt - vdiode
            newCurrentValue = Math.Max(14000000, newCurrentValue);     

            // END USER CODE

            return newCurrentValue;
        }

        // do not modify the following method
        public object Invoke(string method, object[] parameters) 
        {
            return this.GetType().InvokeMember(method,
                BindingFlags.InvokeMethod, null, this, parameters);
        }

    }
}
