/*****************************************************************************  
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************/
// JavaScript Document
 //general variables
var index;
var j;
var value =0;
var aux;
var b_back_status = 0;
var Reg0 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x00,1); // ISRhi (8xdata, address, 16/8 bit register indication)
var Reg1 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x01,0); //ISRlo
var Reg2 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x02,0); // IVR
var Reg3 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x04,0); //VCR
var Reg4 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x05,0); //VSR
var Reg5 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x08,0); //LXR
var Reg6 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x09,0); //LXCR
var Reg7 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x10,0); //WDR 
var Reg8 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x11,0); //WDSR 
var Reg9 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x12,0); //WCR 
var Reg10 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x13,0); //TCR 
var Reg11 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x14,0); //WSR 
var Reg12 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x15,0); //RSR 
var Reg13 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x16,0); //MCR 
var Reg14 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x18,0); //LINR 
var Reg15 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x20,0); //PTBC1 
var Reg16 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x21,0); //PTBC2 
var Reg17 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x22,0); //PTB 
var Reg18 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x28,0); //HSCR 
var Reg19 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x29,0); //HSSR 
var Reg20 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x30,0); //LSCR 
var Reg21 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x31,0); //LSSR 
var Reg97 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x32,0); //LSCEN *******
var Reg22 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x38,0); //HSR 
var Reg23 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x3C,0); //CSR 
var Reg24 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x40,0); //SCIBDhi 
var Reg25 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x41,0); //SCIBDlo 
var Reg26 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x42,0); //SCIC1 
var Reg27 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x43,0); //SCIC2 
var Reg28 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x44,0); //SCIS1 
var Reg29 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x45,0); //SCIS2 
var Reg30 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x46,0); //SCIC3 
var Reg31 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x47,0); //SCID 
var Reg55 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x60,0); //PWMCTL 
var Reg56 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x61,0); //PWMPRCLK 
var Reg57 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x62,0); //PWMSCLA 
var Reg58 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x63,0); //PWMSCLB 
var Reg59 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x64,0); //PWMCNT0 
var Reg60 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x65,0); //PWMCNT1
var Reg61 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x66,0); //PWMPER0
var Reg62 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x67,0); //PWMPER1
var Reg63 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x68,0); //PWMDTY0
var Reg64 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x69,0); //PWMDTY1
var Reg65 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x80,0); //ACR
var Reg66 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x81,0); //ASR
var Reg67 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x82,1); //ACCRhi
var Reg68 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x83,0); //ACCRlo
var Reg69 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x84,1); //ACCSRhi
var Reg70 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x85,0); //ACCSRlo
var Reg71 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x86,1); //ADR0hi
var Reg72 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x87,0); //ADR0lo
var Reg73 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x88,1); //ADR1hi
var Reg74 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x89,0); //ADR1lo
var Reg75 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8A,1); //ADR2hi
var Reg76 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8B,0); //ADR2lo
var Reg77 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8C,1); //ADR3hi
var Reg78 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8D,0); //ADR3lo
var Reg79 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8E,1); //ADR4hi
var Reg80 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x8F,0); //ADR4lo
var Reg81 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x90,1); //ADR5hi
var Reg82 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x91,0); //ADR5lo
var Reg83 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x92,1); //ADR6hi
var Reg84 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x93,0); //ADR6lo
var Reg85 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x94,1); //ADR7hi
var Reg86 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x95,0); //ADR7lo
var Reg87 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x96,1); //ADR8hi
var Reg88 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x97,0); //ADR8lo
var Reg89 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x98,1); //ADR9hi
var Reg90 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x99,0); //ADR9lo
var Reg91 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9A,1); //ADR10hi
var Reg92 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9B,0); //ADR10lo
var Reg93 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9C,1); //ADR11hi
var Reg94 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x9D,0); //ADR11lo
var Reg95 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xA4,1); //ADR15hi
var Reg96 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xA5,0); //ADR15lo
var Reg97 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0x32,0); //LSCEN 
var Reg32 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC0,0); //TIOS
var Reg33 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC1,0); //CFORC
var Reg34 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC2,0); //OC3M
var Reg35 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC3,0); //OC3D
var Reg36 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC4,1); //TCNThi
var Reg37 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC5,0); //TCNTlo
var Reg38 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC6,0); //TSCR1
var Reg39 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC7,0); //TTOV
var Reg40 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC8,0); //TCTL1 
var Reg41 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xC9,0); //TCTL2 
var Reg42 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCA,0); //TIE 
var Reg43 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCB,0); //TSCR2 
var Reg44 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCC,0); //TFLG1 
var Reg45 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCD,0); //TFLG2 
var Reg46 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCE,1); //TC0hi
var Reg47 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xCF,0); //TC0lo 
var Reg48 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD0,1); //TC1hi
var Reg49 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD1,0); //TC1lo
var Reg50 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD2,1); //TC2hi
var Reg51 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD3,0); //TC2lo
var Reg52 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD4,1); //TC3hi
var Reg53 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD5,0); //TC3lo
var Reg54 = new Array(0, 0, 0, 0, 0, 0, 0, 0,0xD6,0); //TIMTST
var AllRegisters = new Array(Reg0,Reg1,Reg2,Reg3,Reg4,Reg5,Reg6,Reg7,Reg8,Reg9,Reg10,Reg11,Reg12,Reg13,Reg14,Reg15,Reg16,Reg17,Reg18,Reg19,Reg20,Reg21,Reg22,Reg23,Reg24,Reg25,Reg26,Reg27,Reg28,Reg29,Reg30,Reg31,Reg32,Reg33,Reg34,Reg35,Reg36,Reg37,Reg38,Reg39,Reg40,Reg41,Reg42,Reg43,Reg44,Reg45,Reg46,Reg47,Reg48,Reg49,Reg50,Reg51,Reg52,Reg53,Reg54,Reg55,Reg56,Reg57,Reg58,Reg59,Reg60,Reg61,Reg62,Reg63,Reg64,Reg65,Reg66,Reg67,Reg68,Reg69,Reg70,Reg71,Reg72,Reg73,Reg74,Reg75,Reg76,Reg77,Reg78,Reg79,Reg80,Reg81,Reg82,Reg83,Reg84,Reg85,Reg86,Reg87,Reg88,Reg89,Reg90,Reg91,Reg92,Reg93,Reg94,Reg95,Reg96,Reg97);
var LIN_ID = new Array (0, 0, 0, 0, 0, 0, 0, 0,0xDF,0); // stores value of LIN slave ID


var number_format =0; // hex is default
var wrong = 0; // 

// variables supported User_friendly control panell
var hs1_on = 0;
var hs2_on = 0;
var ls1_on = 0;
var ls2_on = 0;

var channel_selected = 0;
var duty = 0;
var frequency = 0;
var range = 1;
var polarity = 0;

var duty_ch0 = 20;
var frequency_ch0 = 10;
var frequency_range_ch0 = 2;
var polarity_ch0 = 1;

var duty_ch1 = 40;
var frequency_ch1 = 50;
var frequency_range_ch1 = 2;
var polarity_ch1 = 1;

var wu_select = 0;
var multiplier ="1";
var time = "1";
var cyclic_sense =0;
var lx_time = 1;
var cyclic_source1 =1;
var cyclic_source2 =0;

var su = 0;
var interval = 0;

var timer_reading;

var adc_stop_visualization = false;
var close_port = false;
var conversion_running = 0;
var AdResult = new Array(0,0,0,0,0,0,0,0,0,0,0,0);
var voltage=0;
var temperature =0;
var current = 0;
var ad0_select = 1;
var ad1_select = 0;
var ad2_select = 0;
var ad3_select = 0;
var ad4_select = 0;
var ad5_select = 0;
var ad6_select = 0;
var ad7_select = 0;
var ad8_select = 0;
var ad9_select = 0;
var ad10_select = 1;
var ad11_select = 0;
var lx_select = 0;
var lx_enabled = 0;
var lx_range = 0;
var fifo0 = new Array(0); // need to create own 4 buffers with historic graph data, because "strip" activeX object is stupid, doesn't have access to the already plotted data
var fifo_index = 0;
var fifo_index_max = 202;
var fifo0 = new Array(0);
var fifo1 = new Array(0);
var fifo2 = new Array(0);
var fifo3 = new Array(0);
var fifo4 = new Array(0);
var fifo5 = new Array(0);
var fifo6 = new Array(0);
var fifo7 = new Array(0);
var fifo8 = new Array(0);
var fifo9 = new Array(0);
var fifo10 = new Array(0);
var fifo11 = new Array(0);


var LIN_enabled = 0;

var VCR_value = 0;
var VCR_value_old = 0;
var RSR_value = 0;
var RSR_value_old = 0;
var WSR_value = 0;
var WSR_value_old = 0;
var reset_update = 0;

var ax =0;
var time = 0;
var new_time = 0;

//------------------------------------------------------------------------------
function tabs(view,hideA,hideB,hideC,hideD,hideE,index)

{
    view.style.visibility = "visible";
    view.style.display = "block";
    hideA.style.visibility = "hidden";
    hideB.style.visibility = "hidden";
    hideC.style.visibility = "hidden";
    hideD.style.visibility = "hidden";
    hideE.style.visibility = "hidden";
    hideA.style.display = "none";
    hideB.style.display = "none";
    hideC.style.display = "none";
    hideD.style.display = "none";
    hideE.style.display = "none";
    for (i=1;i<=6;i++)
    { 
      aux = document.getElementById("visible_"+i);     
      aux.style.visibility = "hidden";     
      if (index == i)
      {
        aux.style.visibility = "visible";
      } 
    }
}
//------------------------------------------------------------------------------
function btclick(bitname,register,bit)
{
 if (register[bit] == 1) register[bit] = 0;
    else register[bit] = 1;
 if (register[bit] == 1)
    document.getElementById("bit_"+bitname).className = "BT_1";
 else
    document.getElementById("bit_"+bitname).className = "BT_0";
 AllRegisters[register] = register;
 registername = bitname.substring(0,bitname.length-1);
    if (number_format == 0)
    {
      temp = registername+"value";
      temp2 = array_to_integer(register);
      temp3 = temp2.toString(16);
      size = temp3.length;
      if (size < 2)
        temp3 = "0"+temp3;
      document.getElementById(temp).value = "0x"+temp3.toUpperCase();
    };
    if (number_format == 1)
    {
      temp = registername+"value";
      temp2 = array_to_integer(register);
      document.getElementById(temp).value = temp2.toString(10); 
    };
    if (number_format == 2)
    {
      temp = registername+"value";
      temp2 = array_to_integer(register);
      temp3 = temp2.toString(2)
      size = temp3.length;
      for (i=0;i<(8-size);i++)  //fill left zeroes
      {
        temp3="0"+temp3;
      }
      document.getElementById(temp).value = "0b"+temp3; 
    };
 
}
/*kod klavesy:
<input type="text" 
onKeyPress="cislo()">
<script>function cislo(){
if (event.keyCode 
< 48 || event.keyCode > 57)
event.returnValue= false;}
</script>
*/
//------------------------------------------------------------------------------
function display_error(code)
{
  if (code == 1)
  {
    document.getElementById("error_message").value ="Wrong number";
    document.getElementById("error_message").className = 'style_error';
  }
  else
  {
    document.getElementById("error_message").value ="OK";
    document.getElementById("error_message").className = 'style_OK';
  }
  
} 
//------------------------------------------------------------------------------
function blr(source)
{
var register_array = new Array();
var temp,temp1,temp2,register_value;

    if (document.getElementById(source).value.substring(0,2).toUpperCase() == "0X")
    {
     for (i=2;i< document.getElementById(source).value.length;i++)
     {
      if((!((document.getElementById(source).value.substring(i,i+1).charCodeAt()>47)
      &&(document.getElementById(source).value.substring(i,i+1).charCodeAt() < 58)
      ||(document.getElementById(source).value.substring(i,i+1).toUpperCase()=="A")
      ||(document.getElementById(source).value.substring(i,i+1).toUpperCase()=="B")
      ||(document.getElementById(source).value.substring(i,i+1).toUpperCase()=="C")
      ||(document.getElementById(source).value.substring(i,i+1).toUpperCase()=="D")
      ||(document.getElementById(source).value.substring(i,i+1).toUpperCase()=="E")
      ||(document.getElementById(source).value.substring(i,i+1).toUpperCase()=="F"))
      ||((parseInt(document.getElementById(source).value,16))>0xFF)))
      {
        wrong = 1;
      }
     }
     temp3 = document.getElementById(source).value;
     if (isNaN(parseInt(temp3.substring(2,temp3.length),16)) == true)
        wrong = 1;

     if (wrong == 1)
     {
        display_error(1);
        document.getElementById(source).value="0x0";
        document.getElementById(source).focus();
        wrong = 0;             
      }      
      else
      { 
        temp1 = document.getElementById(source).id;
        register_name = temp1.substring(0,temp1.length-5);
        temp3 = document.getElementById(source).value;
        register_value =  parseInt(temp3.substring(2,temp3.length),16);
        temp2 = register_name.substring(3,register_name.length);
        integer_to_array(register_value,AllRegisters[temp2]);
        visualization(AllRegisters[temp2],register_name,0,0,1);
        display_error(0);
      }
     }
     else if(document.getElementById(source).value.substring(0,2).toUpperCase() == "0B")
     {
     for (i=2;i< document.getElementById(source).value.length;i++)
     {
      if(!((document.getElementById(source).value.substring(i,i+1) == 0)||(document.getElementById(source).value.substring(i,i+1)==1))||(document.getElementById(source).value.length > 10))
      {
        wrong = 1;
      }
     }
     if (wrong == 1)
     {     
        display_error(1);
        document.getElementById(source).value="0b";
        document.getElementById(source).focus();
        wrong =0;       
      }
      else
      {
        temp1 = document.getElementById(source).id;
        register_name = temp1.substring(0,temp1.length-5);
        temp3 = document.getElementById(source).value;
        register_value =  parseInt(temp3.substring(2,temp3.length),2);
        temp2 = register_name.substring(3,register_name.length);
        integer_to_array(register_value,AllRegisters[temp2]);
        visualization(AllRegisters[temp2],register_name,0,0,1); 
        display_error(0);         
      }
     }
     else {
     for (i=0;i<document.getElementById(source).value.length;i++)
     {
     if((document.getElementById(source).value.substring(i,i+1).charCodeAt()<48)
      ||(document.getElementById(source).value.substring(i,i+1).charCodeAt() > 57)
      ||(document.getElementById(source).value > 255))
      {
        wrong = 1;
      }
     }
     if (wrong ==1)
     {
        display_error(1);
        document.getElementById(source).value="0";
        document.getElementById(source).focus();
        wrong = 0;
        return;      
     } 
     else
      { 
        temp1 = document.getElementById(source).id;
        register_name = temp1.substring(0,temp1.length-5);
        temp3 = document.getElementById(source).value; 
        register_value =  parseInt(temp3,10);
        temp2 = register_name.substring(3,register_name.length);
        integer_to_array(register_value,AllRegisters[temp2]);
        visualization(AllRegisters[temp2],register_name,0,0,1);
        display_error(0);      
      } 
  }
  }
//------------------------------------------------------------------------------
function array_to_integer(data_in_array)  // converts to binary format 0bxxxxxxxx
{ 
  var temp=" ";//="0b";
  var temp1;
  for (i=7; i>=0; i--)
  {
    temp = temp + data_in_array[i]
  }
  temp1 = parseInt(temp,2);
  return(temp1)
}
//------------------------------------------------------------------------------
function array_to_integer_dec(data_in_array)  // converts to dec format 
{ 
  var temp = " ";
  var temp2 = 0;
  for (i=0; i <=7; i++)
    temp2 = temp2 + parseInt(data_in_array[i])*Math.pow(2,i);
  return(temp2);
}
//------------------------------------------------------------------------------

function read_all()
{
   var bit=0;
   var temp =" ";
   //loading data from the target to the PC
   for (index=0; index <= AllRegisters.length - 1; index++)
   {
      if (AllRegisters[index][9] == 1)  // distinguish 16-bit registers
      {
        read(AllRegisters[index],AllRegisters[index+1]);
        index++;
      }
      else
      {
        read(AllRegisters[index]);
      }
   }   
   //vizualization of all registers from the PC memory
   for (index=0; index <= AllRegisters.length - 1; index++)  
   {
    for (bit=0;bit<=7; bit++)
    {
    temp = "bit_Reg"+index+bit; 

    if (AllRegisters[index][bit] == 0)
      {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_0";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_0";
      }  
    else
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_1";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_1";
    }
    }
   }
  for (index=0; index <= AllRegisters.length - 1; index++)
  {
    if (number_format == 0)
    {
      temp = "Reg"+index+"value";
      temp2 = array_to_integer(AllRegisters[index]);
      temp3 = temp2.toString(16);
      size = temp3.length;
      if (size < 2)
        temp3 = "0"+temp3;
      document.getElementById(temp).value = "0x"+temp3.toUpperCase();
    };
    if (number_format == 1)
    {
      temp = "Reg"+index+"value";
      temp2 = array_to_integer(AllRegisters[index]);
      document.getElementById(temp).value = temp2.toString(10);          
    };
    if (number_format == 2)
    {
      temp = "Reg"+index+"value";
      temp2 = array_to_integer(AllRegisters[index]);
      temp3 = temp2.toString(2)
      size = temp3.length;
      for (i=0;i<(8-size);i++)  //fill left zeroes
      {
        temp3="0"+temp3;
      }
      document.getElementById(temp).value = "0b"+temp3;               
    };
  }
}
//------------------------------------------------------------------------------

function read(register,next_register)
{
var temp;
var temp1;
var size;
var i;
var address = 0;
var aux_array = new Array(0, 0, 0, 0, 0, 0, 0, 0);
var aux_array_16 = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
// here the code for loading data from the target to the PC variable
    address = 0x200+register[8];
    size_reg = register[9];
    if (size_reg == 0)
    { 
      write_fmaster_variable("fm_register.fm_size", 0);
      write_fmaster_variable("fm_register.fm_address", address);
      write_fmaster_variable("fm_register.fm_read_write", 0);
      write_fmaster_variable("fm_register.fm_status", 1); //request pending
      
      temp1 = -1;
      while (temp1 == -1)
      {
       read_variable("fm_register.fm_status");
       temp1 = value;
      }
      read_variable("fm_register.fm_data");
      temp1 = value;
      temp = temp1.toString(2); //we need binary representation
      size = temp.length;
      for (i=0;i<(8-size);i++)  //fill left zeroes
      {
       temp="0"+temp;
      }
      for (i=0;i<8;i++)
      {
       aux_array[7-i] = temp.substring(i,i+1);
      }
      for (i=0;i<8;i++)
      {
       register[i] = aux_array[i];
      }
    }
    else // if 16-bit register
    {
      write_fmaster_variable("fm_register.fm_size", 1);
      write_fmaster_variable("fm_register.fm_address_16", address);
      write_fmaster_variable("fm_register.fm_read_write", 0);
      write_fmaster_variable("fm_register.fm_status", 1); //request pending
      temp1 = 1;
      while (temp1 == 1)  //waiting until the value is updated by MCU
      {
       read_variable("fm_register.fm_status");
       temp1 = value;
      }
      read_variable("fm_register.fm_data_16");
      temp1 = value;
      temp = temp1.toString(2); //we need binary representation
      size = temp.length;
      for (i=0;i<(16-size);i++)  //fill left zeroes
      {
       temp="0"+temp;
      }
      for (i=0;i<16;i++)
      {
       aux_array_16[15-i] = temp.substring(i,i+1);
      }
       for (i=0;i<8;i++)
      {
       register[i] = aux_array_16[8+i];
      }
      for (i=0;i<8;i++)
      {
       next_register[i] = aux_array_16[i];
      }
    }   
}
//------------------------------------------------------------------------------

// visualization
function readclick(register,registername,next_register,next_registername)
{

get_10_from_16(Reg89,Reg90);
    read(register,next_register); //read from target to PC memory
    visualization(register,registername,next_register,next_registername,0);
    if (number_format == 0)
    {
      temp = registername+"value";
      temp2 = array_to_integer(register);
      temp3 = temp2.toString(16);
      size = temp3.length;
      if (size < 2)
        temp3 = "0"+temp3;
      document.getElementById(temp).value = "0x"+temp3.toUpperCase();
    };
    if (number_format == 1)
    {
      temp = registername+"value";
      temp2 = array_to_integer(register);
      document.getElementById(temp).value = temp2.toString(10); 
    };
    if (number_format == 2)
    {
      temp = registername+"value";
      temp2 = array_to_integer(register);
      temp3 = temp2.toString(2)
      size = temp3.length;
      for (i=0;i<(8-size);i++)  //fill left zeroes
      {
        temp3="0"+temp3;
      }
      document.getElementById(temp).value = "0b"+temp3; 
    };
    size_reg = register[9];
    if (size_reg ==1 )
    {
    if (number_format == 0)
    {
      temp = next_registername+"value";
      temp2 = array_to_integer(next_register);
      temp3 = temp2.toString(16);
      size = temp3.length;
      if (size < 2)
        temp3 = "0"+temp3;
      document.getElementById(temp).value = "0x"+temp3.toUpperCase();
    };
    if (number_format == 1)
    {
      temp = next_registername+"value";
      temp2 = array_to_integer(next_register);
      document.getElementById(temp).value = temp2.toString(10); 
    };
    if (number_format == 2)
    {
      temp = next_registername+"value";
      temp2 = array_to_integer(next_register);
      temp3 = temp2.toString(2)
      size = temp3.length;
      for (i=0;i<(8-size);i++)  //fill left zeroes
      {
        temp3="0"+temp3;
      }
      document.getElementById(temp).value = "0b"+temp3; 
    };
    
    }

}

//------------------------------------------------------------------------------
function  visualization(register,registername,next_register,next_registername,not_visualize_n1)
{
  for (i=0;i<=7;i++)
  {
  temp = "bit_"+registername+i;
  if (register[i] == 0)
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_0";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_0";
    }
  else
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_1";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_1";
    }
  } //end of "for"
  
  size_reg = register[9];
  if ((size_reg == 1)&&(not_visualize_n1 == 0)) // fill also Reg+1
  {
  for (i=0;i<=7;i++)
  {
  temp = "bit_"+next_registername+i;
  if (next_register[i] == 0)
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_0";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_0";
    }
  else
    {
      if ((document.getElementById(temp).className == "BT_1")||(document.getElementById(temp).className == "BT_0")||(document.getElementById(temp).className =="BT"))
          document.getElementById(temp).className = "BT_1";
      if ((document.getElementById(temp).className == "inactive")||(document.getElementById(temp).className == "inactive_0")||(document.getElementById(temp).className =="inactive_1"))
          document.getElementById(temp).className = "inactive_1";
    }
   }
  }
} 
//------------------------------------------------------------------------------

function write(register,next_register)
{
  var address;
  var value16;  
    address = 0x200+register[8];
    write_fmaster_variable("fm_register.fm_size", 0);
    write_fmaster_variable("fm_register.fm_read_write", 1);
    write_fmaster_variable("fm_register.fm_address", address);
    write_fmaster_variable("fm_register.fm_data", array_to_integer(register));
    write_fmaster_variable("fm_register.fm_status", 1); //set request pending
    size_reg = register[9];
    if (size_reg == 1)
    {
      value16 = array_to_integer(register) * 256;
      value16 = value16 + array_to_integer(next_register);
      write_fmaster_variable("fm_register.fm_size", 1);
      write_fmaster_variable("fm_register.fm_read_write", 1);
      write_fmaster_variable("fm_register.fm_address_16", address);
      write_fmaster_variable("fm_register.fm_data_16", value16);
      write_fmaster_variable("fm_register.fm_status", 1); // set request pending    
    }
//    if (register[8] == 22)
//      su = FreeMaster.StartStopComm(false);

}

//------------------------------------------------------------------------------
function writeclick(register,registername,next_register,next_registername)
{
  write(register,next_register);

      //    readclick(register,registername); // because other bits can be changed by writing to the register     
}
//------------------------------------------------------------------------------
function ChangeNumberFormat(format)
{
  for (index=0; index <= AllRegisters.length - 1; index++)
  {
    if (format == 0)
    {
      temp = "Reg"+index+"value";
      temp2 = array_to_integer(AllRegisters[index]);
      temp3 = temp2.toString(16);
      size = temp3.length;
      if (size < 2)
        temp3 = "0"+temp3;
      document.getElementById(temp).value = "0x"+temp3.toUpperCase();
      number_format = 0;
    };
    if (format == 1)
    {
      temp = "Reg"+index+"value";
      temp2 = array_to_integer(AllRegisters[index]);
      document.getElementById(temp).value = temp2.toString(10); 
      number_format = 1;         
    };
    if (format == 2)
    {
      temp = "Reg"+index+"value";
      temp2 = array_to_integer(AllRegisters[index]);
      temp3 = temp2.toString(2)
      size = temp3.length;
      for (i=0;i<(8-size);i++)  //fill left zeroes
      {
        temp3="0"+temp3;
      }
      document.getElementById(temp).value = "0b"+temp3; 
      number_format = 2;            
    };
  }

}
//------------------------------------------------------------------------------
function B_back_onMouseDown()
{
  document.images['B_back'].src='script&pictures/back2.jpg';
}
//------------------------------------------------------------------------------ 
function B_back_onMouseUp()
{

  document.images['B_back'].src='script&pictures/back1.jpg';
  interval = clearInterval(interval);
  window.history.back();
}
//****************************************************************************************
//****************************************************************************************

//****************************************************************************************
//          ** **   Functions supporting the UserFriendly control panel **  **
//****************************************************************************************

//****************************************************************************************
//****************************************************************************************
//----------------------------------------------------------------------------
function start_page()
{
  InitTimer();
  //adc config and enabling, if communication running
  Reg65[5] = 0;
  Reg65[6] = 0;
  write(Reg65);
  read(Reg66);
  //enable current sense
  Reg23[7] = 1;
  Reg23[3] = 0;
  write(Reg23);
  
  reset_control_elements();
}
//----------------------------------------------------------------------------
function reset_control_elements()  // all control items (checkboxes, lists, radios) remembers its previous value after F5 or reset
{
//reseting the control items
  //PWM
  document.getElementById("HS1_BT").className = "BT0";
  document.getElementById("HS2_BT").className = "BT0";
  document.getElementById("LS1_BT").className = "BT0";
  document.getElementById("LS2_BT").className = "BT0";
  PWM_enable0_onclick(0);
  PWM_enable1_onclick(0);
  document.getElementById("PWM0_en").checked = false;
  document.getElementById("PWM1_en").checked = false;
  document.getElementById("pl0").checked = true;
  document.getElementById("PWMradio1").checked = true;
  document.getElementById("freq_range").value = 1;
  document.getElementById("PWMHS1EN").checked = false;
  document.getElementById("PWMHS2EN").checked = false;
  document.getElementById("PWMLS1EN").checked = false;
  document.getElementById("PWMLS2EN").checked = false;
  document.getElementById("hs1_PWM_source1").checked = true;
  document.getElementById("hs2_PWM_source1").checked = true;
  document.getElementById("ls1_PWM_source1").checked = true;
  document.getElementById("ls2_PWM_source1").checked = true;
 
  On_Pwm_Freq_change();
  PWM_selection_onclick(1);
  PWM_selection_onclick(0);
  //wake up           
  document.getElementById("wu_sel3").checked = true;
  document.getElementById("lx_0").checked = true;
  document.getElementById("cyclic").checked = false;
  document.getElementById("lx_cycletime").value = 1;
  document.getElementById("hs1_select").checked = true;
  document.getElementById("hs2_select").checked = false;
  document.getElementById("waketime").value = 1;
  document.getElementById("cycletime_multiplier").value = 1;
  None_onclick();
  //ADC
  document.getElementById("AD0").checked = true;
  document.getElementById("AD1").checked = false;
  document.getElementById("AD2").checked = false;
  document.getElementById("AD10").checked = true;
  document.getElementById("L0").checked = true;   
  document.getElementById("RS1").checked = true;
  graph.ClearAll();
  //LIN
  document.getElementById("LIN_EN").checked = false;
  //WD
  document.getElementById("WD_EN").checked = true;
  
//reseting the control variables  
hs1_on = 0;
hs2_on = 0;
ls1_on = 0;
ls2_on = 0;

channel_selected = 0;
duty = 0;
frequency = 0;
range = 1;
polarity = 0;

duty_ch0 = 20;
frequency_ch0 = 10;
frequency_range_ch0 = 1;
polarity_ch0 = 1;

duty_ch1 = 40;
frequency_ch1 = 50;
frequency_range_ch1 = 1;
polarity_ch1 = 1;

wu_select = 0;
multiplier ="1";
time = "1";
cyclic_sense =0;
lx_time = 1;
cyclic_source1 =1;
cyclic_source2 =0;

fifo_index = 0;
graph.xmajortics = 2;
graph.xminortics = 1;
graph.xdisplaymax = 200;
graph.xdisplaymin = 0;

su = 0;
close_port = false;
}
//----------------------------------------------------------------------------
function WD_En_click(checked)
{
  if (checked)
    write_fmaster_variable("WD_enabled",1)
  else
    write_fmaster_variable("WD_enabled",0)
}
//----------------------------------------------------------------------------

function InitTimer()
{
	interval = setInterval(Timer, 10);
}
//----------------------------------------------------------------------------
function Timer()
{
    UpdateADC();
    if (!(adc_stop_visualization))
    {
      ADC_visualization();
      Update_status_registers();    
      Show_LIN_message();
    }
}
//----------------------------------------------------------------------------
function Update_status_registers()
{
  read(Reg4);
  read(Reg11);
  read(Reg12);
  VSR_value = array_to_integer(Reg4); 
  WSR_value = array_to_integer(Reg11);
  RSR_value = array_to_integer(Reg12);
  if (VSR_value == 0xFF)
      VSR_value = 0;
  if (VSR_value & 0x1) document.getElementById("LBC").className = "one";
    else document.getElementById("LBC").className = "zero";
  if (VSR_value & 0x2) document.getElementById("LVC").className = "one";
    else document.getElementById("LVC").className = "zero";
  if (VSR_value & 0x4) document.getElementById("HVC").className = "one";
    else document.getElementById("HVC").className = "zero";
  if (VSR_value & 0x8) document.getElementById("HTC").className = "one";
    else document.getElementById("HTC").className = "zero";
  if (WSR_value!=0)
    if (WSR_value != WSR_value_old)
    {
      WSR_value_old = WSR_value;
      if (WSR_value == 0xFF)
          WSR_value = 0;  
      if (WSR_value & 0x1) document.getElementById("L0WU").className = "one";
        else document.getElementById("L0WU").className = "zero";
      if (WSR_value & 0x2) document.getElementById("L1WU").className = "one";
        else document.getElementById("L1WU").className = "zero";
      if (WSR_value & 0x4) document.getElementById("L2WU").className = "one";
        else document.getElementById("L2WU").className = "zero";
      if (WSR_value & 0x8) document.getElementById("L3WU").className = "one";
        else document.getElementById("L3WU").className = "zero";
      if (WSR_value & 0x10) document.getElementById("L4WU").className = "one";
        else document.getElementById("L4WU").className = "zero";
      if (WSR_value & 0x20) document.getElementById("L5WU").className = "one";
        else document.getElementById("L5WU").className = "zero";
      if (WSR_value & 0x40) document.getElementById("LINWU").className = "one";
        else document.getElementById("LINWU").className = "zero";
      if (WSR_value & 0x80) document.getElementById("FWU").className = "one";
        else document.getElementById("FWU").className = "zero";  
    }
    if (RSR_value!=0)
    if (RSR_value != RSR_value_old)
    {
      reset_control_elements();
      RSR_value_old = RSR_value;
      if (RSR_value == 0xFF)
          RSR_value = 0;
      if (RSR_value & 0x1) document.getElementById("POR").className = "one";
        else document.getElementById("POR").className = "zero";
      if (RSR_value & 0x2) document.getElementById("LVR").className = "one";
        else document.getElementById("LVR").className = "zero";
      if (RSR_value & 0x4) document.getElementById("LVRX").className = "one";
        else document.getElementById("LVRX").className = "zero";
      if (RSR_value & 0x8) document.getElementById("WUR").className = "one";
        else document.getElementById("WUR").className = "zero";
      if (RSR_value & 0x10) document.getElementById("EXR").className = "one";
        else document.getElementById("EXR").className = "zero";
      if (RSR_value & 0x20) document.getElementById("WDR").className = "one";
        else document.getElementById("WDR").className = "zero";
    }
}
//----------------------------------------------------------------------------
function UpdateADC()
{

  //START ADC
    integer_to_array(0x0F,Reg68);  // start of conversion Ch0
    integer_to_array(0xFF,Reg67);
    write(Reg67,Reg68);
    read(Reg70);
}
//----------------------------------------------------------------------------    
function ADC_visualization()
{   
    for (i=0; i<=22; (i+=2))
    {  
       read(AllRegisters[71+i],AllRegisters[71+i+1]);  // read all result registers
    }
    for (i=0; i < 3; i++)
    {       
      AdResult[i] = array_to_integer_dec(AllRegisters[71+2*i]);
      AdResult[i] = 9.83 * AdResult[i]; 
    }
    for (i=0;i<6;i++)
    {
      AdResult[3+i] = 0;
      if (lx_select == i)
      {
        AdResult[3+i] = array_to_integer_dec(AllRegisters[77+2*i]);
        if (lx_range == 1)
          AdResult[3+i] = 2 * 10 *  AdResult[3] / 7.2;
        else
        {
          AdResult[3+i] = AdResult[3]*10; //need to convert the number for 2500 mV scale
        }
      }        
    }
    AdResult[9] = array_to_integer_dec(AllRegisters[89]);
    AdResult[9] = 9.83 * AdResult[9]; 
    AdResult[10] = array_to_integer_dec(AllRegisters[91]);
    AdResult[10] = 9.83 * AdResult[10]*10.8 /(270/25); // recalculation to 2500mV scale - 27000 mV ~ 2500 mV     
    AdResult[11] = array_to_integer_dec(AllRegisters[93]);
    AdResult[11] = ((((AdResult[11] * (2.5/255) -0.15)/0.009224)-50)+50)/200*2500;      
    fifo0.unshift(AdResult[0]);
    fifo1.unshift(AdResult[1]);
    fifo2.unshift(AdResult[2]);
    fifo3.unshift(AdResult[3]);
    fifo4.unshift(AdResult[4]);
    fifo5.unshift(AdResult[5]);
    fifo6.unshift(AdResult[6]);
    fifo7.unshift(AdResult[7]);
    fifo8.unshift(AdResult[8]);
    fifo9.unshift(AdResult[9]); // current
    fifo10.unshift(AdResult[10]); // voltage
    fifo11.unshift(AdResult[11]); //temperature
    fifo_index++;
    if (fifo_index == fifo_index_max)
    {
       dummy = fifo0.pop();
       dummy = fifo1.pop();
       dummy = fifo2.pop();
       dummy = fifo3.pop();
       dummy = fifo4.pop();
       dummy = fifo5.pop();
       dummy = fifo6.pop();
       dummy = fifo7.pop();
       dummy = fifo8.pop();
       dummy = fifo9.pop();
       dummy = fifo10.pop();
       dummy = fifo11.pop();       
       fifo_index--;
    }
    {
      if (ad0_select == 1)
      {
        graph.AddY(0, AdResult[0]);
      }
      if (ad1_select == 1)
      {
        graph.AddY(1, AdResult[1]);
      }
      if (ad2_select == 1)
      {
        graph.AddY(2, AdResult[2]);
       }      
      if ((lx_select == 0)&& (lx_enabled == 1))
      {
        graph.AddY(3, AdResult[3]);
      } 
      if ((lx_select == 1)&& (lx_enabled == 1))
      {
        graph.AddY(3, AdResult[4]);
      }       
      if ((lx_select == 2)&& (lx_enabled == 1))
      {
        graph.AddY(3, AdResult[5]);
      }       
      if ((lx_select == 3)&& (lx_enabled == 1))
      {
        graph.AddY(3, AdResult[6]);
      }       
      if ((lx_select == 4)&& (lx_enabled == 1))
      {
        graph.AddY(3, AdResult[7]);
      }       
      if ((lx_select == 5)&& (lx_enabled == 1))
      {
        graph.AddY(3, AdResult[8]);
      }       
      if (ad9_select == 1)
      {
        graph.AddY(3, AdResult[9]);
      }       
      if (ad10_select == 1)
      {
        graph.AddY(3, AdResult[10]);
      }       
      if (ad11_select == 1)
      {
        graph.AddY(3, AdResult[11]);
      } 
     }       

    voltage = array_to_integer_dec(Reg91);
    voltage = Math.round(voltage * (2.5/ 255) * 10.8 * 10) /10 ; //we want to have 1 decimal place
    document.getElementById("voltage").value = voltage;
    
    temperature = array_to_integer_dec(Reg93);
    temperature = Math.round((((temperature * (2.5/255) -0.15)/0.009224)-50)) ;
    document.getElementById("temperature").value = temperature;
    

    document.getElementById("current").value = get_10_from_16(Reg89,Reg90);
    //get_10_from_16(Reg89,Reg90);
}
//----------------------------------------------------------------------------
function get_10_from_16(register,register_1)
{
    var number_10 = new Array;
    var number =" ";
    for (i = 0; i<8; i++)
    {
      number_10[i] = register[7-i];
    }
    number_10[8] = register_1[7];
    number_10[9] = register_1[6];
    for (i =0 ;i<10 ;i++)
    {
      number = number + number_10[i];
    }
    temp1 = parseInt(number,2);
    return temp1;
    
}
//----------------------------------------------------------------------------
function rangeclick(range)
{
if (lx_enabled ==1)
{
  if (range == 0)
  {
    lx_range = 0;
    graph.TrackID = 1;
    graph.TrackDisplayMax1 = 5;
    graph.TrackMax = 5;
    graph.ClearAll();
    graph.TrackMajorTics = 10;
    if (fifo_index_max >= graph.xdisplaymax)
    {
    for (i=fifo_index;i>=0;i--)
    {
      fifo3[i] = fifo3[i]*3.6;
      graph.AddY(3,fifo3[i]);
      graph.Addy(0,fifo0[i]);
      graph.Addy(1,fifo1[i]);
      graph.Addy(2,fifo2[i]);
    };
    }
    else
    {
    for (i=0;i<graph.xdisplaymax-fifo_index;i++)
    {
      graph.AddY(3,0);
      graph.Addy(0,0);
      graph.Addy(1,0);
      graph.Addy(2,0);    
    }
    for (i=graph.xdisplaymax-fifo_index;i<graph.xdisplaymax;i++)
    {
      fifo3[i] = fifo3[i]*3.6;
      graph.AddY(3,fifo3[i]);
      graph.Addy(0,fifo0[i]);
      graph.Addy(1,fifo1[i]);
      graph.Addy(2,fifo2[i]);
    };
    }
  }
  else
  {
    lx_range = 1;
    graph.TrackID = 1;
    graph.TrackDisplayMax = 18;
    graph.TrackMax = 18;
    graph.TrackMajorTics = 17;
    graph.ClearAll();
    for (i=fifo_index;i>=0;i--)
    {
      fifo3[i] = fifo3[i]/3.6;
      graph.AddY(3,fifo3[i]);
      graph.Addy(0,fifo0[i]);
      graph.Addy(1,fifo1[i]);
      graph.Addy(2,fifo2[i]);
    };
  }  
 }
}
//----------------------------------------------------------------------------
function update_graph()
{
    if (fifo_index_max >= graph.xdisplaymax)
    for (i=fifo_index;i>=0;i--)
    {
      if (ad3_select == 1)
        graph.AddY(3,fifo3[i]);
      if (ad4_select == 1)
        graph.AddY(3,fifo4[i]);
      if (ad5_select == 1)
        graph.AddY(3,fifo5[i]);
      if (ad6_select == 1)
        graph.AddY(3,fifo6[i]);
      if (ad7_select == 1)
        graph.AddY(3,fifo7[i]);
      if (ad8_select == 1)
        graph.AddY(3,fifo8[i]);
      if (ad9_select == 1)
        graph.AddY(3,fifo9[i]);
      if (ad10_select == 1)
        graph.AddY(3,fifo10[i]); 
      if (ad11_select == 1)
        graph.AddY(3,fifo11[i]);                                                               
      if (ad0_select == 1)
        graph.Addy(0,fifo0[i]);      
      if (ad1_select == 1)
        graph.Addy(1,fifo1[i]);
      if (ad2_select == 1)
        graph.Addy(2,fifo2[i]);
    }
    else
    {
    for (i=0;i<graph.xdisplaymax-fifo_index-2;i++)
    {
      graph.AddY(3,0);
      graph.Addy(0,0);
      graph.Addy(1,0);
      graph.Addy(2,0);    
    }
    for (i=fifo_index;i>=0;i--)
    {
      if (ad3_select == 1)
        graph.AddY(3,fifo3[i]);
      if (ad4_select == 1)
        graph.AddY(3,fifo4[i]);
      if (ad5_select == 1)
        graph.AddY(3,fifo5[i]);
      if (ad6_select == 1)
        graph.AddY(3,fifo6[i]);
      if (ad7_select == 1)
        graph.AddY(3,fifo7[i]);
      if (ad8_select == 1)
        graph.AddY(3,fifo8[i]);
      if (ad9_select == 1)
        graph.AddY(3,fifo9[i]);
      if (ad10_select == 1)
        graph.AddY(3,fifo10[i]); 
      if (ad11_select == 1)
        graph.AddY(3,fifo11[i]);                                                               
      if (ad0_select == 1)
        graph.Addy(0,fifo0[i]);      
      if (ad1_select == 1)
        graph.Addy(1,fifo1[i]);
      if (ad2_select == 1)
        graph.Addy(2,fifo2[i]);
    }
     
    }    

}
//----------------------------------------------------------------------------
function ad_click(source,checked)
{
 if ((source == "AD0")||(source == "AD1")||(source == "AD2"))
 { 
    graph.ClearAll();
    if (source == "AD0")
      if (checked)
        ad0_select =1
      else
        ad0_select =0;
    if (source == "AD1")
      if (checked)
        ad1_select =1
      else
        ad1_select =0;
    if (source == "AD2")
      if (checked)
        ad2_select =1
      else
        ad2_select =0;
                
 }
 if ((source == "AD3")||(source == "AD4")||(source == "AD5")||(source == "AD6")||(source == "AD7")||(source == "AD8")||(source == "AD9")||(source == "AD10")||(source == "AD11"))
 {
    if (source == "AD3")
      if (checked)
      {
        ad3_select =1;
        ad4_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =0;
        ad8_select =0;
        ad9_select =0;
        ad10_select =0;
        ad11_select =0;
      }        
      else
        ad3_select =0;
    if (source == "AD4")
      if (checked)
      {
        ad4_select =1;
        ad3_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =0;
        ad8_select =0;
        ad9_select =0;
        ad10_select =0;
        ad11_select =0; 
      }       
      else
        ad4_select =0;
    if (source == "AD5")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =1;
        ad6_select =0;
        ad7_select =0;
        ad8_select =0;
        ad9_select =0;
        ad10_select =0;
        ad11_select =0; 
      }       
      else
        ad5_select =0;
    if (source == "AD6")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =0;
        ad6_select =1;
        ad7_select =0;
        ad8_select =0;
        ad9_select =0;
        ad10_select =0;
        ad11_select =0; 
      }       
      else
        ad6_select =0;
    if (source == "AD7")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =7;
        ad8_select =0;
        ad9_select =0;
        ad10_select =0;
        ad11_select =0; 
      }       
      else
        ad7_select =0;
    if (source == "AD8")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =0;
        ad8_select =1;
        ad9_select =0;
        ad10_select =0;
        ad11_select =0; 
      }       
      else
        ad8_select =0;
    if (source == "AD9")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =0;
        ad8_select =0;
        ad9_select =1;
        ad10_select =0;
        ad11_select =0; 
        lx_enabled = 0;
      }       
      else
        ad9_select =0;
    if (source == "AD10")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =0;
        ad8_select =0;
        ad9_select =0;
        ad10_select =1;
        ad11_select =0;
        lx_enabled = 0; 
      }       
      else
        ad10_select =0;
    if (source == "AD11")
      if (checked)
      {
        ad4_select =0;
        ad3_select =0;
        ad5_select =0;
        ad6_select =0;
        ad7_select =0;
        ad8_select =0;
        ad9_select =0;
        ad10_select =0;
        ad11_select =1;
        lx_enabled = 0; 
      }       
      else
        ad11_select =0;

 if (ad9_select==1) 
 {         
  graph.CaptionID = 1;
  graph.Caption = "I [raw]";
  graph.TrackID = 1;
  graph.TrackDisplayMax = 1024;
  graph.TrackMax = 1024;
  graph.TrackDisplayMin = 0;
  graph.TrackMin = 0 ;  
  graph.TrackMajorTics = 10;
  graph.ClearAll(); 
 }
 else if (ad10_select==1) 
 {         
  graph.CaptionID = 1;
  graph.Caption = "V batt [V]";
  graph.TrackID = 1;
  graph.TrackDisplayMax = 27;
  graph.TrackMax = 27;
  graph.TrackDisplayMin = 0;
  graph.TrackMin = 0 ;  
  graph.TrackMajorTics = 10;
  graph.ClearAll();  
 }
 else if (ad11_select==1)
 {
  graph.CaptionID = 1;
  graph.Caption = "Temp [C]";
  graph.TrackID = 1;
  graph.TrackDisplayMax = 150;
  graph.TrackMax = 150;
  graph.TrackDisplayMin = -50;
  graph.TrackMin = -50 ;
  graph.TrackMajorTics = 17;
  graph.ClearAll();
 }      
 else
 {
  graph.CaptionID = 1;
  graph.Caption = "Lx [V]";
  graph.TrackID = 1;
  if (lx_range == 0)
  {
    graph.TrackDisplayMax1 = 5;
    graph.TrackMax = 5;
    graph.TrackDisplayMin = 0;
    graph.TrackMin = 0 ;  
    graph.TrackMajorTics = 10;
  }
  else
  {
    graph.TrackDisplayMax = 18;
    graph.TrackMax = 18; 
    graph.TrackDisplayMin = 0;
    graph.TrackMin = 0 ;  
    graph.TrackMajorTics = 17;     
  }
  graph.ClearAll();   
 }
 if (lx_enabled == 0)
 {
   document.getElementById("RS1").disabled = true; 
   document.getElementById("RS2").disabled = true; 
 }
 }
 
 update_graph();
}
//----------------------------------------------------------------------------
function ad_click_Lx()
{
var source;
  switch (lx_select) {
    case 0: source = "AD3"; break;
    case 1: source = "AD4"; break;
    case 2: source = "AD5"; break;
    case 3: source = "AD6"; break;
    case 4: source = "AD7"; break;
    case 5: source = "AD8"; break;
  }
  ad_click(source,true);
  lx_enabled = 1; 
  document.getElementById("RS1").disabled = false;
  document.getElementById("RS2").disabled = false; 
}
//----------------------------------------------------------------------------
function buttonHS1click()
{
    if (hs1_on == 0)
    {
      document.getElementById("HS1_BT").className = "BT1";
      document.getElementById("HS1_BT").value = "HS1 ON";
      hs1_on = 1;
      Reg18[0]=1;
      write(Reg18);      
    }
    else
    {
      document.getElementById("HS1_BT").className = "BT0";
      document.getElementById("HS1_BT").value = "HS1 OFF";
      hs1_on = 0; 
      Reg18[0]=0;
      write(Reg18);                      
    }
}
//----------------------------------------------------------------------------
function buttonHS2click()
{
    if (hs2_on == 0)
    {
      document.getElementById("HS2_BT").className = "BT1";
      document.getElementById("HS2_BT").value = "HS2 ON";
      hs2_on = 1;
      Reg18[1]=1;
      write(Reg18);      
    }
    else
    {
      document.getElementById("HS2_BT").className = "BT0";
      document.getElementById("HS2_BT").value = "HS2 OFF";
      hs2_on = 0; 
      Reg18[1]=0;
      write(Reg18);                      
    }
}
//----------------------------------------------------------------------------
function buttonLS1click()
{
    if (ls1_on == 0)
    {
      document.getElementById("LS1_BT").className = "BT1";
      document.getElementById("LS1_BT").value = "LS1 ON";
      ls1_on = 1;
      Reg20[0]=1;
      write(Reg20);      
    }
    else
    {
      document.getElementById("LS1_BT").className = "BT0";
      document.getElementById("LS1_BT").value = "LS1 OFF";
      ls1_on = 0; 
      Reg20[0]=0;
      write(Reg20);                      
    }
}
//----------------------------------------------------------------------------
function buttonLS2click()
{
    if (ls2_on == 0)
    {
      document.getElementById("LS2_BT").className = "BT1";
      document.getElementById("LS2_BT").value = "LS2 ON";
      ls2_on = 1;
      Reg20[1]=1;
      write(Reg20);      
    }
    else
    {
      document.getElementById("LS2_BT").className = "BT0";
      document.getElementById("LS2_BT").value = "LS2 OFF";
      ls2_on = 0; 
      Reg20[1]=0;
      write(Reg20);                      
    }
}

//----------------------------------------------------------------------------
function integer_to_array(number,register)   // converts dec value to binary array
{
var temp_array = new Array(0, 0, 0, 0, 0, 0, 0, 0);
var temp1
    temp = number.toString(2);
    size = temp.length;
    for (i=0;i<(8-size);i++)  //fill left zeroes
    {
      temp="0"+temp;
    }
for (index = 0; index < 8; index++)
  {
    temp_array[7-index]= temp.substring(index,index+1);
  }
    for (i=0;i<8;i++)
    {
      register[i] = temp_array[i];
    }
}
//----------------------------------------------------------------------------

function set_polarity(pol)
{
  if(pol == 1)
    if (channel_selected == 0)
      {
        Reg55[2]=1;
        write(Reg55);
        polarity_ch0 = 1;
      }
    else
      {
        Reg55[3]=1;
        write(Reg55);
        polarity_ch1 = 1;
      }
  else
    if (channel_selected == 0)
      {
        Reg55[2]=0;
        write(Reg55);
        polarity_ch0 = 0;      
      }
    else
      {
        Reg55[3]=0;
        write(Reg55)
        polarity_ch1 = 0;         
      } 
}
//----------------------------------------------------------------------------

function PWM_enable0_onclick(status)
{

  if (status == 0)
  { //disable module 0
      Reg55[0] = 0;
      write(Reg55);      
  }
  else
  { //enable module 0
	    On_Pwm_Freq_change();      
      Reg55[0] = 1;
      //Reg55[2] = 1;  // positive polarity
      write(Reg55);
  }    
}

//----------------------------------------------------------------------------

function PWM_enable1_onclick(status)
{

  if (status == 0)
  { //disable module 1
      Reg55[1] = 0;
      write(Reg55); //PWMCTL     
  }
  else
  { //enable module 1
	    On_Pwm_Freq_change();      
      Reg55[1] = 1;
     // Reg55[3] = 1;
      write(Reg55); //PWMCTL
  }    
}

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
function On_Pwm_Duty_change()		
{
	On_Pwm_Freq_change(); 	
}
//----------------------------------------------------------------------------
function On_Pwm_Freq_change()			
{
if (channel_selected == 0)
  {
	if ((frequency_range_ch0 == 1)||((frequency_range_ch0 == 2)&&(sld_pwm_freq.value <10)))
	{
      Reg55[4] = 1; // prescaler will be used
      Reg55[6] = 1; // center aligned PWM will be used for very low frequencies
      write(Reg55); //PWMCTL
      Reg56[0] = 1;
      Reg56[1] = 1;
      Reg56[2] = 1; //Prescaler value 110
      write(Reg56); //PWMPRCLK
      integer_to_array(31,Reg57); //Scale clock A
      write(Reg57);
    	frequency_ch0 = 2550 / sld_pwm_freq.Value;
    	if (frequency_range_ch0 == 2)
    	   frequency_ch0 = 3500 / sld_pwm_freq.Value;
      integer_to_array(frequency_ch0,Reg61);
      write(Reg61);
      duty_ch0 = sld_pwm_duty.Value * (frequency_ch0 / 100);
      integer_to_array(duty_ch0,Reg63);
      write(Reg63);
	}
	if (frequency_range_ch0 == 2)
  {  
      Reg55[4] = 1; // scale reg. will be used
      Reg55[6] = 1; // center aligned PWM
      write(Reg55); //PWMCTL
      Reg56[0] = 1;
      Reg56[1] = 1;
      Reg56[2] = 0; //Prescaler value 110
      write(Reg56); //PWMPRCLK
      frequency_ch0 = 2035 / sld_pwm_freq.Value; 
      integer_to_array(62,Reg57); //Scale clock A
      write(Reg57);      
      integer_to_array(frequency_ch0,Reg61);
      write(Reg61);
      duty_ch0 = frequency_ch0 - sld_pwm_duty.Value * (frequency_ch0 / 100);
      integer_to_array(duty_ch0,Reg63);
      write(Reg63);
   }
	if (frequency_range_ch0 == 3)
  {   
      Reg55[4] = 1; // scale register will be used
      Reg55[6] = 0; // edge aligned PWM 
      write(Reg55); //PWMCTL
      Reg56[0] = 0;
      Reg56[1] = 0;
      Reg56[2] = 0; //Prescaler value 011
      write(Reg56); //PWMPRCLK
      integer_to_array(100,Reg57); //Scale of clock A
      write(Reg57);       
    	frequency_ch0 = 2050 / sld_pwm_freq.Value;
      integer_to_array(frequency_ch0,Reg61);
      write(Reg61);
      duty_ch0 = sld_pwm_duty.Value * (frequency_ch0 / 100);
      integer_to_array(duty_ch0,Reg63);
      write(Reg63);
   }
	if (frequency_range_ch0 == 4)
  {   
      Reg55[4] = 0; // scale register used
      Reg55[6] = 0; // center aligned PWM used    
      write(Reg55); //PWMCTL
      Reg56[0] = 0;
      Reg56[1] = 0;
      Reg56[2] = 1; //Prescaler value 010
      write(Reg56); //PWMPRCLK
      integer_to_array(20,Reg57); //Scale clock A
      write(Reg57);       
    	frequency_ch0 = 2530 / sld_pwm_freq.Value;
      integer_to_array(frequency_ch0,Reg61);
      write(Reg61);
      duty_ch0 = sld_pwm_duty.Value * (frequency_ch0 / 100); 
      integer_to_array(duty_ch0,Reg63);
      write(Reg63);
   } 
 	if (frequency_range_ch0 == 5)
  {   
      Reg55[4] = 0; // scale register not used
      Reg55[6] = 1; // center aligned PWM used       
      write(Reg55); //PWMCTL
      Reg56[0] = 0;
      Reg56[1] = 0;
      Reg56[2] = 0; //Prescaler value 000
      write(Reg56); //PWMPRCLK
      integer_to_array(1,Reg57); //Scale clock A
      write(Reg57);      
    	frequency_ch0 = 2050 / sld_pwm_freq.Value;
      integer_to_array(frequency_ch0,Reg61);
      write(Reg61);
      duty_ch0 = sld_pwm_duty.Value * (frequency_ch0 / 100);
      integer_to_array(duty_ch0,Reg63);
      write(Reg63);
   }  
	if (frequency_range_ch0 == 6)
  {   
      Reg55[4] = 0; // prescaler used
      Reg55[6] = 0; // edge aligned PWM used       
      write(Reg55); //PWMCTL
      Reg56[0] = 0;
      Reg56[1] = 0;
      Reg56[2] = 0; //Prescaler value 000
      write(Reg56); //PWMPRCLK
      integer_to_array(1,Reg57); //Scale clock A
      write(Reg57);      
    	frequency_ch0 = 400 / sld_pwm_freq.Value;
      integer_to_array(frequency_ch0,Reg61);
      write(Reg61);
      duty_ch0 = sld_pwm_duty.Value * (frequency_ch0 / 100);
      integer_to_array(duty_ch0,Reg63);
      write(Reg63);
   }     
}
else
{
	if (frequency_range_ch1 == 1)
  {   
      Reg55[5] = 1; // prescaler will be used
      Reg55[7] = 1; // center aligned PWM will be used for very small frequencies
      write(Reg55); //PWMCTL
      Reg56[4] = 1;
      Reg56[5] = 0;
      Reg56[6] = 1; //Prescaler value 111
      write(Reg56); //PWMPRCLK
    	frequency1 = 1240 / sld_pwm_freq.Value;
      integer_to_array(frequency1,Reg62);
      write(Reg62);
      duty1 = sld_pwm_duty.Value * (frequency1 / 100);
      integer_to_array(duty1,Reg64);
      write(Reg64);
   }
	if (frequency_range_ch1 == 2)
  {   
      Reg55[5] = 1; // prescaler will be used
      Reg55[7] = 1; // center aligned PWM will be used for very small frequencies
      write(Reg55); //PWMCTL
      Reg56[4] = 1;
      Reg56[5] = 0;
      Reg56[6] = 0; //Prescaler value 001
      write(Reg56); //PWMPRCLK
    	frequency1 = 1980 / sld_pwm_freq.Value;
      integer_to_array(frequency1,Reg62);
      write(Reg62);
      duty1 = sld_pwm_duty.Value * (frequency1 / 100);
      integer_to_array(duty1,Reg64);
      write(Reg64);
   }
	if (frequency_range_ch1 == 3)
  {   
      Reg55[5] = 0; // prescaler not used
      Reg55[7] = 1; // center aligned PWM used
      write(Reg55); //PWMCTL
      Reg56[4] = 1;
      Reg56[5] = 1;
      Reg56[6] = 1; //Prescaler value 000
      write(Reg56); //PWMPRCLK
    	frequency1 = 1580 / sld_pwm_freq.Value;
      write(Reg62);
      duty1 = sld_pwm_duty.Value * (frequency1 / 100);
      integer_to_array(duty1,Reg64);
      write(Reg64);
   } 
 	if (frequency_range_ch1 == 4)
  {   
      Reg55[5] = 0; // prescaler not used
      Reg55[7] = 0; // edge aligned PWM used 
      write(Reg55); //PWMCTL
      Reg56[4] = 0;
      Reg56[5] = 0;
      Reg56[6] = 1; //Prescaler value 100
      write(Reg56); //PWMPRCLK
    	frequency1 = 2530 / sld_pwm_freq.Value;
      write(Reg62);
      duty1 = sld_pwm_duty.Value * (frequency1 / 100);
      integer_to_array(duty1,Reg64);
      write(Reg64);
   }  
	if (frequency_range_ch1 == 5)
  {   
      Reg55[5] = 0; // prescaler not used
      Reg55[7] = 0; // edge aligned PWM used 
      write(Reg55); //PWMCTL
      Reg56[4] = 1;
      Reg56[5] = 0;
      Reg56[6] = 0; //Prescaler value 001
      write(Reg56); //PWMPRCLK
    	frequency1 = 2020 / sld_pwm_freq.Value;
      write(Reg62);
      duty1 = sld_pwm_duty.Value * (frequency1 / 100);
      integer_to_array(duty1,Reg64);
      write(Reg64);
   } 
	if (frequency_range_ch1 == 6)
  {   
      Reg55[5] = 0; // prescaler not used
      Reg55[7] = 0; // edge aligned PWM used 
      write(Reg55); //PWMCTL
      Reg56[4] = 0;
      Reg56[5] = 0;
      Reg56[6] = 0; //Prescaler value 000
      write(Reg56); //PWMPRCLK
    	frequency1 = 400 / sld_pwm_freq.Value;
      write(Reg62);
      duty1 = sld_pwm_duty.Value * (frequency1 / 100);
      integer_to_array(duty1,Reg64);
      write(Reg64);
   }     
  }
  if (polarity_ch0 == 1)
    Reg55[2] = 1;
  else
    Reg55[2] = 0;
  if (polarity_ch1 == 1)
    Reg55[3] = 1;
  else
    Reg55[3] = 0;
  write(Reg55);
       
}
//----------------------------------------------------------------------------

function Freq_Range_change()			
{
  if (channel_selected == 0)
 	  frequency_range_ch0 = freq_range.value;
 	else
 	  frequency_range_ch1 = freq_range.value;
	On_Pwm_Freq_change();
}
//----------------------------------------------------------------------------
function PWM_selection_onclick(channel) //setting values for each PWM channel
{
  if (channel == 1)
  {
    frequency_ch0 = sld_pwm_freq.Value; // save value of ch0 from slider to mem
    sld_pwm_freq.Value = frequency_ch1; // show value of ch1 on slider
    duty_ch0 = sld_pwm_duty.Value;
    sld_pwm_duty.Value = duty_ch1;
    frequency_range_ch0 = freq_range.value;
    freq_range.value = frequency_range_ch1;
    channel_selected = 1;
    polarity = polarity_ch1;
    if (polarity == 1)
    {
      document.getElementById("pl0").checked = true;
      document.getElementById("pl1").checked = false;
    }
    else
    {
      document.getElementById("pl0").checked = false;
      document.getElementById("pl1").checked = true;
    }
  }
  else
  {
    frequency_ch1 = sld_pwm_freq.Value; // save value of ch1 from slider to mem
    sld_pwm_freq.Value = frequency_ch0; // show value of ch0 on slider
    duty_ch1 = sld_pwm_duty.Value;
    sld_pwm_duty.Value = duty_ch0;
    frequency_range_ch1 = freq_range.value;
    freq_range.value = frequency_range_ch0;  
    channel_selected = 0;
    polarity = polarity_ch0;
    if (polarity == 1)
    {
      document.getElementById("pl0").checked = true;
      document.getElementById("pl1").checked = false;
    }
    else
    {
      document.getElementById("pl0").checked = false;
      document.getElementById("pl1").checked = true;
    }
  }
  On_Pwm_Freq_change();
//  set_polarity(polarity);
}
//----------------------------------------------------------------------------
function HS1_PWM_source(source)
{
  if (source == 1)
  {
      Reg18[4] = 1;
      write(Reg18);
      On_Pwm_Freq_change() //HSCR  
  }
  else
  {
    Reg18[4] = 0;
    write(Reg18);
    On_Pwm_Freq_change() //HSCR      
  }
}
//----------------------------------------------------------------------------
function HS1_PWM_enable(enable)
{
   if (enable == 1)
   {
      Reg18[2] = 1;
      write(Reg18); //HSCR
   } 
   else
   {
      Reg18[2] = 0;
      write(Reg18); //HSCR   
   }
}
//----------------------------------------------------------------------------
function HS2_PWM_source(source)
{
  if (source == 1)
  {
      Reg18[5] = 1;
      write(Reg18); //HSCR
      On_Pwm_Freq_change()  
  }
  else
  {
    Reg18[5] = 0;
    write(Reg18); //HSCR
    On_Pwm_Freq_change()      
  }
}

//----------------------------------------------------------------------------
function HS2_PWM_enable(enable)
{
   if (enable == 1)
   {
      Reg18[3] = 1;
      write(Reg18); //HSCR
   } 
   else
   {
      Reg18[3] = 0;
      write(Reg18); //HSCR   
   }
}
//----------------------------------------------------------------------------
function LS1_PWM_source(source)
{
  if (source == 1)
  {
      Reg20[4] = 1;
      write(Reg20); //LSCR  
  }
  else
  {
    Reg20[4] = 0;
    write(Reg20); //LSCR      
  }
}

//----------------------------------------------------------------------------
function LS1_PWM_enable(enable)
{
   if (enable == 1)
   {
      Reg20[2] = 1;
      write(Reg20); //LSCR
   } 
   else
   {
      Reg20[2] = 0;
      write(Reg20); //LSCR   
   }
}
//----------------------------------------------------------------------------
function LS2_PWM_source(source)
{
  if (source == 1)
  {
      Reg20[5] = 1;
      write(Reg20); //LSCR  
  }
  else
  {
    Reg20[5] = 0;
    write(Reg20); //LSCR      
  }
}

//----------------------------------------------------------------------------
function LS2_PWM_enable(enable)
{
   if (enable == 1)
   {
      Reg20[3] = 1;
      write(Reg20); //LSCR
   } 
   else
   {
      Reg20[3] = 0;
      write(Reg20); //LSCR   
   }
}
//----------------------------------------------------------------------------
function PTB_PWM_source(source)
{
  if (source == 1)
  {
      Reg16[3] = 1;
      write(Reg16); //PTBC2  
  }
  else
  {
    Reg16[3] = 0;
    write(Reg16); //PTBC2      
  }
}
//----------------------------------------------------------------------------
function PTB_PWM_enable(enable)
{
   if (enable == 1)
   {
      Reg16[2] = 1;
      write(Reg16);
   } 
   else
   {
      Reg16[2] = 0;
      write(Reg16); //PTBC2   
   }  
}
//----------------------------------------------------------------------------
//--------------------  Sleep and Stop mode   --------------------------------
//----------------------------------------------------------------------------

function goto_stop_and_sleep(action)
{ 
if (wu_select == 1)  //Lx source
 
 {
   integer_to_array(0,Reg10); // clearing TCR register
   lx_change();
   if (cyclic_sense == 1) 
   if ((cyclic_source1==1)|| (cyclic_source2==1)) // at least HS must be selected for powering the Lx in cycl. sense
   {
      if (cyclic_source1==1)
        Reg9[6] = 1;
      else
        Reg9[6] = 0;
      if (cyclic_source2==1)
        Reg9[7] = 1;
      else
        Reg9[7] = 0;
   }
   else
   {
    alert("No power source selected. Select HS1 or HS2 or both.");
    return;
   }
   switch (lx_time) {
      case "1": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 0;}break;
      case "2": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 1;}break;
      case "3": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 1;Reg10[0] = 0;}break;
      case "4": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 1;Reg10[0] = 1;}break;
      case "5": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 0;Reg10[0] = 0;}break;
      case "6": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 0;Reg10[0] = 1;}break;
      case "7": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 1;Reg10[0] = 0;}break;
      case "8": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 1;Reg10[0] = 1;}break;
      case "9": {Reg10[3] = 1; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 0;}break;                                              
      case "10": {Reg10[3] = 1; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 1;}break;                                              
    }
   write(Reg10);
   write(Reg9); //WCR
    if (action == 1) //go to sleep
    {
      Reg13[0]=0;
      Reg13[1]=1;
    }
    else            // go to stop
    {
      Reg13[0]=1;
      Reg13[1]=0;
    }     
    write(Reg13); //MCR
    }
    if (wu_select == 2)  //Forced source
    {
    switch (multiplier){
      case "1": {Reg10[7] = 0; Reg10[6] = 0;Reg10[5] = 0;Reg10[4] = 1;}break;
      case "2": {Reg10[7] = 0; Reg10[6] = 0;Reg10[5] = 1;Reg10[4] = 0;}break;
      case "3": {Reg10[7] = 0; Reg10[6] = 0;Reg10[5] = 1;Reg10[4] = 1;}break;
      case "4": {Reg10[7] = 0; Reg10[6] = 1;Reg10[5] = 0;Reg10[4] = 0;}break;
      case "5": {Reg10[7] = 0; Reg10[6] = 1;Reg10[5] = 0;Reg10[4] = 1;}break;
      case "6": {Reg10[7] = 0; Reg10[6] = 1;Reg10[5] = 1;Reg10[4] = 0;}break;
      case "7": {Reg10[7] = 0; Reg10[6] = 1;Reg10[5] = 1;Reg10[4] = 1;}break;
      case "8": {Reg10[7] = 1; Reg10[6] = 0;Reg10[5] = 0;Reg10[4] = 0;}break;
      case "9": {Reg10[7] = 1; Reg10[6] = 0;Reg10[5] = 0;Reg10[4] = 1;}break;
      case "10": {Reg10[7] = 1; Reg10[6] = 0;Reg10[5] = 1;Reg10[4] = 0;}break;
      case "11": {Reg10[7] = 1; Reg10[6] = 0;Reg10[5] = 1;Reg10[4] = 1;}break;          
      };
    switch (time) {
      case "1": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 0;}break;
      case "2": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 1;}break;
      case "3": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 1;Reg10[0] = 0;}break;
      case "4": {Reg10[3] = 0; Reg10[2] = 0;Reg10[1] = 1;Reg10[0] = 1;}break;
      case "5": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 0;Reg10[0] = 0;}break;
      case "6": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 0;Reg10[0] = 1;}break;
      case "7": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 1;Reg10[0] = 0;}break;
      case "8": {Reg10[3] = 0; Reg10[2] = 1;Reg10[1] = 1;Reg10[0] = 1;}break;
      case "9": {Reg10[3] = 1; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 0;}break;                                              
      case "10": {Reg10[3] = 1; Reg10[2] = 0;Reg10[1] = 0;Reg10[0] = 1;}break;                                              
    }; 
    write(Reg10);// TCR
    integer_to_array(0,Reg9);
    read(Reg11);//WSR    
    if (action == 1) //go to sleep
    {
      Reg13[0]=0;
      Reg13[1]=1;
    }
    else            // go to stop
    {
      Reg13[0]=1;
      Reg13[1]=0;
    }     
    write(Reg13); //MCR
  }
    //stop the ADC visualization
    adc_stop_visualization = true;
    //close the port
    close_port = true;
    su = FreeMaster.StartStopComm(false);
    document.getElementById("message").value = "BDM port is closed due to STOP or SLEEP mode. After the wake-up open the port manually";
    document.getElementById("message").style.backgroundColor = "red";
    document.getElementById("message").style.color = "white";
    reset_update = 1;
//    document.getElementById("BDM_con").innerText = "NOT CONNECTED";
}
//----------------------------------------------------------------------------
function BDM_click()
{
    su = FreeMaster.StartStopComm(true);
    document.getElementById("BDM_con").innerText = "CONNECTED";

}

//----------------------------------------------------------------------------
function lx_change(source)
{
  read(Reg9);
  switch (source){
    case 0: {if (document.getElementById("lx_0").checked) Reg9[0] = 1; else Reg9[0] = 0; }; break;
    case 1: {if (document.getElementById("lx_1").checked) Reg9[1] = 1; else Reg9[1] = 0; }; break;
    case 2: {if (document.getElementById("lx_2").checked) Reg9[2] = 1; else Reg9[2] = 0; }; break;
    case 3: {if (document.getElementById("lx_3").checked) Reg9[3] = 1; else Reg9[3] = 0; }; break;
    case 4: {if (document.getElementById("lx_4").checked) Reg9[4] = 1; else Reg9[4] = 0; }; break;
    case 5: {if (document.getElementById("lx_5").checked) Reg9[5] = 1; else Reg9[5] = 0; }; break; 
    }
}

//----------------------------------------------------------------------------
function Lx_onclick()
{
    wu_select=1; 
    document.getElementById('Lx').style.visibility = 'visible';
    document.getElementById('forced').style.visibility = 'hidden'
}
//----------------------------------------------------------------------------
function Forced_onclick()
{
  wu_select=2; 
  document.getElementById("Lx").style.visibility = "hidden";
  document.getElementById("forced").style.visibility = "visible"
}
//----------------------------------------------------------------------------
function None_onclick()
{
  wu_select=0;
  document.getElementById('Lx').style.visibility = 'hidden';
  document.getElementById('forced').style.visibility = 'hidden'
}
//----------------------------------------------------------------------------
function waketime_change()
{
    time = waketime.value;
}
//----------------------------------------------------------------------------
function multiplier_change()
{
 	  multiplier = cycletime_multiplier.value;
}
//----------------------------------------------------------------------------
function cyclic_sense_click()
{
  if (document.getElementById("cyclic").checked) 
      cyclic_sense = 1;
  else
      cyclic_sense = 0;
}
//----------------------------------------------------------------------------
function lx_cycle_time_change()
{
  lx_time = lx_cycletime.value; 
}
//----------------------------------------------------------------------------
function hs_select(output)
{
  if (output == 1)
  {
    if (document.getElementById("hs1_select").checked)
        cyclic_source1 = 1;
    else 
        cyclic_source1 = 0 
  }
  else
  {
     if (document.getElementById("hs2_select").checked)
        cyclic_source2 = 1;
    else 
        cyclic_source2 = 0    
   }      
}
//----------------------------- LIN supporting functions ---------------------

//----------------------------------------------------------------------------
function LIN_En_click(checked)
{
  if (checked)
  {
    LIN_enabled = 1;
    Reg14[2] = 1;
    write(Reg14);
    IDchange();
    write(LIN_ID);  // enable the LIN driver on the MCU side
  }
  else
  {
    Reg14[2] = 1;
    write(Reg14);
    LIN_enabled = 0;
    write_fmaster_variable("MsgRcvd", 0);
  }
}
//----------------------------------------------------------------------------
function Show_LIN_message()
{
if (LIN_enabled == 1)
{
  var LINmessage = new Array;
  var LINmessage_string;
  read_variable("MsgRcvd");
  LINmessage_string = value.toString(16); 
  for (i=0;i<LINmessage_string.length;i++)
  {
    if (i%2 == 0)
    {
      if (i==0)
        LINmessage[0] = "0x"+LINmessage_string.substring(i,i+2).toUpperCase();
      else
        LINmessage[i/2] = "0x"+LINmessage_string.substring(i,i+2).toUpperCase();
    }
  }
  document.getElementById("LIN_message").value = LINmessage;
}  
else
  document.getElementById("LIN_message").value = " ";

}
//----------------------------------------------------------------------------

function IDchange()
{
/* not allowed to change the ID of the message due to LIN driver constraints - ID is constant during compilation
var ID = 0;
    ID = parseInt(document.getElementById("slaveID").value);
    integer_to_array(ID,LIN_ID);
    write(LIN_ID);
    */
}
//----------------------------------------------------------------------------

//******************************************************************************
//                   ****** FreeMaster functions ******
//******************************************************************************

function write_fmaster_variable(varname, value)
{
    var succ = FreeMaster.WriteVariable(varname, value);
    if (!succ) {Set_fmaster_err();}
    else
    {
     Clr_fmaster_err();
     if (reset_update == 1)
     {
       WSR_value_old = 0xff;
       RSR_value_old = 0xff
       reset_update = 0; 
     }
    } 
}
//----------------------------------------------------------------------------

function read_variable(varname)
{
    var succ = read_fmaster_variable(varname);
    if(succ)
   {
        value = FreeMaster.LastVariable_vValue;
        
   }
}
//----------------------------------------------------------------------------
function read_fmaster_variable(varname)
{ 
  var succ = FreeMaster.ReadVariable("!" + varname);
  if(succ)
  {
    Clr_fmaster_err();
  }
  else
  {		
    Set_fmaster_err();
	};
   
  return succ;
}
//----------------------------------------------------------------------------
function Set_fmaster_err()
{
 if (close_port==false)
 {
	document.getElementById("message").value = FreeMaster.LastRetMsg;
  document.getElementById("message").style.backgroundColor = "red";
  document.getElementById("message").style.color = "white";	
	adc_stop_visualization = true;
 }
}
//----------------------------------------------------------------------------
function Clr_fmaster_err()
{
	document.getElementById("message").value = " ";
	document.getElementById("message").style.backgroundColor = "white";
  document.getElementById("message").style.color = "black";
	adc_stop_visualization = false;
}