/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ResourceNameValidator
implements IValidator {
    public static char[] SPECIAL_CHARACTERS = new char[]{'<', '>', ':', '/', '\\', '|', '?', '*', '\"', '@', '#', '=', ';', '%'};
    private final int typeMask;
    private String title;

    public static ResourceNameValidator file() {
        ResourceNameValidator validator = new ResourceNameValidator(1);
        return validator;
    }

    public static ResourceNameValidator file(String title) {
        ResourceNameValidator validator = ResourceNameValidator.file();
        validator.setTitle(title);
        return validator;
    }

    public static ResourceNameValidator folder() {
        ResourceNameValidator validator = new ResourceNameValidator(2);
        return validator;
    }

    public static ResourceNameValidator folder(String title) {
        ResourceNameValidator validator = ResourceNameValidator.folder();
        validator.setTitle(title);
        return validator;
    }

    public static ResourceNameValidator project() {
        ResourceNameValidator validator = new ResourceNameValidator(4);
        return validator;
    }

    public static ResourceNameValidator project(String title) {
        ResourceNameValidator validator = ResourceNameValidator.project();
        validator.setTitle(title);
        return validator;
    }

    private ResourceNameValidator(int mask) {
        this.typeMask = mask;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IStatus validate(Object projName) {
        if (projName instanceof String) {
            String name = (String)projName;
            IStatus result = this.doValidate(name);
            if (!result.isOK() && this.title != null && !this.title.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.title);
                sb.append('\n');
                sb.append(result.getMessage());
                String message = sb.toString();
                int severity = result.getSeverity();
                String plugin = result.getPlugin();
                int code = result.getCode();
                Throwable exception = result.getException();
                return new Status(severity, plugin, code, message, exception);
            }
            return result;
        }
        return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
    }

    private IStatus doValidate(String segment) {
        IStatus result = ResourcesPlugin.getWorkspace().validateName(segment, this.typeMask);
        if (!result.isOK()) {
            return result;
        }
        char[] chars = SPECIAL_CHARACTERS;
        int i = 0;
        while (i < chars.length) {
            if (segment.indexOf(chars[i]) != -1) {
                String pattern = ResourcesMessages.ResourceNameValidator_e_name_invalid_character;
                String message = NLS.bind((String)pattern, (Object)String.valueOf(chars[i]), (Object)segment);
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
            }
            ++i;
        }
        return result;
    }
}

