/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKSmartFilter;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public abstract class AbstractSmartFilter
implements ISDKSmartFilter {
    @Override
    public abstract boolean accept(ISDK var1);

    public abstract IFilterOptions options();

    @Override
    public boolean acceptOptions(ISDK sdk) {
        IFilterOptions sdkFilterOptions;
        IFilterOptions filterOptions = this.options();
        if (this.skipOptionsCheck(filterOptions, sdkFilterOptions = sdk.getFilterOptions())) {
            return true;
        }
        if (!this.checkAvailability(filterOptions, sdk)) {
            return false;
        }
        if (!this.acceptLanguages(filterOptions, sdkFilterOptions)) {
            return false;
        }
        if (!this.acceptToolchains(filterOptions, sdkFilterOptions)) {
            return false;
        }
        return this.acceptProcessorAndCores(filterOptions, sdkFilterOptions);
    }

    protected boolean checkAvailability(IFilterOptions filterOptions, ISDK sdk) {
        return filterOptions.isCheckAvailability() ? sdk.isAvailable() : true;
    }

    protected boolean skipOptionsCheck(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        return sdkFilterOptions == null || filterOptions == null;
    }

    protected boolean acceptLanguages(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        IFilterOptions.ELang sdkLang = sdkFilterOptions.getLang();
        return sdkLang.equals((Object)IFilterOptions.ELang.ALL) || sdkLang.equals((Object)IFilterOptions.ELang.UNKNOWN) || sdkLang.equals((Object)filterOptions.getLang());
    }

    protected boolean acceptToolchains(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        boolean isAccepted = true;
        IToolChain[] sdkToolChains = sdkFilterOptions.getToolChains();
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        IToolChain[] iToolChainArray = filterOptions.getToolChains();
        int n = iToolChainArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain tc = iToolChainArray[n2];
            isAccepted = checker.checkToolchainsCompatibility(sdkToolChains, tc);
            if (isAccepted) break;
            ++n2;
        }
        return isAccepted;
    }

    protected boolean acceptProcessorAndCores(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        boolean isAccepted = true;
        String[] sdkCores = sdkFilterOptions.getCores();
        if (sdkCores.length == 0) {
            return true;
        }
        CoreInfo expCoreInfo = new CoreInfo();
        CoreInfo sdkCoreInfo = new CoreInfo();
        String[] stringArray = filterOptions.getCores();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String expCoreString = stringArray[n2];
            expCoreInfo.init(expCoreString);
            boolean found = false;
            String[] stringArray2 = sdkCores;
            int n3 = sdkCores.length;
            int n4 = 0;
            while (n4 < n3) {
                String sdkCoreString = stringArray2[n4];
                if (sdkCoreInfo.init(sdkCoreString).accept(expCoreInfo)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                isAccepted = false;
                break;
            }
            ++n2;
        }
        return isAccepted;
    }

    private class CoreInfo {
        private static final String PROC_CORE_SEPARATOR = ":";
        private static final String UNDEFINED = "$undefined$";
        private String procName;
        private String coreKind;

        private CoreInfo() {
        }

        private CoreInfo init(String coreString) {
            if (coreString != null && !coreString.isEmpty()) {
                String[] core = coreString.split(PROC_CORE_SEPARATOR);
                if (core.length == 1) {
                    this.procName = UNDEFINED;
                    this.coreKind = SDKUtils.unifyCoreKind(core[0]);
                } else {
                    this.procName = SDKUtils.unifyProcessor(core[0]);
                    this.coreKind = SDKUtils.unifyCoreKind(core[1]);
                }
            }
            return this;
        }

        private boolean accept(CoreInfo coreInfo) {
            return coreInfo.procName.equals(UNDEFINED) ? coreInfo.coreKind.equalsIgnoreCase(this.coreKind) : coreInfo.procName.equals(this.procName) && coreInfo.coreKind.equalsIgnoreCase(this.coreKind);
        }
    }
}

