/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class AddSDKDialog
extends Dialog {
    private static final String DIALOG_TITLE = "Select SDKs to register";
    static final int MODE_NAME = 1;
    static final int MODE_VERS = 2;
    static final int MODE_DESC = 3;
    static final int MODE_STAT = 4;
    static final int WIDTH_NAME = 150;
    static final int WIDTH_VERS = 50;
    static final int WIDTH_DESC = 150;
    static final int WIDTH_STAT = 100;
    private Shell shell;
    private CheckboxTableViewer viewer;
    private ISDK[] result = new ISDK[0];
    private final List<ISDK> sdks;

    public AddSDKDialog(Shell parent, List<ISDK> lst) {
        super(parent, 32768);
        this.sdks = lst;
    }

    public ISDK[] open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67680);
        this.shell.setText(DIALOG_TITLE);
        this.createContents((Composite)this.shell);
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = this.shell.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + (r1.height - r2.height) / 2;
        this.shell.setBounds(x, y, r2.width, r2.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        this.viewer = CheckboxTableViewer.newCheckList((Composite)c, (int)67588);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 500;
        gd.widthHint = 500;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableViewerColumn name = new TableViewerColumn((TableViewer)this.viewer, 0);
        name.getColumn().setText("SDK Name");
        name.getColumn().setWidth(150);
        name.setLabelProvider((CellLabelProvider)new SDKLabelProvider(1));
        TableViewerColumn vers = new TableViewerColumn((TableViewer)this.viewer, 0);
        vers.getColumn().setText("Vers");
        vers.getColumn().setWidth(50);
        vers.setLabelProvider((CellLabelProvider)new SDKLabelProvider(2));
        TableViewerColumn desc = new TableViewerColumn((TableViewer)this.viewer, 0);
        desc.getColumn().setText("Description");
        desc.getColumn().setWidth(150);
        desc.setLabelProvider((CellLabelProvider)new SDKLabelProvider(3));
        TableViewerColumn stat = new TableViewerColumn((TableViewer)this.viewer, 0);
        stat.getColumn().setText("Status");
        stat.getColumn().setWidth(100);
        stat.setLabelProvider((CellLabelProvider)new SDKLabelProvider(4));
        TableColumnLayout tableLayout = new TableColumnLayout();
        c.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        tableLayout.setColumnData((Widget)vers.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        tableLayout.setColumnData((Widget)desc.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        tableLayout.setColumnData((Widget)stat.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.viewer.setInput(this.sdks);
        boolean hasDups = false;
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISDK sdk;
            TableItem ti = tableItemArray[n2];
            boolean exist = SDKUtils.exists((sdk = (ISDK)ti.getData()).getId());
            this.viewer.setChecked((Object)sdk, !exist);
            hasDups |= exist;
            ++n2;
        }
        Composite b = new Composite(parent, 0);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        b.setLayout((Layout)new GridLayout(4, true));
        this.setupButton(b, IDialogConstants.OK_LABEL, true);
        this.setupButton(b, IDialogConstants.CANCEL_LABEL, false);
        new Label(b, 0).setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        if (hasDups) {
            Label l = new Label(b, 64);
            l.setText("Selection duplicate SDK(s) will rewrite existing one(s) !");
            l.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        }
        this.shell.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "com.freescale.s32ds.cross.sdk.support.SDK_SEL_context");
        return c;
    }

    protected Button setupButton(Composite c, String text, final boolean isOk) {
        Button b = new Button(c, 8);
        b.setText(text);
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (isOk) {
                    Object[] obs = AddSDKDialog.this.viewer.getCheckedElements();
                    AddSDKDialog.this.result = new ISDK[obs.length];
                    int i = 0;
                    while (i < obs.length) {
                        ((AddSDKDialog)AddSDKDialog.this).result[i] = (ISDK)obs[i];
                        ++i;
                    }
                }
                AddSDKDialog.this.shell.dispose();
            }
        });
        return b;
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray(new ISDK[0]);
            }
            return new Object[0];
        }
    }

    private class SDKLabelProvider
    extends ColumnLabelProvider {
        final int mode;

        public SDKLabelProvider(int mode) {
            this.mode = mode;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ISDK) {
                ISDK sdk = (ISDK)element;
                switch (this.mode) {
                    case 1: {
                        return sdk.getName();
                    }
                    case 2: {
                        return sdk.getVersion();
                    }
                    case 3: {
                        return sdk.getDescription();
                    }
                    case 4: {
                        return SDKUtils.exists(sdk.getId()) ? "Duplicate" : "Can create";
                    }
                }
                return "Bad mode: " + this.mode;
            }
            return "Bad object: " + element;
        }
    }
}

