/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.IFileFilter;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import java.io.File;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class CustomTreeViewer {
    protected static final int SEL_ALL = 1;
    protected static final int SEL_NON = 2;
    private static final int COPY_ALL = 3;
    private static final int COPY_NON = 4;
    public static final String[][] DEFAULT_HEADS = new String[][]{{"Copy"}, {"'x' stands for Link      '+' stands for Copy"}};
    private static final String TREE_KEY = "TREE_";
    private final boolean check;
    private final boolean selectSiblings;
    protected final TreeViewer viewer;
    protected final PathMatcher matcher;
    private IExtendedPath[] checkedStore;
    private final Set<IExtendedPath> toCopy = new HashSet<IExtendedPath>();
    protected final Set<IExtendedPath> toSelect = new HashSet<IExtendedPath>();
    protected final Set<IExtendedPath> toSelectFolder = new HashSet<IExtendedPath>();
    protected static final int DATA_COPY = 0;
    protected static final int DATA_SELECT = 1;
    protected static final int DATA_SELECT_FOLDER = 2;
    protected IExtendedPath.PathList[][] multiData = null;
    protected String[][] heads;
    private final IFileFilter selectedFileFilter = new IFileFilter(){

        @Override
        public boolean accept(File f) {
            return CustomTreeViewer.this.isSelected(f);
        }
    };
    private final String suffix;
    private static final Image[][] ICONS;

    static {
        Image[][] imageArrayArray = new Image[2][];
        Image[] imageArray = new Image[2];
        imageArray[1] = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
        imageArrayArray[0] = imageArray;
        Image[] imageArray2 = new Image[2];
        imageArray2[1] = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
        imageArrayArray[1] = imageArray2;
        ICONS = imageArrayArray;
    }

    public CustomTreeViewer(Composite parent, PathMatcher matcher, boolean check, boolean selectSiblings, String suffix, String[][] heads) {
        this.check = check;
        this.selectSiblings = selectSiblings;
        this.matcher = matcher;
        this.suffix = suffix;
        this.heads = heads == null || heads.length == 0 ? DEFAULT_HEADS : heads;
        this.viewer = new TreeViewer(parent, 68096);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)new SourcesTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                CustomTreeViewer.this.saveTreeItemState(event.getElement(), true);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                CustomTreeViewer.this.saveTreeItemState(event.getElement(), false);
            }
        });
        if (check) {
            this.viewer.getTree().setMenu(this.getMenu(this.viewer.getTree()));
        }
        this.addNameColumn();
        this.addExtraColumns(heads);
    }

    protected void addNameColumn() {
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(300);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IExtendedPath)element).lastSegment();
            }
        });
    }

    protected void addExtraColumns(String[][] heads) {
        if (this.check) {
            TreeViewerColumn selectColumn = new TreeViewerColumn(this.viewer, 0);
            selectColumn.getColumn().setText("Select");
            selectColumn.getColumn().setWidth(50);
            selectColumn.setLabelProvider((CellLabelProvider)new SelectColumnLabelProvider());
            selectColumn.setEditingSupport((EditingSupport)new SelectColumnEditingSupport((ColumnViewer)this.viewer));
            TreeViewerColumn copyColumn = new TreeViewerColumn(this.viewer, 0);
            copyColumn.getColumn().setText("Copy");
            copyColumn.getColumn().setWidth(50);
            copyColumn.setLabelProvider((CellLabelProvider)new CopyColumnLabelProvider());
            copyColumn.setEditingSupport((EditingSupport)new CopyColumnEditingSupport((ColumnViewer)this.viewer));
        } else {
            if (heads == null || heads[0] == null || heads[0].length == 0) {
                heads = DEFAULT_HEADS;
            }
            int i = 0;
            while (i < heads[0].length) {
                TreeViewerColumn c = new TreeViewerColumn(this.viewer, 0);
                c.getColumn().setText(heads[0][i]);
                if (heads[1].length > i) {
                    c.getColumn().setToolTipText(heads[1][i]);
                } else {
                    c.getColumn().setToolTipText(DEFAULT_HEADS[1][0]);
                }
                c.getColumn().setWidth(50);
                c.setLabelProvider((CellLabelProvider)new MultiColumnLabelProvider(i));
                ++i;
            }
        }
    }

    protected Menu getMenu(Tree t) {
        Menu m = new Menu((Control)t);
        this.addItem(m, t, "Select all", 1);
        this.addItem(m, t, "Select none", 2);
        new MenuItem(m, 2);
        this.addItem(m, t, "Copy all", 3);
        this.addItem(m, t, "Copy none", 4);
        return m;
    }

    protected void addItem(Menu m, final Tree t, String txt, final int id) {
        MenuItem mi = new MenuItem(m, 0);
        mi.setText(txt);
        mi.setID(id);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomTreeViewer.this.switchSelection(t, id);
                CustomTreeViewer.this.viewer.refresh();
            }
        });
    }

    protected void switchSelection(Tree t, int id) {
        switch (id) {
            case 1: {
                this.toSelect.clear();
                this.forEach(t.getItems(), id);
                break;
            }
            case 2: {
                this.toSelect.clear();
                break;
            }
            case 3: {
                this.toCopy.clear();
                this.forEach(t.getItems(), id);
                break;
            }
            case 4: {
                this.toCopy.clear();
            }
        }
    }

    protected void forEach(TreeItem[] tis, int id) {
        TreeItem[] treeItemArray = tis;
        int n = tis.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            IExtendedPath ep = (IExtendedPath)ti.getData();
            if (id == 1) {
                this.toSelect.add(ep);
            } else if (id == 3 && this.toSelect.contains(ep)) {
                this.toCopy.add(ep);
            }
            ti.setExpanded(true);
            this.forEach(ti.getItems(), id);
            ++n2;
        }
    }

    protected void saveTreeItemState(Object key, boolean state) {
        if (key == null) {
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        prefs.put(TREE_KEY + this.suffix + '_' + key.toString(), Boolean.toString(state));
        try {
            prefs.flush();
        }
        catch (Exception ex) {
            SDKSupportPlugin.error(ex);
        }
    }

    protected boolean getTreeItemState(Object key) {
        if (key == null) {
            return true;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        return prefs.getBoolean(TREE_KEY + this.suffix + '_' + key.toString(), true);
    }

    public void setInput(InputWrapper wrapper, Set<IExtendedPath> checked, boolean expand) {
        this.setInput(wrapper, checked.toArray(new IExtendedPath[checked.size()]), expand);
    }

    public void setInput(InputWrapper wrapper, IExtendedPath[] checked, boolean expand) {
        this.toSelectFolder.clear();
        this.toSelect.clear();
        this.toCopy.clear();
        this.checkedStore = checked;
        if (this.check) {
            IExtendedPath[] iExtendedPathArray = checked;
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                File f;
                IExtendedPath p = iExtendedPathArray[n2];
                if (p.isCopy()) {
                    this.toCopy.add(p);
                }
                if ((f = p.toFile()).isDirectory()) {
                    this.toSelect.add(p);
                } else if (f.isFile()) {
                    IExtendedPath parent = this.getParent(p);
                    this.toSelectFolder.add(parent);
                    if (this.selectSiblings) {
                        this.toSelect.addAll(Arrays.asList(parent.matchedChildren(this.matcher, true, null)));
                    } else {
                        this.toSelect.add(p);
                    }
                }
                ++n2;
            }
        }
        this.viewer.setInput((Object)wrapper);
        if (expand) {
            this.viewer.expandAll();
            this.restore(this.viewer.getTree().getItems());
        }
    }

    public void setInput(InputWrapper wrapper, IExtendedPath[][] checked, boolean expand) {
        this.checkedStore = checked[0];
        if (checked == null || checked.length == 0) {
            throw new IllegalArgumentException("Null or Empty files list !");
        }
        int offset = 1;
        int size = checked.length - 1;
        if (size == 0) {
            size = 1;
            offset = 0;
        }
        this.multiData = new IExtendedPath.PathList[size][3];
        int i = 0;
        while (i < this.multiData.length) {
            this.multiData[i][0] = new IExtendedPath.PathList();
            this.multiData[i][1] = new IExtendedPath.PathList();
            this.multiData[i][2] = new IExtendedPath.PathList();
            IExtendedPath[] iExtendedPathArray = checked[i + offset];
            int n = iExtendedPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f;
                IExtendedPath p = iExtendedPathArray[n2];
                if (p.isCopy()) {
                    this.multiData[i][0].add(p);
                }
                if ((f = p.toFile()).isDirectory()) {
                    this.multiData[i][1].add(p);
                } else if (f.isFile()) {
                    IExtendedPath parent = this.getParent(p);
                    this.multiData[i][2].add(parent);
                    if (this.selectSiblings) {
                        this.multiData[i][1].addAll(Arrays.asList(parent.matchedChildren(this.matcher, true, null)));
                    } else {
                        this.multiData[i][1].add(p);
                    }
                }
                ++n2;
            }
            ++i;
        }
        this.viewer.setInput((Object)wrapper);
        if (expand) {
            this.viewer.expandAll();
            this.restore(this.viewer.getTree().getItems());
        }
    }

    private void restore(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it = treeItemArray[n2];
            it.setExpanded(this.getTreeItemState(it.getData()));
            this.restore(it.getItems());
            ++n2;
        }
    }

    private IExtendedPath getParent(IExtendedPath p) {
        return ExtendedPath.fromOSString(p.removeLastSegments(1).toOSString(), true);
    }

    public IExtendedPath[] getChecked() {
        IExtendedPath[] result;
        if (!this.check) {
            throw new IllegalAccessError("Bad access !");
        }
        IExtendedPath[] iExtendedPathArray = result = this.toSelect.toArray(new IExtendedPath[this.toSelect.size()]);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath p = iExtendedPathArray[n2];
            p.setCopy(this.toCopy.contains(p));
            ++n2;
        }
        return result;
    }

    public void clearSelected() {
        this.toSelect.clear();
        this.toSelectFolder.clear();
    }

    private boolean isSelected(File file) {
        if (this.check) {
            return true;
        }
        String abs = file.getAbsolutePath();
        IExtendedPath[] iExtendedPathArray = this.checkedStore;
        int n = this.checkedStore.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath p = iExtendedPathArray[n2];
            if (p.toOSString().equals(abs)) {
                return true;
            }
            if (p.isPrefixOf(Path.fromOSString((String)abs))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static InputWrapper wrap(final IExtendedPath input) {
        return new InputWrapper(){

            @Override
            public IExtendedPath get() {
                return input;
            }
        };
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    class CopyColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public CopyColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (!CustomTreeViewer.this.check) {
                return false;
            }
            IExtendedPath path = (IExtendedPath)element;
            return path.toFile().isFile() && CustomTreeViewer.this.toSelect.contains(path);
        }

        protected Boolean getValue(Object element) {
            return CustomTreeViewer.this.toCopy.contains(element);
        }

        protected void setValue(Object element, Object value) {
            boolean copy = (Boolean)value;
            if (copy) {
                CustomTreeViewer.this.toCopy.add((IExtendedPath)element);
            } else {
                CustomTreeViewer.this.toCopy.remove(element);
            }
            this.getViewer().refresh();
        }
    }

    class CopyColumnLabelProvider
    extends CellLabelProvider {
        CopyColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            IExtendedPath path = (IExtendedPath)cell.getElement();
            boolean copy = CustomTreeViewer.this.toCopy.contains(path);
            boolean canEdit = path.toFile().isFile() && CustomTreeViewer.this.toSelect.contains(path);
            cell.setImage(ICONS[copy ? 1 : 0][canEdit ? 1 : 0]);
        }
    }

    static interface InputWrapper {
        public IExtendedPath get();
    }

    class MultiColumnLabelProvider
    extends CellLabelProvider {
        private final int index;

        public MultiColumnLabelProvider(int i) {
            this.index = i;
        }

        public void update(ViewerCell cell) {
            IExtendedPath path = (IExtendedPath)cell.getElement();
            boolean copy = CustomTreeViewer.this.multiData[this.index][0].contains(path);
            boolean canEdit = path.toFile().isFile() && CustomTreeViewer.this.multiData[this.index][1].contains(path);
            cell.setImage(ICONS[copy ? 1 : 0][canEdit ? 1 : 0]);
        }
    }

    class SelectColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public SelectColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            boolean hasMatchedChildren;
            IExtendedPath path = (IExtendedPath)element;
            boolean isDirectory = path.toFile().isDirectory();
            boolean bl = hasMatchedChildren = path.matchedChildren(CustomTreeViewer.this.matcher, false, null).length > 0;
            return !CustomTreeViewer.this.selectSiblings && !isDirectory || isDirectory && hasMatchedChildren;
        }

        protected Boolean getValue(Object element) {
            IExtendedPath path = (IExtendedPath)element;
            boolean isDirectory = path.toFile().isDirectory();
            return isDirectory ? CustomTreeViewer.this.toSelectFolder.contains(element) : CustomTreeViewer.this.toSelect.contains(element);
        }

        protected void setValue(Object element, Object value) {
            IExtendedPath p = (IExtendedPath)element;
            boolean select = (Boolean)value;
            IExtendedPath.PathList toProcess = new IExtendedPath.PathList();
            if (p.toFile().isDirectory()) {
                toProcess.addAll(Arrays.asList(p.matchedChildren(CustomTreeViewer.this.matcher, false, null)));
                if (select) {
                    CustomTreeViewer.this.toSelectFolder.add(p);
                } else {
                    CustomTreeViewer.this.toSelectFolder.remove(p);
                }
            } else {
                toProcess.add(p);
            }
            if (select) {
                CustomTreeViewer.this.toSelect.addAll(toProcess);
            } else {
                CustomTreeViewer.this.toSelect.removeAll(toProcess);
            }
            this.getViewer().refresh();
        }
    }

    class SelectColumnLabelProvider
    extends CellLabelProvider {
        SelectColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            IExtendedPath path = (IExtendedPath)cell.getElement();
            boolean isDirectory = path.toFile().isDirectory();
            boolean hasMatchedChildren = path.matchedChildren(CustomTreeViewer.this.matcher, false, null).length > 0;
            boolean select = isDirectory ? CustomTreeViewer.this.toSelectFolder.contains(path) : CustomTreeViewer.this.toSelect.contains(path);
            boolean canEdit = !path.isEmpty() && (isDirectory && hasMatchedChildren || !isDirectory);
            cell.setImage(ICONS[select ? 1 : 0][canEdit ? 1 : 0]);
        }
    }

    final class SourcesTreeContentProvider
    implements ITreeContentProvider {
        SourcesTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            IPath path = (IPath)element;
            java.nio.file.Path p = Paths.get(path.toOSString(), new String[0]);
            java.nio.file.Path parent = p.getParent();
            return parent == null ? null : ExtendedPath.fromOSString((String)parent.toFile().getAbsolutePath());
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof InputWrapper) {
                return new IExtendedPath[]{((InputWrapper)parentElement).get()};
            }
            return ((IExtendedPath)parentElement).matchedChildren(CustomTreeViewer.this.matcher, true, CustomTreeViewer.this.selectedFileFilter);
        }
    }
}

