/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ui.internal.IconProvider;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;

public abstract class SDKPageLabelProvider
extends CellLabelProvider {
    public static CellLabelProvider getNameLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getName());
                }
            }
        };
    }

    public static CellLabelProvider getVersionLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getVersion());
                }
            }
        };
    }

    public static CellLabelProvider getDescriptionLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getDescription());
                }
            }
        };
    }

    public static CellLabelProvider getStatusLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getStatusText());
                }
            }
        };
    }

    public static CellLabelProvider getCfgLabelProvider(int num, final Map<String, Boolean[]> data, final int len, IConfiguration cfg) {
        return new CellLabelProvider(cfg, num){
            final IconProvider IP;
            {
                this.IP = new IconProvider(iConfiguration, n);
            }

            public void update(ViewerCell cell) {
                ISDK sdk = (ISDK)cell.getElement();
                Boolean[] d = (Boolean[])data.get(sdk.getId());
                if (d == null) {
                    d = new Boolean[len];
                    int i = 0;
                    while (i < len) {
                        d[i] = Boolean.FALSE;
                        ++i;
                    }
                    data.put(sdk.getId(), d);
                }
                cell.setImage(this.IP.getImageFor(cell, d));
            }

            public String getToolTipText(Object element) {
                if (element instanceof ISDK) {
                    ISDK sdk = (ISDK)element;
                    Boolean[] d = (Boolean[])data.get(sdk.getId());
                    return this.IP.getToolTipFor(sdk, d);
                }
                return element.toString();
            }

            public boolean useNativeToolTip(Object element) {
                return true;
            }
        };
    }

    public static EditingSupport getCfgEditingSupport(ColumnViewer viewer, int num, Map<String, Boolean[]> data) {
        return new CfgEditingSupport(viewer, num, data);
    }

    private static class CfgEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor = new CheckboxCellEditor();
        final int number;
        final Map<String, Boolean[]> data;

        public CfgEditingSupport(ColumnViewer viewer, int num, Map<String, Boolean[]> map) {
            super(viewer);
            this.number = num;
            this.data = map;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return this.getValue(element) != null;
        }

        protected Boolean getValue(Object element) {
            Boolean[] d = this.data.get(((ISDK)element).getId());
            return d == null || d[this.number] == null ? null : d[this.number];
        }

        protected void setValue(Object element, Object value) {
            if (this.getValue(element) != null) {
                this.data.get((Object)((ISDK)element).getId())[this.number] = (Boolean)value;
                this.getViewer().refresh();
            }
        }
    }
}

