/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.SDKDefinedSymbolValidator;
import java.util.Arrays;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class StringListControl {
    private static final String HELP_CONTEXT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_defined_symbol_edit_context";
    private final String[] heads;
    private ToolBar toolBar;
    private ToolItem addItem;
    private ToolItem deleteItem;
    private ToolItem editItem;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    private List list;
    private String compTitle;
    private SelectionListener selectionListener;
    private final Image IMG_ADD = CDTSharedImages.getImage((String)"icons/elcl16/list-add.gif");
    private final Image IMG_DEL = CDTSharedImages.getImage((String)"icons/elcl16/list-delete.gif");
    private final Image IMG_EDIT = CDTSharedImages.getImage((String)"icons/elcl16/list-edit.gif");
    private final Image IMG_MOVEUP = CDTSharedImages.getImage((String)"icons/elcl16/list-moveup.gif");
    private final Image IMG_MOVEDOWN = CDTSharedImages.getImage((String)"icons/elcl16/list-movedown.gif");
    private final IInputValidator inputValidator = new StringInputValidator();

    public StringListControl(Composite parent, String compTitle, String[][] heads) {
        this.heads = heads == null ? null : heads[0];
        Composite stringPanel = new Composite(parent, 0);
        GridLayout form1 = new GridLayout();
        form1.numColumns = 1;
        form1.horizontalSpacing = 0;
        form1.verticalSpacing = 0;
        form1.marginHeight = 0;
        form1.marginWidth = 0;
        stringPanel.setLayout((Layout)form1);
        stringPanel.setLayoutData((Object)new GridData(1808));
        Composite titlePanel = new Composite(stringPanel, 2048);
        GridLayout titleform = new GridLayout(2, false);
        titleform.horizontalSpacing = 0;
        titleform.verticalSpacing = 0;
        titleform.marginHeight = 0;
        titleform.marginWidth = 0;
        titlePanel.setLayout((Layout)titleform);
        GridData tgdata = new GridData(768);
        tgdata.heightHint = 25;
        titlePanel.setLayoutData((Object)tgdata);
        this.title = new Label(titlePanel, 1);
        this.compTitle = "  " + compTitle;
        this.title.setText(this.compTitle);
        this.title.setLayoutData((Object)new GridData(768));
        Composite buttonPanel = new Composite(titlePanel, 0);
        GridLayout form2 = new GridLayout();
        form2.numColumns = 5;
        form2.horizontalSpacing = 0;
        form2.verticalSpacing = 0;
        form2.marginWidth = 0;
        form2.marginHeight = 0;
        buttonPanel.setLayout((Layout)form2);
        if (heads == null) {
            this.createToolBar(buttonPanel);
        }
        this.list = new List(stringPanel, 2818);
        GridData grid4 = new GridData(1808);
        Point preferredSize = titlePanel.computeSize(-1, -1);
        grid4.widthHint = preferredSize.x;
        grid4.heightHint = preferredSize.y * 3;
        grid4.horizontalSpan = 2;
        this.list.setLayoutData((Object)grid4);
        if (heads == null) {
            this.createListeners();
        }
        this.selectionChanged();
    }

    private void createToolBar(Composite buttonPanel) {
        this.toolBar = new ToolBar(buttonPanel, 8519936);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(this.IMG_ADD);
        this.addItem.setToolTipText(NLS.bind((String)Messages.StringListControl_button_add_tooltip, null));
        this.addItem.addSelectionListener(this.getSelectionListener());
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(this.IMG_DEL);
        this.deleteItem.setToolTipText(NLS.bind((String)Messages.StringListControl_button_delete_tooltip, null));
        this.deleteItem.addSelectionListener(this.getSelectionListener());
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(this.IMG_EDIT);
        this.editItem.setToolTipText(NLS.bind((String)Messages.StringListControl_button_edit_tooltip, null));
        this.editItem.addSelectionListener(this.getSelectionListener());
        this.moveUpItem = new ToolItem(this.toolBar, 8);
        this.moveUpItem.setImage(this.IMG_MOVEUP);
        this.moveUpItem.setToolTipText(NLS.bind((String)Messages.StringListControl_button_moveup_tooltip, null));
        this.moveUpItem.addSelectionListener(this.getSelectionListener());
        this.moveDownItem = new ToolItem(this.toolBar, 8);
        this.moveDownItem.setImage(this.IMG_MOVEDOWN);
        this.moveDownItem.setToolTipText(NLS.bind((String)Messages.StringListControl_button_movedown_tooltip, null));
        this.moveDownItem.addSelectionListener(this.getSelectionListener());
        GridData grid3 = new GridData(896);
        buttonPanel.setLayoutData((Object)grid3);
    }

    private void createListeners() {
        this.list.addSelectionListener(this.getSelectionListener());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                StringListControl.this.editSelection();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 8: 
                    case 127: {
                        if (e.stateMask != 0) break;
                        StringListControl.this.removePressed();
                    }
                }
            }
        });
    }

    public void setList(String[][] listVal) {
        if (this.list == null) {
            SDKSupportPlugin.log("List is null !");
            return;
        }
        this.list.removeAll();
        if (this.heads != null && this.heads.length > 0) {
            int i = 0;
            while (i < listVal.length) {
                this.list.add(NLS.bind((String)Messages.StringListControl_list_header_not_empty_list, (Object)this.heads[i]));
                if (listVal[i] != null && listVal[i].length > 0) {
                    String[] stringArray = listVal[i];
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        this.list.add(s);
                        ++n2;
                    }
                } else {
                    this.list.add(NLS.bind((String)Messages.StringListControl_list_header_empty_list, null));
                }
                ++i;
            }
        } else {
            String[] stringArray = listVal[0];
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                this.list.add(s);
                ++n3;
            }
        }
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    private void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == StringListControl.this.addItem) {
                    StringListControl.this.addPressed();
                } else if (widget == StringListControl.this.deleteItem) {
                    StringListControl.this.removePressed();
                } else if (widget == StringListControl.this.moveUpItem) {
                    StringListControl.this.upPressed();
                } else if (widget == StringListControl.this.moveDownItem) {
                    StringListControl.this.downPressed();
                } else if (widget == StringListControl.this.list) {
                    StringListControl.this.selectionChanged();
                } else if (widget == StringListControl.this.editItem) {
                    StringListControl.this.editSelection();
                }
            }
        };
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void addPressed() {
        String input = this.getNewInputObject();
        if (input != null && input.length() > 0) {
            int index = this.list.getSelectionIndex();
            this.list.add(input, index + 1);
            this.list.setSelection(index + 1);
        }
        this.selectionChanged();
    }

    /*
     * Unable to fully structure code
     */
    private void removePressed() {
        if (this.list.getSelectionCount() != 0 && this.list.getSelectionIndex() != -1) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.list.remove(i);
lbl4:
            // 2 sources

            ** while ((i = this.list.getSelectionIndex()) != -1)
        }
lbl5:
        // 1 sources

        this.selectionChanged();
    }

    private void upPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String preList = this.list.getItem(index - 1);
        this.list.setItem(index - 1, curSelList);
        this.list.setItem(index, preList);
        this.list.setSelection(index - 1);
        this.selectionChanged();
    }

    private void downPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String nextList = this.list.getItem(index + 1);
        this.list.setItem(index + 1, curSelList);
        this.list.setItem(index, nextList);
        this.list.setSelection(index + 1);
        this.selectionChanged();
    }

    private void editSelection() {
        String selItem;
        int index = this.list.getSelectionIndex();
        if (index != -1 && (selItem = this.list.getItem(index)) != null) {
            String newItem;
            StringInputValidator siv = (StringInputValidator)this.inputValidator;
            siv.setExistingSymbols();
            siv.setIsInitialInput(true);
            InputDialog dialog = new InputDialog(this.list.getShell(), NLS.bind((String)Messages.StringListControl_input_dialog_edit_title, null), NLS.bind((String)Messages.StringListControl_input_dialog_edit_symbol_label, null), selItem, this.inputValidator){

                protected Control createDialogArea(Composite parent) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((Composite)super.createDialogArea(parent)), StringListControl.HELP_CONTEXT_ID);
                    return parent;
                }
            };
            if (dialog.open() == 0 && !(newItem = dialog.getValue().trim()).equals(selItem)) {
                this.list.setItem(index, newItem);
                this.selectionChanged();
            }
        }
    }

    public void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        int selectionCount = this.list.getSelectionCount();
        if (this.heads == null) {
            this.deleteItem.setEnabled(size > 0);
            this.moveUpItem.setEnabled(size > 1 && index > 0 && selectionCount == 1);
            this.moveDownItem.setEnabled(size > 1 && index >= 0 && index < size - 1 && selectionCount == 1);
            this.editItem.setEnabled(selectionCount == 1);
        }
    }

    private String getNewInputObject() {
        String input = null;
        ((StringInputValidator)this.inputValidator).setExistingSymbols();
        InputDialog dialog = new InputDialog(this.list.getShell(), NLS.bind((String)Messages.StringListControl_input_dialog_new_title, null), NLS.bind((String)Messages.StringListControl_input_dialog_new_symbol_label, null), "", this.inputValidator){

            protected Control createDialogArea(Composite parent) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((Composite)super.createDialogArea(parent)), StringListControl.HELP_CONTEXT_ID);
                return parent;
            }
        };
        if (dialog.open() == 0) {
            input = dialog.getValue().trim();
        }
        return input;
    }

    public Label getLabelControl() {
        return this.title;
    }

    public void setEnabled(boolean enabled) {
        this.title.setEnabled(enabled);
        this.toolBar.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    class StringInputValidator
    implements IInputValidator {
        private SDKDefinedSymbolValidator validator = new SDKDefinedSymbolValidator();

        StringInputValidator() {
        }

        public String isValid(String newText) {
            IStatus validationStatus = this.validator.validate(newText);
            return !validationStatus.isOK() ? validationStatus.getMessage() : null;
        }

        void setExistingSymbols() {
            this.validator.setExistingSymbols(Arrays.asList(StringListControl.this.list.getItems()));
        }

        void setIsInitialInput(boolean isInitialInput) {
            this.validator.setIsInitialInput(isInitialInput);
        }
    }
}

