/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.ADragSourceProcessor;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IWorkbenchPartSite;

public class SDKExplorerDragSourceListener
extends ADragSourceListener {
    private static final String DERIVATIVE = "derivative.h";
    private static final String INCLUDE = "#include \"";
    private static final String SDK = "\t// SDK";
    private static final String LF = "\r\n";
    private ICElement element;
    private String saved_data = null;

    public SDKExplorerDragSourceListener(AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite workbenchPartSite) {
        super(abstractTreeViewer, workbenchPartSite);
    }

    protected boolean isProcessDataDragAndDrop(Object data) {
        return data instanceof ISourceManipulation;
    }

    protected void performDragSetData(DragSourceEvent event, Object data) {
        try {
            ICElement ce = (ICElement)data;
            if (ce instanceof ITranslationUnit) {
                this.saved_data = ((ITranslationUnit)ce).getLocation().lastSegment();
                event.data = "\u0000\u0000";
            } else {
                String invocationString = ADragSourceProcessor.getDragSourceProcessor(ce).getFormattedInvocation();
                Object object = event.data = invocationString != null ? invocationString : " ";
                if (79 == ce.getElementType()) {
                    this.saved_data = ((IMacro)ce).getParent().getPath().lastSegment();
                }
            }
            this.updateIndex(ce.getParent());
            this.element = ce;
        }
        catch (CoreException ce) {
            SDKSupportPlugin.error(ce);
        }
    }

    protected void performDragFinished(DragSourceEvent event) {
        block18: {
            if (this.saved_data != null) {
                String include = INCLUDE + this.saved_data + '\"';
                IWorkingCopy tuDst = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
                try {
                    try {
                        String s = tuDst.getBuffer().getContents();
                        if (!s.contains(include) && !this.getName(tuDst.getElementName()).equals(this.saved_data)) {
                            int n = s.indexOf(DERIVATIVE);
                            if (n < 0) {
                                n = s.indexOf(INCLUDE);
                            }
                            if (n <= 0) {
                                tuDst.getBuffer().setContents(String.valueOf(include) + SDK + LF + s);
                            } else {
                                int i = n;
                                while (i < s.length()) {
                                    int type = Character.getType(s.codePointAt(i));
                                    if (type == 13 || type == 15) {
                                        StringBuilder sb = new StringBuilder();
                                        sb.append(s.substring(0, i)).append(LF).append(include).append(SDK).append(s.substring(i));
                                        tuDst.getBuffer().setContents(sb.toString());
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            this.updateIndex((ICElement)tuDst);
                        }
                    }
                    catch (CoreException e) {
                        SDKSupportPlugin.error(e);
                        this.saved_data = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.saved_data = null;
                    throw throwable;
                }
                this.saved_data = null;
            }
        }
        if (this.element instanceof IDeclaration) {
            try {
                ITranslationUnit tu = ((IDeclaration)this.element).getTranslationUnit();
                IWorkingCopy tuToEdit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
                IInclude[] includes = tuToEdit.getIncludes();
                IInclude first = includes.length > 0 ? includes[0] : null;
                String tuPath = tu.getLocation().lastSegment();
                boolean contains = false;
                IInclude[] iIncludeArray = includes;
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    IInclude inc = iIncludeArray[n2];
                    String incPath = inc.getIncludeName();
                    if (incPath.equals(tuPath)) {
                        contains = true;
                        break;
                    }
                    ++n2;
                }
                if (!contains) {
                    tuToEdit.createInclude(tu.getLocation().lastSegment(), false, (ICElement)first, null);
                    this.updateIndex((ICElement)tuToEdit);
                }
            }
            catch (CoreException e) {
                SDKSupportPlugin.error(e);
            }
        }
    }

    protected void updateIndex(ICElement element) throws CoreException {
        IIndexManager indexManager = CCorePlugin.getIndexManager();
        indexManager.update(new ICElement[]{element}, 41);
    }

    private String getName(String full) {
        int n = (full = full.replace('\\', '/').trim()).lastIndexOf(47);
        return n < 0 ? full : full.substring(n + 1);
    }
}

