/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.ui.syntaxcoloring;

import cbg.editor.ColoringEditor;
import com.freescale.s32ds.cdt.ui.syntaxcoloring.Messages;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OpenReferenceAction
extends TextEditorAction {
    private static final String INCLUDE_KEYWORD = ".include";
    private static final String POUND_INCLUDE_KEYWORD = "#include";
    private boolean dynamicEnablement = false;

    public OpenReferenceAction(ColoringEditor editor) {
        super(ResourceBundle.getBundle("com.freescale.s32ds.cdt.ui.syntaxcoloring.messages"), "OpenReferenceAction_", editor != null ? editor.getITextEditor() : null);
    }

    public OpenReferenceAction() {
        this(null);
    }

    public void setAlwaysEnabled(boolean value) {
        this.dynamicEnablement = !value;
    }

    public void run() {
        String text = this.getStringLiteral();
        if (text != null) {
            IEditorInput input = this.getTextEditor().getEditorInput();
            IPath target = null;
            if (Path.fromOSString((String)text).isAbsolute()) {
                target = Path.fromOSString((String)text);
            }
            if (target == null) {
                IPath path = null;
                ILocationProvider locationProvider = (ILocationProvider)input.getAdapter(ILocationProvider.class);
                if (locationProvider != null) {
                    path = locationProvider.getPath((Object)input);
                    IResource result = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    if (result != null) {
                        path = result.getLocation();
                    }
                } else {
                    IResource res = (IResource)input.getAdapter(IResource.class);
                    if (res != null) {
                        path = res.getLocation();
                    }
                }
                if (path != null) {
                    IPath relativePath = path.removeLastSegments(1);
                    if ((relativePath = relativePath.append(text)).toFile().exists()) {
                        target = relativePath;
                    }
                }
            }
            if (target == null) {
                String fileName = Path.fromOSString((String)text).lastSegment();
                IResource result = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName, false);
                if (result != null) {
                    target = result.getLocation();
                }
            }
            if (target != null) {
                try {
                    this.open(target);
                }
                catch (CoreException coreException) {
                    this.showStatusLineMessage(Messages.bind((String)Messages.OpenReferenceAction_0, (Object)text));
                }
            } else {
                this.showStatusLineMessage(Messages.bind((String)Messages.OpenReferenceAction_0, (Object)text));
            }
        }
    }

    private String getCurrentLine() {
        if (this.getTextEditor() != null) {
            IDocument document = OpenReferenceAction.getDocument(this.getTextEditor());
            ITextSelection textSelection = OpenReferenceAction.getSelection(this.getTextEditor());
            try {
                int line = document.getLineOfOffset(textSelection.getOffset());
                IRegion region = document.getLineInformation(line);
                String content = document.get(region.getOffset(), region.getLength());
                return content;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    private String getStringLiteral() {
        String line = this.getCurrentLine();
        if (line != null && (line.startsWith(INCLUDE_KEYWORD) || line.startsWith(POUND_INCLUDE_KEYWORD))) {
            String literal = this.searchLiteral(line);
            return literal;
        }
        return null;
    }

    private String searchLiteral(String content) {
        char[] delimiters;
        char[] cArray = delimiters = new char[]{'\"', '\''};
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            int index = content.indexOf(delimiter);
            if (index != -1) {
                String literal = content.substring(index + 1);
                if ((index = literal.indexOf(delimiter)) != -1) {
                    literal = literal.substring(0, index);
                }
                return literal;
            }
            ++n2;
        }
        return null;
    }

    private static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document;
    }

    private static ITextSelection getSelection(ITextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    protected void open(IPath path) throws CoreException {
        this.showStatusLineMessage(null);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)fileStore);
    }

    protected void showStatusLineMessage(String message) {
        IEditorActionBarContributor contributor = this.getTextEditor().getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager m = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            m.setErrorMessage(message);
        }
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(!this.dynamicEnablement || this.getStringLiteral() != null);
    }
}

