/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.ui;

import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectFacade;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.ui.ExampleSelectionPage;
import com.nxp.s32ds.ext.ide.examples.ui.Messages;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import com.nxp.s32ds.ext.ide.resources.IdeValidators;
import com.nxp.s32ds.ext.ide.ui.operations.ImportExampleOperation;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class ExampleImportWizard
extends Wizard
implements IShellProvider,
INewWizard {
    private final CompositeValidator compositeNameValidator = new CompositeValidator(IdeValidators.getNameValidators());
    private final CompositeValidator compositePathValidatior = new CompositeValidator(IdeValidators.getPathValidators());
    ExampleProjectFacade exampleFacade = new ExampleProjectFacade();
    ExampleSelectionPage selectionPage = new ExampleSelectionPage(this.exampleFacade){

        @Override
        protected IStatus validate() {
            IStatus status = null;
            if (!ExampleImportWizard.this.selectionPage.isFolder()) {
                status = ExampleImportWizard.this.compositeNameValidator.validate((Object)this.getName());
                if (status.isOK()) {
                    String strPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + File.separator + this.getName();
                    status = ExampleImportWizard.this.compositePathValidatior.validate((Object)strPath);
                }
            } else {
                status = new Status(4, "com.nxp.s32ds.ext.ide.resources", Messages.Folder_selection_message);
            }
            return status;
        }
    };

    public ExampleImportWizard() throws CoreException, IOException {
        this.setHelpAvailable(false);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean canFinish() {
        return this.selectionPage.validate().isOK();
    }

    public boolean performFinish() {
        try {
            String name = this.selectionPage.getName();
            ProjectSet projects = this.selectionPage.getProjects();
            this.getContainer().run(true, true, (IRunnableWithProgress)new ImportExampleOperation(name, projects));
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Status status = new Status(4, ExIdtUiExamplesActivator.getPluginId(), 1, t.getLocalizedMessage(), t);
            ExIdtUiExamplesActivator.log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, (String)message, (IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.Wizard_title);
    }
}

