/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.ui;

import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectFacade;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.ValidationExampleUtil;
import com.nxp.s32ds.ext.ide.examples.ui.ExampleSelectionComposite;
import com.nxp.s32ds.ext.ide.examples.ui.Messages;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import java.io.File;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class ExampleSelectionPage
extends WizardPage {
    private static final String HELP_CONTEXT_ID = ".import_example_project_context";
    private final ExampleProjectFacade projectFacade;
    private ExampleSelectionComposite composite;
    private ProjectSet projectSet = null;
    private String name = "";
    private Object pathToValidate;
    private boolean isFolder = false;

    public boolean isFolder() {
        return this.isFolder;
    }

    protected ExampleSelectionPage(ExampleProjectFacade projectFacade) {
        super("Select project");
        this.projectFacade = projectFacade;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.Wizard_page_title);
        this.composite = new ExampleSelectionComposite(parent, this.projectFacade){

            @Override
            protected void projectSelected(ProjectSet project) {
                ExampleSelectionPage.this.projectSet = project;
                this.updateStatus();
            }

            private boolean updateStatus() {
                ExampleSelectionPage.this.isFolder = ExampleSelectionPage.this.composite.isFolderSelected();
                IStatus status = ExampleSelectionPage.this.validate();
                ExampleSelectionPage.this.setPageComplete(status.isOK());
                ExampleSelectionPage.this.setErrorMessage(status.isOK() || status.getSeverity() == 8 ? null : status.getMessage());
                return status.isOK();
            }

            @Override
            protected void nameChanged(String name) {
                ExampleSelectionPage.this.name = name;
                if (ExampleSelectionPage.this.projectSet != null) {
                    if (ExampleSelectionPage.this.projectSet.getProjects().count() == 1L) {
                        ExampleSelectionPage.this.pathToValidate = name;
                        this.updateStatus();
                    } else {
                        for (IProjectDescription description : ExampleSelectionPage.this.projectSet.getProjects().collect(Collectors.toList())) {
                            ExampleSelectionPage.this.pathToValidate = (Path)ValidationExampleUtil.calculateExamplePath((IPath)new Path(String.valueOf(ExampleSelectionPage.this.projectSet.getName()) + File.separator + description.getName()), (String)ExampleSelectionPage.this.projectSet.getName(), (String)name);
                            if (!this.updateStatus()) break;
                        }
                    }
                }
            }
        };
        this.setControl((Control)this.composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, String.valueOf(ExIdtUiExamplesActivator.getPluginId()) + HELP_CONTEXT_ID);
    }

    public void dispose() {
        this.composite.dispose();
        this.getControl().dispose();
        super.dispose();
    }

    public ProjectSet getProjects() {
        return this.projectSet;
    }

    public String getName() {
        return this.name;
    }

    protected abstract IStatus validate();

    public Object getPathToValidate() {
        return this.pathToValidate;
    }
}

