/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.operations;

import com.nxp.s32ds.ext.ide.core.refactoring.RenameRefactorService;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import com.nxp.s32ds.ext.ide.ui.operations.AbstractOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class ImportExampleOperation
extends AbstractOperation {
    private static final String PROCESSOR_EXPERT_FILE = "ProcessorExpert.pe";
    private static final String JOB_TITLE = "Open Processor Expert file";

    public ImportExampleOperation(String name, ProjectSet projects) {
        super(name, projects, RenameRefactorService.getImportRefactoringParticipants());
    }

    @Override
    protected void postExecuteStep(final IProject project) {
        UIJob openPeFile = new UIJob(JOB_TITLE){

            public IStatus runInUIThread(IProgressMonitor ipm) {
                IFile file = project.getFile(ImportExampleOperation.PROCESSOR_EXPERT_FILE);
                if (file != null && file.exists()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                    }
                    catch (PartInitException e) {
                        ExIdtUiExamplesActivator.log(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        openPeFile.schedule();
    }
}

