/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.preferences;

import com.nxp.s32ds.ext.rcp.license.LicenseActivator;
import com.nxp.s32ds.ext.rcp.license.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LicensePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showWarningButton;
    private Button useDefaultLicenseWarningDelayButton;
    private Button useCustomWarningDelayButton;
    private Label daysLabel;
    private Text customWarningDelayText;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.workbench_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createButtons(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    protected void createButtons(Composite composite) {
        this.showWarningButton = new Button(composite, 32);
        this.showWarningButton.setText(Messages.getString("LicensePreferencePage_1", null));
        this.showWarningButton.setSelection(LicenseActivator.getDefault().getPreferenceStore().getBoolean("booleanDisplayWarningWindow"));
        this.showWarningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.setDisplayWarning(LicensePreferencePage.this.showWarningButton.getSelection());
            }
        });
        this.useDefaultLicenseWarningDelayButton = LicensePreferencePage.createRadioButton(composite, Messages.getString("LicensePreferencePage_2", null));
        this.useDefaultLicenseWarningDelayButton.setSelection(LicenseActivator.getDefault().getPreferenceStore().getString("choiceDelayType").equals("licenceDefault"));
        this.useDefaultLicenseWarningDelayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.setDefaultLicenseWarningDelay(LicensePreferencePage.this.useDefaultLicenseWarningDelayButton.getSelection());
            }
        });
        GridData data = new GridData();
        data.horizontalIndent = 20;
        this.useDefaultLicenseWarningDelayButton.setLayoutData((Object)data);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        child.setLayout((Layout)layout);
        child.setLayoutData((Object)new GridData(272));
        data = new GridData();
        data.horizontalIndent = 20;
        child.setLayoutData((Object)data);
        this.useCustomWarningDelayButton = LicensePreferencePage.createRadioButton(child, Messages.getString("LicensePreferencePage_3", null));
        this.useCustomWarningDelayButton.setSelection(LicenseActivator.getDefault().getPreferenceStore().getString("choiceDelayType").equals("custom"));
        this.useCustomWarningDelayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.setCustomWarningDelay(LicensePreferencePage.this.useCustomWarningDelayButton.getSelection());
            }
        });
        this.customWarningDelayText = new Text(child, 16779268);
        this.customWarningDelayText.setText(Integer.toString(LicenseActivator.getDefault().getPreferenceStore().getInt("intNumberOfDays")));
        this.customWarningDelayText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(i))) {
                        e.doit = false;
                        break;
                    }
                    ++i;
                }
            }
        });
        data = new GridData();
        data.widthHint = 15;
        this.customWarningDelayText.setLayoutData((Object)data);
        this.daysLabel = new Label(child, 4);
        this.daysLabel.setText(Messages.getString("LicensePreferencePage_4", null));
        this.arrangeEnabledStates();
    }

    void arrangeEnabledStates() {
        boolean showWarning = this.showWarningButton.getSelection();
        this.useDefaultLicenseWarningDelayButton.setEnabled(showWarning);
        this.useCustomWarningDelayButton.setEnabled(showWarning);
        boolean customSelected = this.useCustomWarningDelayButton.getSelection();
        this.customWarningDelayText.setEnabled(showWarning && customSelected);
        this.daysLabel.setEnabled(showWarning);
    }

    void setCustomWarningDelay(boolean value) {
        this.useDefaultLicenseWarningDelayButton.setSelection(!value);
        this.arrangeEnabledStates();
    }

    void setDefaultLicenseWarningDelay(boolean value) {
        this.useCustomWarningDelayButton.setSelection(!value);
        this.arrangeEnabledStates();
    }

    void setDisplayWarning(boolean value) {
        this.arrangeEnabledStates();
    }

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LicenseActivator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench aWorkbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.showWarningButton.setSelection(store.getDefaultBoolean("booleanDisplayWarningWindow"));
        this.useDefaultLicenseWarningDelayButton.setSelection(store.getDefaultString("choiceDelayType").equals("licenceDefault"));
        this.useCustomWarningDelayButton.setSelection(store.getDefaultString("choiceDelayType").equals("custom"));
        this.customWarningDelayText.setText(Integer.toString(store.getDefaultInt("intNumberOfDays")));
        this.arrangeEnabledStates();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("booleanDisplayWarningWindow", this.showWarningButton.getSelection());
        if (this.useDefaultLicenseWarningDelayButton.getSelection()) {
            store.setValue("choiceDelayType", "licenceDefault");
        } else {
            store.setValue("choiceDelayType", "custom");
        }
        store.setValue("intNumberOfDays", Integer.parseInt(this.customWarningDelayText.getText()));
        return true;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }
}

