/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.runtime;

import com.nxp.s32ds.ext.rcp.runtime.IStatusHandler;
import com.nxp.s32ds.ext.rcp.runtime.IStatusHandlerDescriptor;
import com.nxp.s32ds.ext.rcp.runtime.IStatusHandlerService;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.log.LogService;

@Component
public class StatusHandlerService
implements IStatusHandlerService {
    private LogService logService;
    private Map<QualifiedName, IStatusHandlerDescriptor> handlers = new HashMap<QualifiedName, IStatusHandlerDescriptor>();

    @Override
    public void registerStatusHandler(IStatusHandlerDescriptor descriptor) throws CoreException {
        if (descriptor == null) {
            String message = "Unable to register null as IStatusHandlerDescriptor";
            IStatus error = Log.toErrorStatus(message);
            throw new CoreException(error);
        }
        String plugin = descriptor.getPlugin();
        String code = descriptor.getCode();
        if (code == null || code.isEmpty()) {
            String message = String.format("Unable to register IStatusHandlerDescriptor %s with invalid code %s", descriptor, code);
            IStatus error = Log.toErrorStatus(message);
            throw new CoreException(error);
        }
        QualifiedName qualifiedName = this.composeKey(plugin, code);
        this.handlers.put(qualifiedName, descriptor);
    }

    @Override
    public IStatusHandler getStatusHandler(IStatus status) {
        int code;
        if (status == null) {
            return null;
        }
        String id = status.getPlugin();
        QualifiedName qualifiedName = this.composeKey(id, String.valueOf(code = status.getCode()));
        IStatusHandlerDescriptor descriptor = this.handlers.get(qualifiedName);
        if (descriptor == null) {
            return null;
        }
        try {
            IStatusHandler executable = descriptor.createExecutable();
            if (executable != null) {
                return executable;
            }
            String pattern = "Registered descriptor %s failed to obtain required instance of %s.";
            String message = String.format(pattern, descriptor, IStatusHandler.class);
            this.logError(message, null);
        }
        catch (CoreException e) {
            IStatus error = e.getStatus();
            this.logError(error.getMessage(), error.getException());
        }
        return null;
    }

    private QualifiedName composeKey(String id, String code) {
        String qualifier = id;
        String localName = code;
        QualifiedName qualifiedName = new QualifiedName(qualifier, localName);
        return qualifiedName;
    }

    public void bindLogService(LogService logService) {
        this.logService = logService;
    }

    public void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }

    private void logError(String message, Throwable throwable) {
        if (this.logService == null) {
            return;
        }
        this.logService.log(1, message, throwable);
    }
}

