/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime;

import com.nxp.s32ds.ext.rcp.internal.runtime.CoreRuntimeMessages;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public final class Extensions {
    private static final String E_EXTENSION_POINT_NOT_FOUND = CoreRuntimeMessages.Extensions_e_extension_point_not_found;
    private static final String E_IMPLEMENTATION_NOT_FOUND = CoreRuntimeMessages.Extensions_e_implementation_not_found;

    private Extensions() {
    }

    public static <T> T getImplementation(String namespace, String extensionPointName, String propertyName, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        Assert.isNotNull((Object)propertyName, (String)"propertyName");
        Assert.isNotNull((Object)attributeName, (String)"attributeName");
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        List<T> result = Extensions.getExecutableExtensions(namespace, extensionPointName, propertyName, attributeName, extensionClass);
        if (result.size() == 0) {
            String error = String.format(E_IMPLEMENTATION_NOT_FOUND, extensionClass.getName());
            Log.logError(error);
            return null;
        }
        return result.get(0);
    }

    public static <T> List<T> getExecutableExtensions(String namespace, String extensionPointName, String propertyName, String attributeName, Class<T> extensionClass) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        Assert.isNotNull((Object)propertyName, (String)"propertyName");
        Assert.isNotNull((Object)attributeName, (String)"attributeName");
        Assert.isNotNull(extensionClass, (String)"extensionClass");
        ArrayList result = new ArrayList();
        List<IConfigurationElement> elements = Extensions.getConfigrationElements(namespace, extensionPointName);
        for (IConfigurationElement element : elements) {
            Extensions.readElement(element, propertyName, attributeName, extensionClass, result);
        }
        return result;
    }

    public static List<IConfigurationElement> getConfigrationElements(String namespace, String extensionPointName) {
        Assert.isNotNull((Object)namespace, (String)"namespace");
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(namespace, extensionPointName);
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        if (ep == null) {
            String message = String.format(E_EXTENSION_POINT_NOT_FOUND, namespace, extensionPointName);
            Log.logError(message);
            return result;
        }
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return result;
        }
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length != 0) {
                result.addAll(Arrays.asList(elements));
            }
            ++i;
        }
        return result;
    }

    private static <T> void readElement(IConfigurationElement element, String propertyName, String attributeName, Class<T> extensionClass, List<T> result) {
        if (propertyName.equals(element.getName())) {
            Extensions.createExtension(element, attributeName, extensionClass, result);
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            Extensions.readElement(children[i], propertyName, attributeName, extensionClass, result);
            ++i;
        }
    }

    private static <T> void createExtension(IConfigurationElement element, String attributeName, Class<T> extensionClass, List<T> result) {
        try {
            Object extensionInstance = element.createExecutableExtension(attributeName);
            if (extensionClass.isAssignableFrom(extensionInstance.getClass())) {
                result.add(extensionInstance);
            }
        }
        catch (CoreException ex) {
            Log.log(ex.getStatus());
        }
    }
}

