/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.handler;

import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataFactory;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DebuggerHandler
extends DefaultParameterHandler {
    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        if (!"debugger".equals(tag)) {
            return null;
        }
        HashSet<String> debuggerWizardIds = new HashSet<String>();
        Map<String, String> debuggerMap = this.createDebuggerMap((CProjectMasterContext)context);
        for (String debuggerPluginId : debuggerMap.keySet()) {
            Bundle bundle = Platform.getBundle((String)debuggerPluginId);
            if (bundle == null) continue;
            debuggerWizardIds.add(debuggerMap.get(debuggerPluginId));
        }
        DataSet dataSet = context.getDataSet("debugger");
        ArrayList elements = new ArrayList(dataSet.getElements());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            ConfigurationData c = (ConfigurationData)it.next();
            if (debuggerWizardIds.contains(c.getId())) continue;
            it.remove();
        }
        DataSet newDataSet = DataFactory.createDataSetFrom((DataSet)dataSet, elements);
        ContextChange change = new ContextChange(context, "debugger");
        change.addDataSet(newDataSet);
        ConfigurationData defaultElement = newDataSet.getDefaultElement();
        if (defaultElement != null) {
            change.addValue("debugger", (Object)defaultElement.getId());
        }
        return new ChangeResult(Arrays.asList(change));
    }

    protected Map<String, String> createDebuggerMap(CProjectMasterContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.pemicro.debug.gdbjtag.pne", "pne");
        map.put("ilg.gnuarmeclipse.debug.gdbjtag", "segger");
        map.put("org.eclipse.cdt.debug.gdbjtag", "vdk");
        return map;
    }
}

