/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LocationArea {
    private static final String BROWSE_LABEL = Messages.LocationArea_browse;
    private static final String KEY_PATH = "loc_path";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String FILE_SCHEME = "file";
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;
    private Button useDefaultsButton;
    private IProject existingProject;
    private final S32DSMultiPageOne wizardPage;
    private String projectName = "";
    private String userPath = "";
    private boolean follow = false;

    public LocationArea(Composite composite, S32DSMultiPageOne page) {
        this.createContents(composite, true);
        this.wizardPage = page;
    }

    public void setExistingProject(IProject existingProject) {
        this.projectName = existingProject.getName();
        this.existingProject = existingProject;
    }

    private void createContents(Composite composite, boolean defaultEnabled) {
        Composite projectGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(Messages.LocationArea_Use_default_loc);
        this.useDefaultsButton.setSelection(defaultEnabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 4;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserEntryArea(projectGroup, defaultEnabled);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = LocationArea.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    LocationArea.this.userPath = LocationArea.this.locationPathField.getText();
                    LocationArea.this.locationPathField.setText(TextProcessor.process((String)LocationArea.this.getDefaultPathDisplayString()));
                } else {
                    LocationArea.this.locationPathField.setText(TextProcessor.process((String)LocationArea.this.userPath));
                }
                LocationArea.this.setUserAreaEnabled(!useDefaults);
            }
        });
        this.setUserAreaEnabled(!defaultEnabled);
    }

    public boolean isDefault() {
        return this.useDefaultsButton.getSelection();
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(Messages.LocationArea_location);
        this.locationPathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocationArea.this.handleLocationBrowseButtonPressed();
            }
        });
        if (defaultEnabled) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        } else if (this.existingProject == null) {
            this.locationPathField.setText("");
        } else {
            this.locationPathField.setText(TextProcessor.process((String)this.existingProject.getLocation().toOSString()));
        }
        this.locationPathField.addModifyListener(e -> this.wizardPage.getContext().setBaseProjectPath(this.locationPathField.getText()));
    }

    private String getDefaultPathDisplayString() {
        URI defaultURI = null;
        if (this.existingProject != null) {
            defaultURI = this.existingProject.getLocationURI();
        }
        if (defaultURI == null || defaultURI.getScheme().equals(FILE_SCHEME)) {
            return Platform.getLocation().append(this.projectName).toOSString();
        }
        return defaultURI.toString();
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationPathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public static IFileInfo getFileInfo(String s) {
        Path location = new Path(s);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        try {
            URI uri = file != null ? file.getLocationURI() : location.toFile().toURI();
            IFileStore store = EFS.getStore((URI)uri);
            if (store != null) {
                return store.fetchInfo();
            }
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
        return null;
    }

    private void handleLocationBrowseButtonPressed() {
        String dirName = this.getPathFromLocationField();
        if (!dirName.isEmpty()) {
            IFileInfo info = LocationArea.getFileInfo(dirName);
            if (info == null || !info.exists()) {
                dirName = "";
            }
        } else {
            dirName = LocationArea.loadSettings(KEY_PATH);
        }
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell(), 0x10000000);
        dialog.setMessage(Messages.LocationArea_select_dir);
        dialog.setFilterPath(dirName);
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            String text = this.projectName.isEmpty() ? String.valueOf(selectedDirectory) + File.separator : new Path(selectedDirectory).append(this.projectName).toOSString();
            this.locationPathField.setText(TextProcessor.process((String)text));
            this.follow = true;
            LocationArea.saveSettings(KEY_PATH, selectedDirectory);
        }
    }

    private String getPathFromLocationField() {
        String path = URIUtil.toURI((String)this.locationPathField.getText(), (boolean)true).getPath();
        return path != null ? path : this.locationPathField.getText();
    }

    public URI getProjectLocationURI() {
        return URIUtil.toURI((String)this.locationPathField.getText(), (boolean)true);
    }

    public void updateProjectName(String newName) {
        this.projectName = newName;
        if (this.isDefault()) {
            String str = this.getDefaultPathDisplayString();
            String strProcessed = TextProcessor.process((String)str);
            this.locationPathField.setText(strProcessed);
        } else if (newName != null && this.follow) {
            String s = this.locationPathField.getText();
            if (s.contains(File.separator)) {
                s = s.substring(0, s.lastIndexOf(File.separator));
            }
            this.locationPathField.setText(String.valueOf(s) + File.separator + newName);
            this.follow = true;
        }
    }

    public String getProjectLocation() {
        return this.isDefault() ? Platform.getLocation().toOSString() : this.locationPathField.getText();
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    private static void saveSettings(String key, String path) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.wizard");
        prefs.put(key, path);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static String loadSettings(String key) {
        return InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.wizard").get(key, "");
    }
}

