/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cdt.core.OSFamily;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableFactory {
    public static Table createTable(Composite parent, final List<String> columnKeys, int rowsNumber, int fullWidth, int rowHeight) {
        final Table table = new Table(parent, 2052);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = fullWidth;
        gd.widthHint = fullWidth;
        gd.minimumHeight = rowsNumber * rowHeight;
        gd.heightHint = -1;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 10;
        table.setLayoutData((Object)gd);
        table.setSortDirection(128);
        table.setLinesVisible(true);
        table.getHorizontalBar().setEnabled(true);
        Iterator<String> iterator = columnKeys.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            new TableColumn(table, 0);
        }
        TableFactory.setColumnsSize(table, columnKeys);
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TableFactory.setColumnsSize(table, columnKeys);
            }
        });
        table.pack();
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control[] cs;
                Control[] controlArray = cs = table.getChildren();
                int n = cs.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (!c.isDisposed()) {
                        c.dispose();
                    }
                    ++n2;
                }
            }
        });
        TableFactory.setTableItemHeight(table, rowHeight);
        return table;
    }

    private static void setColumnsSize(Table table, List<String> columnKeys) {
        int dataColumns = columnKeys.size() - 1;
        int width = table.getClientArea().width;
        int firstWidth = columnKeys.size() == 2 ? width / 3 : width / columnKeys.size();
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn c = table.getColumn(i);
            if (i == 0) {
                c.setWidth(firstWidth);
            } else {
                int columnWidth = (width - firstWidth) / dataColumns;
                if (columnWidth < 150) {
                    columnWidth = 150;
                }
                c.setWidth(columnWidth);
            }
            ++i;
        }
    }

    public static void setTableItemHeight(Table table, int height) {
        if (OSFamily.WINDOWS.isCurrent()) {
            try {
                Method setItemHeightMethod = table.getClass().getDeclaredMethod("setItemHeight", Integer.TYPE);
                setItemHeightMethod.setAccessible(true);
                setItemHeightMethod.invoke((Object)table, height);
            }
            catch (Exception e) {
                S32DSWizardPlugin.log(e);
            }
        }
    }
}

