/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.collateral.core.internal;

import com.nxp.s32ds.ext.rcp.collateral.CollateralFactory;
import com.nxp.s32ds.ext.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.ext.rcp.collateral.CollateralPack;
import com.nxp.s32ds.ext.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.ext.rcp.collateral.CollateralResource;
import com.nxp.s32ds.ext.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.ext.rcp.collateral.CollateralTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CollatorRegistryCompiler {
    private final CollateralFactory factory = CollateralFactory.INSTANCE;
    private Map<String, Collection<String>> featureIdToResoursesId = new HashMap<String, Collection<String>>();
    private Map<String, String> resourceToResourseTypeId = new HashMap<String, String>();
    private Map<String, Collection<String>> resourceIdToTagsId = new HashMap<String, Collection<String>>();
    private Map<String, CollateralTag> tagIdToTags = new HashMap<String, CollateralTag>();
    private Map<String, CollateralResource> resourcesIdToResource = new HashMap<String, CollateralResource>();
    private Map<String, CollateralResourceType> resourceTypesIdToResourceTypes = new HashMap<String, CollateralResourceType>();
    private Map<String, CollateralFeature> featureIdTofeature = new HashMap<String, CollateralFeature>();
    private Collection<CollateralPack> packs = new ArrayList<CollateralPack>();
    private Map<String, Collection<String>> packIdToFeatureIds = new HashMap<String, Collection<String>>();

    public static CollatorRegistryCompiler getInstance() {
        return CollatorRegistryCompilerHolder.COMPILER;
    }

    public CollateralRegistry compile() {
        CollateralRegistry collateralRegistry = this.factory.createCollateralRegistry();
        for (CollateralTag collateralTag : this.tagIdToTags.values()) {
            collateralRegistry.addTag(collateralTag);
        }
        for (CollateralResourceType resourceType : this.resourceTypesIdToResourceTypes.values()) {
            collateralRegistry.addResourceType(resourceType);
        }
        for (CollateralResource collateralResource : this.resourcesIdToResource.values()) {
            Collection<String> tagsId;
            CollateralResourceType collateralResourceType;
            String resourceId = collateralResource.getId();
            String resourceTypeId = this.resourceToResourseTypeId.get(resourceId);
            if (resourceTypeId != null && !resourceTypeId.isEmpty() && (collateralResourceType = this.resourceTypesIdToResourceTypes.get(resourceTypeId)) != null) {
                collateralRegistry.setCollateralResourceTypeToResource(collateralResourceType, collateralResource);
            }
            if ((tagsId = this.resourceIdToTagsId.get(resourceId)) == null) continue;
            for (String string : tagsId) {
                CollateralTag collateralTag = this.tagIdToTags.get(string);
                if (collateralTag == null) continue;
                collateralRegistry.addCollateralTagToResource(collateralTag, collateralResource);
            }
        }
        for (CollateralFeature collateralFeature : this.featureIdTofeature.values()) {
            String featureId = collateralFeature.getId();
            Collection<String> resources = this.featureIdToResoursesId.get(featureId);
            if (resources == null) continue;
            for (String resourceId : resources) {
                CollateralResource collateralResource = this.resourcesIdToResource.get(resourceId);
                if (collateralResource == null) continue;
                collateralRegistry.addCollateralResourceToFeature(collateralResource, collateralFeature);
            }
        }
        for (CollateralPack collateralPack : this.packs) {
            String packId = collateralPack.getId();
            Collection<String> featureIds = this.packIdToFeatureIds.get(packId);
            if (featureIds == null) continue;
            for (String featureId : featureIds) {
                CollateralFeature collateralFeature = this.featureIdTofeature.get(featureId);
                if (collateralFeature == null) continue;
                collateralRegistry.addCollateralFeatureToPack(collateralFeature, collateralPack);
            }
        }
        for (CollateralPack collateralPack : this.packs) {
            collateralRegistry.addPack(collateralPack);
        }
        return collateralRegistry;
    }

    public Map<String, Collection<String>> getFeatureIdToResoursesId() {
        return this.featureIdToResoursesId;
    }

    public Map<String, String> getResourceToResourseTypeId() {
        return this.resourceToResourseTypeId;
    }

    public Map<String, Collection<String>> getResourceIdToTagId() {
        return this.resourceIdToTagsId;
    }

    public Map<String, CollateralTag> getTags() {
        return this.tagIdToTags;
    }

    public Map<String, CollateralResource> getResources() {
        return this.resourcesIdToResource;
    }

    public Map<String, CollateralResourceType> getResourceTypesIdToResourceTypes() {
        return this.resourceTypesIdToResourceTypes;
    }

    public Map<String, CollateralFeature> getFeatures() {
        return this.featureIdTofeature;
    }

    public Collection<CollateralPack> getPacks() {
        return this.packs;
    }

    public Map<String, Collection<String>> getPackIdToFeatureIds() {
        return this.packIdToFeatureIds;
    }

    private static class CollatorRegistryCompilerHolder {
        private static final CollatorRegistryCompiler COMPILER = new CollatorRegistryCompiler();

        private CollatorRegistryCompilerHolder() {
        }
    }
}

