/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class ProcessorData
extends ObjectData {
    private final ContextPart processorPart;

    public ProcessorData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
        Set<Parameter> refs = this.getParameters();
        this.processorPart = new ContextPart(refs, this.getContextPositionType());
    }

    public List<CoreNatureData> getCoreNatures(boolean executable) {
        return executable ? this.getCores() : this.getCoreTypes();
    }

    public List<CoreData> getCores() {
        return this.getElements("core");
    }

    public List<CoreTypeData> getCoreTypes() {
        return this.getElements("coreType");
    }

    public FamilyData getFamily() {
        return (FamilyData)this.getElement("family");
    }

    @Override
    public Set<Parameter> getParameters() {
        Set<Parameter> result = super.getParameters();
        result.addAll(this.getFamily().getParameters());
        return result;
    }

    public ContextPart getProcessorPart() {
        return this.processorPart;
    }
}

