/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.registry;

import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.PositionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContextPart {
    private final Map<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
    private final List<ParameterType> parameterTypes = new ArrayList<ParameterType>();
    private final PositionType positionType;

    public ContextPart() {
        this(Collections.EMPTY_LIST);
    }

    public ContextPart(Collection<Parameter> ws) {
        this(ws, PositionType.CENTER);
    }

    public ContextPart(Collection<Parameter> ws, PositionType positionType) {
        this.positionType = positionType;
        for (Parameter w : ws) {
            this.parameterTypes.add(w.getType());
            this.parameterMap.put(w.getType().getTag(), w);
        }
    }

    public PositionType getPositionType() {
        return this.positionType;
    }

    public List<ParameterType> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    public Parameter getParameter(String tag) {
        return this.parameterMap.get(tag);
    }

    public Collection<Parameter> getParameters() {
        return this.parameterMap.values();
    }

    public IParameterHandler getParameterHandler(String tag) {
        Parameter ref = this.getParameter(tag);
        return ref != null ? ref.getHandler() : null;
    }
}

