/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildCommand;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class ExternalTool {
    protected static final String WHITESPACE = " ";
    protected static final String EMPTY = "";

    protected static Map<IProject, List<IFile>> arrangeFilesByProject(List<IFile> files) {
        return files.stream().collect(Collectors.groupingBy(IResource::getProject, Collectors.toList()));
    }

    protected void openFileInEditor(File redirectionFile) {
        Display.getDefault().asyncExec(() -> {
            String editorId = ExternalTool.getEditorId((IPath)new Path(redirectionFile.toString()));
            IFile[] tmpIFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((String)redirectionFile.toString()));
            FileEditorInput fileEditorInput = new FileEditorInput(tmpIFiles[0]);
            try {
                EclipseUtils.getActivePage().openEditor((IEditorInput)fileEditorInput, editorId);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        });
    }

    protected void openFileInExternalEditor(File redirectionFile) {
        Display.getDefault().syncExec(() -> {
            IWorkbenchPage page = EclipseUtils.getActivePage();
            EditorSelectionDialog dialog = new EditorSelectionDialog(EclipseUtils.getShell());
            Path pathToRedirectionFile = new Path(redirectionFile.toString());
            IContentType contentType = ExternalTool.getContentType((IPath)pathToRedirectionFile);
            dialog.setEditorsToFilter(ExternalTool.getEditorsToFilter((IPath)pathToRedirectionFile, contentType));
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                IEditorDescriptor editorDescriptor = dialog.getSelectedEditor();
                IFile[] tmpIFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((String)redirectionFile.toString()));
                FileEditorInput fileEditorInput = new FileEditorInput(tmpIFiles[0]);
                try {
                    if (editorDescriptor.isInternal()) {
                        page.openEditor((IEditorInput)fileEditorInput, editorDescriptor.getId());
                    } else {
                        ((WorkbenchPage)page).openEditorFromDescriptor((IEditorInput)fileEditorInput, editorDescriptor, true, null);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }
        });
    }

    private static String getEditorId(IPath path) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(path.lastSegment(), ExternalTool.getContentType(path));
        return descriptor == null ? "org.eclipse.ui.systemExternalEditor" : descriptor.getId();
    }

    private static IContentType getContentType(IPath path) {
        if (path == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream stream = new FileInputStream(path.toFile());){
                return Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, path.lastSegment());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.log(e);
            return null;
        }
    }

    private static IEditorDescriptor[] getEditorsToFilter(IPath path, IContentType contentType) {
        IEditorRegistry registry = ExternalTool.getEditorRegistry();
        List<IEditorDescriptor> matchingEditors = Arrays.asList(registry.getEditors(path.lastSegment(), contentType));
        return (IEditorDescriptor[])Stream.of(registry.getFileEditorMappings()).map(IFileEditorMapping::getEditors).flatMap(iEditorDescriptorArray -> Stream.of(iEditorDescriptorArray)).filter(editor -> !matchingEditors.contains(editor)).toArray(IEditorDescriptor[]::new);
    }

    private static IEditorRegistry getEditorRegistry() {
        return PlatformUI.getWorkbench().getEditorRegistry();
    }

    protected static Map<String, String> calculateEnvironment(IConfiguration configuration) {
        return Stream.of(ManagedBuildManager.getEnvironmentVariableProvider().getVariables((Object)configuration, true, true)).collect(Collectors.toMap(IBuildEnvironmentVariable::getName, IBuildEnvironmentVariable::getValue));
    }

    protected static IBuildCommand createCommandFromString(String cmd, IPath cwd, Map<String, String> env) {
        char[] arr = cmd.toCharArray();
        char expect = '\u0000';
        char prev = '\u0000';
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            char ch = arr[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (expect == ch) {
                        expect = '\u0000';
                        break;
                    }
                    if (expect == '\u0000') {
                        expect = ch;
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case ' ': {
                    if (expect == '\u0000') {
                        if (prev == ' ') break;
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            prev = ch;
            ++i;
        }
        if (buf.length() > 0) {
            list.add(buf.toString());
        }
        Path c = new Path((String)list.remove(0));
        String[] args = list.toArray(new String[list.size()]);
        return new BuildCommand((IPath)c, args, env, cwd, null);
    }

    protected static String[] mapToStringArray(Map<String, String> map) {
        return map == null ? null : (String[])map.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + '=' + (String)e.getValue()).toArray(String[]::new);
    }

    protected static String[] concat(String[] ... arrays) {
        return (String[])Stream.of(arrays).flatMap(stringArray -> Stream.of(stringArray)).toArray(String[]::new);
    }

    protected static String getOutputFileName(IPath pathToInputFile, ITool tool) {
        return String.valueOf(ExternalTool.getInputFileName(pathToInputFile)) + ExternalTool.getOutputFileExtension(tool);
    }

    protected static String getInputFileName(IPath pathToInputFile) {
        IPath pathToInputFileWithoutExtension = pathToInputFile.removeFileExtension();
        String inputFileNameWithoutExtension = pathToInputFileWithoutExtension.makeRelativeTo(pathToInputFileWithoutExtension.removeLastSegments(1)).toString();
        return inputFileNameWithoutExtension;
    }

    private static <T> boolean notEmpty(T[] array) {
        return array != null && array.length > 0;
    }

    protected static String getOutputFileExtension(ITool tool) {
        String[] extensions;
        IOutputType[] outputTypes;
        String extension = "txt";
        IOutputType outputType = tool.getPrimaryOutputType();
        if (outputType != null && ExternalTool.notEmpty(outputType.getOutputExtensionsAttribute())) {
            extension = outputType.getOutputExtensionsAttribute()[0];
        }
        if (outputType == null && ExternalTool.notEmpty(outputTypes = tool.getOutputTypes()) && ExternalTool.notEmpty(outputTypes[0].getOutputExtensionsAttribute())) {
            extension = outputTypes[0].getOutputExtensionsAttribute()[0];
        }
        if (outputType == null && ExternalTool.notEmpty(extensions = tool.getAllOutputExtensions())) {
            extension = extensions[0];
        }
        return extension;
    }
}

