/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cross.core.tools.Messages;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.resources.IdeValidators;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RenameDialog
extends Dialog {
    private static final Image X = JFaceResources.getImage((String)"dialog_message_error_image");
    private static final int TEXT_SIZE = 300;
    private static final int ICON_SIZE = 16;
    private Shell shell;
    private Text text;
    private Button okButton;
    private Label icon;
    private Label error;
    private final ProjectSet projects;
    private String result;
    private int returnCode;
    private final CompositeValidator compositeNameValidator = new CompositeValidator(IdeValidators.getNameValidators());
    private final CompositeValidator compositePathValidator = new CompositeValidator(IdeValidators.getPathValidators());

    public RenameDialog(Shell sh, ProjectSet projects) {
        super(sh);
        this.projects = Objects.requireNonNull(projects);
        this.result = projects.getName();
    }

    public int open() {
        Shell parent = this.getParentShell();
        this.shell = this.createShell();
        this.shell.setText(Messages.RenameDialog_title);
        this.shell.setParent((Composite)parent);
        this.createContents((Composite)this.shell);
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = this.shell.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + (r1.height - r2.height) / 2;
        this.shell.setBounds(x, y, r2.width, r2.height);
        this.result = null;
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnCode;
    }

    public String getResult() {
        return this.result;
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.shell.addListener(31, this.closeDialogWhithoutResult(2));
        this.shell.addListener(21, this.closeDialogWhithoutResult(0));
        Label label = new Label(parent, 0);
        label.setText(Messages.RenameDialog_new_name);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.text = new Text(parent, 2052);
        this.text.setText(this.result);
        this.text.setSelection(0, this.result.length());
        this.text.addModifyListener(e -> this.validate());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1).minSize(300, -1).applyTo((Control)this.text);
        new Composite(parent, 0){
            {
                this.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
                this.setLayout((Layout)new GridLayout(2, false));
                RenameDialog.this.icon = new Label((Composite)this, 0);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(16, -1).minSize(16, -1).applyTo((Control)RenameDialog.this.icon);
                RenameDialog.this.error = new Label((Composite)this, 64);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1).minSize(300, -1).applyTo((Control)RenameDialog.this.error);
            }
        };
        new Composite(parent, 0){
            {
                this.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
                this.setLayout((Layout)new GridLayout(3, true));
                RenameDialog.this.setupButton(this, null, 0, null);
                RenameDialog.this.okButton = RenameDialog.this.setupButton(this, IDialogConstants.OK_LABEL, 0, ".RENAME_OK_context");
                RenameDialog.this.setupButton(this, IDialogConstants.CANCEL_LABEL, 1, ".RENAME_CANCEL_context");
                RenameDialog.this.okButton.setEnabled(false);
            }
        };
        this.shell.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.text, "com.freescale.s32ds.cross.core.RENAME_context");
        return parent;
    }

    protected Button setupButton(Composite c, String txt, final int id, String context) {
        if (txt == null) {
            new Label(c, 0).setLayoutData((Object)new GridData(4, 2, false, false));
            return null;
        }
        Button b = new Button(c, 8);
        if (id == 0) {
            c.getShell().setDefaultButton(b);
        }
        b.setText(txt);
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RenameDialog.this.returnCode = id;
                RenameDialog.this.result = id == 0 ? RenameDialog.this.text.getText().trim() : null;
                RenameDialog.this.shell.dispose();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)b, "com.freescale.s32ds.cross.core" + context);
        return b;
    }

    private void validate() {
        String name = this.text.getText().trim();
        IStatus status = this.compositeNameValidator.validate((Object)name);
        if (status.isOK()) {
            String strPath = String.valueOf(this.projects.getRoot().toOSString()) + File.separator + name;
            status = this.compositePathValidator.validate((Object)strPath);
        }
        this.setError(status.isOK() ? null : status.getMessage());
        this.shell.pack();
    }

    private void setError(String s) {
        this.error.setText(s == null ? "" : s);
        this.icon.setImage(s == null ? null : X);
        if (this.okButton != null) {
            this.okButton.setEnabled(s == null);
        }
    }

    private Listener closeDialogWhithoutResult(int mask) {
        return event -> {
            if (event.detail == mask) {
                this.result = null;
                this.returnCode = 12;
                event.doit = false;
                event.detail = 0;
                this.shell.dispose();
            }
        };
    }
}

