/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core;

import com.nxp.s32ds.ext.rcp.p2.core.LockedFiles;
import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.P2CoreActivator;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class LockedFilesTracker {
    public static final String DS_PREFIX = "s32ds_";
    private static final String LOCKED_FILES_MAP_DIR = "s32ds_locked";
    private static final String LOCKED_FILES_MAP_FILE = "s32ds_locked_map.lck";
    private final Map<String, String> lockedFiles = new HashMap<String, String>();
    private String unzipFolder;

    public static void recopyLockedFiles() {
        for (LockedFiles group : LockedFilesTracker.retrieveLockedFilesMapFiles()) {
            LockedFilesTracker.logWarning(String.valueOf(NLS.bind((String)Messages.LockedFilesTracker_resume_copying, (Object)group.getFiles().size())) + group.getGroupPath().getName());
            LockedFilesTracker.doCopyLockedFiles(group);
        }
    }

    private static List<LockedFiles> retrieveLockedFilesMapFiles() {
        LinkedList<LockedFiles> result = new LinkedList<LockedFiles>();
        File root = LockedFilesTracker.getLockedFilesStorage();
        String[] children = root.list();
        if (children == null || children.length == 0) {
            return result;
        }
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File lockedMap;
            String child = stringArray[n2];
            File childFile = new File(root, child);
            if (childFile.isDirectory() && (lockedMap = new File(childFile, LOCKED_FILES_MAP_FILE)).exists()) {
                try {
                    result.add(LockedFiles.create(childFile, lockedMap));
                }
                catch (IOException e) {
                    LockedFilesTracker.logError(NLS.bind((String)Messages.LockedFilesTracker_cannot_find_locked_file_map, (Object)lockedMap), e);
                }
            }
            ++n2;
        }
        return result;
    }

    private static void doCopyLockedFiles(LockedFiles lockedFiles) {
        try {
            for (Map.Entry<String, String> entry : new HashMap<String, String>(lockedFiles.getFiles()).entrySet()) {
                String relPath = entry.getKey();
                String dstAbsPath = entry.getValue();
                File srcFile = new File(lockedFiles.getGroupPath(), relPath);
                if (!srcFile.exists()) {
                    LockedFilesTracker.logError(NLS.bind((String)Messages.LockedFilesTracker_invalid_file_path, (Object)srcFile), null);
                    continue;
                }
                LockedFilesTracker.logWarning(NLS.bind((String)Messages.LockedFilesTracker_copying_to, (Object)srcFile, (Object)dstAbsPath));
                File destFile = new File(dstAbsPath);
                if (destFile.exists() && !destFile.delete()) {
                    LockedFilesTracker.logError(NLS.bind((String)Messages.LockedFilesTracker_cannot_delete_existing_file, (Object)dstAbsPath), null);
                    continue;
                }
                try {
                    destFile.createNewFile();
                }
                catch (IOException e) {
                    LockedFilesTracker.logError(e.getMessage(), e);
                    continue;
                }
                Files.copy(Paths.get(srcFile.getAbsolutePath(), new String[0]), Paths.get(destFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                lockedFiles.getFiles().remove(relPath);
                if (srcFile.delete()) continue;
                LockedFilesTracker.logWarning(NLS.bind((String)Messages.LockedFilesTracker_cannot_delete_source_file, (Object)srcFile));
            }
            if (lockedFiles.getFiles().isEmpty()) {
                LockedFilesTracker.deleteFolder(lockedFiles.getGroupPath());
            }
        }
        catch (IOException e) {
            LockedFilesTracker.logError(Messages.LockedFilesTracker_errors_while_copying_locked_files, e);
            try {
                lockedFiles.store(new FileWriter(new File(lockedFiles.getGroupPath(), LOCKED_FILES_MAP_FILE)));
            }
            catch (IOException iOException) {
                LockedFilesTracker.logError(Messages.LockedFilesTracker_could_not_update_locked_files, e);
            }
        }
    }

    public Map<String, String> getLockedFiles() {
        return this.lockedFiles;
    }

    public void markLocked(String string, String srcFileName) {
        this.lockedFiles.put(string, srcFileName);
    }

    public boolean hasLockedFiles() {
        return !this.lockedFiles.isEmpty();
    }

    public static String getLockedFilesStorage(Map<String, Object> parameters) {
        File result = LockedFilesTracker.getLockedFilesStorage();
        IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
        if (artifactKey != null) {
            result = new File(result, String.valueOf(artifactKey.getId()) + "_" + artifactKey.getVersion());
        } else {
            Util.logError(NLS.bind((String)Messages.LockedFilesTracker_has_no_artifact_key, (Object)((IInstallableUnit)parameters.get("iu")).getId()));
        }
        return result.getAbsolutePath();
    }

    public static File getLockedFilesStorage() {
        return P2CoreActivator.getContext().getBundle().getDataFile(LOCKED_FILES_MAP_DIR);
    }

    private static void log(int level, String message, Throwable exception) {
        BundleContext context = P2CoreActivator.getContext();
        ServiceTracker installLocation = new ServiceTracker(context, ExtendedLogService.class, null);
        installLocation.open();
        ExtendedLogService service = (ExtendedLogService)installLocation.getService();
        service.getLogger("org.eclipse.equinox.logger").log(4, message, exception);
        installLocation.close();
    }

    private static void logError(String message, Throwable t) {
        LockedFilesTracker.log(4, message, t);
    }

    private static void logWarning(String message) {
        LockedFilesTracker.log(2, message, null);
    }

    private static void deleteFolder(File directory) {
        if (directory.isDirectory()) {
            File[] children;
            File[] fileArray = children = directory.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                LockedFilesTracker.deleteFolder(new File(directory, element.getName()));
                ++n2;
            }
            if (!directory.delete()) {
                LockedFilesTracker.logWarning(String.format("Cannot delete %s%n", directory));
            }
        } else if (!directory.delete()) {
            LockedFilesTracker.logWarning(String.format("Cannot delete %s%n", directory));
        }
    }

    public void createLockedFilesMapFile(String destFolder) {
        block15: {
            if (!this.hasLockedFiles()) {
                return;
            }
            if (!LockedFilesTracker.createDestinationFolder(destFolder)) {
                return;
            }
            String destAbsPath = String.valueOf(destFolder) + File.separator + LOCKED_FILES_MAP_FILE;
            FileOutputStream fos = null;
            try {
                try {
                    File lf = new File(destAbsPath);
                    if (lf.exists()) {
                        lf.delete();
                    }
                    lf.createNewFile();
                    fos = new FileOutputStream(lf);
                    Properties lockedFilesToBeInstalled = new Properties();
                    lockedFilesToBeInstalled.putAll(this.lockedFiles);
                    lockedFilesToBeInstalled.store(fos, Messages.LockedFilesTracker_locked_liles_map_info);
                }
                catch (IOException ioe) {
                    Util.createErrorMessage(ioe.getMessage());
                    if (fos == null) break block15;
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        Util.logError(e.getMessage());
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        Util.logError(e.getMessage());
                    }
                }
            }
        }
    }

    private static boolean createDestinationFolder(String destFolder) {
        File destFolderFile = new File(destFolder);
        if (!destFolderFile.exists() && !destFolderFile.mkdirs()) {
            Util.logError(Messages.FreescaleInstall_CreateLockedFilesFolderFailure);
            return false;
        }
        return true;
    }

    public boolean copyLockedFiles(String srcFolder, String destFolder) {
        if (!this.hasLockedFiles()) {
            return false;
        }
        if (!LockedFilesTracker.createDestinationFolder(destFolder)) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.lockedFiles.entrySet()) {
            String relPath = entry.getKey();
            String srcAbsPath = String.valueOf(this.unzipFolder) + File.separator + relPath;
            File srcFile = new File(srcAbsPath);
            if (!srcFile.exists()) {
                Util.logError(Messages.FreescaleInstall_InvalidFilePath);
                return false;
            }
            String destAbsPath = String.valueOf(destFolder) + File.separator + relPath;
            File destFile = new File(destAbsPath);
            LockedFilesTracker.createDestinationFolder(destFile.getParent());
            if (destFile.exists()) {
                destFile.delete();
            }
            try {
                destFile.createNewFile();
            }
            catch (IOException iOException) {
                Util.logError(Messages.FreescaleInstall_CreateDestFileFailure);
                return false;
            }
            try {
                Util.copyFile(srcFile, destFile);
            }
            catch (IOException iOException) {
                Util.logError(Messages.FreescaleInstall_CopyLockedFileFailure);
                return false;
            }
        }
        return true;
    }

    public void setUnzipFolder(String unzipFolder) {
        this.unzipFolder = unzipFolder;
    }

    public String getUnzipFolder() {
        return this.unzipFolder;
    }
}

