/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class ProcessCheckRunner {
    private static final String SPACE_SPLITTER = " ";
    private static final String SLASH_SPLITTER = "/";

    public static void main(String[] args) {
        try {
            System.out.format("CCS %s running\n", ProcessCheckRunner.isProcessRunning("ccs", "") ? "is" : "is not");
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    public static boolean getProcessRunning(String process, String installFolder) throws IOException {
        return ProcessCheckRunner.isProcessRunning(process, installFolder);
    }

    private static boolean isProcessRunning(String processName, String installFolder) throws IOException {
        if (Platform.getOS().equals("linux")) {
            return ProcessCheckRunner.isLinuxProcessRunning(processName, installFolder);
        }
        return ProcessCheckRunner.isWindowsProcessRunning(processName, installFolder);
    }

    private static boolean isLinuxProcessRunning(String processName, String installFolder) throws IOException {
        Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ps -e | grep " + processName});
        try (BufferedReader input = null;){
            String line;
            p.getOutputStream().close();
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                String procPath;
                String[] pathSegs;
                String[] tokens = line.split(SPACE_SPLITTER);
                if (tokens.length <= 0 || (pathSegs = (procPath = tokens[tokens.length - 1]).split(SLASH_SPLITTER)).length <= 0 || !pathSegs[pathSegs.length - 1].equalsIgnoreCase(processName)) continue;
                input.close();
                p = Runtime.getRuntime().exec("readlink -f /proc/" + tokens[1] + "/exe");
                input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    if (!line.startsWith(installFolder)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isWindowsProcessRunning(String processName, String installFolder) throws IOException {
        File f;
        if (!processName.toLowerCase().endsWith(".exe")) {
            processName = String.valueOf(processName) + ".exe";
        }
        if (!(f = new File(installFolder).getCanonicalFile()).exists()) {
            return false;
        }
        if (!f.isDirectory()) {
            throw new IOException(NLS.bind((String)Messages.ProcessCheckRunner_invalid_installation_folder_argument, (Object)installFolder));
        }
        installFolder = f.getAbsolutePath();
        Process p = Runtime.getRuntime().exec("wmic process where name='" + processName + "' get ExecutablePath");
        try (BufferedReader input = null;){
            String line;
            p.getOutputStream().close();
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!line.startsWith(installFolder)) continue;
                return true;
            }
        }
        return false;
    }
}

